/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.merger;

public final class Difference {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int CHANGE = 3;
    public static final int UNCHANGE = 4;
    private final int operation;
    private final int orgPosition;
    private final int modPosition;

    public Difference(int operation, int orgPosition, int modPosition) {
        this.operation = operation;
        this.orgPosition = orgPosition;
        this.modPosition = modPosition;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getOrgPosition() {
        return this.orgPosition;
    }

    public int getModPosition() {
        return this.modPosition;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Difference) {
            Difference diff = (Difference)obj;
            if (this.operation == diff.operation && this.orgPosition == diff.orgPosition && this.modPosition == diff.modPosition) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String debug() {
        String opStr = "";
        switch (this.operation) {
            case 1: {
                opStr = "add";
                break;
            }
            case 2: {
                opStr = "del";
                break;
            }
            case 3: {
                opStr = "chg";
                break;
            }
            case 4: {
                opStr = "uch";
                break;
            }
        }
        return "<diff orgPos=" + this.orgPosition + " modPos=" + this.modPosition + " op=" + opStr + ">";
    }

    public String toString() {
        return this.orgPosition + " " + this.modPosition + " " + this.operation;
    }
}

