/* Copyright (C) 2020 Google, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include "util/u_dump.h"
#include "freedreno_batch.h"

#include "freedreno_tracepoints.h"

#define __NEEDS_TRACE_PRIV
#include "util/perf/u_trace_priv.h"

/*
 * start_state_restore
 */
#define __print_start_state_restore NULL
static const struct u_tracepoint __tp_start_state_restore = {
    ALIGN_POT(sizeof(struct trace_start_state_restore), 8),   /* keep size 64b aligned */
    "start_state_restore",
    false,
    __print_start_state_restore,
};
void __trace_start_state_restore(
     struct u_trace *ut, void *cs
) {
   struct trace_start_state_restore *__entry =
      (struct trace_start_state_restore *)u_trace_append(ut, cs, &__tp_start_state_restore);
   (void)__entry;
}

/*
 * end_state_restore
 */
#define __print_end_state_restore NULL
static const struct u_tracepoint __tp_end_state_restore = {
    ALIGN_POT(sizeof(struct trace_end_state_restore), 8),   /* keep size 64b aligned */
    "end_state_restore",
    false,
    __print_end_state_restore,
};
void __trace_end_state_restore(
     struct u_trace *ut, void *cs
) {
   struct trace_end_state_restore *__entry =
      (struct trace_end_state_restore *)u_trace_append(ut, cs, &__tp_end_state_restore);
   (void)__entry;
}

/*
 * flush_batch
 */
static void __print_flush_batch(FILE *out, const void *arg) {
   const struct trace_flush_batch *__entry =
      (const struct trace_flush_batch *)arg;
   fprintf(out, "%p: cleared=%x, gmem_reason=%x, num_draws=%u\n"
           , __entry->batch
           , __entry->cleared
           , __entry->gmem_reason
           , __entry->num_draws
   );
}
static const struct u_tracepoint __tp_flush_batch = {
    ALIGN_POT(sizeof(struct trace_flush_batch), 8),   /* keep size 64b aligned */
    "flush_batch",
    false,
    __print_flush_batch,
};
void __trace_flush_batch(
     struct u_trace *ut, void *cs
   , struct fd_batch * batch
   , uint16_t cleared
   , uint16_t gmem_reason
   , uint16_t num_draws
) {
   struct trace_flush_batch *__entry =
      (struct trace_flush_batch *)u_trace_append(ut, cs, &__tp_flush_batch);
   __entry->batch = batch;
   __entry->cleared = cleared;
   __entry->gmem_reason = gmem_reason;
   __entry->num_draws = num_draws;
}

/*
 * render_gmem
 */
static void __print_render_gmem(FILE *out, const void *arg) {
   const struct trace_render_gmem *__entry =
      (const struct trace_render_gmem *)arg;
   fprintf(out, "%ux%u bins of %ux%u\n"
           , __entry->nbins_x
           , __entry->nbins_y
           , __entry->bin_w
           , __entry->bin_h
   );
}
static const struct u_tracepoint __tp_render_gmem = {
    ALIGN_POT(sizeof(struct trace_render_gmem), 8),   /* keep size 64b aligned */
    "render_gmem",
    false,
    __print_render_gmem,
};
void __trace_render_gmem(
     struct u_trace *ut, void *cs
   , uint16_t nbins_x
   , uint16_t nbins_y
   , uint16_t bin_w
   , uint16_t bin_h
) {
   struct trace_render_gmem *__entry =
      (struct trace_render_gmem *)u_trace_append(ut, cs, &__tp_render_gmem);
   __entry->nbins_x = nbins_x;
   __entry->nbins_y = nbins_y;
   __entry->bin_w = bin_w;
   __entry->bin_h = bin_h;
}

/*
 * render_sysmem
 */
#define __print_render_sysmem NULL
static const struct u_tracepoint __tp_render_sysmem = {
    ALIGN_POT(sizeof(struct trace_render_sysmem), 8),   /* keep size 64b aligned */
    "render_sysmem",
    false,
    __print_render_sysmem,
};
void __trace_render_sysmem(
     struct u_trace *ut, void *cs
) {
   struct trace_render_sysmem *__entry =
      (struct trace_render_sysmem *)u_trace_append(ut, cs, &__tp_render_sysmem);
   (void)__entry;
}

/*
 * start_render_pass
 */
static void __print_start_render_pass(FILE *out, const void *arg) {
   const struct trace_start_render_pass *__entry =
      (const struct trace_start_render_pass *)arg;
   fprintf(out, ""
      "submit_id=%u, "
      "cbuf0_format=%s, "
      "zs_format=%s, "
      "width=%u, "
      "height=%u, "
      "mrts=%u, "
      "samples=%u, "
      "nbins=%u, "
      "binw=%u, "
      "binh=%u, "
         "\n"
   ,__entry->submit_id
   ,util_format_description(__entry->cbuf0_format)->short_name
   ,util_format_description(__entry->zs_format)->short_name
   ,__entry->width
   ,__entry->height
   ,__entry->mrts
   ,__entry->samples
   ,__entry->nbins
   ,__entry->binw
   ,__entry->binh
   );
}
static const struct u_tracepoint __tp_start_render_pass = {
    ALIGN_POT(sizeof(struct trace_start_render_pass), 8),   /* keep size 64b aligned */
    "start_render_pass",
    false,
    __print_start_render_pass,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_render_pass,
#endif
};
void __trace_start_render_pass(
     struct u_trace *ut, void *cs
   , uint32_t submit_id
   , enum pipe_format cbuf0_format
   , enum pipe_format zs_format
   , uint16_t width
   , uint16_t height
   , uint8_t mrts
   , uint8_t samples
   , uint16_t nbins
   , uint16_t binw
   , uint16_t binh
) {
   struct trace_start_render_pass *__entry =
      (struct trace_start_render_pass *)u_trace_append(ut, cs, &__tp_start_render_pass);
   __entry->submit_id = submit_id;
   __entry->cbuf0_format = cbuf0_format;
   __entry->zs_format = zs_format;
   __entry->width = width;
   __entry->height = height;
   __entry->mrts = mrts;
   __entry->samples = samples;
   __entry->nbins = nbins;
   __entry->binw = binw;
   __entry->binh = binh;
}

/*
 * end_render_pass
 */
#define __print_end_render_pass NULL
static const struct u_tracepoint __tp_end_render_pass = {
    ALIGN_POT(sizeof(struct trace_end_render_pass), 8),   /* keep size 64b aligned */
    "end_render_pass",
    false,
    __print_end_render_pass,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_render_pass,
#endif
};
void __trace_end_render_pass(
     struct u_trace *ut, void *cs
) {
   struct trace_end_render_pass *__entry =
      (struct trace_end_render_pass *)u_trace_append(ut, cs, &__tp_end_render_pass);
   (void)__entry;
}

/*
 * start_binning_ib
 */
#define __print_start_binning_ib NULL
static const struct u_tracepoint __tp_start_binning_ib = {
    ALIGN_POT(sizeof(struct trace_start_binning_ib), 8),   /* keep size 64b aligned */
    "start_binning_ib",
    false,
    __print_start_binning_ib,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_binning_ib,
#endif
};
void __trace_start_binning_ib(
     struct u_trace *ut, void *cs
) {
   struct trace_start_binning_ib *__entry =
      (struct trace_start_binning_ib *)u_trace_append(ut, cs, &__tp_start_binning_ib);
   (void)__entry;
}

/*
 * end_binning_ib
 */
#define __print_end_binning_ib NULL
static const struct u_tracepoint __tp_end_binning_ib = {
    ALIGN_POT(sizeof(struct trace_end_binning_ib), 8),   /* keep size 64b aligned */
    "end_binning_ib",
    false,
    __print_end_binning_ib,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_binning_ib,
#endif
};
void __trace_end_binning_ib(
     struct u_trace *ut, void *cs
) {
   struct trace_end_binning_ib *__entry =
      (struct trace_end_binning_ib *)u_trace_append(ut, cs, &__tp_end_binning_ib);
   (void)__entry;
}

/*
 * start_vsc_overflow_test
 */
#define __print_start_vsc_overflow_test NULL
static const struct u_tracepoint __tp_start_vsc_overflow_test = {
    ALIGN_POT(sizeof(struct trace_start_vsc_overflow_test), 8),   /* keep size 64b aligned */
    "start_vsc_overflow_test",
    false,
    __print_start_vsc_overflow_test,
};
void __trace_start_vsc_overflow_test(
     struct u_trace *ut, void *cs
) {
   struct trace_start_vsc_overflow_test *__entry =
      (struct trace_start_vsc_overflow_test *)u_trace_append(ut, cs, &__tp_start_vsc_overflow_test);
   (void)__entry;
}

/*
 * end_vsc_overflow_test
 */
#define __print_end_vsc_overflow_test NULL
static const struct u_tracepoint __tp_end_vsc_overflow_test = {
    ALIGN_POT(sizeof(struct trace_end_vsc_overflow_test), 8),   /* keep size 64b aligned */
    "end_vsc_overflow_test",
    false,
    __print_end_vsc_overflow_test,
};
void __trace_end_vsc_overflow_test(
     struct u_trace *ut, void *cs
) {
   struct trace_end_vsc_overflow_test *__entry =
      (struct trace_end_vsc_overflow_test *)u_trace_append(ut, cs, &__tp_end_vsc_overflow_test);
   (void)__entry;
}

/*
 * start_prologue
 */
#define __print_start_prologue NULL
static const struct u_tracepoint __tp_start_prologue = {
    ALIGN_POT(sizeof(struct trace_start_prologue), 8),   /* keep size 64b aligned */
    "start_prologue",
    false,
    __print_start_prologue,
};
void __trace_start_prologue(
     struct u_trace *ut, void *cs
) {
   struct trace_start_prologue *__entry =
      (struct trace_start_prologue *)u_trace_append(ut, cs, &__tp_start_prologue);
   (void)__entry;
}

/*
 * end_prologue
 */
#define __print_end_prologue NULL
static const struct u_tracepoint __tp_end_prologue = {
    ALIGN_POT(sizeof(struct trace_end_prologue), 8),   /* keep size 64b aligned */
    "end_prologue",
    false,
    __print_end_prologue,
};
void __trace_end_prologue(
     struct u_trace *ut, void *cs
) {
   struct trace_end_prologue *__entry =
      (struct trace_end_prologue *)u_trace_append(ut, cs, &__tp_end_prologue);
   (void)__entry;
}

/*
 * start_clear_restore
 */
static void __print_start_clear_restore(FILE *out, const void *arg) {
   const struct trace_start_clear_restore *__entry =
      (const struct trace_start_clear_restore *)arg;
   fprintf(out, "fast_cleared: 0x%x\n"
           , __entry->fast_cleared
   );
}
static const struct u_tracepoint __tp_start_clear_restore = {
    ALIGN_POT(sizeof(struct trace_start_clear_restore), 8),   /* keep size 64b aligned */
    "start_clear_restore",
    false,
    __print_start_clear_restore,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_clear_restore,
#endif
};
void __trace_start_clear_restore(
     struct u_trace *ut, void *cs
   , uint16_t fast_cleared
) {
   struct trace_start_clear_restore *__entry =
      (struct trace_start_clear_restore *)u_trace_append(ut, cs, &__tp_start_clear_restore);
   __entry->fast_cleared = fast_cleared;
}

/*
 * end_clear_restore
 */
#define __print_end_clear_restore NULL
static const struct u_tracepoint __tp_end_clear_restore = {
    ALIGN_POT(sizeof(struct trace_end_clear_restore), 8),   /* keep size 64b aligned */
    "end_clear_restore",
    false,
    __print_end_clear_restore,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_clear_restore,
#endif
};
void __trace_end_clear_restore(
     struct u_trace *ut, void *cs
) {
   struct trace_end_clear_restore *__entry =
      (struct trace_end_clear_restore *)u_trace_append(ut, cs, &__tp_end_clear_restore);
   (void)__entry;
}

/*
 * start_resolve
 */
#define __print_start_resolve NULL
static const struct u_tracepoint __tp_start_resolve = {
    ALIGN_POT(sizeof(struct trace_start_resolve), 8),   /* keep size 64b aligned */
    "start_resolve",
    false,
    __print_start_resolve,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_resolve,
#endif
};
void __trace_start_resolve(
     struct u_trace *ut, void *cs
) {
   struct trace_start_resolve *__entry =
      (struct trace_start_resolve *)u_trace_append(ut, cs, &__tp_start_resolve);
   (void)__entry;
}

/*
 * end_resolve
 */
#define __print_end_resolve NULL
static const struct u_tracepoint __tp_end_resolve = {
    ALIGN_POT(sizeof(struct trace_end_resolve), 8),   /* keep size 64b aligned */
    "end_resolve",
    false,
    __print_end_resolve,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_resolve,
#endif
};
void __trace_end_resolve(
     struct u_trace *ut, void *cs
) {
   struct trace_end_resolve *__entry =
      (struct trace_end_resolve *)u_trace_append(ut, cs, &__tp_end_resolve);
   (void)__entry;
}

/*
 * start_tile
 */
static void __print_start_tile(FILE *out, const void *arg) {
   const struct trace_start_tile *__entry =
      (const struct trace_start_tile *)arg;
   fprintf(out, "bin_h=%d, yoff=%d, bin_w=%d, xoff=%d\n"
           , __entry->bin_h
           , __entry->yoff
           , __entry->bin_w
           , __entry->xoff
   );
}
static const struct u_tracepoint __tp_start_tile = {
    ALIGN_POT(sizeof(struct trace_start_tile), 8),   /* keep size 64b aligned */
    "start_tile",
    false,
    __print_start_tile,
};
void __trace_start_tile(
     struct u_trace *ut, void *cs
   , uint16_t bin_h
   , uint16_t yoff
   , uint16_t bin_w
   , uint16_t xoff
) {
   struct trace_start_tile *__entry =
      (struct trace_start_tile *)u_trace_append(ut, cs, &__tp_start_tile);
   __entry->bin_h = bin_h;
   __entry->yoff = yoff;
   __entry->bin_w = bin_w;
   __entry->xoff = xoff;
}

/*
 * start_draw_ib
 */
#define __print_start_draw_ib NULL
static const struct u_tracepoint __tp_start_draw_ib = {
    ALIGN_POT(sizeof(struct trace_start_draw_ib), 8),   /* keep size 64b aligned */
    "start_draw_ib",
    false,
    __print_start_draw_ib,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_draw_ib,
#endif
};
void __trace_start_draw_ib(
     struct u_trace *ut, void *cs
) {
   struct trace_start_draw_ib *__entry =
      (struct trace_start_draw_ib *)u_trace_append(ut, cs, &__tp_start_draw_ib);
   (void)__entry;
}

/*
 * end_draw_ib
 */
#define __print_end_draw_ib NULL
static const struct u_tracepoint __tp_end_draw_ib = {
    ALIGN_POT(sizeof(struct trace_end_draw_ib), 8),   /* keep size 64b aligned */
    "end_draw_ib",
    false,
    __print_end_draw_ib,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_draw_ib,
#endif
};
void __trace_end_draw_ib(
     struct u_trace *ut, void *cs
) {
   struct trace_end_draw_ib *__entry =
      (struct trace_end_draw_ib *)u_trace_append(ut, cs, &__tp_end_draw_ib);
   (void)__entry;
}

/*
 * start_blit
 */
static void __print_start_blit(FILE *out, const void *arg) {
   const struct trace_start_blit *__entry =
      (const struct trace_start_blit *)arg;
   fprintf(out, "%s -> %s\n"
           , util_str_tex_target(__entry->src_target, true)
           , util_str_tex_target(__entry->dst_target, true)
   );
}
static const struct u_tracepoint __tp_start_blit = {
    ALIGN_POT(sizeof(struct trace_start_blit), 8),   /* keep size 64b aligned */
    "start_blit",
    false,
    __print_start_blit,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_blit,
#endif
};
void __trace_start_blit(
     struct u_trace *ut, void *cs
   , enum pipe_texture_target src_target
   , enum pipe_texture_target dst_target
) {
   struct trace_start_blit *__entry =
      (struct trace_start_blit *)u_trace_append(ut, cs, &__tp_start_blit);
   __entry->src_target = src_target;
   __entry->dst_target = dst_target;
}

/*
 * end_blit
 */
#define __print_end_blit NULL
static const struct u_tracepoint __tp_end_blit = {
    ALIGN_POT(sizeof(struct trace_end_blit), 8),   /* keep size 64b aligned */
    "end_blit",
    false,
    __print_end_blit,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_blit,
#endif
};
void __trace_end_blit(
     struct u_trace *ut, void *cs
) {
   struct trace_end_blit *__entry =
      (struct trace_end_blit *)u_trace_append(ut, cs, &__tp_end_blit);
   (void)__entry;
}

/*
 * start_compute
 */
#define __print_start_compute NULL
static const struct u_tracepoint __tp_start_compute = {
    ALIGN_POT(sizeof(struct trace_start_compute), 8),   /* keep size 64b aligned */
    "start_compute",
    false,
    __print_start_compute,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_start_compute,
#endif
};
void __trace_start_compute(
     struct u_trace *ut, void *cs
) {
   struct trace_start_compute *__entry =
      (struct trace_start_compute *)u_trace_append(ut, cs, &__tp_start_compute);
   (void)__entry;
}

/*
 * end_compute
 */
#define __print_end_compute NULL
static const struct u_tracepoint __tp_end_compute = {
    ALIGN_POT(sizeof(struct trace_end_compute), 8),   /* keep size 64b aligned */
    "end_compute",
    false,
    __print_end_compute,
#ifdef HAVE_PERFETTO
    (void (*)(void *pctx, uint64_t, const void *, const void *))fd_end_compute,
#endif
};
void __trace_end_compute(
     struct u_trace *ut, void *cs
) {
   struct trace_end_compute *__entry =
      (struct trace_end_compute *)u_trace_append(ut, cs, &__tp_end_compute);
   (void)__entry;
}

