/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "org.freedesktop.NetworkManager.IP6Config.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.NetworkManager.IP6Config
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:NMDBusIP6Config
 * @title: NMDBusIP6Config
 * @short_description: Generated C code for the org.freedesktop.NetworkManager.IP6Config D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.NetworkManager.IP6Config ---- */

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_addresses =
{
  {
    -1,
    (gchar *) "Addresses",
    (gchar *) "a(ayuay)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "addresses",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_address_data =
{
  {
    -1,
    (gchar *) "AddressData",
    (gchar *) "aa{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "address-data",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_gateway =
{
  {
    -1,
    (gchar *) "Gateway",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "gateway",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_routes =
{
  {
    -1,
    (gchar *) "Routes",
    (gchar *) "a(ayuayu)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "routes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_route_data =
{
  {
    -1,
    (gchar *) "RouteData",
    (gchar *) "aa{sv}",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "route-data",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_nameservers =
{
  {
    -1,
    (gchar *) "Nameservers",
    (gchar *) "aay",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "nameservers",
  TRUE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_domains =
{
  {
    -1,
    (gchar *) "Domains",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "domains",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_searches =
{
  {
    -1,
    (gchar *) "Searches",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "searches",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_dns_options =
{
  {
    -1,
    (gchar *) "DnsOptions",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "dns-options",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _nmdbus_ip6_config_property_info_dns_priority =
{
  {
    -1,
    (gchar *) "DnsPriority",
    (gchar *) "i",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "dns-priority",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _nmdbus_ip6_config_property_info_pointers[] =
{
  &_nmdbus_ip6_config_property_info_addresses.parent_struct,
  &_nmdbus_ip6_config_property_info_address_data.parent_struct,
  &_nmdbus_ip6_config_property_info_gateway.parent_struct,
  &_nmdbus_ip6_config_property_info_routes.parent_struct,
  &_nmdbus_ip6_config_property_info_route_data.parent_struct,
  &_nmdbus_ip6_config_property_info_nameservers.parent_struct,
  &_nmdbus_ip6_config_property_info_domains.parent_struct,
  &_nmdbus_ip6_config_property_info_searches.parent_struct,
  &_nmdbus_ip6_config_property_info_dns_options.parent_struct,
  &_nmdbus_ip6_config_property_info_dns_priority.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _nmdbus_ip6_config_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.NetworkManager.IP6Config",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_nmdbus_ip6_config_property_info_pointers,
    NULL
  },
  "ip6-config",
};


/**
 * nmdbus_ip6_config_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
nmdbus_ip6_config_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_nmdbus_ip6_config_interface_info.parent_struct;
}

/**
 * nmdbus_ip6_config_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #NMDBusIP6Config interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
nmdbus_ip6_config_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "addresses");
  g_object_class_override_property (klass, property_id_begin++, "address-data");
  g_object_class_override_property (klass, property_id_begin++, "gateway");
  g_object_class_override_property (klass, property_id_begin++, "routes");
  g_object_class_override_property (klass, property_id_begin++, "route-data");
  g_object_class_override_property (klass, property_id_begin++, "nameservers");
  g_object_class_override_property (klass, property_id_begin++, "domains");
  g_object_class_override_property (klass, property_id_begin++, "searches");
  g_object_class_override_property (klass, property_id_begin++, "dns-options");
  g_object_class_override_property (klass, property_id_begin++, "dns-priority");
  return property_id_begin - 1;
}



/**
 * NMDBusIP6Config:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link>.
 */

/**
 * NMDBusIP6ConfigIface:
 * @parent_iface: The parent interface.
 * @get_address_data: Getter for the #NMDBusIP6Config:address-data property.
 * @get_addresses: Getter for the #NMDBusIP6Config:addresses property.
 * @get_dns_options: Getter for the #NMDBusIP6Config:dns-options property.
 * @get_dns_priority: Getter for the #NMDBusIP6Config:dns-priority property.
 * @get_domains: Getter for the #NMDBusIP6Config:domains property.
 * @get_gateway: Getter for the #NMDBusIP6Config:gateway property.
 * @get_nameservers: Getter for the #NMDBusIP6Config:nameservers property.
 * @get_route_data: Getter for the #NMDBusIP6Config:route-data property.
 * @get_routes: Getter for the #NMDBusIP6Config:routes property.
 * @get_searches: Getter for the #NMDBusIP6Config:searches property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link>.
 */

typedef NMDBusIP6ConfigIface NMDBusIP6ConfigInterface;
G_DEFINE_INTERFACE (NMDBusIP6Config, nmdbus_ip6_config, G_TYPE_OBJECT)

static void
nmdbus_ip6_config_default_init (NMDBusIP6ConfigIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * NMDBusIP6Config:addresses:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Addresses">"Addresses"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("addresses", "Addresses", "Addresses", G_VARIANT_TYPE ("a(ayuay)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:address-data:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.AddressData">"AddressData"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("address-data", "AddressData", "AddressData", G_VARIANT_TYPE ("aa{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:gateway:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Gateway">"Gateway"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("gateway", "Gateway", "Gateway", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:routes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Routes">"Routes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("routes", "Routes", "Routes", G_VARIANT_TYPE ("a(ayuayu)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:route-data:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.RouteData">"RouteData"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("route-data", "RouteData", "RouteData", G_VARIANT_TYPE ("aa{sv}"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:nameservers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Nameservers">"Nameservers"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("nameservers", "Nameservers", "Nameservers", G_VARIANT_TYPE ("aay"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:domains:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Domains">"Domains"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("domains", "Domains", "Domains", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:searches:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Searches">"Searches"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("searches", "Searches", "Searches", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:dns-options:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsOptions">"DnsOptions"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("dns-options", "DnsOptions", "DnsOptions", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * NMDBusIP6Config:dns-priority:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsPriority">"DnsPriority"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_int ("dns-priority", "DnsPriority", "DnsPriority", G_MININT32, G_MAXINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * nmdbus_ip6_config_get_addresses: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Addresses">"Addresses"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_addresses() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_ip6_config_get_addresses (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_addresses (object);
}

/**
 * nmdbus_ip6_config_dup_addresses: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Addresses">"Addresses"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_ip6_config_dup_addresses (NMDBusIP6Config *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "addresses", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_addresses: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Addresses">"Addresses"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_addresses (NMDBusIP6Config *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "addresses", value, NULL);
}

/**
 * nmdbus_ip6_config_get_address_data: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.AddressData">"AddressData"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_address_data() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_ip6_config_get_address_data (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_address_data (object);
}

/**
 * nmdbus_ip6_config_dup_address_data: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.AddressData">"AddressData"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_ip6_config_dup_address_data (NMDBusIP6Config *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "address-data", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_address_data: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.AddressData">"AddressData"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_address_data (NMDBusIP6Config *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "address-data", value, NULL);
}

/**
 * nmdbus_ip6_config_get_gateway: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Gateway">"Gateway"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_gateway() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
nmdbus_ip6_config_get_gateway (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_gateway (object);
}

/**
 * nmdbus_ip6_config_dup_gateway: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Gateway">"Gateway"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
nmdbus_ip6_config_dup_gateway (NMDBusIP6Config *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "gateway", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_gateway: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Gateway">"Gateway"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_gateway (NMDBusIP6Config *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "gateway", value, NULL);
}

/**
 * nmdbus_ip6_config_get_routes: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Routes">"Routes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_routes() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_ip6_config_get_routes (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_routes (object);
}

/**
 * nmdbus_ip6_config_dup_routes: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Routes">"Routes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_ip6_config_dup_routes (NMDBusIP6Config *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "routes", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_routes: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Routes">"Routes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_routes (NMDBusIP6Config *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "routes", value, NULL);
}

/**
 * nmdbus_ip6_config_get_route_data: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.RouteData">"RouteData"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_route_data() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_ip6_config_get_route_data (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_route_data (object);
}

/**
 * nmdbus_ip6_config_dup_route_data: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.RouteData">"RouteData"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_ip6_config_dup_route_data (NMDBusIP6Config *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "route-data", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_route_data: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.RouteData">"RouteData"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_route_data (NMDBusIP6Config *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "route-data", value, NULL);
}

/**
 * nmdbus_ip6_config_get_nameservers: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Nameservers">"Nameservers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_nameservers() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
nmdbus_ip6_config_get_nameservers (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_nameservers (object);
}

/**
 * nmdbus_ip6_config_dup_nameservers: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Nameservers">"Nameservers"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
nmdbus_ip6_config_dup_nameservers (NMDBusIP6Config *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "nameservers", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_nameservers: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Nameservers">"Nameservers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_nameservers (NMDBusIP6Config *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "nameservers", value, NULL);
}

/**
 * nmdbus_ip6_config_get_domains: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Domains">"Domains"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_domains() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_ip6_config_get_domains (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_domains (object);
}

/**
 * nmdbus_ip6_config_dup_domains: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Domains">"Domains"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_ip6_config_dup_domains (NMDBusIP6Config *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "domains", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_domains: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Domains">"Domains"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_domains (NMDBusIP6Config *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "domains", value, NULL);
}

/**
 * nmdbus_ip6_config_get_searches: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Searches">"Searches"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_searches() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_ip6_config_get_searches (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_searches (object);
}

/**
 * nmdbus_ip6_config_dup_searches: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Searches">"Searches"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_ip6_config_dup_searches (NMDBusIP6Config *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "searches", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_searches: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.Searches">"Searches"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_searches (NMDBusIP6Config *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "searches", value, NULL);
}

/**
 * nmdbus_ip6_config_get_dns_options: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsOptions">"DnsOptions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use nmdbus_ip6_config_dup_dns_options() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
nmdbus_ip6_config_get_dns_options (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_dns_options (object);
}

/**
 * nmdbus_ip6_config_dup_dns_options: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsOptions">"DnsOptions"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
nmdbus_ip6_config_dup_dns_options (NMDBusIP6Config *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "dns-options", &value, NULL);
  return value;
}

/**
 * nmdbus_ip6_config_set_dns_options: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsOptions">"DnsOptions"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_dns_options (NMDBusIP6Config *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "dns-options", value, NULL);
}

/**
 * nmdbus_ip6_config_get_dns_priority: (skip)
 * @object: A #NMDBusIP6Config.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsPriority">"DnsPriority"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gint 
nmdbus_ip6_config_get_dns_priority (NMDBusIP6Config *object)
{
  return NMDBUS_IP6_CONFIG_GET_IFACE (object)->get_dns_priority (object);
}

/**
 * nmdbus_ip6_config_set_dns_priority: (skip)
 * @object: A #NMDBusIP6Config.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-NetworkManager-IP6Config.DnsPriority">"DnsPriority"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
nmdbus_ip6_config_set_dns_priority (NMDBusIP6Config *object, gint value)
{
  g_object_set (G_OBJECT (object), "dns-priority", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * NMDBusIP6ConfigProxy:
 *
 * The #NMDBusIP6ConfigProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusIP6ConfigProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusIP6ConfigProxy.
 */

struct _NMDBusIP6ConfigProxyPrivate
{
  GData *qdata;
};

static void nmdbus_ip6_config_proxy_iface_init (NMDBusIP6ConfigIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusIP6ConfigProxy, nmdbus_ip6_config_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (NMDBusIP6ConfigProxy)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_IP6_CONFIG, nmdbus_ip6_config_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusIP6ConfigProxy, nmdbus_ip6_config_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_IP6_CONFIG, nmdbus_ip6_config_proxy_iface_init))

#endif
static void
nmdbus_ip6_config_proxy_finalize (GObject *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (nmdbus_ip6_config_proxy_parent_class)->finalize (object);
}

static void
nmdbus_ip6_config_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_ip6_config_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
nmdbus_ip6_config_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.NetworkManager.IP6Config: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
nmdbus_ip6_config_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_ip6_config_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.NetworkManager.IP6Config", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) nmdbus_ip6_config_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
nmdbus_ip6_config_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_nmdbus_ip6_config_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], NMDBUS_TYPE_IP6_CONFIG);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_IP6_CONFIG);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
nmdbus_ip6_config_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_ip6_config_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_ip6_config_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static GVariant *
nmdbus_ip6_config_proxy_get_addresses (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Addresses");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
nmdbus_ip6_config_proxy_get_address_data (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AddressData");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *
nmdbus_ip6_config_proxy_get_gateway (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Gateway");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
nmdbus_ip6_config_proxy_get_routes (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Routes");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
nmdbus_ip6_config_proxy_get_route_data (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RouteData");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
nmdbus_ip6_config_proxy_get_nameservers (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Nameservers");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *const *
nmdbus_ip6_config_proxy_get_domains (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Domains");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Domains");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Domains", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_ip6_config_proxy_get_searches (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Searches");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Searches");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Searches", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
nmdbus_ip6_config_proxy_get_dns_options (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "DnsOptions");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DnsOptions");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "DnsOptions", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static gint 
nmdbus_ip6_config_proxy_get_dns_priority (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigProxy *proxy = NMDBUS_IP6_CONFIG_PROXY (object);
  GVariant *variant;
  gint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DnsPriority");
  if (variant != NULL)
    {
      value = g_variant_get_int32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
nmdbus_ip6_config_proxy_init (NMDBusIP6ConfigProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = nmdbus_ip6_config_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, NMDBUS_TYPE_IP6_CONFIG_PROXY, NMDBusIP6ConfigProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), nmdbus_ip6_config_interface_info ());
}

static void
nmdbus_ip6_config_proxy_class_init (NMDBusIP6ConfigProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = nmdbus_ip6_config_proxy_finalize;
  gobject_class->get_property = nmdbus_ip6_config_proxy_get_property;
  gobject_class->set_property = nmdbus_ip6_config_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = nmdbus_ip6_config_proxy_g_signal;
  proxy_class->g_properties_changed = nmdbus_ip6_config_proxy_g_properties_changed;

  nmdbus_ip6_config_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusIP6ConfigProxyPrivate));
#endif
}

static void
nmdbus_ip6_config_proxy_iface_init (NMDBusIP6ConfigIface *iface)
{
  iface->get_addresses = nmdbus_ip6_config_proxy_get_addresses;
  iface->get_address_data = nmdbus_ip6_config_proxy_get_address_data;
  iface->get_gateway = nmdbus_ip6_config_proxy_get_gateway;
  iface->get_routes = nmdbus_ip6_config_proxy_get_routes;
  iface->get_route_data = nmdbus_ip6_config_proxy_get_route_data;
  iface->get_nameservers = nmdbus_ip6_config_proxy_get_nameservers;
  iface->get_domains = nmdbus_ip6_config_proxy_get_domains;
  iface->get_searches = nmdbus_ip6_config_proxy_get_searches;
  iface->get_dns_options = nmdbus_ip6_config_proxy_get_dns_options;
  iface->get_dns_priority = nmdbus_ip6_config_proxy_get_dns_priority;
}

/**
 * nmdbus_ip6_config_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_ip6_config_proxy_new_finish() to get the result of the operation.
 *
 * See nmdbus_ip6_config_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_ip6_config_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_IP6_CONFIG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.IP6Config", NULL);
}

/**
 * nmdbus_ip6_config_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_ip6_config_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_ip6_config_proxy_new().
 *
 * Returns: (transfer full) (type NMDBusIP6ConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusIP6Config *
nmdbus_ip6_config_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_IP6_CONFIG (ret);
  else
    return NULL;
}

/**
 * nmdbus_ip6_config_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_ip6_config_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusIP6ConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusIP6Config *
nmdbus_ip6_config_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_IP6_CONFIG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.IP6Config", NULL);
  if (ret != NULL)
    return NMDBUS_IP6_CONFIG (ret);
  else
    return NULL;
}


/**
 * nmdbus_ip6_config_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like nmdbus_ip6_config_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call nmdbus_ip6_config_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See nmdbus_ip6_config_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
nmdbus_ip6_config_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (NMDBUS_TYPE_IP6_CONFIG_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.IP6Config", NULL);
}

/**
 * nmdbus_ip6_config_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to nmdbus_ip6_config_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with nmdbus_ip6_config_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type NMDBusIP6ConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusIP6Config *
nmdbus_ip6_config_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return NMDBUS_IP6_CONFIG (ret);
  else
    return NULL;
}

/**
 * nmdbus_ip6_config_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like nmdbus_ip6_config_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See nmdbus_ip6_config_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type NMDBusIP6ConfigProxy): The constructed proxy object or %NULL if @error is set.
 */
NMDBusIP6Config *
nmdbus_ip6_config_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (NMDBUS_TYPE_IP6_CONFIG_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.NetworkManager.IP6Config", NULL);
  if (ret != NULL)
    return NMDBUS_IP6_CONFIG (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * NMDBusIP6ConfigSkeleton:
 *
 * The #NMDBusIP6ConfigSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * NMDBusIP6ConfigSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #NMDBusIP6ConfigSkeleton.
 */

struct _NMDBusIP6ConfigSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_nmdbus_ip6_config_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], NMDBUS_TYPE_IP6_CONFIG);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, NMDBUS_TYPE_IP6_CONFIG);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_nmdbus_ip6_config_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_ip6_config_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_nmdbus_ip6_config_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_nmdbus_ip6_config_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _nmdbus_ip6_config_skeleton_vtable =
{
  _nmdbus_ip6_config_skeleton_handle_method_call,
  _nmdbus_ip6_config_skeleton_handle_get_property,
  _nmdbus_ip6_config_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
nmdbus_ip6_config_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return nmdbus_ip6_config_interface_info ();
}

static GDBusInterfaceVTable *
nmdbus_ip6_config_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_nmdbus_ip6_config_skeleton_vtable;
}

static GVariant *
nmdbus_ip6_config_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_nmdbus_ip6_config_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _nmdbus_ip6_config_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _nmdbus_ip6_config_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _nmdbus_ip6_config_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.NetworkManager.IP6Config", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _nmdbus_ip6_config_emit_changed (gpointer user_data);

static void
nmdbus_ip6_config_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _nmdbus_ip6_config_emit_changed (skeleton);
}

static void nmdbus_ip6_config_skeleton_iface_init (NMDBusIP6ConfigIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (NMDBusIP6ConfigSkeleton, nmdbus_ip6_config_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (NMDBusIP6ConfigSkeleton)
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_IP6_CONFIG, nmdbus_ip6_config_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (NMDBusIP6ConfigSkeleton, nmdbus_ip6_config_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (NMDBUS_TYPE_IP6_CONFIG, nmdbus_ip6_config_skeleton_iface_init))

#endif
static void
nmdbus_ip6_config_skeleton_finalize (GObject *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  guint n;
  for (n = 0; n < 10; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (nmdbus_ip6_config_skeleton_parent_class)->finalize (object);
}

static void
nmdbus_ip6_config_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_nmdbus_ip6_config_emit_changed (gpointer user_data)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.NetworkManager.IP6Config",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_nmdbus_ip6_config_schedule_emit_changed (NMDBusIP6ConfigSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
nmdbus_ip6_config_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _nmdbus_ip6_config_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _nmdbus_ip6_config_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
nmdbus_ip6_config_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 10);
  info = (const _ExtendedGDBusPropertyInfo *) _nmdbus_ip6_config_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _nmdbus_ip6_config_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
nmdbus_ip6_config_skeleton_init (NMDBusIP6ConfigSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = nmdbus_ip6_config_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, NMDBUS_TYPE_IP6_CONFIG_SKELETON, NMDBusIP6ConfigSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 10);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[9], G_TYPE_INT);
}

static GVariant *
nmdbus_ip6_config_skeleton_get_addresses (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_ip6_config_skeleton_get_address_data (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
nmdbus_ip6_config_skeleton_get_gateway (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_ip6_config_skeleton_get_routes (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_ip6_config_skeleton_get_route_data (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
nmdbus_ip6_config_skeleton_get_nameservers (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_ip6_config_skeleton_get_domains (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_ip6_config_skeleton_get_searches (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
nmdbus_ip6_config_skeleton_get_dns_options (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gint 
nmdbus_ip6_config_skeleton_get_dns_priority (NMDBusIP6Config *object)
{
  NMDBusIP6ConfigSkeleton *skeleton = NMDBUS_IP6_CONFIG_SKELETON (object);
  gint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_int (&(skeleton->priv->properties[9]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
nmdbus_ip6_config_skeleton_class_init (NMDBusIP6ConfigSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = nmdbus_ip6_config_skeleton_finalize;
  gobject_class->get_property = nmdbus_ip6_config_skeleton_get_property;
  gobject_class->set_property = nmdbus_ip6_config_skeleton_set_property;
  gobject_class->notify       = nmdbus_ip6_config_skeleton_notify;


  nmdbus_ip6_config_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = nmdbus_ip6_config_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = nmdbus_ip6_config_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = nmdbus_ip6_config_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = nmdbus_ip6_config_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (NMDBusIP6ConfigSkeletonPrivate));
#endif
}

static void
nmdbus_ip6_config_skeleton_iface_init (NMDBusIP6ConfigIface *iface)
{
  iface->get_addresses = nmdbus_ip6_config_skeleton_get_addresses;
  iface->get_address_data = nmdbus_ip6_config_skeleton_get_address_data;
  iface->get_gateway = nmdbus_ip6_config_skeleton_get_gateway;
  iface->get_routes = nmdbus_ip6_config_skeleton_get_routes;
  iface->get_route_data = nmdbus_ip6_config_skeleton_get_route_data;
  iface->get_nameservers = nmdbus_ip6_config_skeleton_get_nameservers;
  iface->get_domains = nmdbus_ip6_config_skeleton_get_domains;
  iface->get_searches = nmdbus_ip6_config_skeleton_get_searches;
  iface->get_dns_options = nmdbus_ip6_config_skeleton_get_dns_options;
  iface->get_dns_priority = nmdbus_ip6_config_skeleton_get_dns_priority;
}

/**
 * nmdbus_ip6_config_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-NetworkManager-IP6Config.top_of_page">org.freedesktop.NetworkManager.IP6Config</link>.
 *
 * Returns: (transfer full) (type NMDBusIP6ConfigSkeleton): The skeleton object.
 */
NMDBusIP6Config *
nmdbus_ip6_config_skeleton_new (void)
{
  return NMDBUS_IP6_CONFIG (g_object_new (NMDBUS_TYPE_IP6_CONFIG_SKELETON, NULL));
}

