/* rygel-dtcp-cleartext-request.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-dtcp-cleartext-request.vala, do not modify */

/*
 * Copyright (C) 2013  Cable Television Laboratories, Inc.
 *
 * Author: Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <libsoup/soup.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

enum  {
	RYGEL_DTCP_CLEARTEXT_REQUEST_0_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY,
	RYGEL_DTCP_CLEARTEXT_REQUEST_NUM_PROPERTIES
};
static GParamSpec* rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_NUM_PROPERTIES];

#define RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER (rygel_http_media_resource_handler_get_type ())
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandler))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER))
#define RYGEL_HTTP_MEDIA_RESOURCE_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_MEDIA_RESOURCE_HANDLER, RygelHTTPMediaResourceHandlerClass))

typedef struct _RygelHTTPMediaResourceHandler RygelHTTPMediaResourceHandler;
typedef struct _RygelHTTPMediaResourceHandlerClass RygelHTTPMediaResourceHandlerClass;
typedef struct _RygelHTTPMediaResourceHandlerPrivate RygelHTTPMediaResourceHandlerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RygelDTCPCleartextRequestPrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

struct _RygelHTTPMediaResourceHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPMediaResourceHandlerPrivate * priv;
	RygelMediaResource* media_resource;
};

struct _RygelHTTPMediaResourceHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

static gint RygelDTCPCleartextRequest_private_offset;
static gpointer rygel_dtcp_cleartext_request_parent_class = NULL;

VALA_EXTERN GType rygel_http_media_resource_handler_get_type (void) G_GNUC_CONST ;
static void rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self,
                                                  gint64 value);
static void rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self,
                                                gint64 value);
static void rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self,
                                                    gint64 value);
static void rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self,
                                                  gint64 value);
static void rygel_dtcp_cleartext_request_finalize (GObject * obj);
static GType rygel_dtcp_cleartext_request_get_type_once (void);
static void _vala_rygel_dtcp_cleartext_request_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_rygel_dtcp_cleartext_request_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_dtcp_cleartext_request_get_instance_private (RygelDTCPCleartextRequest* self)
{
	return G_STRUCT_MEMBER_P (self, RygelDTCPCleartextRequest_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar** unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

RygelDTCPCleartextRequest*
rygel_dtcp_cleartext_request_construct (GType object_type,
                                        SoupMessage* message,
                                        RygelHTTPGetHandler* handler,
                                        GError** error)
{
	RygelDTCPCleartextRequest * self = NULL;
	gint64 start = 0LL;
	gint64 end = 0LL;
	gint64 total_size = 0LL;
	RygelHTTPMediaResourceHandler* resource_handler = NULL;
	RygelHTTPMediaResourceHandler* _tmp0_;
	RygelHTTPMediaResourceHandler* _tmp1_;
	const gchar* range = NULL;
	SoupMessageHeaders* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp14_;
	gchar** range_tokens = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gint range_tokens_length1;
	gint _range_tokens_size_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	gint64 _tmp34_ = 0LL;
	gboolean _tmp35_;
	const gchar* _tmp40_;
	gint _tmp41_;
	gint _tmp42_;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp61_ = FALSE;
	gint64 _tmp62_ = 0LL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (message != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	self = (RygelDTCPCleartextRequest*) rygel_http_seek_request_construct (object_type);
	_tmp0_ = _g_object_ref0 (RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER (handler) ? ((RygelHTTPMediaResourceHandler*) handler) : NULL);
	resource_handler = _tmp0_;
	_tmp1_ = resource_handler;
	if (_tmp1_ != NULL) {
		RygelMediaResource* resource = NULL;
		RygelHTTPMediaResourceHandler* _tmp2_;
		RygelMediaResource* _tmp3_;
		RygelMediaResource* _tmp4_;
		RygelMediaResource* _tmp5_;
		gint64 _tmp6_;
		gint64 _tmp7_;
		_tmp2_ = resource_handler;
		_tmp3_ = _tmp2_->media_resource;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		resource = _tmp4_;
		_tmp5_ = resource;
		_tmp6_ = rygel_media_resource_get_cleartext_size (_tmp5_);
		_tmp7_ = _tmp6_;
		total_size = _tmp7_;
		if (total_size <= ((gint64) 0)) {
			total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
		}
		_g_object_unref0 (resource);
	} else {
		total_size = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	}
	_tmp8_ = message->request_headers;
	_tmp9_ = soup_message_headers_get_one (_tmp8_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	range = _tmp9_;
	_tmp10_ = range;
	if (_tmp10_ == NULL) {
		gchar* msg = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		_tmp11_ = g_strdup ("%s request header not present");
		msg = _tmp11_;
		_tmp12_ = msg;
		_tmp13_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp12_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
		_inner_error0_ = _tmp13_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_object_unref0 (resource_handler);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			_g_object_unref0 (resource_handler);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp14_ = range;
	if (!g_str_has_prefix (_tmp14_, "bytes")) {
		gchar* msg = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		GError* _tmp18_;
		_tmp15_ = g_strdup ("Invalid %s value (missing bytes field): '%s'");
		msg = _tmp15_;
		_tmp16_ = msg;
		_tmp17_ = range;
		_tmp18_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp16_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp17_);
		_inner_error0_ = _tmp18_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			_g_object_unref0 (resource_handler);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			_g_object_unref0 (resource_handler);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp19_ = range;
	_tmp20_ = string_substring (_tmp19_, (glong) 6, (glong) -1);
	_tmp21_ = _tmp20_;
	_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, "-", 2);
	_tmp24_ = _tmp23_;
	_tmp24__length1 = _vala_array_length (_tmp22_);
	_g_free0 (_tmp21_);
	range_tokens = _tmp24_;
	range_tokens_length1 = _tmp24__length1;
	_range_tokens_size_ = range_tokens_length1;
	_tmp25_ = range_tokens[0];
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == 0) {
		gchar* msg = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		GError* _tmp31_;
		_tmp28_ = g_strdup ("No range start specified: '%s'");
		msg = _tmp28_;
		_tmp29_ = msg;
		_tmp30_ = range;
		_tmp31_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp29_, _tmp30_);
		_inner_error0_ = _tmp31_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp33_ = range_tokens[0];
	_tmp35_ = int64_try_parse (_tmp33_, &_tmp34_, NULL, (guint) 0);
	start = _tmp34_;
	if (!_tmp35_) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = start < ((gint64) 0);
	}
	if (_tmp32_) {
		gchar* msg = NULL;
		gchar* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		GError* _tmp39_;
		_tmp36_ = g_strdup ("Invalid %s range start: '%s'");
		msg = _tmp36_;
		_tmp37_ = msg;
		_tmp38_ = range;
		_tmp39_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp37_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp38_);
		_inner_error0_ = _tmp39_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	_tmp40_ = range_tokens[1];
	_tmp41_ = strlen (_tmp40_);
	_tmp42_ = _tmp41_;
	if (_tmp42_ == 0) {
		end = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		gboolean _tmp43_ = FALSE;
		const gchar* _tmp44_;
		gint64 _tmp45_ = 0LL;
		gboolean _tmp46_;
		_tmp44_ = range_tokens[1];
		_tmp46_ = int64_try_parse (_tmp44_, &_tmp45_, NULL, (guint) 0);
		end = _tmp45_;
		if (!_tmp46_) {
			_tmp43_ = TRUE;
		} else {
			_tmp43_ = end <= ((gint64) 0);
		}
		if (_tmp43_) {
			gchar* msg = NULL;
			gchar* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			GError* _tmp50_;
			_tmp47_ = g_strdup ("Invalid %s range end: '%s'");
			msg = _tmp47_;
			_tmp48_ = msg;
			_tmp49_ = range;
			_tmp50_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp48_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp49_);
			_inner_error0_ = _tmp50_;
			if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (resource_handler);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (msg);
				range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (resource_handler);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_g_free0 (msg);
		}
	}
	if (end != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp51_ = start > end;
	} else {
		_tmp51_ = FALSE;
	}
	if (_tmp51_) {
		gchar* msg = NULL;
		gchar* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		GError* _tmp55_;
		_tmp52_ = g_strdup ("Invalid %s range - start > end: '%s'");
		msg = _tmp52_;
		_tmp53_ = msg;
		_tmp54_ = range;
		_tmp55_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_INVALID_RANGE, _tmp53_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp54_);
		_inner_error0_ = _tmp55_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp56_ = start > (total_size - 1);
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		gchar* msg = NULL;
		gchar* _tmp57_;
		const gchar* _tmp58_;
		const gchar* _tmp59_;
		GError* _tmp60_;
		_tmp57_ = g_strdup ("Invalid %s range - start > length: '%s'");
		msg = _tmp57_;
		_tmp58_ = msg;
		_tmp59_ = range;
		_tmp60_ = g_error_new (RYGEL_HTTP_SEEK_REQUEST_ERROR, RYGEL_HTTP_SEEK_REQUEST_ERROR_OUT_OF_RANGE, _tmp58_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER, _tmp59_);
		_inner_error0_ = _tmp60_;
		if ((_inner_error0_->domain == RYGEL_HTTP_SEEK_REQUEST_ERROR) || (_inner_error0_->domain == RYGEL_HTTP_REQUEST_ERROR)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_free0 (msg);
			range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (resource_handler);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (msg);
	}
	if (total_size != RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp61_ = end > (total_size - 1);
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		end = total_size - 1;
	}
	rygel_dtcp_cleartext_request_set_start_byte (self, start);
	rygel_dtcp_cleartext_request_set_end_byte (self, end);
	if (end == RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED) {
		_tmp62_ = RYGEL_HTTP_SEEK_REQUEST_UNSPECIFIED;
	} else {
		_tmp62_ = (end - start) + 1;
	}
	rygel_dtcp_cleartext_request_set_range_length (self, _tmp62_);
	rygel_dtcp_cleartext_request_set_total_size (self, total_size);
	range_tokens = (_vala_array_free (range_tokens, range_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (resource_handler);
	return self;
}

RygelDTCPCleartextRequest*
rygel_dtcp_cleartext_request_new (SoupMessage* message,
                                  RygelHTTPGetHandler* handler,
                                  GError** error)
{
	return rygel_dtcp_cleartext_request_construct (RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, message, handler, error);
}

gboolean
rygel_dtcp_cleartext_request_supported (SoupMessage* message,
                                        RygelHTTPGetHandler* handler)
{
	RygelHTTPMediaResourceHandler* resource_handler = NULL;
	RygelHTTPMediaResourceHandler* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RygelHTTPMediaResourceHandler* _tmp2_;
	gboolean result;
	g_return_val_if_fail (message != NULL, FALSE);
	g_return_val_if_fail (handler != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (RYGEL_IS_HTTP_MEDIA_RESOURCE_HANDLER (handler) ? ((RygelHTTPMediaResourceHandler*) handler) : NULL);
	resource_handler = _tmp0_;
	_tmp2_ = resource_handler;
	if (_tmp2_ != NULL) {
		RygelHTTPMediaResourceHandler* _tmp3_;
		RygelMediaResource* _tmp4_;
		_tmp3_ = resource_handler;
		_tmp4_ = _tmp3_->media_resource;
		_tmp1_ = rygel_media_resource_is_cleartext_range_support_enabled (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_g_object_unref0 (resource_handler);
	return result;
}

gboolean
rygel_dtcp_cleartext_request_requested (SoupMessage* message)
{
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (message != NULL, FALSE);
	_tmp0_ = message->request_headers;
	_tmp1_ = soup_message_headers_get_one (_tmp0_, RYGEL_DTCP_CLEARTEXT_REQUEST_DTCP_RANGE_HEADER);
	result = _tmp1_ != NULL;
	return result;
}

gint64
rygel_dtcp_cleartext_request_get_start_byte (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_start_byte (RygelDTCPCleartextRequest* self,
                                             gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_request_get_start_byte (self);
	if (old_value != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_request_get_end_byte (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_end_byte (RygelDTCPCleartextRequest* self,
                                           gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_request_get_end_byte (self);
	if (old_value != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_request_get_range_length (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_length;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_range_length (RygelDTCPCleartextRequest* self,
                                               gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_request_get_range_length (self);
	if (old_value != value) {
		self->priv->_range_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY]);
	}
}

gint64
rygel_dtcp_cleartext_request_get_total_size (RygelDTCPCleartextRequest* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_size;
	return result;
}

static void
rygel_dtcp_cleartext_request_set_total_size (RygelDTCPCleartextRequest* self,
                                             gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_dtcp_cleartext_request_get_total_size (self);
	if (old_value != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY]);
	}
}

static void
rygel_dtcp_cleartext_request_class_init (RygelDTCPCleartextRequestClass * klass,
                                         gpointer klass_data)
{
	rygel_dtcp_cleartext_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelDTCPCleartextRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_dtcp_cleartext_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_dtcp_cleartext_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_dtcp_cleartext_request_finalize;
	/**
	     * The start of the cleartext range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The end of the cleartext range in bytes (inclusive). May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the cleartext range in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY] = g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the cleartext resource in bytes. May be
	     * HTTPSeekRequest.UNSPECIFIED
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY, rygel_dtcp_cleartext_request_properties[RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY] = g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rygel_dtcp_cleartext_request_instance_init (RygelDTCPCleartextRequest * self,
                                            gpointer klass)
{
	self->priv = rygel_dtcp_cleartext_request_get_instance_private (self);
}

static void
rygel_dtcp_cleartext_request_finalize (GObject * obj)
{
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	G_OBJECT_CLASS (rygel_dtcp_cleartext_request_parent_class)->finalize (obj);
}

static GType
rygel_dtcp_cleartext_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelDTCPCleartextRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dtcp_cleartext_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDTCPCleartextRequest), 0, (GInstanceInitFunc) rygel_dtcp_cleartext_request_instance_init, NULL };
	GType rygel_dtcp_cleartext_request_type_id;
	rygel_dtcp_cleartext_request_type_id = g_type_register_static (RYGEL_TYPE_HTTP_SEEK_REQUEST, "RygelDTCPCleartextRequest", &g_define_type_info, 0);
	RygelDTCPCleartextRequest_private_offset = g_type_add_instance_private (rygel_dtcp_cleartext_request_type_id, sizeof (RygelDTCPCleartextRequestPrivate));
	return rygel_dtcp_cleartext_request_type_id;
}

GType
rygel_dtcp_cleartext_request_get_type (void)
{
	static volatile gsize rygel_dtcp_cleartext_request_type_id__once = 0;
	if (g_once_init_enter (&rygel_dtcp_cleartext_request_type_id__once)) {
		GType rygel_dtcp_cleartext_request_type_id;
		rygel_dtcp_cleartext_request_type_id = rygel_dtcp_cleartext_request_get_type_once ();
		g_once_init_leave (&rygel_dtcp_cleartext_request_type_id__once, rygel_dtcp_cleartext_request_type_id);
	}
	return rygel_dtcp_cleartext_request_type_id__once;
}

static void
_vala_rygel_dtcp_cleartext_request_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_start_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_end_byte (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_range_length (self));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_dtcp_cleartext_request_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_dtcp_cleartext_request_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	RygelDTCPCleartextRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_DTCP_CLEARTEXT_REQUEST, RygelDTCPCleartextRequest);
	switch (property_id) {
		case RYGEL_DTCP_CLEARTEXT_REQUEST_START_BYTE_PROPERTY:
		rygel_dtcp_cleartext_request_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_END_BYTE_PROPERTY:
		rygel_dtcp_cleartext_request_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_RANGE_LENGTH_PROPERTY:
		rygel_dtcp_cleartext_request_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_DTCP_CLEARTEXT_REQUEST_TOTAL_SIZE_PROPERTY:
		rygel_dtcp_cleartext_request_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

