/* rygel-http-byte-seek-response.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-http-byte-seek-response.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>

enum  {
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_0_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY,
	RYGEL_HTTP_BYTE_SEEK_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_NUM_PROPERTIES];

struct _RygelHTTPByteSeekResponsePrivate {
	gint64 _start_byte;
	gint64 _end_byte;
	gint64 _range_length;
	gint64 _total_size;
};

static gint RygelHTTPByteSeekResponse_private_offset;
static gpointer rygel_http_byte_seek_response_parent_class = NULL;

static void rygel_http_byte_seek_response_set_range_length (RygelHTTPByteSeekResponse* self,
                                                     gint64 value);
static void rygel_http_byte_seek_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                              RygelHTTPRequest* request);
static gchar* rygel_http_byte_seek_response_real_to_string (RygelHTTPResponseElement* base);
static void rygel_http_byte_seek_response_finalize (GObject * obj);
static GType rygel_http_byte_seek_response_get_type_once (void);
static void _vala_rygel_http_byte_seek_response_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_rygel_http_byte_seek_response_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_byte_seek_response_get_instance_private (RygelHTTPByteSeekResponse* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPByteSeekResponse_private_offset);
}

RygelHTTPByteSeekResponse*
rygel_http_byte_seek_response_construct (GType object_type,
                                         gint64 start_byte,
                                         gint64 end_byte,
                                         gint64 total_size)
{
	RygelHTTPByteSeekResponse * self = NULL;
	self = (RygelHTTPByteSeekResponse*) rygel_http_response_element_construct (object_type);
	rygel_http_byte_seek_response_set_start_byte (self, start_byte);
	rygel_http_byte_seek_response_set_end_byte (self, end_byte);
	rygel_http_byte_seek_response_set_range_length (self, (end_byte - start_byte) + 1);
	rygel_http_byte_seek_response_set_total_size (self, total_size);
	return self;
}

RygelHTTPByteSeekResponse*
rygel_http_byte_seek_response_new (gint64 start_byte,
                                   gint64 end_byte,
                                   gint64 total_size)
{
	return rygel_http_byte_seek_response_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, start_byte, end_byte, total_size);
}

RygelHTTPByteSeekResponse*
rygel_http_byte_seek_response_construct_from_request (GType object_type,
                                                      RygelHTTPByteSeekRequest* request)
{
	RygelHTTPByteSeekResponse * self = NULL;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gint64 _tmp7_;
	g_return_val_if_fail (request != NULL, NULL);
	self = (RygelHTTPByteSeekResponse*) rygel_http_response_element_construct (object_type);
	_tmp0_ = rygel_http_byte_seek_request_get_start_byte (request);
	_tmp1_ = _tmp0_;
	rygel_http_byte_seek_response_set_start_byte (self, _tmp1_);
	_tmp2_ = rygel_http_byte_seek_request_get_end_byte (request);
	_tmp3_ = _tmp2_;
	rygel_http_byte_seek_response_set_end_byte (self, _tmp3_);
	_tmp4_ = rygel_http_byte_seek_request_get_range_length (request);
	_tmp5_ = _tmp4_;
	rygel_http_byte_seek_response_set_range_length (self, _tmp5_);
	_tmp6_ = rygel_http_byte_seek_request_get_total_size (request);
	_tmp7_ = _tmp6_;
	rygel_http_byte_seek_response_set_total_size (self, _tmp7_);
	return self;
}

RygelHTTPByteSeekResponse*
rygel_http_byte_seek_response_new_from_request (RygelHTTPByteSeekRequest* request)
{
	return rygel_http_byte_seek_response_construct_from_request (RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, request);
}

static void
rygel_http_byte_seek_response_real_add_response_headers (RygelHTTPResponseElement* base,
                                                         RygelHTTPRequest* request)
{
	RygelHTTPByteSeekResponse * self;
	gint64 _tmp0_;
	self = (RygelHTTPByteSeekResponse*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->_end_byte;
	if (_tmp0_ != ((gint64) -1)) {
		SoupMessage* _tmp1_;
		SoupMessageHeaders* _tmp2_;
		gint64 _tmp3_;
		gint64 _tmp4_;
		gint64 _tmp5_;
		SoupMessage* _tmp6_;
		SoupMessageHeaders* _tmp7_;
		SoupMessage* _tmp8_;
		SoupMessageHeaders* _tmp9_;
		gint64 _tmp10_;
		_tmp1_ = request->msg;
		_tmp2_ = _tmp1_->response_headers;
		_tmp3_ = self->priv->_start_byte;
		_tmp4_ = self->priv->_end_byte;
		_tmp5_ = self->priv->_total_size;
		soup_message_headers_set_content_range (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
		_tmp6_ = request->msg;
		_tmp7_ = _tmp6_->response_headers;
		soup_message_headers_append (_tmp7_, "Accept-Ranges", "bytes");
		_tmp8_ = request->msg;
		_tmp9_ = _tmp8_->response_headers;
		_tmp10_ = self->priv->_range_length;
		soup_message_headers_set_content_length (_tmp9_, _tmp10_);
	}
}

static gchar*
rygel_http_byte_seek_response_real_to_string (RygelHTTPResponseElement* base)
{
	RygelHTTPByteSeekResponse * self;
	gint64 _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = (RygelHTTPByteSeekResponse*) base;
	_tmp0_ = self->priv->_start_byte;
	_tmp1_ = self->priv->_end_byte;
	_tmp2_ = self->priv->_total_size;
	_tmp3_ = self->priv->_range_length;
	_tmp4_ = g_strdup_printf ("HTTPByteSeekResponse(bytes=%lld-%lld/%lld (%lld bytes))", _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}

gint64
rygel_http_byte_seek_response_get_start_byte (RygelHTTPByteSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_start_byte;
	return result;
}

void
rygel_http_byte_seek_response_set_start_byte (RygelHTTPByteSeekResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_byte_seek_response_get_start_byte (self);
	if (old_value != value) {
		self->priv->_start_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE_PROPERTY]);
	}
}

gint64
rygel_http_byte_seek_response_get_end_byte (RygelHTTPByteSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_end_byte;
	return result;
}

void
rygel_http_byte_seek_response_set_end_byte (RygelHTTPByteSeekResponse* self,
                                            gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_byte_seek_response_get_end_byte (self);
	if (old_value != value) {
		self->priv->_end_byte = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE_PROPERTY]);
	}
}

gint64
rygel_http_byte_seek_response_get_range_length (RygelHTTPByteSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_range_length;
	return result;
}

static void
rygel_http_byte_seek_response_set_range_length (RygelHTTPByteSeekResponse* self,
                                                gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_byte_seek_response_get_range_length (self);
	if (old_value != value) {
		self->priv->_range_length = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH_PROPERTY]);
	}
}

gint64
rygel_http_byte_seek_response_get_total_size (RygelHTTPByteSeekResponse* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_total_size;
	return result;
}

void
rygel_http_byte_seek_response_set_total_size (RygelHTTPByteSeekResponse* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_byte_seek_response_get_total_size (self);
	if (old_value != value) {
		self->priv->_total_size = value;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY]);
	}
}

static void
rygel_http_byte_seek_response_class_init (RygelHTTPByteSeekResponseClass * klass,
                                          gpointer klass_data)
{
	rygel_http_byte_seek_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPByteSeekResponse_private_offset);
	((RygelHTTPResponseElementClass *) klass)->add_response_headers = (void (*) (RygelHTTPResponseElement*, RygelHTTPRequest*)) rygel_http_byte_seek_response_real_add_response_headers;
	((RygelHTTPResponseElementClass *) klass)->to_string = (gchar* (*) (RygelHTTPResponseElement*)) rygel_http_byte_seek_response_real_to_string;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_byte_seek_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_byte_seek_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_response_finalize;
	/**
	     * The start of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE_PROPERTY, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE_PROPERTY] = g_param_spec_int64 ("start-byte", "start-byte", "start-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The end of the range in bytes (inclusive)
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE_PROPERTY, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE_PROPERTY] = g_param_spec_int64 ("end-byte", "end-byte", "end-byte", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The length of the range in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH_PROPERTY, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH_PROPERTY] = g_param_spec_int64 ("range-length", "range-length", "range-length", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The length of the resource in bytes
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY, rygel_http_byte_seek_response_properties[RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY] = g_param_spec_int64 ("total-size", "total-size", "total-size", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_http_byte_seek_response_instance_init (RygelHTTPByteSeekResponse * self,
                                             gpointer klass)
{
	self->priv = rygel_http_byte_seek_response_get_instance_private (self);
}

static void
rygel_http_byte_seek_response_finalize (GObject * obj)
{
	RygelHTTPByteSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse);
	G_OBJECT_CLASS (rygel_http_byte_seek_response_parent_class)->finalize (obj);
}

static GType
rygel_http_byte_seek_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekResponse), 0, (GInstanceInitFunc) rygel_http_byte_seek_response_instance_init, NULL };
	GType rygel_http_byte_seek_response_type_id;
	rygel_http_byte_seek_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE_ELEMENT, "RygelHTTPByteSeekResponse", &g_define_type_info, 0);
	RygelHTTPByteSeekResponse_private_offset = g_type_add_instance_private (rygel_http_byte_seek_response_type_id, sizeof (RygelHTTPByteSeekResponsePrivate));
	return rygel_http_byte_seek_response_type_id;
}

GType
rygel_http_byte_seek_response_get_type (void)
{
	static volatile gsize rygel_http_byte_seek_response_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_response_type_id__once)) {
		GType rygel_http_byte_seek_response_type_id;
		rygel_http_byte_seek_response_type_id = rygel_http_byte_seek_response_get_type_once ();
		g_once_init_leave (&rygel_http_byte_seek_response_type_id__once, rygel_http_byte_seek_response_type_id);
	}
	return rygel_http_byte_seek_response_type_id__once;
}

static void
_vala_rygel_http_byte_seek_response_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	RygelHTTPByteSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_start_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_end_byte (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_range_length (self));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY:
		g_value_set_int64 (value, rygel_http_byte_seek_response_get_total_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_byte_seek_response_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	RygelHTTPByteSeekResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_BYTE_SEEK_RESPONSE, RygelHTTPByteSeekResponse);
	switch (property_id) {
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_START_BYTE_PROPERTY:
		rygel_http_byte_seek_response_set_start_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_END_BYTE_PROPERTY:
		rygel_http_byte_seek_response_set_end_byte (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_RANGE_LENGTH_PROPERTY:
		rygel_http_byte_seek_response_set_range_length (self, g_value_get_int64 (value));
		break;
		case RYGEL_HTTP_BYTE_SEEK_RESPONSE_TOTAL_SIZE_PROPERTY:
		rygel_http_byte_seek_response_set_total_size (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

