/* rygel-http-server.c generated by valac 0.56.1, the Vala compiler
 * generated from rygel-http-server.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 * Copyright (C) 2012 Intel Corporation.
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Jens Georg <jensg@openismus.com>
 *         Doug Galligan <doug@sentosatech.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>
#include "rygel-core.h"
#include "config.h"
#include <libgupnp/gupnp.h>
#include <libgssdp/gssdp.h>
#include <libsoup/soup.h>

#define RYGEL_HTTP_SERVER_SERVER_TEMPLATE "%s/%s %s/%s DLNA/1.51 UPnP/1.0"

enum  {
	RYGEL_HTTP_SERVER_0_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT_PROPERTY,
	RYGEL_HTTP_SERVER_SERVER_NAME_PROPERTY,
	RYGEL_HTTP_SERVER_CANCELLABLE_PROPERTY,
	RYGEL_HTTP_SERVER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_server_properties[RYGEL_HTTP_SERVER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _RygelHttpServerRunData RygelHttpServerRunData;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;

struct _RygelHTTPServerPrivate {
	gchar* _path_root;
	gchar* _server_name;
	GeeArrayList* requests;
	gboolean locally_hosted;
	GCancellable* _cancellable;
};

struct _RygelHttpServerRunData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelHTTPServer* self;
	GUPnPContext* _tmp0_;
	const gchar* _tmp1_;
	GUPnPContext* _tmp2_;
	SoupServer* _tmp3_;
	SoupServer* _tmp4_;
	GUPnPContext* _tmp5_;
	SoupServer* _tmp6_;
	SoupServer* _tmp7_;
	GUPnPContext* _tmp8_;
	SoupServer* _tmp9_;
	SoupServer* _tmp10_;
	GCancellable* _tmp11_;
	GCancellable* _tmp12_;
	GCancellable* _tmp13_;
	GCancellable* _tmp14_;
};

static gint RygelHTTPServer_private_offset;
static gpointer rygel_http_server_parent_class = NULL;
static RygelStateMachineIface * rygel_http_server_rygel_state_machine_parent_iface = NULL;

VALA_EXTERN gchar* rygel_http_server_get_protocol (RygelHTTPServer* self);
VALA_EXTERN GeeArrayList* rygel_http_server_get_protocol_info (RygelHTTPServer* self);
static void rygel_http_server_set_path_root (RygelHTTPServer* self,
                                      const gchar* value);
static void _g_free0_ (gpointer var);
static void rygel_http_server_real_run_data_free (gpointer _data);
static void rygel_http_server_real_run (RygelStateMachine* base,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* _data_);
static void rygel_http_server_server_handler (RygelHTTPServer* self,
                                       SoupServer* server,
                                       SoupMessage* msg,
                                       const gchar* server_path,
                                       GHashTable* query,
                                       SoupClientContext* soup_client);
static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server,
                                                             SoupMessage* msg,
                                                             const gchar* path,
                                                             GHashTable* query,
                                                             SoupClientContext* client,
                                                             gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self,
                                           SoupServer* server,
                                           SoupMessage* message,
                                           SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender,
                                                                        SoupMessage* msg,
                                                                        SoupClientContext* client,
                                                                        gpointer self);
static void rygel_http_server_on_request_started (RygelHTTPServer* self,
                                           SoupServer* server,
                                           SoupMessage* message,
                                           SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender,
                                                                        SoupMessage* msg,
                                                                        SoupClientContext* client,
                                                                        gpointer self);
static void rygel_http_server_on_request_read (RygelHTTPServer* self,
                                        SoupServer* server,
                                        SoupMessage* message,
                                        SoupClientContext* client);
static void _rygel_http_server_on_request_read_soup_server_request_read (SoupServer* _sender,
                                                                  SoupMessage* msg,
                                                                  SoupClientContext* client,
                                                                  gpointer self);
static void rygel_http_server_on_cancelled (RygelHTTPServer* self,
                                     GCancellable* cancellable);
static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                              gpointer self);
VALA_EXTERN gchar* rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                                RygelMediaObject* object,
                                                gint thumbnail_index,
                                                gint subtitle_index,
                                                const gchar* resource_name);
static gchar* rygel_http_server_real_get_protocol (RygelHTTPServer* self);
static GeeArrayList* rygel_http_server_real_get_protocol_info (RygelHTTPServer* self);
static void rygel_http_server_on_request_completed (RygelHTTPServer* self,
                                             RygelStateMachine* machine);
static void __lambda12_ (RygelHTTPServer* self,
                  const gchar* name,
                  const gchar* value);
static void ___lambda12__soup_message_headers_foreach_func (const gchar* name,
                                                     const gchar* value,
                                                     gpointer self);
static void rygel_http_server_queue_request (RygelHTTPServer* self,
                                      RygelHTTPRequest* request);
static void rygel_http_server_on_got_headers (RygelHTTPServer* self,
                                       SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender,
                                                                 gpointer self);
VALA_EXTERN RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server,
                                    SoupServer* server,
                                    SoupMessage* msg);
VALA_EXTERN RygelHTTPPost* rygel_http_post_construct (GType object_type,
                                          RygelHTTPServer* http_server,
                                          SoupServer* server,
                                          SoupMessage* msg);
VALA_EXTERN GType rygel_http_post_get_type (void) G_GNUC_CONST ;
static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender,
                                                                            gpointer self);
static void rygel_http_server_finalize (GObject * obj);
static GType rygel_http_server_get_type_once (void);
static void _vala_rygel_http_server_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_rygel_http_server_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_server_get_instance_private (RygelHTTPServer* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPServer_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

RygelHTTPServer*
rygel_http_server_construct (GType object_type,
                             RygelContentDirectory* content_dir,
                             const gchar* name)
{
	RygelHTTPServer * self = NULL;
	RygelMediaContainer* _tmp6_;
	RygelMediaContainer* _tmp7_;
	GUPnPContext* _tmp8_;
	GUPnPContext* _tmp9_;
	GUPnPContext* _tmp10_;
	GeeArrayList* _tmp11_;
	GCancellable* _tmp12_;
	GUPnPContext* _tmp13_;
	GInetAddress* _tmp14_;
	GInetAddress* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	GUPnPContext* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GHashTable* _tmp26_;
	gchar* _tmp27_;
	GUPnPContext* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GHashTable* _tmp31_;
	gchar* _tmp32_;
	GUPnPContext* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	GHashTable* _tmp37_;
	gchar* _tmp38_;
	GUPnPContext* _tmp39_;
	guint _tmp40_;
	guint _tmp41_;
	gchar* _tmp42_;
	GHashTable* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (content_dir != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (RygelHTTPServer*) g_object_new (object_type, NULL);
	{
		RygelMetaConfig* config = NULL;
		RygelMetaConfig* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = rygel_meta_config_get_default ();
		config = _tmp0_;
		_tmp2_ = rygel_configuration_get_string ((RygelConfiguration*) config, name, "server-name", &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (config);
			goto __catch0_g_error;
		}
		rygel_http_server_set_server_name (self, _tmp1_);
		_g_free0 (_tmp1_);
		_g_object_unref0 (config);
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_get_prgname ();
		_tmp4_ = g_strdup_printf (RYGEL_HTTP_SERVER_SERVER_TEMPLATE, name, PACKAGE_VERSION, _tmp3_, PACKAGE_VERSION);
		_tmp5_ = _tmp4_;
		rygel_http_server_set_server_name (self, _tmp5_);
		_g_free0 (_tmp5_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = content_dir->root_container;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->root_container);
	self->root_container = _tmp7_;
	_tmp8_ = gupnp_service_info_get_context ((GUPnPServiceInfo*) content_dir);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->context);
	self->context = _tmp10_;
	_tmp11_ = gee_array_list_new (RYGEL_TYPE_HTTP_REQUEST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->requests);
	self->priv->requests = _tmp11_;
	_tmp12_ = content_dir->cancellable;
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, _tmp12_);
	_tmp13_ = self->context;
	_tmp14_ = gssdp_client_get_address ((GSSDPClient*) _tmp13_);
	_tmp15_ = _tmp14_;
	self->priv->locally_hosted = g_inet_address_get_is_loopback (_tmp15_);
	_g_object_unref0 (_tmp15_);
	_tmp16_ = g_strconcat ("/", name, NULL);
	_tmp17_ = _tmp16_;
	rygel_http_server_set_path_root (self, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, _g_free0_);
	_g_hash_table_unref0 (self->replacements);
	self->replacements = _tmp20_;
	_tmp21_ = self->replacements;
	_tmp22_ = g_strdup ("@SERVICE_ADDRESS@");
	_tmp23_ = self->context;
	g_object_get ((GSSDPClient*) _tmp23_, "host-ip", &_tmp24_, NULL);
	_tmp25_ = _tmp24_;
	g_hash_table_insert (_tmp21_, _tmp22_, _tmp25_);
	_tmp26_ = self->replacements;
	_tmp27_ = g_strdup ("@ADDRESS@");
	_tmp28_ = self->context;
	g_object_get ((GSSDPClient*) _tmp28_, "host-ip", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	g_hash_table_insert (_tmp26_, _tmp27_, _tmp30_);
	_tmp31_ = self->replacements;
	_tmp32_ = g_strdup ("@SERVICE_INTERFACE@");
	_tmp33_ = self->context;
	_tmp34_ = gssdp_client_get_interface ((GSSDPClient*) _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_strdup (_tmp35_);
	g_hash_table_insert (_tmp31_, _tmp32_, _tmp36_);
	_tmp37_ = self->replacements;
	_tmp38_ = g_strdup ("@SERVICE_PORT@");
	_tmp39_ = self->context;
	_tmp40_ = gupnp_context_get_port (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strdup_printf ("%u", _tmp41_);
	g_hash_table_insert (_tmp37_, _tmp38_, _tmp42_);
	_tmp43_ = self->replacements;
	_tmp44_ = g_strdup ("@HOSTNAME@");
	_tmp45_ = g_get_host_name ();
	_tmp46_ = g_strdup (_tmp45_);
	g_hash_table_insert (_tmp43_, _tmp44_, _tmp46_);
	return self;
}

RygelHTTPServer*
rygel_http_server_new (RygelContentDirectory* content_dir,
                       const gchar* name)
{
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, content_dir, name);
}

static void
rygel_http_server_real_run_data_free (gpointer _data)
{
	RygelHttpServerRunData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelHttpServerRunData, _data_);
}

static void
rygel_http_server_real_run (RygelStateMachine* base,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	RygelHTTPServer * self;
	RygelHttpServerRunData* _data_;
	RygelHTTPServer* _tmp0_;
	self = (RygelHTTPServer*) base;
	_data_ = g_slice_new0 (RygelHttpServerRunData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_http_server_real_run_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_http_server_real_run_co (_data_);
}

static void
rygel_http_server_run_finish (RygelStateMachine* base,
                              GAsyncResult* _res_)
{
	RygelHttpServerRunData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
_rygel_http_server_server_handler_soup_server_callback (SoupServer* server,
                                                        SoupMessage* msg,
                                                        const gchar* path,
                                                        GHashTable* query,
                                                        SoupClientContext* client,
                                                        gpointer self)
{
	rygel_http_server_server_handler ((RygelHTTPServer*) self, server, msg, path, query, client);
}

static void
_rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender,
                                                                   SoupMessage* msg,
                                                                   SoupClientContext* client,
                                                                   gpointer self)
{
	rygel_http_server_on_request_aborted ((RygelHTTPServer*) self, _sender, msg, client);
}

static void
_rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender,
                                                                   SoupMessage* msg,
                                                                   SoupClientContext* client,
                                                                   gpointer self)
{
	rygel_http_server_on_request_started ((RygelHTTPServer*) self, _sender, msg, client);
}

static void
_rygel_http_server_on_request_read_soup_server_request_read (SoupServer* _sender,
                                                             SoupMessage* msg,
                                                             SoupClientContext* client,
                                                             gpointer self)
{
	rygel_http_server_on_request_read ((RygelHTTPServer*) self, _sender, msg, client);
}

static void
_rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender,
                                                         gpointer self)
{
	rygel_http_server_on_cancelled ((RygelHTTPServer*) self, _sender);
}

static gboolean
rygel_http_server_real_run_co (RygelHttpServerRunData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->context;
	_data_->_tmp1_ = _data_->self->priv->_path_root;
	gupnp_context_add_server_handler (_data_->_tmp0_, TRUE, _data_->_tmp1_, _rygel_http_server_server_handler_soup_server_callback, g_object_ref (_data_->self), g_object_unref);
	_data_->_tmp2_ = _data_->self->context;
	_data_->_tmp3_ = gupnp_context_get_server (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_signal_connect_object (_data_->_tmp4_, "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, _data_->self, 0);
	_data_->_tmp5_ = _data_->self->context;
	_data_->_tmp6_ = gupnp_context_get_server (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_signal_connect_object (_data_->_tmp7_, "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, _data_->self, 0);
	_data_->_tmp8_ = _data_->self->context;
	_data_->_tmp9_ = gupnp_context_get_server (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	g_signal_connect_object (_data_->_tmp10_, "request-read", (GCallback) _rygel_http_server_on_request_read_soup_server_request_read, _data_->self, 0);
	_data_->_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _data_->self);
		_data_->_tmp14_ = _data_->_tmp13_;
		g_signal_connect_object (_data_->_tmp14_, "cancelled", (GCallback) _rygel_http_server_on_cancelled_g_cancellable_cancelled, _data_->self, 0);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Set or unset options the server supports/doesn't support
     *
     * Resources should be setup assuming server supports all optional
     * delivery modes
     */
void
rygel_http_server_set_resource_delivery_options (RygelHTTPServer* self,
                                                 RygelMediaResource* res)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GUPnPDLNAFlags _tmp2_;
	GUPnPDLNAFlags _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	_tmp0_ = rygel_http_server_get_protocol (self);
	_tmp1_ = _tmp0_;
	rygel_media_resource_set_protocol (res, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = rygel_media_resource_get_dlna_flags (res);
	_tmp3_ = _tmp2_;
	rygel_media_resource_set_dlna_flags (res, _tmp3_ | GUPNP_DLNA_FLAGS_DLNA_V15);
}

gboolean
rygel_http_server_need_proxy (RygelHTTPServer* self,
                              const gchar* uri)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = g_uri_parse_scheme (uri);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strcmp0 (_tmp1_, "http") != 0;
	_g_free0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static void
rygel_http_server_on_cancelled (RygelHTTPServer* self,
                                GCancellable* cancellable)
{
	GCancellable* _tmp0_;
	GCancellable* _tmp1_;
	GUPnPContext* _tmp2_;
	SoupServer* _tmp3_;
	SoupServer* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cancellable != NULL);
	_tmp0_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) self);
	_tmp1_ = _tmp0_;
	g_cancellable_cancel (_tmp1_);
	_tmp2_ = self->context;
	_tmp3_ = gupnp_context_get_server (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->_path_root;
	soup_server_remove_handler (_tmp4_, _tmp5_);
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
}

gchar*
rygel_http_server_create_uri_for_object (RygelHTTPServer* self,
                                         RygelMediaObject* object,
                                         gint thumbnail_index,
                                         gint subtitle_index,
                                         const gchar* resource_name)
{
	RygelHTTPItemURI* uri = NULL;
	RygelHTTPItemURI* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object != NULL, NULL);
	_tmp0_ = rygel_http_item_uri_new (object, self, thumbnail_index, subtitle_index, resource_name);
	uri = _tmp0_;
	_tmp1_ = rygel_http_item_uri_to_string (uri);
	result = _tmp1_;
	_g_object_unref0 (uri);
	return result;
}

static gchar*
rygel_http_server_real_get_protocol (RygelHTTPServer* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("http-get");
	result = _tmp0_;
	return result;
}

gchar*
rygel_http_server_get_protocol (RygelHTTPServer* self)
{
	RygelHTTPServerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_HTTP_SERVER_GET_CLASS (self);
	if (_klass_->get_protocol) {
		return _klass_->get_protocol (self);
	}
	return NULL;
}

static GeeArrayList*
rygel_http_server_real_get_protocol_info (RygelHTTPServer* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	_tmp0_ = gee_array_list_new (gupnp_protocol_info_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	result = _tmp0_;
	return result;
}

GeeArrayList*
rygel_http_server_get_protocol_info (RygelHTTPServer* self)
{
	RygelHTTPServerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_HTTP_SERVER_GET_CLASS (self);
	if (_klass_->get_protocol_info) {
		return _klass_->get_protocol_info (self);
	}
	return NULL;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

GHashTable*
rygel_http_server_get_replacements (RygelHTTPServer* self)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->replacements;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
rygel_http_server_is_local (RygelHTTPServer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->locally_hosted;
	return result;
}

static void
rygel_http_server_on_request_completed (RygelHTTPServer* self,
                                        RygelStateMachine* machine)
{
	RygelHTTPRequest* request = NULL;
	RygelHTTPRequest* _tmp0_;
	GeeArrayList* _tmp1_;
	SoupMessage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SoupMessage* _tmp6_;
	SoupURI* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (machine != NULL);
	_tmp0_ = _g_object_ref0 (RYGEL_IS_HTTP_REQUEST (machine) ? ((RygelHTTPRequest*) machine) : NULL);
	request = _tmp0_;
	_tmp1_ = self->priv->requests;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, request);
	_tmp2_ = request->msg;
	g_object_get (_tmp2_, "method", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = request->msg;
	_tmp7_ = soup_message_get_uri (_tmp6_);
	_tmp8_ = soup_uri_to_string (_tmp7_, FALSE);
	_tmp9_ = _tmp8_;
	g_debug ("rygel-http-server.vala:154: HTTP %s request for URI '%s' handled.", _tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_g_object_unref0 (request);
}

static void
__lambda12_ (RygelHTTPServer* self,
             const gchar* name,
             const gchar* value)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	g_debug ("rygel-http-server.vala:173:     %s : %s", name, value);
}

static void
___lambda12__soup_message_headers_foreach_func (const gchar* name,
                                                const gchar* value,
                                                gpointer self)
{
	__lambda12_ ((RygelHTTPServer*) self, name, value);
}

static void
rygel_http_server_server_handler (RygelHTTPServer* self,
                                  SoupServer* server,
                                  SoupMessage* msg,
                                  const gchar* server_path,
                                  GHashTable* query,
                                  SoupClientContext* soup_client)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SoupURI* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	SoupMessageHeaders* _tmp10_;
	RygelHTTPGet* _tmp11_;
	RygelHTTPGet* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (msg != NULL);
	g_return_if_fail (server_path != NULL);
	g_return_if_fail (soup_client != NULL);
	g_object_get (msg, "method", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "POST") == 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		return;
	}
	g_object_get (msg, "method", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = soup_message_get_uri (msg);
	_tmp8_ = soup_uri_to_string (_tmp7_, FALSE);
	_tmp9_ = _tmp8_;
	g_debug ("rygel-http-server.vala:169: HTTP %s request for URI '%s'. Headers:", _tmp6_, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_tmp10_ = msg->request_headers;
	soup_message_headers_foreach (_tmp10_, ___lambda12__soup_message_headers_foreach_func, self);
	_tmp11_ = rygel_http_get_new (self, server, msg);
	_tmp12_ = _tmp11_;
	rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp12_);
	_g_object_unref0 (_tmp12_);
}

static void
rygel_http_server_on_request_aborted (RygelHTTPServer* self,
                                      SoupServer* server,
                                      SoupMessage* message,
                                      SoupClientContext* client)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (client != NULL);
	{
		GeeArrayList* _request_list = NULL;
		GeeArrayList* _tmp0_;
		gint _request_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _request_index = 0;
		_tmp0_ = self->priv->requests;
		_request_list = _tmp0_;
		_tmp1_ = _request_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_request_size = _tmp3_;
		_request_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			RygelHTTPRequest* request = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			RygelHTTPRequest* _tmp8_;
			SoupMessage* _tmp9_;
			_request_index = _request_index + 1;
			_tmp4_ = _request_index;
			_tmp5_ = _request_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _request_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _request_index);
			request = (RygelHTTPRequest*) _tmp7_;
			_tmp8_ = request;
			_tmp9_ = _tmp8_->msg;
			if (_tmp9_ == message) {
				RygelHTTPRequest* _tmp10_;
				GCancellable* _tmp11_;
				GCancellable* _tmp12_;
				RygelHTTPRequest* _tmp13_;
				SoupMessage* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				RygelHTTPRequest* _tmp18_;
				SoupMessage* _tmp19_;
				SoupURI* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp10_ = request;
				_tmp11_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp10_);
				_tmp12_ = _tmp11_;
				g_cancellable_cancel (_tmp12_);
				_tmp13_ = request;
				_tmp14_ = _tmp13_->msg;
				g_object_get (_tmp14_, "method", &_tmp15_, NULL);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp18_ = request;
				_tmp19_ = _tmp18_->msg;
				_tmp20_ = soup_message_get_uri (_tmp19_);
				_tmp21_ = soup_uri_to_string (_tmp20_, FALSE);
				_tmp22_ = _tmp21_;
				g_debug ("rygel-http-server.vala:185: HTTP client aborted %s request for URI '%s" \
"'.", _tmp17_, _tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp17_);
				_g_object_unref0 (request);
				break;
			}
			_g_object_unref0 (request);
		}
	}
}

static void
_rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender,
                                                            gpointer self)
{
	rygel_http_server_on_got_headers ((RygelHTTPServer*) self, _sender);
}

static void
rygel_http_server_on_request_started (RygelHTTPServer* self,
                                      SoupServer* server,
                                      SoupMessage* message,
                                      SoupClientContext* client)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (client != NULL);
	g_signal_connect_object (message, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
}

static void
rygel_http_server_on_request_read (RygelHTTPServer* self,
                                   SoupServer* server,
                                   SoupMessage* message,
                                   SoupClientContext* client)
{
	gchar* agent = NULL;
	SoupMessageHeaders* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (client != NULL);
	_tmp0_ = message->request_headers;
	_tmp1_ = soup_message_headers_get_one (_tmp0_, "User-Agent");
	_tmp2_ = g_strdup (_tmp1_);
	agent = _tmp2_;
	_tmp3_ = agent;
	if (_tmp3_ == NULL) {
		gchar* host = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		GUPnPContext* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp4_ = soup_client_context_get_host (client);
		_tmp5_ = g_strdup (_tmp4_);
		host = _tmp5_;
		_tmp6_ = self->context;
		_tmp7_ = host;
		_tmp8_ = gssdp_client_guess_user_agent ((GSSDPClient*) _tmp6_, _tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (agent);
		agent = _tmp9_;
		_tmp10_ = agent;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			SoupMessageHeaders* _tmp13_;
			const gchar* _tmp14_;
			_tmp11_ = agent;
			_tmp12_ = soup_client_context_get_host (client);
			g_debug ("rygel-http-server.vala:209: Guessed user agent %s for %s", _tmp11_, _tmp12_);
			_tmp13_ = message->request_headers;
			_tmp14_ = agent;
			soup_message_headers_append (_tmp13_, "User-Agent", _tmp14_);
		} else {
			const gchar* _tmp15_;
			_tmp15_ = host;
			g_debug ("rygel-http-server.vala:212: Could not guess user agent for ip %s.", _tmp15_);
		}
		_g_free0 (host);
	}
	_g_free0 (agent);
}

static void
rygel_http_server_on_got_headers (RygelHTTPServer* self,
                                  SoupMessage* msg)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	g_object_get (msg, "method", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "POST") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		SoupURI* _tmp5_;
		SoupURI* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = soup_message_get_uri (msg);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->path;
		_tmp8_ = self->priv->_path_root;
		_tmp0_ = g_str_has_prefix (_tmp7_, _tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SoupURI* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GUPnPContext* _tmp12_;
		SoupServer* _tmp13_;
		SoupServer* _tmp14_;
		RygelHTTPPost* _tmp15_;
		RygelHTTPPost* _tmp16_;
		_tmp9_ = soup_message_get_uri (msg);
		_tmp10_ = soup_uri_to_string (_tmp9_, FALSE);
		_tmp11_ = _tmp10_;
		g_debug ("rygel-http-server.vala:221: HTTP POST request for URI '%s'", _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = self->context;
		_tmp13_ = gupnp_context_get_server (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = rygel_http_post_new (self, _tmp14_, msg);
		_tmp16_ = _tmp15_;
		rygel_http_server_queue_request (self, (RygelHTTPRequest*) _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
}

static void
_rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelStateMachine* _sender,
                                                                       gpointer self)
{
	rygel_http_server_on_request_completed ((RygelHTTPServer*) self, _sender);
}

static void
rygel_http_server_queue_request (RygelHTTPServer* self,
                                 RygelHTTPRequest* request)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (request != NULL);
	g_signal_connect_object ((RygelStateMachine*) request, "completed", (GCallback) _rygel_http_server_on_request_completed_rygel_state_machine_completed, self, 0);
	_tmp0_ = self->priv->requests;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, request);
	rygel_state_machine_run ((RygelStateMachine*) request, NULL, NULL);
}

const gchar*
rygel_http_server_get_path_root (RygelHTTPServer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_path_root;
	result = _tmp0_;
	return result;
}

static void
rygel_http_server_set_path_root (RygelHTTPServer* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_server_get_path_root (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_path_root);
		self->priv->_path_root = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_server_properties[RYGEL_HTTP_SERVER_PATH_ROOT_PROPERTY]);
	}
}

const gchar*
rygel_http_server_get_server_name (RygelHTTPServer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_server_name;
	result = _tmp0_;
	return result;
}

void
rygel_http_server_set_server_name (RygelHTTPServer* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_server_get_server_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_server_name);
		self->priv->_server_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_server_properties[RYGEL_HTTP_SERVER_SERVER_NAME_PROPERTY]);
	}
}

static GCancellable*
rygel_http_server_real_get_cancellable (RygelStateMachine* base)
{
	GCancellable* result;
	RygelHTTPServer* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPServer*) base;
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
rygel_http_server_real_set_cancellable (RygelStateMachine* base,
                                        GCancellable* value)
{
	RygelHTTPServer* self;
	GCancellable* old_value;
	self = (RygelHTTPServer*) base;
	old_value = rygel_http_server_real_get_cancellable (base);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_server_properties[RYGEL_HTTP_SERVER_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_http_server_class_init (RygelHTTPServerClass * klass,
                              gpointer klass_data)
{
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPServer_private_offset);
	((RygelHTTPServerClass *) klass)->get_protocol = (gchar* (*) (RygelHTTPServer*)) rygel_http_server_real_get_protocol;
	((RygelHTTPServerClass *) klass)->get_protocol_info = (GeeArrayList* (*) (RygelHTTPServer*)) rygel_http_server_real_get_protocol_info;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_server_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT_PROPERTY, rygel_http_server_properties[RYGEL_HTTP_SERVER_PATH_ROOT_PROPERTY] = g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_SERVER_NAME_PROPERTY, rygel_http_server_properties[RYGEL_HTTP_SERVER_SERVER_NAME_PROPERTY] = g_param_spec_string ("server-name", "server-name", "server-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_CANCELLABLE_PROPERTY, rygel_http_server_properties[RYGEL_HTTP_SERVER_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_http_server_rygel_state_machine_interface_init (RygelStateMachineIface * iface,
                                                      gpointer iface_data)
{
	rygel_http_server_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = (void (*) (RygelStateMachine*, GAsyncReadyCallback, gpointer)) rygel_http_server_real_run;
	iface->run_finish = (void (*) (RygelStateMachine*, GAsyncResult*)) rygel_http_server_run_finish;
	iface->get_cancellable = rygel_http_server_real_get_cancellable;
	iface->set_cancellable = rygel_http_server_real_set_cancellable;
}

static void
rygel_http_server_instance_init (RygelHTTPServer * self,
                                 gpointer klass)
{
	self->priv = rygel_http_server_get_instance_private (self);
}

static void
rygel_http_server_finalize (GObject * obj)
{
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	_g_free0 (self->priv->_path_root);
	_g_free0 (self->priv->_server_name);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->priv->requests);
	_g_hash_table_unref0 (self->replacements);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}

static GType
rygel_http_server_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
	static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_server_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType rygel_http_server_type_id;
	rygel_http_server_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPServer", &g_define_type_info, 0);
	g_type_add_interface_static (rygel_http_server_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	RygelHTTPServer_private_offset = g_type_add_instance_private (rygel_http_server_type_id, sizeof (RygelHTTPServerPrivate));
	return rygel_http_server_type_id;
}

GType
rygel_http_server_get_type (void)
{
	static volatile gsize rygel_http_server_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_server_type_id__once)) {
		GType rygel_http_server_type_id;
		rygel_http_server_type_id = rygel_http_server_get_type_once ();
		g_once_init_leave (&rygel_http_server_type_id__once, rygel_http_server_type_id);
	}
	return rygel_http_server_type_id__once;
}

static void
_vala_rygel_http_server_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT_PROPERTY:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_SERVER_NAME_PROPERTY:
		g_value_set_string (value, rygel_http_server_get_server_name (self));
		break;
		case RYGEL_HTTP_SERVER_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_server_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	RygelHTTPServer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT_PROPERTY:
		rygel_http_server_set_path_root (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_SERVER_SERVER_NAME_PROPERTY:
		rygel_http_server_set_server_name (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_SERVER_CANCELLABLE_PROPERTY:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

