/* operation.c generated by valac 0.56.1, the Vala compiler
 * generated from operation.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <signal.h>
#include <sys/types.h>
#include <fcntl.h>
#include "seahorse-common.h"
#include <unistd.h>
#include "config.h"
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>

enum  {
	SEAHORSE_SSH_OPERATION_0_PROPERTY,
	SEAHORSE_SSH_OPERATION_STD_OUT_PROPERTY,
	SEAHORSE_SSH_OPERATION_STD_ERR_PROPERTY,
	SEAHORSE_SSH_OPERATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_operation_properties[SEAHORSE_SSH_OPERATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _SeahorseSshOperationOperationAsyncData SeahorseSshOperationOperationAsyncData;
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
typedef struct _Block8Data Block8Data;
enum  {
	SEAHORSE_SSH_UPLOAD_OPERATION_0_PROPERTY,
	SEAHORSE_SSH_UPLOAD_OPERATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_upload_operation_properties[SEAHORSE_SSH_UPLOAD_OPERATION_NUM_PROPERTIES];
typedef struct _Block9Data Block9Data;
typedef struct _SeahorseSshUploadOperationUploadAsyncData SeahorseSshUploadOperationUploadAsyncData;
enum  {
	SEAHORSE_SSH_CHANGE_PASSPHRASE_OPERATION_0_PROPERTY,
	SEAHORSE_SSH_CHANGE_PASSPHRASE_OPERATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_change_passphrase_operation_properties[SEAHORSE_SSH_CHANGE_PASSPHRASE_OPERATION_NUM_PROPERTIES];
typedef struct _SeahorseSshChangePassphraseOperationChangePassphraseAsyncData SeahorseSshChangePassphraseOperationChangePassphraseAsyncData;
enum  {
	SEAHORSE_SSH_GENERATE_OPERATION_0_PROPERTY,
	SEAHORSE_SSH_GENERATE_OPERATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_generate_operation_properties[SEAHORSE_SSH_GENERATE_OPERATION_NUM_PROPERTIES];
typedef struct _SeahorseSshGenerateOperationGenerateAsyncData SeahorseSshGenerateOperationGenerateAsyncData;
enum  {
	SEAHORSE_SSH_PRIVATE_IMPORT_OPERATION_0_PROPERTY,
	SEAHORSE_SSH_PRIVATE_IMPORT_OPERATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_private_import_operation_properties[SEAHORSE_SSH_PRIVATE_IMPORT_OPERATION_NUM_PROPERTIES];
typedef struct _SeahorseSshPrivateImportOperationImportPrivateAsyncData SeahorseSshPrivateImportOperationImportPrivateAsyncData;
enum  {
	SEAHORSE_SSH_RENAME_OPERATION_0_PROPERTY,
	SEAHORSE_SSH_RENAME_OPERATION_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_rename_operation_properties[SEAHORSE_SSH_RENAME_OPERATION_NUM_PROPERTIES];
typedef struct _SeahorseSshRenameOperationRenameAsyncData SeahorseSshRenameOperationRenameAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorseSshOperationPrivate {
	gchar* command_name;
	GString* _std_out;
	GString* _std_err;
	GPid pid;
};

struct _Block7Data {
	int _ref_count_;
	SeahorseSshOperation* self;
	GString* std_in;
};

struct _SeahorseSshOperationOperationAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshOperation* self;
	gchar* command;
	gchar* input;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* e;
	GError* _tmp6_;
	GError* _tmp7_;
	gint* fin;
	gint* fout;
	gint* ferr;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GPid _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint* _tmp14_;
	gint _tmp15_;
	gint* _tmp16_;
	gint _tmp17_;
	gint* _tmp18_;
	gulong cancelled_sig;
	Block7Data* _data7_;
	GString* _tmp19_;
	const gchar* _tmp20_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	GString* _tmp23_;
	gint* _tmp24_;
	GString* _tmp25_;
	GString* _tmp26_;
	gint* _tmp27_;
	GString* _tmp28_;
	GString* _tmp29_;
	gint* _tmp30_;
	GError* _inner_error0_;
};

struct _Block8Data {
	int _ref_count_;
	SeahorseSshOperation* self;
	GCancellable* cancellable;
	gulong cancelled_sig;
};

struct _Block9Data {
	int _ref_count_;
	SeahorseSshUploadOperation* self;
	GString* data;
	gpointer _async_data_;
};

struct _SeahorseSshUploadOperationUploadAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshUploadOperation* self;
	GList* keys;
	gchar* username;
	gchar* hostname;
	gchar* port;
	GCancellable* cancellable;
	Block9Data* _data9_;
	gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	gchar* cmd;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _SeahorseSshChangePassphraseOperationChangePassphraseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshChangePassphraseOperation* self;
	SeahorseSshKey* key;
	GCancellable* cancellable;
	gboolean _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	SeahorseSshKeyData* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* cmd;
	SeahorseSshKeyData* _tmp11_;
	SeahorseSshKeyData* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_;
};

struct _SeahorseSshGenerateOperationGenerateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshGenerateOperation* self;
	gchar* filename;
	gchar* email;
	SeahorseSshAlgorithm type;
	guint bits;
	GCancellable* cancellable;
	GError* _tmp0_;
	gchar* _tmp1_;
	gchar* algo;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* bits_str;
	gchar* _tmp9_;
	gchar* comment;
	gchar* _tmp10_;
	gchar* cmd;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _SeahorseSshPrivateImportOperationImportPrivateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshPrivateImportOperation* self;
	SeahorseSshSource* source;
	SeahorseSshSecData* data;
	gchar* filename;
	GCancellable* cancellable;
	gchar* result;
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SeahorseSshAlgorithm _tmp6_;
	SeahorseSshAlgorithm _tmp7_;
	gchar* _tmp8_;
	gchar* file;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* message;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* cmd;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gint pos;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	GString* _tmp30_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	GString* _tmp33_;
	GString* _tmp34_;
	SeahorseSshKeyData* keydata;
	GString* _tmp35_;
	GString* _tmp36_;
	const gchar* _tmp37_;
	SeahorseSshKeyData* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	GString* _tmp41_;
	GString* _tmp42_;
	GString* _tmp43_;
	GString* _tmp44_;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* pubfile;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	const gchar* _tmp49_;
	GString* _tmp50_;
	GString* _tmp51_;
	const gchar* _tmp52_;
	gboolean _tmp53_;
	SeahorseSshKeyData* _tmp54_;
	SeahorseSshKeyData* _tmp55_;
	SeahorseSshKeyData* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	GError* _tmp60_;
	GError* _inner_error0_;
};

struct _SeahorseSshRenameOperationRenameAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshRenameOperation* self;
	SeahorseSshKey* key;
	gchar* new_comment;
	GtkWindow* transient_for;
	SeahorseSshKeyData* keydata;
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp4_;
	SeahorseSshKeyData* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	SeahorseSshKeyData* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	SeahorseSshKeyData* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	SeahorseSshKeyData* _tmp14_;
	SeahorseSshKeyData* _tmp15_;
	SeahorseSshKeyData* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	SeahorseSshKeyData* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_;
};

static gint SeahorseSshOperation_private_offset;
static gpointer seahorse_ssh_operation_parent_class = NULL;
static gpointer seahorse_ssh_upload_operation_parent_class = NULL;
static gpointer seahorse_ssh_change_passphrase_operation_parent_class = NULL;
static gpointer seahorse_ssh_generate_operation_parent_class = NULL;
static gpointer seahorse_ssh_private_import_operation_parent_class = NULL;
static gpointer seahorse_ssh_rename_operation_parent_class = NULL;

static void seahorse_ssh_operation_operation_async_data_free (gpointer _data);
static gboolean seahorse_ssh_operation_operation_async_co (SeahorseSshOperationOperationAsyncData* _data_);
static void seahorse_ssh_operation_on_spawn_setup_child (SeahorseSshOperation* self);
static void _seahorse_ssh_operation_on_spawn_setup_child_gspawn_child_setup_func (gpointer self);
static gint* _int_dup (gint* self);
static void ___lambda5_ (SeahorseSshOperation* self);
static void ____lambda5__gfunc (gconstpointer data,
                         gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void seahorse_ssh_operation_create_io_channel (SeahorseSshOperation* self,
                                               GString* data,
                                               gint handle,
                                               GIOCondition io_cond,
                                               GIOFunc io_func,
                                               gpointer io_func_target,
                                               GError** error);
static gboolean ___lambda6_ (Block7Data* _data7_,
                      GIOChannel* io,
                      GIOCondition cond);
static gboolean seahorse_ssh_operation_on_io_ssh_write (SeahorseSshOperation* self,
                                                 GIOChannel* source,
                                                 GIOCondition condition,
                                                 GString* input);
static gboolean ____lambda6__gio_func (GIOChannel* source,
                                GIOCondition condition,
                                gpointer self);
static gboolean __lambda7_ (SeahorseSshOperation* self,
                     GIOChannel* io,
                     GIOCondition cond);
static gboolean seahorse_ssh_operation_on_io_ssh_read (SeahorseSshOperation* self,
                                                GIOChannel* source,
                                                GIOCondition condition,
                                                GString* data);
static gboolean ___lambda7__gio_func (GIOChannel* source,
                               GIOCondition condition,
                               gpointer self);
static gboolean __lambda8_ (SeahorseSshOperation* self,
                     GIOChannel* io,
                     GIOCondition cond);
static gboolean ___lambda8__gio_func (GIOChannel* source,
                               GIOCondition condition,
                               gpointer self);
static void seahorse_ssh_operation_watch_ssh_process (SeahorseSshOperation* self,
                                               GCancellable* cancellable,
                                               gulong cancelled_sig,
                                               GError** error);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda9_ (Block8Data* _data8_,
                 GPid pid,
                 gint status);
static void ___lambda9__gchild_watch_func (GPid pid,
                                    gint wait_status,
                                    gpointer self);
static void seahorse_ssh_operation_finalize (GObject * obj);
static GType seahorse_ssh_operation_get_type_once (void);
static void _vala_seahorse_ssh_operation_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void seahorse_ssh_upload_operation_upload_async_data_free (gpointer _data);
static gboolean seahorse_ssh_upload_operation_upload_async_co (SeahorseSshUploadOperationUploadAsyncData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda25_ (Block9Data* _data9_,
                  SeahorseSshKey* key);
static void ___lambda25__gfunc (gconstpointer data,
                         gpointer self);
static void seahorse_ssh_upload_operation_upload_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static GType seahorse_ssh_upload_operation_get_type_once (void);
static void seahorse_ssh_change_passphrase_operation_change_passphrase_async_data_free (gpointer _data);
static gboolean seahorse_ssh_change_passphrase_operation_change_passphrase_async_co (SeahorseSshChangePassphraseOperationChangePassphraseAsyncData* _data_);
static void seahorse_ssh_change_passphrase_operation_change_passphrase_async_ready (GObject* source_object,
                                                                             GAsyncResult* _res_,
                                                                             gpointer _user_data_);
static GType seahorse_ssh_change_passphrase_operation_get_type_once (void);
static void seahorse_ssh_generate_operation_generate_async_data_free (gpointer _data);
static gboolean seahorse_ssh_generate_operation_generate_async_co (SeahorseSshGenerateOperationGenerateAsyncData* _data_);
static void seahorse_ssh_generate_operation_generate_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static GType seahorse_ssh_generate_operation_get_type_once (void);
static void seahorse_ssh_private_import_operation_import_private_async_data_free (gpointer _data);
static gboolean seahorse_ssh_private_import_operation_import_private_async_co (SeahorseSshPrivateImportOperationImportPrivateAsyncData* _data_);
static void seahorse_ssh_private_import_operation_import_private_async_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
static GType seahorse_ssh_private_import_operation_get_type_once (void);
static void seahorse_ssh_rename_operation_rename_async_data_free (gpointer _data);
static gboolean seahorse_ssh_rename_operation_rename_async_co (SeahorseSshRenameOperationRenameAsyncData* _data_);
static gboolean seahorse_ssh_rename_operation_change_raw_comment (SeahorseSshRenameOperation* self,
                                                           SeahorseSshKeyData* keydata,
                                                           const gchar* new_comment);
VALA_EXTERN void seahorse_ssh_key_data_set_rawdata (SeahorseSshKeyData* self,
                                        const gchar* value);
static GType seahorse_ssh_rename_operation_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_operation_get_instance_private (SeahorseSshOperation* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshOperation_private_offset);
}

static void
seahorse_ssh_operation_operation_async_data_free (gpointer _data)
{
	SeahorseSshOperationOperationAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->command);
	_g_free0 (_data_->input);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshOperationOperationAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_ssh_operation_operation_async (SeahorseSshOperation* self,
                                        const gchar* command,
                                        const gchar* input,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	SeahorseSshOperationOperationAsyncData* _data_;
	SeahorseSshOperation* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command != NULL);
	_data_ = g_slice_new0 (SeahorseSshOperationOperationAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_operation_operation_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (command);
	_g_free0 (_data_->command);
	_data_->command = _tmp1_;
	_tmp2_ = g_strdup (input);
	_g_free0 (_data_->input);
	_data_->input = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	seahorse_ssh_operation_operation_async_co (_data_);
}

void
seahorse_ssh_operation_operation_finish (SeahorseSshOperation* self,
                                         GAsyncResult* _res_,
                                         GError** error)
{
	SeahorseSshOperationOperationAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Calls a command and returns the output.
     *
     * @param command The command that should be launched.
     * @param input The standard input for the command, or null if none expected.
     * @param cancellable Can be used if you want to cancel. The process will be killed.
     * @return The output of the command.
     */
static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
_seahorse_ssh_operation_on_spawn_setup_child_gspawn_child_setup_func (gpointer self)
{
	seahorse_ssh_operation_on_spawn_setup_child ((SeahorseSshOperation*) self);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
___lambda5_ (SeahorseSshOperation* self)
{
	kill ((pid_t) self->priv->pid, (gint) SIGTERM);
}

static void
____lambda5__gfunc (gconstpointer data,
                    gpointer self)
{
	___lambda5_ ((SeahorseSshOperation*) self);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		SeahorseSshOperation* self;
		self = _data7_->self;
		_g_string_free0 (_data7_->std_in);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
___lambda6_ (Block7Data* _data7_,
             GIOChannel* io,
             GIOCondition cond)
{
	SeahorseSshOperation* self;
	GString* _tmp0_;
	gboolean result;
	self = _data7_->self;
	g_return_val_if_fail (io != NULL, FALSE);
	_tmp0_ = _data7_->std_in;
	result = seahorse_ssh_operation_on_io_ssh_write (self, io, cond, _tmp0_);
	return result;
}

static gboolean
____lambda6__gio_func (GIOChannel* source,
                       GIOCondition condition,
                       gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self, source, condition);
	return result;
}

static gboolean
__lambda7_ (SeahorseSshOperation* self,
            GIOChannel* io,
            GIOCondition cond)
{
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean result;
	g_return_val_if_fail (io != NULL, FALSE);
	_tmp0_ = seahorse_ssh_operation_get_std_out (self);
	_tmp1_ = _tmp0_;
	result = seahorse_ssh_operation_on_io_ssh_read (self, io, cond, _tmp1_);
	return result;
}

static gboolean
___lambda7__gio_func (GIOChannel* source,
                      GIOCondition condition,
                      gpointer self)
{
	gboolean result;
	result = __lambda7_ ((SeahorseSshOperation*) self, source, condition);
	return result;
}

static gboolean
__lambda8_ (SeahorseSshOperation* self,
            GIOChannel* io,
            GIOCondition cond)
{
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean result;
	g_return_val_if_fail (io != NULL, FALSE);
	_tmp0_ = seahorse_ssh_operation_get_std_err (self);
	_tmp1_ = _tmp0_;
	result = seahorse_ssh_operation_on_io_ssh_read (self, io, cond, _tmp1_);
	return result;
}

static gboolean
___lambda8__gio_func (GIOChannel* source,
                      GIOCondition condition,
                      gpointer self)
{
	gboolean result;
	result = __lambda8_ ((SeahorseSshOperation*) self, source, condition);
	return result;
}

static gboolean
seahorse_ssh_operation_operation_async_co (SeahorseSshOperationOperationAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->command == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = g_strcmp0 (_data_->command, "") == 0;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->args_length1 = 0;
	_data_->_args_size_ = 0;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp2_ = 0;
		g_shell_parse_argv (_data_->command, &_data_->_tmp2_, &_data_->_tmp1_, &_data_->_inner_error0_);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		_data_->args = _data_->_tmp1_;
		_data_->args_length1 = _data_->_tmp2_;
		_data_->_args_size_ = _data_->args_length1;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->args;
		_data_->_tmp3__length1 = _data_->args_length1;
		_data_->_tmp4_ = _data_->_tmp3_[0];
		_data_->_tmp5_ = g_strdup (_data_->_tmp4_);
		_g_free0 (_data_->self->priv->command_name);
		_data_->self->priv->command_name = _data_->_tmp5_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		g_critical ("operation.vala:68: Couldn't parse SSH command line %s.", _data_->command);
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _g_error_copy0 (_data_->_tmp6_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("operation.vala:72: SSHOP: Executing SSH command: %s", _data_->command);
	if (_data_->input != NULL) {
		_g_free0 (_data_->fin);
		_data_->fin = NULL;
	}
	_data_->_tmp8_ = _data_->args;
	_data_->_tmp8__length1 = _data_->args_length1;
	_data_->_tmp9_ = 0;
	_data_->_tmp10_ = 0;
	_data_->_tmp11_ = 0;
	_data_->_tmp12_ = 0;
	g_spawn_async_with_pipes (NULL, _data_->_tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_LEAVE_DESCRIPTORS_OPEN, _seahorse_ssh_operation_on_spawn_setup_child_gspawn_child_setup_func, _data_->self, &_data_->_tmp9_, &_data_->_tmp10_, &_data_->_tmp11_, &_data_->_tmp12_, &_data_->_inner_error0_);
	_data_->self->priv->pid = _data_->_tmp9_;
	_g_free0 (_data_->fin);
	_data_->_tmp13_ = _data_->_tmp10_;
	_data_->_tmp14_ = __int_dup0 (&_data_->_tmp13_);
	_data_->fin = _data_->_tmp14_;
	_g_free0 (_data_->fout);
	_data_->_tmp15_ = _data_->_tmp11_;
	_data_->_tmp16_ = __int_dup0 (&_data_->_tmp15_);
	_data_->fout = _data_->_tmp16_;
	_g_free0 (_data_->ferr);
	_data_->_tmp17_ = _data_->_tmp12_;
	_data_->_tmp18_ = __int_dup0 (&_data_->_tmp17_);
	_data_->ferr = _data_->_tmp18_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->ferr);
		_g_free0 (_data_->fout);
		_g_free0 (_data_->fin);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->cancelled_sig = (gulong) 0;
	if (_data_->cancellable != NULL) {
		_data_->cancelled_sig = g_cancellable_connect (_data_->cancellable, (GCallback) ____lambda5__gfunc, g_object_ref (_data_->self), g_object_unref);
	}
	if (_data_->input != NULL) {
		_data_->_data7_ = g_slice_new0 (Block7Data);
		_data_->_data7_->_ref_count_ = 1;
		_data_->_data7_->self = g_object_ref (_data_->self);
		_data_->_tmp19_ = g_string_new (_data_->input);
		_data_->_data7_->std_in = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->self->priv->command_name;
		_data_->_tmp21_ = _data_->_data7_->std_in;
		_data_->_tmp22_ = _data_->_tmp21_->str;
		g_debug ("operation.vala:96: Sending input to '%s': '%s'", _data_->_tmp20_, _data_->_tmp22_);
		_data_->_tmp23_ = _data_->_data7_->std_in;
		_data_->_tmp24_ = _data_->fin;
		seahorse_ssh_operation_create_io_channel (_data_->self, _data_->_tmp23_, *_data_->_tmp24_, G_IO_OUT | G_IO_HUP, ____lambda6__gio_func, _data_->_data7_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block7_data_unref (_data_->_data7_);
			_data_->_data7_ = NULL;
			_g_free0 (_data_->ferr);
			_g_free0 (_data_->fout);
			_g_free0 (_data_->fin);
			_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		block7_data_unref (_data_->_data7_);
		_data_->_data7_ = NULL;
	}
	_data_->_tmp25_ = seahorse_ssh_operation_get_std_out (_data_->self);
	_data_->_tmp26_ = _data_->_tmp25_;
	_data_->_tmp27_ = _data_->fout;
	seahorse_ssh_operation_create_io_channel (_data_->self, _data_->_tmp26_, *_data_->_tmp27_, G_IO_IN | G_IO_HUP, ___lambda7__gio_func, _data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->ferr);
		_g_free0 (_data_->fout);
		_g_free0 (_data_->fin);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp28_ = seahorse_ssh_operation_get_std_err (_data_->self);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->ferr;
	seahorse_ssh_operation_create_io_channel (_data_->self, _data_->_tmp29_, *_data_->_tmp30_, G_IO_IN | G_IO_HUP, ___lambda8__gio_func, _data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->ferr);
		_g_free0 (_data_->fout);
		_g_free0 (_data_->fin);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_ssh_operation_watch_ssh_process (_data_->self, _data_->cancellable, _data_->cancelled_sig, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->ferr);
		_g_free0 (_data_->fout);
		_g_free0 (_data_->fin);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->ferr);
	_g_free0 (_data_->fout);
	_g_free0 (_data_->fin);
	_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_ssh_operation_create_io_channel (SeahorseSshOperation* self,
                                          GString* data,
                                          gint handle,
                                          GIOCondition io_cond,
                                          GIOFunc io_func,
                                          gpointer io_func_target,
                                          GError** error)
{
	GIOChannel* io_channel = NULL;
	GIOChannel* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	fcntl (handle, F_SETFL, O_NONBLOCK | fcntl (handle, F_GETFL, NULL), NULL);
	_tmp0_ = g_io_channel_unix_new (handle);
	io_channel = _tmp0_;
	g_io_channel_set_encoding (io_channel, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_io_channel_unref0 (io_channel);
		return;
	}
	g_io_channel_set_close_on_unref (io_channel, TRUE);
	g_io_add_watch (io_channel, io_cond, io_func, io_func_target);
	_g_io_channel_unref0 (io_channel);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		SeahorseSshOperation* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda9_ (Block8Data* _data8_,
            GPid pid,
            gint status)
{
	SeahorseSshOperation* self;
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	_tmp0_ = self->priv->command_name;
	g_debug ("operation.vala:124: Process '%s' done.", _tmp0_);
	{
		g_spawn_check_exit_status (status, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		const gchar* _tmp1_;
		GString* _tmp2_;
		GString* _tmp3_;
		const gchar* _tmp4_;
		g_clear_error (&_inner_error0_);
		_tmp1_ = self->prompt_title;
		_tmp2_ = seahorse_ssh_operation_get_std_err (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->str;
		seahorse_util_show_error (NULL, _tmp1_, _tmp4_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_cancellable_disconnect (_data8_->cancellable, _data8_->cancelled_sig);
	g_spawn_close_pid (pid);
}

static void
___lambda9__gchild_watch_func (GPid pid,
                               gint wait_status,
                               gpointer self)
{
	__lambda9_ (self, pid, wait_status);
}

static void
seahorse_ssh_operation_watch_ssh_process (SeahorseSshOperation* self,
                                          GCancellable* cancellable,
                                          gulong cancelled_sig,
                                          GError** error)
{
	Block8Data* _data8_;
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data8_->cancellable);
	_data8_->cancellable = _tmp0_;
	_data8_->cancelled_sig = cancelled_sig;
	g_child_watch_add_full (G_PRIORITY_DEFAULT, self->priv->pid, ___lambda9__gchild_watch_func, block8_data_ref (_data8_), block8_data_unref);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
seahorse_ssh_operation_on_io_ssh_read (SeahorseSshOperation* self,
                                       GIOChannel* source,
                                       GIOCondition condition,
                                       GString* data)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (data != NULL, FALSE);
	{
		GIOStatus status = 0;
		status = G_IO_STATUS_NORMAL;
		while (TRUE) {
			gchar* buf = NULL;
			GIOStatus _tmp0_ = 0;
			gchar* _tmp1_ = NULL;
			GIOStatus _tmp2_;
			gboolean _tmp3_ = FALSE;
			if (!(status != G_IO_STATUS_EOF)) {
				break;
			}
			_tmp2_ = g_io_channel_read_line (source, &_tmp1_, NULL, NULL, &_inner_error0_);
			_g_free0 (buf);
			buf = _tmp1_;
			_tmp0_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (buf);
				goto __catch0_g_error;
			}
			status = _tmp0_;
			if (status == G_IO_STATUS_NORMAL) {
				const gchar* _tmp4_;
				_tmp4_ = buf;
				_tmp3_ = _tmp4_ != NULL;
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp5_ = buf;
				g_string_append (data, _tmp5_);
				_tmp6_ = data->str;
				_tmp7_ = buf;
				_tmp8_ = strlen (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = string_substring (_tmp6_, (glong) _tmp9_, (glong) -1);
				_tmp11_ = _tmp10_;
				g_debug ("operation.vala:146: %s", _tmp11_);
				_g_free0 (_tmp11_);
			}
			_g_free0 (buf);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("operation.vala:150: Couldn't read output of SSH command. Error: %s", _tmp13_);
		kill ((pid_t) self->priv->pid, (gint) SIGTERM);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp14_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = TRUE;
	return result;
}

static gchar*
string_to_utf8 (const gchar* self,
                gint* result_length1)
{
	gint string_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _result_ = NULL;
	gchar* _tmp2_;
	gint _result__length1;
	gint __result__size_;
	gint _tmp3_;
	gchar* _tmp4_;
	gint _tmp4__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = _tmp1_;
	_tmp2_ = g_new0 (gchar, string_length + 1);
	_result_ = _tmp2_;
	_result__length1 = string_length + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	memcpy (_result_, self, (gsize) string_length);
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static gboolean
seahorse_ssh_operation_on_io_ssh_write (SeahorseSshOperation* self,
                                        GIOChannel* source,
                                        GIOCondition condition,
                                        GString* input)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	g_debug ("operation.vala:163: SSHOP: SSH ready for input");
	{
		gsize written = 0UL;
		GIOStatus status = 0;
		const gchar* _tmp0_;
		gint _tmp1_ = 0;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gint _tmp3__length1;
		gsize _tmp4_ = 0UL;
		GIOStatus _tmp5_;
		GIOStatus _tmp6_;
		written = (gsize) 0;
		_tmp0_ = input->str;
		_tmp2_ = string_to_utf8 (_tmp0_, &_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = _tmp1_;
		_tmp5_ = g_io_channel_write_chars (source, _tmp3_, (gint) _tmp1_, &_tmp4_, &_inner_error0_);
		written = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp3_ = (g_free (_tmp3_), NULL);
		status = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (status != G_IO_STATUS_AGAIN) {
			g_debug ("operation.vala:168: SSHOP: Wrote %u bytes to SSH", (guint) written);
			g_string_erase (input, (gssize) 0, (gssize) written);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("operation.vala:172: Couldn't write to STDIN of SSH command. Error: %s", _tmp8_);
		kill ((pid_t) self->priv->pid, (gint) SIGTERM);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = TRUE;
	return result;
}

static void
seahorse_ssh_operation_on_spawn_setup_child (SeahorseSshOperation* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	setsid ();
	_tmp0_ = g_build_filename (EXECDIR, "ssh-askpass", NULL);
	_tmp1_ = _tmp0_;
	g_setenv ("SSH_ASKPASS", _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = g_getenv ("LC_ALL");
	if (_tmp2_ != NULL) {
		g_setenv ("LC_ALL", "C", TRUE);
	}
	g_setenv ("LANG", "C", TRUE);
	_tmp3_ = self->prompt_title;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = self->prompt_title;
		g_setenv ("SEAHORSE_SSH_ASKPASS_TITLE", _tmp4_, TRUE);
	}
	_tmp5_ = self->prompt_message;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = self->prompt_message;
		g_setenv ("SEAHORSE_SSH_ASKPASS_MESSAGE", _tmp6_, TRUE);
	}
	if (self->prompt_transient_for != ((gulong) 0)) {
		gchar* parent = NULL;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = g_strdup_printf ("%lu", self->prompt_transient_for);
		parent = _tmp7_;
		_tmp8_ = parent;
		g_setenv ("SEAHORSE_SSH_ASKPASS_PARENT", _tmp8_, TRUE);
		_g_free0 (parent);
	}
}

SeahorseSshOperation*
seahorse_ssh_operation_construct (GType object_type)
{
	SeahorseSshOperation * self = NULL;
	self = (SeahorseSshOperation*) g_object_new (object_type, NULL);
	return self;
}

GString*
seahorse_ssh_operation_get_std_out (SeahorseSshOperation* self)
{
	GString* result;
	GString* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_std_out;
	result = _tmp0_;
	return result;
}

GString*
seahorse_ssh_operation_get_std_err (SeahorseSshOperation* self)
{
	GString* result;
	GString* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_std_err;
	result = _tmp0_;
	return result;
}

static void
seahorse_ssh_operation_class_init (SeahorseSshOperationClass * klass,
                                   gpointer klass_data)
{
	seahorse_ssh_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshOperation_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_operation_get_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_OPERATION_STD_OUT_PROPERTY, seahorse_ssh_operation_properties[SEAHORSE_SSH_OPERATION_STD_OUT_PROPERTY] = g_param_spec_boxed ("std-out", "std-out", "std-out", G_TYPE_GSTRING, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_OPERATION_STD_ERR_PROPERTY, seahorse_ssh_operation_properties[SEAHORSE_SSH_OPERATION_STD_ERR_PROPERTY] = g_param_spec_boxed ("std-err", "std-err", "std-err", G_TYPE_GSTRING, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_ssh_operation_instance_init (SeahorseSshOperation * self,
                                      gpointer klass)
{
	GString* _tmp0_;
	GString* _tmp1_;
	self->priv = seahorse_ssh_operation_get_instance_private (self);
	_tmp0_ = g_string_new ("");
	self->priv->_std_out = _tmp0_;
	_tmp1_ = g_string_new ("");
	self->priv->_std_err = _tmp1_;
}

static void
seahorse_ssh_operation_finalize (GObject * obj)
{
	SeahorseSshOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_OPERATION, SeahorseSshOperation);
	_g_free0 (self->priv->command_name);
	_g_string_free0 (self->priv->_std_out);
	_g_string_free0 (self->priv->_std_err);
	_g_free0 (self->prompt_title);
	_g_free0 (self->prompt_message);
	_g_free0 (self->prompt_argument);
	G_OBJECT_CLASS (seahorse_ssh_operation_parent_class)->finalize (obj);
}

/**
 * Wraps a command-line executable in its own async method.
 *
 * Since OpenSSH doesn't provide a library (or didn't at the time of writing),
 * we use a small wrapper around the ssh and ssh-keygen executables.
 * So, create a subclass instead and do whatever you want with the output.
 */
 G_GNUC_NO_INLINE static GType
seahorse_ssh_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshOperation), 0, (GInstanceInitFunc) seahorse_ssh_operation_instance_init, NULL };
	GType seahorse_ssh_operation_type_id;
	seahorse_ssh_operation_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSshOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	SeahorseSshOperation_private_offset = g_type_add_instance_private (seahorse_ssh_operation_type_id, sizeof (SeahorseSshOperationPrivate));
	return seahorse_ssh_operation_type_id;
}

GType
seahorse_ssh_operation_get_type (void)
{
	static volatile gsize seahorse_ssh_operation_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_operation_type_id__once)) {
		GType seahorse_ssh_operation_type_id;
		seahorse_ssh_operation_type_id = seahorse_ssh_operation_get_type_once ();
		g_once_init_leave (&seahorse_ssh_operation_type_id__once, seahorse_ssh_operation_type_id);
	}
	return seahorse_ssh_operation_type_id__once;
}

static void
_vala_seahorse_ssh_operation_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SeahorseSshOperation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_OPERATION, SeahorseSshOperation);
	switch (property_id) {
		case SEAHORSE_SSH_OPERATION_STD_OUT_PROPERTY:
		g_value_set_boxed (value, seahorse_ssh_operation_get_std_out (self));
		break;
		case SEAHORSE_SSH_OPERATION_STD_ERR_PROPERTY:
		g_value_set_boxed (value, seahorse_ssh_operation_get_std_err (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
seahorse_ssh_upload_operation_upload_async_data_free (gpointer _data)
{
	SeahorseSshUploadOperationUploadAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->username);
	_g_free0 (_data_->hostname);
	_g_free0 (_data_->port);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshUploadOperationUploadAsyncData, _data_);
}

void
seahorse_ssh_upload_operation_upload_async (SeahorseSshUploadOperation* self,
                                            GList* keys,
                                            const gchar* username,
                                            const gchar* hostname,
                                            const gchar* port,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SeahorseSshUploadOperationUploadAsyncData* _data_;
	SeahorseSshUploadOperation* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (hostname != NULL);
	_data_ = g_slice_new0 (SeahorseSshUploadOperationUploadAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_upload_operation_upload_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->keys = keys;
	_tmp1_ = g_strdup (username);
	_g_free0 (_data_->username);
	_data_->username = _tmp1_;
	_tmp2_ = g_strdup (hostname);
	_g_free0 (_data_->hostname);
	_data_->hostname = _tmp2_;
	_tmp3_ = g_strdup (port);
	_g_free0 (_data_->port);
	_data_->port = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_ssh_upload_operation_upload_async_co (_data_);
}

void
seahorse_ssh_upload_operation_upload_finish (SeahorseSshUploadOperation* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	SeahorseSshUploadOperationUploadAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Uploads a set of keys to a given host.
     *
     * @param keys The keys that should be uploaded.
     * @param username The username to use on the server.
     * @param hostname The URL of the host.
     * @param port The port of the host. If none is specified, the default port is used.
     * @param cancellable Used if you want to cancel the operation.
     */
static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		SeahorseSshUploadOperation* self;
		self = _data9_->self;
		_g_string_free0 (_data9_->data);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda25_ (Block9Data* _data9_,
             SeahorseSshKey* key)
{
	SeahorseSshUploadOperation* self;
	SeahorseSshKeyData* keydata = NULL;
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	gboolean _tmp3_ = FALSE;
	SeahorseSshKeyData* _tmp4_;
	self = _data9_->self;
	g_return_if_fail (key != NULL);
	_tmp0_ = seahorse_ssh_key_get_key_data (key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keydata = _tmp2_;
	_tmp4_ = keydata;
	if (_tmp4_ != NULL) {
		SeahorseSshKeyData* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = keydata;
		_tmp6_ = seahorse_ssh_key_data_get_pubfile (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GString* _tmp8_;
		SeahorseSshKeyData* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GString* _tmp12_;
		_tmp8_ = _data9_->data;
		_tmp9_ = keydata;
		_tmp10_ = seahorse_ssh_key_data_get_rawdata (_tmp9_);
		_tmp11_ = _tmp10_;
		g_string_append (_tmp8_, _tmp11_);
		_tmp12_ = _data9_->data;
		g_string_append_c (_tmp12_, '\n');
	}
	_g_object_unref0 (keydata);
}

static void
___lambda25__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda25_ (self, (SeahorseSshKey*) data);
}

static void
seahorse_ssh_upload_operation_upload_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	SeahorseSshUploadOperationUploadAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_upload_operation_upload_async_co (_data_);
}

static gboolean
seahorse_ssh_upload_operation_upload_async_co (SeahorseSshUploadOperationUploadAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strdup (_ ("Remote Host Password"));
	_g_free0 (((SeahorseSshOperation*) _data_->self)->prompt_title);
	((SeahorseSshOperation*) _data_->self)->prompt_title = _data_->_tmp0_;
	if (_data_->keys == NULL) {
		_data_->_tmp4_ = TRUE;
	} else {
		_data_->_tmp4_ = _data_->username == NULL;
	}
	if (_data_->_tmp4_) {
		_data_->_tmp3_ = TRUE;
	} else {
		_data_->_tmp3_ = g_strcmp0 (_data_->username, "") == 0;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp2_ = _data_->hostname == NULL;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = g_strcmp0 (_data_->hostname, "") == 0;
	}
	if (_data_->_tmp1_) {
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->port == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_data_->port);
		_data_->port = _tmp5_;
	}
	_data_->_tmp6_ = g_string_sized_new ((gsize) 1024);
	_data_->_data9_->data = _data_->_tmp6_;
	g_list_foreach (_data_->keys, ___lambda25__gfunc, _data_->_data9_);
	if (g_strcmp0 (_data_->port, "") != 0) {
		_data_->_tmp7_ = "-p";
	} else {
		_data_->_tmp7_ = "";
	}
	_data_->_tmp8_ = g_strdup_printf ("%s '%s@%s' %s %s -o StrictHostKeyChecking=no \"umask 077; test -d .ssh" \
" || mkdir .ssh ; cat >> .ssh/authorized_keys\"", SSH_PATH, _data_->username, _data_->hostname, _data_->_tmp7_, _data_->port);
	_data_->cmd = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->cmd;
	_data_->_tmp10_ = _data_->_data9_->data;
	_data_->_tmp11_ = _data_->_tmp10_->str;
	_data_->_state_ = 1;
	seahorse_ssh_operation_operation_async ((SeahorseSshOperation*) _data_->self, _data_->_tmp9_, _data_->_tmp11_, _data_->cancellable, seahorse_ssh_upload_operation_upload_async_ready, _data_);
	return FALSE;
	_state_1:
	seahorse_ssh_operation_operation_finish ((SeahorseSshOperation*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->cmd);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->cmd);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshUploadOperation*
seahorse_ssh_upload_operation_construct (GType object_type)
{
	SeahorseSshUploadOperation * self = NULL;
	self = (SeahorseSshUploadOperation*) seahorse_ssh_operation_construct (object_type);
	return self;
}

SeahorseSshUploadOperation*
seahorse_ssh_upload_operation_new (void)
{
	return seahorse_ssh_upload_operation_construct (SEAHORSE_SSH_TYPE_UPLOAD_OPERATION);
}

static void
seahorse_ssh_upload_operation_class_init (SeahorseSshUploadOperationClass * klass,
                                          gpointer klass_data)
{
	seahorse_ssh_upload_operation_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_ssh_upload_operation_instance_init (SeahorseSshUploadOperation * self,
                                             gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_upload_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshUploadOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_upload_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshUploadOperation), 0, (GInstanceInitFunc) seahorse_ssh_upload_operation_instance_init, NULL };
	GType seahorse_ssh_upload_operation_type_id;
	seahorse_ssh_upload_operation_type_id = g_type_register_static (SEAHORSE_SSH_TYPE_OPERATION, "SeahorseSshUploadOperation", &g_define_type_info, 0);
	return seahorse_ssh_upload_operation_type_id;
}

GType
seahorse_ssh_upload_operation_get_type (void)
{
	static volatile gsize seahorse_ssh_upload_operation_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_upload_operation_type_id__once)) {
		GType seahorse_ssh_upload_operation_type_id;
		seahorse_ssh_upload_operation_type_id = seahorse_ssh_upload_operation_get_type_once ();
		g_once_init_leave (&seahorse_ssh_upload_operation_type_id__once, seahorse_ssh_upload_operation_type_id);
	}
	return seahorse_ssh_upload_operation_type_id__once;
}

static void
seahorse_ssh_change_passphrase_operation_change_passphrase_async_data_free (gpointer _data)
{
	SeahorseSshChangePassphraseOperationChangePassphraseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->key);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshChangePassphraseOperationChangePassphraseAsyncData, _data_);
}

void
seahorse_ssh_change_passphrase_operation_change_passphrase_async (SeahorseSshChangePassphraseOperation* self,
                                                                  SeahorseSshKey* key,
                                                                  GCancellable* cancellable,
                                                                  GAsyncReadyCallback _callback_,
                                                                  gpointer _user_data_)
{
	SeahorseSshChangePassphraseOperationChangePassphraseAsyncData* _data_;
	SeahorseSshChangePassphraseOperation* _tmp0_;
	SeahorseSshKey* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_data_ = g_slice_new0 (SeahorseSshChangePassphraseOperationChangePassphraseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_change_passphrase_operation_change_passphrase_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (key);
	_g_object_unref0 (_data_->key);
	_data_->key = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_ssh_change_passphrase_operation_change_passphrase_async_co (_data_);
}

void
seahorse_ssh_change_passphrase_operation_change_passphrase_finish (SeahorseSshChangePassphraseOperation* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error)
{
	SeahorseSshChangePassphraseOperationChangePassphraseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Changes the passphrase of the given key.
     *
     * @param key The key of which to change the passphrase.
     * @param cancellable Used if you want to cancel the operation.
     */
static void
seahorse_ssh_change_passphrase_operation_change_passphrase_async_ready (GObject* source_object,
                                                                        GAsyncResult* _res_,
                                                                        gpointer _user_data_)
{
	SeahorseSshChangePassphraseOperationChangePassphraseAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_change_passphrase_operation_change_passphrase_async_co (_data_);
}

static gboolean
seahorse_ssh_change_passphrase_operation_change_passphrase_async_co (SeahorseSshChangePassphraseOperationChangePassphraseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = seahorse_ssh_key_get_key_data (_data_->key);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp3_ = seahorse_ssh_key_get_key_data (_data_->key);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = seahorse_ssh_key_data_get_privfile (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp0_ = _data_->_tmp6_ == NULL;
	}
	if (_data_->_tmp0_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = g_strdup (_ ("Enter Key Passphrase"));
	_g_free0 (((SeahorseSshOperation*) _data_->self)->prompt_title);
	((SeahorseSshOperation*) _data_->self)->prompt_title = _data_->_tmp7_;
	_data_->_tmp8_ = seahorse_object_get_label ((SeahorseObject*) _data_->key);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
	_g_free0 (((SeahorseSshOperation*) _data_->self)->prompt_argument);
	((SeahorseSshOperation*) _data_->self)->prompt_argument = _data_->_tmp10_;
	_data_->_tmp11_ = seahorse_ssh_key_get_key_data (_data_->key);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = seahorse_ssh_key_data_get_privfile (_data_->_tmp12_);
	_data_->_tmp14_ = _data_->_tmp13_;
	_data_->_tmp15_ = g_strdup_printf ("%s -p -f '%s'", SSH_KEYGEN_PATH, _data_->_tmp14_);
	_data_->cmd = _data_->_tmp15_;
	_data_->_tmp16_ = _data_->cmd;
	_data_->_state_ = 1;
	seahorse_ssh_operation_operation_async ((SeahorseSshOperation*) _data_->self, _data_->_tmp16_, NULL, _data_->cancellable, seahorse_ssh_change_passphrase_operation_change_passphrase_async_ready, _data_);
	return FALSE;
	_state_1:
	seahorse_ssh_operation_operation_finish ((SeahorseSshOperation*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->cmd);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->cmd);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshChangePassphraseOperation*
seahorse_ssh_change_passphrase_operation_construct (GType object_type)
{
	SeahorseSshChangePassphraseOperation * self = NULL;
	self = (SeahorseSshChangePassphraseOperation*) seahorse_ssh_operation_construct (object_type);
	return self;
}

SeahorseSshChangePassphraseOperation*
seahorse_ssh_change_passphrase_operation_new (void)
{
	return seahorse_ssh_change_passphrase_operation_construct (SEAHORSE_SSH_TYPE_CHANGE_PASSPHRASE_OPERATION);
}

static void
seahorse_ssh_change_passphrase_operation_class_init (SeahorseSshChangePassphraseOperationClass * klass,
                                                     gpointer klass_data)
{
	seahorse_ssh_change_passphrase_operation_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_ssh_change_passphrase_operation_instance_init (SeahorseSshChangePassphraseOperation * self,
                                                        gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_change_passphrase_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshChangePassphraseOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_change_passphrase_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshChangePassphraseOperation), 0, (GInstanceInitFunc) seahorse_ssh_change_passphrase_operation_instance_init, NULL };
	GType seahorse_ssh_change_passphrase_operation_type_id;
	seahorse_ssh_change_passphrase_operation_type_id = g_type_register_static (SEAHORSE_SSH_TYPE_OPERATION, "SeahorseSshChangePassphraseOperation", &g_define_type_info, 0);
	return seahorse_ssh_change_passphrase_operation_type_id;
}

GType
seahorse_ssh_change_passphrase_operation_get_type (void)
{
	static volatile gsize seahorse_ssh_change_passphrase_operation_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_change_passphrase_operation_type_id__once)) {
		GType seahorse_ssh_change_passphrase_operation_type_id;
		seahorse_ssh_change_passphrase_operation_type_id = seahorse_ssh_change_passphrase_operation_get_type_once ();
		g_once_init_leave (&seahorse_ssh_change_passphrase_operation_type_id__once, seahorse_ssh_change_passphrase_operation_type_id);
	}
	return seahorse_ssh_change_passphrase_operation_type_id__once;
}

static void
seahorse_ssh_generate_operation_generate_async_data_free (gpointer _data)
{
	SeahorseSshGenerateOperationGenerateAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_free0 (_data_->email);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshGenerateOperationGenerateAsyncData, _data_);
}

void
seahorse_ssh_generate_operation_generate_async (SeahorseSshGenerateOperation* self,
                                                const gchar* filename,
                                                const gchar* email,
                                                SeahorseSshAlgorithm type,
                                                guint bits,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SeahorseSshGenerateOperationGenerateAsyncData* _data_;
	SeahorseSshGenerateOperation* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (email != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (SeahorseSshGenerateOperationGenerateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_generate_operation_generate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	_tmp2_ = g_strdup (email);
	_g_free0 (_data_->email);
	_data_->email = _tmp2_;
	_data_->type = type;
	_data_->bits = bits;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	seahorse_ssh_generate_operation_generate_async_co (_data_);
}

void
seahorse_ssh_generate_operation_generate_finish (SeahorseSshGenerateOperation* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	SeahorseSshGenerateOperationGenerateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Generates an SSH key pair.
     *
     * @param filename The filename of the new key.
     * @param email The e-mail address for which the key should be made.
     * @param type The type of key, i.e. which algorithm should be used;
     * @param bits The amount of bits that should be used.
     * @param cancellable Used if you want to cancel the operation.
     */
static void
seahorse_ssh_generate_operation_generate_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SeahorseSshGenerateOperationGenerateAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_generate_operation_generate_async_co (_data_);
}

static gboolean
seahorse_ssh_generate_operation_generate_async_co (SeahorseSshGenerateOperationGenerateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->type == SEAHORSE_SSH_ALGORITHM_UNKNOWN) {
		_data_->_tmp0_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Can't generate key for an unknown algorithm");
		_data_->_inner_error0_ = _data_->_tmp0_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_strdup (_ ("Passphrase for New Secure Shell Key"));
	_g_free0 (((SeahorseSshOperation*) _data_->self)->prompt_title);
	((SeahorseSshOperation*) _data_->self)->prompt_title = _data_->_tmp1_;
	_data_->_tmp2_ = seahorse_ssh_algorithm_to_string (_data_->type);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_utf8_strdown (_data_->_tmp3_, (gssize) -1);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_data_->algo = _data_->_tmp5_;
	if (_data_->bits != ((guint) 0)) {
		_data_->_tmp7_ = g_strdup_printf ("-b '%u'", _data_->bits);
		_g_free0 (_data_->_tmp6_);
		_data_->_tmp6_ = _data_->_tmp7_;
	} else {
		_data_->_tmp8_ = g_strdup ("");
		_g_free0 (_data_->_tmp6_);
		_data_->_tmp6_ = _data_->_tmp8_;
	}
	_data_->_tmp9_ = g_strdup (_data_->_tmp6_);
	_data_->bits_str = _data_->_tmp9_;
	_data_->_tmp10_ = g_shell_quote (_data_->email);
	_data_->comment = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->algo;
	_data_->_tmp12_ = g_strdup_printf ("%s %s -t '%s' -C %s -f '%s'", SSH_KEYGEN_PATH, _data_->bits_str, _data_->_tmp11_, _data_->comment, _data_->filename);
	_data_->cmd = _data_->_tmp12_;
	_data_->_state_ = 1;
	seahorse_ssh_operation_operation_async ((SeahorseSshOperation*) _data_->self, _data_->cmd, NULL, _data_->cancellable, seahorse_ssh_generate_operation_generate_async_ready, _data_);
	return FALSE;
	_state_1:
	seahorse_ssh_operation_operation_finish ((SeahorseSshOperation*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->cmd);
		_g_free0 (_data_->comment);
		_g_free0 (_data_->bits_str);
		_g_free0 (_data_->_tmp6_);
		_g_free0 (_data_->algo);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->cmd);
	_g_free0 (_data_->comment);
	_g_free0 (_data_->bits_str);
	_g_free0 (_data_->_tmp6_);
	_g_free0 (_data_->algo);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshGenerateOperation*
seahorse_ssh_generate_operation_construct (GType object_type)
{
	SeahorseSshGenerateOperation * self = NULL;
	self = (SeahorseSshGenerateOperation*) seahorse_ssh_operation_construct (object_type);
	return self;
}

SeahorseSshGenerateOperation*
seahorse_ssh_generate_operation_new (void)
{
	return seahorse_ssh_generate_operation_construct (SEAHORSE_SSH_TYPE_GENERATE_OPERATION);
}

static void
seahorse_ssh_generate_operation_class_init (SeahorseSshGenerateOperationClass * klass,
                                            gpointer klass_data)
{
	seahorse_ssh_generate_operation_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_ssh_generate_operation_instance_init (SeahorseSshGenerateOperation * self,
                                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_generate_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshGenerateOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_generate_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshGenerateOperation), 0, (GInstanceInitFunc) seahorse_ssh_generate_operation_instance_init, NULL };
	GType seahorse_ssh_generate_operation_type_id;
	seahorse_ssh_generate_operation_type_id = g_type_register_static (SEAHORSE_SSH_TYPE_OPERATION, "SeahorseSshGenerateOperation", &g_define_type_info, 0);
	return seahorse_ssh_generate_operation_type_id;
}

GType
seahorse_ssh_generate_operation_get_type (void)
{
	static volatile gsize seahorse_ssh_generate_operation_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_generate_operation_type_id__once)) {
		GType seahorse_ssh_generate_operation_type_id;
		seahorse_ssh_generate_operation_type_id = seahorse_ssh_generate_operation_get_type_once ();
		g_once_init_leave (&seahorse_ssh_generate_operation_type_id__once, seahorse_ssh_generate_operation_type_id);
	}
	return seahorse_ssh_generate_operation_type_id__once;
}

static void
seahorse_ssh_private_import_operation_import_private_async_data_free (gpointer _data)
{
	SeahorseSshPrivateImportOperationImportPrivateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->source);
	_g_object_unref0 (_data_->data);
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshPrivateImportOperationImportPrivateAsyncData, _data_);
}

void
seahorse_ssh_private_import_operation_import_private_async (SeahorseSshPrivateImportOperation* self,
                                                            SeahorseSshSource* source,
                                                            SeahorseSshSecData* data,
                                                            const gchar* filename,
                                                            GCancellable* cancellable,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	SeahorseSshPrivateImportOperationImportPrivateAsyncData* _data_;
	SeahorseSshPrivateImportOperation* _tmp0_;
	SeahorseSshSource* _tmp1_;
	SeahorseSshSecData* _tmp2_;
	gchar* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (data != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (SeahorseSshPrivateImportOperationImportPrivateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_private_import_operation_import_private_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	_tmp2_ = _g_object_ref0 (data);
	_g_object_unref0 (_data_->data);
	_data_->data = _tmp2_;
	_tmp3_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	seahorse_ssh_private_import_operation_import_private_async_co (_data_);
}

gchar*
seahorse_ssh_private_import_operation_import_private_finish (SeahorseSshPrivateImportOperation* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	gchar* result;
	SeahorseSshPrivateImportOperationImportPrivateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Imports a private key into a file.
     *
     * @param source The source that will decide the location of the private key.
     * @param data The public key that needs to be imported.
     * @param filename The name of the file in which the key should be imported.
     * @param cancellable Allows the operation to be cancelled.
     */
static void
seahorse_ssh_private_import_operation_import_private_async_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	SeahorseSshPrivateImportOperationImportPrivateAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_private_import_operation_import_private_async_co (_data_);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
seahorse_ssh_private_import_operation_import_private_async_co (SeahorseSshPrivateImportOperationImportPrivateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->data == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp1_ = seahorse_ssh_sec_data_get_rawdata (_data_->data);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp0_ = _data_->_tmp2_ == NULL;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp3_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Trying to import private key that is empty.");
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = g_strdup (_data_->filename);
	_data_->_tmp4_ = _data_->_tmp5_;
	if (_data_->_tmp4_ == NULL) {
		_data_->_tmp6_ = seahorse_ssh_sec_data_get_algo (_data_->data);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = seahorse_ssh_source_new_filename_for_algorithm (_data_->source, _data_->_tmp7_);
		_g_free0 (_data_->_tmp4_);
		_data_->_tmp4_ = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->_tmp4_;
	_data_->_tmp4_ = NULL;
	_data_->file = _data_->_tmp9_;
	_data_->_tmp11_ = seahorse_ssh_sec_data_get_comment (_data_->data);
	_data_->_tmp12_ = _data_->_tmp11_;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = seahorse_ssh_sec_data_get_comment (_data_->data);
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp15_ = g_strdup_printf (_ ("Importing key: %s"), _data_->_tmp14_);
		_g_free0 (_data_->_tmp10_);
		_data_->_tmp10_ = _data_->_tmp15_;
	} else {
		_data_->_tmp16_ = g_strdup (_ ("Importing key. Enter passphrase"));
		_g_free0 (_data_->_tmp10_);
		_data_->_tmp10_ = _data_->_tmp16_;
	}
	_data_->_tmp17_ = g_strdup (_data_->_tmp10_);
	_data_->message = _data_->_tmp17_;
	_data_->_tmp18_ = g_strdup (_ ("Import Key"));
	_g_free0 (((SeahorseSshOperation*) _data_->self)->prompt_title);
	((SeahorseSshOperation*) _data_->self)->prompt_title = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->message;
	_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
	_g_free0 (((SeahorseSshOperation*) _data_->self)->prompt_message);
	((SeahorseSshOperation*) _data_->self)->prompt_message = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->file;
	_data_->_tmp22_ = seahorse_ssh_sec_data_get_rawdata (_data_->data);
	_data_->_tmp23_ = _data_->_tmp22_;
	g_file_set_contents (_data_->_tmp21_, _data_->_tmp23_, (gssize) -1, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->message);
		_g_free0 (_data_->_tmp10_);
		_g_free0 (_data_->file);
		_g_free0 (_data_->_tmp4_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp24_ = _data_->file;
	_data_->_tmp25_ = g_strdup_printf ("%s -y -f '%s'", SSH_KEYGEN_PATH, _data_->_tmp24_);
	_data_->cmd = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->cmd;
	_data_->_state_ = 1;
	seahorse_ssh_operation_operation_async ((SeahorseSshOperation*) _data_->self, _data_->_tmp26_, NULL, _data_->cancellable, seahorse_ssh_private_import_operation_import_private_async_ready, _data_);
	return FALSE;
	_state_1:
	seahorse_ssh_operation_operation_finish ((SeahorseSshOperation*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->cmd);
		_g_free0 (_data_->message);
		_g_free0 (_data_->_tmp10_);
		_g_free0 (_data_->file);
		_g_free0 (_data_->_tmp4_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = _data_->_tmp28_->str;
	_data_->_tmp30_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
	_data_->_tmp31_ = _data_->_tmp30_;
	_data_->_tmp32_ = _data_->_tmp31_->str;
	_data_->pos = MAX (string_index_of_char (_data_->_tmp29_, (gunichar) '\n', 0), string_index_of_char (_data_->_tmp32_, (gunichar) '\r', 0));
	if (_data_->pos != -1) {
		_data_->_tmp33_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
		_data_->_tmp34_ = _data_->_tmp33_;
		g_string_erase (_data_->_tmp34_, (gssize) _data_->pos, (gssize) -1);
	}
	_data_->_tmp35_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = _data_->_tmp36_->str;
	_data_->_tmp38_ = seahorse_ssh_key_data_parse_line (_data_->_tmp37_, &_data_->_inner_error0_);
	_data_->keydata = _data_->_tmp38_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->cmd);
		_g_free0 (_data_->message);
		_g_free0 (_data_->_tmp10_);
		_g_free0 (_data_->file);
		_g_free0 (_data_->_tmp4_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp39_ = seahorse_ssh_sec_data_get_comment (_data_->data);
	_data_->_tmp40_ = _data_->_tmp39_;
	if (_data_->_tmp40_ != NULL) {
		_data_->_tmp41_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
		_data_->_tmp42_ = _data_->_tmp41_;
		g_string_append_c (_data_->_tmp42_, ' ');
		_data_->_tmp43_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
		_data_->_tmp44_ = _data_->_tmp43_;
		_data_->_tmp45_ = seahorse_ssh_sec_data_get_comment (_data_->data);
		_data_->_tmp46_ = _data_->_tmp45_;
		g_string_append (_data_->_tmp44_, _data_->_tmp46_);
	}
	_data_->_tmp47_ = _data_->file;
	_data_->_tmp48_ = g_strdup_printf ("%s.pub", _data_->_tmp47_);
	_data_->pubfile = _data_->_tmp48_;
	_data_->_tmp49_ = _data_->pubfile;
	_data_->_tmp50_ = seahorse_ssh_operation_get_std_out ((SeahorseSshOperation*) _data_->self);
	_data_->_tmp51_ = _data_->_tmp50_;
	_data_->_tmp52_ = _data_->_tmp51_->str;
	g_file_set_contents (_data_->_tmp49_, _data_->_tmp52_, (gssize) -1, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->pubfile);
		_g_object_unref0 (_data_->keydata);
		_g_free0 (_data_->cmd);
		_g_free0 (_data_->message);
		_g_free0 (_data_->_tmp10_);
		_g_free0 (_data_->file);
		_g_free0 (_data_->_tmp4_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp54_ = _data_->keydata;
	if (_data_->_tmp54_ != NULL) {
		_data_->_tmp55_ = _data_->keydata;
		_data_->_tmp53_ = seahorse_ssh_key_data_is_valid (_data_->_tmp55_);
	} else {
		_data_->_tmp53_ = FALSE;
	}
	if (_data_->_tmp53_) {
		_data_->_tmp56_ = _data_->keydata;
		_data_->_tmp57_ = seahorse_ssh_key_data_get_fingerprint (_data_->_tmp56_);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = g_strdup (_data_->_tmp58_);
		_data_->result = _data_->_tmp59_;
		_g_free0 (_data_->pubfile);
		_g_object_unref0 (_data_->keydata);
		_g_free0 (_data_->cmd);
		_g_free0 (_data_->message);
		_g_free0 (_data_->_tmp10_);
		_g_free0 (_data_->file);
		_g_free0 (_data_->_tmp4_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp60_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Couldn't parse imported private key fingerprint");
	_data_->_inner_error0_ = _data_->_tmp60_;
	g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
	_g_free0 (_data_->pubfile);
	_g_object_unref0 (_data_->keydata);
	_g_free0 (_data_->cmd);
	_g_free0 (_data_->message);
	_g_free0 (_data_->_tmp10_);
	_g_free0 (_data_->file);
	_g_free0 (_data_->_tmp4_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshPrivateImportOperation*
seahorse_ssh_private_import_operation_construct (GType object_type)
{
	SeahorseSshPrivateImportOperation * self = NULL;
	self = (SeahorseSshPrivateImportOperation*) seahorse_ssh_operation_construct (object_type);
	return self;
}

SeahorseSshPrivateImportOperation*
seahorse_ssh_private_import_operation_new (void)
{
	return seahorse_ssh_private_import_operation_construct (SEAHORSE_SSH_TYPE_PRIVATE_IMPORT_OPERATION);
}

static void
seahorse_ssh_private_import_operation_class_init (SeahorseSshPrivateImportOperationClass * klass,
                                                  gpointer klass_data)
{
	seahorse_ssh_private_import_operation_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_ssh_private_import_operation_instance_init (SeahorseSshPrivateImportOperation * self,
                                                     gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_private_import_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshPrivateImportOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_private_import_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshPrivateImportOperation), 0, (GInstanceInitFunc) seahorse_ssh_private_import_operation_instance_init, NULL };
	GType seahorse_ssh_private_import_operation_type_id;
	seahorse_ssh_private_import_operation_type_id = g_type_register_static (SEAHORSE_SSH_TYPE_OPERATION, "SeahorseSshPrivateImportOperation", &g_define_type_info, 0);
	return seahorse_ssh_private_import_operation_type_id;
}

GType
seahorse_ssh_private_import_operation_get_type (void)
{
	static volatile gsize seahorse_ssh_private_import_operation_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_private_import_operation_type_id__once)) {
		GType seahorse_ssh_private_import_operation_type_id;
		seahorse_ssh_private_import_operation_type_id = seahorse_ssh_private_import_operation_get_type_once ();
		g_once_init_leave (&seahorse_ssh_private_import_operation_type_id__once, seahorse_ssh_private_import_operation_type_id);
	}
	return seahorse_ssh_private_import_operation_type_id__once;
}

static void
seahorse_ssh_rename_operation_rename_async_data_free (gpointer _data)
{
	SeahorseSshRenameOperationRenameAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->key);
	_g_free0 (_data_->new_comment);
	_g_object_unref0 (_data_->transient_for);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshRenameOperationRenameAsyncData, _data_);
}

void
seahorse_ssh_rename_operation_rename_async (SeahorseSshRenameOperation* self,
                                            SeahorseSshKey* key,
                                            const gchar* new_comment,
                                            GtkWindow* transient_for,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	SeahorseSshRenameOperationRenameAsyncData* _data_;
	SeahorseSshRenameOperation* _tmp0_;
	SeahorseSshKey* _tmp1_;
	gchar* _tmp2_;
	GtkWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (transient_for != NULL);
	_data_ = g_slice_new0 (SeahorseSshRenameOperationRenameAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_rename_operation_rename_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (key);
	_g_object_unref0 (_data_->key);
	_data_->key = _tmp1_;
	_tmp2_ = g_strdup (new_comment);
	_g_free0 (_data_->new_comment);
	_data_->new_comment = _tmp2_;
	_tmp3_ = _g_object_ref0 (transient_for);
	_g_object_unref0 (_data_->transient_for);
	_data_->transient_for = _tmp3_;
	seahorse_ssh_rename_operation_rename_async_co (_data_);
}

void
seahorse_ssh_rename_operation_rename_finish (SeahorseSshRenameOperation* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	SeahorseSshRenameOperationRenameAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Renames/Deletes the comment in a key.
     *
     * @param key The key that should have its comment renamed/deleted.
     * @param new_comment The new comment of the key (or null if the previous
     *                    comment should be deleted)
     */
static gboolean
seahorse_ssh_rename_operation_rename_async_co (SeahorseSshRenameOperationRenameAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = seahorse_ssh_key_get_key_data (_data_->key);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _g_object_ref0 (_data_->_tmp1_);
	_data_->keydata = _data_->_tmp2_;
	if (_data_->new_comment == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		_g_free0 (_data_->new_comment);
		_data_->new_comment = _tmp3_;
	}
	_data_->_tmp4_ = _data_->keydata;
	if (!seahorse_ssh_rename_operation_change_raw_comment (_data_->self, _data_->_tmp4_, _data_->new_comment)) {
		_g_object_unref0 (_data_->keydata);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("operation.vala:376: Renaming key to: %s", _data_->new_comment);
	_data_->_tmp5_ = _data_->keydata;
	_data_->_tmp6_ = seahorse_ssh_key_data_get_pubfile (_data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_vala_assert (_data_->_tmp7_ != NULL, "keydata.pubfile != null");
	_data_->_tmp8_ = _data_->keydata;
	_data_->_tmp9_ = seahorse_ssh_key_data_get_partial (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = _data_->keydata;
		_data_->_tmp12_ = seahorse_ssh_key_data_get_pubfile (_data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->keydata;
		_data_->_tmp15_ = _data_->keydata;
		seahorse_ssh_key_data_filter_file (_data_->_tmp13_, _data_->_tmp14_, _data_->_tmp15_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->keydata);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp16_ = _data_->keydata;
		_data_->_tmp17_ = seahorse_ssh_key_data_get_pubfile (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = _data_->keydata;
		_data_->_tmp20_ = seahorse_ssh_key_data_get_rawdata (_data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		g_file_set_contents (_data_->_tmp18_, _data_->_tmp21_, (gssize) -1, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->keydata);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->keydata);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static gboolean
seahorse_ssh_rename_operation_change_raw_comment (SeahorseSshRenameOperation* self,
                                                  SeahorseSshKeyData* keydata,
                                                  const gchar* new_comment)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* no_leading = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** parts = NULL;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (keydata != NULL, FALSE);
	g_return_val_if_fail (new_comment != NULL, FALSE);
	_tmp0_ = seahorse_ssh_key_data_get_rawdata (keydata);
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_ != NULL, "keydata.rawdata != null");
	_tmp2_ = seahorse_ssh_key_data_get_rawdata (keydata);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_chug (_tmp3_);
	no_leading = _tmp4_;
	_tmp5_ = no_leading;
	_tmp7_ = _tmp6_ = g_strsplit_set (_tmp5_, " ", 3);
	parts = _tmp7_;
	parts_length1 = _vala_array_length (_tmp6_);
	_parts_size_ = parts_length1;
	_tmp8_ = parts;
	_tmp8__length1 = parts_length1;
	if (_tmp8__length1 < 3) {
		result = FALSE;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (no_leading);
		return result;
	}
	_tmp9_ = parts;
	_tmp9__length1 = parts_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = g_strconcat (_tmp10_, " ", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = parts;
	_tmp13__length1 = parts_length1;
	_tmp14_ = _tmp13_[1];
	_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, " ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, new_comment, NULL);
	_tmp20_ = _tmp19_;
	seahorse_ssh_key_data_set_rawdata (keydata, _tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
	result = TRUE;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (no_leading);
	return result;
}

SeahorseSshRenameOperation*
seahorse_ssh_rename_operation_construct (GType object_type)
{
	SeahorseSshRenameOperation * self = NULL;
	self = (SeahorseSshRenameOperation*) seahorse_ssh_operation_construct (object_type);
	return self;
}

SeahorseSshRenameOperation*
seahorse_ssh_rename_operation_new (void)
{
	return seahorse_ssh_rename_operation_construct (SEAHORSE_SSH_TYPE_RENAME_OPERATION);
}

static void
seahorse_ssh_rename_operation_class_init (SeahorseSshRenameOperationClass * klass,
                                          gpointer klass_data)
{
	seahorse_ssh_rename_operation_parent_class = g_type_class_peek_parent (klass);
}

static void
seahorse_ssh_rename_operation_instance_init (SeahorseSshRenameOperation * self,
                                             gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
seahorse_ssh_rename_operation_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshRenameOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_rename_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshRenameOperation), 0, (GInstanceInitFunc) seahorse_ssh_rename_operation_instance_init, NULL };
	GType seahorse_ssh_rename_operation_type_id;
	seahorse_ssh_rename_operation_type_id = g_type_register_static (SEAHORSE_SSH_TYPE_OPERATION, "SeahorseSshRenameOperation", &g_define_type_info, 0);
	return seahorse_ssh_rename_operation_type_id;
}

GType
seahorse_ssh_rename_operation_get_type (void)
{
	static volatile gsize seahorse_ssh_rename_operation_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_rename_operation_type_id__once)) {
		GType seahorse_ssh_rename_operation_type_id;
		seahorse_ssh_rename_operation_type_id = seahorse_ssh_rename_operation_get_type_once ();
		g_once_init_leave (&seahorse_ssh_rename_operation_type_id__once, seahorse_ssh_rename_operation_type_id);
	}
	return seahorse_ssh_rename_operation_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

