/* source.c generated by valac 0.56.1, the Vala compiler
 * generated from source.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2004-2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (c) 2016 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "seahorse-ssh.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gstdio.h>
#include "seahorse-common.h"
#include <gcr/gcr-base.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

enum  {
	SEAHORSE_SSH_SOURCE_0_PROPERTY,
	SEAHORSE_SSH_SOURCE_LABEL_PROPERTY,
	SEAHORSE_SSH_SOURCE_DESCRIPTION_PROPERTY,
	SEAHORSE_SSH_SOURCE_URI_PROPERTY,
	SEAHORSE_SSH_SOURCE_ICON_PROPERTY,
	SEAHORSE_SSH_SOURCE_CATEGORY_PROPERTY,
	SEAHORSE_SSH_SOURCE_ACTIONS_PROPERTY,
	SEAHORSE_SSH_SOURCE_ACTION_PREFIX_PROPERTY,
	SEAHORSE_SSH_SOURCE_MENU_MODEL_PROPERTY,
	SEAHORSE_SSH_SOURCE_SHOW_IF_EMPTY_PROPERTY,
	SEAHORSE_SSH_SOURCE_BASE_DIRECTORY_PROPERTY,
	SEAHORSE_SSH_SOURCE_NUM_PROPERTIES
};
static GParamSpec* seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SeahorseSshSourceAddKeyFromFilenameData SeahorseSshSourceAddKeyFromFilenameData;
typedef struct _Block10Data Block10Data;
typedef struct _SeahorseSshSourceLoadKeyForPrivateFileData SeahorseSshSourceLoadKeyForPrivateFileData;
typedef struct _Block11Data Block11Data;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
typedef struct _SeahorseSshSourceLoadData SeahorseSshSourceLoadData;
typedef struct _Block12Data Block12Data;
typedef struct _SeahorseSshSourceImportAsyncData SeahorseSshSourceImportAsyncData;
typedef struct _SeahorseSshSourceImportPublicAsyncData SeahorseSshSourceImportPublicAsyncData;
typedef struct _Block13Data Block13Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _SeahorseSshSourceAuthorizeAsyncData SeahorseSshSourceAuthorizeAsyncData;

struct _SeahorseSshSourcePrivate {
	gchar* ssh_homedir;
	guint scheduled_refresh_source;
	GFileMonitor* monitor_handle;
	GListStore* keys;
};

struct _SeahorseSshSourceAddKeyFromFilenameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshSource* self;
	gchar* privfile;
	SeahorseSshKey* result;
	guint i;
	gboolean _tmp0_;
	guint _tmp1_;
	GListStore* _tmp2_;
	SeahorseSshKey* key;
	GListStore* _tmp3_;
	GObject* _tmp4_;
	SeahorseSshKey* _tmp5_;
	SeahorseSshKeyData* _tmp6_;
	SeahorseSshKeyData* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	SeahorseSshKey* _tmp10_;
	SeahorseSshKey* _tmp11_;
	SeahorseSshKey* _tmp12_;
	GError* _inner_error0_;
};

struct _Block10Data {
	int _ref_count_;
	SeahorseSshSource* self;
	gchar* pubfile;
	SeahorseSshKey* key;
	gchar* privfile;
	gpointer _async_data_;
};

struct _SeahorseSshSourceLoadKeyForPrivateFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshSource* self;
	gchar* privfile;
	SeahorseSshKey* result;
	Block10Data* _data10_;
	gchar* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* e;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError* _tmp10_;
	GError* _tmp11_;
	SeahorseSshKey* _tmp12_;
	SeahorseSshKey* _tmp13_;
	GError* _inner_error0_;
};

struct _Block11Data {
	int _ref_count_;
	SeahorseSshSource* self;
	gchar* pubfile;
	gpointer _async_data_;
};

struct _SeahorseSshSourceLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshSource* self;
	GCancellable* cancellable;
	gboolean result;
	Block11Data* _data11_;
	GDir* dir;
	const gchar* _tmp0_;
	GDir* _tmp1_;
	gchar* filename;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* privfile;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block12Data {
	int _ref_count_;
	SeahorseSshSource* self;
	gchar* fullpath;
	SeahorseSshSource* src;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _SeahorseSshSourceImportAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshSource* self;
	GInputStream* input;
	GtkWindow* transient_for;
	GCancellable* cancellable;
	GList* result;
	Block12Data* _data12_;
	guint8* buffer;
	guint8* _tmp0_;
	gint buffer_length1;
	gint _buffer_size_;
	gsize bytes_read;
	gsize _tmp1_;
	gchar* _tmp2_;
	SeahorseSshSource* _tmp3_;
	GError* _inner_error0_;
};

struct _SeahorseSshSourceImportPublicAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshSource* self;
	SeahorseSshKeyData* data;
	gchar* filename;
	GCancellable* cancellable;
	gchar* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _Block13Data {
	int _ref_count_;
	SeahorseSshSource* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GError* err;
	gchar* from;
	gchar* to;
	SeahorseSshKey* key;
	gpointer _async_data_;
};

struct _SeahorseSshSourceAuthorizeAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorseSshSource* self;
	SeahorseSshKey* key;
	gboolean authorize;
	Block13Data* _data13_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GThread* thread;
	GThread* _tmp4_;
	GThread* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _tmp8_;
	GError* _inner_error0_;
};

static gint SeahorseSshSource_private_offset;
static gpointer seahorse_ssh_source_parent_class = NULL;
static GcrCollectionIface * seahorse_ssh_source_gcr_collection_parent_iface = NULL;
static SeahorsePlaceIface * seahorse_ssh_source_seahorse_place_parent_iface = NULL;

static gboolean seahorse_ssh_source_check_file_for_ssh (SeahorseSshSource* self,
                                                 const gchar* filename);
static void seahorse_ssh_source_cancel_scheduled_refresh (SeahorseSshSource* self);
static gboolean seahorse_ssh_source_scheduled_refresh (SeahorseSshSource* self);
static gboolean seahorse_ssh_source_scheduled_dummy (SeahorseSshSource* self);
static void seahorse_ssh_source_monitor_ssh_homedir (SeahorseSshSource* self);
static void ___lambda19_ (SeahorseSshSource* self,
                   GFile* file,
                   GFile* other_file,
                   GFileMonitorEvent event_type);
static gboolean _seahorse_ssh_source_scheduled_refresh_gsource_func (gpointer self);
static void ____lambda19__g_file_monitor_changed (GFileMonitor* _sender,
                                           GFile* file,
                                           GFile* other_file,
                                           GFileMonitorEvent event_type,
                                           gpointer self);
static guint seahorse_ssh_source_real_get_length (GcrCollection* base);
static GList* seahorse_ssh_source_real_get_objects (GcrCollection* base);
static gboolean seahorse_ssh_source_real_contains (GcrCollection* base,
                                            GObject* object);
static void seahorse_ssh_source_add_key_from_filename_data_free (gpointer _data);
static gboolean seahorse_ssh_source_add_key_from_filename_co (SeahorseSshSourceAddKeyFromFilenameData* _data_);
static void seahorse_ssh_source_load_key_for_private_file (SeahorseSshSource* self,
                                                    const gchar* privfile,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
static SeahorseSshKey* seahorse_ssh_source_load_key_for_private_file_finish (SeahorseSshSource* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void seahorse_ssh_source_add_key_from_filename_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void seahorse_ssh_source_load_key_for_private_file_data_free (gpointer _data);
static gboolean seahorse_ssh_source_load_key_for_private_file_co (SeahorseSshSourceLoadKeyForPrivateFileData* _data_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean ____lambda16_ (Block10Data* _data10_,
                        SeahorseSshKeyData* keydata);
static gboolean _____lambda16__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                             gpointer self);
static void seahorse_ssh_source_load_key_for_private_file_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void seahorse_ssh_source_real_load_data_free (gpointer _data);
static void seahorse_ssh_source_real_load (SeahorsePlace* base,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static gboolean seahorse_ssh_source_real_load_co (SeahorseSshSourceLoadData* _data_);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean _seahorse_ssh_source_scheduled_dummy_gsource_func (gpointer self);
static gboolean __lambda17_ (Block11Data* _data11_,
                      SeahorseSshKeyData* keydata);
static gboolean ___lambda17__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                           gpointer self);
static gboolean __lambda18_ (Block11Data* _data11_,
                      SeahorseSshKeyData* keydata);
static gboolean ___lambda18__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void seahorse_ssh_source_import_async_data_free (gpointer _data);
static gboolean seahorse_ssh_source_import_async_co (SeahorseSshSourceImportAsyncData* _data_);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gboolean __lambda20_ (Block12Data* _data12_,
                      SeahorseSshKeyData* keydata);
static gboolean ___lambda20__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                           gpointer self);
static gboolean __lambda21_ (Block12Data* _data12_,
                      SeahorseSshSecData* secdata);
static gboolean ___lambda21__seahorse_ssh_key_priv_parsed_handler (SeahorseSshSecData* data,
                                                            gpointer self);
static void seahorse_ssh_source_import_public_async_data_free (gpointer _data);
static gboolean seahorse_ssh_source_import_public_async_co (SeahorseSshSourceImportPublicAsyncData* _data_);
static void seahorse_ssh_source_authorize_async_data_free (gpointer _data);
static gboolean seahorse_ssh_source_authorize_async_co (SeahorseSshSourceAuthorizeAsyncData* _data_);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean _seahorse_ssh_source_authorize_async_co_gsource_func (gpointer self);
static void* __lambda11_ (Block13Data* _data13_);
static void seahorse_ssh_source_ensure_file_exists (SeahorseSshSource* self,
                                             const gchar* filename);
static gpointer ___lambda11__gthread_func (gpointer self);
static GObject * seahorse_ssh_source_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void seahorse_ssh_source_finalize (GObject * obj);
static GType seahorse_ssh_source_get_type_once (void);
static void _vala_seahorse_ssh_source_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_seahorse_ssh_source_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_ssh_source_get_instance_private (SeahorseSshSource* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseSshSource_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
seahorse_ssh_source_check_file_for_ssh (SeahorseSshSource* self,
                                        const gchar* filename)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	if (!g_file_test (filename, G_FILE_TEST_IS_REGULAR)) {
		result = FALSE;
		return result;
	}
	{
		gchar* contents = NULL;
		gchar* _tmp0_ = NULL;
		const gchar* _tmp2_;
		g_file_get_contents (filename, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			_g_free0 (contents);
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		_tmp2_ = contents;
		result = string_contains (_tmp2_, " PRIVATE KEY-----");
		_g_free0 (contents);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_strdup_printf ("Error reading file '%s' to check for SSH key. %s", filename, _tmp4_);
		_tmp6_ = _tmp5_;
		g_warning ("source.vala:114: %s", _tmp6_);
		_g_free0 (_tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = FALSE;
	return result;
}

static void
seahorse_ssh_source_cancel_scheduled_refresh (SeahorseSshSource* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->scheduled_refresh_source != ((guint) 0)) {
		g_debug ("source.vala:122: Cancelling scheduled refresh event");
		g_source_remove (self->priv->scheduled_refresh_source);
		self->priv->scheduled_refresh_source = (guint) 0;
	}
}

static gboolean
seahorse_ssh_source_scheduled_refresh (SeahorseSshSource* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("source.vala:129: Scheduled refresh event ocurring now");
	seahorse_ssh_source_cancel_scheduled_refresh (self);
	seahorse_place_load ((SeahorsePlace*) self, NULL, NULL, NULL);
	result = FALSE;
	return result;
}

static gboolean
seahorse_ssh_source_scheduled_dummy (SeahorseSshSource* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_debug ("source.vala:136: Dummy refresh event occurring now");
	self->priv->scheduled_refresh_source = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
_seahorse_ssh_source_scheduled_refresh_gsource_func (gpointer self)
{
	gboolean result;
	result = seahorse_ssh_source_scheduled_refresh ((SeahorseSshSource*) self);
	return result;
}

static void
___lambda19_ (SeahorseSshSource* self,
              GFile* file,
              GFile* other_file,
              GFileMonitorEvent event_type)
{
	gboolean _tmp0_ = FALSE;
	gchar* path = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (file != NULL);
	if (self->priv->scheduled_refresh_source != ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		if (event_type != G_FILE_MONITOR_EVENT_CHANGED) {
			_tmp3_ = event_type != G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = event_type != G_FILE_MONITOR_EVENT_DELETED;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = event_type != G_FILE_MONITOR_EVENT_CREATED;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = g_file_get_path (file);
	path = _tmp4_;
	_tmp5_ = path;
	if (_tmp5_ == NULL) {
		_g_free0 (path);
		return;
	}
	if (event_type != G_FILE_MONITOR_EVENT_DELETED) {
		const gchar* _tmp10_;
		_tmp10_ = path;
		_tmp9_ = !g_str_has_suffix (_tmp10_, SEAHORSE_SSH_SOURCE_AUTHORIZED_KEYS_FILE);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp11_;
		_tmp11_ = path;
		_tmp8_ = !g_str_has_suffix (_tmp11_, SEAHORSE_SSH_SOURCE_OTHER_KEYS_FILE);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp12_;
		_tmp12_ = path;
		_tmp7_ = !g_str_has_suffix (_tmp12_, ".pub");
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp13_;
		_tmp13_ = path;
		_tmp6_ = !seahorse_ssh_sec_data_contains_private_key (_tmp13_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_g_free0 (path);
		return;
	}
	g_debug ("source.vala:168: Scheduling refresh event due to file changes");
	self->priv->scheduled_refresh_source = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _seahorse_ssh_source_scheduled_refresh_gsource_func, g_object_ref (self), g_object_unref);
	_g_free0 (path);
}

static void
____lambda19__g_file_monitor_changed (GFileMonitor* _sender,
                                      GFile* file,
                                      GFile* other_file,
                                      GFileMonitorEvent event_type,
                                      gpointer self)
{
	___lambda19_ ((SeahorseSshSource*) self, file, other_file, event_type);
}

static void
seahorse_ssh_source_monitor_ssh_homedir (SeahorseSshSource* self)
{
	GFile* dot_ssh_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ssh_homedir;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	dot_ssh_dir = _tmp1_;
	_tmp2_ = dot_ssh_dir;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (dot_ssh_dir);
		return;
	}
	{
		GFileMonitor* _tmp3_ = NULL;
		GFile* _tmp4_;
		GFileMonitor* _tmp5_;
		GFileMonitor* _tmp6_;
		GFileMonitor* _tmp7_;
		_tmp4_ = dot_ssh_dir;
		_tmp5_ = g_file_monitor_directory (_tmp4_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (self->priv->monitor_handle);
		self->priv->monitor_handle = _tmp6_;
		_tmp7_ = self->priv->monitor_handle;
		g_signal_connect_object (_tmp7_, "changed", (GCallback) ____lambda19__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = self->priv->ssh_homedir;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("source.vala:172: couldn't monitor ssh directory: %s: %s", _tmp8_, _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (dot_ssh_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (dot_ssh_dir);
}

static guint
seahorse_ssh_source_real_get_length (GcrCollection* base)
{
	SeahorseSshSource * self;
	GListStore* _tmp0_;
	guint result;
	self = (SeahorseSshSource*) base;
	_tmp0_ = self->priv->keys;
	result = g_list_model_get_n_items ((GListModel*) _tmp0_);
	return result;
}

static GList*
seahorse_ssh_source_real_get_objects (GcrCollection* base)
{
	SeahorseSshSource * self;
	GList* objects = NULL;
	GList* result;
	self = (SeahorseSshSource*) base;
	objects = NULL;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				GObject* _tmp5_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->keys;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->keys;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, i);
				_tmp5_ = _tmp4_;
				objects = g_list_append (objects, _tmp5_);
				_g_object_unref0 (_tmp5_);
			}
		}
	}
	result = objects;
	return result;
}

static gboolean
seahorse_ssh_source_real_contains (GcrCollection* base,
                                   GObject* object)
{
	SeahorseSshSource * self;
	GListStore* _tmp0_;
	gboolean result;
	self = (SeahorseSshSource*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = self->priv->keys;
	result = g_list_store_find (_tmp0_, object, NULL);
	return result;
}

void
seahorse_ssh_source_remove_object (SeahorseSshSource* self,
                                   GObject* object)
{
	guint pos = 0U;
	GListStore* _tmp0_;
	guint _tmp1_ = 0U;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = self->priv->keys;
	_tmp2_ = g_list_store_find (_tmp0_, object, &_tmp1_);
	pos = _tmp1_;
	if (_tmp2_) {
		GListStore* _tmp3_;
		_tmp3_ = self->priv->keys;
		g_list_store_remove (_tmp3_, pos);
		g_signal_emit_by_name ((GcrCollection*) self, "removed", object);
	}
}

gchar*
seahorse_ssh_source_authorized_keys_path (SeahorseSshSource* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ssh_homedir;
	_tmp1_ = g_build_filename (_tmp0_, SEAHORSE_SSH_SOURCE_AUTHORIZED_KEYS_FILE, NULL);
	result = _tmp1_;
	return result;
}

gchar*
seahorse_ssh_source_other_keys_path (SeahorseSshSource* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ssh_homedir;
	_tmp1_ = g_build_filename (_tmp0_, SEAHORSE_SSH_SOURCE_OTHER_KEYS_FILE, NULL);
	result = _tmp1_;
	return result;
}

static void
seahorse_ssh_source_add_key_from_filename_data_free (gpointer _data)
{
	SeahorseSshSourceAddKeyFromFilenameData* _data_;
	_data_ = _data;
	_g_free0 (_data_->privfile);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshSourceAddKeyFromFilenameData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
seahorse_ssh_source_add_key_from_filename (SeahorseSshSource* self,
                                           const gchar* privfile,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	SeahorseSshSourceAddKeyFromFilenameData* _data_;
	SeahorseSshSource* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SeahorseSshSourceAddKeyFromFilenameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_source_add_key_from_filename_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (privfile);
	_g_free0 (_data_->privfile);
	_data_->privfile = _tmp1_;
	seahorse_ssh_source_add_key_from_filename_co (_data_);
}

SeahorseSshKey*
seahorse_ssh_source_add_key_from_filename_finish (SeahorseSshSource* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	SeahorseSshKey* result;
	SeahorseSshSourceAddKeyFromFilenameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
seahorse_ssh_source_add_key_from_filename_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	SeahorseSshSourceAddKeyFromFilenameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_source_add_key_from_filename_co (_data_);
}

static gboolean
seahorse_ssh_source_add_key_from_filename_co (SeahorseSshSourceAddKeyFromFilenameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->privfile == NULL) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp0_) {
					_data_->_tmp1_ = _data_->i;
					_data_->i = _data_->_tmp1_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp2_ = _data_->self->priv->keys;
				if (!(_data_->i < g_list_model_get_n_items ((GListModel*) _data_->_tmp2_))) {
					break;
				}
				_data_->_tmp3_ = _data_->self->priv->keys;
				_data_->_tmp4_ = g_list_model_get_item ((GListModel*) _data_->_tmp3_, _data_->i);
				_data_->key = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, SEAHORSE_SSH_TYPE_KEY, SeahorseSshKey);
				_data_->_tmp5_ = _data_->key;
				_data_->_tmp6_ = seahorse_ssh_key_get_key_data (_data_->_tmp5_);
				_data_->_tmp7_ = _data_->_tmp6_;
				_data_->_tmp8_ = seahorse_ssh_key_data_get_privfile (_data_->_tmp7_);
				_data_->_tmp9_ = _data_->_tmp8_;
				if (g_strcmp0 (_data_->_tmp9_, _data_->privfile) == 0) {
					_data_->result = _data_->key;
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->key);
			}
		}
	}
	_data_->_state_ = 1;
	seahorse_ssh_source_load_key_for_private_file (_data_->self, _data_->privfile, seahorse_ssh_source_add_key_from_filename_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = seahorse_ssh_source_load_key_for_private_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp10_ = _data_->_tmp11_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->_tmp10_;
	_data_->_tmp10_ = NULL;
	_data_->result = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp10_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_ssh_source_load_key_for_private_file_data_free (gpointer _data)
{
	SeahorseSshSourceLoadKeyForPrivateFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshSourceLoadKeyForPrivateFileData, _data_);
}

static void
seahorse_ssh_source_load_key_for_private_file (SeahorseSshSource* self,
                                               const gchar* privfile,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	SeahorseSshSourceLoadKeyForPrivateFileData* _data_;
	SeahorseSshSource* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (privfile != NULL);
	_data_ = g_slice_new0 (SeahorseSshSourceLoadKeyForPrivateFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_source_load_key_for_private_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (privfile);
	_g_free0 (_data_->privfile);
	_data_->privfile = _tmp1_;
	seahorse_ssh_source_load_key_for_private_file_co (_data_);
}

static SeahorseSshKey*
seahorse_ssh_source_load_key_for_private_file_finish (SeahorseSshSource* self,
                                                      GAsyncResult* _res_,
                                                      GError** error)
{
	SeahorseSshKey* result;
	SeahorseSshSourceLoadKeyForPrivateFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		SeahorseSshSource* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->key);
		_g_free0 (_data10_->pubfile);
		_g_free0 (_data10_->privfile);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
____lambda16_ (Block10Data* _data10_,
               SeahorseSshKeyData* keydata)
{
	SeahorseSshSource* self;
	const gchar* _tmp0_;
	SeahorseSshKey* _tmp1_;
	gboolean result;
	self = _data10_->self;
	g_return_val_if_fail (keydata != NULL, FALSE);
	_tmp0_ = _data10_->pubfile;
	_tmp1_ = seahorse_ssh_source_add_key_from_parsed_data (self, keydata, _tmp0_, FALSE, FALSE, _data10_->privfile, NULL);
	_g_object_unref0 (_data10_->key);
	_data10_->key = _tmp1_;
	result = TRUE;
	return result;
}

static gboolean
_____lambda16__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                    gpointer self)
{
	gboolean result;
	result = ____lambda16_ (self, data);
	return result;
}

static void
seahorse_ssh_source_load_key_for_private_file_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	SeahorseSshSourceLoadKeyForPrivateFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_ssh_source_load_key_for_private_file_co (_data_);
}

static gboolean
seahorse_ssh_source_load_key_for_private_file_co (SeahorseSshSourceLoadKeyForPrivateFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data10_ = g_slice_new0 (Block10Data);
	_data_->_data10_->_ref_count_ = 1;
	_data_->_data10_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data10_->privfile);
	_data_->_data10_->privfile = _data_->privfile;
	_data_->_data10_->_async_data_ = _data_;
	_data_->_tmp0_ = g_strconcat (_data_->_data10_->privfile, ".pub", NULL);
	_data_->_data10_->pubfile = _data_->_tmp0_;
	_data_->_data10_->key = NULL;
	if (g_file_test (_data_->_data10_->privfile, G_FILE_TEST_EXISTS)) {
		_data_->_tmp3_ = _data_->_data10_->pubfile;
		_data_->_tmp2_ = g_file_test (_data_->_tmp3_, G_FILE_TEST_EXISTS);
	} else {
		_data_->_tmp2_ = FALSE;
	}
	if (_data_->_tmp2_) {
		_data_->_tmp1_ = seahorse_ssh_source_check_file_for_ssh (_data_->self, _data_->_data10_->privfile);
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		{
			_data_->_tmp4_ = _data_->_data10_->pubfile;
			_data_->_state_ = 1;
			seahorse_ssh_key_parse_file (_data_->_tmp4_, _____lambda16__seahorse_ssh_key_pub_parsed_handler, _data_->_data10_, NULL, NULL, NULL, seahorse_ssh_source_load_key_for_private_file_ready, _data_);
			return FALSE;
			_state_1:
			seahorse_ssh_key_parse_file_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp5_ = _data_->_data10_->pubfile;
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = _data_->_tmp6_->message;
			_data_->_tmp8_ = g_strdup_printf ("Couldn't read SSH file: %s (%s)", _data_->_tmp5_, _data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_data_->_tmp10_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, _data_->_tmp9_);
			_data_->_tmp11_ = _data_->_tmp10_;
			_g_free0 (_data_->_tmp9_);
			_data_->_inner_error0_ = _data_->_tmp11_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			block10_data_unref (_data_->_data10_);
			_data_->_data10_ = NULL;
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp12_ = _data_->_data10_->key;
	_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
	_data_->result = _data_->_tmp13_;
	block10_data_unref (_data_->_data10_);
	_data_->_data10_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
seahorse_ssh_source_export_private (SeahorseSshSource* self,
                                    SeahorseSshKey* key,
                                    GError** error)
{
	SeahorseSshKeyData* keydata = NULL;
	SeahorseSshKeyData* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	SeahorseSshKeyData* _tmp2_;
	SeahorseSshKeyData* _tmp3_;
	SeahorseSshKeyData* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* results = NULL;
	gboolean _tmp8_ = FALSE;
	SeahorseSshKeyData* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gboolean _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = seahorse_ssh_key_get_key_data (key);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keydata = _tmp2_;
	_tmp3_ = keydata;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (keydata);
		return result;
	}
	_tmp4_ = keydata;
	_tmp5_ = seahorse_ssh_key_data_get_privfile (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, _ ("No private key file is available for this key."));
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (keydata);
		return NULL;
	}
	_tmp9_ = keydata;
	_tmp10_ = seahorse_ssh_key_data_get_privfile (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = g_file_get_contents (_tmp11_, &_tmp12_, NULL, &_inner_error0_);
	_g_free0 (results);
	results = _tmp12_;
	_tmp8_ = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (results);
		_g_object_unref0 (keydata);
		return NULL;
	}
	if (!_tmp8_) {
		result = NULL;
		_g_free0 (results);
		_g_object_unref0 (keydata);
		return result;
	}
	result = results;
	_g_object_unref0 (keydata);
	return result;
}

static void
seahorse_ssh_source_real_load_data_free (gpointer _data)
{
	SeahorseSshSourceLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshSourceLoadData, _data_);
}

static void
seahorse_ssh_source_real_load (SeahorsePlace* base,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SeahorseSshSource * self;
	SeahorseSshSourceLoadData* _data_;
	SeahorseSshSource* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorseSshSource*) base;
	_data_ = g_slice_new0 (SeahorseSshSourceLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_source_real_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_ssh_source_real_load_co (_data_);
}

static gboolean
seahorse_ssh_source_load_finish (SeahorsePlace* base,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	gboolean result;
	SeahorseSshSourceLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

/**
     * Loads the keys from this Source's directory.
     *
     * @param cancellable Use this to cancel the operation.
     */
static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		SeahorseSshSource* self;
		self = _data11_->self;
		_g_free0 (_data11_->pubfile);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
_seahorse_ssh_source_scheduled_dummy_gsource_func (gpointer self)
{
	gboolean result;
	result = seahorse_ssh_source_scheduled_dummy ((SeahorseSshSource*) self);
	return result;
}

static gboolean
__lambda17_ (Block11Data* _data11_,
             SeahorseSshKeyData* keydata)
{
	SeahorseSshSource* self;
	const gchar* _tmp0_;
	SeahorseSshKey* _tmp1_;
	SeahorseSshKey* _tmp2_;
	gboolean result;
	self = _data11_->self;
	g_return_val_if_fail (keydata != NULL, FALSE);
	_tmp0_ = _data11_->pubfile;
	_tmp1_ = seahorse_ssh_source_add_key_from_parsed_data (self, keydata, _tmp0_, TRUE, TRUE, NULL, NULL);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	return result;
}

static gboolean
___lambda17__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                  gpointer self)
{
	gboolean result;
	result = __lambda17_ (self, data);
	return result;
}

static gboolean
__lambda18_ (Block11Data* _data11_,
             SeahorseSshKeyData* keydata)
{
	SeahorseSshSource* self;
	const gchar* _tmp0_;
	SeahorseSshKey* _tmp1_;
	SeahorseSshKey* _tmp2_;
	gboolean result;
	self = _data11_->self;
	g_return_val_if_fail (keydata != NULL, FALSE);
	_tmp0_ = _data11_->pubfile;
	_tmp1_ = seahorse_ssh_source_add_key_from_parsed_data (self, keydata, _tmp0_, TRUE, FALSE, NULL, NULL);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	result = TRUE;
	return result;
}

static gboolean
___lambda18__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                  gpointer self)
{
	gboolean result;
	result = __lambda18_ (self, data);
	return result;
}

static gboolean
seahorse_ssh_source_real_load_co (SeahorseSshSourceLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data11_ = g_slice_new0 (Block11Data);
	_data_->_data11_->_ref_count_ = 1;
	_data_->_data11_->self = g_object_ref (_data_->self);
	_data_->_data11_->_async_data_ = _data_;
	seahorse_ssh_source_cancel_scheduled_refresh (_data_->self);
	_data_->self->priv->scheduled_refresh_source = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _seahorse_ssh_source_scheduled_dummy_gsource_func, g_object_ref (_data_->self), g_object_unref);
	g_debug ("source.vala:269: scheduled a dummy refresh");
	_data_->_tmp0_ = _data_->self->priv->ssh_homedir;
	_data_->_tmp1_ = g_dir_open (_data_->_tmp0_, (guint) 0, &_data_->_inner_error0_);
	_data_->dir = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block11_data_unref (_data_->_data11_);
		_data_->_data11_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->filename = NULL;
	while (TRUE) {
		_data_->_tmp2_ = g_dir_read_name (_data_->dir);
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_g_free0 (_data_->filename);
		_data_->filename = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->filename;
		if (!(_data_->_tmp4_ != NULL)) {
			break;
		}
		_data_->_tmp5_ = _data_->self->priv->ssh_homedir;
		_data_->_tmp6_ = _data_->filename;
		_data_->_tmp7_ = g_build_filename (_data_->_tmp5_, _data_->_tmp6_, NULL);
		_data_->privfile = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->privfile;
		seahorse_ssh_source_load_key_for_private_file (_data_->self, _data_->_tmp8_, NULL, NULL);
		_g_free0 (_data_->privfile);
	}
	_data_->_tmp9_ = seahorse_ssh_source_authorized_keys_path (_data_->self);
	_data_->_data11_->pubfile = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->_data11_->pubfile;
	seahorse_ssh_key_parse_file (_data_->_tmp10_, ___lambda17__seahorse_ssh_key_pub_parsed_handler, _data_->_data11_, NULL, NULL, NULL, NULL, NULL);
	_data_->_tmp11_ = seahorse_ssh_source_other_keys_path (_data_->self);
	_g_free0 (_data_->_data11_->pubfile);
	_data_->_data11_->pubfile = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->_data11_->pubfile;
	seahorse_ssh_key_parse_file (_data_->_tmp12_, ___lambda18__seahorse_ssh_key_pub_parsed_handler, _data_->_data11_, NULL, NULL, NULL, NULL, NULL);
	_data_->result = TRUE;
	_g_free0 (_data_->filename);
	_g_dir_close0 (_data_->dir);
	block11_data_unref (_data_->_data11_);
	_data_->_data11_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SeahorseSshKey*
seahorse_ssh_source_add_key_from_parsed_data (SeahorseSshSource* src,
                                              SeahorseSshKeyData* keydata,
                                              const gchar* pubfile,
                                              gboolean partial,
                                              gboolean authorized,
                                              const gchar* privfile,
                                              GPtrArray* checks)
{
	gboolean _tmp0_ = FALSE;
	SeahorseSshKey* prev = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	SeahorseSshKey* _tmp5_;
	SeahorseSshKey* _tmp6_;
	SeahorseSshKey* _tmp8_;
	SeahorseSshKey* key = NULL;
	SeahorseSshKey* _tmp9_;
	GListStore* _tmp10_;
	SeahorseSshKey* _tmp11_;
	SeahorseSshKey* _tmp12_;
	SeahorseSshKey* result;
	g_return_val_if_fail (src != NULL, NULL);
	g_return_val_if_fail (pubfile != NULL, NULL);
	if (keydata != NULL) {
		_tmp0_ = seahorse_ssh_key_data_is_valid (keydata);
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	seahorse_ssh_key_data_set_pubfile (keydata, pubfile);
	seahorse_ssh_key_data_set_partial (keydata, partial);
	seahorse_ssh_key_data_set_authorized (keydata, authorized);
	if (privfile != NULL) {
		seahorse_ssh_key_data_set_privfile (keydata, privfile);
	}
	if (checks != NULL) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = seahorse_ssh_key_data_get_fingerprint (keydata);
		_tmp2_ = _tmp1_;
		g_ptr_array_remove (checks, _tmp2_);
	}
	_tmp3_ = seahorse_ssh_key_data_get_fingerprint (keydata);
	_tmp4_ = _tmp3_;
	_tmp5_ = seahorse_ssh_source_find_key_by_fingerprint (src, _tmp4_);
	prev = _tmp5_;
	_tmp6_ = prev;
	if (_tmp6_ != NULL) {
		SeahorseSshKey* _tmp7_;
		_tmp7_ = prev;
		seahorse_ssh_key_merge_keydata (_tmp7_, keydata);
	}
	_tmp8_ = prev;
	if (_tmp8_ != NULL) {
		result = prev;
		return result;
	}
	_tmp9_ = seahorse_ssh_key_new (src, keydata);
	key = _tmp9_;
	_tmp10_ = src->priv->keys;
	_tmp11_ = key;
	g_list_store_append (_tmp10_, (GObject*) _tmp11_);
	_tmp12_ = key;
	g_signal_emit_by_name ((GcrCollection*) src, "added", (GObject*) _tmp12_);
	result = key;
	_g_object_unref0 (prev);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
seahorse_ssh_source_import_async_data_free (gpointer _data)
{
	SeahorseSshSourceImportAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->input);
	_g_object_unref0 (_data_->transient_for);
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_object_unref0_ (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshSourceImportAsyncData, _data_);
}

void
seahorse_ssh_source_import_async (SeahorseSshSource* self,
                                  GInputStream* input,
                                  GtkWindow* transient_for,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	SeahorseSshSourceImportAsyncData* _data_;
	SeahorseSshSource* _tmp0_;
	GInputStream* _tmp1_;
	GtkWindow* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (transient_for != NULL);
	_data_ = g_slice_new0 (SeahorseSshSourceImportAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_source_import_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (input);
	_g_object_unref0 (_data_->input);
	_data_->input = _tmp1_;
	_tmp2_ = _g_object_ref0 (transient_for);
	_g_object_unref0 (_data_->transient_for);
	_data_->transient_for = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	seahorse_ssh_source_import_async_co (_data_);
}

GList*
seahorse_ssh_source_import_finish (SeahorseSshSource* self,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	GList* result;
	SeahorseSshSourceImportAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Parse an inputstream into a list of keys and import those keys.
     */
static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		SeahorseSshSource* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->src);
		_g_free0 (_data12_->fullpath);
		_g_object_unref0 (_data12_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static gboolean
__lambda20_ (Block12Data* _data12_,
             SeahorseSshKeyData* keydata)
{
	SeahorseSshSource* self;
	const gchar* _tmp0_;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (keydata != NULL, FALSE);
	_tmp0_ = _data12_->fullpath;
	seahorse_ssh_source_import_public_async (self, keydata, _tmp0_, _data12_->cancellable, NULL, NULL);
	result = TRUE;
	return result;
}

static gboolean
___lambda20__seahorse_ssh_key_pub_parsed_handler (SeahorseSshKeyData* data,
                                                  gpointer self)
{
	gboolean result;
	result = __lambda20_ (self, data);
	return result;
}

static gboolean
__lambda21_ (Block12Data* _data12_,
             SeahorseSshSecData* secdata)
{
	SeahorseSshSource* self;
	SeahorseSshPrivateImportOperation* _tmp0_;
	SeahorseSshPrivateImportOperation* _tmp1_;
	SeahorseSshSource* _tmp2_;
	gboolean result;
	self = _data12_->self;
	g_return_val_if_fail (secdata != NULL, FALSE);
	_tmp0_ = seahorse_ssh_private_import_operation_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _data12_->src;
	seahorse_ssh_private_import_operation_import_private_async (_tmp1_, _tmp2_, secdata, NULL, _data12_->cancellable, NULL, NULL);
	_g_object_unref0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
___lambda21__seahorse_ssh_key_priv_parsed_handler (SeahorseSshSecData* data,
                                                   gpointer self)
{
	gboolean result;
	result = __lambda21_ (self, data);
	return result;
}

static gboolean
seahorse_ssh_source_import_async_co (SeahorseSshSourceImportAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data12_ = g_slice_new0 (Block12Data);
	_data_->_data12_->_ref_count_ = 1;
	_data_->_data12_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data12_->cancellable);
	_data_->_data12_->cancellable = _data_->cancellable;
	_data_->_data12_->_async_data_ = _data_;
	_data_->_tmp0_ = g_new0 (guint8, 4096);
	_data_->buffer = _data_->_tmp0_;
	_data_->buffer_length1 = 4096;
	_data_->_buffer_size_ = _data_->buffer_length1;
	_data_->_tmp1_ = 0UL;
	g_input_stream_read_all (_data_->input, _data_->buffer, (gsize) _data_->buffer_length1, &_data_->_tmp1_, _data_->_data12_->cancellable, &_data_->_inner_error0_);
	_data_->bytes_read = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->buffer = (g_free (_data_->buffer), NULL);
		block12_data_unref (_data_->_data12_);
		_data_->_data12_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = seahorse_ssh_source_other_keys_path (_data_->self);
	_data_->_data12_->fullpath = _data_->_tmp2_;
	_data_->_tmp3_ = _g_object_ref0 (_data_->self);
	_data_->_data12_->src = _data_->_tmp3_;
	seahorse_ssh_key_parse ((const gchar*) _data_->buffer, ___lambda20__seahorse_ssh_key_pub_parsed_handler, _data_->_data12_, ___lambda21__seahorse_ssh_key_priv_parsed_handler, _data_->_data12_, NULL, NULL, NULL);
	_data_->result = NULL;
	_data_->buffer = (g_free (_data_->buffer), NULL);
	block12_data_unref (_data_->_data12_);
	_data_->_data12_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_ssh_source_import_public_async_data_free (gpointer _data)
{
	SeahorseSshSourceImportPublicAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->data);
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshSourceImportPublicAsyncData, _data_);
}

void
seahorse_ssh_source_import_public_async (SeahorseSshSource* self,
                                         SeahorseSshKeyData* data,
                                         const gchar* filename,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	SeahorseSshSourceImportPublicAsyncData* _data_;
	SeahorseSshSource* _tmp0_;
	SeahorseSshKeyData* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (data != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (SeahorseSshSourceImportPublicAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_source_import_public_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (data);
	_g_object_unref0 (_data_->data);
	_data_->data = _tmp1_;
	_tmp2_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	seahorse_ssh_source_import_public_async_co (_data_);
}

gchar*
seahorse_ssh_source_import_public_finish (SeahorseSshSource* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	gchar* result;
	SeahorseSshSourceImportPublicAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Import a public key into a file.
     *
     * @param data The public key that needs to be imported.
     * @param filename The name of the file in which the key should be imported.
     * @param cancellable Allows the operation to be cancelled.
     */
static gboolean
seahorse_ssh_source_import_public_async_co (SeahorseSshSourceImportPublicAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->data == NULL) {
		_data_->_tmp1_ = TRUE;
	} else {
		_data_->_tmp1_ = !seahorse_ssh_key_data_is_valid (_data_->data);
	}
	if (_data_->_tmp1_) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = seahorse_ssh_key_data_get_rawdata (_data_->data);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp0_ = _data_->_tmp3_ == NULL;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp4_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Trying to import an invalid public key.");
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	seahorse_ssh_key_data_filter_file (_data_->filename, _data_->data, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = seahorse_ssh_key_data_get_fingerprint (_data_->data);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
     * Returns a possible filename for a key.
     *
     * @param algo The type of the key
     */
gchar*
seahorse_ssh_source_new_filename_for_algorithm (SeahorseSshSource* self,
                                                SeahorseSshAlgorithm algo)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* type = NULL;
	gchar* _tmp3_;
	gchar* basename = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* filename = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = seahorse_ssh_algorithm_to_string (algo);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("unk");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	type = _tmp3_;
	_tmp4_ = type;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("id_%s", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	basename = _tmp8_;
	filename = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gchar* _tmp11_ = NULL;
				gchar* t = NULL;
				gchar* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < G_MAXINT)) {
					break;
				}
				if (i == 0) {
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = basename;
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (_tmp11_);
					_tmp11_ = _tmp13_;
				} else {
					const gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp14_ = basename;
					_tmp15_ = g_strdup_printf ("%s.%d", _tmp14_, i);
					_g_free0 (_tmp11_);
					_tmp11_ = _tmp15_;
				}
				_tmp16_ = g_strdup (_tmp11_);
				t = _tmp16_;
				_tmp17_ = seahorse_ssh_source_get_base_directory (self);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = g_build_filename (_tmp18_, _tmp19_, NULL);
				_g_free0 (filename);
				filename = _tmp20_;
				_tmp21_ = filename;
				if (!g_file_test (_tmp21_, G_FILE_TEST_EXISTS)) {
					_g_free0 (t);
					_g_free0 (_tmp11_);
					break;
				}
				_g_free0 (filename);
				filename = NULL;
				_g_free0 (t);
				_g_free0 (_tmp11_);
			}
		}
	}
	result = filename;
	_g_free0 (basename);
	_g_free0 (type);
	_g_free0 (_tmp0_);
	return result;
}

static void
seahorse_ssh_source_authorize_async_data_free (gpointer _data)
{
	SeahorseSshSourceAuthorizeAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorseSshSourceAuthorizeAsyncData, _data_);
}

void
seahorse_ssh_source_authorize_async (SeahorseSshSource* self,
                                     SeahorseSshKey* key,
                                     gboolean authorize,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	SeahorseSshSourceAuthorizeAsyncData* _data_;
	SeahorseSshSource* _tmp0_;
	SeahorseSshKey* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_data_ = g_slice_new0 (SeahorseSshSourceAuthorizeAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_ssh_source_authorize_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (key);
	_g_object_unref0 (_data_->key);
	_data_->key = _tmp1_;
	_data_->authorize = authorize;
	seahorse_ssh_source_authorize_async_co (_data_);
}

void
seahorse_ssh_source_authorize_finish (SeahorseSshSource* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SeahorseSshSourceAuthorizeAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Adds/Removes a public key to/from the authorized keys.
     *
     * @param key The key that needs to be authorized.
     * @param authorize Whether the specified key needs to be (de-)authorized.
     */
static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		SeahorseSshSource* self;
		self = _data13_->self;
		_g_free0 (_data13_->to);
		_g_free0 (_data13_->from);
		_g_error_free0 (_data13_->err);
		(_data13_->callback_target_destroy_notify == NULL) ? NULL : (_data13_->callback_target_destroy_notify (_data13_->callback_target), NULL);
		_data13_->callback = NULL;
		_data13_->callback_target = NULL;
		_data13_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (_data13_->key);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
_seahorse_ssh_source_authorize_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = seahorse_ssh_source_authorize_async_co (self);
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void*
__lambda11_ (Block13Data* _data13_)
{
	SeahorseSshSource* self;
	GSourceFunc _tmp13_;
	gpointer _tmp13__target;
	GDestroyNotify _tmp13__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	void* result;
	self = _data13_->self;
	{
		SeahorseSshKeyData* keydata = NULL;
		SeahorseSshKeyData* _tmp0_;
		SeahorseSshKeyData* _tmp1_;
		SeahorseSshKeyData* _tmp2_;
		SeahorseSshKeyData* _tmp3_;
		const gchar* _tmp5_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		SeahorseSshKeyData* _tmp10_;
		_tmp0_ = seahorse_ssh_key_get_key_data (_data13_->key);
		_tmp1_ = _tmp0_;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		keydata = _tmp2_;
		_tmp3_ = keydata;
		if (_tmp3_ == NULL) {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (SEAHORSE_SSH_ERROR, SEAHORSE_SSH_ERROR_GENERAL, "Can't authorize empty key.");
			_inner_error0_ = _tmp4_;
			_g_object_unref0 (keydata);
			goto __catch0_g_error;
		}
		_tmp5_ = _data13_->from;
		if (g_file_test (_tmp5_, G_FILE_TEST_EXISTS)) {
			const gchar* _tmp6_;
			SeahorseSshKeyData* _tmp7_;
			_tmp6_ = _data13_->from;
			_tmp7_ = keydata;
			seahorse_ssh_key_data_filter_file (_tmp6_, NULL, _tmp7_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (keydata);
				goto __catch0_g_error;
			}
		}
		_tmp8_ = _data13_->to;
		seahorse_ssh_source_ensure_file_exists (self, _tmp8_);
		_tmp9_ = _data13_->to;
		_tmp10_ = keydata;
		seahorse_ssh_key_data_filter_file (_tmp9_, _tmp10_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (keydata);
			goto __catch0_g_error;
		}
		seahorse_ssh_key_refresh (_data13_->key);
		_g_object_unref0 (keydata);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		GError* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _g_error_copy0 (_tmp11_);
		_g_error_free0 (_data13_->err);
		_data13_->err = _tmp12_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp13_ = _data13_->callback;
	_tmp13__target = _data13_->callback_target;
	_tmp13__target_destroy_notify = _data13_->callback_target_destroy_notify;
	_data13_->callback = NULL;
	_data13_->callback_target = NULL;
	_data13_->callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, _tmp13__target, _tmp13__target_destroy_notify);
	result = NULL;
	return result;
}

static gpointer
___lambda11__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda11_ (self);
	block13_data_unref (self);
	return result;
}

static gboolean
seahorse_ssh_source_authorize_async_co (SeahorseSshSourceAuthorizeAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data13_ = g_slice_new0 (Block13Data);
	_data_->_data13_->_ref_count_ = 1;
	_data_->_data13_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data13_->key);
	_data_->_data13_->key = _data_->key;
	_data_->_data13_->_async_data_ = _data_;
	_data_->_data13_->callback = _seahorse_ssh_source_authorize_async_co_gsource_func;
	_data_->_data13_->callback_target = _data_;
	_data_->_data13_->callback_target_destroy_notify = NULL;
	_data_->_data13_->err = NULL;
	if (_data_->authorize) {
		_data_->_tmp0_ = seahorse_ssh_source_other_keys_path (_data_->self);
		_g_free0 (_data_->_data13_->from);
		_data_->_data13_->from = _data_->_tmp0_;
		_data_->_tmp1_ = seahorse_ssh_source_authorized_keys_path (_data_->self);
		_g_free0 (_data_->_data13_->to);
		_data_->_data13_->to = _data_->_tmp1_;
	} else {
		_data_->_tmp2_ = seahorse_ssh_source_authorized_keys_path (_data_->self);
		_g_free0 (_data_->_data13_->from);
		_data_->_data13_->from = _data_->_tmp2_;
		_data_->_tmp3_ = seahorse_ssh_source_other_keys_path (_data_->self);
		_g_free0 (_data_->_data13_->to);
		_data_->_data13_->to = _data_->_tmp3_;
	}
	_data_->_tmp4_ = g_thread_new ("authorize-async", ___lambda11__gthread_func, block13_data_ref (_data_->_data13_));
	_data_->thread = _data_->_tmp4_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = _data_->thread;
	_data_->thread = NULL;
	g_thread_join (_data_->_tmp5_);
	_data_->_tmp6_ = _data_->_data13_->err;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = _data_->_data13_->err;
		_data_->_tmp8_ = _g_error_copy0 (_data_->_tmp7_);
		_data_->_inner_error0_ = _data_->_tmp8_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_thread_unref0 (_data_->thread);
		block13_data_unref (_data_->_data13_);
		_data_->_data13_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_thread_unref0 (_data_->thread);
	block13_data_unref (_data_->_data13_);
	_data_->_data13_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_ssh_source_ensure_file_exists (SeahorseSshSource* self,
                                        const gchar* filename)
{
	gint fd = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	fd = open (filename, O_WRONLY | O_CREAT, (mode_t) 0644);
	close (fd);
}

SeahorseSshKey*
seahorse_ssh_source_find_key_by_fingerprint (SeahorseSshSource* self,
                                             const gchar* fingerprint)
{
	SeahorseSshKey* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (fingerprint != NULL, NULL);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				SeahorseSshKey* key = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				SeahorseSshKey* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp0_) {
					guint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->keys;
				if (!(i < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->keys;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, i);
				key = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, SEAHORSE_SSH_TYPE_KEY, SeahorseSshKey);
				_tmp5_ = key;
				_tmp6_ = seahorse_ssh_key_get_fingerprint (_tmp5_);
				_tmp7_ = _tmp6_;
				if (g_strcmp0 (_tmp7_, fingerprint) == 0) {
					result = key;
					return result;
				}
				_g_object_unref0 (key);
			}
		}
	}
	result = NULL;
	return result;
}

SeahorseSshSource*
seahorse_ssh_source_construct (GType object_type)
{
	SeahorseSshSource * self = NULL;
	self = (SeahorseSshSource*) g_object_new (object_type, NULL);
	return self;
}

SeahorseSshSource*
seahorse_ssh_source_new (void)
{
	return seahorse_ssh_source_construct (SEAHORSE_SSH_TYPE_SOURCE);
}

static gchar*
seahorse_ssh_source_real_get_label (SeahorsePlace* base)
{
	gchar* result;
	SeahorseSshSource* self;
	gchar* _tmp0_;
	self = (SeahorseSshSource*) base;
	_tmp0_ = g_strdup (_ ("OpenSSH keys"));
	result = _tmp0_;
	return result;
}

static void
seahorse_ssh_source_real_set_label (SeahorsePlace* base,
                                    const gchar* value)
{
	SeahorseSshSource* self;
	self = (SeahorseSshSource*) base;
	g_object_notify_by_pspec ((GObject *) self, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_LABEL_PROPERTY]);
}

static gchar*
seahorse_ssh_source_real_get_description (SeahorsePlace* base)
{
	gchar* result;
	SeahorseSshSource* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SeahorseSshSource*) base;
	_tmp0_ = self->priv->ssh_homedir;
	_tmp1_ = g_strdup_printf (_ ("OpenSSH: %s"), _tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
seahorse_ssh_source_real_get_uri (SeahorsePlace* base)
{
	gchar* result;
	SeahorseSshSource* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SeahorseSshSource*) base;
	_tmp0_ = self->priv->ssh_homedir;
	_tmp1_ = g_strdup_printf (_ ("openssh://%s"), _tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
seahorse_ssh_source_real_get_icon (SeahorsePlace* base)
{
	GIcon* result;
	SeahorseSshSource* self;
	GThemedIcon* _tmp0_;
	self = (SeahorseSshSource*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (GCR_ICON_HOME_DIRECTORY);
	result = (GIcon*) _tmp0_;
	return result;
}

static SeahorsePlaceCategory
seahorse_ssh_source_real_get_category (SeahorsePlace* base)
{
	SeahorsePlaceCategory result;
	SeahorseSshSource* self;
	self = (SeahorseSshSource*) base;
	result = SEAHORSE_PLACE_CATEGORY_KEYS;
	return result;
}

static GActionGroup*
seahorse_ssh_source_real_get_actions (SeahorsePlace* base)
{
	GActionGroup* result;
	SeahorseSshSource* self;
	self = (SeahorseSshSource*) base;
	result = NULL;
	return result;
}

static const gchar*
seahorse_ssh_source_real_get_action_prefix (SeahorsePlace* base)
{
	const gchar* result;
	SeahorseSshSource* self;
	self = (SeahorseSshSource*) base;
	result = NULL;
	return result;
}

static GMenuModel*
seahorse_ssh_source_real_get_menu_model (SeahorsePlace* base)
{
	GMenuModel* result;
	SeahorseSshSource* self;
	self = (SeahorseSshSource*) base;
	result = NULL;
	return result;
}

static gboolean
seahorse_ssh_source_real_get_show_if_empty (SeahorsePlace* base)
{
	gboolean result;
	SeahorseSshSource* self;
	self = (SeahorseSshSource*) base;
	result = TRUE;
	return result;
}

const gchar*
seahorse_ssh_source_get_base_directory (SeahorseSshSource* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ssh_homedir;
	result = _tmp0_;
	return result;
}

static GObject *
seahorse_ssh_source_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorseSshSource * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (seahorse_ssh_source_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup_printf ("%s/.ssh", _tmp0_);
	_g_free0 (self->priv->ssh_homedir);
	self->priv->ssh_homedir = _tmp1_;
	_tmp2_ = self->priv->ssh_homedir;
	if (!g_file_test (_tmp2_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->ssh_homedir;
		if (g_mkdir (_tmp3_, 0700) != 0) {
			const gchar* _tmp4_;
			_tmp4_ = self->priv->ssh_homedir;
			g_warning ("source.vala:95: couldn't create .ssh directory: %s", _tmp4_);
			return obj;
		}
	}
	seahorse_ssh_source_monitor_ssh_homedir (self);
	return obj;
}

static void
seahorse_ssh_source_class_init (SeahorseSshSourceClass * klass,
                                gpointer klass_data)
{
	seahorse_ssh_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseSshSource_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_ssh_source_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_ssh_source_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_ssh_source_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_ssh_source_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_LABEL_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_DESCRIPTION_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_URI_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_ICON_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_CATEGORY_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_CATEGORY_PROPERTY] = g_param_spec_enum ("category", "category", "category", SEAHORSE_PLACE_TYPE_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_ACTIONS_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_ACTION_PREFIX_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_ACTION_PREFIX_PROPERTY] = g_param_spec_string ("action-prefix", "action-prefix", "action-prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_MENU_MODEL_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_MENU_MODEL_PROPERTY] = g_param_spec_object ("menu-model", "menu-model", "menu-model", g_menu_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_SHOW_IF_EMPTY_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_SHOW_IF_EMPTY_PROPERTY] = g_param_spec_boolean ("show-if-empty", "show-if-empty", "show-if-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The directory containing the SSH keys.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_SSH_SOURCE_BASE_DIRECTORY_PROPERTY, seahorse_ssh_source_properties[SEAHORSE_SSH_SOURCE_BASE_DIRECTORY_PROPERTY] = g_param_spec_string ("base-directory", "base-directory", "base-directory", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_ssh_source_gcr_collection_interface_init (GcrCollectionIface * iface,
                                                   gpointer iface_data)
{
	seahorse_ssh_source_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_length = (guint (*) (GcrCollection*)) seahorse_ssh_source_real_get_length;
	iface->get_objects = (GList* (*) (GcrCollection*)) seahorse_ssh_source_real_get_objects;
	iface->contains = (gboolean (*) (GcrCollection*, GObject*)) seahorse_ssh_source_real_contains;
}

static void
seahorse_ssh_source_seahorse_place_interface_init (SeahorsePlaceIface * iface,
                                                   gpointer iface_data)
{
	seahorse_ssh_source_seahorse_place_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (void (*) (SeahorsePlace*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_ssh_source_real_load;
	iface->load_finish = (gboolean (*) (SeahorsePlace*, GAsyncResult*, GError**)) seahorse_ssh_source_load_finish;
	iface->get_label = seahorse_ssh_source_real_get_label;
	iface->set_label = seahorse_ssh_source_real_set_label;
	iface->get_description = seahorse_ssh_source_real_get_description;
	iface->get_uri = seahorse_ssh_source_real_get_uri;
	iface->get_icon = seahorse_ssh_source_real_get_icon;
	iface->get_category = seahorse_ssh_source_real_get_category;
	iface->get_actions = seahorse_ssh_source_real_get_actions;
	iface->get_action_prefix = seahorse_ssh_source_real_get_action_prefix;
	iface->get_menu_model = seahorse_ssh_source_real_get_menu_model;
	iface->get_show_if_empty = seahorse_ssh_source_real_get_show_if_empty;
}

static void
seahorse_ssh_source_instance_init (SeahorseSshSource * self,
                                   gpointer klass)
{
	GListStore* _tmp0_;
	self->priv = seahorse_ssh_source_get_instance_private (self);
	self->priv->scheduled_refresh_source = (guint) 0;
	self->priv->monitor_handle = NULL;
	_tmp0_ = g_list_store_new (SEAHORSE_SSH_TYPE_KEY);
	self->priv->keys = _tmp0_;
}

static void
seahorse_ssh_source_finalize (GObject * obj)
{
	SeahorseSshSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource);
	_g_free0 (self->priv->ssh_homedir);
	_g_object_unref0 (self->priv->monitor_handle);
	_g_object_unref0 (self->priv->keys);
	G_OBJECT_CLASS (seahorse_ssh_source_parent_class)->finalize (obj);
}

/**
 * The {@link Place} where SSH keys are stored. By default that is ~/.ssh.
 * Basically, this becomes an interface to the SSH home directory.
 */
 G_GNUC_NO_INLINE static GType
seahorse_ssh_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseSshSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_ssh_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseSshSource), 0, (GInstanceInitFunc) seahorse_ssh_source_instance_init, NULL };
	static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_ssh_source_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_place_info = { (GInterfaceInitFunc) seahorse_ssh_source_seahorse_place_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_ssh_source_type_id;
	seahorse_ssh_source_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorseSshSource", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_ssh_source_type_id, gcr_collection_get_type (), &gcr_collection_info);
	g_type_add_interface_static (seahorse_ssh_source_type_id, SEAHORSE_TYPE_PLACE, &seahorse_place_info);
	SeahorseSshSource_private_offset = g_type_add_instance_private (seahorse_ssh_source_type_id, sizeof (SeahorseSshSourcePrivate));
	return seahorse_ssh_source_type_id;
}

GType
seahorse_ssh_source_get_type (void)
{
	static volatile gsize seahorse_ssh_source_type_id__once = 0;
	if (g_once_init_enter (&seahorse_ssh_source_type_id__once)) {
		GType seahorse_ssh_source_type_id;
		seahorse_ssh_source_type_id = seahorse_ssh_source_get_type_once ();
		g_once_init_leave (&seahorse_ssh_source_type_id__once, seahorse_ssh_source_type_id);
	}
	return seahorse_ssh_source_type_id__once;
}

static void
_vala_seahorse_ssh_source_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	SeahorseSshSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource);
	switch (property_id) {
		case SEAHORSE_SSH_SOURCE_LABEL_PROPERTY:
		g_value_take_string (value, seahorse_place_get_label ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_DESCRIPTION_PROPERTY:
		g_value_take_string (value, seahorse_place_get_description ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_URI_PROPERTY:
		g_value_take_string (value, seahorse_place_get_uri ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_ICON_PROPERTY:
		g_value_take_object (value, seahorse_place_get_icon ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_CATEGORY_PROPERTY:
		g_value_set_enum (value, seahorse_place_get_category ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_ACTIONS_PROPERTY:
		g_value_take_object (value, seahorse_place_get_actions ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_ACTION_PREFIX_PROPERTY:
		g_value_set_string (value, seahorse_place_get_action_prefix ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_MENU_MODEL_PROPERTY:
		g_value_take_object (value, seahorse_place_get_menu_model ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_SHOW_IF_EMPTY_PROPERTY:
		g_value_set_boolean (value, seahorse_place_get_show_if_empty ((SeahorsePlace*) self));
		break;
		case SEAHORSE_SSH_SOURCE_BASE_DIRECTORY_PROPERTY:
		g_value_set_string (value, seahorse_ssh_source_get_base_directory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_ssh_source_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	SeahorseSshSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_SSH_TYPE_SOURCE, SeahorseSshSource);
	switch (property_id) {
		case SEAHORSE_SSH_SOURCE_LABEL_PROPERTY:
		seahorse_place_set_label ((SeahorsePlace*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

