/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.SwallowedExceptionLogger;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.CPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PerUserPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PoolKey;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;

public class PerUserPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = 7872747993848065028L;
    private static final Log log = LogFactory.getLog(PerUserPoolDataSource.class);
    private Map<String, Boolean> perUserBlockWhenExhausted;
    private Map<String, String> perUserEvictionPolicyClassName;
    private Map<String, Boolean> perUserLifo;
    private Map<String, Integer> perUserMaxIdle;
    private Map<String, Integer> perUserMaxTotal;
    private Map<String, Duration> perUserMaxWaitDuration;
    private Map<String, Duration> perUserMinEvictableIdleDuration;
    private Map<String, Integer> perUserMinIdle;
    private Map<String, Integer> perUserNumTestsPerEvictionRun;
    private Map<String, Duration> perUserSoftMinEvictableIdleDuration;
    private Map<String, Boolean> perUserTestOnCreate;
    private Map<String, Boolean> perUserTestOnBorrow;
    private Map<String, Boolean> perUserTestOnReturn;
    private Map<String, Boolean> perUserTestWhileIdle;
    private Map<String, Duration> perUserDurationBetweenEvictionRuns;
    private Map<String, Boolean> perUserDefaultAutoCommit;
    private Map<String, Integer> perUserDefaultTransactionIsolation;
    private Map<String, Boolean> perUserDefaultReadOnly;
    private transient Map<PoolKey, PooledConnectionManager> managers = new HashMap<PoolKey, PooledConnectionManager>();

    public void clear() {
        for (PooledConnectionManager pooledConnectionManager : this.managers.values()) {
            try {
                this.getCPDSConnectionFactoryPool(pooledConnectionManager).clear();
            }
            catch (Exception exception) {}
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    @Override
    public void close() {
        for (PooledConnectionManager pooledConnectionManager : this.managers.values()) {
            Utils.closeQuietly(this.getCPDSConnectionFactoryPool(pooledConnectionManager));
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    private Map<String, Duration> convertMap(Map<String, Duration> map, Map<String, Long> map2) {
        HashMap<String, Duration> hashMap = new HashMap<String, Duration>();
        map2.forEach((string, l) -> hashMap.put((String)string, this.toDurationOrNull((Long)l)));
        if (map == null) {
            return hashMap;
        }
        map.clear();
        map.putAll(hashMap);
        return map;
    }

    private HashMap<String, Boolean> createMap() {
        return new HashMap<String, Boolean>();
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey userPassKey) {
        return this.managers.get(this.getPoolKey(userPassKey.getUserName()));
    }

    private ObjectPool<PooledConnectionAndInfo> getCPDSConnectionFactoryPool(PooledConnectionManager pooledConnectionManager) {
        return ((CPDSConnectionFactory)pooledConnectionManager).getPool();
    }

    public int getNumActive() {
        return this.getNumActive(null);
    }

    public int getNumActive(String string) {
        ObjectPool<PooledConnectionAndInfo> objectPool = this.getPool(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumActive();
    }

    public int getNumIdle() {
        return this.getNumIdle(null);
    }

    public int getNumIdle(String string) {
        ObjectPool<PooledConnectionAndInfo> objectPool = this.getPool(this.getPoolKey(string));
        return objectPool == null ? 0 : objectPool.getNumIdle();
    }

    public boolean getPerUserBlockWhenExhausted(String string) {
        Boolean bl = null;
        if (this.perUserBlockWhenExhausted != null) {
            bl = this.perUserBlockWhenExhausted.get(string);
        }
        if (bl == null) {
            return this.getDefaultBlockWhenExhausted();
        }
        return bl;
    }

    public Boolean getPerUserDefaultAutoCommit(String string) {
        Boolean bl = null;
        if (this.perUserDefaultAutoCommit != null) {
            bl = this.perUserDefaultAutoCommit.get(string);
        }
        return bl;
    }

    public Boolean getPerUserDefaultReadOnly(String string) {
        Boolean bl = null;
        if (this.perUserDefaultReadOnly != null) {
            bl = this.perUserDefaultReadOnly.get(string);
        }
        return bl;
    }

    public Integer getPerUserDefaultTransactionIsolation(String string) {
        Integer n = null;
        if (this.perUserDefaultTransactionIsolation != null) {
            n = this.perUserDefaultTransactionIsolation.get(string);
        }
        return n;
    }

    public Duration getPerUserDurationBetweenEvictionRuns(String string) {
        Duration duration = null;
        if (this.perUserDurationBetweenEvictionRuns != null) {
            duration = this.perUserDurationBetweenEvictionRuns.get(string);
        }
        if (duration == null) {
            return this.getDefaultDurationBetweenEvictionRuns();
        }
        return duration;
    }

    public String getPerUserEvictionPolicyClassName(String string) {
        String string2 = null;
        if (this.perUserEvictionPolicyClassName != null) {
            string2 = this.perUserEvictionPolicyClassName.get(string);
        }
        if (string2 == null) {
            return this.getDefaultEvictionPolicyClassName();
        }
        return string2;
    }

    public boolean getPerUserLifo(String string) {
        Boolean bl = null;
        if (this.perUserLifo != null) {
            bl = this.perUserLifo.get(string);
        }
        if (bl == null) {
            return this.getDefaultLifo();
        }
        return bl;
    }

    public int getPerUserMaxIdle(String string) {
        Integer n = null;
        if (this.perUserMaxIdle != null) {
            n = this.perUserMaxIdle.get(string);
        }
        if (n == null) {
            return this.getDefaultMaxIdle();
        }
        return n;
    }

    public int getPerUserMaxTotal(String string) {
        Integer n = null;
        if (this.perUserMaxTotal != null) {
            n = this.perUserMaxTotal.get(string);
        }
        if (n == null) {
            return this.getDefaultMaxTotal();
        }
        return n;
    }

    public Duration getPerUserMaxWaitDuration(String string) {
        Duration duration = null;
        if (this.perUserMaxWaitDuration != null) {
            duration = this.perUserMaxWaitDuration.get(string);
        }
        if (duration == null) {
            return this.getDefaultMaxWait();
        }
        return duration;
    }

    @Deprecated
    public long getPerUserMaxWaitMillis(String string) {
        return this.getPerUserMaxWaitDuration(string).toMillis();
    }

    public Duration getPerUserMinEvictableIdleDuration(String string) {
        Duration duration = null;
        if (this.perUserMinEvictableIdleDuration != null) {
            duration = this.perUserMinEvictableIdleDuration.get(string);
        }
        if (duration == null) {
            return this.getDefaultMinEvictableIdleDuration();
        }
        return duration;
    }

    @Deprecated
    public long getPerUserMinEvictableIdleTimeMillis(String string) {
        return this.getPerUserMinEvictableIdleDuration(string).toMillis();
    }

    public int getPerUserMinIdle(String string) {
        Integer n = null;
        if (this.perUserMinIdle != null) {
            n = this.perUserMinIdle.get(string);
        }
        if (n == null) {
            return this.getDefaultMinIdle();
        }
        return n;
    }

    public int getPerUserNumTestsPerEvictionRun(String string) {
        Integer n = null;
        if (this.perUserNumTestsPerEvictionRun != null) {
            n = this.perUserNumTestsPerEvictionRun.get(string);
        }
        if (n == null) {
            return this.getDefaultNumTestsPerEvictionRun();
        }
        return n;
    }

    public Duration getPerUserSoftMinEvictableIdleDuration(String string) {
        Duration duration = null;
        if (this.perUserSoftMinEvictableIdleDuration != null) {
            duration = this.perUserSoftMinEvictableIdleDuration.get(string);
        }
        if (duration == null) {
            return this.getDefaultSoftMinEvictableIdleDuration();
        }
        return duration;
    }

    @Deprecated
    public long getPerUserSoftMinEvictableIdleTimeMillis(String string) {
        return this.getPerUserSoftMinEvictableIdleDuration(string).toMillis();
    }

    public boolean getPerUserTestOnBorrow(String string) {
        Boolean bl = null;
        if (this.perUserTestOnBorrow != null) {
            bl = this.perUserTestOnBorrow.get(string);
        }
        if (bl == null) {
            return this.getDefaultTestOnBorrow();
        }
        return bl;
    }

    public boolean getPerUserTestOnCreate(String string) {
        Boolean bl = null;
        if (this.perUserTestOnCreate != null) {
            bl = this.perUserTestOnCreate.get(string);
        }
        if (bl == null) {
            return this.getDefaultTestOnCreate();
        }
        return bl;
    }

    public boolean getPerUserTestOnReturn(String string) {
        Boolean bl = null;
        if (this.perUserTestOnReturn != null) {
            bl = this.perUserTestOnReturn.get(string);
        }
        if (bl == null) {
            return this.getDefaultTestOnReturn();
        }
        return bl;
    }

    public boolean getPerUserTestWhileIdle(String string) {
        Boolean bl = null;
        if (this.perUserTestWhileIdle != null) {
            bl = this.perUserTestWhileIdle.get(string);
        }
        if (bl == null) {
            return this.getDefaultTestWhileIdle();
        }
        return bl;
    }

    @Deprecated
    public long getPerUserTimeBetweenEvictionRunsMillis(String string) {
        return this.getPerUserDurationBetweenEvictionRuns(string).toMillis();
    }

    private ObjectPool<PooledConnectionAndInfo> getPool(PoolKey poolKey) {
        CPDSConnectionFactory cPDSConnectionFactory = (CPDSConnectionFactory)this.managers.get(poolKey);
        return cPDSConnectionFactory == null ? null : cPDSConnectionFactory.getPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        ObjectPool<PooledConnectionAndInfo> objectPool;
        PooledConnectionManager pooledConnectionManager;
        PoolKey poolKey = this.getPoolKey(string);
        Object object = this;
        synchronized (object) {
            pooledConnectionManager = this.managers.get(poolKey);
            if (pooledConnectionManager == null) {
                try {
                    this.registerPool(string, string2);
                    pooledConnectionManager = this.managers.get(poolKey);
                }
                catch (NamingException namingException) {
                    throw new SQLException("RegisterPool failed", namingException);
                }
            }
            objectPool = this.getCPDSConnectionFactoryPool(pooledConnectionManager);
        }
        object = null;
        try {
            object = objectPool.borrowObject();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Could not retrieve connection info from pool", noSuchElementException);
        }
        catch (Exception exception) {
            try {
                this.testCPDS(string, string2);
            }
            catch (Exception exception2) {
                throw new SQLException("Could not retrieve connection info from pool", exception2);
            }
            pooledConnectionManager.closePool(string);
            PerUserPoolDataSource perUserPoolDataSource = this;
            synchronized (perUserPoolDataSource) {
                this.managers.remove(poolKey);
            }
            try {
                this.registerPool(string, string2);
                objectPool = this.getPool(poolKey);
            }
            catch (NamingException namingException) {
                throw new SQLException("RegisterPool failed", namingException);
            }
            try {
                object = objectPool.borrowObject();
            }
            catch (Exception exception3) {
                throw new SQLException("Could not retrieve connection info from pool", exception3);
            }
        }
        return object;
    }

    private PoolKey getPoolKey(String string) {
        return new PoolKey(this.getDataSourceName(), string);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), PerUserPoolDataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return reference;
    }

    private Map<String, Duration> makeMap(Map<String, Duration> map, Map<String, Duration> map2) {
        if (map == null) {
            return new HashMap<String, Duration>(map2);
        }
        map.clear();
        map.putAll(map2);
        return map;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            objectInputStream.defaultReadObject();
            PerUserPoolDataSource perUserPoolDataSource = (PerUserPoolDataSource)new PerUserPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), (Name)null, (Context)null, (Hashtable)null);
            this.managers = perUserPoolDataSource.managers;
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + namingException);
        }
    }

    private synchronized void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        CPDSConnectionFactory cPDSConnectionFactory = new CPDSConnectionFactory(connectionPoolDataSource, this.getValidationQuery(), this.getValidationQueryTimeoutDuration(), this.isRollbackAfterValidation(), string, string2);
        cPDSConnectionFactory.setMaxConn(this.getMaxConnDuration());
        GenericObjectPool<PooledConnectionAndInfo> genericObjectPool = new GenericObjectPool<PooledConnectionAndInfo>(cPDSConnectionFactory);
        cPDSConnectionFactory.setPool(genericObjectPool);
        genericObjectPool.setBlockWhenExhausted(this.getPerUserBlockWhenExhausted(string));
        genericObjectPool.setEvictionPolicyClassName(this.getPerUserEvictionPolicyClassName(string));
        genericObjectPool.setLifo(this.getPerUserLifo(string));
        genericObjectPool.setMaxIdle(this.getPerUserMaxIdle(string));
        genericObjectPool.setMaxTotal(this.getPerUserMaxTotal(string));
        genericObjectPool.setMaxWait(Duration.ofMillis(this.getPerUserMaxWaitMillis(string)));
        genericObjectPool.setMinEvictableIdle(this.getPerUserMinEvictableIdleDuration(string));
        genericObjectPool.setMinIdle(this.getPerUserMinIdle(string));
        genericObjectPool.setNumTestsPerEvictionRun(this.getPerUserNumTestsPerEvictionRun(string));
        genericObjectPool.setSoftMinEvictableIdle(this.getPerUserSoftMinEvictableIdleDuration(string));
        genericObjectPool.setTestOnCreate(this.getPerUserTestOnCreate(string));
        genericObjectPool.setTestOnBorrow(this.getPerUserTestOnBorrow(string));
        genericObjectPool.setTestOnReturn(this.getPerUserTestOnReturn(string));
        genericObjectPool.setTestWhileIdle(this.getPerUserTestWhileIdle(string));
        genericObjectPool.setTimeBetweenEvictionRuns(this.getPerUserDurationBetweenEvictionRuns(string));
        genericObjectPool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log));
        PooledConnectionManager pooledConnectionManager = this.managers.put(this.getPoolKey(string), cPDSConnectionFactory);
        if (pooledConnectionManager != null) {
            throw new IllegalStateException("Pool already contains an entry for this user/password: " + string);
        }
    }

    void setPerUserBlockWhenExhausted(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserBlockWhenExhausted == null) {
            this.perUserBlockWhenExhausted = this.createMap();
        } else {
            this.perUserBlockWhenExhausted.clear();
        }
        this.perUserBlockWhenExhausted.putAll(map);
    }

    public void setPerUserBlockWhenExhausted(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserBlockWhenExhausted == null) {
            this.perUserBlockWhenExhausted = this.createMap();
        }
        this.perUserBlockWhenExhausted.put(string, bl);
    }

    void setPerUserDefaultAutoCommit(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = this.createMap();
        } else {
            this.perUserDefaultAutoCommit.clear();
        }
        this.perUserDefaultAutoCommit.putAll(map);
    }

    public void setPerUserDefaultAutoCommit(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultAutoCommit == null) {
            this.perUserDefaultAutoCommit = this.createMap();
        }
        this.perUserDefaultAutoCommit.put(string, bl);
    }

    void setPerUserDefaultReadOnly(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = this.createMap();
        } else {
            this.perUserDefaultReadOnly.clear();
        }
        this.perUserDefaultReadOnly.putAll(map);
    }

    public void setPerUserDefaultReadOnly(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultReadOnly == null) {
            this.perUserDefaultReadOnly = this.createMap();
        }
        this.perUserDefaultReadOnly.put(string, bl);
    }

    void setPerUserDefaultTransactionIsolation(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        } else {
            this.perUserDefaultTransactionIsolation.clear();
        }
        this.perUserDefaultTransactionIsolation.putAll(map);
    }

    public void setPerUserDefaultTransactionIsolation(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserDefaultTransactionIsolation == null) {
            this.perUserDefaultTransactionIsolation = new HashMap<String, Integer>();
        }
        this.perUserDefaultTransactionIsolation.put(string, n);
    }

    void setPerUserDurationBetweenEvictionRuns(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserDurationBetweenEvictionRuns = this.makeMap(this.perUserDurationBetweenEvictionRuns, map);
    }

    public void setPerUserDurationBetweenEvictionRuns(String string, Duration duration) {
        this.assertInitializationAllowed();
        if (this.perUserDurationBetweenEvictionRuns == null) {
            this.perUserDurationBetweenEvictionRuns = new HashMap<String, Duration>();
        }
        this.perUserDurationBetweenEvictionRuns.put(string, duration);
    }

    void setPerUserEvictionPolicyClassName(Map<String, String> map) {
        this.assertInitializationAllowed();
        if (this.perUserEvictionPolicyClassName == null) {
            this.perUserEvictionPolicyClassName = new HashMap<String, String>();
        } else {
            this.perUserEvictionPolicyClassName.clear();
        }
        this.perUserEvictionPolicyClassName.putAll(map);
    }

    public void setPerUserEvictionPolicyClassName(String string, String string2) {
        this.assertInitializationAllowed();
        if (this.perUserEvictionPolicyClassName == null) {
            this.perUserEvictionPolicyClassName = new HashMap<String, String>();
        }
        this.perUserEvictionPolicyClassName.put(string, string2);
    }

    void setPerUserLifo(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserLifo == null) {
            this.perUserLifo = this.createMap();
        } else {
            this.perUserLifo.clear();
        }
        this.perUserLifo.putAll(map);
    }

    public void setPerUserLifo(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserLifo == null) {
            this.perUserLifo = this.createMap();
        }
        this.perUserLifo.put(string, bl);
    }

    void setPerUserMaxIdle(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        } else {
            this.perUserMaxIdle.clear();
        }
        this.perUserMaxIdle.putAll(map);
    }

    public void setPerUserMaxIdle(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxIdle == null) {
            this.perUserMaxIdle = new HashMap<String, Integer>();
        }
        this.perUserMaxIdle.put(string, n);
    }

    void setPerUserMaxTotal(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        } else {
            this.perUserMaxTotal.clear();
        }
        this.perUserMaxTotal.putAll(map);
    }

    public void setPerUserMaxTotal(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMaxTotal == null) {
            this.perUserMaxTotal = new HashMap<String, Integer>();
        }
        this.perUserMaxTotal.put(string, n);
    }

    void setPerUserMaxWaitDuration(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserMaxWaitDuration = this.makeMap(this.perUserMaxWaitDuration, map);
    }

    public void setPerUserMaxWait(String string, Duration duration) {
        this.assertInitializationAllowed();
        if (this.perUserMaxWaitDuration == null) {
            this.perUserMaxWaitDuration = new HashMap<String, Duration>();
        }
        this.perUserMaxWaitDuration.put(string, duration);
    }

    void setPerUserMaxWaitMillis(Map<String, Long> map) {
        this.assertInitializationAllowed();
        this.perUserMaxWaitDuration = this.convertMap(this.perUserMaxWaitDuration, map);
    }

    @Deprecated
    public void setPerUserMaxWaitMillis(String string, Long l) {
        this.setPerUserMaxWait(string, this.toDurationOrNull(l));
    }

    void setPerUserMinEvictableIdle(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserMinEvictableIdleDuration = this.makeMap(this.perUserMinEvictableIdleDuration, map);
    }

    public void setPerUserMinEvictableIdle(String string, Duration duration) {
        this.assertInitializationAllowed();
        if (this.perUserMinEvictableIdleDuration == null) {
            this.perUserMinEvictableIdleDuration = new HashMap<String, Duration>();
        }
        this.perUserMinEvictableIdleDuration.put(string, duration);
    }

    @Deprecated
    public void setPerUserMinEvictableIdleTimeMillis(String string, Long l) {
        this.setPerUserMinEvictableIdle(string, this.toDurationOrNull(l));
    }

    void setPerUserMinIdle(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        if (this.perUserMinIdle == null) {
            this.perUserMinIdle = new HashMap<String, Integer>();
        } else {
            this.perUserMinIdle.clear();
        }
        this.perUserMinIdle.putAll(map);
    }

    public void setPerUserMinIdle(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserMinIdle == null) {
            this.perUserMinIdle = new HashMap<String, Integer>();
        }
        this.perUserMinIdle.put(string, n);
    }

    void setPerUserNumTestsPerEvictionRun(Map<String, Integer> map) {
        this.assertInitializationAllowed();
        if (this.perUserNumTestsPerEvictionRun == null) {
            this.perUserNumTestsPerEvictionRun = new HashMap<String, Integer>();
        } else {
            this.perUserNumTestsPerEvictionRun.clear();
        }
        this.perUserNumTestsPerEvictionRun.putAll(map);
    }

    public void setPerUserNumTestsPerEvictionRun(String string, Integer n) {
        this.assertInitializationAllowed();
        if (this.perUserNumTestsPerEvictionRun == null) {
            this.perUserNumTestsPerEvictionRun = new HashMap<String, Integer>();
        }
        this.perUserNumTestsPerEvictionRun.put(string, n);
    }

    void setPerUserSoftMinEvictableIdle(Map<String, Duration> map) {
        this.assertInitializationAllowed();
        this.perUserSoftMinEvictableIdleDuration = this.makeMap(this.perUserSoftMinEvictableIdleDuration, map);
    }

    public void setPerUserSoftMinEvictableIdle(String string, Duration duration) {
        this.assertInitializationAllowed();
        if (this.perUserSoftMinEvictableIdleDuration == null) {
            this.perUserSoftMinEvictableIdleDuration = new HashMap<String, Duration>();
        }
        this.perUserSoftMinEvictableIdleDuration.put(string, duration);
    }

    @Deprecated
    public void setPerUserSoftMinEvictableIdleTimeMillis(String string, Long l) {
        this.setPerUserSoftMinEvictableIdle(string, this.toDurationOrNull(l));
    }

    void setPerUserTestOnBorrow(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnBorrow == null) {
            this.perUserTestOnBorrow = this.createMap();
        } else {
            this.perUserTestOnBorrow.clear();
        }
        this.perUserTestOnBorrow.putAll(map);
    }

    public void setPerUserTestOnBorrow(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnBorrow == null) {
            this.perUserTestOnBorrow = this.createMap();
        }
        this.perUserTestOnBorrow.put(string, bl);
    }

    void setPerUserTestOnCreate(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnCreate == null) {
            this.perUserTestOnCreate = this.createMap();
        } else {
            this.perUserTestOnCreate.clear();
        }
        this.perUserTestOnCreate.putAll(map);
    }

    public void setPerUserTestOnCreate(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnCreate == null) {
            this.perUserTestOnCreate = this.createMap();
        }
        this.perUserTestOnCreate.put(string, bl);
    }

    void setPerUserTestOnReturn(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnReturn == null) {
            this.perUserTestOnReturn = this.createMap();
        } else {
            this.perUserTestOnReturn.clear();
        }
        this.perUserTestOnReturn.putAll(map);
    }

    public void setPerUserTestOnReturn(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserTestOnReturn == null) {
            this.perUserTestOnReturn = this.createMap();
        }
        this.perUserTestOnReturn.put(string, bl);
    }

    void setPerUserTestWhileIdle(Map<String, Boolean> map) {
        this.assertInitializationAllowed();
        if (this.perUserTestWhileIdle == null) {
            this.perUserTestWhileIdle = this.createMap();
        } else {
            this.perUserTestWhileIdle.clear();
        }
        this.perUserTestWhileIdle.putAll(map);
    }

    public void setPerUserTestWhileIdle(String string, Boolean bl) {
        this.assertInitializationAllowed();
        if (this.perUserTestWhileIdle == null) {
            this.perUserTestWhileIdle = this.createMap();
        }
        this.perUserTestWhileIdle.put(string, bl);
    }

    @Deprecated
    public void setPerUserTimeBetweenEvictionRunsMillis(String string, Long l) {
        this.setPerUserDurationBetweenEvictionRuns(string, this.toDurationOrNull(l));
    }

    @Override
    protected void setupDefaults(Connection connection, String string) throws SQLException {
        Integer n;
        Boolean bl;
        Boolean bl2;
        Boolean bl3 = this.isDefaultAutoCommit();
        if (string != null && (bl2 = this.getPerUserDefaultAutoCommit(string)) != null) {
            bl3 = bl2;
        }
        bl2 = this.isDefaultReadOnly();
        if (string != null && (bl = this.getPerUserDefaultReadOnly(string)) != null) {
            bl2 = bl;
        }
        int n2 = this.getDefaultTransactionIsolation();
        if (string != null && (n = this.getPerUserDefaultTransactionIsolation(string)) != null) {
            n2 = n;
        }
        if (bl3 != null && connection.getAutoCommit() != bl3.booleanValue()) {
            connection.setAutoCommit(bl3);
        }
        if (n2 != -1) {
            connection.setTransactionIsolation(n2);
        }
        if (bl2 != null && connection.isReadOnly() != bl2.booleanValue()) {
            connection.setReadOnly(bl2);
        }
    }

    private Duration toDurationOrNull(Long l) {
        return l == null ? null : Duration.ofMillis(l);
    }
}

