/* tracker-backend.c generated by valac 0.56.1, the Vala compiler
 * generated from tracker-backend.vala, do not modify */

/*
 * Copyright (C) 2010, Nokia <ivan.frade@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */
/* All apps using libtracker-sparql will call one of these constructors, so
 * we take the opportunity to call tracker_get_debug_flags(). This has the
 * effect of printing the 'help' message if TRACKER_DEBUG=help is set.
 */

#include "tracker-sparql-3.0.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "libtracker-sparql/tracker-sparql.h"
#include "libtracker-common/tracker-debug.h"
#include <glib-object.h>
#include "tracker-bus.h"
#include "tracker-direct.h"

typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TrackerSparqlConnectionBusNewAsyncData TrackerSparqlConnectionBusNewAsyncData;
typedef struct _TrackerSparqlConnectionNewAsyncData TrackerSparqlConnectionNewAsyncData;

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	GError* _error_;
	TrackerSparqlConnection* sparql_conn;
};

struct _TrackerSparqlConnectionBusNewAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* service;
	gchar* object_path;
	GDBusConnection* conn;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	GDBusConnection* dbus_conn;
	gchar* path;
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	GDBusConnection* _tmp2_;
	GDBusConnection* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TrackerBusConnection* _tmp6_;
	const gchar* _tmp7_;
	GDBusConnection* _tmp8_;
	TrackerBusConnection* _tmp9_;
	TrackerBusConnection* _tmp10_;
	GError* _inner_error0_;
};

struct _TrackerSparqlConnectionNewAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TrackerSparqlConnectionFlags flags;
	GFile* store;
	GFile* ontology;
	GCancellable* cancellable;
	TrackerSparqlConnection* result;
	TrackerDirectConnection* conn;
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* _tmp1_;
	GError* _inner_error0_;
};

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda4_ (Block1Data* _data1_,
                 GObject* o,
                 GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void tracker_sparql_connection_bus_new_async_data_free (gpointer _data);
static gboolean tracker_sparql_connection_bus_new_async_co (TrackerSparqlConnectionBusNewAsyncData* _data_);
static void tracker_sparql_connection_bus_new_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void tracker_sparql_connection_new_async_data_free (gpointer _data);
static gboolean tracker_sparql_connection_new_async_co (TrackerSparqlConnectionNewAsyncData* _data_);
static void tracker_sparql_connection_new_async_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->sparql_conn);
		_g_error_free0 (_data1_->_error_);
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
__lambda4_ (Block1Data* _data1_,
            GObject* o,
            GAsyncResult* res)
{
	GMainLoop* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		TrackerSparqlConnection* _tmp0_ = NULL;
		TrackerSparqlConnection* _tmp1_;
		TrackerSparqlConnection* _tmp2_;
		_tmp1_ = tracker_sparql_connection_bus_new_finish (res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (_data1_->sparql_conn);
		_data1_->sparql_conn = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		GError* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _g_error_copy0 (_tmp3_);
		_g_error_free0 (_data1_->_error_);
		_data1_->_error_ = _tmp4_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = _data1_->loop;
	g_main_loop_quit (_tmp5_);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TrackerSparqlConnection*
tracker_sparql_connection_bus_new (const gchar* service,
                                   const gchar* object_path,
                                   GDBusConnection* conn,
                                   GError** error)
{
	Block1Data* _data1_;
	GMainContext* context = NULL;
	GMainContext* _tmp0_;
	GMainContext* _tmp1_;
	GMainLoop* _tmp2_;
	GMainContext* _tmp3_;
	GMainLoop* _tmp4_;
	GMainContext* _tmp5_;
	GError* _tmp6_;
	TrackerSparqlConnection* _tmp9_;
	TrackerSparqlConnection* _tmp10_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	g_return_val_if_fail (service != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	tracker_get_debug_flags ();
	_tmp0_ = g_main_context_new ();
	context = _tmp0_;
	_tmp1_ = context;
	_tmp2_ = g_main_loop_new (_tmp1_, FALSE);
	_data1_->loop = _tmp2_;
	_data1_->_error_ = NULL;
	_data1_->sparql_conn = NULL;
	_tmp3_ = context;
	g_main_context_push_thread_default (_tmp3_);
	tracker_sparql_connection_bus_new_async (service, object_path, conn, NULL, ___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp4_ = _data1_->loop;
	g_main_loop_run (_tmp4_);
	_tmp5_ = context;
	g_main_context_pop_thread_default (_tmp5_);
	_tmp6_ = _data1_->_error_;
	if (_tmp6_ != NULL) {
		GError* _tmp7_;
		GError* _tmp8_;
		_tmp7_ = _data1_->_error_;
		_tmp8_ = _g_error_copy0 (_tmp7_);
		_inner_error0_ = _tmp8_;
		g_propagate_error (error, _inner_error0_);
		_g_main_context_unref0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return NULL;
	}
	_tmp9_ = _data1_->sparql_conn;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	result = _tmp10_;
	_g_main_context_unref0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
tracker_sparql_connection_bus_new_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionBusNewAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->service);
	_g_free0 (_data_->object_path);
	_g_object_unref0 (_data_->conn);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionBusNewAsyncData, _data_);
}

void
tracker_sparql_connection_bus_new_async (const gchar* service,
                                         const gchar* object_path,
                                         GDBusConnection* conn,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	TrackerSparqlConnectionBusNewAsyncData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDBusConnection* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (service != NULL);
	_data_ = g_slice_new0 (TrackerSparqlConnectionBusNewAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_bus_new_async_data_free);
	_tmp0_ = g_strdup (service);
	_g_free0 (_data_->service);
	_data_->service = _tmp0_;
	_tmp1_ = g_strdup (object_path);
	_g_free0 (_data_->object_path);
	_data_->object_path = _tmp1_;
	_tmp2_ = _g_object_ref0 (conn);
	_g_object_unref0 (_data_->conn);
	_data_->conn = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	tracker_sparql_connection_bus_new_async_co (_data_);
}

TrackerSparqlConnection*
tracker_sparql_connection_bus_new_finish (GAsyncResult* _res_,
                                          GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionBusNewAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_connection_bus_new_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	TrackerSparqlConnectionBusNewAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_connection_bus_new_async_co (_data_);
}

static gboolean
tracker_sparql_connection_bus_new_async_co (TrackerSparqlConnectionBusNewAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	tracker_get_debug_flags ();
	if (_data_->conn != NULL) {
		_data_->_tmp0_ = _g_object_ref0 (_data_->conn);
		_g_object_unref0 (_data_->dbus_conn);
		_data_->dbus_conn = _data_->_tmp0_;
	} else {
		_data_->_state_ = 1;
		g_bus_get (G_BUS_TYPE_SESSION, _data_->cancellable, tracker_sparql_connection_bus_new_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = g_bus_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->dbus_conn);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->dbus_conn);
		_data_->dbus_conn = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp1_);
	}
	if (_data_->object_path != NULL) {
		_data_->_tmp4_ = g_strdup (_data_->object_path);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp4_;
	} else {
		_data_->_tmp5_ = g_strdup ("/org/freedesktop/Tracker3/Endpoint");
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp5_;
	}
	_data_->_tmp7_ = _data_->path;
	_data_->_tmp8_ = _data_->dbus_conn;
	_data_->_state_ = 2;
	tracker_bus_connection_new (_data_->service, _data_->_tmp7_, _data_->_tmp8_, _data_->cancellable, tracker_sparql_connection_bus_new_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp9_ = tracker_bus_connection_new_finish (_data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp6_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->path);
		_g_object_unref0 (_data_->dbus_conn);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp6_;
	_data_->_tmp6_ = NULL;
	_data_->result = (TrackerSparqlConnection*) _data_->_tmp10_;
	_g_object_unref0 (_data_->_tmp6_);
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->dbus_conn);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

TrackerSparqlConnection*
tracker_sparql_connection_new (TrackerSparqlConnectionFlags flags,
                               GFile* store,
                               GFile* ontology,
                               GCancellable* cancellable,
                               GError** error)
{
	TrackerDirectConnection* conn = NULL;
	TrackerDirectConnection* _tmp0_;
	TrackerDirectConnection* _tmp1_;
	GError* _inner_error0_ = NULL;
	TrackerSparqlConnection* result;
	tracker_get_debug_flags ();
	_tmp0_ = tracker_direct_connection_new (flags, store, ontology, &_inner_error0_);
	conn = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = conn;
	g_initable_init ((GInitable*) _tmp1_, cancellable, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (conn);
		return NULL;
	}
	result = (TrackerSparqlConnection*) conn;
	return result;
}

static void
tracker_sparql_connection_new_async_data_free (gpointer _data)
{
	TrackerSparqlConnectionNewAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store);
	_g_object_unref0 (_data_->ontology);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	g_slice_free (TrackerSparqlConnectionNewAsyncData, _data_);
}

void
tracker_sparql_connection_new_async (TrackerSparqlConnectionFlags flags,
                                     GFile* store,
                                     GFile* ontology,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	TrackerSparqlConnectionNewAsyncData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (ontology != NULL);
	_data_ = g_slice_new0 (TrackerSparqlConnectionNewAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tracker_sparql_connection_new_async_data_free);
	_data_->flags = flags;
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp0_;
	_tmp1_ = _g_object_ref0 (ontology);
	_g_object_unref0 (_data_->ontology);
	_data_->ontology = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	tracker_sparql_connection_new_async_co (_data_);
}

TrackerSparqlConnection*
tracker_sparql_connection_new_finish (GAsyncResult* _res_,
                                      GError** error)
{
	TrackerSparqlConnection* result;
	TrackerSparqlConnectionNewAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
tracker_sparql_connection_new_async_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	TrackerSparqlConnectionNewAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tracker_sparql_connection_new_async_co (_data_);
}

static gboolean
tracker_sparql_connection_new_async_co (TrackerSparqlConnectionNewAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	tracker_get_debug_flags ();
	_data_->_tmp0_ = tracker_direct_connection_new (_data_->flags, _data_->store, _data_->ontology, &_data_->_inner_error0_);
	_data_->conn = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->conn;
	_data_->_state_ = 1;
	g_async_initable_init_async ((GAsyncInitable*) _data_->_tmp1_, G_PRIORITY_DEFAULT, _data_->cancellable, tracker_sparql_connection_new_async_ready, _data_);
	return FALSE;
	_state_1:
	g_async_initable_init_finish ((GAsyncInitable*) _data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->conn);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = (TrackerSparqlConnection*) _data_->conn;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

