/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.dnd;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.Constants;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.ModeComponent;
import org.openide.windows.TopComponent;

public final class TopComponentDraggable {
    private final TopComponent tc;
    private final ModeImpl mode;

    public TopComponentDraggable(TopComponent topComponent) {
        this(topComponent, (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent));
    }

    TopComponentDraggable(TopComponent topComponent, ModeImpl modeImpl) {
        assert (null != topComponent);
        assert (null != modeImpl);
        this.tc = topComponent;
        this.mode = modeImpl;
    }

    public TopComponentDraggable(ModeImpl modeImpl) {
        this.tc = null;
        assert (null != modeImpl);
        this.mode = modeImpl;
    }

    public int getKind() {
        return this.mode.getKind();
    }

    public ModeImpl getMode() {
        return this.mode;
    }

    public boolean isAllowedToMoveAnywhere() {
        boolean bl;
        boolean bl2 = bl = Constants.SWITCH_MODE_ADD_NO_RESTRICT || Switches.isMixingOfEditorsAndViewsEnabled();
        if (this.isTopComponentTransfer()) {
            bl |= WindowManagerImpl.getInstance().isTopComponentAllowedToMoveAnywhere(this.tc);
        }
        return bl;
    }

    boolean isUndockingEnabled() {
        if (this.isModeTransfer()) {
            if (this.getKind() == 1) {
                return Switches.isEditorModeUndockingEnabled();
            }
            return Switches.isViewModeUndockingEnabled();
        }
        return Switches.isTopComponentUndockingEnabled() && Switches.isUndockingEnabled(this.tc);
    }

    boolean isSlidingEnabled() {
        if (this.isModeTransfer()) {
            return Switches.isModeSlidingEnabled();
        }
        return Switches.isTopComponentSlidingEnabled() && Switches.isSlidingEnabled(this.tc);
    }

    public boolean isModeTransfer() {
        return null == this.tc;
    }

    public TopComponent getTopComponent() {
        return this.tc;
    }

    public boolean isTopComponentTransfer() {
        return null != this.tc;
    }

    Rectangle getBounds() {
        TopComponent[] topComponentArray;
        Rectangle rectangle = null;
        TopComponent topComponent = this.getTopComponent();
        if (null == topComponent && null == (topComponent = this.mode.getSelectedTopComponent()) && null != (topComponentArray = this.mode.getTopComponents()) && topComponentArray.length > 0) {
            topComponent = topComponentArray[0];
        }
        if ((topComponentArray = SwingUtilities.getAncestorOfClass(ModeComponent.class, (Component)topComponent)) != null) {
            rectangle = topComponentArray.getBounds();
        }
        return rectangle;
    }
}

