/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.openide.util.Mutex;
import org.openide.util.VectorIcon;

public class ToolbarWithOverflow
extends JToolBar {
    private JButton overflowButton;
    private JPopupMenu popup;
    private JToolBar overflowToolbar;
    private boolean displayOverflowOnHover = true;
    private final String PROP_PREF_ICON_SIZE = "PreferredIconSize";
    private final String PROP_DRAGGER = "_toolbar_dragger_";
    private final String PROP_JDEV_DISABLE_OVERFLOW = "nb.toolbar.overflow.disable";
    private AWTEventListener awtEventListener;
    private ComponentAdapter componentAdapter;
    private static JPopupMenu showingPopup = null;

    public ToolbarWithOverflow() {
        this(0);
    }

    public ToolbarWithOverflow(int n) {
        this(null, n);
    }

    public ToolbarWithOverflow(String string) {
        this(string, 0);
    }

    public ToolbarWithOverflow(String string, int n) {
        super(string, n);
        this.setupOverflowButton();
        this.popup = new SafePopupMenu();
        this.popup.setBorderPainted(false);
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.overflowToolbar = new SafeToolBar("overflowToolbar", n == 0 ? 1 : 0);
        this.overflowToolbar.setFloatable(false);
        this.overflowToolbar.setBorder(BorderFactory.createLineBorder(UIManager.getColor("controlShadow"), 1));
    }

    private ComponentListener getComponentListener() {
        if (this.componentAdapter == null) {
            this.componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    ToolbarWithOverflow.this.maybeAddOverflow();
                }
            };
        }
        return this.componentAdapter;
    }

    private AWTEventListener getAWTEventListener() {
        if (this.awtEventListener == null) {
            this.awtEventListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent aWTEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (ToolbarWithOverflow.this.isVisible() && !ToolbarWithOverflow.this.isShowing() && ToolbarWithOverflow.this.popup.isShowing()) {
                        showingPopup = null;
                        ToolbarWithOverflow.this.popup.setVisible(false);
                        return;
                    }
                    if (aWTEvent.getSource() == ToolbarWithOverflow.this.popup) {
                        if (ToolbarWithOverflow.this.popup.isShowing() && mouseEvent.getID() == 505) {
                            int n = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().x;
                            int n2 = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().x + ToolbarWithOverflow.this.popup.getWidth();
                            int n3 = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().y;
                            int n4 = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().y + ToolbarWithOverflow.this.popup.getHeight();
                            if (mouseEvent.getXOnScreen() < n || mouseEvent.getXOnScreen() >= n2 || mouseEvent.getYOnScreen() < n3 || mouseEvent.getYOnScreen() >= n4) {
                                showingPopup = null;
                                ToolbarWithOverflow.this.popup.setVisible(false);
                            }
                        }
                    } else if (ToolbarWithOverflow.this.popup.isShowing() && ToolbarWithOverflow.this.overflowButton.isShowing() && (mouseEvent.getID() == 503 || mouseEvent.getID() == 505)) {
                        int n;
                        int n5 = ((ToolbarWithOverflow)ToolbarWithOverflow.this).overflowButton.getLocationOnScreen().x;
                        int n6 = ToolbarWithOverflow.this.getOrientation() == 0 ? n5 + ToolbarWithOverflow.this.popup.getWidth() : n5 + ToolbarWithOverflow.this.overflowButton.getWidth() + ToolbarWithOverflow.this.popup.getWidth();
                        int n7 = ((ToolbarWithOverflow)ToolbarWithOverflow.this).overflowButton.getLocationOnScreen().y;
                        int n8 = n = ToolbarWithOverflow.this.getOrientation() == 0 ? n7 + ToolbarWithOverflow.this.overflowButton.getHeight() + ToolbarWithOverflow.this.popup.getHeight() : n7 + ToolbarWithOverflow.this.popup.getHeight();
                        if (mouseEvent.getXOnScreen() < n5 || mouseEvent.getYOnScreen() < n7 || mouseEvent.getXOnScreen() > n6 || mouseEvent.getYOnScreen() > n) {
                            showingPopup = null;
                            ToolbarWithOverflow.this.popup.setVisible(false);
                        }
                    }
                }
            };
        }
        return this.awtEventListener;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!Boolean.TRUE.equals(this.getClientProperty("nb.toolbar.overflow.disable"))) {
            this.addComponentListener(this.getComponentListener());
            Toolkit.getDefaultToolkit().addAWTEventListener(this.getAWTEventListener(), 48L);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.componentAdapter != null) {
            this.removeComponentListener(this.componentAdapter);
        }
        if (this.awtEventListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        }
    }

    @Override
    public void updateUI() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                ToolbarWithOverflow.this.superUpdateUI();
            }
        });
    }

    final void superUpdateUI() {
        super.updateUI();
    }

    public boolean isDisplayOverflowOnHover() {
        return this.displayOverflowOnHover;
    }

    public void setDisplayOverflowOnHover(boolean bl) {
        this.displayOverflowOnHover = bl;
        this.setupOverflowButton();
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] componentArray = this.getAllComponents();
        Insets insets = this.getInsets();
        int n = null == insets ? 0 : insets.left + insets.right;
        int n2 = null == insets ? 0 : insets.top + insets.bottom;
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            n += this.getOrientation() == 0 ? component.getPreferredSize().width : component.getPreferredSize().height;
            n2 = Math.max(n2, this.getOrientation() == 0 ? component.getPreferredSize().height + (insets == null ? 0 : insets.top + insets.bottom) : component.getPreferredSize().width + (insets == null ? 0 : insets.left + insets.right));
        }
        if (this.overflowToolbar.getComponentCount() > 0) {
            n += this.getOrientation() == 0 ? this.overflowButton.getPreferredSize().width : this.overflowButton.getPreferredSize().height;
        }
        Dimension dimension = this.getOrientation() == 0 ? new Dimension(n, n2) : new Dimension(n2, n);
        return dimension;
    }

    @Override
    public void setOrientation(int n) {
        super.setOrientation(n);
        this.setupOverflowButton();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.overflowToolbar.removeAll();
    }

    @Override
    public void validate() {
        if (!Boolean.TRUE.equals(this.getClientProperty("nb.toolbar.overflow.disable"))) {
            int n = this.computeVisibleButtons();
            if (n == -1) {
                this.handleOverflowRemoval();
            } else {
                this.handleOverflowAddittion(n);
            }
        }
        super.validate();
    }

    private void setupOverflowButton() {
        this.overflowButton = new JButton(this.getOrientation() == 0 ? ToolbarArrowIcon.INSTANCE_VERTICAL : ToolbarArrowIcon.INSTANCE_HORIZONTAL){

            @Override
            public void updateUI() {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        this.superUpdateUI();
                    }
                });
            }

            private void superUpdateUI() {
                super.updateUI();
            }
        };
        this.overflowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ToolbarWithOverflow.this.popup.isShowing()) {
                    showingPopup = null;
                    ToolbarWithOverflow.this.popup.setVisible(false);
                } else {
                    ToolbarWithOverflow.this.displayOverflow();
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (showingPopup != null && showingPopup != ToolbarWithOverflow.this.popup) {
                    showingPopup.setVisible(false);
                    showingPopup = null;
                }
                if (ToolbarWithOverflow.this.displayOverflowOnHover) {
                    ToolbarWithOverflow.this.displayOverflow();
                }
            }
        });
    }

    private void displayOverflow() {
        if (!this.overflowButton.isShowing()) {
            return;
        }
        int n = this.getOrientation() == 0 ? this.overflowButton.getLocationOnScreen().x : this.overflowButton.getLocationOnScreen().x + this.overflowButton.getWidth();
        int n2 = this.getOrientation() == 0 ? this.overflowButton.getLocationOnScreen().y + this.overflowButton.getHeight() : this.overflowButton.getLocationOnScreen().y;
        this.popup.setLocation(n, n2);
        showingPopup = this.popup;
        this.popup.setVisible(true);
    }

    private void maybeAddOverflow() {
        this.validate();
        this.repaint();
    }

    private int computeVisibleButtons() {
        int n;
        if (this.isShowing()) {
            int n2 = this.getOrientation() == 0 ? this.overflowButton.getIcon().getIconWidth() + 4 : this.getWidth() - this.getInsets().left - this.getInsets().right;
            n = this.getOrientation() == 0 ? this.getHeight() - this.getInsets().top - this.getInsets().bottom : this.overflowButton.getIcon().getIconHeight() + 4;
            this.overflowButton.setMaximumSize(new Dimension(n2, n));
            this.overflowButton.setMinimumSize(new Dimension(n2, n));
            this.overflowButton.setPreferredSize(new Dimension(n2, n));
        }
        this.handleIconResize();
        Component[] componentArray = this.getAllComponents();
        n = 0;
        int n3 = this.getOrientation() == 0 ? this.getWidth() : this.getHeight();
        int n4 = this.getOrientation() == 0 ? this.overflowButton.getPreferredSize().width : this.overflowButton.getPreferredSize().height;
        int n5 = 0;
        int n6 = 0;
        Insets insets = this.getInsets();
        if (null != insets) {
            n = this.getOrientation() == 0 ? insets.left + insets.right : insets.top + insets.bottom;
        }
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (!component.isVisible()) continue;
            if (n5 == n6) {
                int n7;
                int n8 = n7 = this.getOrientation() == 0 ? component.getPreferredSize().width : component.getPreferredSize().height;
                if (n + n7 <= n3) {
                    n += n7;
                    ++n6;
                }
            }
            ++n5;
        }
        if (n6 < n5 && n6 > 0 && n + n4 > n3) {
            --n6;
        }
        if (n6 == 0 && componentArray.length > 0 && componentArray[0] instanceof JComponent && Boolean.TRUE.equals(((JComponent)componentArray[0]).getClientProperty("_toolbar_dragger_"))) {
            n6 = 1;
        }
        if (n6 == n5) {
            n6 = -1;
        }
        return n6;
    }

    private void handleOverflowAddittion(int n) {
        Component[] componentArray = this.getAllComponents();
        this.removeAll();
        this.overflowToolbar.setOrientation(this.getOrientation() == 0 ? 1 : 0);
        this.popup.removeAll();
        for (Component component : componentArray) {
            if (n > 0) {
                this.add(component);
                if (!component.isVisible()) continue;
                --n;
                continue;
            }
            this.overflowToolbar.add(component);
        }
        this.popup.add(this.overflowToolbar);
        this.add(this.overflowButton);
    }

    private void handleOverflowRemoval() {
        if (this.overflowToolbar.getComponents().length > 0) {
            this.remove(this.overflowButton);
            this.handleIconResize();
            for (Component component : this.overflowToolbar.getComponents()) {
                this.add(component);
            }
            this.overflowToolbar.removeAll();
            this.popup.removeAll();
        }
    }

    private void handleIconResize() {
        for (Component component : this.overflowToolbar.getComponents()) {
            boolean bl;
            boolean bl2 = bl = this.getClientProperty("PreferredIconSize") == null;
            if (bl) {
                ((JComponent)component).putClientProperty("PreferredIconSize", null);
                continue;
            }
            ((JComponent)component).putClientProperty("PreferredIconSize", 24);
        }
    }

    private Component[] getAllComponents() {
        Component[] componentArray;
        Component[] componentArray2 = this.overflowToolbar.getComponents();
        if (componentArray2.length == 0) {
            componentArray = this.getComponents();
        } else if (this.getComponentCount() > 0) {
            componentArray = new Component[this.getComponents().length - 1];
            System.arraycopy(this.getComponents(), 0, componentArray, 0, componentArray.length);
        } else {
            componentArray = new Component[]{};
        }
        Component[] componentArray3 = new Component[componentArray.length + componentArray2.length];
        System.arraycopy(componentArray, 0, componentArray3, 0, componentArray.length);
        System.arraycopy(componentArray2, 0, componentArray3, componentArray.length, componentArray2.length);
        return componentArray3;
    }

    private static final class ToolbarArrowIcon
    extends VectorIcon {
        public static final Icon INSTANCE_HORIZONTAL = new ToolbarArrowIcon(true);
        public static final Icon INSTANCE_VERTICAL = new ToolbarArrowIcon(false);
        private final boolean horizontal;

        private ToolbarArrowIcon(boolean bl) {
            super(11, 11);
            this.horizontal = bl;
        }

        protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
            if (this.horizontal) {
                graphics2D.rotate(-1.5707963267948966, (double)n / 2.0, (double)n2 / 2.0);
            }
            double d2 = 0.8 * d + 0.3;
            graphics2D.setStroke(new BasicStroke((float)d2));
            Color color = UIManager.getBoolean("nb.dark.theme") ? new Color(187, 187, 187, 255) : new Color(50, 50, 50, 255);
            graphics2D.setColor(color);
            for (int i = 0; i < 2; ++i) {
                int n3 = ToolbarArrowIcon.round((double)((1.4 + 4.1 * (double)i) * d));
                double d3 = ToolbarArrowIcon.round((double)(5.0 * d));
                double d4 = ToolbarArrowIcon.round((double)(3.0 * d));
                double d5 = ((double)n - d3) / 2.0;
                double d6 = d5 + d3 / 2.0;
                graphics2D.clipRect(0, n3, n, n2);
                Path2D.Double double_ = new Path2D.Double();
                double_.moveTo(d6 - d3 / 2.0, n3);
                double_.lineTo(d6, (double)n3 + d4);
                double_.lineTo(d6 + d3 / 2.0, n3);
                graphics2D.draw(double_);
            }
        }
    }

    private static class SafePopupMenu
    extends JPopupMenu {
        private SafePopupMenu() {
        }

        @Override
        public void updateUI() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    this.superUpdateUI();
                }
            });
        }

        final void superUpdateUI() {
            super.updateUI();
        }
    }

    private static class SafeToolBar
    extends JToolBar {
        public SafeToolBar(String string, int n) {
            super(string, n);
        }

        @Override
        public void updateUI() {
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    this.superUpdateUI();
                }
            });
        }

        final void superUpdateUI() {
            super.updateUI();
        }
    }
}

