/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.results.cpu;

import java.util.HashSet;
import java.util.ResourceBundle;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUCCTContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.CPUResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeBacked;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNodeFree;

public class AllThreadsMergedCPUCCTContainer
extends CPUCCTContainer {
    private static final String ALL_THREADS_STRING = ResourceBundle.getBundle("org.graalvm.visualvm.lib.jfluid.results.cpu.Bundle").getString("AllThreadsMergedCPUCCTContainer_AllThreadsString");
    protected int view;

    public AllThreadsMergedCPUCCTContainer(CPUResultsSnapshot cpuResSnapshot, PrestimeCPUCCTNode[] rootNodeSubNodes, int view) {
        super(cpuResSnapshot);
        int i;
        this.threadId = -1;
        this.threadName = ALL_THREADS_STRING;
        this.view = view;
        this.collectingTwoTimeStamps = cpuResSnapshot.isCollectingTwoTimeStamps();
        this.compactData = new byte[28];
        this.setNCallsForNodeOfs(0, 1);
        this.rootNode = new PrestimeCPUCCTNodeBacked(this, rootNodeSubNodes);
        long time = 0L;
        for (i = 0; i < rootNodeSubNodes.length; ++i) {
            time += rootNodeSubNodes[i].getTotalTime0();
        }
        this.wholeGraphNetTime0 = time;
        this.setTotalTime0ForNodeOfs(0, time);
        if (this.collectingTwoTimeStamps) {
            time = 0L;
            for (i = 0; i < rootNodeSubNodes.length; ++i) {
                time += rootNodeSubNodes[i].getTotalTime1();
            }
            this.wholeGraphNetTime1 = time;
            this.setTotalTime1ForNodeOfs(0, time);
        }
    }

    @Override
    public String[] getMethodClassNameAndSig(int methodId) {
        return this.cpuResSnapshot.getMethodClassNameAndSig(methodId, this.view);
    }

    @Override
    protected FlatProfileContainer generateFlatProfile() {
        this.preGenerateFlatProfile();
        PrestimeCPUCCTNode[] children = (PrestimeCPUCCTNode[])this.rootNode.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                CPUCCTContainer childContainer = children[i].getContainer();
                childContainer.timePerMethodId0 = this.timePerMethodId0;
                childContainer.timePerMethodId1 = this.timePerMethodId1;
                childContainer.totalTimePerMethodId0 = this.totalTimePerMethodId0;
                childContainer.totalTimePerMethodId1 = this.totalTimePerMethodId1;
                childContainer.invPerMethodId = this.invPerMethodId;
                childContainer.methodsOnStack = new HashSet();
                childContainer.addFlatProfTimeForNode(0);
                childContainer.timePerMethodId1 = null;
                childContainer.timePerMethodId0 = null;
                childContainer.totalTimePerMethodId1 = null;
                childContainer.totalTimePerMethodId0 = null;
                childContainer.invPerMethodId = null;
                childContainer.methodsOnStack = null;
            }
        }
        return this.postGenerateFlatProfile();
    }

    @Override
    protected PrestimeCPUCCTNodeFree generateReverseCCT(int methodId) {
        PrestimeCPUCCTNode[] children = (PrestimeCPUCCTNode[])this.rootNode.getChildren();
        PrestimeCPUCCTNodeFree rev = null;
        for (int i = 0; i < children.length; ++i) {
            CPUCCTContainer childContainer = children[i].getContainer();
            if (rev == null) {
                rev = childContainer.generateReverseCCT(methodId);
                continue;
            }
            childContainer.addToReverseCCT(rev, methodId);
        }
        return rev;
    }
}

