/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.javascript;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObjectLanguageHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.javascript.JavaScriptType;
import org.graalvm.visualvm.heapviewer.utils.ExcludingIterator;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;

class JavaScriptHeapFragment
extends DynamicObjectLanguageHeapFragment<JavaScriptObject, JavaScriptType> {
    static final String JS_LANG_ID = "com.oracle.truffle.js.runtime.builtins.JSClass";
    private static final String JS_HEAP_ID = "javascript_heap";
    private static final String JS_NULL_CLASS_FQN = "com.oracle.truffle.js.runtime.objects.Null";
    private static final String JS_UNDEFIED_CLASS_FQN = "com.oracle.truffle.js.runtime.objects.Undefined";
    final Instance nullInstance;
    final Instance undefinedInstance;
    private final Map<Instance, String> typesCache;

    JavaScriptHeapFragment(JavaScriptLanguage language, Instance langID, Heap heap) {
        super(JS_HEAP_ID, Bundle.JavaScriptHeapFragment_Name(), JavaScriptHeapFragment.fragmentDescription(langID, heap), language, heap);
        JavaClass nullClass = heap.getJavaClassByName(JS_NULL_CLASS_FQN);
        this.nullInstance = (Instance)nullClass.getValueOfStaticField("instance");
        JavaClass undefinedClass = heap.getJavaClassByName(JS_UNDEFIED_CLASS_FQN);
        this.undefinedInstance = (Instance)undefinedClass.getValueOfStaticField("instance");
        this.typesCache = new HashMap<Instance, String>();
    }

    static JavaScriptHeapFragment fromContext(HeapContext context) {
        return (JavaScriptHeapFragment)context.getFragment();
    }

    static boolean isJavaScriptHeap(HeapContext context) {
        return JS_HEAP_ID.equals(context.getFragment().getID());
    }

    @Override
    public Iterator<Instance> getInstancesIterator() {
        return new ExcludingIterator<Instance>(this.languageInstancesIterator(JS_LANG_ID)){

            protected boolean exclude(Instance instance) {
                return Objects.equals(JavaScriptHeapFragment.this.nullInstance, instance) || Objects.equals(JavaScriptHeapFragment.this.undefinedInstance, instance);
            }
        };
    }

    @Override
    public Iterator<JavaScriptObject> getObjectsIterator() {
        return new ExcludingIterator<JavaScriptObject>(this.languageObjectsIterator(JS_LANG_ID)){

            protected boolean exclude(JavaScriptObject object) {
                Instance instance = object.getInstance();
                return Objects.equals(JavaScriptHeapFragment.this.nullInstance, instance) || Objects.equals(JavaScriptHeapFragment.this.undefinedInstance, instance);
            }
        };
    }

    String getObjectType(Instance instance) {
        return this.getObjectType(instance, null);
    }

    String getObjectType(Instance instance, Instance shape) {
        String type;
        if (shape == null) {
            shape = JavaScriptObject.getShape(instance);
        }
        if ((type = this.typesCache.get(shape)) == null) {
            Instance prototype = JavaScriptHeapFragment.getPrototype(instance);
            type = this.typesCache.get(prototype);
            if (type == null) {
                type = JavaScriptHeapFragment.getJSType(prototype, this);
                this.typesCache.put(prototype, type);
            }
            this.typesCache.put(shape, type);
        }
        return type;
    }

    private static Instance getPrototype(Instance instance) {
        JavaScriptObject jsobj = new JavaScriptObject(instance);
        Instance prototype = JavaScriptHeapFragment.getPrototype(jsobj.getStaticFieldValues());
        if (prototype != null) {
            return prototype;
        }
        return JavaScriptHeapFragment.getPrototype(jsobj.getFieldValues());
    }

    private static Instance getPrototype(List<FieldValue> fields) {
        for (FieldValue field : fields) {
            String fieldName = field.getField().getName();
            if (!"__proto__ (hidden)".equals(fieldName) && !"[[Prototype]] (hidden)".equals(fieldName)) continue;
            return ((ObjectFieldValue)field).getInstance();
        }
        return null;
    }

    private static String getJSType(Instance prototype, JavaScriptHeapFragment fragment) {
        if (prototype == null) {
            return Bundle.JavaScriptHeapFragment_UnknownType();
        }
        if (Objects.equals(fragment.nullInstance, prototype)) {
            return Bundle.JavaScriptHeapFragment_NoPrototype();
        }
        Heap heap = fragment.getHeap();
        JavaScriptObject dprototype = new JavaScriptObject(prototype);
        ObjectFieldValue constructorValue = (ObjectFieldValue)dprototype.getFieldValue("constructor");
        if (constructorValue != null) {
            String dconstructorT;
            Instance constructor = constructorValue.getInstance();
            JavaScriptObject dconstructor = new JavaScriptObject(constructor);
            String type = JavaScriptNodes.getLogicalValue(dconstructor, dconstructorT = DynamicObject.getType(constructor));
            if (type == null) {
                return Bundle.JavaScriptHeapFragment_AnonymousPrototype();
            }
            return type.endsWith("()") ? type.substring(0, type.length() - 2) : type;
        }
        return Bundle.JavaScriptHeapFragment_UnknownPrototype();
    }
}

