/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import org.graalvm.visualvm.heapviewer.truffle.dynamicobject.DynamicObject;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

class RubyObject
extends DynamicObject {
    RubyObject(Instance instance) {
        super(instance);
    }

    RubyObject(String type, Instance instance) {
        super(type, instance);
    }

    boolean isRubyObject() {
        return RubyObject.isRubyLangId(this.getLanguageId());
    }

    @Override
    protected String computeType() {
        Instance metaClass = (Instance)this.getInstance().getValueOfField("metaClass");
        if (metaClass == null) {
            return super.computeType();
        }
        return DetailsUtils.getInstanceFieldString((Instance)metaClass, (String)"nonSingletonClass");
    }

    static boolean isRubyObject(Instance instance) {
        return DynamicObject.isDynamicObject(instance) && RubyObject.isRubyLangId(DynamicObject.getLanguageId(instance));
    }

    private static boolean isRubyLangId(JavaClass langIdClass) {
        String className = langIdClass.getName();
        return "org.truffleruby.language.RubyObjectType".equals(className) || "org.truffleruby.interop.RubyObjectType".equals(className);
    }
}

