/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.heapwalk.details.netbeans;

import java.io.UnsupportedEncodingException;
import java.util.List;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.PrimitiveArrayInstance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;
import org.openide.util.Exceptions;

public class JavacDetailsProvider
extends DetailsProvider.Basic {
    private static final String SHAREDNAMETABLE_NAMEIMPL_MASK = "com.sun.tools.javac.util.SharedNameTable$NameImpl";
    private static final String NAME_MASK = "com.sun.tools.javac.util.Name";
    private static final String SYMBOL_MASK = "com.sun.tools.javac.code.Symbol+";
    private static final String CLASS_SYM_MASK = "com.sun.tools.javac.code.Symbol$ClassSymbol";
    private static final String PACKAGE_SYM_MASK = "com.sun.tools.javac.code.Symbol$PackageSymbol";

    public JavacDetailsProvider() {
        super(SHAREDNAMETABLE_NAMEIMPL_MASK, NAME_MASK, SYMBOL_MASK, CLASS_SYM_MASK, PACKAGE_SYM_MASK);
    }

    @Override
    public String getDetailsString(String className, Instance instance) {
        if (SHAREDNAMETABLE_NAMEIMPL_MASK.equals(className)) {
            return this.getName(instance, "length", "index", "table", "bytes");
        }
        if (NAME_MASK.equals(className)) {
            return this.getName(instance, "len", "index", "table", "names");
        }
        if (SYMBOL_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "name");
        }
        if (CLASS_SYM_MASK.equals(className)) {
            String name = DetailsUtils.getInstanceFieldString(instance, "name");
            if (name == null || name.isEmpty()) {
                return DetailsUtils.getInstanceFieldString(instance, "flatname");
            }
            return DetailsUtils.getInstanceFieldString(instance, "fullname");
        }
        if (PACKAGE_SYM_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString(instance, "fullname");
        }
        return null;
    }

    private String getName(Instance instance, String lenField, String indexField, String tableField, String bytesField) {
        Integer length = (Integer)instance.getValueOfField(lenField);
        Integer index = (Integer)instance.getValueOfField(indexField);
        Instance table = (Instance)instance.getValueOfField(tableField);
        if (length != null && index != null && table != null) {
            PrimitiveArrayInstance bytes = (PrimitiveArrayInstance)table.getValueOfField(bytesField);
            List elements = bytes.getValues();
            byte[] data = new byte[length.intValue()];
            for (int i = 0; i < length; ++i) {
                String el = (String)elements.get(index + i);
                data[i] = Byte.parseByte(el);
            }
            try {
                return new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

