/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.sampler.cpu;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNodeProcessor;
import org.graalvm.visualvm.lib.jfluid.results.cpu.FlatProfileContainer;
import org.graalvm.visualvm.lib.jfluid.results.cpu.MethodInfoMapper;
import org.graalvm.visualvm.lib.jfluid.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.graalvm.visualvm.sampler.cpu.FlatProfilerContainer;

final class CCTFlattener
extends RuntimeCCTNodeProcessor.PluginAdapter {
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private Stack<TotalTime> parentStack = new Stack();
    private Set methodsOnStack = new HashSet();
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private long[] totalTimePM0;
    private long[] totalTimePM1;
    private int nMethods;
    private InstrumentationFilter instrFilter;
    private boolean twoTimestamps;
    private MethodInfoMapper methodInfoMapper;

    CCTFlattener(boolean twoStamps, MethodInfoMapper mapper, InstrumentationFilter f) {
        this.nMethods = mapper.getMaxMethodId();
        this.methodInfoMapper = mapper;
        this.twoTimestamps = twoStamps;
        this.instrFilter = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() {
        long wholeGraphTime0 = 0L;
        long wholeGraphTime1 = 0L;
        long totalNInv = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double time = (double)this.timePM0[i] / 1000.0;
            if (time < 0.0) {
                time = 0.0;
            }
            this.timePM0[i] = (long)time;
            if (i > 0) {
                wholeGraphTime0 = (long)((double)wholeGraphTime0 + time);
            }
            if (this.twoTimestamps) {
                time = (double)this.timePM1[i] / 1000.0;
                this.timePM1[i] = (long)time;
                if (i > 0) {
                    wholeGraphTime1 = (long)((double)wholeGraphTime1 + time);
                }
            }
            totalNInv += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = new FlatProfilerContainer(this.methodInfoMapper, this.twoTimestamps, this.timePM0, this.timePM1, this.totalTimePM0, this.totalTimePM1, this.invPM, new char[0], wholeGraphTime0, wholeGraphTime1, this.invPM.length);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
        this.methodsOnStack.clear();
        this.instrFilter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[this.twoTimestamps ? this.nMethods : 0];
        this.totalTimePM0 = new long[this.nMethods];
        this.totalTimePM1 = new long[this.twoTimestamps ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        this.methodsOnStack.clear();
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    public void onNode(MethodCPUCCTNode node) {
        int parentMethodId;
        boolean filteredOut;
        int nodeMethodId = node.getMethodId();
        int nodeFilerStatus = node.getFilteredStatus();
        MethodCPUCCTNode currentParent = this.parentStack.isEmpty() ? null : this.parentStack.peek().parent;
        boolean bl = filteredOut = nodeFilerStatus == 2;
        if (!filteredOut) {
            String jvmClassName = this.methodInfoMapper.getInstrMethodClass(nodeMethodId).replace('.', '/');
            filteredOut = !this.instrFilter.passes(jvmClassName);
        }
        int n = parentMethodId = currentParent != null ? currentParent.getMethodId() : -1;
        if (filteredOut) {
            if (currentParent != null && !currentParent.isRoot()) {
                int n2 = parentMethodId;
                this.invDiff[n2] = this.invDiff[n2] + node.getNCalls();
                int n3 = parentMethodId;
                this.timePM0[n3] = this.timePM0[n3] + node.getNetTime0();
                if (this.twoTimestamps) {
                    int n4 = parentMethodId;
                    this.timePM1[n4] = this.timePM1[n4] + node.getNetTime1();
                }
            }
        } else {
            int n5 = nodeMethodId;
            this.timePM0[n5] = this.timePM0[n5] + node.getNetTime0();
            if (this.twoTimestamps) {
                int n6 = nodeMethodId;
                this.timePM1[n6] = this.timePM1[n6] + node.getNetTime1();
            }
            int n7 = nodeMethodId;
            this.invPM[n7] = this.invPM[n7] + node.getNCalls();
            if (currentParent != null && !currentParent.isRoot()) {
                int n8 = parentMethodId;
                this.nCalleeInvocations[n8] = this.nCalleeInvocations[n8] + node.getNCalls();
            }
        }
        MethodCPUCCTNode nextParent = filteredOut ? currentParent : node;
        TotalTime timeNode = new TotalTime(nextParent, this.methodsOnStack.contains(nodeMethodId));
        timeNode.totalTimePM0 = timeNode.totalTimePM0 + node.getNetTime0();
        if (this.twoTimestamps) {
            timeNode.totalTimePM1 = timeNode.totalTimePM1 + node.getNetTime1();
        }
        if (!timeNode.recursive) {
            this.methodsOnStack.add(nodeMethodId);
        }
        this.parentStack.push(timeNode);
    }

    public void onBackout(MethodCPUCCTNode node) {
        TotalTime current = this.parentStack.pop();
        if (!current.recursive) {
            int nodeMethodId = node.getMethodId();
            this.methodsOnStack.remove(nodeMethodId);
            double time = (double)current.totalTimePM0 / 1000.0;
            if (time > 0.0) {
                int n = nodeMethodId;
                this.totalTimePM0[n] = (long)((double)this.totalTimePM0[n] + time);
            }
            if (this.twoTimestamps && (time = (double)current.totalTimePM1 / 1000.0) > 0.0) {
                int n = nodeMethodId;
                this.totalTimePM1[n] = (long)((double)this.totalTimePM1[n] + time);
            }
        }
        if (!this.parentStack.isEmpty()) {
            TotalTime parent = this.parentStack.peek();
            parent.add(current);
            TotalTime totalTime = parent;
            totalTime.outCalls = totalTime.outCalls + node.getNCalls();
        }
    }

    private static class TotalTime {
        private final MethodCPUCCTNode parent;
        private final boolean recursive;
        private int outCalls;
        private long totalTimePM0;
        private long totalTimePM1;

        TotalTime(MethodCPUCCTNode n, boolean r) {
            this.parent = n;
            this.recursive = r;
        }

        private void add(TotalTime current) {
            this.outCalls += current.outCalls;
            this.totalTimePM0 += current.totalTimePM0;
            this.totalTimePM1 += current.totalTimePM1;
        }
    }
}

