/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;

public abstract class VectorIcon
implements Icon,
Serializable {
    private final int width;
    private final int height;

    protected VectorIcon(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.width = n;
        this.height = n2;
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    private static Graphics2D createGraphicsWithRenderingHintsConfigured(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        LinkedHashMap<RenderingHints.Key, Object> linkedHashMap = new LinkedHashMap<RenderingHints.Key, Object>();
        if (object != null && object instanceof Map) {
            linkedHashMap.putAll((Map)object);
        }
        linkedHashMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        linkedHashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        linkedHashMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.addRenderingHints(linkedHashMap);
        return graphics2D;
    }

    protected static final void setAntiAliasing(Graphics2D graphics2D, boolean bl) {
        LinkedHashMap<RenderingHints.Key, Object> linkedHashMap = new LinkedHashMap<RenderingHints.Key, Object>();
        linkedHashMap.put(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.addRenderingHints(linkedHashMap);
    }

    protected static final int round(double d) {
        int n = (int)Math.round(d);
        return d > 0.0 && n == 0 ? 1 : n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = VectorIcon.createGraphicsWithRenderingHintsConfigured(graphics);
        try {
            graphics2D.clipRect(n, n2, this.getIconWidth(), this.getIconHeight());
            graphics2D.translate(n, n2);
            AffineTransform affineTransform = graphics2D.getTransform();
            int n3 = affineTransform.getType();
            if (n3 != 2 && n3 != 3) {
                this.paintIcon(component, graphics2D, this.getIconWidth(), this.getIconHeight(), 1.0);
                return;
            }
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getTranslateX();
            double d3 = affineTransform.getTranslateY();
            double d4 = Math.ceil(d2);
            double d5 = Math.ceil(d3);
            graphics2D.setTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, d4, d5));
            double d6 = d4 - d2;
            double d7 = d5 - d3;
            int n4 = (int)Math.floor((double)this.getIconWidth() * d - d6);
            int n5 = (int)Math.floor((double)this.getIconHeight() * d - d7);
            this.paintIcon(component, graphics2D, n4, n5, d);
        }
        finally {
            graphics2D.dispose();
        }
    }

    protected abstract void paintIcon(Component var1, Graphics2D var2, int var3, int var4, double var5);
}

