/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.views.sampler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.core.ui.components.DataViewComponent;
import org.graalvm.visualvm.jfr.model.JFREvent;
import org.graalvm.visualvm.jfr.model.JFREventVisitor;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRPropertyNotAvailableException;
import org.graalvm.visualvm.jfr.model.JFRThread;
import org.graalvm.visualvm.jfr.views.components.MessageComponent;
import org.graalvm.visualvm.jfr.views.sampler.CPUSamplerViewSupport;
import org.graalvm.visualvm.jfr.views.sampler.JFRSnapshotSamplerViewProvider;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.GoToSource;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.swing.FilterUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.openide.util.NbBundle;

final class MemorySamplerViewSupport {
    MemorySamplerViewSupport() {
    }

    static final class ThreadsMemoryViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final boolean hasData;
        private Map<String, Long> eventData;
        private String[] names;
        private long[] values;
        private TreadsAllocTableModel tableModel;
        private ProfilerTable table;
        private HideableBarRenderer[] renderers;

        ThreadsMemoryViewSupport(JFRModel model) {
            this.hasData = model.containsEvent(JFRSnapshotSamplerViewProvider.ThreadAllocationsChecker.class);
            this.initComponents();
        }

        @Override
        public void init() {
            if (this.hasData) {
                this.eventData = new HashMap<String, Long>();
            }
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if (!this.hasData) {
                return true;
            }
            if ("jdk.ThreadAllocationStatistics".equals(typeName)) {
                try {
                    JFRThread thread = event.getThread("thread");
                    if (thread != null) {
                        String threadName = thread.getName();
                        long allocated = event.getLong("allocated");
                        Long _allocated = this.eventData.get(threadName);
                        if (_allocated == null || _allocated < allocated) {
                            this.eventData.put(threadName, allocated);
                        }
                    }
                }
                catch (JFRPropertyNotAvailableException jFRPropertyNotAvailableException) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public void done() {
            if (this.hasData) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long total = 0L;
                        long max = 0L;
                        ThreadsMemoryViewSupport.access$1402(this, new String[eventData.size()]);
                        ThreadsMemoryViewSupport.access$1602(this, new long[eventData.size()]);
                        int i = 0;
                        for (Map.Entry entry : eventData.entrySet()) {
                            ((ThreadsMemoryViewSupport)this).names[i] = (String)entry.getKey();
                            ((ThreadsMemoryViewSupport)this).values[i] = (Long)entry.getValue();
                            max = values[i] > max ? values[i] : max;
                            total += values[i++];
                        }
                        renderers[0].setMaxValue(max);
                        table.setDefaultColumnWidth(1, renderers[0].getOptimalWidth());
                        renderers[0].setMaxValue(total);
                        tableModel.fireTableDataChanged();
                        eventData.clear();
                        eventData = null;
                    }
                });
            }
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerViewSupport.class, (String)"LBL_ThreadAlloc_M"), null, 20, (JComponent)this, null);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (!this.hasData) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("Per thread allocations", JFRSnapshotSamplerViewProvider.ThreadAllocationsChecker.checkedTypes()), "Center");
            } else {
                this.tableModel = new TreadsAllocTableModel();
                this.table = new ProfilerTable((TableModel)this.tableModel, true, true, null);
                this.table.setMainColumn(0);
                this.table.setFitWidthColumn(0);
                this.table.setSortColumn(1);
                this.table.setDefaultSortOrder(SortOrder.DESCENDING);
                this.table.setDefaultSortOrder(0, SortOrder.ASCENDING);
                this.renderers = new HideableBarRenderer[1];
                this.renderers[0] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer(Formatters.bytesFormat()));
                LabelRenderer threadRenderer = new LabelRenderer();
                threadRenderer.setIcon(Icons.getIcon((String)"ProfilerIcons.Thread"));
                threadRenderer.setFont(threadRenderer.getFont().deriveFont(1));
                this.table.setColumnRenderer(0, (ProfilerRenderer)threadRenderer);
                this.table.setColumnRenderer(1, (ProfilerRenderer)this.renderers[0]);
                this.add((Component)new ProfilerTableContainer(this.table, false, null), "Center");
            }
        }

        static /* synthetic */ String[] access$1402(ThreadsMemoryViewSupport x0, String[] x1) {
            x0.names = x1;
            return x1;
        }

        static /* synthetic */ long[] access$1602(ThreadsMemoryViewSupport x0, long[] x1) {
            x0.values = x1;
            return x1;
        }

        private class TreadsAllocTableModel
        extends AbstractTableModel {
            private TreadsAllocTableModel() {
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Thread";
                }
                if (columnIndex == 1) {
                    return "Allocated";
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return Long.class;
            }

            @Override
            public int getRowCount() {
                return ThreadsMemoryViewSupport.this.names == null ? 0 : ThreadsMemoryViewSupport.this.names.length;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return ThreadsMemoryViewSupport.this.names[rowIndex];
                }
                if (columnIndex == 1) {
                    return ThreadsMemoryViewSupport.this.values[rowIndex];
                }
                return null;
            }
        }
    }

    static final class HeapViewSupport
    extends JPanel
    implements JFREventVisitor {
        private final boolean hasData;
        private Map<String, Long[]> eventData;
        private String[] names;
        private long[] sizes;
        private long[] counts;
        private HeapTableModel tableModel;
        private ProfilerTable table;
        private HideableBarRenderer[] renderers;
        private JComponent bottomPanel;
        private JComponent filterPanel;
        private JComponent searchPanel;

        HeapViewSupport(JFRModel model) {
            this.hasData = model.containsEvent(JFRSnapshotSamplerViewProvider.ObjectCountChecker.class);
            this.initComponents();
        }

        @Override
        public void init() {
            if (this.hasData) {
                this.eventData = new HashMap<String, Long[]>();
            }
        }

        @Override
        public boolean visit(String typeName, JFREvent event) {
            if (!this.hasData) {
                return true;
            }
            if ("jdk.ObjectCount".equals(typeName)) {
                try {
                    this.eventData.put(event.getClass("objectClass").getName(), new Long[]{event.getLong("totalSize"), event.getLong("count")});
                }
                catch (JFRPropertyNotAvailableException e) {
                    System.err.println(">>> " + e);
                }
            }
            return false;
        }

        @Override
        public void done() {
            if (this.hasData) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        long total1 = 0L;
                        long total2 = 0L;
                        long max1 = 0L;
                        long max2 = 0L;
                        HeapViewSupport.access$002(this, new String[eventData.size()]);
                        HeapViewSupport.access$202(this, new long[eventData.size()]);
                        HeapViewSupport.access$302(this, new long[eventData.size()]);
                        int i = 0;
                        for (Map.Entry entry : eventData.entrySet()) {
                            ((HeapViewSupport)this).names[i] = HeapViewSupport.decodeClassName((String)entry.getKey());
                            ((HeapViewSupport)this).sizes[i] = ((Long[])entry.getValue())[0];
                            ((HeapViewSupport)this).counts[i] = ((Long[])entry.getValue())[1];
                            max1 = sizes[i] > max1 ? sizes[i] : max1;
                            total1 += sizes[i];
                            max2 = counts[i] > max2 ? counts[i] : max2;
                            total2 += counts[i];
                            ++i;
                        }
                        renderers[0].setMaxValue(max1);
                        table.setDefaultColumnWidth(1, renderers[0].getOptimalWidth());
                        renderers[0].setMaxValue(total1);
                        renderers[1].setMaxValue(max2);
                        table.setDefaultColumnWidth(2, renderers[1].getOptimalWidth());
                        renderers[1].setMaxValue(total2);
                        tableModel.fireTableDataChanged();
                        eventData.clear();
                        eventData = null;
                    }
                });
            }
        }

        private static String decodeClassName(String className) {
            if ((className = StringUtils.userFormClassName((String)className)).startsWith("L") && className.contains(";")) {
                className = className.substring(1, className.length()).replace(";", "");
            }
            return className;
        }

        DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(CPUSamplerViewSupport.class, (String)"LBL_Heap_histogram"), null, 10, (JComponent)this, null);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (!this.hasData) {
                this.setLayout(new BorderLayout());
                this.add((Component)MessageComponent.noData("Heap histogram", JFRSnapshotSamplerViewProvider.ObjectCountChecker.checkedTypes()), "Center");
            } else {
                this.tableModel = new HeapTableModel();
                this.table = new ProfilerTable(this.tableModel, true, true, null){

                    protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                        String selectedClass;
                        String string = selectedClass = value == null ? null : value.toString();
                        if (GoToSource.isAvailable()) {
                            popup.add(new JMenuItem(NbBundle.getMessage(MemorySamplerViewSupport.class, (String)"MemoryView_Context_GoToSource")){
                                {
                                    super(x0);
                                    this.setEnabled(selectedClass != null);
                                    this.setFont(this.getFont().deriveFont(1));
                                }

                                @Override
                                protected void fireActionPerformed(ActionEvent e) {
                                    GoToSource.openSource(null, (String)selectedClass, null, null);
                                }
                            });
                            popup.addSeparator();
                        }
                        popup.add(this.createCopyMenuItem());
                        popup.addSeparator();
                        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                this.activateFilter();
                            }
                        });
                        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

                            @Override
                            protected void fireActionPerformed(ActionEvent e) {
                                this.activateSearch();
                            }
                        });
                    }
                };
                this.table.providePopupMenu(true);
                this.table.setMainColumn(0);
                this.table.setFitWidthColumn(0);
                this.table.setSortColumn(1);
                this.table.setDefaultSortOrder(SortOrder.DESCENDING);
                this.table.setDefaultSortOrder(0, SortOrder.ASCENDING);
                this.renderers = new HideableBarRenderer[2];
                this.renderers[0] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer(Formatters.bytesFormat()));
                this.renderers[1] = new HideableBarRenderer((ProfilerRenderer)new NumberPercentRenderer());
                JavaNameRenderer classRenderer = new JavaNameRenderer(Icons.getIcon((String)"LanguageIcons.Class"));
                this.table.setColumnRenderer(0, (ProfilerRenderer)classRenderer);
                this.table.setColumnRenderer(1, (ProfilerRenderer)this.renderers[0]);
                this.table.setColumnRenderer(2, (ProfilerRenderer)this.renderers[1]);
                this.add((Component)new ProfilerTableContainer(this.table, false, null), "Center");
                InputMap inputMap = this.getInputMap(1);
                ActionMap actionMap = this.getActionMap();
                String filterKey = "filter-action-key";
                AbstractAction filterAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.activateFilter();
                    }
                };
                ActionsSupport.registerAction((String)"filter-action-key", (Action)filterAction, (ActionMap)actionMap, (InputMap)inputMap);
                String findKey = "find-action-key";
                AbstractAction findAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.activateSearch();
                    }
                };
                ActionsSupport.registerAction((String)"find-action-key", (Action)findAction, (ActionMap)actionMap, (InputMap)inputMap);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchUtils.enableSearchActions((ProfilerTable)table);
                    }
                });
            }
        }

        private JComponent getBottomPanel() {
            if (this.bottomPanel == null) {
                this.bottomPanel = new JPanel(new FilterFindLayout());
                this.bottomPanel.setOpaque(true);
                this.bottomPanel.setBackground(UIManager.getColor("controlShadow"));
                this.add((Component)this.bottomPanel, "South");
            }
            return this.bottomPanel;
        }

        private void activateFilter() {
            JComponent panel = this.getBottomPanel();
            if (this.filterPanel == null) {
                this.filterPanel = FilterUtils.createFilterPanel((ProfilerTable)this.table, null);
                panel.add(this.filterPanel);
                Container parent = panel.getParent();
                parent.invalidate();
                parent.revalidate();
                parent.repaint();
            }
            panel.setVisible(true);
            this.filterPanel.setVisible(true);
            this.filterPanel.requestFocusInWindow();
        }

        private void activateSearch() {
            JComponent panel = this.getBottomPanel();
            if (this.searchPanel == null) {
                this.searchPanel = SearchUtils.createSearchPanel((ProfilerTable)this.table);
                panel.add(this.searchPanel);
                Container parent = panel.getParent();
                parent.invalidate();
                parent.revalidate();
                parent.repaint();
            }
            panel.setVisible(true);
            this.searchPanel.setVisible(true);
            this.searchPanel.requestFocusInWindow();
        }

        static /* synthetic */ String[] access$002(HeapViewSupport x0, String[] x1) {
            x0.names = x1;
            return x1;
        }

        static /* synthetic */ long[] access$202(HeapViewSupport x0, long[] x1) {
            x0.sizes = x1;
            return x1;
        }

        static /* synthetic */ long[] access$302(HeapViewSupport x0, long[] x1) {
            x0.counts = x1;
            return x1;
        }

        private class HeapTableModel
        extends AbstractTableModel {
            private HeapTableModel() {
            }

            @Override
            public String getColumnName(int columnIndex) {
                if (columnIndex == 0) {
                    return "Name";
                }
                if (columnIndex == 1) {
                    return "Bytes";
                }
                if (columnIndex == 2) {
                    return "Objects";
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 0) {
                    return String.class;
                }
                return Long.class;
            }

            @Override
            public int getRowCount() {
                return HeapViewSupport.this.names == null ? 0 : HeapViewSupport.this.names.length;
            }

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return HeapViewSupport.this.names[rowIndex];
                }
                if (columnIndex == 1) {
                    return HeapViewSupport.this.sizes[rowIndex];
                }
                if (columnIndex == 2) {
                    return HeapViewSupport.this.counts[rowIndex];
                }
                return null;
            }
        }

        private final class FilterFindLayout
        implements LayoutManager {
            private FilterFindLayout() {
            }

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                JComponent search;
                JComponent filter = HeapViewSupport.this.filterPanel;
                if (filter != null && !filter.isVisible()) {
                    filter = null;
                }
                if ((search = HeapViewSupport.this.searchPanel) != null && !search.isVisible()) {
                    search = null;
                }
                Dimension dim = new Dimension();
                if (filter != null && search != null) {
                    Dimension dim1 = filter.getPreferredSize();
                    Dimension dim2 = search.getPreferredSize();
                    dim.width = dim1.width + dim2.width + 1;
                    dim.height = Math.max(dim1.height, dim2.height);
                } else if (filter != null) {
                    dim = filter.getPreferredSize();
                } else if (search != null) {
                    dim = search.getPreferredSize();
                }
                if (filter != null || search != null) {
                    ++dim.height;
                }
                return dim;
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                JComponent search;
                JComponent filter = HeapViewSupport.this.filterPanel;
                if (filter != null && !filter.isVisible()) {
                    filter = null;
                }
                if ((search = HeapViewSupport.this.searchPanel) != null && !search.isVisible()) {
                    search = null;
                }
                Dimension dim = new Dimension();
                if (filter != null && search != null) {
                    Dimension dim1 = filter.getMinimumSize();
                    Dimension dim2 = search.getMinimumSize();
                    dim.width = dim1.width + dim2.width + 1;
                    dim.height = Math.max(dim1.height, dim2.height);
                } else if (filter != null) {
                    dim = filter.getMinimumSize();
                } else if (search != null) {
                    dim = search.getMinimumSize();
                }
                if (filter != null || search != null) {
                    ++dim.height;
                }
                return dim;
            }

            @Override
            public void layoutContainer(Container parent) {
                JComponent search;
                JComponent filter = HeapViewSupport.this.filterPanel;
                if (filter != null && !filter.isVisible()) {
                    filter = null;
                }
                if ((search = HeapViewSupport.this.searchPanel) != null && !search.isVisible()) {
                    search = null;
                }
                int bottomOffset = 0;
                if (filter != null && search != null) {
                    Dimension size = parent.getSize();
                    int w = (size.width - 1) / 2;
                    filter.setBounds(0, 0, w, size.height - bottomOffset);
                    search.setBounds(w + 1, 0, size.width - w - 1, size.height - bottomOffset);
                } else if (filter != null) {
                    Dimension size = parent.getSize();
                    filter.setBounds(0, 0, size.width, size.height - bottomOffset);
                } else if (search != null) {
                    Dimension size = parent.getSize();
                    search.setBounds(0, 0, size.width, size.height - bottomOffset);
                }
            }
        }
    }
}

