/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.ui.actions;

import java.util.Collections;
import java.util.Set;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.explorer.ExplorerSupport;

public final class ActionUtils {
    public static DataSource getSelectedDataSource() {
        Set<DataSource> selectedDataSources = ActionUtils.getSelectedDataSources();
        return selectedDataSources.size() == 1 ? selectedDataSources.iterator().next() : null;
    }

    public static <X extends DataSource> X getSelectedDataSource(Class<X> scope) {
        Set<X> selectedDataSources = ActionUtils.getSelectedDataSources(scope);
        return (X)(selectedDataSources.size() == 1 ? (DataSource)selectedDataSources.iterator().next() : null);
    }

    public static Set<DataSource> getSelectedDataSources() {
        Set<DataSource> selectedDataSources = ExplorerSupport.sharedInstance().getSelectedDataSources();
        return selectedDataSources;
    }

    public static <X extends DataSource> Set<X> getSelectedDataSources(Class<X> scope) {
        Set<DataSource> selectedDataSources = ActionUtils.getSelectedDataSources();
        Set filteredSelectedDataSources = Utils.getFilteredSet(selectedDataSources, scope);
        return selectedDataSources.size() == filteredSelectedDataSources.size() ? filteredSelectedDataSources : Collections.EMPTY_SET;
    }
}

