/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.laf.flatlaf.ui;

import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.swing.laf.flatlaf.ui.Utils;
import org.openide.util.VectorIcon;

public final class FlatTabControlIcon
extends VectorIcon {
    private static final boolean chevron = "chevron".equals(UIManager.getString("Component.arrowType"));
    private static final int arc = UIManager.getInt("TabControlIcon.arc");
    private static final Color foreground = UIManager.getColor("TabControlIcon.foreground");
    private static final Color disabledForeground = UIManager.getColor("TabControlIcon.disabledForeground");
    private static final Color rolloverBackground = UIManager.getColor("TabControlIcon.rolloverBackground");
    private static final Color pressedBackground = UIManager.getColor("TabControlIcon.pressedBackground");
    private static final Color closeRolloverBackground = UIManager.getColor("TabControlIcon.close.rolloverBackground");
    private static final Color closeRolloverForeground = UIManager.getColor("TabControlIcon.close.rolloverForeground");
    private static final Map<Map.Entry<Integer, Integer>, Icon> INSTANCES = FlatTabControlIcon.populateInstances();
    private final int buttonId;
    private final Integer buttonState;
    private final float userScaleFactor;

    private static void populateOne(Map<Map.Entry<Integer, Integer>, Icon> map, int n, Integer n2) {
        map.put(new AbstractMap.SimpleEntry<Integer, Integer>(n, n2), (Icon)((Object)new FlatTabControlIcon(n, n2)));
    }

    private static Map<Map.Entry<Integer, Integer>, Icon> populateInstances() {
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put("close", 1);
        linkedHashMap.put("pin", 2);
        linkedHashMap.put("restore_group", 11);
        linkedHashMap.put("slide_group", 12);
        linkedHashMap.put("scroll_left", 9);
        linkedHashMap.put("scroll_right", 10);
        linkedHashMap.put("drop_down", 8);
        linkedHashMap.put("maximize", 3);
        linkedHashMap.put("restore", 4);
        LinkedHashMap<String, Integer> linkedHashMap2 = new LinkedHashMap<String, Integer>();
        linkedHashMap2.put("component", null);
        linkedHashMap2.put("default", 0);
        linkedHashMap2.put("pressed", 1);
        linkedHashMap2.put("disabled", 2);
        linkedHashMap2.put("rollover", 3);
        LinkedHashMap<Map.Entry<Integer, Integer>, Icon> linkedHashMap3 = new LinkedHashMap<Map.Entry<Integer, Integer>, Icon>();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            for (Map.Entry entry2 : linkedHashMap2.entrySet()) {
                FlatTabControlIcon.populateOne(linkedHashMap3, (Integer)entry.getValue(), (Integer)entry2.getValue());
            }
        }
        return Collections.unmodifiableMap(linkedHashMap3);
    }

    private FlatTabControlIcon(int n, Integer n2) {
        super(UIScale.scale((int)16), UIScale.scale((int)16));
        this.buttonId = n;
        this.buttonState = n2;
        this.userScaleFactor = UIScale.getUserScaleFactor();
    }

    public static Icon get(int n, int n2) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Integer>(n, n2));
    }

    public static Icon get(int n) {
        return INSTANCES.get(new AbstractMap.SimpleEntry<Integer, Object>(n, null));
    }

    protected void paintIcon(Component component, Graphics2D graphics2D, int n, int n2, double d) {
        Object object;
        int n3;
        d *= (double)this.userScaleFactor;
        Object object2 = new Color(0, 0, 0, 0);
        Color color = foreground;
        if (this.buttonState != null) {
            n3 = this.buttonState;
        } else {
            n3 = 0;
            if (!component.isEnabled()) {
                n3 = 2;
            } else if (component instanceof AbstractButton) {
                object = ((AbstractButton)component).getModel();
                if (object.isPressed()) {
                    n3 = 1;
                } else if (object.isRollover()) {
                    n3 = 3;
                }
            }
        }
        Object object3 = object = this.buttonId == 1 ? closeRolloverBackground : null;
        if (n3 == 2) {
            color = disabledForeground;
        } else if (n3 == 1) {
            Object object4 = object2 = object != null ? object : pressedBackground;
            if (object != null && closeRolloverForeground != null) {
                color = closeRolloverForeground;
            }
        } else if (n3 == 3) {
            Object object5 = object2 = object != null ? object : rolloverBackground;
            if (object != null && closeRolloverForeground != null) {
                color = closeRolloverForeground;
            }
        }
        if (((Color)object2).getAlpha() > 0) {
            n3 = FlatTabControlIcon.round((double)((double)(arc * 2) * d));
            graphics2D.setColor((Color)object2);
            graphics2D.fillRoundRect(0, 0, n, n2, n3, n3);
        }
        graphics2D.setColor(color);
        if (this.buttonId == 1) {
            double d2 = (((Color)object2).getAlpha() > 0 ? 1.0 : 0.8) * d;
            if (d > 1.0) {
                d2 *= 1.5;
            } else if (d2 < 1.0) {
                d2 = 1.0;
            }
            double d3 = (double)n / 2.0;
            double d4 = (double)n2 / 2.0;
            double d5 = 3.25 * d;
            BasicStroke basicStroke = new BasicStroke((float)d2, 1, 1);
            Area area = new Area();
            area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d3 - d5, d4 - d5, d3 + d5, d4 + d5))));
            area.add(new Area(basicStroke.createStrokedShape(new Line2D.Double(d3 + d5, d4 - d5, d3 - d5, d4 + d5))));
            graphics2D.fill(area);
        } else if (this.buttonId == 2 || this.buttonId == 11 || this.buttonId == 4) {
            n3 = FlatTabControlIcon.round((double)(8.0 * d));
            int n4 = FlatTabControlIcon.round((double)(5.0 * d));
            int n5 = FlatTabControlIcon.round((double)(3.0 * d));
            int n6 = FlatTabControlIcon.round((double)(3.0 * d));
            int n7 = FlatTabControlIcon.round((double)(5.0 * d));
            Area area = FlatTabControlIcon.getWindowSymbol(d, n4, n5, n3, n3);
            Area area2 = FlatTabControlIcon.getWindowSymbol(d, n6, n7, n3, n3);
            area.subtract(new Area(area2.getBounds2D()));
            graphics2D.fill(area);
            graphics2D.fill(area2);
        } else if (this.buttonId == 3) {
            n3 = (int)(3.0 * d);
            int n8 = n - 2 * n3;
            graphics2D.fill(FlatTabControlIcon.getWindowSymbol(d, n3, n3, n8, n8));
        } else if (this.buttonId == 12) {
            n3 = (int)(3.0 * d);
            int n9 = FlatTabControlIcon.round((double)(11.0 * d));
            int n10 = n - 2 * n3;
            int n11 = (int)(1.0 * d);
            graphics2D.fill(new Rectangle2D.Double(n3, n9, n10, n11));
        } else if (this.buttonId == 8 || this.buttonId == 9 || this.buttonId == 10) {
            if (this.buttonId == 9) {
                graphics2D.rotate(1.5707963267948966, (double)n / 2.0, (double)n2 / 2.0);
            } else if (this.buttonId == 10) {
                graphics2D.rotate(-1.5707963267948966, (double)n / 2.0, (double)n2 / 2.0);
            }
            n3 = FlatTabControlIcon.round((double)(((double)n2 - 4.0 * d) / 2.0));
            double d6 = (chevron ? 8.0 : 9.0) * d;
            double d7 = (chevron ? 4.0 : 5.0) * d;
            double d8 = (double)n / 2.0;
            if (!chevron && d == 1.0) {
                d8 -= 0.5;
                if (this.buttonId == 9) {
                    d8 += 1.0;
                }
            }
            Path2D.Double double_ = new Path2D.Double();
            double_.moveTo(d8 - d6 / 2.0, n3);
            double_.lineTo(d8, (double)n3 + d7);
            double_.lineTo(d8 + d6 / 2.0, n3);
            if (chevron) {
                Utils.setRenderingHints(graphics2D);
                graphics2D.setStroke(new BasicStroke((float)d));
                graphics2D.draw(double_);
            } else {
                double_.closePath();
                graphics2D.fill(double_);
            }
        }
    }

    private static Area getWindowSymbol(double d, int n, int n2, int n3, int n4) {
        int n5 = FlatTabControlIcon.round((double)(0.8 * d));
        Area area = new Area(new Rectangle2D.Double(n, n2, n3, n4));
        area.subtract(new Area(new Rectangle2D.Double(n + n5, n2 + n5, n3 - n5 * 2, n4 - n5 * 2)));
        return area;
    }
}

