/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2017 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "WebPreferences.h"

#include "WebPreferencesDefinitions.h"
#include "WebPreferencesKeys.h"
#include <wtf/ExperimentalFeatureNames.h>

namespace WebKit {

const Vector<RefPtr<API::Object>>& WebPreferences::experimentalFeatures()
{
    static NeverDestroyed<Vector<RefPtr<API::Object>>> features(std::initializer_list<RefPtr<API::Object>> {
        API::ExperimentalFeature::create(":focus-visible pseudo-class", "FocusVisibleEnabled", "Enable the focus-indicated pseudo-class :focus-visible", DEFAULT_VALUE_FOR_FocusVisibleEnabled, false),
        API::ExperimentalFeature::create(":has() pseudo-class", "HasPseudoClassEnabled", "Enable :has() pseudo-class", DEFAULT_VALUE_FOR_HasPseudoClassEnabled, false),
        API::ExperimentalFeature::create("@page CSS at-rule support", "PageAtRuleSupportEnabled", "Enable @page support", DEFAULT_VALUE_FOR_PageAtRuleSupportEnabled, false),
        API::ExperimentalFeature::create("AccessHandle API", "AccessHandleEnabled", "Enable AccessHandle API", DEFAULT_VALUE_FOR_AccessHandleEnabled, false),
        API::ExperimentalFeature::create("Accessibility Object Model", "AccessibilityObjectModelEnabled", "Accessibility Object Model support", DEFAULT_VALUE_FOR_AccessibilityObjectModelEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::ExperimentalFeature::create("Allow per media element speaker device selection", "PerElementSpeakerSelectionEnabled", "Allow per media element speaker device selection", DEFAULT_VALUE_FOR_PerElementSpeakerSelectionEnabled, false),
#endif
#if ENABLE(MEDIA_STREAM)
        API::ExperimentalFeature::create("Allow speaker device selection", "ExposeSpeakersEnabled", "Allow speaker device selection", DEFAULT_VALUE_FOR_ExposeSpeakersEnabled, false),
#endif
        API::ExperimentalFeature::create("Aspect ratio of <img> from width and height", "AspectRatioOfImgFromWidthAndHeightEnabled", "Map HTML attributes width/height to the default aspect ratio of <img>", DEFAULT_VALUE_FOR_AspectRatioOfImgFromWidthAndHeightEnabled, false),
        API::ExperimentalFeature::create("Async clipboard API", "AsyncClipboardAPIEnabled", "Enable the async clipboard API", DEFAULT_VALUE_FOR_AsyncClipboardAPIEnabled, false),
        API::ExperimentalFeature::create("Blank anchor target implies rel=noopener", "BlankAnchorTargetImpliesNoOpenerEnabled", "target=_blank on anchor elements implies rel=noopener", DEFAULT_VALUE_FOR_BlankAnchorTargetImpliesNoOpenerEnabled, false),
        API::ExperimentalFeature::create("Block top-level redirects by third-party iframes", "ThirdPartyIframeRedirectBlockingEnabled", "Block top-level redirects by third-party iframes", DEFAULT_VALUE_FOR_ThirdPartyIframeRedirectBlockingEnabled, false),
        API::ExperimentalFeature::create("BroadcastChannel API", "BroadcastChannelEnabled", "BroadcastChannel API", DEFAULT_VALUE_FOR_BroadcastChannelEnabled, false),
        API::ExperimentalFeature::create("BroadcastChannel Origin Partitioning", "BroadcastChannelOriginPartitioningEnabled", "BroadcastChannel Origin Partitioning", DEFAULT_VALUE_FOR_BroadcastChannelOriginPartitioningEnabled, false),
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        API::ExperimentalFeature::create("Built-In Web Notifications", "BuiltInNotificationsEnabled", "Enable built-in WebKit managed notifications", DEFAULT_VALUE_FOR_BuiltInNotificationsEnabled, false),
#endif
        API::ExperimentalFeature::create("CSS 3D Transform Interoperability", "CSS3DTransformInteroperabilityEnabled", "Enable 3D transform behavior that is specification-compliant but backwards incompatible", DEFAULT_VALUE_FOR_CSS3DTransformInteroperabilityEnabled, false),
        API::ExperimentalFeature::create("CSS @counter-style <image> symbols", "CSSCounterStyleAtRuleImageSymbolsEnabled", "Enable support for <image> symbols in CSS @counter-style rules", DEFAULT_VALUE_FOR_CSSCounterStyleAtRuleImageSymbolsEnabled, false),
        API::ExperimentalFeature::create("CSS @counter-style", "CSSCounterStyleAtRulesEnabled", "Enable support for CSS @counter-style rules", DEFAULT_VALUE_FOR_CSSCounterStyleAtRulesEnabled, false),
        API::ExperimentalFeature::create("CSS Accent Color", "AccentColorEnabled", "Enable accent-color CSS property", DEFAULT_VALUE_FOR_AccentColorEnabled, false),
        API::ExperimentalFeature::create("CSS Aspect Ratio", "AspectRatioEnabled", "Enable aspect-ratio CSS property", DEFAULT_VALUE_FOR_AspectRatioEnabled, false),
        API::ExperimentalFeature::create("CSS Cascade Layers", "CSSCascadeLayersEnabled", "Enable CSS Cascade Layers", DEFAULT_VALUE_FOR_CSSCascadeLayersEnabled, false),
        API::ExperimentalFeature::create("CSS Color 4 Color Types", "CSSColor4", "Enable support for CSS Color 4 Color Types", DEFAULT_VALUE_FOR_CSSColor4, false),
        API::ExperimentalFeature::create("CSS Container Queries", "CSSContainerQueriesEnabled", "Enable CSS Container Queries", DEFAULT_VALUE_FOR_CSSContainerQueriesEnabled, false),
        API::ExperimentalFeature::create("CSS Containment", "CSSContainmentEnabled", "Enable contain CSS property", DEFAULT_VALUE_FOR_CSSContainmentEnabled, false),
        API::ExperimentalFeature::create("CSS Custom Properties and Values API", "CSSCustomPropertiesAndValuesEnabled", "Enable CSS Custom Properties and Values API", DEFAULT_VALUE_FOR_CSSCustomPropertiesAndValuesEnabled, false),
        API::ExperimentalFeature::create("CSS Gradient Interpolation Color Spaces", "CSSGradientInterpolationColorSpacesEnabled", "Enable custom interpolation in CSS gradients", DEFAULT_VALUE_FOR_CSSGradientInterpolationColorSpacesEnabled, false),
        API::ExperimentalFeature::create("CSS Gradient Premultiplied Alpha Interpolation", "CSSGradientPremultipliedAlphaInterpolationEnabled", "Enable premultiplied alpha interpolated CSS gradients", DEFAULT_VALUE_FOR_CSSGradientPremultipliedAlphaInterpolationEnabled, false),
        API::ExperimentalFeature::create("CSS Individual Transform Properties", "CSSIndividualTransformPropertiesEnabled", "Support for the translate, scale and rotate CSS properties", DEFAULT_VALUE_FOR_CSSIndividualTransformPropertiesEnabled, false),
        API::ExperimentalFeature::create("CSS Input Security", "CSSInputSecurityEnabled", "Enable input-security CSS property", DEFAULT_VALUE_FOR_CSSInputSecurityEnabled, false),
        API::ExperimentalFeature::create("CSS Motion Path", "CSSMotionPathEnabled", "Enable CSS Motion Path support", DEFAULT_VALUE_FOR_CSSMotionPathEnabled, false),
        API::ExperimentalFeature::create("CSS Overscroll Behavior", "OverscrollBehaviorEnabled", "Enable CSS overscroll-behavior", DEFAULT_VALUE_FOR_OverscrollBehaviorEnabled, false),
#if ENABLE(CSS_PAINTING_API)
        API::ExperimentalFeature::create("CSS Painting API", "CSSPaintingAPIEnabled", "Enable the CSS Painting API", DEFAULT_VALUE_FOR_CSSPaintingAPIEnabled, false),
#endif
        API::ExperimentalFeature::create("CSS Relative Color Syntax", "CSSRelativeColorSyntaxEnabled", "Enable support for CSS Relative Color Syntax defined in CSS Color 5", DEFAULT_VALUE_FOR_CSSRelativeColorSyntaxEnabled, false),
        API::ExperimentalFeature::create("CSS Spring Animations", "SpringTimingFunctionEnabled", "CSS Spring Animation prototype", DEFAULT_VALUE_FOR_SpringTimingFunctionEnabled, false),
#if ENABLE(CSS_TYPED_OM)
        API::ExperimentalFeature::create("CSS Typed OM", "CSSTypedOMEnabled", "Enable the CSS Typed OM", DEFAULT_VALUE_FOR_CSSTypedOMEnabled, false),
#endif
        API::ExperimentalFeature::create("CSS color-contrast()", "CSSColorContrastEnabled", "Enable support for CSS color-contrast() defined in CSS Color 5", DEFAULT_VALUE_FOR_CSSColorContrastEnabled, false),
        API::ExperimentalFeature::create("CSS color-mix()", "CSSColorMixEnabled", "Enable support for CSS color-mix() defined in CSS Color 5", DEFAULT_VALUE_FOR_CSSColorMixEnabled, false),
        API::ExperimentalFeature::create("CSS overflow: clip support", "OverflowClipEnabled", "Enable CSS overflow: clip support", DEFAULT_VALUE_FOR_OverflowClipEnabled, false),
        API::ExperimentalFeature::create("CSS subgrid support", "SubgridEnabled", "Enable CSS subgrid support", DEFAULT_VALUE_FOR_SubgridEnabled, false),
        API::ExperimentalFeature::create("CSSOM View Smooth Scrolling", "CSSOMViewSmoothScrollingEnabled", "Enable DOM API and CSS property for 'smooth' scroll behavior", DEFAULT_VALUE_FOR_CSSOMViewSmoothScrollingEnabled, false),
        API::ExperimentalFeature::create("Canvas Color Spaces", "CanvasColorSpaceEnabled", "Enable use of predefined canvas color spaces", DEFAULT_VALUE_FOR_CanvasColorSpaceEnabled, false),
        API::ExperimentalFeature::create("Contact Picker API", "ContactPickerAPIEnabled", "Enable the Contact Picker API", DEFAULT_VALUE_FOR_ContactPickerAPIEnabled, false),
        API::ExperimentalFeature::create("Cross-Origin-Embedder-Policy (COEP) header", "CrossOriginEmbedderPolicyEnabled", "Support for Cross-Origin-Embedder-Policy (COEP) header", DEFAULT_VALUE_FOR_CrossOriginEmbedderPolicyEnabled, false),
        API::ExperimentalFeature::create("Cross-Origin-Opener-Policy (COOP) header", "CrossOriginOpenerPolicyEnabled", "Support for Cross-Origin-Opener-Policy (COOP) header", DEFAULT_VALUE_FOR_CrossOriginOpenerPolicyEnabled, false),
        API::ExperimentalFeature::create("Defer async scripts until DOMContentLoaded or first-paint", "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint", "Defer async scripts until DOMContentLoaded or first-paint", DEFAULT_VALUE_FOR_ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint, false),
        API::ExperimentalFeature::create("Dialog Element", "DialogElementEnabled", "Enable the Dialog Element", DEFAULT_VALUE_FOR_DialogElementEnabled, false),
        API::ExperimentalFeature::create("Disable Full 3rd-Party Cookie Blocking (ITP)", "IsThirdPartyCookieBlockingDisabled", "Disable full third-party cookie blocking when Intelligent Tracking Prevention is enabled", DEFAULT_VALUE_FOR_IsThirdPartyCookieBlockingDisabled, false),
#if HAVE(CELESTIAL)
        API::ExperimentalFeature::create("Disable Media Experience PID Inheritance", "DisableMediaExperiencePIDInheritance", "Disable Media Experience PID Inheritance", DEFAULT_VALUE_FOR_DisableMediaExperiencePIDInheritance, false),
#endif
        API::ExperimentalFeature::create("Disable Removal of Non-Cookie Data After 7 Days of No User Interaction (ITP)", "IsFirstPartyWebsiteDataRemovalDisabled", "Disable removal of all non-cookie website data after seven days of no user interaction when Intelligent Tracking Prevention is enabled", DEFAULT_VALUE_FOR_IsFirstPartyWebsiteDataRemovalDisabled, false),
        API::ExperimentalFeature::create("Disallow sync XHR during page dismissal", "DisallowSyncXHRDuringPageDismissalEnabled", "Disallow synchronous XMLHttpRequest during page dismissal", DEFAULT_VALUE_FOR_DisallowSyncXHRDuringPageDismissalEnabled, false),
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        API::ExperimentalFeature::create("Experimental MediaSession coordinator API", "MediaSessionCoordinatorEnabled", "Enable experimental MediaSession coordinator API", DEFAULT_VALUE_FOR_MediaSessionCoordinatorEnabled, false),
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        API::ExperimentalFeature::create("Experimental MediaSession playlist API", "MediaSessionPlaylistEnabled", "Enable experimental MediaSession playlist API", DEFAULT_VALUE_FOR_MediaSessionPlaylistEnabled, false),
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        API::ExperimentalFeature::create("Experimental MediaSource Inline Painting", "MediaSourceInlinePaintingEnabled", "Experimental MediaSource Inline Painting", DEFAULT_VALUE_FOR_MediaSourceInlinePaintingEnabled, false),
#endif
#if HAVE(NETWORK_LOADER)
        API::ExperimentalFeature::create("Experimental network loader", "CFNetworkNetworkLoaderEnabled", "Enable experimental network loader", DEFAULT_VALUE_FOR_CFNetworkNetworkLoaderEnabled, false),
#endif
        API::ExperimentalFeature::create("FTP support enabled", "FTPEnabled", "FTP support enabled", DEFAULT_VALUE_FOR_FTPEnabled, false),
        API::ExperimentalFeature::create("Fetch API Request KeepAlive", "FetchAPIKeepAliveEnabled", "Enable Fetch API Request KeepAlive", DEFAULT_VALUE_FOR_FetchAPIKeepAliveEnabled, false),
        API::ExperimentalFeature::create("File System Access API", "FileSystemAccessEnabled", "Enable File System Access API", DEFAULT_VALUE_FOR_FileSystemAccessEnabled, false),
        API::ExperimentalFeature::create("Form requestSubmit", "RequestSubmitEnabled", "Form requestSubmit method", DEFAULT_VALUE_FOR_RequestSubmitEnabled, false),
#if ENABLE(GPU_PROCESS)
        API::ExperimentalFeature::create("GPU Process: DOM Rendering", "UseGPUProcessForDOMRenderingEnabled", "Enable DOM rendering in GPU Process", DEFAULT_VALUE_FOR_UseGPUProcessForDOMRenderingEnabled, false),
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        API::ExperimentalFeature::create("GPU Process: Screen and Window capture", "UseGPUProcessForDisplayCapture", "Display capture in GPU Process", DEFAULT_VALUE_FOR_UseGPUProcessForDisplayCapture, false),
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL) && !(PLATFORM(GTK) || PLATFORM(WPE))
        API::ExperimentalFeature::create("GPU Process: WebGL", "UseGPUProcessForWebGLEnabled", "Process all WebGL operations in GPU Process", DEFAULT_VALUE_FOR_UseGPUProcessForWebGLEnabled, false),
#endif
#if ENABLE(VIDEO)
        API::ExperimentalFeature::create("Generic Text Track Cue API", "GenericCueAPIEnabled", "Enable Generic Text Track Cue API", DEFAULT_VALUE_FOR_GenericCueAPIEnabled, false),
#endif
        API::ExperimentalFeature::create("HDR Media Capabilities", "HDRMediaCapabilitiesEnabled", "HDR Media Capabilities", DEFAULT_VALUE_FOR_HDRMediaCapabilitiesEnabled, false),
#if ENABLE(MODEL_ELEMENT)
        API::ExperimentalFeature::create("HTML <model> element", "ModelElementEnabled", "HTML <model> element", DEFAULT_VALUE_FOR_ModelElementEnabled, false),
#endif
#if ENABLE(MODEL_ELEMENT)
        API::ExperimentalFeature::create("HTML <model> elements for stand-alone document", "ModelDocumentEnabled", "HTML <model> element for model documents", DEFAULT_VALUE_FOR_ModelDocumentEnabled, false),
#endif
#if HAVE(CFNETWORK_ALTERNATIVE_SERVICE)
        API::ExperimentalFeature::create("HTTP/3", "HTTP3Enabled", "Enable HTTP/3", DEFAULT_VALUE_FOR_HTTP3Enabled, false),
#endif
        API::ExperimentalFeature::create("Highlight API", "HighlightAPIEnabled", "Highlight API support", DEFAULT_VALUE_FOR_HighlightAPIEnabled, false),
        API::ExperimentalFeature::create("ImageBitmap", "ImageBitmapEnabled", "Support for the ImageBitmap APIs", DEFAULT_VALUE_FOR_ImageBitmapEnabled, false),
        API::ExperimentalFeature::create("In-Process Cookie Cache", "InProcessCookieCacheEnabled", "In-Process DOM Cookie Cache", DEFAULT_VALUE_FOR_InProcessCookieCacheEnabled, false),
#if HAVE(INCREMENTAL_PDF_APIS)
        API::ExperimentalFeature::create("Incremental PDF Loading", "IncrementalPDFLoadingEnabled", "Enable Incremental PDF Loading on supported platforms", DEFAULT_VALUE_FOR_IncrementalPDFLoadingEnabled, false),
#endif
        API::ExperimentalFeature::create("Intersection Observer", "IntersectionObserverEnabled", "Enable Intersection Observer support", DEFAULT_VALUE_FOR_IntersectionObserverEnabled, false),
        API::ExperimentalFeature::create("IsLoggedIn web API", "IsLoggedInAPIEnabled", "Enable the proposed IsLoggedIn web API", DEFAULT_VALUE_FOR_IsLoggedInAPIEnabled, false),
        API::ExperimentalFeature::create("Lazy iframe loading", "LazyIframeLoadingEnabled", "Enable lazy iframe loading support", DEFAULT_VALUE_FOR_LazyIframeLoadingEnabled, false),
        API::ExperimentalFeature::create("Lazy image loading", "LazyImageLoadingEnabled", "Enable lazy image loading support", DEFAULT_VALUE_FOR_LazyImageLoadingEnabled, false),
        API::ExperimentalFeature::create("Link Sanitizer", "LinkSanitizerEnabled", "Enable link sanitizer", DEFAULT_VALUE_FOR_LinkSanitizerEnabled, false),
        API::ExperimentalFeature::create("Link preload responsive images", "LinkPreloadResponsiveImagesEnabled", "Enable link preload responsive images", DEFAULT_VALUE_FOR_LinkPreloadResponsiveImagesEnabled, false),
        API::ExperimentalFeature::create("LinkPrefetch", "LinkPrefetchEnabled", "Enable LinkedPrefetch", DEFAULT_VALUE_FOR_LinkPrefetchEnabled, false),
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        API::ExperimentalFeature::create("Mask WebGL Strings", "MaskWebGLStringsEnabled", "Mask WebGL Vendor, Renderer, Shader Language Strings", DEFAULT_VALUE_FOR_MaskWebGLStringsEnabled, false),
#endif
        API::ExperimentalFeature::create("MathML Core", "CoreMathMLEnabled", "Disable features removed from the MathML Core spec.", DEFAULT_VALUE_FOR_CoreMathMLEnabled, false),
        API::ExperimentalFeature::create("Media Capabilities Extensions", "MediaCapabilitiesExtensionsEnabled", "Media Capabilities Extensions", DEFAULT_VALUE_FOR_MediaCapabilitiesExtensionsEnabled, false),
#if ENABLE(MEDIA_SESSION)
        API::ExperimentalFeature::create("Media Session API", "MediaSessionEnabled", "Media Session API", DEFAULT_VALUE_FOR_MediaSessionEnabled, false),
#endif
#if ENABLE(MEDIA_RECORDER)
        API::ExperimentalFeature::create("MediaRecorder", "MediaRecorderEnabled", "MediaRecorder", DEFAULT_VALUE_FOR_MediaRecorderEnabled, false),
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
        API::ExperimentalFeature::create("NSURLSession WebSocket", "IsNSURLSessionWebSocketEnabled", "Use NSURLSession WebSocket API", DEFAULT_VALUE_FOR_IsNSURLSessionWebSocketEnabled, false),
#endif
#if ENABLE(OPUS)
        API::ExperimentalFeature::create("Opus audio decoder", "OpusDecoderEnabled", "Enable Opus audio decoder", DEFAULT_VALUE_FOR_OpusDecoderEnabled, false),
#endif
        API::ExperimentalFeature::create("Paint Timing", "PaintTimingEnabled", "Enable PaintTiming API", DEFAULT_VALUE_FOR_PaintTimingEnabled, false),
        API::ExperimentalFeature::create("PerformanceNavigationTiming", "PerformanceNavigationTimingAPIEnabled", "Enable PerformanceNavigationTiming API", DEFAULT_VALUE_FOR_PerformanceNavigationTimingAPIEnabled, false),
        API::ExperimentalFeature::create("PerformanceResourceTiming.transferSize, encodedBodySize, and decodedBodySize", "PerformanceResourceTimingSensitivePropertiesEnabled", "Enable all properties of PerformanceResourceTiming API", DEFAULT_VALUE_FOR_PerformanceResourceTimingSensitivePropertiesEnabled, false),
        API::ExperimentalFeature::create("Permissions API", "PermissionsAPIEnabled", "Enable Permissions API", DEFAULT_VALUE_FOR_PermissionsAPIEnabled, false),
        API::ExperimentalFeature::create("Prefer Page Rendering Updates near 60fps", "PreferPageRenderingUpdatesNear60FPSEnabled", "Prefer page rendering updates near 60 frames per second rather than using the display's refresh rate", DEFAULT_VALUE_FOR_PreferPageRenderingUpdatesNear60FPSEnabled, false),
        API::ExperimentalFeature::create("Private Click Measurement Debug Mode", "PrivateClickMeasurementDebugModeEnabled", "Enable Private Click Measurement Debug Mode", DEFAULT_VALUE_FOR_PrivateClickMeasurementDebugModeEnabled, false),
        API::ExperimentalFeature::create("Private Click Measurement Fraud Prevention", "PrivateClickMeasurementFraudPreventionEnabled", "Enable Private Click Measurement Fraud Prevention", DEFAULT_VALUE_FOR_PrivateClickMeasurementFraudPreventionEnabled, false),
#if ENABLE(SERVICE_WORKER)
        API::ExperimentalFeature::create("Push API", "PushAPIEnabled", "Enable Push API", DEFAULT_VALUE_FOR_PushAPIEnabled, false),
#endif
        API::ExperimentalFeature::create("Quirk to prevent delayed initial painting on sites using Google's Anti-Flicker optimization", "GoogleAntiFlickerOptimizationQuirkEnabled", "Quirk to prevent delayed initial painting on sites using Google's Anti-Flicker optimization", DEFAULT_VALUE_FOR_GoogleAntiFlickerOptimizationQuirkEnabled, false),
        API::ExperimentalFeature::create("ReadableByteStream", "ReadableByteStreamAPIEnabled", "Enable Readable Byte Streams", DEFAULT_VALUE_FOR_ReadableByteStreamAPIEnabled, false),
        API::ExperimentalFeature::create("Referrer Policy attribute", "ReferrerPolicyAttributeEnabled", "Enable Referrer Policy attribute", DEFAULT_VALUE_FOR_ReferrerPolicyAttributeEnabled, false),
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        API::ExperimentalFeature::create("Remote Playback API", "RemotePlaybackEnabled", "Enable Remote Playback API", DEFAULT_VALUE_FOR_RemotePlaybackEnabled, false),
#endif
        API::ExperimentalFeature::create("RequestVideoFrameCallback", "RequestVideoFrameCallbackEnabled", "Enable RequestVideoFrameCallback API", DEFAULT_VALUE_FOR_RequestVideoFrameCallbackEnabled, false),
        API::ExperimentalFeature::create("Resize Observer", "ResizeObserverEnabled", "Enable Resize Observer support", DEFAULT_VALUE_FOR_ResizeObserverEnabled, false),
        API::ExperimentalFeature::create("Resolution media feature", "ResolutionMediaFeatureEnabled", "Enable resolution media feature support", DEFAULT_VALUE_FOR_ResolutionMediaFeatureEnabled, false),
        API::ExperimentalFeature::create("SameSite strict enforcement (ITP)", "IsSameSiteStrictEnforcementEnabled", "Enable SameSite strict enforcement to mitigate bounce tracking", DEFAULT_VALUE_FOR_IsSameSiteStrictEnforcementEnabled, false),
#if ENABLE(MEDIA_STREAM)
        API::ExperimentalFeature::create("ScreenCapture", "ScreenCaptureEnabled", "Enable ScreenCapture", DEFAULT_VALUE_FOR_ScreenCaptureEnabled, false),
#endif
        API::ExperimentalFeature::create("Scroll To Text Fragment", "ScrollToTextFragmentEnabled", "Enable Scroll To Text Fragment", DEFAULT_VALUE_FOR_ScrollToTextFragmentEnabled, false),
        API::ExperimentalFeature::create("Server Timing", "ServerTimingEnabled", "Enable Server Timing API", DEFAULT_VALUE_FOR_ServerTimingEnabled, false),
#if ENABLE(SERVICE_WORKER)
        API::ExperimentalFeature::create("Service Worker Navigation Preload", "ServiceWorkerNavigationPreloadEnabled", "Enable Service Worker Navigation Preload API", DEFAULT_VALUE_FOR_ServiceWorkerNavigationPreloadEnabled, false),
#endif
        API::ExperimentalFeature::create("SharedWorker", "SharedWorkerEnabled", "Enabled SharedWorker API", DEFAULT_VALUE_FOR_SharedWorkerEnabled, false),
        API::ExperimentalFeature::create("SpeechRecognition API", "SpeechRecognitionEnabled", "Enable SpeechRecognition of WebSpeech API", DEFAULT_VALUE_FOR_SpeechRecognitionEnabled, false),
        API::ExperimentalFeature::create("Storage API", "StorageAPIEnabled", "Enable Storage API", DEFAULT_VALUE_FOR_StorageAPIEnabled, false),
        API::ExperimentalFeature::create("Swap Processes on Cross-Site Navigation", "ProcessSwapOnCrossSiteNavigationEnabled", "Swap WebContent Processes on cross-site navigations", DEFAULT_VALUE_FOR_ProcessSwapOnCrossSiteNavigationEnabled, false),
        API::ExperimentalFeature::create("Synthetic Editing Commands", "SyntheticEditingCommandsEnabled", "Enable Synthetic Editing Commands", DEFAULT_VALUE_FOR_SyntheticEditingCommandsEnabled, false),
        API::ExperimentalFeature::create("Track Configuration API", "TrackConfigurationEnabled", "Track Configuration API", DEFAULT_VALUE_FOR_TrackConfigurationEnabled, false),
        API::ExperimentalFeature::create("TransformStream API", "TransformStreamAPIEnabled", "Enable Transform Stream API", DEFAULT_VALUE_FOR_TransformStreamAPIEnabled, false),
#if HAVE(SCREEN_CAPTURE_KIT)
        API::ExperimentalFeature::create("Use ScreenCaptureKit", "UseScreenCaptureKit", "Use ScreenCaptureKit when available", DEFAULT_VALUE_FOR_UseScreenCaptureKit, false),
#endif
        API::ExperimentalFeature::create("UserGesture Promise Propagation", "UserGesturePromisePropagationEnabled", "UserGesture Promise Propagation", DEFAULT_VALUE_FOR_UserGesturePromisePropagationEnabled, false),
#if ENABLE(VP9)
        API::ExperimentalFeature::create("VP8 decoder", "VP8DecoderEnabled", "Enable VP8 decoder", DEFAULT_VALUE_FOR_VP8DecoderEnabled, false),
#endif
#if ENABLE(VP9)
        API::ExperimentalFeature::create("VP9 SW decoder on battery", "VP9SWDecoderEnabledOnBattery", "Enable VP9 SW decoder on battery", DEFAULT_VALUE_FOR_VP9SWDecoderEnabledOnBattery, false),
#endif
#if ENABLE(VP9)
        API::ExperimentalFeature::create("VP9 decoder", "VP9DecoderEnabled", "Enable VP9 decoder", DEFAULT_VALUE_FOR_VP9DecoderEnabled, false),
#endif
        API::ExperimentalFeature::create("Visual Viewport API", "VisualViewportAPIEnabled", "Enable Visual Viewport API", DEFAULT_VALUE_FOR_VisualViewportAPIEnabled, false),
#if ENABLE(VORBIS)
        API::ExperimentalFeature::create("Vorbis audio decoder", "VorbisDecoderEnabled", "Enable Vorbis audio decoder", DEFAULT_VALUE_FOR_VorbisDecoderEnabled, false),
#endif
        API::ExperimentalFeature::create("Web Animations composite operations", "WebAnimationsCompositeOperationsEnabled", "Support for the CompositeOperation enum and properties consuming it", DEFAULT_VALUE_FOR_WebAnimationsCompositeOperationsEnabled, false),
        API::ExperimentalFeature::create("Web Animations custom effects", "WebAnimationsCustomEffectsEnabled", "Support for the CustomEffect interface", DEFAULT_VALUE_FOR_WebAnimationsCustomEffectsEnabled, false),
        API::ExperimentalFeature::create("Web Animations custom frame rate", "WebAnimationsCustomFrameRateEnabled", "Support for specifying a custom frame rate for Web Animations", DEFAULT_VALUE_FOR_WebAnimationsCustomFrameRateEnabled, false),
        API::ExperimentalFeature::create("Web Animations mutable timelines", "WebAnimationsMutableTimelinesEnabled", "Support for setting the timeline property of an Animation object", DEFAULT_VALUE_FOR_WebAnimationsMutableTimelinesEnabled, false),
#if ENABLE(WEB_AUTHN)
        API::ExperimentalFeature::create("Web Authentication Modern", "WebAuthenticationModernEnabled", "Enable Modern Web Authentication support", DEFAULT_VALUE_FOR_WebAuthenticationModernEnabled, false),
#endif
#if ENABLE(WEB_AUTHN)
        API::ExperimentalFeature::create("Web Authentication", "WebAuthenticationEnabled", "Enable Web Authentication support", DEFAULT_VALUE_FOR_WebAuthenticationEnabled, false),
#endif
        API::ExperimentalFeature::create("Web Locks API", "WebLocksAPIEnabled", "Web Locks API", DEFAULT_VALUE_FOR_WebLocksAPIEnabled, false),
        API::ExperimentalFeature::create("Web Share API Level 2", "WebShareFileAPIEnabled", "Enable level 2 of Web Share API", DEFAULT_VALUE_FOR_WebShareFileAPIEnabled, false),
#if ENABLE(WEBGL2)
        API::ExperimentalFeature::create("WebGL 2.0", "WebGL2Enabled", "WebGL 2 prototype", DEFAULT_VALUE_FOR_WebGL2Enabled, false),
#endif
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        API::ExperimentalFeature::create("WebGL via Metal", "WebGLUsingMetal", "Use the Metal backend for ANGLE", DEFAULT_VALUE_FOR_WebGLUsingMetal, false),
#endif
#if ENABLE(MEDIA_SOURCE)
        API::ExperimentalFeature::create("WebM MSE parser", "WebMParserEnabled", "Enable WebM MSE parser", DEFAULT_VALUE_FOR_WebMParserEnabled, false),
#endif
#if ENABLE(WEBM_FORMAT_READER)
        API::ExperimentalFeature::create("WebM format reader", "WebMFormatReaderEnabled", "Enable MediaToolbox format reader plug-in for WebM", DEFAULT_VALUE_FOR_WebMFormatReaderEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Encoded Transform API", "WebRTCEncodedTransformEnabled", "Enable WebRTC Encoded Transform API", DEFAULT_VALUE_FOR_WebRTCEncodedTransformEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC H264 LowLatency encoder", "WebRTCH264LowLatencyEncoderEnabled", "Enable H264 LowLatency encoder", DEFAULT_VALUE_FOR_WebRTCH264LowLatencyEncoderEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC H265 codec", "WebRTCH265CodecEnabled", "Enable WebRTC H265 codec", DEFAULT_VALUE_FOR_WebRTCH265CodecEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Platform TCP Sockets", "WebRTCPlatformTCPSocketsEnabled", "Enable WebRTC Platform TCP Sockets", DEFAULT_VALUE_FOR_WebRTCPlatformTCPSocketsEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Platform UDP Sockets", "WebRTCPlatformUDPSocketsEnabled", "Enable WebRTC Platform UDP Sockets", DEFAULT_VALUE_FOR_WebRTCPlatformUDPSocketsEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC SFrame Transform API", "WebRTCSFrameTransformEnabled", "Enable WebRTC SFrame Transform API", DEFAULT_VALUE_FOR_WebRTCSFrameTransformEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC Sockets Proxying", "WebRTCSocketsProxyingEnabled", "Enable WebRTC Sockets Proxying", DEFAULT_VALUE_FOR_WebRTCSocketsProxyingEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC VP9 profile 0 codec", "WebRTCVP9Profile0CodecEnabled", "Enable WebRTC VP9 profile 0 codec", DEFAULT_VALUE_FOR_WebRTCVP9Profile0CodecEnabled, false),
#endif
#if ENABLE(WEB_RTC)
        API::ExperimentalFeature::create("WebRTC VP9 profile 2 codec", "WebRTCVP9Profile2CodecEnabled", "Enable WebRTC VP9 profile 2 codec", DEFAULT_VALUE_FOR_WebRTCVP9Profile2CodecEnabled, false),
#endif
#if ENABLE(WEBXR)
        API::ExperimentalFeature::create("WebXR Augmented Reality Module", "WebXRAugmentedRealityModuleEnabled", "Adds support for the WebXR Augmented Reality Module", DEFAULT_VALUE_FOR_WebXRAugmentedRealityModuleEnabled, false),
#endif
#if ENABLE(WEBXR)
        API::ExperimentalFeature::create("WebXR Device API", "WebXREnabled", "Adds support for accessing virtual reality (VR) and augmented reality (AR) devices, including sensors and head-mounted displays, on the Web", DEFAULT_VALUE_FOR_WebXREnabled, false),
#endif
#if ENABLE(WEBXR)
        API::ExperimentalFeature::create("WebXR Gamepads Module", "WebXRGamepadsModuleEnabled", "Adds support for the WebXR Gamepads Module", DEFAULT_VALUE_FOR_WebXRGamepadsModuleEnabled, false),
#endif
#if ENABLE(WEBXR_HANDS)
        API::ExperimentalFeature::create("WebXR Hand Input Module", "WebXRHandInputModuleEnabled", "Adds support for the Hands Input Module for WebXR", DEFAULT_VALUE_FOR_WebXRHandInputModuleEnabled, false),
#endif
        API::ExperimentalFeature::create("Wheel Event gestures become non-blocking", "WheelEventGesturesBecomeNonBlocking", "preventDefault() is only allowed on the first wheel event in a gesture", DEFAULT_VALUE_FOR_WheelEventGesturesBecomeNonBlocking, false),
        API::ExperimentalFeature::create("Wheel Event listeners on the root made passive", "PassiveWheelListenersAsDefaultOnDocument", "Force wheel event listeners registered on the window, document or body to be passive", DEFAULT_VALUE_FOR_PassiveWheelListenersAsDefaultOnDocument, false),
        API::ExperimentalFeature::create("inert attribute", "InertAttributeEnabled", "Enable inert attribute support", DEFAULT_VALUE_FOR_InertAttributeEnabled, false),
        API::ExperimentalFeature::create("requestIdleCallback", "RequestIdleCallbackEnabled", "Enable requestIdleCallback support", DEFAULT_VALUE_FOR_RequestIdleCallbackEnabled, false),
        API::ExperimentalFeature::create(WebKitAdditionsFeature1HumanReadableName, "WebKitAdditionsFeature1Enabled", WebKitAdditionsFeature1HumanReadableDescription, DEFAULT_VALUE_FOR_WebKitAdditionsFeature1Enabled, false),
    });

    return features;
}

bool WebPreferences::isFeatureEnabled(const API::ExperimentalFeature& feature) const
{
    struct FeatureGetterMapping {
        const char* name;
        bool (WebPreferences::*function) () const;
    };

    static FeatureGetterMapping getters[] = {
        { "FocusVisibleEnabled", &WebPreferences::focusVisibleEnabled },
        { "HasPseudoClassEnabled", &WebPreferences::hasPseudoClassEnabled },
        { "PageAtRuleSupportEnabled", &WebPreferences::pageAtRuleSupportEnabled },
        { "AccessHandleEnabled", &WebPreferences::accessHandleEnabled },
        { "AccessibilityObjectModelEnabled", &WebPreferences::accessibilityObjectModelEnabled },
#if ENABLE(MEDIA_STREAM)
        { "PerElementSpeakerSelectionEnabled", &WebPreferences::perElementSpeakerSelectionEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ExposeSpeakersEnabled", &WebPreferences::exposeSpeakersEnabled },
#endif
        { "AspectRatioOfImgFromWidthAndHeightEnabled", &WebPreferences::aspectRatioOfImgFromWidthAndHeightEnabled },
        { "AsyncClipboardAPIEnabled", &WebPreferences::asyncClipboardAPIEnabled },
        { "BlankAnchorTargetImpliesNoOpenerEnabled", &WebPreferences::blankAnchorTargetImpliesNoOpenerEnabled },
        { "ThirdPartyIframeRedirectBlockingEnabled", &WebPreferences::thirdPartyIframeRedirectBlockingEnabled },
        { "BroadcastChannelEnabled", &WebPreferences::broadcastChannelEnabled },
        { "BroadcastChannelOriginPartitioningEnabled", &WebPreferences::broadcastChannelOriginPartitioningEnabled },
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        { "BuiltInNotificationsEnabled", &WebPreferences::builtInNotificationsEnabled },
#endif
        { "CSS3DTransformInteroperabilityEnabled", &WebPreferences::css3DTransformInteroperabilityEnabled },
        { "CSSCounterStyleAtRuleImageSymbolsEnabled", &WebPreferences::cssCounterStyleAtRuleImageSymbolsEnabled },
        { "CSSCounterStyleAtRulesEnabled", &WebPreferences::cssCounterStyleAtRulesEnabled },
        { "AccentColorEnabled", &WebPreferences::accentColorEnabled },
        { "AspectRatioEnabled", &WebPreferences::aspectRatioEnabled },
        { "CSSCascadeLayersEnabled", &WebPreferences::cssCascadeLayersEnabled },
        { "CSSColor4", &WebPreferences::cssColor4 },
        { "CSSContainerQueriesEnabled", &WebPreferences::cssContainerQueriesEnabled },
        { "CSSContainmentEnabled", &WebPreferences::cssContainmentEnabled },
        { "CSSCustomPropertiesAndValuesEnabled", &WebPreferences::cssCustomPropertiesAndValuesEnabled },
        { "CSSGradientInterpolationColorSpacesEnabled", &WebPreferences::cssGradientInterpolationColorSpacesEnabled },
        { "CSSGradientPremultipliedAlphaInterpolationEnabled", &WebPreferences::cssGradientPremultipliedAlphaInterpolationEnabled },
        { "CSSIndividualTransformPropertiesEnabled", &WebPreferences::cssIndividualTransformPropertiesEnabled },
        { "CSSInputSecurityEnabled", &WebPreferences::cssInputSecurityEnabled },
        { "CSSMotionPathEnabled", &WebPreferences::cssMotionPathEnabled },
        { "OverscrollBehaviorEnabled", &WebPreferences::overscrollBehaviorEnabled },
#if ENABLE(CSS_PAINTING_API)
        { "CSSPaintingAPIEnabled", &WebPreferences::cssPaintingAPIEnabled },
#endif
        { "CSSRelativeColorSyntaxEnabled", &WebPreferences::cssRelativeColorSyntaxEnabled },
        { "SpringTimingFunctionEnabled", &WebPreferences::springTimingFunctionEnabled },
#if ENABLE(CSS_TYPED_OM)
        { "CSSTypedOMEnabled", &WebPreferences::cssTypedOMEnabled },
#endif
        { "CSSColorContrastEnabled", &WebPreferences::cssColorContrastEnabled },
        { "CSSColorMixEnabled", &WebPreferences::cssColorMixEnabled },
        { "OverflowClipEnabled", &WebPreferences::overflowClipEnabled },
        { "SubgridEnabled", &WebPreferences::subgridEnabled },
        { "CSSOMViewSmoothScrollingEnabled", &WebPreferences::cssOMViewSmoothScrollingEnabled },
        { "CanvasColorSpaceEnabled", &WebPreferences::canvasColorSpaceEnabled },
        { "ContactPickerAPIEnabled", &WebPreferences::contactPickerAPIEnabled },
        { "CrossOriginEmbedderPolicyEnabled", &WebPreferences::crossOriginEmbedderPolicyEnabled },
        { "CrossOriginOpenerPolicyEnabled", &WebPreferences::crossOriginOpenerPolicyEnabled },
        { "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint", &WebPreferences::shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint },
        { "DialogElementEnabled", &WebPreferences::dialogElementEnabled },
        { "IsThirdPartyCookieBlockingDisabled", &WebPreferences::isThirdPartyCookieBlockingDisabled },
#if HAVE(CELESTIAL)
        { "DisableMediaExperiencePIDInheritance", &WebPreferences::disableMediaExperiencePIDInheritance },
#endif
        { "IsFirstPartyWebsiteDataRemovalDisabled", &WebPreferences::isFirstPartyWebsiteDataRemovalDisabled },
        { "DisallowSyncXHRDuringPageDismissalEnabled", &WebPreferences::disallowSyncXHRDuringPageDismissalEnabled },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "MediaSessionCoordinatorEnabled", &WebPreferences::mediaSessionCoordinatorEnabled },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        { "MediaSessionPlaylistEnabled", &WebPreferences::mediaSessionPlaylistEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        { "MediaSourceInlinePaintingEnabled", &WebPreferences::mediaSourceInlinePaintingEnabled },
#endif
#if HAVE(NETWORK_LOADER)
        { "CFNetworkNetworkLoaderEnabled", &WebPreferences::cFNetworkNetworkLoaderEnabled },
#endif
        { "FTPEnabled", &WebPreferences::ftpEnabled },
        { "FetchAPIKeepAliveEnabled", &WebPreferences::fetchAPIKeepAliveEnabled },
        { "FileSystemAccessEnabled", &WebPreferences::fileSystemAccessEnabled },
        { "RequestSubmitEnabled", &WebPreferences::requestSubmitEnabled },
#if ENABLE(GPU_PROCESS)
        { "UseGPUProcessForDOMRenderingEnabled", &WebPreferences::useGPUProcessForDOMRenderingEnabled },
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        { "UseGPUProcessForDisplayCapture", &WebPreferences::useGPUProcessForDisplayCapture },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForWebGLEnabled", &WebPreferences::useGPUProcessForWebGLEnabled },
#endif
#if ENABLE(VIDEO)
        { "GenericCueAPIEnabled", &WebPreferences::genericCueAPIEnabled },
#endif
        { "HDRMediaCapabilitiesEnabled", &WebPreferences::hDRMediaCapabilitiesEnabled },
#if ENABLE(MODEL_ELEMENT)
        { "ModelElementEnabled", &WebPreferences::modelElementEnabled },
#endif
#if ENABLE(MODEL_ELEMENT)
        { "ModelDocumentEnabled", &WebPreferences::modelDocumentEnabled },
#endif
#if HAVE(CFNETWORK_ALTERNATIVE_SERVICE)
        { "HTTP3Enabled", &WebPreferences::http3Enabled },
#endif
        { "HighlightAPIEnabled", &WebPreferences::highlightAPIEnabled },
        { "ImageBitmapEnabled", &WebPreferences::imageBitmapEnabled },
        { "InProcessCookieCacheEnabled", &WebPreferences::inProcessCookieCacheEnabled },
#if HAVE(INCREMENTAL_PDF_APIS)
        { "IncrementalPDFLoadingEnabled", &WebPreferences::incrementalPDFLoadingEnabled },
#endif
        { "IntersectionObserverEnabled", &WebPreferences::intersectionObserverEnabled },
        { "IsLoggedInAPIEnabled", &WebPreferences::isLoggedInAPIEnabled },
        { "LazyIframeLoadingEnabled", &WebPreferences::lazyIframeLoadingEnabled },
        { "LazyImageLoadingEnabled", &WebPreferences::lazyImageLoadingEnabled },
        { "LinkSanitizerEnabled", &WebPreferences::linkSanitizerEnabled },
        { "LinkPreloadResponsiveImagesEnabled", &WebPreferences::linkPreloadResponsiveImagesEnabled },
        { "LinkPrefetchEnabled", &WebPreferences::linkPrefetchEnabled },
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        { "MaskWebGLStringsEnabled", &WebPreferences::maskWebGLStringsEnabled },
#endif
        { "CoreMathMLEnabled", &WebPreferences::coreMathMLEnabled },
        { "MediaCapabilitiesExtensionsEnabled", &WebPreferences::mediaCapabilitiesExtensionsEnabled },
#if ENABLE(MEDIA_SESSION)
        { "MediaSessionEnabled", &WebPreferences::mediaSessionEnabled },
#endif
#if ENABLE(MEDIA_RECORDER)
        { "MediaRecorderEnabled", &WebPreferences::mediaRecorderEnabled },
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
        { "IsNSURLSessionWebSocketEnabled", &WebPreferences::isNSURLSessionWebSocketEnabled },
#endif
#if ENABLE(OPUS)
        { "OpusDecoderEnabled", &WebPreferences::opusDecoderEnabled },
#endif
        { "PaintTimingEnabled", &WebPreferences::paintTimingEnabled },
        { "PerformanceNavigationTimingAPIEnabled", &WebPreferences::performanceNavigationTimingAPIEnabled },
        { "PerformanceResourceTimingSensitivePropertiesEnabled", &WebPreferences::performanceResourceTimingSensitivePropertiesEnabled },
        { "PermissionsAPIEnabled", &WebPreferences::permissionsAPIEnabled },
        { "PreferPageRenderingUpdatesNear60FPSEnabled", &WebPreferences::preferPageRenderingUpdatesNear60FPSEnabled },
        { "PrivateClickMeasurementDebugModeEnabled", &WebPreferences::privateClickMeasurementDebugModeEnabled },
        { "PrivateClickMeasurementFraudPreventionEnabled", &WebPreferences::privateClickMeasurementFraudPreventionEnabled },
#if ENABLE(SERVICE_WORKER)
        { "PushAPIEnabled", &WebPreferences::pushAPIEnabled },
#endif
        { "GoogleAntiFlickerOptimizationQuirkEnabled", &WebPreferences::googleAntiFlickerOptimizationQuirkEnabled },
        { "ReadableByteStreamAPIEnabled", &WebPreferences::readableByteStreamAPIEnabled },
        { "ReferrerPolicyAttributeEnabled", &WebPreferences::referrerPolicyAttributeEnabled },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "RemotePlaybackEnabled", &WebPreferences::remotePlaybackEnabled },
#endif
        { "RequestVideoFrameCallbackEnabled", &WebPreferences::requestVideoFrameCallbackEnabled },
        { "ResizeObserverEnabled", &WebPreferences::resizeObserverEnabled },
        { "ResolutionMediaFeatureEnabled", &WebPreferences::resolutionMediaFeatureEnabled },
        { "IsSameSiteStrictEnforcementEnabled", &WebPreferences::isSameSiteStrictEnforcementEnabled },
#if ENABLE(MEDIA_STREAM)
        { "ScreenCaptureEnabled", &WebPreferences::screenCaptureEnabled },
#endif
        { "ScrollToTextFragmentEnabled", &WebPreferences::scrollToTextFragmentEnabled },
        { "ServerTimingEnabled", &WebPreferences::serverTimingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkerNavigationPreloadEnabled", &WebPreferences::serviceWorkerNavigationPreloadEnabled },
#endif
        { "SharedWorkerEnabled", &WebPreferences::sharedWorkerEnabled },
        { "SpeechRecognitionEnabled", &WebPreferences::speechRecognitionEnabled },
        { "StorageAPIEnabled", &WebPreferences::storageAPIEnabled },
        { "ProcessSwapOnCrossSiteNavigationEnabled", &WebPreferences::processSwapOnCrossSiteNavigationEnabled },
        { "SyntheticEditingCommandsEnabled", &WebPreferences::syntheticEditingCommandsEnabled },
        { "TrackConfigurationEnabled", &WebPreferences::trackConfigurationEnabled },
        { "TransformStreamAPIEnabled", &WebPreferences::transformStreamAPIEnabled },
#if HAVE(SCREEN_CAPTURE_KIT)
        { "UseScreenCaptureKit", &WebPreferences::useScreenCaptureKit },
#endif
        { "UserGesturePromisePropagationEnabled", &WebPreferences::userGesturePromisePropagationEnabled },
#if ENABLE(VP9)
        { "VP8DecoderEnabled", &WebPreferences::vp8DecoderEnabled },
#endif
#if ENABLE(VP9)
        { "VP9SWDecoderEnabledOnBattery", &WebPreferences::vp9SWDecoderEnabledOnBattery },
#endif
#if ENABLE(VP9)
        { "VP9DecoderEnabled", &WebPreferences::vp9DecoderEnabled },
#endif
        { "VisualViewportAPIEnabled", &WebPreferences::visualViewportAPIEnabled },
#if ENABLE(VORBIS)
        { "VorbisDecoderEnabled", &WebPreferences::vorbisDecoderEnabled },
#endif
        { "WebAnimationsCompositeOperationsEnabled", &WebPreferences::webAnimationsCompositeOperationsEnabled },
        { "WebAnimationsCustomEffectsEnabled", &WebPreferences::webAnimationsCustomEffectsEnabled },
        { "WebAnimationsCustomFrameRateEnabled", &WebPreferences::webAnimationsCustomFrameRateEnabled },
        { "WebAnimationsMutableTimelinesEnabled", &WebPreferences::webAnimationsMutableTimelinesEnabled },
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationModernEnabled", &WebPreferences::webAuthenticationModernEnabled },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationEnabled", &WebPreferences::webAuthenticationEnabled },
#endif
        { "WebLocksAPIEnabled", &WebPreferences::webLocksAPIEnabled },
        { "WebShareFileAPIEnabled", &WebPreferences::webShareFileAPIEnabled },
#if ENABLE(WEBGL2)
        { "WebGL2Enabled", &WebPreferences::webGL2Enabled },
#endif
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        { "WebGLUsingMetal", &WebPreferences::webGLUsingMetal },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebMParserEnabled", &WebPreferences::webMParserEnabled },
#endif
#if ENABLE(WEBM_FORMAT_READER)
        { "WebMFormatReaderEnabled", &WebPreferences::webMFormatReaderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCEncodedTransformEnabled", &WebPreferences::webRTCEncodedTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264LowLatencyEncoderEnabled", &WebPreferences::webRTCH264LowLatencyEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH265CodecEnabled", &WebPreferences::webRTCH265CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformTCPSocketsEnabled", &WebPreferences::webRTCPlatformTCPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformUDPSocketsEnabled", &WebPreferences::webRTCPlatformUDPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSFrameTransformEnabled", &WebPreferences::webRTCSFrameTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSocketsProxyingEnabled", &WebPreferences::webRTCSocketsProxyingEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile0CodecEnabled", &WebPreferences::webRTCVP9Profile0CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile2CodecEnabled", &WebPreferences::webRTCVP9Profile2CodecEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRAugmentedRealityModuleEnabled", &WebPreferences::webXRAugmentedRealityModuleEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXREnabled", &WebPreferences::webXREnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRGamepadsModuleEnabled", &WebPreferences::webXRGamepadsModuleEnabled },
#endif
#if ENABLE(WEBXR_HANDS)
        { "WebXRHandInputModuleEnabled", &WebPreferences::webXRHandInputModuleEnabled },
#endif
        { "WheelEventGesturesBecomeNonBlocking", &WebPreferences::wheelEventGesturesBecomeNonBlocking },
        { "PassiveWheelListenersAsDefaultOnDocument", &WebPreferences::passiveWheelListenersAsDefaultOnDocument },
        { "InertAttributeEnabled", &WebPreferences::inertAttributeEnabled },
        { "RequestIdleCallbackEnabled", &WebPreferences::requestIdleCallbackEnabled },
        { "WebKitAdditionsFeature1Enabled", &WebPreferences::webKitAdditionsFeature1Enabled },
    };

    const String& key = feature.key();

    for (auto& getter : getters) {
        if (key == getter.name)
            return (this->*getter.function)();
    }

    return false;
}

void WebPreferences::setFeatureEnabled(const API::ExperimentalFeature& feature, bool value)
{
    setExperimentalFeatureEnabledForKey(feature.key(), value);
}

void WebPreferences::setExperimentalFeatureEnabledForKey(const String& key, bool value)
{
    struct FeatureSetterMapping {
        const char* name;
        void (WebPreferences::*function) (const bool&);
    };

    static FeatureSetterMapping setters[] = {
        { "FocusVisibleEnabled", &WebPreferences::setFocusVisibleEnabled },
        { "HasPseudoClassEnabled", &WebPreferences::setHasPseudoClassEnabled },
        { "PageAtRuleSupportEnabled", &WebPreferences::setPageAtRuleSupportEnabled },
        { "AccessHandleEnabled", &WebPreferences::setAccessHandleEnabled },
        { "AccessibilityObjectModelEnabled", &WebPreferences::setAccessibilityObjectModelEnabled },
#if ENABLE(MEDIA_STREAM)
        { "PerElementSpeakerSelectionEnabled", &WebPreferences::setPerElementSpeakerSelectionEnabled },
#endif
#if ENABLE(MEDIA_STREAM)
        { "ExposeSpeakersEnabled", &WebPreferences::setExposeSpeakersEnabled },
#endif
        { "AspectRatioOfImgFromWidthAndHeightEnabled", &WebPreferences::setAspectRatioOfImgFromWidthAndHeightEnabled },
        { "AsyncClipboardAPIEnabled", &WebPreferences::setAsyncClipboardAPIEnabled },
        { "BlankAnchorTargetImpliesNoOpenerEnabled", &WebPreferences::setBlankAnchorTargetImpliesNoOpenerEnabled },
        { "ThirdPartyIframeRedirectBlockingEnabled", &WebPreferences::setThirdPartyIframeRedirectBlockingEnabled },
        { "BroadcastChannelEnabled", &WebPreferences::setBroadcastChannelEnabled },
        { "BroadcastChannelOriginPartitioningEnabled", &WebPreferences::setBroadcastChannelOriginPartitioningEnabled },
#if ENABLE(BUILT_IN_NOTIFICATIONS)
        { "BuiltInNotificationsEnabled", &WebPreferences::setBuiltInNotificationsEnabled },
#endif
        { "CSS3DTransformInteroperabilityEnabled", &WebPreferences::setCSS3DTransformInteroperabilityEnabled },
        { "CSSCounterStyleAtRuleImageSymbolsEnabled", &WebPreferences::setCSSCounterStyleAtRuleImageSymbolsEnabled },
        { "CSSCounterStyleAtRulesEnabled", &WebPreferences::setCSSCounterStyleAtRulesEnabled },
        { "AccentColorEnabled", &WebPreferences::setAccentColorEnabled },
        { "AspectRatioEnabled", &WebPreferences::setAspectRatioEnabled },
        { "CSSCascadeLayersEnabled", &WebPreferences::setCSSCascadeLayersEnabled },
        { "CSSColor4", &WebPreferences::setCSSColor4 },
        { "CSSContainerQueriesEnabled", &WebPreferences::setCSSContainerQueriesEnabled },
        { "CSSContainmentEnabled", &WebPreferences::setCSSContainmentEnabled },
        { "CSSCustomPropertiesAndValuesEnabled", &WebPreferences::setCSSCustomPropertiesAndValuesEnabled },
        { "CSSGradientInterpolationColorSpacesEnabled", &WebPreferences::setCSSGradientInterpolationColorSpacesEnabled },
        { "CSSGradientPremultipliedAlphaInterpolationEnabled", &WebPreferences::setCSSGradientPremultipliedAlphaInterpolationEnabled },
        { "CSSIndividualTransformPropertiesEnabled", &WebPreferences::setCSSIndividualTransformPropertiesEnabled },
        { "CSSInputSecurityEnabled", &WebPreferences::setCSSInputSecurityEnabled },
        { "CSSMotionPathEnabled", &WebPreferences::setCSSMotionPathEnabled },
        { "OverscrollBehaviorEnabled", &WebPreferences::setOverscrollBehaviorEnabled },
#if ENABLE(CSS_PAINTING_API)
        { "CSSPaintingAPIEnabled", &WebPreferences::setCSSPaintingAPIEnabled },
#endif
        { "CSSRelativeColorSyntaxEnabled", &WebPreferences::setCSSRelativeColorSyntaxEnabled },
        { "SpringTimingFunctionEnabled", &WebPreferences::setSpringTimingFunctionEnabled },
#if ENABLE(CSS_TYPED_OM)
        { "CSSTypedOMEnabled", &WebPreferences::setCSSTypedOMEnabled },
#endif
        { "CSSColorContrastEnabled", &WebPreferences::setCSSColorContrastEnabled },
        { "CSSColorMixEnabled", &WebPreferences::setCSSColorMixEnabled },
        { "OverflowClipEnabled", &WebPreferences::setOverflowClipEnabled },
        { "SubgridEnabled", &WebPreferences::setSubgridEnabled },
        { "CSSOMViewSmoothScrollingEnabled", &WebPreferences::setCSSOMViewSmoothScrollingEnabled },
        { "CanvasColorSpaceEnabled", &WebPreferences::setCanvasColorSpaceEnabled },
        { "ContactPickerAPIEnabled", &WebPreferences::setContactPickerAPIEnabled },
        { "CrossOriginEmbedderPolicyEnabled", &WebPreferences::setCrossOriginEmbedderPolicyEnabled },
        { "CrossOriginOpenerPolicyEnabled", &WebPreferences::setCrossOriginOpenerPolicyEnabled },
        { "ShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint", &WebPreferences::setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint },
        { "DialogElementEnabled", &WebPreferences::setDialogElementEnabled },
        { "IsThirdPartyCookieBlockingDisabled", &WebPreferences::setIsThirdPartyCookieBlockingDisabled },
#if HAVE(CELESTIAL)
        { "DisableMediaExperiencePIDInheritance", &WebPreferences::setDisableMediaExperiencePIDInheritance },
#endif
        { "IsFirstPartyWebsiteDataRemovalDisabled", &WebPreferences::setIsFirstPartyWebsiteDataRemovalDisabled },
        { "DisallowSyncXHRDuringPageDismissalEnabled", &WebPreferences::setDisallowSyncXHRDuringPageDismissalEnabled },
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        { "MediaSessionCoordinatorEnabled", &WebPreferences::setMediaSessionCoordinatorEnabled },
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
        { "MediaSessionPlaylistEnabled", &WebPreferences::setMediaSessionPlaylistEnabled },
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
        { "MediaSourceInlinePaintingEnabled", &WebPreferences::setMediaSourceInlinePaintingEnabled },
#endif
#if HAVE(NETWORK_LOADER)
        { "CFNetworkNetworkLoaderEnabled", &WebPreferences::setCFNetworkNetworkLoaderEnabled },
#endif
        { "FTPEnabled", &WebPreferences::setFTPEnabled },
        { "FetchAPIKeepAliveEnabled", &WebPreferences::setFetchAPIKeepAliveEnabled },
        { "FileSystemAccessEnabled", &WebPreferences::setFileSystemAccessEnabled },
        { "RequestSubmitEnabled", &WebPreferences::setRequestSubmitEnabled },
#if ENABLE(GPU_PROCESS)
        { "UseGPUProcessForDOMRenderingEnabled", &WebPreferences::setUseGPUProcessForDOMRenderingEnabled },
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
        { "UseGPUProcessForDisplayCapture", &WebPreferences::setUseGPUProcessForDisplayCapture },
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL) && !(PLATFORM(GTK) || PLATFORM(WPE))
        { "UseGPUProcessForWebGLEnabled", &WebPreferences::setUseGPUProcessForWebGLEnabled },
#endif
#if ENABLE(VIDEO)
        { "GenericCueAPIEnabled", &WebPreferences::setGenericCueAPIEnabled },
#endif
        { "HDRMediaCapabilitiesEnabled", &WebPreferences::setHDRMediaCapabilitiesEnabled },
#if ENABLE(MODEL_ELEMENT)
        { "ModelElementEnabled", &WebPreferences::setModelElementEnabled },
#endif
#if ENABLE(MODEL_ELEMENT)
        { "ModelDocumentEnabled", &WebPreferences::setModelDocumentEnabled },
#endif
#if HAVE(CFNETWORK_ALTERNATIVE_SERVICE)
        { "HTTP3Enabled", &WebPreferences::setHTTP3Enabled },
#endif
        { "HighlightAPIEnabled", &WebPreferences::setHighlightAPIEnabled },
        { "ImageBitmapEnabled", &WebPreferences::setImageBitmapEnabled },
        { "InProcessCookieCacheEnabled", &WebPreferences::setInProcessCookieCacheEnabled },
#if HAVE(INCREMENTAL_PDF_APIS)
        { "IncrementalPDFLoadingEnabled", &WebPreferences::setIncrementalPDFLoadingEnabled },
#endif
        { "IntersectionObserverEnabled", &WebPreferences::setIntersectionObserverEnabled },
        { "IsLoggedInAPIEnabled", &WebPreferences::setIsLoggedInAPIEnabled },
        { "LazyIframeLoadingEnabled", &WebPreferences::setLazyIframeLoadingEnabled },
        { "LazyImageLoadingEnabled", &WebPreferences::setLazyImageLoadingEnabled },
        { "LinkSanitizerEnabled", &WebPreferences::setLinkSanitizerEnabled },
        { "LinkPreloadResponsiveImagesEnabled", &WebPreferences::setLinkPreloadResponsiveImagesEnabled },
        { "LinkPrefetchEnabled", &WebPreferences::setLinkPrefetchEnabled },
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
        { "MaskWebGLStringsEnabled", &WebPreferences::setMaskWebGLStringsEnabled },
#endif
        { "CoreMathMLEnabled", &WebPreferences::setCoreMathMLEnabled },
        { "MediaCapabilitiesExtensionsEnabled", &WebPreferences::setMediaCapabilitiesExtensionsEnabled },
#if ENABLE(MEDIA_SESSION)
        { "MediaSessionEnabled", &WebPreferences::setMediaSessionEnabled },
#endif
#if ENABLE(MEDIA_RECORDER)
        { "MediaRecorderEnabled", &WebPreferences::setMediaRecorderEnabled },
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
        { "IsNSURLSessionWebSocketEnabled", &WebPreferences::setIsNSURLSessionWebSocketEnabled },
#endif
#if ENABLE(OPUS)
        { "OpusDecoderEnabled", &WebPreferences::setOpusDecoderEnabled },
#endif
        { "PaintTimingEnabled", &WebPreferences::setPaintTimingEnabled },
        { "PerformanceNavigationTimingAPIEnabled", &WebPreferences::setPerformanceNavigationTimingAPIEnabled },
        { "PerformanceResourceTimingSensitivePropertiesEnabled", &WebPreferences::setPerformanceResourceTimingSensitivePropertiesEnabled },
        { "PermissionsAPIEnabled", &WebPreferences::setPermissionsAPIEnabled },
        { "PreferPageRenderingUpdatesNear60FPSEnabled", &WebPreferences::setPreferPageRenderingUpdatesNear60FPSEnabled },
        { "PrivateClickMeasurementDebugModeEnabled", &WebPreferences::setPrivateClickMeasurementDebugModeEnabled },
        { "PrivateClickMeasurementFraudPreventionEnabled", &WebPreferences::setPrivateClickMeasurementFraudPreventionEnabled },
#if ENABLE(SERVICE_WORKER)
        { "PushAPIEnabled", &WebPreferences::setPushAPIEnabled },
#endif
        { "GoogleAntiFlickerOptimizationQuirkEnabled", &WebPreferences::setGoogleAntiFlickerOptimizationQuirkEnabled },
        { "ReadableByteStreamAPIEnabled", &WebPreferences::setReadableByteStreamAPIEnabled },
        { "ReferrerPolicyAttributeEnabled", &WebPreferences::setReferrerPolicyAttributeEnabled },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        { "RemotePlaybackEnabled", &WebPreferences::setRemotePlaybackEnabled },
#endif
        { "RequestVideoFrameCallbackEnabled", &WebPreferences::setRequestVideoFrameCallbackEnabled },
        { "ResizeObserverEnabled", &WebPreferences::setResizeObserverEnabled },
        { "ResolutionMediaFeatureEnabled", &WebPreferences::setResolutionMediaFeatureEnabled },
        { "IsSameSiteStrictEnforcementEnabled", &WebPreferences::setIsSameSiteStrictEnforcementEnabled },
#if ENABLE(MEDIA_STREAM)
        { "ScreenCaptureEnabled", &WebPreferences::setScreenCaptureEnabled },
#endif
        { "ScrollToTextFragmentEnabled", &WebPreferences::setScrollToTextFragmentEnabled },
        { "ServerTimingEnabled", &WebPreferences::setServerTimingEnabled },
#if ENABLE(SERVICE_WORKER)
        { "ServiceWorkerNavigationPreloadEnabled", &WebPreferences::setServiceWorkerNavigationPreloadEnabled },
#endif
        { "SharedWorkerEnabled", &WebPreferences::setSharedWorkerEnabled },
        { "SpeechRecognitionEnabled", &WebPreferences::setSpeechRecognitionEnabled },
        { "StorageAPIEnabled", &WebPreferences::setStorageAPIEnabled },
        { "ProcessSwapOnCrossSiteNavigationEnabled", &WebPreferences::setProcessSwapOnCrossSiteNavigationEnabled },
        { "SyntheticEditingCommandsEnabled", &WebPreferences::setSyntheticEditingCommandsEnabled },
        { "TrackConfigurationEnabled", &WebPreferences::setTrackConfigurationEnabled },
        { "TransformStreamAPIEnabled", &WebPreferences::setTransformStreamAPIEnabled },
#if HAVE(SCREEN_CAPTURE_KIT)
        { "UseScreenCaptureKit", &WebPreferences::setUseScreenCaptureKit },
#endif
        { "UserGesturePromisePropagationEnabled", &WebPreferences::setUserGesturePromisePropagationEnabled },
#if ENABLE(VP9)
        { "VP8DecoderEnabled", &WebPreferences::setVP8DecoderEnabled },
#endif
#if ENABLE(VP9)
        { "VP9SWDecoderEnabledOnBattery", &WebPreferences::setVP9SWDecoderEnabledOnBattery },
#endif
#if ENABLE(VP9)
        { "VP9DecoderEnabled", &WebPreferences::setVP9DecoderEnabled },
#endif
        { "VisualViewportAPIEnabled", &WebPreferences::setVisualViewportAPIEnabled },
#if ENABLE(VORBIS)
        { "VorbisDecoderEnabled", &WebPreferences::setVorbisDecoderEnabled },
#endif
        { "WebAnimationsCompositeOperationsEnabled", &WebPreferences::setWebAnimationsCompositeOperationsEnabled },
        { "WebAnimationsCustomEffectsEnabled", &WebPreferences::setWebAnimationsCustomEffectsEnabled },
        { "WebAnimationsCustomFrameRateEnabled", &WebPreferences::setWebAnimationsCustomFrameRateEnabled },
        { "WebAnimationsMutableTimelinesEnabled", &WebPreferences::setWebAnimationsMutableTimelinesEnabled },
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationModernEnabled", &WebPreferences::setWebAuthenticationModernEnabled },
#endif
#if ENABLE(WEB_AUTHN)
        { "WebAuthenticationEnabled", &WebPreferences::setWebAuthenticationEnabled },
#endif
        { "WebLocksAPIEnabled", &WebPreferences::setWebLocksAPIEnabled },
        { "WebShareFileAPIEnabled", &WebPreferences::setWebShareFileAPIEnabled },
#if ENABLE(WEBGL2)
        { "WebGL2Enabled", &WebPreferences::setWebGL2Enabled },
#endif
#if ENABLE(WEBGL) && PLATFORM(COCOA)
        { "WebGLUsingMetal", &WebPreferences::setWebGLUsingMetal },
#endif
#if ENABLE(MEDIA_SOURCE)
        { "WebMParserEnabled", &WebPreferences::setWebMParserEnabled },
#endif
#if ENABLE(WEBM_FORMAT_READER)
        { "WebMFormatReaderEnabled", &WebPreferences::setWebMFormatReaderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCEncodedTransformEnabled", &WebPreferences::setWebRTCEncodedTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH264LowLatencyEncoderEnabled", &WebPreferences::setWebRTCH264LowLatencyEncoderEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCH265CodecEnabled", &WebPreferences::setWebRTCH265CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformTCPSocketsEnabled", &WebPreferences::setWebRTCPlatformTCPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCPlatformUDPSocketsEnabled", &WebPreferences::setWebRTCPlatformUDPSocketsEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSFrameTransformEnabled", &WebPreferences::setWebRTCSFrameTransformEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCSocketsProxyingEnabled", &WebPreferences::setWebRTCSocketsProxyingEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile0CodecEnabled", &WebPreferences::setWebRTCVP9Profile0CodecEnabled },
#endif
#if ENABLE(WEB_RTC)
        { "WebRTCVP9Profile2CodecEnabled", &WebPreferences::setWebRTCVP9Profile2CodecEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRAugmentedRealityModuleEnabled", &WebPreferences::setWebXRAugmentedRealityModuleEnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXREnabled", &WebPreferences::setWebXREnabled },
#endif
#if ENABLE(WEBXR)
        { "WebXRGamepadsModuleEnabled", &WebPreferences::setWebXRGamepadsModuleEnabled },
#endif
#if ENABLE(WEBXR_HANDS)
        { "WebXRHandInputModuleEnabled", &WebPreferences::setWebXRHandInputModuleEnabled },
#endif
        { "WheelEventGesturesBecomeNonBlocking", &WebPreferences::setWheelEventGesturesBecomeNonBlocking },
        { "PassiveWheelListenersAsDefaultOnDocument", &WebPreferences::setPassiveWheelListenersAsDefaultOnDocument },
        { "InertAttributeEnabled", &WebPreferences::setInertAttributeEnabled },
        { "RequestIdleCallbackEnabled", &WebPreferences::setRequestIdleCallbackEnabled },
        { "WebKitAdditionsFeature1Enabled", &WebPreferences::setWebKitAdditionsFeature1Enabled },
    };

    for (auto& setter : setters) {
        if (key == setter.name) {
            (this->*setter.function)(value);
            return;
        }
    }
}

void WebPreferences::enableAllExperimentalFeatures()
{
    UpdateBatch batch(*this);
    setFocusVisibleEnabled(true);
    setHasPseudoClassEnabled(true);
    setPageAtRuleSupportEnabled(true);
    setAccessHandleEnabled(true);
    setAccessibilityObjectModelEnabled(true);
#if ENABLE(MEDIA_STREAM)
    setPerElementSpeakerSelectionEnabled(true);
#endif
#if ENABLE(MEDIA_STREAM)
    setExposeSpeakersEnabled(true);
#endif
    setAspectRatioOfImgFromWidthAndHeightEnabled(true);
    setAsyncClipboardAPIEnabled(true);
    setBlankAnchorTargetImpliesNoOpenerEnabled(true);
    setThirdPartyIframeRedirectBlockingEnabled(true);
    setBroadcastChannelEnabled(true);
    setBroadcastChannelOriginPartitioningEnabled(true);
#if ENABLE(BUILT_IN_NOTIFICATIONS)
    setBuiltInNotificationsEnabled(true);
#endif
    setCSS3DTransformInteroperabilityEnabled(true);
    setCSSCounterStyleAtRuleImageSymbolsEnabled(true);
    setCSSCounterStyleAtRulesEnabled(true);
    setAccentColorEnabled(true);
    setAspectRatioEnabled(true);
    setCSSCascadeLayersEnabled(true);
    setCSSColor4(true);
    setCSSContainerQueriesEnabled(true);
    setCSSContainmentEnabled(true);
    setCSSCustomPropertiesAndValuesEnabled(true);
    setCSSGradientInterpolationColorSpacesEnabled(true);
    setCSSGradientPremultipliedAlphaInterpolationEnabled(true);
    setCSSIndividualTransformPropertiesEnabled(true);
    setCSSInputSecurityEnabled(true);
    setCSSMotionPathEnabled(true);
    setOverscrollBehaviorEnabled(true);
#if ENABLE(CSS_PAINTING_API)
    setCSSPaintingAPIEnabled(true);
#endif
    setCSSRelativeColorSyntaxEnabled(true);
    setSpringTimingFunctionEnabled(true);
#if ENABLE(CSS_TYPED_OM)
    setCSSTypedOMEnabled(true);
#endif
    setCSSColorContrastEnabled(true);
    setCSSColorMixEnabled(true);
    setOverflowClipEnabled(true);
    setSubgridEnabled(true);
    setCSSOMViewSmoothScrollingEnabled(true);
    setCanvasColorSpaceEnabled(true);
    setContactPickerAPIEnabled(true);
    setCrossOriginEmbedderPolicyEnabled(true);
    setCrossOriginOpenerPolicyEnabled(true);
    setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint(true);
    setDialogElementEnabled(true);
    setIsThirdPartyCookieBlockingDisabled(true);
#if HAVE(CELESTIAL)
    setDisableMediaExperiencePIDInheritance(true);
#endif
    setIsFirstPartyWebsiteDataRemovalDisabled(true);
    setDisallowSyncXHRDuringPageDismissalEnabled(true);
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    setMediaSessionCoordinatorEnabled(true);
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR) && ENABLE(MEDIA_SESSION_PLAYLIST)
    setMediaSessionPlaylistEnabled(true);
#endif
#if ENABLE(MEDIA_SOURCE) && (HAVE(AVSAMPLEBUFFERVIDEOOUTPUT) || USE(GSTREAMER))
    setMediaSourceInlinePaintingEnabled(true);
#endif
#if HAVE(NETWORK_LOADER)
    setCFNetworkNetworkLoaderEnabled(true);
#endif
    setFTPEnabled(true);
    setFetchAPIKeepAliveEnabled(true);
    setFileSystemAccessEnabled(true);
    setRequestSubmitEnabled(true);
#if ENABLE(GPU_PROCESS)
    setUseGPUProcessForDOMRenderingEnabled(true);
#endif
#if HAVE(SC_CONTENT_SHARING_SESSION)
    setUseGPUProcessForDisplayCapture(true);
#endif
#if ENABLE(GPU_PROCESS) && ENABLE(WEBGL) && !(PLATFORM(GTK) || PLATFORM(WPE))
    setUseGPUProcessForWebGLEnabled(true);
#endif
#if ENABLE(VIDEO)
    setGenericCueAPIEnabled(true);
#endif
    setHDRMediaCapabilitiesEnabled(true);
#if ENABLE(MODEL_ELEMENT)
    setModelElementEnabled(true);
#endif
#if ENABLE(MODEL_ELEMENT)
    setModelDocumentEnabled(true);
#endif
#if HAVE(CFNETWORK_ALTERNATIVE_SERVICE)
    setHTTP3Enabled(true);
#endif
    setHighlightAPIEnabled(true);
    setImageBitmapEnabled(true);
    setInProcessCookieCacheEnabled(true);
#if HAVE(INCREMENTAL_PDF_APIS)
    setIncrementalPDFLoadingEnabled(true);
#endif
    setIntersectionObserverEnabled(true);
    setIsLoggedInAPIEnabled(true);
    setLazyIframeLoadingEnabled(true);
    setLazyImageLoadingEnabled(true);
    setLinkSanitizerEnabled(true);
    setLinkPreloadResponsiveImagesEnabled(true);
    setLinkPrefetchEnabled(true);
#if ENABLE(WEBGL) || ENABLE(WEBGL2)
    setMaskWebGLStringsEnabled(true);
#endif
    setCoreMathMLEnabled(true);
    setMediaCapabilitiesExtensionsEnabled(true);
#if ENABLE(MEDIA_SESSION)
    setMediaSessionEnabled(true);
#endif
#if ENABLE(MEDIA_RECORDER)
    setMediaRecorderEnabled(true);
#endif
#if HAVE(NSURLSESSION_WEBSOCKET)
    setIsNSURLSessionWebSocketEnabled(true);
#endif
#if ENABLE(OPUS)
    setOpusDecoderEnabled(true);
#endif
    setPaintTimingEnabled(true);
    setPerformanceNavigationTimingAPIEnabled(true);
    setPerformanceResourceTimingSensitivePropertiesEnabled(true);
    setPermissionsAPIEnabled(true);
    setPreferPageRenderingUpdatesNear60FPSEnabled(true);
    setPrivateClickMeasurementDebugModeEnabled(true);
    setPrivateClickMeasurementFraudPreventionEnabled(true);
#if ENABLE(SERVICE_WORKER)
    setPushAPIEnabled(true);
#endif
    setGoogleAntiFlickerOptimizationQuirkEnabled(true);
    setReadableByteStreamAPIEnabled(true);
    setReferrerPolicyAttributeEnabled(true);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    setRemotePlaybackEnabled(true);
#endif
    setRequestVideoFrameCallbackEnabled(true);
    setResizeObserverEnabled(true);
    setResolutionMediaFeatureEnabled(true);
    setIsSameSiteStrictEnforcementEnabled(true);
#if ENABLE(MEDIA_STREAM)
    setScreenCaptureEnabled(true);
#endif
    setScrollToTextFragmentEnabled(true);
    setServerTimingEnabled(true);
#if ENABLE(SERVICE_WORKER)
    setServiceWorkerNavigationPreloadEnabled(true);
#endif
    setSharedWorkerEnabled(true);
    setSpeechRecognitionEnabled(true);
    setStorageAPIEnabled(true);
    setProcessSwapOnCrossSiteNavigationEnabled(true);
    setSyntheticEditingCommandsEnabled(true);
    setTrackConfigurationEnabled(true);
    setTransformStreamAPIEnabled(true);
#if HAVE(SCREEN_CAPTURE_KIT)
    setUseScreenCaptureKit(true);
#endif
    setUserGesturePromisePropagationEnabled(true);
#if ENABLE(VP9)
    setVP8DecoderEnabled(true);
#endif
#if ENABLE(VP9)
    setVP9SWDecoderEnabledOnBattery(true);
#endif
#if ENABLE(VP9)
    setVP9DecoderEnabled(true);
#endif
    setVisualViewportAPIEnabled(true);
#if ENABLE(VORBIS)
    setVorbisDecoderEnabled(true);
#endif
    setWebAnimationsCompositeOperationsEnabled(true);
    setWebAnimationsCustomEffectsEnabled(true);
    setWebAnimationsCustomFrameRateEnabled(true);
    setWebAnimationsMutableTimelinesEnabled(true);
#if ENABLE(WEB_AUTHN)
    setWebAuthenticationModernEnabled(true);
#endif
#if ENABLE(WEB_AUTHN)
    setWebAuthenticationEnabled(true);
#endif
    setWebLocksAPIEnabled(true);
    setWebShareFileAPIEnabled(true);
#if ENABLE(WEBGL2)
    setWebGL2Enabled(true);
#endif
#if ENABLE(WEBGL) && PLATFORM(COCOA)
    setWebGLUsingMetal(true);
#endif
#if ENABLE(MEDIA_SOURCE)
    setWebMParserEnabled(true);
#endif
#if ENABLE(WEBM_FORMAT_READER)
    setWebMFormatReaderEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCEncodedTransformEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH264LowLatencyEncoderEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCH265CodecEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCPlatformTCPSocketsEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCPlatformUDPSocketsEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCSFrameTransformEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCSocketsProxyingEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCVP9Profile0CodecEnabled(true);
#endif
#if ENABLE(WEB_RTC)
    setWebRTCVP9Profile2CodecEnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXRAugmentedRealityModuleEnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXREnabled(true);
#endif
#if ENABLE(WEBXR)
    setWebXRGamepadsModuleEnabled(true);
#endif
#if ENABLE(WEBXR_HANDS)
    setWebXRHandInputModuleEnabled(true);
#endif
    setWheelEventGesturesBecomeNonBlocking(true);
    setPassiveWheelListenersAsDefaultOnDocument(true);
    setInertAttributeEnabled(true);
    setRequestIdleCallbackEnabled(true);
    setWebKitAdditionsFeature1Enabled(true);
}

}
