/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "./src/xdp-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Account
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpAccount
 * @title: XdpAccount
 * @short_description: Generated C code for the org.freedesktop.portal.Account D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Account ---- */

static const _ExtendedGDBusArgInfo _xdp_account_method_info_get_user_information_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_account_method_info_get_user_information_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_account_method_info_get_user_information_IN_ARG_pointers[] =
{
  &_xdp_account_method_info_get_user_information_IN_ARG_window.parent_struct,
  &_xdp_account_method_info_get_user_information_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_account_method_info_get_user_information_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_account_method_info_get_user_information_OUT_ARG_pointers[] =
{
  &_xdp_account_method_info_get_user_information_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_account_method_info_get_user_information =
{
  {
    -1,
    (gchar *) "GetUserInformation",
    (GDBusArgInfo **) &_xdp_account_method_info_get_user_information_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_account_method_info_get_user_information_OUT_ARG_pointers,
    NULL
  },
  "handle-get-user-information",
  FALSE
};

static const GDBusMethodInfo * const _xdp_account_method_info_pointers[] =
{
  &_xdp_account_method_info_get_user_information.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_account_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_account_property_info_pointers[] =
{
  &_xdp_account_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_account_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Account",
    (GDBusMethodInfo **) &_xdp_account_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_account_property_info_pointers,
    NULL
  },
  "account",
};


/**
 * xdp_account_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_account_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_account_interface_info.parent_struct;
}

/**
 * xdp_account_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpAccount interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_account_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpAccount:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link>.
 */

/**
 * XdpAccountIface:
 * @parent_iface: The parent interface.
 * @handle_get_user_information: Handler for the #XdpAccount::handle-get-user-information signal.
 * @get_version: Getter for the #XdpAccount:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link>.
 */

typedef XdpAccountIface XdpAccountInterface;
G_DEFINE_INTERFACE (XdpAccount, xdp_account, G_TYPE_OBJECT)

static void
xdp_account_default_init (XdpAccountIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpAccount::handle-get-user-information:
   * @object: A #XdpAccount.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_account_complete_get_user_information() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-user-information",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpAccountIface, handle_get_user_information),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpAccount:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Account.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_account_get_version: (skip)
 * @object: A #XdpAccount.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Account.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_account_get_version (XdpAccount *object)
{
  return XDP_ACCOUNT_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_account_set_version: (skip)
 * @object: A #XdpAccount.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Account.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_account_set_version (XdpAccount *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_account_call_get_user_information:
 * @proxy: A #XdpAccountProxy.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_account_call_get_user_information_finish() to get the result of the operation.
 *
 * See xdp_account_call_get_user_information_sync() for the synchronous, blocking version of this method.
 */
void
xdp_account_call_get_user_information (
    XdpAccount *proxy,
    const gchar *arg_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUserInformation",
    g_variant_new ("(s@a{sv})",
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_account_call_get_user_information_finish:
 * @proxy: A #XdpAccountProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_account_call_get_user_information().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_account_call_get_user_information().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_account_call_get_user_information_finish (
    XdpAccount *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_account_call_get_user_information_sync:
 * @proxy: A #XdpAccountProxy.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_account_call_get_user_information() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_account_call_get_user_information_sync (
    XdpAccount *proxy,
    const gchar *arg_window,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUserInformation",
    g_variant_new ("(s@a{sv})",
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_account_complete_get_user_information:
 * @object: A #XdpAccount.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_account_complete_get_user_information (
    XdpAccount *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpAccountProxy:
 *
 * The #XdpAccountProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpAccountProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpAccountProxy.
 */

struct _XdpAccountProxyPrivate
{
  GData *qdata;
};

static void xdp_account_proxy_iface_init (XdpAccountIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpAccountProxy, xdp_account_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpAccountProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_ACCOUNT, xdp_account_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpAccountProxy, xdp_account_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_ACCOUNT, xdp_account_proxy_iface_init))

#endif
static void
xdp_account_proxy_finalize (GObject *object)
{
  XdpAccountProxy *proxy = XDP_ACCOUNT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_account_proxy_parent_class)->finalize (object);
}

static void
xdp_account_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_account_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_account_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Account: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_account_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_account_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Account", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_account_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_account_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_account_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_ACCOUNT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_ACCOUNT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_account_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpAccountProxy *proxy = XDP_ACCOUNT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_account_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_account_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_account_proxy_get_version (XdpAccount *object)
{
  XdpAccountProxy *proxy = XDP_ACCOUNT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_account_proxy_init (XdpAccountProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_account_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_ACCOUNT_PROXY, XdpAccountProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_account_interface_info ());
}

static void
xdp_account_proxy_class_init (XdpAccountProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_account_proxy_finalize;
  gobject_class->get_property = xdp_account_proxy_get_property;
  gobject_class->set_property = xdp_account_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_account_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_account_proxy_g_properties_changed;

  xdp_account_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpAccountProxyPrivate));
#endif
}

static void
xdp_account_proxy_iface_init (XdpAccountIface *iface)
{
  iface->get_version = xdp_account_proxy_get_version;
}

/**
 * xdp_account_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_account_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_account_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_account_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_ACCOUNT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Account", NULL);
}

/**
 * xdp_account_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_account_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_account_proxy_new().
 *
 * Returns: (transfer full) (type XdpAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpAccount *
xdp_account_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_ACCOUNT (ret);
  else
    return NULL;
}

/**
 * xdp_account_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_account_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpAccount *
xdp_account_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_ACCOUNT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Account", NULL);
  if (ret != NULL)
    return XDP_ACCOUNT (ret);
  else
    return NULL;
}


/**
 * xdp_account_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_account_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_account_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_account_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_account_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_ACCOUNT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Account", NULL);
}

/**
 * xdp_account_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_account_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_account_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpAccount *
xdp_account_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_ACCOUNT (ret);
  else
    return NULL;
}

/**
 * xdp_account_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_account_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_account_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpAccount *
xdp_account_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_ACCOUNT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Account", NULL);
  if (ret != NULL)
    return XDP_ACCOUNT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpAccountSkeleton:
 *
 * The #XdpAccountSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpAccountSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpAccountSkeleton.
 */

struct _XdpAccountSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_account_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_ACCOUNT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_ACCOUNT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_account_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_account_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_account_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_account_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_account_skeleton_vtable =
{
  _xdp_account_skeleton_handle_method_call,
  _xdp_account_skeleton_handle_get_property,
  _xdp_account_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_account_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_account_interface_info ();
}

static GDBusInterfaceVTable *
xdp_account_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_account_skeleton_vtable;
}

static GVariant *
xdp_account_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_account_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_account_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_account_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_account_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Account", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_account_emit_changed (gpointer user_data);

static void
xdp_account_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_account_emit_changed (skeleton);
}

static void xdp_account_skeleton_iface_init (XdpAccountIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpAccountSkeleton, xdp_account_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpAccountSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_ACCOUNT, xdp_account_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpAccountSkeleton, xdp_account_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_ACCOUNT, xdp_account_skeleton_iface_init))

#endif
static void
xdp_account_skeleton_finalize (GObject *object)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_account_skeleton_parent_class)->finalize (object);
}

static void
xdp_account_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_account_emit_changed (gpointer user_data)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Account",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_account_schedule_emit_changed (XdpAccountSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_account_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_account_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_account_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_account_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_account_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_account_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_account_skeleton_init (XdpAccountSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_account_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_ACCOUNT_SKELETON, XdpAccountSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_account_skeleton_get_version (XdpAccount *object)
{
  XdpAccountSkeleton *skeleton = XDP_ACCOUNT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_account_skeleton_class_init (XdpAccountSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_account_skeleton_finalize;
  gobject_class->get_property = xdp_account_skeleton_get_property;
  gobject_class->set_property = xdp_account_skeleton_set_property;
  gobject_class->notify       = xdp_account_skeleton_notify;


  xdp_account_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_account_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_account_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_account_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_account_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpAccountSkeletonPrivate));
#endif
}

static void
xdp_account_skeleton_iface_init (XdpAccountIface *iface)
{
  iface->get_version = xdp_account_skeleton_get_version;
}

/**
 * xdp_account_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Account.top_of_page">org.freedesktop.portal.Account</link>.
 *
 * Returns: (transfer full) (type XdpAccountSkeleton): The skeleton object.
 */
XdpAccount *
xdp_account_skeleton_new (void)
{
  return XDP_ACCOUNT (g_object_new (XDP_TYPE_ACCOUNT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Background
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpBackground
 * @title: XdpBackground
 * @short_description: Generated C code for the org.freedesktop.portal.Background D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Background ---- */

static const _ExtendedGDBusArgInfo _xdp_background_method_info_request_background_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_background_method_info_request_background_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_background_method_info_request_background_IN_ARG_pointers[] =
{
  &_xdp_background_method_info_request_background_IN_ARG_parent_window.parent_struct,
  &_xdp_background_method_info_request_background_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_background_method_info_request_background_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_background_method_info_request_background_OUT_ARG_pointers[] =
{
  &_xdp_background_method_info_request_background_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_background_method_info_request_background =
{
  {
    -1,
    (gchar *) "RequestBackground",
    (GDBusArgInfo **) &_xdp_background_method_info_request_background_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_background_method_info_request_background_OUT_ARG_pointers,
    NULL
  },
  "handle-request-background",
  FALSE
};

static const GDBusMethodInfo * const _xdp_background_method_info_pointers[] =
{
  &_xdp_background_method_info_request_background.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_background_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_background_property_info_pointers[] =
{
  &_xdp_background_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_background_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Background",
    (GDBusMethodInfo **) &_xdp_background_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_background_property_info_pointers,
    NULL
  },
  "background",
};


/**
 * xdp_background_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_background_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_background_interface_info.parent_struct;
}

/**
 * xdp_background_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpBackground interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_background_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpBackground:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link>.
 */

/**
 * XdpBackgroundIface:
 * @parent_iface: The parent interface.
 * @handle_request_background: Handler for the #XdpBackground::handle-request-background signal.
 * @get_version: Getter for the #XdpBackground:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link>.
 */

typedef XdpBackgroundIface XdpBackgroundInterface;
G_DEFINE_INTERFACE (XdpBackground, xdp_background, G_TYPE_OBJECT)

static void
xdp_background_default_init (XdpBackgroundIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpBackground::handle-request-background:
   * @object: A #XdpBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Background.RequestBackground">RequestBackground()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_background_complete_request_background() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-background",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpBackgroundIface, handle_request_background),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpBackground:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Background.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_background_get_version: (skip)
 * @object: A #XdpBackground.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Background.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_background_get_version (XdpBackground *object)
{
  return XDP_BACKGROUND_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_background_set_version: (skip)
 * @object: A #XdpBackground.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Background.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_background_set_version (XdpBackground *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_background_call_request_background:
 * @proxy: A #XdpBackgroundProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Background.RequestBackground">RequestBackground()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_background_call_request_background_finish() to get the result of the operation.
 *
 * See xdp_background_call_request_background_sync() for the synchronous, blocking version of this method.
 */
void
xdp_background_call_request_background (
    XdpBackground *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestBackground",
    g_variant_new ("(s@a{sv})",
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_background_call_request_background_finish:
 * @proxy: A #XdpBackgroundProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_background_call_request_background().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_background_call_request_background().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_background_call_request_background_finish (
    XdpBackground *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_background_call_request_background_sync:
 * @proxy: A #XdpBackgroundProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Background.RequestBackground">RequestBackground()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_background_call_request_background() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_background_call_request_background_sync (
    XdpBackground *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestBackground",
    g_variant_new ("(s@a{sv})",
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_background_complete_request_background:
 * @object: A #XdpBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Background.RequestBackground">RequestBackground()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_background_complete_request_background (
    XdpBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpBackgroundProxy:
 *
 * The #XdpBackgroundProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpBackgroundProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpBackgroundProxy.
 */

struct _XdpBackgroundProxyPrivate
{
  GData *qdata;
};

static void xdp_background_proxy_iface_init (XdpBackgroundIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpBackgroundProxy, xdp_background_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpBackgroundProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_BACKGROUND, xdp_background_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpBackgroundProxy, xdp_background_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_BACKGROUND, xdp_background_proxy_iface_init))

#endif
static void
xdp_background_proxy_finalize (GObject *object)
{
  XdpBackgroundProxy *proxy = XDP_BACKGROUND_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_background_proxy_parent_class)->finalize (object);
}

static void
xdp_background_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_background_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_background_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Background: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_background_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_background_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Background", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_background_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_background_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_background_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_BACKGROUND);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_BACKGROUND);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_background_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpBackgroundProxy *proxy = XDP_BACKGROUND_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_background_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_background_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_background_proxy_get_version (XdpBackground *object)
{
  XdpBackgroundProxy *proxy = XDP_BACKGROUND_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_background_proxy_init (XdpBackgroundProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_background_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_BACKGROUND_PROXY, XdpBackgroundProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_background_interface_info ());
}

static void
xdp_background_proxy_class_init (XdpBackgroundProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_background_proxy_finalize;
  gobject_class->get_property = xdp_background_proxy_get_property;
  gobject_class->set_property = xdp_background_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_background_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_background_proxy_g_properties_changed;

  xdp_background_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpBackgroundProxyPrivate));
#endif
}

static void
xdp_background_proxy_iface_init (XdpBackgroundIface *iface)
{
  iface->get_version = xdp_background_proxy_get_version;
}

/**
 * xdp_background_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_background_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_background_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_background_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Background", NULL);
}

/**
 * xdp_background_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_background_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_background_proxy_new().
 *
 * Returns: (transfer full) (type XdpBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpBackground *
xdp_background_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_background_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_background_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpBackground *
xdp_background_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Background", NULL);
  if (ret != NULL)
    return XDP_BACKGROUND (ret);
  else
    return NULL;
}


/**
 * xdp_background_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_background_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_background_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_background_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_background_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Background", NULL);
}

/**
 * xdp_background_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_background_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_background_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpBackground *
xdp_background_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_background_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_background_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_background_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpBackground *
xdp_background_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Background", NULL);
  if (ret != NULL)
    return XDP_BACKGROUND (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpBackgroundSkeleton:
 *
 * The #XdpBackgroundSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpBackgroundSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpBackgroundSkeleton.
 */

struct _XdpBackgroundSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_background_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_BACKGROUND);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_BACKGROUND);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_background_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_background_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_background_skeleton_vtable =
{
  _xdp_background_skeleton_handle_method_call,
  _xdp_background_skeleton_handle_get_property,
  _xdp_background_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_background_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_background_interface_info ();
}

static GDBusInterfaceVTable *
xdp_background_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_background_skeleton_vtable;
}

static GVariant *
xdp_background_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_background_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_background_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_background_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_background_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Background", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_background_emit_changed (gpointer user_data);

static void
xdp_background_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_background_emit_changed (skeleton);
}

static void xdp_background_skeleton_iface_init (XdpBackgroundIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpBackgroundSkeleton, xdp_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpBackgroundSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_BACKGROUND, xdp_background_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpBackgroundSkeleton, xdp_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_BACKGROUND, xdp_background_skeleton_iface_init))

#endif
static void
xdp_background_skeleton_finalize (GObject *object)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_background_skeleton_parent_class)->finalize (object);
}

static void
xdp_background_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_background_emit_changed (gpointer user_data)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Background",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_background_schedule_emit_changed (XdpBackgroundSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_background_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_background_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_background_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_background_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_background_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_background_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_background_skeleton_init (XdpBackgroundSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_background_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_BACKGROUND_SKELETON, XdpBackgroundSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_background_skeleton_get_version (XdpBackground *object)
{
  XdpBackgroundSkeleton *skeleton = XDP_BACKGROUND_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_background_skeleton_class_init (XdpBackgroundSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_background_skeleton_finalize;
  gobject_class->get_property = xdp_background_skeleton_get_property;
  gobject_class->set_property = xdp_background_skeleton_set_property;
  gobject_class->notify       = xdp_background_skeleton_notify;


  xdp_background_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_background_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_background_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_background_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_background_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpBackgroundSkeletonPrivate));
#endif
}

static void
xdp_background_skeleton_iface_init (XdpBackgroundIface *iface)
{
  iface->get_version = xdp_background_skeleton_get_version;
}

/**
 * xdp_background_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Background.top_of_page">org.freedesktop.portal.Background</link>.
 *
 * Returns: (transfer full) (type XdpBackgroundSkeleton): The skeleton object.
 */
XdpBackground *
xdp_background_skeleton_new (void)
{
  return XDP_BACKGROUND (g_object_new (XDP_TYPE_BACKGROUND_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Camera
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpCamera
 * @title: XdpCamera
 * @short_description: Generated C code for the org.freedesktop.portal.Camera D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Camera ---- */

static const _ExtendedGDBusArgInfo _xdp_camera_method_info_access_camera_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_camera_method_info_access_camera_IN_ARG_pointers[] =
{
  &_xdp_camera_method_info_access_camera_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_camera_method_info_access_camera_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_camera_method_info_access_camera_OUT_ARG_pointers[] =
{
  &_xdp_camera_method_info_access_camera_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_camera_method_info_access_camera =
{
  {
    -1,
    (gchar *) "AccessCamera",
    (GDBusArgInfo **) &_xdp_camera_method_info_access_camera_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_camera_method_info_access_camera_OUT_ARG_pointers,
    NULL
  },
  "handle-access-camera",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_camera_method_info_open_pipewire_remote_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_camera_method_info_open_pipewire_remote_IN_ARG_pointers[] =
{
  &_xdp_camera_method_info_open_pipewire_remote_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_camera_method_info_open_pipewire_remote_OUT_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_camera_method_info_open_pipewire_remote_OUT_ARG_pointers[] =
{
  &_xdp_camera_method_info_open_pipewire_remote_OUT_ARG_fd.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_camera_method_info_open_pipewire_remote =
{
  {
    -1,
    (gchar *) "OpenPipeWireRemote",
    (GDBusArgInfo **) &_xdp_camera_method_info_open_pipewire_remote_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_camera_method_info_open_pipewire_remote_OUT_ARG_pointers,
    NULL
  },
  "handle-open-pipewire-remote",
  TRUE
};

static const GDBusMethodInfo * const _xdp_camera_method_info_pointers[] =
{
  &_xdp_camera_method_info_access_camera.parent_struct,
  &_xdp_camera_method_info_open_pipewire_remote.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_camera_property_info_is_camera_present =
{
  {
    -1,
    (gchar *) "IsCameraPresent",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "is-camera-present",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_camera_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_camera_property_info_pointers[] =
{
  &_xdp_camera_property_info_is_camera_present.parent_struct,
  &_xdp_camera_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_camera_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Camera",
    (GDBusMethodInfo **) &_xdp_camera_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_camera_property_info_pointers,
    NULL
  },
  "camera",
};


/**
 * xdp_camera_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_camera_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_camera_interface_info.parent_struct;
}

/**
 * xdp_camera_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpCamera interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_camera_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "is-camera-present");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpCamera:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link>.
 */

/**
 * XdpCameraIface:
 * @parent_iface: The parent interface.
 * @handle_access_camera: Handler for the #XdpCamera::handle-access-camera signal.
 * @handle_open_pipewire_remote: Handler for the #XdpCamera::handle-open-pipewire-remote signal.
 * @get_is_camera_present: Getter for the #XdpCamera:is-camera-present property.
 * @get_version: Getter for the #XdpCamera:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link>.
 */

typedef XdpCameraIface XdpCameraInterface;
G_DEFINE_INTERFACE (XdpCamera, xdp_camera, G_TYPE_OBJECT)

static void
xdp_camera_default_init (XdpCameraIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpCamera::handle-access-camera:
   * @object: A #XdpCamera.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Camera.AccessCamera">AccessCamera()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_camera_complete_access_camera() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-access-camera",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpCameraIface, handle_access_camera),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * XdpCamera::handle-open-pipewire-remote:
   * @object: A #XdpCamera.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Camera.OpenPipeWireRemote">OpenPipeWireRemote()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_camera_complete_open_pipewire_remote() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-pipewire-remote",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpCameraIface, handle_open_pipewire_remote),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpCamera:is-camera-present:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Camera.IsCameraPresent">"IsCameraPresent"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("is-camera-present", "IsCameraPresent", "IsCameraPresent", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpCamera:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Camera.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_camera_get_is_camera_present: (skip)
 * @object: A #XdpCamera.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Camera.IsCameraPresent">"IsCameraPresent"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_camera_get_is_camera_present (XdpCamera *object)
{
  return XDP_CAMERA_GET_IFACE (object)->get_is_camera_present (object);
}

/**
 * xdp_camera_set_is_camera_present: (skip)
 * @object: A #XdpCamera.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Camera.IsCameraPresent">"IsCameraPresent"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_camera_set_is_camera_present (XdpCamera *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "is-camera-present", value, NULL);
}

/**
 * xdp_camera_get_version: (skip)
 * @object: A #XdpCamera.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Camera.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_camera_get_version (XdpCamera *object)
{
  return XDP_CAMERA_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_camera_set_version: (skip)
 * @object: A #XdpCamera.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Camera.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_camera_set_version (XdpCamera *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_camera_call_access_camera:
 * @proxy: A #XdpCameraProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Camera.AccessCamera">AccessCamera()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_camera_call_access_camera_finish() to get the result of the operation.
 *
 * See xdp_camera_call_access_camera_sync() for the synchronous, blocking version of this method.
 */
void
xdp_camera_call_access_camera (
    XdpCamera *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AccessCamera",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_camera_call_access_camera_finish:
 * @proxy: A #XdpCameraProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_camera_call_access_camera().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_camera_call_access_camera().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_camera_call_access_camera_finish (
    XdpCamera *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_camera_call_access_camera_sync:
 * @proxy: A #XdpCameraProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Camera.AccessCamera">AccessCamera()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_camera_call_access_camera() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_camera_call_access_camera_sync (
    XdpCamera *proxy,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AccessCamera",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_camera_call_open_pipewire_remote:
 * @proxy: A #XdpCameraProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Camera.OpenPipeWireRemote">OpenPipeWireRemote()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_camera_call_open_pipewire_remote_finish() to get the result of the operation.
 *
 * See xdp_camera_call_open_pipewire_remote_sync() for the synchronous, blocking version of this method.
 */
void
xdp_camera_call_open_pipewire_remote (
    XdpCamera *proxy,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenPipeWireRemote",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_camera_call_open_pipewire_remote_finish:
 * @proxy: A #XdpCameraProxy.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_camera_call_open_pipewire_remote().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_camera_call_open_pipewire_remote().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_camera_call_open_pipewire_remote_finish (
    XdpCamera *proxy,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_camera_call_open_pipewire_remote_sync:
 * @proxy: A #XdpCameraProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Camera.OpenPipeWireRemote">OpenPipeWireRemote()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_camera_call_open_pipewire_remote() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_camera_call_open_pipewire_remote_sync (
    XdpCamera *proxy,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GVariant **out_fd,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenPipeWireRemote",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@h)",
                 out_fd);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_camera_complete_access_camera:
 * @object: A #XdpCamera.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Camera.AccessCamera">AccessCamera()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_camera_complete_access_camera (
    XdpCamera *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_camera_complete_open_pipewire_remote:
 * @object: A #XdpCamera.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @fd: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Camera.OpenPipeWireRemote">OpenPipeWireRemote()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_camera_complete_open_pipewire_remote (
    XdpCamera *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    GVariant *fd)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(@h)",
                   fd),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpCameraProxy:
 *
 * The #XdpCameraProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpCameraProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpCameraProxy.
 */

struct _XdpCameraProxyPrivate
{
  GData *qdata;
};

static void xdp_camera_proxy_iface_init (XdpCameraIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpCameraProxy, xdp_camera_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpCameraProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_CAMERA, xdp_camera_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpCameraProxy, xdp_camera_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_CAMERA, xdp_camera_proxy_iface_init))

#endif
static void
xdp_camera_proxy_finalize (GObject *object)
{
  XdpCameraProxy *proxy = XDP_CAMERA_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_camera_proxy_parent_class)->finalize (object);
}

static void
xdp_camera_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_camera_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_camera_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Camera: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_camera_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_camera_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Camera", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_camera_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_camera_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_camera_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_CAMERA);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_CAMERA);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_camera_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpCameraProxy *proxy = XDP_CAMERA_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_camera_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_camera_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
xdp_camera_proxy_get_is_camera_present (XdpCamera *object)
{
  XdpCameraProxy *proxy = XDP_CAMERA_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "IsCameraPresent");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_camera_proxy_get_version (XdpCamera *object)
{
  XdpCameraProxy *proxy = XDP_CAMERA_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_camera_proxy_init (XdpCameraProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_camera_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_CAMERA_PROXY, XdpCameraProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_camera_interface_info ());
}

static void
xdp_camera_proxy_class_init (XdpCameraProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_camera_proxy_finalize;
  gobject_class->get_property = xdp_camera_proxy_get_property;
  gobject_class->set_property = xdp_camera_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_camera_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_camera_proxy_g_properties_changed;

  xdp_camera_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpCameraProxyPrivate));
#endif
}

static void
xdp_camera_proxy_iface_init (XdpCameraIface *iface)
{
  iface->get_is_camera_present = xdp_camera_proxy_get_is_camera_present;
  iface->get_version = xdp_camera_proxy_get_version;
}

/**
 * xdp_camera_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_camera_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_camera_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_camera_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_CAMERA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Camera", NULL);
}

/**
 * xdp_camera_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_camera_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_camera_proxy_new().
 *
 * Returns: (transfer full) (type XdpCameraProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpCamera *
xdp_camera_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_CAMERA (ret);
  else
    return NULL;
}

/**
 * xdp_camera_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_camera_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpCameraProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpCamera *
xdp_camera_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_CAMERA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Camera", NULL);
  if (ret != NULL)
    return XDP_CAMERA (ret);
  else
    return NULL;
}


/**
 * xdp_camera_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_camera_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_camera_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_camera_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_camera_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_CAMERA_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Camera", NULL);
}

/**
 * xdp_camera_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_camera_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_camera_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpCameraProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpCamera *
xdp_camera_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_CAMERA (ret);
  else
    return NULL;
}

/**
 * xdp_camera_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_camera_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_camera_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpCameraProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpCamera *
xdp_camera_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_CAMERA_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Camera", NULL);
  if (ret != NULL)
    return XDP_CAMERA (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpCameraSkeleton:
 *
 * The #XdpCameraSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpCameraSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpCameraSkeleton.
 */

struct _XdpCameraSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_camera_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_CAMERA);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_CAMERA);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_camera_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_camera_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_camera_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_camera_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_camera_skeleton_vtable =
{
  _xdp_camera_skeleton_handle_method_call,
  _xdp_camera_skeleton_handle_get_property,
  _xdp_camera_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_camera_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_camera_interface_info ();
}

static GDBusInterfaceVTable *
xdp_camera_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_camera_skeleton_vtable;
}

static GVariant *
xdp_camera_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_camera_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_camera_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_camera_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_camera_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Camera", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_camera_emit_changed (gpointer user_data);

static void
xdp_camera_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_camera_emit_changed (skeleton);
}

static void xdp_camera_skeleton_iface_init (XdpCameraIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpCameraSkeleton, xdp_camera_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpCameraSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_CAMERA, xdp_camera_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpCameraSkeleton, xdp_camera_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_CAMERA, xdp_camera_skeleton_iface_init))

#endif
static void
xdp_camera_skeleton_finalize (GObject *object)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_camera_skeleton_parent_class)->finalize (object);
}

static void
xdp_camera_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_camera_emit_changed (gpointer user_data)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Camera",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_camera_schedule_emit_changed (XdpCameraSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_camera_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_camera_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_camera_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_camera_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_camera_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_camera_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_camera_skeleton_init (XdpCameraSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_camera_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_CAMERA_SKELETON, XdpCameraSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static gboolean 
xdp_camera_skeleton_get_is_camera_present (XdpCamera *object)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_camera_skeleton_get_version (XdpCamera *object)
{
  XdpCameraSkeleton *skeleton = XDP_CAMERA_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_camera_skeleton_class_init (XdpCameraSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_camera_skeleton_finalize;
  gobject_class->get_property = xdp_camera_skeleton_get_property;
  gobject_class->set_property = xdp_camera_skeleton_set_property;
  gobject_class->notify       = xdp_camera_skeleton_notify;


  xdp_camera_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_camera_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_camera_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_camera_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_camera_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpCameraSkeletonPrivate));
#endif
}

static void
xdp_camera_skeleton_iface_init (XdpCameraIface *iface)
{
  iface->get_is_camera_present = xdp_camera_skeleton_get_is_camera_present;
  iface->get_version = xdp_camera_skeleton_get_version;
}

/**
 * xdp_camera_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Camera.top_of_page">org.freedesktop.portal.Camera</link>.
 *
 * Returns: (transfer full) (type XdpCameraSkeleton): The skeleton object.
 */
XdpCamera *
xdp_camera_skeleton_new (void)
{
  return XDP_CAMERA (g_object_new (XDP_TYPE_CAMERA_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Device
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDevice
 * @title: XdpDevice
 * @short_description: Generated C code for the org.freedesktop.portal.Device D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Device ---- */

static const _ExtendedGDBusArgInfo _xdp_device_method_info_access_device_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_device_method_info_access_device_IN_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_device_method_info_access_device_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_device_method_info_access_device_IN_ARG_pointers[] =
{
  &_xdp_device_method_info_access_device_IN_ARG_pid.parent_struct,
  &_xdp_device_method_info_access_device_IN_ARG_devices.parent_struct,
  &_xdp_device_method_info_access_device_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_device_method_info_access_device_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_device_method_info_access_device_OUT_ARG_pointers[] =
{
  &_xdp_device_method_info_access_device_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_device_method_info_access_device =
{
  {
    -1,
    (gchar *) "AccessDevice",
    (GDBusArgInfo **) &_xdp_device_method_info_access_device_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_device_method_info_access_device_OUT_ARG_pointers,
    NULL
  },
  "handle-access-device",
  FALSE
};

static const GDBusMethodInfo * const _xdp_device_method_info_pointers[] =
{
  &_xdp_device_method_info_access_device.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_device_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_device_property_info_pointers[] =
{
  &_xdp_device_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_device_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Device",
    (GDBusMethodInfo **) &_xdp_device_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_device_property_info_pointers,
    NULL
  },
  "device",
};


/**
 * xdp_device_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_device_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_device_interface_info.parent_struct;
}

/**
 * xdp_device_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDevice interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_device_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDevice:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link>.
 */

/**
 * XdpDeviceIface:
 * @parent_iface: The parent interface.
 * @handle_access_device: Handler for the #XdpDevice::handle-access-device signal.
 * @get_version: Getter for the #XdpDevice:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link>.
 */

typedef XdpDeviceIface XdpDeviceInterface;
G_DEFINE_INTERFACE (XdpDevice, xdp_device, G_TYPE_OBJECT)

static void
xdp_device_default_init (XdpDeviceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDevice::handle-access-device:
   * @object: A #XdpDevice.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   * @arg_devices: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Device.AccessDevice">AccessDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_device_complete_access_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-access-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDeviceIface, handle_access_device),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT, G_TYPE_STRV, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDevice:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Device.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_device_get_version: (skip)
 * @object: A #XdpDevice.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Device.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_device_get_version (XdpDevice *object)
{
  return XDP_DEVICE_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_device_set_version: (skip)
 * @object: A #XdpDevice.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Device.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_device_set_version (XdpDevice *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_device_call_access_device:
 * @proxy: A #XdpDeviceProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_devices: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Device.AccessDevice">AccessDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_device_call_access_device_finish() to get the result of the operation.
 *
 * See xdp_device_call_access_device_sync() for the synchronous, blocking version of this method.
 */
void
xdp_device_call_access_device (
    XdpDevice *proxy,
    guint arg_pid,
    const gchar *const *arg_devices,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AccessDevice",
    g_variant_new ("(u^as@a{sv})",
                   arg_pid,
                   arg_devices,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_device_call_access_device_finish:
 * @proxy: A #XdpDeviceProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_device_call_access_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_device_call_access_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_device_call_access_device_finish (
    XdpDevice *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_device_call_access_device_sync:
 * @proxy: A #XdpDeviceProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @arg_devices: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Device.AccessDevice">AccessDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_device_call_access_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_device_call_access_device_sync (
    XdpDevice *proxy,
    guint arg_pid,
    const gchar *const *arg_devices,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AccessDevice",
    g_variant_new ("(u^as@a{sv})",
                   arg_pid,
                   arg_devices,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_device_complete_access_device:
 * @object: A #XdpDevice.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Device.AccessDevice">AccessDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_device_complete_access_device (
    XdpDevice *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDeviceProxy:
 *
 * The #XdpDeviceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDeviceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDeviceProxy.
 */

struct _XdpDeviceProxyPrivate
{
  GData *qdata;
};

static void xdp_device_proxy_iface_init (XdpDeviceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDeviceProxy, xdp_device_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDeviceProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DEVICE, xdp_device_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDeviceProxy, xdp_device_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DEVICE, xdp_device_proxy_iface_init))

#endif
static void
xdp_device_proxy_finalize (GObject *object)
{
  XdpDeviceProxy *proxy = XDP_DEVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_device_proxy_parent_class)->finalize (object);
}

static void
xdp_device_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_device_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Device: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_device_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_device_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Device", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_device_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_device_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_device_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_DEVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_DEVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_device_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDeviceProxy *proxy = XDP_DEVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_device_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_device_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_device_proxy_get_version (XdpDevice *object)
{
  XdpDeviceProxy *proxy = XDP_DEVICE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_device_proxy_init (XdpDeviceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_device_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_DEVICE_PROXY, XdpDeviceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_device_interface_info ());
}

static void
xdp_device_proxy_class_init (XdpDeviceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_device_proxy_finalize;
  gobject_class->get_property = xdp_device_proxy_get_property;
  gobject_class->set_property = xdp_device_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_device_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_device_proxy_g_properties_changed;

  xdp_device_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDeviceProxyPrivate));
#endif
}

static void
xdp_device_proxy_iface_init (XdpDeviceIface *iface)
{
  iface->get_version = xdp_device_proxy_get_version;
}

/**
 * xdp_device_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_device_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_device_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_device_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Device", NULL);
}

/**
 * xdp_device_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_device_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_device_proxy_new().
 *
 * Returns: (transfer full) (type XdpDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDevice *
xdp_device_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DEVICE (ret);
  else
    return NULL;
}

/**
 * xdp_device_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_device_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDevice *
xdp_device_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Device", NULL);
  if (ret != NULL)
    return XDP_DEVICE (ret);
  else
    return NULL;
}


/**
 * xdp_device_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_device_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_device_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_device_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_device_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_DEVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Device", NULL);
}

/**
 * xdp_device_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_device_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_device_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDevice *
xdp_device_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DEVICE (ret);
  else
    return NULL;
}

/**
 * xdp_device_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_device_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_device_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDeviceProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDevice *
xdp_device_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_DEVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Device", NULL);
  if (ret != NULL)
    return XDP_DEVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDeviceSkeleton:
 *
 * The #XdpDeviceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDeviceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDeviceSkeleton.
 */

struct _XdpDeviceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_device_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_DEVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_DEVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_device_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_device_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_device_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_device_skeleton_vtable =
{
  _xdp_device_skeleton_handle_method_call,
  _xdp_device_skeleton_handle_get_property,
  _xdp_device_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_device_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_device_interface_info ();
}

static GDBusInterfaceVTable *
xdp_device_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_device_skeleton_vtable;
}

static GVariant *
xdp_device_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_device_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_device_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_device_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_device_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Device", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_device_emit_changed (gpointer user_data);

static void
xdp_device_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_device_emit_changed (skeleton);
}

static void xdp_device_skeleton_iface_init (XdpDeviceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDeviceSkeleton, xdp_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDeviceSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DEVICE, xdp_device_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDeviceSkeleton, xdp_device_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DEVICE, xdp_device_skeleton_iface_init))

#endif
static void
xdp_device_skeleton_finalize (GObject *object)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_device_skeleton_parent_class)->finalize (object);
}

static void
xdp_device_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_device_emit_changed (gpointer user_data)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Device",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_device_schedule_emit_changed (XdpDeviceSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_device_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_device_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_device_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_device_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_device_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_device_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_device_skeleton_init (XdpDeviceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_device_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_DEVICE_SKELETON, XdpDeviceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_device_skeleton_get_version (XdpDevice *object)
{
  XdpDeviceSkeleton *skeleton = XDP_DEVICE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_device_skeleton_class_init (XdpDeviceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_device_skeleton_finalize;
  gobject_class->get_property = xdp_device_skeleton_get_property;
  gobject_class->set_property = xdp_device_skeleton_set_property;
  gobject_class->notify       = xdp_device_skeleton_notify;


  xdp_device_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_device_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_device_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_device_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_device_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDeviceSkeletonPrivate));
#endif
}

static void
xdp_device_skeleton_iface_init (XdpDeviceIface *iface)
{
  iface->get_version = xdp_device_skeleton_get_version;
}

/**
 * xdp_device_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Device.top_of_page">org.freedesktop.portal.Device</link>.
 *
 * Returns: (transfer full) (type XdpDeviceSkeleton): The skeleton object.
 */
XdpDevice *
xdp_device_skeleton_new (void)
{
  return XDP_DEVICE (g_object_new (XDP_TYPE_DEVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Documents
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDocuments
 * @title: XdpDocuments
 * @short_description: Generated C code for the org.freedesktop.portal.Documents D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Documents ---- */

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_get_mount_point_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_get_mount_point_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_get_mount_point_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_get_mount_point =
{
  {
    -1,
    (gchar *) "GetMountPoint",
    NULL,
    (GDBusArgInfo **) &_xdp_documents_method_info_get_mount_point_OUT_ARG_pointers,
    NULL
  },
  "handle-get-mount-point",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_IN_ARG_o_path_fd =
{
  {
    -1,
    (gchar *) "o_path_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_IN_ARG_reuse_existing =
{
  {
    -1,
    (gchar *) "reuse_existing",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_IN_ARG_persistent =
{
  {
    -1,
    (gchar *) "persistent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_IN_ARG_o_path_fd.parent_struct,
  &_xdp_documents_method_info_add_IN_ARG_reuse_existing.parent_struct,
  &_xdp_documents_method_info_add_IN_ARG_persistent.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_OUT_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_OUT_ARG_doc_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_add =
{
  {
    -1,
    (gchar *) "Add",
    (GDBusArgInfo **) &_xdp_documents_method_info_add_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_add_OUT_ARG_pointers,
    NULL
  },
  "handle-add",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_IN_ARG_o_path_parent_fd =
{
  {
    -1,
    (gchar *) "o_path_parent_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_IN_ARG_reuse_existing =
{
  {
    -1,
    (gchar *) "reuse_existing",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_IN_ARG_persistent =
{
  {
    -1,
    (gchar *) "persistent",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_named_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_named_IN_ARG_o_path_parent_fd.parent_struct,
  &_xdp_documents_method_info_add_named_IN_ARG_filename.parent_struct,
  &_xdp_documents_method_info_add_named_IN_ARG_reuse_existing.parent_struct,
  &_xdp_documents_method_info_add_named_IN_ARG_persistent.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_OUT_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_named_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_named_OUT_ARG_doc_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_add_named =
{
  {
    -1,
    (gchar *) "AddNamed",
    (GDBusArgInfo **) &_xdp_documents_method_info_add_named_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_add_named_OUT_ARG_pointers,
    NULL
  },
  "handle-add-named",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_full_IN_ARG_o_path_fds =
{
  {
    -1,
    (gchar *) "o_path_fds",
    (gchar *) "ah",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_full_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_full_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_full_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_full_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_full_IN_ARG_o_path_fds.parent_struct,
  &_xdp_documents_method_info_add_full_IN_ARG_flags.parent_struct,
  &_xdp_documents_method_info_add_full_IN_ARG_app_id.parent_struct,
  &_xdp_documents_method_info_add_full_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_full_OUT_ARG_doc_ids =
{
  {
    -1,
    (gchar *) "doc_ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_full_OUT_ARG_extra_out =
{
  {
    -1,
    (gchar *) "extra_out",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_full_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_full_OUT_ARG_doc_ids.parent_struct,
  &_xdp_documents_method_info_add_full_OUT_ARG_extra_out.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_add_full =
{
  {
    -1,
    (gchar *) "AddFull",
    (GDBusArgInfo **) &_xdp_documents_method_info_add_full_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_add_full_OUT_ARG_pointers,
    NULL
  },
  "handle-add-full",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_IN_ARG_o_path_fd =
{
  {
    -1,
    (gchar *) "o_path_fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_named_full_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_named_full_IN_ARG_o_path_fd.parent_struct,
  &_xdp_documents_method_info_add_named_full_IN_ARG_filename.parent_struct,
  &_xdp_documents_method_info_add_named_full_IN_ARG_flags.parent_struct,
  &_xdp_documents_method_info_add_named_full_IN_ARG_app_id.parent_struct,
  &_xdp_documents_method_info_add_named_full_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_OUT_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_add_named_full_OUT_ARG_extra_out =
{
  {
    -1,
    (gchar *) "extra_out",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_add_named_full_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_add_named_full_OUT_ARG_doc_id.parent_struct,
  &_xdp_documents_method_info_add_named_full_OUT_ARG_extra_out.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_add_named_full =
{
  {
    -1,
    (gchar *) "AddNamedFull",
    (GDBusArgInfo **) &_xdp_documents_method_info_add_named_full_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_add_named_full_OUT_ARG_pointers,
    NULL
  },
  "handle-add-named-full",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_grant_permissions_IN_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_grant_permissions_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_grant_permissions_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_grant_permissions_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_grant_permissions_IN_ARG_doc_id.parent_struct,
  &_xdp_documents_method_info_grant_permissions_IN_ARG_app_id.parent_struct,
  &_xdp_documents_method_info_grant_permissions_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_grant_permissions =
{
  {
    -1,
    (gchar *) "GrantPermissions",
    (GDBusArgInfo **) &_xdp_documents_method_info_grant_permissions_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-grant-permissions",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_revoke_permissions_IN_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_revoke_permissions_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_revoke_permissions_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_revoke_permissions_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_revoke_permissions_IN_ARG_doc_id.parent_struct,
  &_xdp_documents_method_info_revoke_permissions_IN_ARG_app_id.parent_struct,
  &_xdp_documents_method_info_revoke_permissions_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_revoke_permissions =
{
  {
    -1,
    (gchar *) "RevokePermissions",
    (GDBusArgInfo **) &_xdp_documents_method_info_revoke_permissions_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-revoke-permissions",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_delete_IN_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_delete_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_delete_IN_ARG_doc_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_xdp_documents_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_lookup_IN_ARG_filename =
{
  {
    -1,
    (gchar *) "filename",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_lookup_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_lookup_IN_ARG_filename.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_lookup_OUT_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_lookup_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_lookup_OUT_ARG_doc_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_lookup =
{
  {
    -1,
    (gchar *) "Lookup",
    (GDBusArgInfo **) &_xdp_documents_method_info_lookup_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_lookup_OUT_ARG_pointers,
    NULL
  },
  "handle-lookup",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_info_IN_ARG_doc_id =
{
  {
    -1,
    (gchar *) "doc_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_info_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_info_IN_ARG_doc_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_info_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "ay",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_info_OUT_ARG_apps =
{
  {
    -1,
    (gchar *) "apps",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_info_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_info_OUT_ARG_path.parent_struct,
  &_xdp_documents_method_info_info_OUT_ARG_apps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_info =
{
  {
    -1,
    (gchar *) "Info",
    (GDBusArgInfo **) &_xdp_documents_method_info_info_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_info_OUT_ARG_pointers,
    NULL
  },
  "handle-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_list_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_list_IN_ARG_pointers[] =
{
  &_xdp_documents_method_info_list_IN_ARG_app_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_documents_method_info_list_OUT_ARG_docs =
{
  {
    -1,
    (gchar *) "docs",
    (gchar *) "a{say}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_documents_method_info_list_OUT_ARG_pointers[] =
{
  &_xdp_documents_method_info_list_OUT_ARG_docs.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_documents_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    (GDBusArgInfo **) &_xdp_documents_method_info_list_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_documents_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const GDBusMethodInfo * const _xdp_documents_method_info_pointers[] =
{
  &_xdp_documents_method_info_get_mount_point.parent_struct,
  &_xdp_documents_method_info_add.parent_struct,
  &_xdp_documents_method_info_add_named.parent_struct,
  &_xdp_documents_method_info_add_full.parent_struct,
  &_xdp_documents_method_info_add_named_full.parent_struct,
  &_xdp_documents_method_info_grant_permissions.parent_struct,
  &_xdp_documents_method_info_revoke_permissions.parent_struct,
  &_xdp_documents_method_info_delete.parent_struct,
  &_xdp_documents_method_info_lookup.parent_struct,
  &_xdp_documents_method_info_info.parent_struct,
  &_xdp_documents_method_info_list.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_documents_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_documents_property_info_pointers[] =
{
  &_xdp_documents_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_documents_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Documents",
    (GDBusMethodInfo **) &_xdp_documents_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_documents_property_info_pointers,
    NULL
  },
  "documents",
};


/**
 * xdp_documents_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_documents_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_documents_interface_info.parent_struct;
}

/**
 * xdp_documents_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDocuments interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_documents_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDocuments:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link>.
 */

/**
 * XdpDocumentsIface:
 * @parent_iface: The parent interface.
 * @handle_add: Handler for the #XdpDocuments::handle-add signal.
 * @handle_add_full: Handler for the #XdpDocuments::handle-add-full signal.
 * @handle_add_named: Handler for the #XdpDocuments::handle-add-named signal.
 * @handle_add_named_full: Handler for the #XdpDocuments::handle-add-named-full signal.
 * @handle_delete: Handler for the #XdpDocuments::handle-delete signal.
 * @handle_get_mount_point: Handler for the #XdpDocuments::handle-get-mount-point signal.
 * @handle_grant_permissions: Handler for the #XdpDocuments::handle-grant-permissions signal.
 * @handle_info: Handler for the #XdpDocuments::handle-info signal.
 * @handle_list: Handler for the #XdpDocuments::handle-list signal.
 * @handle_lookup: Handler for the #XdpDocuments::handle-lookup signal.
 * @handle_revoke_permissions: Handler for the #XdpDocuments::handle-revoke-permissions signal.
 * @get_version: Getter for the #XdpDocuments:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link>.
 */

typedef XdpDocumentsIface XdpDocumentsInterface;
G_DEFINE_INTERFACE (XdpDocuments, xdp_documents, G_TYPE_OBJECT)

static void
xdp_documents_default_init (XdpDocumentsIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDocuments::handle-get-mount-point:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GetMountPoint">GetMountPoint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_get_mount_point() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-mount-point",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_get_mount_point),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpDocuments::handle-add:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_o_path_fd: Argument passed by remote caller.
   * @arg_reuse_existing: Argument passed by remote caller.
   * @arg_persistent: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Add">Add()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_add() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_add),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * XdpDocuments::handle-add-named:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_o_path_parent_fd: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   * @arg_reuse_existing: Argument passed by remote caller.
   * @arg_persistent: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamed">AddNamed()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_add_named() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-named",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_add_named),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * XdpDocuments::handle-add-full:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_o_path_fds: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddFull">AddFull()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_add_full() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-full",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_add_full),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdpDocuments::handle-add-named-full:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_o_path_fd: Argument passed by remote caller.
   * @arg_filename: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamedFull">AddNamedFull()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_add_named_full() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-named-full",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_add_named_full),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdpDocuments::handle-grant-permissions:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_doc_id: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GrantPermissions">GrantPermissions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_grant_permissions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-grant-permissions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_grant_permissions),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdpDocuments::handle-revoke-permissions:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_doc_id: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.RevokePermissions">RevokePermissions()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_revoke_permissions() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-revoke-permissions",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_revoke_permissions),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdpDocuments::handle-delete:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_doc_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XdpDocuments::handle-lookup:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_filename: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Lookup">Lookup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_lookup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lookup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_lookup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XdpDocuments::handle-info:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_doc_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Info">Info()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_info() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_info),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XdpDocuments::handle-list:
   * @object: A #XdpDocuments.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Documents.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_documents_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDocumentsIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDocuments:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Documents.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_documents_get_version: (skip)
 * @object: A #XdpDocuments.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Documents.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_documents_get_version (XdpDocuments *object)
{
  return XDP_DOCUMENTS_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_documents_set_version: (skip)
 * @object: A #XdpDocuments.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Documents.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_documents_set_version (XdpDocuments *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_documents_call_get_mount_point:
 * @proxy: A #XdpDocumentsProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GetMountPoint">GetMountPoint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_get_mount_point_finish() to get the result of the operation.
 *
 * See xdp_documents_call_get_mount_point_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_get_mount_point (
    XdpDocuments *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMountPoint",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_get_mount_point_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_get_mount_point().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_get_mount_point().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_get_mount_point_finish (
    XdpDocuments *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_get_mount_point_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GetMountPoint">GetMountPoint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_get_mount_point() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_get_mount_point_sync (
    XdpDocuments *proxy,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMountPoint",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_fd: Argument to pass with the method invocation.
 * @arg_reuse_existing: Argument to pass with the method invocation.
 * @arg_persistent: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Add">Add()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_add_finish() to get the result of the operation.
 *
 * See xdp_documents_call_add_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_add (
    XdpDocuments *proxy,
    GVariant *arg_o_path_fd,
    gboolean arg_reuse_existing,
    gboolean arg_persistent,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Add",
    g_variant_new ("(@hbb)",
                   arg_o_path_fd,
                   arg_reuse_existing,
                   arg_persistent),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_add_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_add().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_add().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_finish (
    XdpDocuments *proxy,
    gchar **out_doc_id,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_doc_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_fd: Argument to pass with the method invocation.
 * @arg_reuse_existing: Argument to pass with the method invocation.
 * @arg_persistent: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Add">Add()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_add() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_sync (
    XdpDocuments *proxy,
    GVariant *arg_o_path_fd,
    gboolean arg_reuse_existing,
    gboolean arg_persistent,
    GUnixFDList  *fd_list,
    gchar **out_doc_id,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Add",
    g_variant_new ("(@hbb)",
                   arg_o_path_fd,
                   arg_reuse_existing,
                   arg_persistent),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_doc_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_named:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_parent_fd: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_reuse_existing: Argument to pass with the method invocation.
 * @arg_persistent: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamed">AddNamed()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_add_named_finish() to get the result of the operation.
 *
 * See xdp_documents_call_add_named_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_add_named (
    XdpDocuments *proxy,
    GVariant *arg_o_path_parent_fd,
    const gchar *arg_filename,
    gboolean arg_reuse_existing,
    gboolean arg_persistent,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AddNamed",
    g_variant_new ("(@h^aybb)",
                   arg_o_path_parent_fd,
                   arg_filename,
                   arg_reuse_existing,
                   arg_persistent),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_add_named_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_add_named().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_add_named().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_named_finish (
    XdpDocuments *proxy,
    gchar **out_doc_id,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_doc_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_named_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_parent_fd: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_reuse_existing: Argument to pass with the method invocation.
 * @arg_persistent: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamed">AddNamed()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_add_named() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_named_sync (
    XdpDocuments *proxy,
    GVariant *arg_o_path_parent_fd,
    const gchar *arg_filename,
    gboolean arg_reuse_existing,
    gboolean arg_persistent,
    GUnixFDList  *fd_list,
    gchar **out_doc_id,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AddNamed",
    g_variant_new ("(@h^aybb)",
                   arg_o_path_parent_fd,
                   arg_filename,
                   arg_reuse_existing,
                   arg_persistent),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_doc_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_full:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_fds: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddFull">AddFull()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_add_full_finish() to get the result of the operation.
 *
 * See xdp_documents_call_add_full_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_add_full (
    XdpDocuments *proxy,
    GVariant *arg_o_path_fds,
    guint arg_flags,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AddFull",
    g_variant_new ("(@ahus^as)",
                   arg_o_path_fds,
                   arg_flags,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_add_full_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_doc_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_extra_out: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_add_full().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_add_full().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_full_finish (
    XdpDocuments *proxy,
    gchar ***out_doc_ids,
    GVariant **out_extra_out,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as@a{sv})",
                 out_doc_ids,
                 out_extra_out);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_full_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_fds: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_doc_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_extra_out: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddFull">AddFull()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_add_full() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_full_sync (
    XdpDocuments *proxy,
    GVariant *arg_o_path_fds,
    guint arg_flags,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GUnixFDList  *fd_list,
    gchar ***out_doc_ids,
    GVariant **out_extra_out,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AddFull",
    g_variant_new ("(@ahus^as)",
                   arg_o_path_fds,
                   arg_flags,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as@a{sv})",
                 out_doc_ids,
                 out_extra_out);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_named_full:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_fd: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamedFull">AddNamedFull()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_add_named_full_finish() to get the result of the operation.
 *
 * See xdp_documents_call_add_named_full_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_add_named_full (
    XdpDocuments *proxy,
    GVariant *arg_o_path_fd,
    const gchar *arg_filename,
    guint arg_flags,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AddNamedFull",
    g_variant_new ("(@h^ayus^as)",
                   arg_o_path_fd,
                   arg_filename,
                   arg_flags,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_add_named_full_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_extra_out: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_add_named_full().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_add_named_full().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_named_full_finish (
    XdpDocuments *proxy,
    gchar **out_doc_id,
    GVariant **out_extra_out,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s@a{sv})",
                 out_doc_id,
                 out_extra_out);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_add_named_full_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_o_path_fd: Argument to pass with the method invocation.
 * @arg_filename: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_extra_out: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamedFull">AddNamedFull()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_add_named_full() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_add_named_full_sync (
    XdpDocuments *proxy,
    GVariant *arg_o_path_fd,
    const gchar *arg_filename,
    guint arg_flags,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GUnixFDList  *fd_list,
    gchar **out_doc_id,
    GVariant **out_extra_out,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AddNamedFull",
    g_variant_new ("(@h^ayus^as)",
                   arg_o_path_fd,
                   arg_filename,
                   arg_flags,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s@a{sv})",
                 out_doc_id,
                 out_extra_out);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_grant_permissions:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GrantPermissions">GrantPermissions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_grant_permissions_finish() to get the result of the operation.
 *
 * See xdp_documents_call_grant_permissions_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_grant_permissions (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GrantPermissions",
    g_variant_new ("(ss^as)",
                   arg_doc_id,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_grant_permissions_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_grant_permissions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_grant_permissions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_grant_permissions_finish (
    XdpDocuments *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_grant_permissions_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GrantPermissions">GrantPermissions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_grant_permissions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_grant_permissions_sync (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GrantPermissions",
    g_variant_new ("(ss^as)",
                   arg_doc_id,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_revoke_permissions:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.RevokePermissions">RevokePermissions()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_revoke_permissions_finish() to get the result of the operation.
 *
 * See xdp_documents_call_revoke_permissions_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_revoke_permissions (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RevokePermissions",
    g_variant_new ("(ss^as)",
                   arg_doc_id,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_revoke_permissions_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_revoke_permissions().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_revoke_permissions().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_revoke_permissions_finish (
    XdpDocuments *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_revoke_permissions_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.RevokePermissions">RevokePermissions()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_revoke_permissions() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_revoke_permissions_sync (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    const gchar *arg_app_id,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RevokePermissions",
    g_variant_new ("(ss^as)",
                   arg_doc_id,
                   arg_app_id,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_delete:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_delete_finish() to get the result of the operation.
 *
 * See xdp_documents_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_delete (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(s)",
                   arg_doc_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_delete_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_delete_finish (
    XdpDocuments *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_delete_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_delete_sync (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(s)",
                   arg_doc_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_lookup:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Lookup">Lookup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_lookup_finish() to get the result of the operation.
 *
 * See xdp_documents_call_lookup_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_lookup (
    XdpDocuments *proxy,
    const gchar *arg_filename,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(^ay)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_lookup_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_lookup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_lookup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_lookup_finish (
    XdpDocuments *proxy,
    gchar **out_doc_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_doc_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_lookup_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_filename: Argument to pass with the method invocation.
 * @out_doc_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Lookup">Lookup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_lookup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_lookup_sync (
    XdpDocuments *proxy,
    const gchar *arg_filename,
    gchar **out_doc_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(^ay)",
                   arg_filename),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_doc_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_info:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Info">Info()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_info_finish() to get the result of the operation.
 *
 * See xdp_documents_call_info_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_info (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(s)",
                   arg_doc_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_info_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_info_finish (
    XdpDocuments *proxy,
    gchar **out_path,
    GVariant **out_apps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay@a{sas})",
                 out_path,
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_info_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_doc_id: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Info">Info()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_info_sync (
    XdpDocuments *proxy,
    const gchar *arg_doc_id,
    gchar **out_path,
    GVariant **out_apps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Info",
    g_variant_new ("(s)",
                   arg_doc_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ay@a{sas})",
                 out_path,
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_list:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_call_list_finish() to get the result of the operation.
 *
 * See xdp_documents_call_list_sync() for the synchronous, blocking version of this method.
 */
void
xdp_documents_call_list (
    XdpDocuments *proxy,
    const gchar *arg_app_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_app_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_documents_call_list_finish:
 * @proxy: A #XdpDocumentsProxy.
 * @out_docs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_documents_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_list_finish (
    XdpDocuments *proxy,
    GVariant **out_docs,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{say})",
                 out_docs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_call_list_sync:
 * @proxy: A #XdpDocumentsProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @out_docs: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Documents.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_documents_call_list_sync (
    XdpDocuments *proxy,
    const gchar *arg_app_id,
    GVariant **out_docs,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_app_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{say})",
                 out_docs);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_documents_complete_get_mount_point:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GetMountPoint">GetMountPoint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_get_mount_point (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ay)",
                   path));
}

/**
 * xdp_documents_complete_add:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @doc_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Add">Add()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_add (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *doc_id)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(s)",
                   doc_id),
    fd_list);
}

/**
 * xdp_documents_complete_add_named:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @doc_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamed">AddNamed()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_add_named (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *doc_id)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(s)",
                   doc_id),
    fd_list);
}

/**
 * xdp_documents_complete_add_full:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @doc_ids: Parameter to return.
 * @extra_out: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddFull">AddFull()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_add_full (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *const *doc_ids,
    GVariant *extra_out)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(^as@a{sv})",
                   doc_ids,
                   extra_out),
    fd_list);
}

/**
 * xdp_documents_complete_add_named_full:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @doc_id: Parameter to return.
 * @extra_out: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.AddNamedFull">AddNamedFull()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_add_named_full (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *doc_id,
    GVariant *extra_out)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(s@a{sv})",
                   doc_id,
                   extra_out),
    fd_list);
}

/**
 * xdp_documents_complete_grant_permissions:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.GrantPermissions">GrantPermissions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_grant_permissions (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_documents_complete_revoke_permissions:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.RevokePermissions">RevokePermissions()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_revoke_permissions (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_documents_complete_delete:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_delete (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_documents_complete_lookup:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @doc_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Lookup">Lookup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_lookup (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *doc_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   doc_id));
}

/**
 * xdp_documents_complete_info:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 * @apps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.Info">Info()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_info (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path,
    GVariant *apps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ay@a{sas})",
                   path,
                   apps));
}

/**
 * xdp_documents_complete_list:
 * @object: A #XdpDocuments.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @docs: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Documents.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_documents_complete_list (
    XdpDocuments *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *docs)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{say})",
                   docs));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDocumentsProxy:
 *
 * The #XdpDocumentsProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDocumentsProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDocumentsProxy.
 */

struct _XdpDocumentsProxyPrivate
{
  GData *qdata;
};

static void xdp_documents_proxy_iface_init (XdpDocumentsIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDocumentsProxy, xdp_documents_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDocumentsProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DOCUMENTS, xdp_documents_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDocumentsProxy, xdp_documents_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DOCUMENTS, xdp_documents_proxy_iface_init))

#endif
static void
xdp_documents_proxy_finalize (GObject *object)
{
  XdpDocumentsProxy *proxy = XDP_DOCUMENTS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_documents_proxy_parent_class)->finalize (object);
}

static void
xdp_documents_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_documents_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_documents_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Documents: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_documents_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_documents_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Documents", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_documents_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_documents_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_documents_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_DOCUMENTS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_DOCUMENTS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_documents_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDocumentsProxy *proxy = XDP_DOCUMENTS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_documents_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_documents_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_documents_proxy_get_version (XdpDocuments *object)
{
  XdpDocumentsProxy *proxy = XDP_DOCUMENTS_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_documents_proxy_init (XdpDocumentsProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_documents_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_DOCUMENTS_PROXY, XdpDocumentsProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_documents_interface_info ());
}

static void
xdp_documents_proxy_class_init (XdpDocumentsProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_documents_proxy_finalize;
  gobject_class->get_property = xdp_documents_proxy_get_property;
  gobject_class->set_property = xdp_documents_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_documents_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_documents_proxy_g_properties_changed;

  xdp_documents_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDocumentsProxyPrivate));
#endif
}

static void
xdp_documents_proxy_iface_init (XdpDocumentsIface *iface)
{
  iface->get_version = xdp_documents_proxy_get_version;
}

/**
 * xdp_documents_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_documents_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_documents_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_DOCUMENTS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Documents", NULL);
}

/**
 * xdp_documents_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_documents_proxy_new().
 *
 * Returns: (transfer full) (type XdpDocumentsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDocuments *
xdp_documents_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DOCUMENTS (ret);
  else
    return NULL;
}

/**
 * xdp_documents_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDocumentsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDocuments *
xdp_documents_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_DOCUMENTS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Documents", NULL);
  if (ret != NULL)
    return XDP_DOCUMENTS (ret);
  else
    return NULL;
}


/**
 * xdp_documents_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_documents_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_documents_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_documents_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_documents_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_DOCUMENTS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Documents", NULL);
}

/**
 * xdp_documents_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_documents_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_documents_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDocumentsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDocuments *
xdp_documents_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DOCUMENTS (ret);
  else
    return NULL;
}

/**
 * xdp_documents_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_documents_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_documents_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDocumentsProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDocuments *
xdp_documents_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_DOCUMENTS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Documents", NULL);
  if (ret != NULL)
    return XDP_DOCUMENTS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDocumentsSkeleton:
 *
 * The #XdpDocumentsSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDocumentsSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDocumentsSkeleton.
 */

struct _XdpDocumentsSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_documents_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_DOCUMENTS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_DOCUMENTS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_documents_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_documents_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_documents_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_documents_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_documents_skeleton_vtable =
{
  _xdp_documents_skeleton_handle_method_call,
  _xdp_documents_skeleton_handle_get_property,
  _xdp_documents_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_documents_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_documents_interface_info ();
}

static GDBusInterfaceVTable *
xdp_documents_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_documents_skeleton_vtable;
}

static GVariant *
xdp_documents_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_documents_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_documents_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_documents_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_documents_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Documents", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_documents_emit_changed (gpointer user_data);

static void
xdp_documents_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_documents_emit_changed (skeleton);
}

static void xdp_documents_skeleton_iface_init (XdpDocumentsIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDocumentsSkeleton, xdp_documents_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDocumentsSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DOCUMENTS, xdp_documents_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDocumentsSkeleton, xdp_documents_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DOCUMENTS, xdp_documents_skeleton_iface_init))

#endif
static void
xdp_documents_skeleton_finalize (GObject *object)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_documents_skeleton_parent_class)->finalize (object);
}

static void
xdp_documents_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_documents_emit_changed (gpointer user_data)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Documents",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_documents_schedule_emit_changed (XdpDocumentsSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_documents_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_documents_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_documents_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_documents_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_documents_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_documents_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_documents_skeleton_init (XdpDocumentsSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_documents_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_DOCUMENTS_SKELETON, XdpDocumentsSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_documents_skeleton_get_version (XdpDocuments *object)
{
  XdpDocumentsSkeleton *skeleton = XDP_DOCUMENTS_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_documents_skeleton_class_init (XdpDocumentsSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_documents_skeleton_finalize;
  gobject_class->get_property = xdp_documents_skeleton_get_property;
  gobject_class->set_property = xdp_documents_skeleton_set_property;
  gobject_class->notify       = xdp_documents_skeleton_notify;


  xdp_documents_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_documents_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_documents_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_documents_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_documents_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDocumentsSkeletonPrivate));
#endif
}

static void
xdp_documents_skeleton_iface_init (XdpDocumentsIface *iface)
{
  iface->get_version = xdp_documents_skeleton_get_version;
}

/**
 * xdp_documents_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Documents.top_of_page">org.freedesktop.portal.Documents</link>.
 *
 * Returns: (transfer full) (type XdpDocumentsSkeleton): The skeleton object.
 */
XdpDocuments *
xdp_documents_skeleton_new (void)
{
  return XDP_DOCUMENTS (g_object_new (XDP_TYPE_DOCUMENTS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.DynamicLauncher
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDynamicLauncher
 * @title: XdpDynamicLauncher
 * @short_description: Generated C code for the org.freedesktop.portal.DynamicLauncher D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.DynamicLauncher ---- */

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_install_IN_ARG_token =
{
  {
    -1,
    (gchar *) "token",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_install_IN_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_install_IN_ARG_desktop_entry =
{
  {
    -1,
    (gchar *) "desktop_entry",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_install_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_install_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_install_IN_ARG_token.parent_struct,
  &_xdp_dynamic_launcher_method_info_install_IN_ARG_desktop_file_id.parent_struct,
  &_xdp_dynamic_launcher_method_info_install_IN_ARG_desktop_entry.parent_struct,
  &_xdp_dynamic_launcher_method_info_install_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_install =
{
  {
    -1,
    (gchar *) "Install",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_install_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_icon_v =
{
  {
    -1,
    (gchar *) "icon_v",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_parent_window.parent_struct,
  &_xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_name.parent_struct,
  &_xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_icon_v.parent_struct,
  &_xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_prepare_install_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_prepare_install_OUT_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_prepare_install_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_prepare_install =
{
  {
    -1,
    (gchar *) "PrepareInstall",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_prepare_install_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_prepare_install_OUT_ARG_pointers,
    NULL
  },
  "handle-prepare-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_icon_v =
{
  {
    -1,
    (gchar *) "icon_v",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_name.parent_struct,
  &_xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_icon_v.parent_struct,
  &_xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_request_install_token_OUT_ARG_token =
{
  {
    -1,
    (gchar *) "token",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_request_install_token_OUT_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_request_install_token_OUT_ARG_token.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_request_install_token =
{
  {
    -1,
    (gchar *) "RequestInstallToken",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_request_install_token_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_request_install_token_OUT_ARG_pointers,
    NULL
  },
  "handle-request-install-token",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_uninstall_IN_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_uninstall_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_uninstall_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_uninstall_IN_ARG_desktop_file_id.parent_struct,
  &_xdp_dynamic_launcher_method_info_uninstall_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_uninstall =
{
  {
    -1,
    (gchar *) "Uninstall",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_uninstall_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-uninstall",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_get_desktop_entry_IN_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_get_desktop_entry_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_get_desktop_entry_IN_ARG_desktop_file_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_get_desktop_entry_OUT_ARG_contents =
{
  {
    -1,
    (gchar *) "contents",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_get_desktop_entry_OUT_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_get_desktop_entry_OUT_ARG_contents.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_get_desktop_entry =
{
  {
    -1,
    (gchar *) "GetDesktopEntry",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_get_desktop_entry_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_get_desktop_entry_OUT_ARG_pointers,
    NULL
  },
  "handle-get-desktop-entry",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_get_icon_IN_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_get_icon_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_get_icon_IN_ARG_desktop_file_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_icon_v =
{
  {
    -1,
    (gchar *) "icon_v",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_icon_format =
{
  {
    -1,
    (gchar *) "icon_format",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_icon_size =
{
  {
    -1,
    (gchar *) "icon_size",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_icon_v.parent_struct,
  &_xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_icon_format.parent_struct,
  &_xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_icon_size.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_get_icon =
{
  {
    -1,
    (gchar *) "GetIcon",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_get_icon_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_get_icon_OUT_ARG_pointers,
    NULL
  },
  "handle-get-icon",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_launch_IN_ARG_desktop_file_id =
{
  {
    -1,
    (gchar *) "desktop_file_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dynamic_launcher_method_info_launch_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dynamic_launcher_method_info_launch_IN_ARG_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_launch_IN_ARG_desktop_file_id.parent_struct,
  &_xdp_dynamic_launcher_method_info_launch_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dynamic_launcher_method_info_launch =
{
  {
    -1,
    (gchar *) "Launch",
    (GDBusArgInfo **) &_xdp_dynamic_launcher_method_info_launch_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-launch",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dynamic_launcher_method_info_pointers[] =
{
  &_xdp_dynamic_launcher_method_info_install.parent_struct,
  &_xdp_dynamic_launcher_method_info_prepare_install.parent_struct,
  &_xdp_dynamic_launcher_method_info_request_install_token.parent_struct,
  &_xdp_dynamic_launcher_method_info_uninstall.parent_struct,
  &_xdp_dynamic_launcher_method_info_get_desktop_entry.parent_struct,
  &_xdp_dynamic_launcher_method_info_get_icon.parent_struct,
  &_xdp_dynamic_launcher_method_info_launch.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dynamic_launcher_property_info_supported_launcher_types =
{
  {
    -1,
    (gchar *) "SupportedLauncherTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-launcher-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dynamic_launcher_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dynamic_launcher_property_info_pointers[] =
{
  &_xdp_dynamic_launcher_property_info_supported_launcher_types.parent_struct,
  &_xdp_dynamic_launcher_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dynamic_launcher_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.DynamicLauncher",
    (GDBusMethodInfo **) &_xdp_dynamic_launcher_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dynamic_launcher_property_info_pointers,
    NULL
  },
  "dynamic-launcher",
};


/**
 * xdp_dynamic_launcher_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dynamic_launcher_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dynamic_launcher_interface_info.parent_struct;
}

/**
 * xdp_dynamic_launcher_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDynamicLauncher interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dynamic_launcher_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-launcher-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDynamicLauncher:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link>.
 */

/**
 * XdpDynamicLauncherIface:
 * @parent_iface: The parent interface.
 * @handle_get_desktop_entry: Handler for the #XdpDynamicLauncher::handle-get-desktop-entry signal.
 * @handle_get_icon: Handler for the #XdpDynamicLauncher::handle-get-icon signal.
 * @handle_install: Handler for the #XdpDynamicLauncher::handle-install signal.
 * @handle_launch: Handler for the #XdpDynamicLauncher::handle-launch signal.
 * @handle_prepare_install: Handler for the #XdpDynamicLauncher::handle-prepare-install signal.
 * @handle_request_install_token: Handler for the #XdpDynamicLauncher::handle-request-install-token signal.
 * @handle_uninstall: Handler for the #XdpDynamicLauncher::handle-uninstall signal.
 * @get_supported_launcher_types: Getter for the #XdpDynamicLauncher:supported-launcher-types property.
 * @get_version: Getter for the #XdpDynamicLauncher:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link>.
 */

typedef XdpDynamicLauncherIface XdpDynamicLauncherInterface;
G_DEFINE_INTERFACE (XdpDynamicLauncher, xdp_dynamic_launcher, G_TYPE_OBJECT)

static void
xdp_dynamic_launcher_default_init (XdpDynamicLauncherIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDynamicLauncher::handle-install:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_token: Argument passed by remote caller.
   * @arg_desktop_file_id: Argument passed by remote caller.
   * @arg_desktop_entry: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Install">Install()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_install),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDynamicLauncher::handle-prepare-install:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_icon_v: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_prepare_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prepare-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_prepare_install),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpDynamicLauncher::handle-request-install-token:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_name: Argument passed by remote caller.
   * @arg_icon_v: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_request_install_token() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-install-token",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_request_install_token),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpDynamicLauncher::handle-uninstall:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_desktop_file_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Uninstall">Uninstall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_uninstall() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-uninstall",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_uninstall),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDynamicLauncher::handle-get-desktop-entry:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_desktop_file_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetDesktopEntry">GetDesktopEntry()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_get_desktop_entry() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-desktop-entry",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_get_desktop_entry),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XdpDynamicLauncher::handle-get-icon:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_desktop_file_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetIcon">GetIcon()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_get_icon() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-icon",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_get_icon),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XdpDynamicLauncher::handle-launch:
   * @object: A #XdpDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_desktop_file_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Launch">Launch()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dynamic_launcher_complete_launch() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-launch",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDynamicLauncherIface, handle_launch),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDynamicLauncher:supported-launcher-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-launcher-types", "SupportedLauncherTypes", "SupportedLauncherTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDynamicLauncher:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-DynamicLauncher.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dynamic_launcher_get_supported_launcher_types: (skip)
 * @object: A #XdpDynamicLauncher.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dynamic_launcher_get_supported_launcher_types (XdpDynamicLauncher *object)
{
  return XDP_DYNAMIC_LAUNCHER_GET_IFACE (object)->get_supported_launcher_types (object);
}

/**
 * xdp_dynamic_launcher_set_supported_launcher_types: (skip)
 * @object: A #XdpDynamicLauncher.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dynamic_launcher_set_supported_launcher_types (XdpDynamicLauncher *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-launcher-types", value, NULL);
}

/**
 * xdp_dynamic_launcher_get_version: (skip)
 * @object: A #XdpDynamicLauncher.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-DynamicLauncher.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dynamic_launcher_get_version (XdpDynamicLauncher *object)
{
  return XDP_DYNAMIC_LAUNCHER_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_dynamic_launcher_set_version: (skip)
 * @object: A #XdpDynamicLauncher.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-DynamicLauncher.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dynamic_launcher_set_version (XdpDynamicLauncher *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_dynamic_launcher_call_install:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_token: Argument to pass with the method invocation.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @arg_desktop_entry: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Install">Install()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_install_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_install_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_install (
    XdpDynamicLauncher *proxy,
    const gchar *arg_token,
    const gchar *arg_desktop_file_id,
    const gchar *arg_desktop_entry,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(sss@a{sv})",
                   arg_token,
                   arg_desktop_file_id,
                   arg_desktop_entry,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_install_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_install_finish (
    XdpDynamicLauncher *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_install_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_token: Argument to pass with the method invocation.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @arg_desktop_entry: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Install">Install()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_install_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_token,
    const gchar *arg_desktop_file_id,
    const gchar *arg_desktop_entry,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Install",
    g_variant_new ("(sss@a{sv})",
                   arg_token,
                   arg_desktop_file_id,
                   arg_desktop_entry,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_prepare_install:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_prepare_install_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_prepare_install_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_prepare_install (
    XdpDynamicLauncher *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PrepareInstall",
    g_variant_new ("(ss@v@a{sv})",
                   arg_parent_window,
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_prepare_install_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_prepare_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_prepare_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_prepare_install_finish (
    XdpDynamicLauncher *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_prepare_install_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_prepare_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_prepare_install_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PrepareInstall",
    g_variant_new ("(ss@v@a{sv})",
                   arg_parent_window,
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_request_install_token:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_request_install_token_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_request_install_token_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_request_install_token (
    XdpDynamicLauncher *proxy,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestInstallToken",
    g_variant_new ("(s@v@a{sv})",
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_request_install_token_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @out_token: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_request_install_token().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_request_install_token().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_request_install_token_finish (
    XdpDynamicLauncher *proxy,
    gchar **out_token,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_token);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_request_install_token_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_token: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_request_install_token() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_request_install_token_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    gchar **out_token,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestInstallToken",
    g_variant_new ("(s@v@a{sv})",
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_token);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_uninstall:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Uninstall">Uninstall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_uninstall_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_uninstall_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_uninstall (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Uninstall",
    g_variant_new ("(s@a{sv})",
                   arg_desktop_file_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_uninstall_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_uninstall().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_uninstall().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_uninstall_finish (
    XdpDynamicLauncher *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_uninstall_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Uninstall">Uninstall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_uninstall() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_uninstall_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Uninstall",
    g_variant_new ("(s@a{sv})",
                   arg_desktop_file_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_get_desktop_entry:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetDesktopEntry">GetDesktopEntry()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_get_desktop_entry_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_get_desktop_entry_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_get_desktop_entry (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetDesktopEntry",
    g_variant_new ("(s)",
                   arg_desktop_file_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_get_desktop_entry_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @out_contents: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_get_desktop_entry().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_get_desktop_entry().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_get_desktop_entry_finish (
    XdpDynamicLauncher *proxy,
    gchar **out_contents,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_contents);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_get_desktop_entry_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @out_contents: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetDesktopEntry">GetDesktopEntry()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_get_desktop_entry() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_get_desktop_entry_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    gchar **out_contents,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetDesktopEntry",
    g_variant_new ("(s)",
                   arg_desktop_file_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_contents);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_get_icon:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetIcon">GetIcon()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_get_icon_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_get_icon_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_get_icon (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetIcon",
    g_variant_new ("(s)",
                   arg_desktop_file_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_get_icon_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @out_icon_v: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_icon_format: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_icon_size: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_get_icon().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_get_icon().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_get_icon_finish (
    XdpDynamicLauncher *proxy,
    GVariant **out_icon_v,
    gchar **out_icon_format,
    guint *out_icon_size,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@vsu)",
                 out_icon_v,
                 out_icon_format,
                 out_icon_size);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_get_icon_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @out_icon_v: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_icon_format: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_icon_size: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetIcon">GetIcon()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_get_icon() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_get_icon_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GVariant **out_icon_v,
    gchar **out_icon_format,
    guint *out_icon_size,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetIcon",
    g_variant_new ("(s)",
                   arg_desktop_file_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@vsu)",
                 out_icon_v,
                 out_icon_format,
                 out_icon_size);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_launch:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Launch">Launch()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_call_launch_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_call_launch_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dynamic_launcher_call_launch (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Launch",
    g_variant_new ("(s@a{sv})",
                   arg_desktop_file_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dynamic_launcher_call_launch_finish:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_call_launch().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dynamic_launcher_call_launch().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_launch_finish (
    XdpDynamicLauncher *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_call_launch_sync:
 * @proxy: A #XdpDynamicLauncherProxy.
 * @arg_desktop_file_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Launch">Launch()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_call_launch() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dynamic_launcher_call_launch_sync (
    XdpDynamicLauncher *proxy,
    const gchar *arg_desktop_file_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Launch",
    g_variant_new ("(s@a{sv})",
                   arg_desktop_file_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dynamic_launcher_complete_install:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Install">Install()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_install (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dynamic_launcher_complete_prepare_install:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_prepare_install (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_dynamic_launcher_complete_request_install_token:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @token: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_request_install_token (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *token)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   token));
}

/**
 * xdp_dynamic_launcher_complete_uninstall:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Uninstall">Uninstall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_uninstall (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dynamic_launcher_complete_get_desktop_entry:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @contents: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetDesktopEntry">GetDesktopEntry()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_get_desktop_entry (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *contents)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   contents));
}

/**
 * xdp_dynamic_launcher_complete_get_icon:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @icon_v: Parameter to return.
 * @icon_format: Parameter to return.
 * @icon_size: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.GetIcon">GetIcon()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_get_icon (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *icon_v,
    const gchar *icon_format,
    guint icon_size)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@vsu)",
                   icon_v,
                   icon_format,
                   icon_size));
}

/**
 * xdp_dynamic_launcher_complete_launch:
 * @object: A #XdpDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-DynamicLauncher.Launch">Launch()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dynamic_launcher_complete_launch (
    XdpDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDynamicLauncherProxy:
 *
 * The #XdpDynamicLauncherProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDynamicLauncherProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDynamicLauncherProxy.
 */

struct _XdpDynamicLauncherProxyPrivate
{
  GData *qdata;
};

static void xdp_dynamic_launcher_proxy_iface_init (XdpDynamicLauncherIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDynamicLauncherProxy, xdp_dynamic_launcher_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDynamicLauncherProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DYNAMIC_LAUNCHER, xdp_dynamic_launcher_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDynamicLauncherProxy, xdp_dynamic_launcher_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DYNAMIC_LAUNCHER, xdp_dynamic_launcher_proxy_iface_init))

#endif
static void
xdp_dynamic_launcher_proxy_finalize (GObject *object)
{
  XdpDynamicLauncherProxy *proxy = XDP_DYNAMIC_LAUNCHER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dynamic_launcher_proxy_parent_class)->finalize (object);
}

static void
xdp_dynamic_launcher_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dynamic_launcher_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dynamic_launcher_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.DynamicLauncher: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dynamic_launcher_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dynamic_launcher_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.DynamicLauncher", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dynamic_launcher_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dynamic_launcher_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dynamic_launcher_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_DYNAMIC_LAUNCHER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_DYNAMIC_LAUNCHER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dynamic_launcher_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDynamicLauncherProxy *proxy = XDP_DYNAMIC_LAUNCHER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dynamic_launcher_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dynamic_launcher_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_dynamic_launcher_proxy_get_supported_launcher_types (XdpDynamicLauncher *object)
{
  XdpDynamicLauncherProxy *proxy = XDP_DYNAMIC_LAUNCHER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedLauncherTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_dynamic_launcher_proxy_get_version (XdpDynamicLauncher *object)
{
  XdpDynamicLauncherProxy *proxy = XDP_DYNAMIC_LAUNCHER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dynamic_launcher_proxy_init (XdpDynamicLauncherProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dynamic_launcher_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_DYNAMIC_LAUNCHER_PROXY, XdpDynamicLauncherProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dynamic_launcher_interface_info ());
}

static void
xdp_dynamic_launcher_proxy_class_init (XdpDynamicLauncherProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dynamic_launcher_proxy_finalize;
  gobject_class->get_property = xdp_dynamic_launcher_proxy_get_property;
  gobject_class->set_property = xdp_dynamic_launcher_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dynamic_launcher_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dynamic_launcher_proxy_g_properties_changed;

  xdp_dynamic_launcher_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDynamicLauncherProxyPrivate));
#endif
}

static void
xdp_dynamic_launcher_proxy_iface_init (XdpDynamicLauncherIface *iface)
{
  iface->get_supported_launcher_types = xdp_dynamic_launcher_proxy_get_supported_launcher_types;
  iface->get_version = xdp_dynamic_launcher_proxy_get_version;
}

/**
 * xdp_dynamic_launcher_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dynamic_launcher_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_DYNAMIC_LAUNCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.DynamicLauncher", NULL);
}

/**
 * xdp_dynamic_launcher_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dynamic_launcher_proxy_new().
 *
 * Returns: (transfer full) (type XdpDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDynamicLauncher *
xdp_dynamic_launcher_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}

/**
 * xdp_dynamic_launcher_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDynamicLauncher *
xdp_dynamic_launcher_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_DYNAMIC_LAUNCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.DynamicLauncher", NULL);
  if (ret != NULL)
    return XDP_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}


/**
 * xdp_dynamic_launcher_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dynamic_launcher_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dynamic_launcher_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dynamic_launcher_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dynamic_launcher_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_DYNAMIC_LAUNCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.DynamicLauncher", NULL);
}

/**
 * xdp_dynamic_launcher_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dynamic_launcher_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dynamic_launcher_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDynamicLauncher *
xdp_dynamic_launcher_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}

/**
 * xdp_dynamic_launcher_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dynamic_launcher_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dynamic_launcher_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDynamicLauncher *
xdp_dynamic_launcher_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_DYNAMIC_LAUNCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.DynamicLauncher", NULL);
  if (ret != NULL)
    return XDP_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDynamicLauncherSkeleton:
 *
 * The #XdpDynamicLauncherSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDynamicLauncherSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDynamicLauncherSkeleton.
 */

struct _XdpDynamicLauncherSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dynamic_launcher_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_DYNAMIC_LAUNCHER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_DYNAMIC_LAUNCHER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dynamic_launcher_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dynamic_launcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dynamic_launcher_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dynamic_launcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dynamic_launcher_skeleton_vtable =
{
  _xdp_dynamic_launcher_skeleton_handle_method_call,
  _xdp_dynamic_launcher_skeleton_handle_get_property,
  _xdp_dynamic_launcher_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dynamic_launcher_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dynamic_launcher_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dynamic_launcher_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dynamic_launcher_skeleton_vtable;
}

static GVariant *
xdp_dynamic_launcher_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dynamic_launcher_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dynamic_launcher_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dynamic_launcher_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dynamic_launcher_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.DynamicLauncher", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dynamic_launcher_emit_changed (gpointer user_data);

static void
xdp_dynamic_launcher_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dynamic_launcher_emit_changed (skeleton);
}

static void xdp_dynamic_launcher_skeleton_iface_init (XdpDynamicLauncherIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDynamicLauncherSkeleton, xdp_dynamic_launcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDynamicLauncherSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DYNAMIC_LAUNCHER, xdp_dynamic_launcher_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDynamicLauncherSkeleton, xdp_dynamic_launcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_DYNAMIC_LAUNCHER, xdp_dynamic_launcher_skeleton_iface_init))

#endif
static void
xdp_dynamic_launcher_skeleton_finalize (GObject *object)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dynamic_launcher_skeleton_parent_class)->finalize (object);
}

static void
xdp_dynamic_launcher_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dynamic_launcher_emit_changed (gpointer user_data)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.DynamicLauncher",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dynamic_launcher_schedule_emit_changed (XdpDynamicLauncherSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dynamic_launcher_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dynamic_launcher_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dynamic_launcher_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dynamic_launcher_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dynamic_launcher_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dynamic_launcher_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dynamic_launcher_skeleton_init (XdpDynamicLauncherSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dynamic_launcher_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_DYNAMIC_LAUNCHER_SKELETON, XdpDynamicLauncherSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static guint 
xdp_dynamic_launcher_skeleton_get_supported_launcher_types (XdpDynamicLauncher *object)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_dynamic_launcher_skeleton_get_version (XdpDynamicLauncher *object)
{
  XdpDynamicLauncherSkeleton *skeleton = XDP_DYNAMIC_LAUNCHER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dynamic_launcher_skeleton_class_init (XdpDynamicLauncherSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dynamic_launcher_skeleton_finalize;
  gobject_class->get_property = xdp_dynamic_launcher_skeleton_get_property;
  gobject_class->set_property = xdp_dynamic_launcher_skeleton_set_property;
  gobject_class->notify       = xdp_dynamic_launcher_skeleton_notify;


  xdp_dynamic_launcher_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dynamic_launcher_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dynamic_launcher_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dynamic_launcher_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dynamic_launcher_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDynamicLauncherSkeletonPrivate));
#endif
}

static void
xdp_dynamic_launcher_skeleton_iface_init (XdpDynamicLauncherIface *iface)
{
  iface->get_supported_launcher_types = xdp_dynamic_launcher_skeleton_get_supported_launcher_types;
  iface->get_version = xdp_dynamic_launcher_skeleton_get_version;
}

/**
 * xdp_dynamic_launcher_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-DynamicLauncher.top_of_page">org.freedesktop.portal.DynamicLauncher</link>.
 *
 * Returns: (transfer full) (type XdpDynamicLauncherSkeleton): The skeleton object.
 */
XdpDynamicLauncher *
xdp_dynamic_launcher_skeleton_new (void)
{
  return XDP_DYNAMIC_LAUNCHER (g_object_new (XDP_TYPE_DYNAMIC_LAUNCHER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Email
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpEmail
 * @title: XdpEmail
 * @short_description: Generated C code for the org.freedesktop.portal.Email D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Email ---- */

static const _ExtendedGDBusArgInfo _xdp_email_method_info_compose_email_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_email_method_info_compose_email_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_email_method_info_compose_email_IN_ARG_pointers[] =
{
  &_xdp_email_method_info_compose_email_IN_ARG_parent_window.parent_struct,
  &_xdp_email_method_info_compose_email_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_email_method_info_compose_email_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_email_method_info_compose_email_OUT_ARG_pointers[] =
{
  &_xdp_email_method_info_compose_email_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_email_method_info_compose_email =
{
  {
    -1,
    (gchar *) "ComposeEmail",
    (GDBusArgInfo **) &_xdp_email_method_info_compose_email_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_email_method_info_compose_email_OUT_ARG_pointers,
    NULL
  },
  "handle-compose-email",
  TRUE
};

static const GDBusMethodInfo * const _xdp_email_method_info_pointers[] =
{
  &_xdp_email_method_info_compose_email.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_email_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_email_property_info_pointers[] =
{
  &_xdp_email_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_email_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Email",
    (GDBusMethodInfo **) &_xdp_email_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_email_property_info_pointers,
    NULL
  },
  "email",
};


/**
 * xdp_email_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_email_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_email_interface_info.parent_struct;
}

/**
 * xdp_email_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpEmail interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_email_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpEmail:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link>.
 */

/**
 * XdpEmailIface:
 * @parent_iface: The parent interface.
 * @handle_compose_email: Handler for the #XdpEmail::handle-compose-email signal.
 * @get_version: Getter for the #XdpEmail:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link>.
 */

typedef XdpEmailIface XdpEmailInterface;
G_DEFINE_INTERFACE (XdpEmail, xdp_email, G_TYPE_OBJECT)

static void
xdp_email_default_init (XdpEmailIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpEmail::handle-compose-email:
   * @object: A #XdpEmail.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_email_complete_compose_email() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-compose-email",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpEmailIface, handle_compose_email),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpEmail:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Email.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_email_get_version: (skip)
 * @object: A #XdpEmail.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Email.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_email_get_version (XdpEmail *object)
{
  return XDP_EMAIL_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_email_set_version: (skip)
 * @object: A #XdpEmail.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Email.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_email_set_version (XdpEmail *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_email_call_compose_email:
 * @proxy: A #XdpEmailProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_email_call_compose_email_finish() to get the result of the operation.
 *
 * See xdp_email_call_compose_email_sync() for the synchronous, blocking version of this method.
 */
void
xdp_email_call_compose_email (
    XdpEmail *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "ComposeEmail",
    g_variant_new ("(s@a{sv})",
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_email_call_compose_email_finish:
 * @proxy: A #XdpEmailProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_email_call_compose_email().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_email_call_compose_email().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_email_call_compose_email_finish (
    XdpEmail *proxy,
    gchar **out_handle,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_email_call_compose_email_sync:
 * @proxy: A #XdpEmailProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_email_call_compose_email() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_email_call_compose_email_sync (
    XdpEmail *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    gchar **out_handle,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "ComposeEmail",
    g_variant_new ("(s@a{sv})",
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_email_complete_compose_email:
 * @object: A #XdpEmail.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_email_complete_compose_email (
    XdpEmail *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(o)",
                   handle),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpEmailProxy:
 *
 * The #XdpEmailProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpEmailProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpEmailProxy.
 */

struct _XdpEmailProxyPrivate
{
  GData *qdata;
};

static void xdp_email_proxy_iface_init (XdpEmailIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpEmailProxy, xdp_email_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpEmailProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_EMAIL, xdp_email_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpEmailProxy, xdp_email_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_EMAIL, xdp_email_proxy_iface_init))

#endif
static void
xdp_email_proxy_finalize (GObject *object)
{
  XdpEmailProxy *proxy = XDP_EMAIL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_email_proxy_parent_class)->finalize (object);
}

static void
xdp_email_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_email_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_email_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Email: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_email_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_email_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Email", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_email_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_email_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_email_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_EMAIL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_EMAIL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_email_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpEmailProxy *proxy = XDP_EMAIL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_email_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_email_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_email_proxy_get_version (XdpEmail *object)
{
  XdpEmailProxy *proxy = XDP_EMAIL_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_email_proxy_init (XdpEmailProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_email_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_EMAIL_PROXY, XdpEmailProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_email_interface_info ());
}

static void
xdp_email_proxy_class_init (XdpEmailProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_email_proxy_finalize;
  gobject_class->get_property = xdp_email_proxy_get_property;
  gobject_class->set_property = xdp_email_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_email_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_email_proxy_g_properties_changed;

  xdp_email_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpEmailProxyPrivate));
#endif
}

static void
xdp_email_proxy_iface_init (XdpEmailIface *iface)
{
  iface->get_version = xdp_email_proxy_get_version;
}

/**
 * xdp_email_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_email_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_email_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_email_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_EMAIL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Email", NULL);
}

/**
 * xdp_email_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_email_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_email_proxy_new().
 *
 * Returns: (transfer full) (type XdpEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpEmail *
xdp_email_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_EMAIL (ret);
  else
    return NULL;
}

/**
 * xdp_email_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_email_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpEmail *
xdp_email_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_EMAIL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Email", NULL);
  if (ret != NULL)
    return XDP_EMAIL (ret);
  else
    return NULL;
}


/**
 * xdp_email_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_email_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_email_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_email_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_email_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_EMAIL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Email", NULL);
}

/**
 * xdp_email_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_email_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_email_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpEmail *
xdp_email_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_EMAIL (ret);
  else
    return NULL;
}

/**
 * xdp_email_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_email_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_email_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpEmail *
xdp_email_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_EMAIL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Email", NULL);
  if (ret != NULL)
    return XDP_EMAIL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpEmailSkeleton:
 *
 * The #XdpEmailSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpEmailSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpEmailSkeleton.
 */

struct _XdpEmailSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_email_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_EMAIL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_EMAIL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_email_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_email_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_email_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_email_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_email_skeleton_vtable =
{
  _xdp_email_skeleton_handle_method_call,
  _xdp_email_skeleton_handle_get_property,
  _xdp_email_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_email_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_email_interface_info ();
}

static GDBusInterfaceVTable *
xdp_email_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_email_skeleton_vtable;
}

static GVariant *
xdp_email_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_email_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_email_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_email_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_email_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Email", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_email_emit_changed (gpointer user_data);

static void
xdp_email_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_email_emit_changed (skeleton);
}

static void xdp_email_skeleton_iface_init (XdpEmailIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpEmailSkeleton, xdp_email_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpEmailSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_EMAIL, xdp_email_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpEmailSkeleton, xdp_email_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_EMAIL, xdp_email_skeleton_iface_init))

#endif
static void
xdp_email_skeleton_finalize (GObject *object)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_email_skeleton_parent_class)->finalize (object);
}

static void
xdp_email_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_email_emit_changed (gpointer user_data)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Email",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_email_schedule_emit_changed (XdpEmailSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_email_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_email_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_email_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_email_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_email_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_email_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_email_skeleton_init (XdpEmailSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_email_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_EMAIL_SKELETON, XdpEmailSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_email_skeleton_get_version (XdpEmail *object)
{
  XdpEmailSkeleton *skeleton = XDP_EMAIL_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_email_skeleton_class_init (XdpEmailSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_email_skeleton_finalize;
  gobject_class->get_property = xdp_email_skeleton_get_property;
  gobject_class->set_property = xdp_email_skeleton_set_property;
  gobject_class->notify       = xdp_email_skeleton_notify;


  xdp_email_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_email_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_email_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_email_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_email_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpEmailSkeletonPrivate));
#endif
}

static void
xdp_email_skeleton_iface_init (XdpEmailIface *iface)
{
  iface->get_version = xdp_email_skeleton_get_version;
}

/**
 * xdp_email_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Email.top_of_page">org.freedesktop.portal.Email</link>.
 *
 * Returns: (transfer full) (type XdpEmailSkeleton): The skeleton object.
 */
XdpEmail *
xdp_email_skeleton_new (void)
{
  return XDP_EMAIL (g_object_new (XDP_TYPE_EMAIL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.FileChooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpFileChooser
 * @title: XdpFileChooser
 * @short_description: Generated C code for the org.freedesktop.portal.FileChooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.FileChooser ---- */

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_open_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_open_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_open_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_chooser_method_info_open_file_IN_ARG_pointers[] =
{
  &_xdp_file_chooser_method_info_open_file_IN_ARG_parent_window.parent_struct,
  &_xdp_file_chooser_method_info_open_file_IN_ARG_title.parent_struct,
  &_xdp_file_chooser_method_info_open_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_open_file_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_chooser_method_info_open_file_OUT_ARG_pointers[] =
{
  &_xdp_file_chooser_method_info_open_file_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_chooser_method_info_open_file =
{
  {
    -1,
    (gchar *) "OpenFile",
    (GDBusArgInfo **) &_xdp_file_chooser_method_info_open_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_file_chooser_method_info_open_file_OUT_ARG_pointers,
    NULL
  },
  "handle-open-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_chooser_method_info_save_file_IN_ARG_pointers[] =
{
  &_xdp_file_chooser_method_info_save_file_IN_ARG_parent_window.parent_struct,
  &_xdp_file_chooser_method_info_save_file_IN_ARG_title.parent_struct,
  &_xdp_file_chooser_method_info_save_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_file_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_chooser_method_info_save_file_OUT_ARG_pointers[] =
{
  &_xdp_file_chooser_method_info_save_file_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_chooser_method_info_save_file =
{
  {
    -1,
    (gchar *) "SaveFile",
    (GDBusArgInfo **) &_xdp_file_chooser_method_info_save_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_file_chooser_method_info_save_file_OUT_ARG_pointers,
    NULL
  },
  "handle-save-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_files_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_files_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_files_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_chooser_method_info_save_files_IN_ARG_pointers[] =
{
  &_xdp_file_chooser_method_info_save_files_IN_ARG_parent_window.parent_struct,
  &_xdp_file_chooser_method_info_save_files_IN_ARG_title.parent_struct,
  &_xdp_file_chooser_method_info_save_files_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_file_chooser_method_info_save_files_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_chooser_method_info_save_files_OUT_ARG_pointers[] =
{
  &_xdp_file_chooser_method_info_save_files_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_chooser_method_info_save_files =
{
  {
    -1,
    (gchar *) "SaveFiles",
    (GDBusArgInfo **) &_xdp_file_chooser_method_info_save_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_file_chooser_method_info_save_files_OUT_ARG_pointers,
    NULL
  },
  "handle-save-files",
  FALSE
};

static const GDBusMethodInfo * const _xdp_file_chooser_method_info_pointers[] =
{
  &_xdp_file_chooser_method_info_open_file.parent_struct,
  &_xdp_file_chooser_method_info_save_file.parent_struct,
  &_xdp_file_chooser_method_info_save_files.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_file_chooser_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_file_chooser_property_info_pointers[] =
{
  &_xdp_file_chooser_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_file_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.FileChooser",
    (GDBusMethodInfo **) &_xdp_file_chooser_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_file_chooser_property_info_pointers,
    NULL
  },
  "file-chooser",
};


/**
 * xdp_file_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_file_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_file_chooser_interface_info.parent_struct;
}

/**
 * xdp_file_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpFileChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_file_chooser_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpFileChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link>.
 */

/**
 * XdpFileChooserIface:
 * @parent_iface: The parent interface.
 * @handle_open_file: Handler for the #XdpFileChooser::handle-open-file signal.
 * @handle_save_file: Handler for the #XdpFileChooser::handle-save-file signal.
 * @handle_save_files: Handler for the #XdpFileChooser::handle-save-files signal.
 * @get_version: Getter for the #XdpFileChooser:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link>.
 */

typedef XdpFileChooserIface XdpFileChooserInterface;
G_DEFINE_INTERFACE (XdpFileChooser, xdp_file_chooser, G_TYPE_OBJECT)

static void
xdp_file_chooser_default_init (XdpFileChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpFileChooser::handle-open-file:
   * @object: A #XdpFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_chooser_complete_open_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileChooserIface, handle_open_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpFileChooser::handle-save-file:
   * @object: A #XdpFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_chooser_complete_save_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileChooserIface, handle_save_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpFileChooser::handle-save-files:
   * @object: A #XdpFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_chooser_complete_save_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileChooserIface, handle_save_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpFileChooser:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-FileChooser.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_file_chooser_get_version: (skip)
 * @object: A #XdpFileChooser.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-FileChooser.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_file_chooser_get_version (XdpFileChooser *object)
{
  return XDP_FILE_CHOOSER_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_file_chooser_set_version: (skip)
 * @object: A #XdpFileChooser.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-FileChooser.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_file_chooser_set_version (XdpFileChooser *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_file_chooser_call_open_file:
 * @proxy: A #XdpFileChooserProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_chooser_call_open_file_finish() to get the result of the operation.
 *
 * See xdp_file_chooser_call_open_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_chooser_call_open_file (
    XdpFileChooser *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_chooser_call_open_file_finish:
 * @proxy: A #XdpFileChooserProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_chooser_call_open_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_chooser_call_open_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_chooser_call_open_file_finish (
    XdpFileChooser *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_chooser_call_open_file_sync:
 * @proxy: A #XdpFileChooserProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_chooser_call_open_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_chooser_call_open_file_sync (
    XdpFileChooser *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_chooser_call_save_file:
 * @proxy: A #XdpFileChooserProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_chooser_call_save_file_finish() to get the result of the operation.
 *
 * See xdp_file_chooser_call_save_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_chooser_call_save_file (
    XdpFileChooser *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_chooser_call_save_file_finish:
 * @proxy: A #XdpFileChooserProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_chooser_call_save_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_chooser_call_save_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_chooser_call_save_file_finish (
    XdpFileChooser *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_chooser_call_save_file_sync:
 * @proxy: A #XdpFileChooserProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_chooser_call_save_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_chooser_call_save_file_sync (
    XdpFileChooser *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_chooser_call_save_files:
 * @proxy: A #XdpFileChooserProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_chooser_call_save_files_finish() to get the result of the operation.
 *
 * See xdp_file_chooser_call_save_files_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_chooser_call_save_files (
    XdpFileChooser *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_chooser_call_save_files_finish:
 * @proxy: A #XdpFileChooserProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_chooser_call_save_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_chooser_call_save_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_chooser_call_save_files_finish (
    XdpFileChooser *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_chooser_call_save_files_sync:
 * @proxy: A #XdpFileChooserProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_chooser_call_save_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_chooser_call_save_files_sync (
    XdpFileChooser *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_chooser_complete_open_file:
 * @object: A #XdpFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_chooser_complete_open_file (
    XdpFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_file_chooser_complete_save_file:
 * @object: A #XdpFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_chooser_complete_save_file (
    XdpFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_file_chooser_complete_save_files:
 * @object: A #XdpFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_chooser_complete_save_files (
    XdpFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpFileChooserProxy:
 *
 * The #XdpFileChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpFileChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpFileChooserProxy.
 */

struct _XdpFileChooserProxyPrivate
{
  GData *qdata;
};

static void xdp_file_chooser_proxy_iface_init (XdpFileChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpFileChooserProxy, xdp_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpFileChooserProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_CHOOSER, xdp_file_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpFileChooserProxy, xdp_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_CHOOSER, xdp_file_chooser_proxy_iface_init))

#endif
static void
xdp_file_chooser_proxy_finalize (GObject *object)
{
  XdpFileChooserProxy *proxy = XDP_FILE_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_file_chooser_proxy_parent_class)->finalize (object);
}

static void
xdp_file_chooser_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_file_chooser_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_file_chooser_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.FileChooser: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_file_chooser_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_file_chooser_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.FileChooser", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_file_chooser_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_file_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_file_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_FILE_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_file_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpFileChooserProxy *proxy = XDP_FILE_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_file_chooser_proxy_get_version (XdpFileChooser *object)
{
  XdpFileChooserProxy *proxy = XDP_FILE_CHOOSER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_file_chooser_proxy_init (XdpFileChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_file_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_FILE_CHOOSER_PROXY, XdpFileChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_file_chooser_interface_info ());
}

static void
xdp_file_chooser_proxy_class_init (XdpFileChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_file_chooser_proxy_finalize;
  gobject_class->get_property = xdp_file_chooser_proxy_get_property;
  gobject_class->set_property = xdp_file_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_file_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_file_chooser_proxy_g_properties_changed;

  xdp_file_chooser_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpFileChooserProxyPrivate));
#endif
}

static void
xdp_file_chooser_proxy_iface_init (XdpFileChooserIface *iface)
{
  iface->get_version = xdp_file_chooser_proxy_get_version;
}

/**
 * xdp_file_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_file_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_file_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileChooser", NULL);
}

/**
 * xdp_file_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_file_chooser_proxy_new().
 *
 * Returns: (transfer full) (type XdpFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileChooser *
xdp_file_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_file_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_file_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileChooser *
xdp_file_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileChooser", NULL);
  if (ret != NULL)
    return XDP_FILE_CHOOSER (ret);
  else
    return NULL;
}


/**
 * xdp_file_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_file_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_file_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_file_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileChooser", NULL);
}

/**
 * xdp_file_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_file_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileChooser *
xdp_file_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_file_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_file_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_file_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileChooser *
xdp_file_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileChooser", NULL);
  if (ret != NULL)
    return XDP_FILE_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpFileChooserSkeleton:
 *
 * The #XdpFileChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpFileChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpFileChooserSkeleton.
 */

struct _XdpFileChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_file_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_FILE_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_file_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_file_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_file_chooser_skeleton_vtable =
{
  _xdp_file_chooser_skeleton_handle_method_call,
  _xdp_file_chooser_skeleton_handle_get_property,
  _xdp_file_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_file_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_file_chooser_interface_info ();
}

static GDBusInterfaceVTable *
xdp_file_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_file_chooser_skeleton_vtable;
}

static GVariant *
xdp_file_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_file_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_file_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_file_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_file_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.FileChooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_file_chooser_emit_changed (gpointer user_data);

static void
xdp_file_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_file_chooser_emit_changed (skeleton);
}

static void xdp_file_chooser_skeleton_iface_init (XdpFileChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpFileChooserSkeleton, xdp_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpFileChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_CHOOSER, xdp_file_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpFileChooserSkeleton, xdp_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_CHOOSER, xdp_file_chooser_skeleton_iface_init))

#endif
static void
xdp_file_chooser_skeleton_finalize (GObject *object)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_file_chooser_skeleton_parent_class)->finalize (object);
}

static void
xdp_file_chooser_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_file_chooser_emit_changed (gpointer user_data)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.FileChooser",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_file_chooser_schedule_emit_changed (XdpFileChooserSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_file_chooser_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_file_chooser_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_file_chooser_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_file_chooser_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_file_chooser_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_file_chooser_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_file_chooser_skeleton_init (XdpFileChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_file_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_FILE_CHOOSER_SKELETON, XdpFileChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_file_chooser_skeleton_get_version (XdpFileChooser *object)
{
  XdpFileChooserSkeleton *skeleton = XDP_FILE_CHOOSER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_file_chooser_skeleton_class_init (XdpFileChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_file_chooser_skeleton_finalize;
  gobject_class->get_property = xdp_file_chooser_skeleton_get_property;
  gobject_class->set_property = xdp_file_chooser_skeleton_set_property;
  gobject_class->notify       = xdp_file_chooser_skeleton_notify;


  xdp_file_chooser_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_file_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_file_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_file_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_file_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpFileChooserSkeletonPrivate));
#endif
}

static void
xdp_file_chooser_skeleton_iface_init (XdpFileChooserIface *iface)
{
  iface->get_version = xdp_file_chooser_skeleton_get_version;
}

/**
 * xdp_file_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileChooser.top_of_page">org.freedesktop.portal.FileChooser</link>.
 *
 * Returns: (transfer full) (type XdpFileChooserSkeleton): The skeleton object.
 */
XdpFileChooser *
xdp_file_chooser_skeleton_new (void)
{
  return XDP_FILE_CHOOSER (g_object_new (XDP_TYPE_FILE_CHOOSER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.FileTransfer
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpFileTransfer
 * @title: XdpFileTransfer
 * @short_description: Generated C code for the org.freedesktop.portal.FileTransfer D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.FileTransfer ---- */

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_start_transfer_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_method_info_start_transfer_IN_ARG_pointers[] =
{
  &_xdp_file_transfer_method_info_start_transfer_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_start_transfer_OUT_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_method_info_start_transfer_OUT_ARG_pointers[] =
{
  &_xdp_file_transfer_method_info_start_transfer_OUT_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_transfer_method_info_start_transfer =
{
  {
    -1,
    (gchar *) "StartTransfer",
    (GDBusArgInfo **) &_xdp_file_transfer_method_info_start_transfer_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_file_transfer_method_info_start_transfer_OUT_ARG_pointers,
    NULL
  },
  "handle-start-transfer",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_add_files_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_add_files_IN_ARG_fds =
{
  {
    -1,
    (gchar *) "fds",
    (gchar *) "ah",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_add_files_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_method_info_add_files_IN_ARG_pointers[] =
{
  &_xdp_file_transfer_method_info_add_files_IN_ARG_key.parent_struct,
  &_xdp_file_transfer_method_info_add_files_IN_ARG_fds.parent_struct,
  &_xdp_file_transfer_method_info_add_files_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_transfer_method_info_add_files =
{
  {
    -1,
    (gchar *) "AddFiles",
    (GDBusArgInfo **) &_xdp_file_transfer_method_info_add_files_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-files",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_retrieve_files_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_retrieve_files_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_method_info_retrieve_files_IN_ARG_pointers[] =
{
  &_xdp_file_transfer_method_info_retrieve_files_IN_ARG_key.parent_struct,
  &_xdp_file_transfer_method_info_retrieve_files_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_retrieve_files_OUT_ARG_files =
{
  {
    -1,
    (gchar *) "files",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_method_info_retrieve_files_OUT_ARG_pointers[] =
{
  &_xdp_file_transfer_method_info_retrieve_files_OUT_ARG_files.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_transfer_method_info_retrieve_files =
{
  {
    -1,
    (gchar *) "RetrieveFiles",
    (GDBusArgInfo **) &_xdp_file_transfer_method_info_retrieve_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_file_transfer_method_info_retrieve_files_OUT_ARG_pointers,
    NULL
  },
  "handle-retrieve-files",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_method_info_stop_transfer_IN_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_method_info_stop_transfer_IN_ARG_pointers[] =
{
  &_xdp_file_transfer_method_info_stop_transfer_IN_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_file_transfer_method_info_stop_transfer =
{
  {
    -1,
    (gchar *) "StopTransfer",
    (GDBusArgInfo **) &_xdp_file_transfer_method_info_stop_transfer_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-stop-transfer",
  FALSE
};

static const GDBusMethodInfo * const _xdp_file_transfer_method_info_pointers[] =
{
  &_xdp_file_transfer_method_info_start_transfer.parent_struct,
  &_xdp_file_transfer_method_info_add_files.parent_struct,
  &_xdp_file_transfer_method_info_retrieve_files.parent_struct,
  &_xdp_file_transfer_method_info_stop_transfer.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_file_transfer_signal_info_transfer_closed_ARG_key =
{
  {
    -1,
    (gchar *) "key",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_file_transfer_signal_info_transfer_closed_ARG_pointers[] =
{
  &_xdp_file_transfer_signal_info_transfer_closed_ARG_key.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_file_transfer_signal_info_transfer_closed =
{
  {
    -1,
    (gchar *) "TransferClosed",
    (GDBusArgInfo **) &_xdp_file_transfer_signal_info_transfer_closed_ARG_pointers,
    NULL
  },
  "transfer-closed"
};

static const GDBusSignalInfo * const _xdp_file_transfer_signal_info_pointers[] =
{
  &_xdp_file_transfer_signal_info_transfer_closed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_file_transfer_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_file_transfer_property_info_pointers[] =
{
  &_xdp_file_transfer_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_file_transfer_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.FileTransfer",
    (GDBusMethodInfo **) &_xdp_file_transfer_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_file_transfer_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_file_transfer_property_info_pointers,
    NULL
  },
  "file-transfer",
};


/**
 * xdp_file_transfer_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_file_transfer_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_file_transfer_interface_info.parent_struct;
}

/**
 * xdp_file_transfer_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpFileTransfer interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_file_transfer_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpFileTransfer:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link>.
 */

/**
 * XdpFileTransferIface:
 * @parent_iface: The parent interface.
 * @handle_add_files: Handler for the #XdpFileTransfer::handle-add-files signal.
 * @handle_retrieve_files: Handler for the #XdpFileTransfer::handle-retrieve-files signal.
 * @handle_start_transfer: Handler for the #XdpFileTransfer::handle-start-transfer signal.
 * @handle_stop_transfer: Handler for the #XdpFileTransfer::handle-stop-transfer signal.
 * @get_version: Getter for the #XdpFileTransfer:version property.
 * @transfer_closed: Handler for the #XdpFileTransfer::transfer-closed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link>.
 */

typedef XdpFileTransferIface XdpFileTransferInterface;
G_DEFINE_INTERFACE (XdpFileTransfer, xdp_file_transfer, G_TYPE_OBJECT)

static void
xdp_file_transfer_default_init (XdpFileTransferIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpFileTransfer::handle-start-transfer:
   * @object: A #XdpFileTransfer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StartTransfer">StartTransfer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_transfer_complete_start_transfer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start-transfer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileTransferIface, handle_start_transfer),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * XdpFileTransfer::handle-add-files:
   * @object: A #XdpFileTransfer.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_key: Argument passed by remote caller.
   * @arg_fds: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.AddFiles">AddFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_transfer_complete_add_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileTransferIface, handle_add_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpFileTransfer::handle-retrieve-files:
   * @object: A #XdpFileTransfer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.RetrieveFiles">RetrieveFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_transfer_complete_retrieve_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-retrieve-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileTransferIface, handle_retrieve_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpFileTransfer::handle-stop-transfer:
   * @object: A #XdpFileTransfer.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_key: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StopTransfer">StopTransfer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_file_transfer_complete_stop_transfer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-stop-transfer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileTransferIface, handle_stop_transfer),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpFileTransfer::transfer-closed:
   * @object: A #XdpFileTransfer.
   * @arg_key: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-FileTransfer.TransferClosed">"TransferClosed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("transfer-closed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpFileTransferIface, transfer_closed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpFileTransfer:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-FileTransfer.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_file_transfer_get_version: (skip)
 * @object: A #XdpFileTransfer.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-FileTransfer.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_file_transfer_get_version (XdpFileTransfer *object)
{
  return XDP_FILE_TRANSFER_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_file_transfer_set_version: (skip)
 * @object: A #XdpFileTransfer.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-FileTransfer.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_file_transfer_set_version (XdpFileTransfer *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_file_transfer_emit_transfer_closed:
 * @object: A #XdpFileTransfer.
 * @arg_key: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-FileTransfer.TransferClosed">"TransferClosed"</link> D-Bus signal.
 */
void
xdp_file_transfer_emit_transfer_closed (
    XdpFileTransfer *object,
    const gchar *arg_key)
{
  g_signal_emit_by_name (object, "transfer-closed", arg_key);
}

/**
 * xdp_file_transfer_call_start_transfer:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StartTransfer">StartTransfer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_transfer_call_start_transfer_finish() to get the result of the operation.
 *
 * See xdp_file_transfer_call_start_transfer_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_transfer_call_start_transfer (
    XdpFileTransfer *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StartTransfer",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_transfer_call_start_transfer_finish:
 * @proxy: A #XdpFileTransferProxy.
 * @out_key: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_transfer_call_start_transfer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_transfer_call_start_transfer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_start_transfer_finish (
    XdpFileTransfer *proxy,
    gchar **out_key,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_key);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_start_transfer_sync:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_key: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StartTransfer">StartTransfer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_transfer_call_start_transfer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_start_transfer_sync (
    XdpFileTransfer *proxy,
    GVariant *arg_options,
    gchar **out_key,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StartTransfer",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(s)",
                 out_key);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_add_files:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.AddFiles">AddFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_transfer_call_add_files_finish() to get the result of the operation.
 *
 * See xdp_file_transfer_call_add_files_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_transfer_call_add_files (
    XdpFileTransfer *proxy,
    const gchar *arg_key,
    GVariant *arg_fds,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "AddFiles",
    g_variant_new ("(s@ah@a{sv})",
                   arg_key,
                   arg_fds,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_transfer_call_add_files_finish:
 * @proxy: A #XdpFileTransferProxy.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_transfer_call_add_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_transfer_call_add_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_add_files_finish (
    XdpFileTransfer *proxy,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_add_files_sync:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_fds: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.AddFiles">AddFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_transfer_call_add_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_add_files_sync (
    XdpFileTransfer *proxy,
    const gchar *arg_key,
    GVariant *arg_fds,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "AddFiles",
    g_variant_new ("(s@ah@a{sv})",
                   arg_key,
                   arg_fds,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_retrieve_files:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.RetrieveFiles">RetrieveFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_transfer_call_retrieve_files_finish() to get the result of the operation.
 *
 * See xdp_file_transfer_call_retrieve_files_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_transfer_call_retrieve_files (
    XdpFileTransfer *proxy,
    const gchar *arg_key,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RetrieveFiles",
    g_variant_new ("(s@a{sv})",
                   arg_key,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_transfer_call_retrieve_files_finish:
 * @proxy: A #XdpFileTransferProxy.
 * @out_files: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_transfer_call_retrieve_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_transfer_call_retrieve_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_retrieve_files_finish (
    XdpFileTransfer *proxy,
    gchar ***out_files,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_retrieve_files_sync:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_files: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.RetrieveFiles">RetrieveFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_transfer_call_retrieve_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_retrieve_files_sync (
    XdpFileTransfer *proxy,
    const gchar *arg_key,
    GVariant *arg_options,
    gchar ***out_files,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RetrieveFiles",
    g_variant_new ("(s@a{sv})",
                   arg_key,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_files);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_stop_transfer:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StopTransfer">StopTransfer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_transfer_call_stop_transfer_finish() to get the result of the operation.
 *
 * See xdp_file_transfer_call_stop_transfer_sync() for the synchronous, blocking version of this method.
 */
void
xdp_file_transfer_call_stop_transfer (
    XdpFileTransfer *proxy,
    const gchar *arg_key,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "StopTransfer",
    g_variant_new ("(s)",
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_file_transfer_call_stop_transfer_finish:
 * @proxy: A #XdpFileTransferProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_transfer_call_stop_transfer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_file_transfer_call_stop_transfer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_stop_transfer_finish (
    XdpFileTransfer *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_call_stop_transfer_sync:
 * @proxy: A #XdpFileTransferProxy.
 * @arg_key: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StopTransfer">StopTransfer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_file_transfer_call_stop_transfer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_file_transfer_call_stop_transfer_sync (
    XdpFileTransfer *proxy,
    const gchar *arg_key,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "StopTransfer",
    g_variant_new ("(s)",
                   arg_key),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_file_transfer_complete_start_transfer:
 * @object: A #XdpFileTransfer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @key: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StartTransfer">StartTransfer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_transfer_complete_start_transfer (
    XdpFileTransfer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *key)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(s)",
                   key));
}

/**
 * xdp_file_transfer_complete_add_files:
 * @object: A #XdpFileTransfer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.AddFiles">AddFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_transfer_complete_add_files (
    XdpFileTransfer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("()"),
    fd_list);
}

/**
 * xdp_file_transfer_complete_retrieve_files:
 * @object: A #XdpFileTransfer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @files: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.RetrieveFiles">RetrieveFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_transfer_complete_retrieve_files (
    XdpFileTransfer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *files)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   files));
}

/**
 * xdp_file_transfer_complete_stop_transfer:
 * @object: A #XdpFileTransfer.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-FileTransfer.StopTransfer">StopTransfer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_file_transfer_complete_stop_transfer (
    XdpFileTransfer *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpFileTransferProxy:
 *
 * The #XdpFileTransferProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpFileTransferProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpFileTransferProxy.
 */

struct _XdpFileTransferProxyPrivate
{
  GData *qdata;
};

static void xdp_file_transfer_proxy_iface_init (XdpFileTransferIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpFileTransferProxy, xdp_file_transfer_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpFileTransferProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_TRANSFER, xdp_file_transfer_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpFileTransferProxy, xdp_file_transfer_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_TRANSFER, xdp_file_transfer_proxy_iface_init))

#endif
static void
xdp_file_transfer_proxy_finalize (GObject *object)
{
  XdpFileTransferProxy *proxy = XDP_FILE_TRANSFER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_file_transfer_proxy_parent_class)->finalize (object);
}

static void
xdp_file_transfer_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_file_transfer_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_file_transfer_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.FileTransfer: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_file_transfer_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_file_transfer_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.FileTransfer", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_file_transfer_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_file_transfer_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_file_transfer_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_FILE_TRANSFER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_FILE_TRANSFER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_file_transfer_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpFileTransferProxy *proxy = XDP_FILE_TRANSFER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_transfer_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_transfer_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_file_transfer_proxy_get_version (XdpFileTransfer *object)
{
  XdpFileTransferProxy *proxy = XDP_FILE_TRANSFER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_file_transfer_proxy_init (XdpFileTransferProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_file_transfer_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_FILE_TRANSFER_PROXY, XdpFileTransferProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_file_transfer_interface_info ());
}

static void
xdp_file_transfer_proxy_class_init (XdpFileTransferProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_file_transfer_proxy_finalize;
  gobject_class->get_property = xdp_file_transfer_proxy_get_property;
  gobject_class->set_property = xdp_file_transfer_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_file_transfer_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_file_transfer_proxy_g_properties_changed;

  xdp_file_transfer_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpFileTransferProxyPrivate));
#endif
}

static void
xdp_file_transfer_proxy_iface_init (XdpFileTransferIface *iface)
{
  iface->get_version = xdp_file_transfer_proxy_get_version;
}

/**
 * xdp_file_transfer_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_transfer_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_file_transfer_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_file_transfer_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_FILE_TRANSFER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileTransfer", NULL);
}

/**
 * xdp_file_transfer_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_transfer_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_file_transfer_proxy_new().
 *
 * Returns: (transfer full) (type XdpFileTransferProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileTransfer *
xdp_file_transfer_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_FILE_TRANSFER (ret);
  else
    return NULL;
}

/**
 * xdp_file_transfer_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_file_transfer_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpFileTransferProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileTransfer *
xdp_file_transfer_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_FILE_TRANSFER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileTransfer", NULL);
  if (ret != NULL)
    return XDP_FILE_TRANSFER (ret);
  else
    return NULL;
}


/**
 * xdp_file_transfer_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_file_transfer_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_file_transfer_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_file_transfer_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_file_transfer_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_FILE_TRANSFER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileTransfer", NULL);
}

/**
 * xdp_file_transfer_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_file_transfer_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_file_transfer_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpFileTransferProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileTransfer *
xdp_file_transfer_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_FILE_TRANSFER (ret);
  else
    return NULL;
}

/**
 * xdp_file_transfer_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_file_transfer_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_file_transfer_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpFileTransferProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpFileTransfer *
xdp_file_transfer_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_FILE_TRANSFER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.FileTransfer", NULL);
  if (ret != NULL)
    return XDP_FILE_TRANSFER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpFileTransferSkeleton:
 *
 * The #XdpFileTransferSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpFileTransferSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpFileTransferSkeleton.
 */

struct _XdpFileTransferSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_file_transfer_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_FILE_TRANSFER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_FILE_TRANSFER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_file_transfer_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_transfer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_file_transfer_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_file_transfer_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_file_transfer_skeleton_vtable =
{
  _xdp_file_transfer_skeleton_handle_method_call,
  _xdp_file_transfer_skeleton_handle_get_property,
  _xdp_file_transfer_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_file_transfer_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_file_transfer_interface_info ();
}

static GDBusInterfaceVTable *
xdp_file_transfer_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_file_transfer_skeleton_vtable;
}

static GVariant *
xdp_file_transfer_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_file_transfer_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_file_transfer_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_file_transfer_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_file_transfer_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.FileTransfer", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_file_transfer_emit_changed (gpointer user_data);

static void
xdp_file_transfer_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_file_transfer_emit_changed (skeleton);
}

static void
_xdp_file_transfer_on_signal_transfer_closed (
    XdpFileTransfer *object,
    const gchar *arg_key)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_key));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.FileTransfer", "TransferClosed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_file_transfer_skeleton_iface_init (XdpFileTransferIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpFileTransferSkeleton, xdp_file_transfer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpFileTransferSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_TRANSFER, xdp_file_transfer_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpFileTransferSkeleton, xdp_file_transfer_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_FILE_TRANSFER, xdp_file_transfer_skeleton_iface_init))

#endif
static void
xdp_file_transfer_skeleton_finalize (GObject *object)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_file_transfer_skeleton_parent_class)->finalize (object);
}

static void
xdp_file_transfer_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_file_transfer_emit_changed (gpointer user_data)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.FileTransfer",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_file_transfer_schedule_emit_changed (XdpFileTransferSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_file_transfer_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_file_transfer_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_file_transfer_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_file_transfer_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_file_transfer_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_file_transfer_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_file_transfer_skeleton_init (XdpFileTransferSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_file_transfer_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_FILE_TRANSFER_SKELETON, XdpFileTransferSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_file_transfer_skeleton_get_version (XdpFileTransfer *object)
{
  XdpFileTransferSkeleton *skeleton = XDP_FILE_TRANSFER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_file_transfer_skeleton_class_init (XdpFileTransferSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_file_transfer_skeleton_finalize;
  gobject_class->get_property = xdp_file_transfer_skeleton_get_property;
  gobject_class->set_property = xdp_file_transfer_skeleton_set_property;
  gobject_class->notify       = xdp_file_transfer_skeleton_notify;


  xdp_file_transfer_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_file_transfer_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_file_transfer_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_file_transfer_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_file_transfer_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpFileTransferSkeletonPrivate));
#endif
}

static void
xdp_file_transfer_skeleton_iface_init (XdpFileTransferIface *iface)
{
  iface->transfer_closed = _xdp_file_transfer_on_signal_transfer_closed;
  iface->get_version = xdp_file_transfer_skeleton_get_version;
}

/**
 * xdp_file_transfer_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-FileTransfer.top_of_page">org.freedesktop.portal.FileTransfer</link>.
 *
 * Returns: (transfer full) (type XdpFileTransferSkeleton): The skeleton object.
 */
XdpFileTransfer *
xdp_file_transfer_skeleton_new (void)
{
  return XDP_FILE_TRANSFER (g_object_new (XDP_TYPE_FILE_TRANSFER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.GameMode
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpGameMode
 * @title: XdpGameMode
 * @short_description: Generated C code for the org.freedesktop.portal.GameMode D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.GameMode ---- */

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_query_status_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_query_status_IN_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_query_status_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_query_status_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_query_status =
{
  {
    -1,
    (gchar *) "QueryStatus",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_query_status_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_query_status_OUT_ARG_pointers,
    NULL
  },
  "handle-query-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_register_game_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_register_game_IN_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_register_game_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_register_game_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_register_game =
{
  {
    -1,
    (gchar *) "RegisterGame",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_register_game_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_register_game_OUT_ARG_pointers,
    NULL
  },
  "handle-register-game",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_IN_ARG_pid =
{
  {
    -1,
    (gchar *) "pid",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_unregister_game_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_unregister_game_IN_ARG_pid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_unregister_game_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_unregister_game_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_unregister_game =
{
  {
    -1,
    (gchar *) "UnregisterGame",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_unregister_game_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_unregister_game_OUT_ARG_pointers,
    NULL
  },
  "handle-unregister-game",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_by_pid_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_by_pid_IN_ARG_requester =
{
  {
    -1,
    (gchar *) "requester",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_query_status_by_pid_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_query_status_by_pid_IN_ARG_target.parent_struct,
  &_xdp_game_mode_method_info_query_status_by_pid_IN_ARG_requester.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_by_pid_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_query_status_by_pid_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_query_status_by_pid_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_query_status_by_pid =
{
  {
    -1,
    (gchar *) "QueryStatusByPid",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_query_status_by_pid_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_query_status_by_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-query-status-by-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_by_pid_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_by_pid_IN_ARG_requester =
{
  {
    -1,
    (gchar *) "requester",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_register_game_by_pid_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_register_game_by_pid_IN_ARG_target.parent_struct,
  &_xdp_game_mode_method_info_register_game_by_pid_IN_ARG_requester.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_by_pid_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_register_game_by_pid_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_register_game_by_pid_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_register_game_by_pid =
{
  {
    -1,
    (gchar *) "RegisterGameByPid",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_register_game_by_pid_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_register_game_by_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-register-game-by-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_by_pid_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_by_pid_IN_ARG_requester =
{
  {
    -1,
    (gchar *) "requester",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_unregister_game_by_pid_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_unregister_game_by_pid_IN_ARG_target.parent_struct,
  &_xdp_game_mode_method_info_unregister_game_by_pid_IN_ARG_requester.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_by_pid_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_unregister_game_by_pid_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_unregister_game_by_pid_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_unregister_game_by_pid =
{
  {
    -1,
    (gchar *) "UnregisterGameByPid",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_unregister_game_by_pid_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_unregister_game_by_pid_OUT_ARG_pointers,
    NULL
  },
  "handle-unregister-game-by-pid",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_by_pidfd_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_by_pidfd_IN_ARG_requester =
{
  {
    -1,
    (gchar *) "requester",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_query_status_by_pidfd_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_query_status_by_pidfd_IN_ARG_target.parent_struct,
  &_xdp_game_mode_method_info_query_status_by_pidfd_IN_ARG_requester.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_query_status_by_pidfd_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_query_status_by_pidfd_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_query_status_by_pidfd_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_query_status_by_pidfd =
{
  {
    -1,
    (gchar *) "QueryStatusByPIDFd",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_query_status_by_pidfd_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_query_status_by_pidfd_OUT_ARG_pointers,
    NULL
  },
  "handle-query-status-by-pidfd",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_by_pidfd_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_by_pidfd_IN_ARG_requester =
{
  {
    -1,
    (gchar *) "requester",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_register_game_by_pidfd_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_register_game_by_pidfd_IN_ARG_target.parent_struct,
  &_xdp_game_mode_method_info_register_game_by_pidfd_IN_ARG_requester.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_register_game_by_pidfd_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_register_game_by_pidfd_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_register_game_by_pidfd_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_register_game_by_pidfd =
{
  {
    -1,
    (gchar *) "RegisterGameByPIDFd",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_register_game_by_pidfd_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_register_game_by_pidfd_OUT_ARG_pointers,
    NULL
  },
  "handle-register-game-by-pidfd",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_by_pidfd_IN_ARG_target =
{
  {
    -1,
    (gchar *) "target",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_by_pidfd_IN_ARG_requester =
{
  {
    -1,
    (gchar *) "requester",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_unregister_game_by_pidfd_IN_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_unregister_game_by_pidfd_IN_ARG_target.parent_struct,
  &_xdp_game_mode_method_info_unregister_game_by_pidfd_IN_ARG_requester.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_game_mode_method_info_unregister_game_by_pidfd_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_game_mode_method_info_unregister_game_by_pidfd_OUT_ARG_pointers[] =
{
  &_xdp_game_mode_method_info_unregister_game_by_pidfd_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_game_mode_method_info_unregister_game_by_pidfd =
{
  {
    -1,
    (gchar *) "UnregisterGameByPIDFd",
    (GDBusArgInfo **) &_xdp_game_mode_method_info_unregister_game_by_pidfd_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_game_mode_method_info_unregister_game_by_pidfd_OUT_ARG_pointers,
    NULL
  },
  "handle-unregister-game-by-pidfd",
  TRUE
};

static const GDBusMethodInfo * const _xdp_game_mode_method_info_pointers[] =
{
  &_xdp_game_mode_method_info_query_status.parent_struct,
  &_xdp_game_mode_method_info_register_game.parent_struct,
  &_xdp_game_mode_method_info_unregister_game.parent_struct,
  &_xdp_game_mode_method_info_query_status_by_pid.parent_struct,
  &_xdp_game_mode_method_info_register_game_by_pid.parent_struct,
  &_xdp_game_mode_method_info_unregister_game_by_pid.parent_struct,
  &_xdp_game_mode_method_info_query_status_by_pidfd.parent_struct,
  &_xdp_game_mode_method_info_register_game_by_pidfd.parent_struct,
  &_xdp_game_mode_method_info_unregister_game_by_pidfd.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_game_mode_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_game_mode_property_info_pointers[] =
{
  &_xdp_game_mode_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_game_mode_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.GameMode",
    (GDBusMethodInfo **) &_xdp_game_mode_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_game_mode_property_info_pointers,
    NULL
  },
  "game-mode",
};


/**
 * xdp_game_mode_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_game_mode_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_game_mode_interface_info.parent_struct;
}

/**
 * xdp_game_mode_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpGameMode interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_game_mode_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpGameMode:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link>.
 */

/**
 * XdpGameModeIface:
 * @parent_iface: The parent interface.
 * @handle_query_status: Handler for the #XdpGameMode::handle-query-status signal.
 * @handle_query_status_by_pid: Handler for the #XdpGameMode::handle-query-status-by-pid signal.
 * @handle_query_status_by_pidfd: Handler for the #XdpGameMode::handle-query-status-by-pidfd signal.
 * @handle_register_game: Handler for the #XdpGameMode::handle-register-game signal.
 * @handle_register_game_by_pid: Handler for the #XdpGameMode::handle-register-game-by-pid signal.
 * @handle_register_game_by_pidfd: Handler for the #XdpGameMode::handle-register-game-by-pidfd signal.
 * @handle_unregister_game: Handler for the #XdpGameMode::handle-unregister-game signal.
 * @handle_unregister_game_by_pid: Handler for the #XdpGameMode::handle-unregister-game-by-pid signal.
 * @handle_unregister_game_by_pidfd: Handler for the #XdpGameMode::handle-unregister-game-by-pidfd signal.
 * @get_version: Getter for the #XdpGameMode:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link>.
 */

typedef XdpGameModeIface XdpGameModeInterface;
G_DEFINE_INTERFACE (XdpGameMode, xdp_game_mode, G_TYPE_OBJECT)

static void
xdp_game_mode_default_init (XdpGameModeIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpGameMode::handle-query-status:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatus">QueryStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_query_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_query_status),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * XdpGameMode::handle-register-game:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGame">RegisterGame()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_register_game() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-game",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_register_game),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * XdpGameMode::handle-unregister-game:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_pid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGame">UnregisterGame()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_unregister_game() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-game",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_unregister_game),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT);

  /**
   * XdpGameMode::handle-query-status-by-pid:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_target: Argument passed by remote caller.
   * @arg_requester: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPid">QueryStatusByPid()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_query_status_by_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-status-by-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_query_status_by_pid),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * XdpGameMode::handle-register-game-by-pid:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_target: Argument passed by remote caller.
   * @arg_requester: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPid">RegisterGameByPid()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_register_game_by_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-game-by-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_register_game_by_pid),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * XdpGameMode::handle-unregister-game-by-pid:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_target: Argument passed by remote caller.
   * @arg_requester: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPid">UnregisterGameByPid()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_unregister_game_by_pid() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-game-by-pid",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_unregister_game_by_pid),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_INT, G_TYPE_INT);

  /**
   * XdpGameMode::handle-query-status-by-pidfd:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_target: Argument passed by remote caller.
   * @arg_requester: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPIDFd">QueryStatusByPIDFd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_query_status_by_pidfd() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-status-by-pidfd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_query_status_by_pidfd),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpGameMode::handle-register-game-by-pidfd:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_target: Argument passed by remote caller.
   * @arg_requester: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPIDFd">RegisterGameByPIDFd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_register_game_by_pidfd() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-game-by-pidfd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_register_game_by_pidfd),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpGameMode::handle-unregister-game-by-pidfd:
   * @object: A #XdpGameMode.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_target: Argument passed by remote caller.
   * @arg_requester: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPIDFd">UnregisterGameByPIDFd()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_game_mode_complete_unregister_game_by_pidfd() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-game-by-pidfd",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpGameModeIface, handle_unregister_game_by_pidfd),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpGameMode:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-GameMode.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_game_mode_get_version: (skip)
 * @object: A #XdpGameMode.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-GameMode.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_game_mode_get_version (XdpGameMode *object)
{
  return XDP_GAME_MODE_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_game_mode_set_version: (skip)
 * @object: A #XdpGameMode.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-GameMode.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_game_mode_set_version (XdpGameMode *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_game_mode_call_query_status:
 * @proxy: A #XdpGameModeProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatus">QueryStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_query_status_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_query_status_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_query_status (
    XdpGameMode *proxy,
    gint arg_pid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryStatus",
    g_variant_new ("(i)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_query_status_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_query_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_query_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_query_status_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_query_status_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatus">QueryStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_query_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_query_status_sync (
    XdpGameMode *proxy,
    gint arg_pid,
    gint *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryStatus",
    g_variant_new ("(i)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_register_game:
 * @proxy: A #XdpGameModeProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGame">RegisterGame()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_register_game_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_register_game_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_register_game (
    XdpGameMode *proxy,
    gint arg_pid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterGame",
    g_variant_new ("(i)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_register_game_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_register_game().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_register_game().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_register_game_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_register_game_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGame">RegisterGame()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_register_game() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_register_game_sync (
    XdpGameMode *proxy,
    gint arg_pid,
    gint *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterGame",
    g_variant_new ("(i)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_unregister_game:
 * @proxy: A #XdpGameModeProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGame">UnregisterGame()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_unregister_game_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_unregister_game_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_unregister_game (
    XdpGameMode *proxy,
    gint arg_pid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterGame",
    g_variant_new ("(i)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_unregister_game_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_unregister_game().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_unregister_game().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_unregister_game_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_unregister_game_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_pid: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGame">UnregisterGame()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_unregister_game() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_unregister_game_sync (
    XdpGameMode *proxy,
    gint arg_pid,
    gint *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterGame",
    g_variant_new ("(i)",
                   arg_pid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_query_status_by_pid:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPid">QueryStatusByPid()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_query_status_by_pid_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_query_status_by_pid_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_query_status_by_pid (
    XdpGameMode *proxy,
    gint arg_target,
    gint arg_requester,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryStatusByPid",
    g_variant_new ("(ii)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_query_status_by_pid_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_query_status_by_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_query_status_by_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_query_status_by_pid_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_query_status_by_pid_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPid">QueryStatusByPid()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_query_status_by_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_query_status_by_pid_sync (
    XdpGameMode *proxy,
    gint arg_target,
    gint arg_requester,
    gint *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryStatusByPid",
    g_variant_new ("(ii)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_register_game_by_pid:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPid">RegisterGameByPid()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_register_game_by_pid_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_register_game_by_pid_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_register_game_by_pid (
    XdpGameMode *proxy,
    gint arg_target,
    gint arg_requester,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterGameByPid",
    g_variant_new ("(ii)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_register_game_by_pid_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_register_game_by_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_register_game_by_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_register_game_by_pid_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_register_game_by_pid_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPid">RegisterGameByPid()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_register_game_by_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_register_game_by_pid_sync (
    XdpGameMode *proxy,
    gint arg_target,
    gint arg_requester,
    gint *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterGameByPid",
    g_variant_new ("(ii)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_unregister_game_by_pid:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPid">UnregisterGameByPid()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_unregister_game_by_pid_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_unregister_game_by_pid_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_unregister_game_by_pid (
    XdpGameMode *proxy,
    gint arg_target,
    gint arg_requester,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterGameByPid",
    g_variant_new ("(ii)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_unregister_game_by_pid_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_unregister_game_by_pid().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_unregister_game_by_pid().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_unregister_game_by_pid_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_unregister_game_by_pid_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPid">UnregisterGameByPid()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_unregister_game_by_pid() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_unregister_game_by_pid_sync (
    XdpGameMode *proxy,
    gint arg_target,
    gint arg_requester,
    gint *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterGameByPid",
    g_variant_new ("(ii)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_query_status_by_pidfd:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPIDFd">QueryStatusByPIDFd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_query_status_by_pidfd_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_query_status_by_pidfd_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_query_status_by_pidfd (
    XdpGameMode *proxy,
    GVariant *arg_target,
    GVariant *arg_requester,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "QueryStatusByPIDFd",
    g_variant_new ("(@h@h)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_query_status_by_pidfd_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_query_status_by_pidfd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_query_status_by_pidfd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_query_status_by_pidfd_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_query_status_by_pidfd_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPIDFd">QueryStatusByPIDFd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_query_status_by_pidfd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_query_status_by_pidfd_sync (
    XdpGameMode *proxy,
    GVariant *arg_target,
    GVariant *arg_requester,
    GUnixFDList  *fd_list,
    gint *out_result,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "QueryStatusByPIDFd",
    g_variant_new ("(@h@h)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_register_game_by_pidfd:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPIDFd">RegisterGameByPIDFd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_register_game_by_pidfd_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_register_game_by_pidfd_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_register_game_by_pidfd (
    XdpGameMode *proxy,
    GVariant *arg_target,
    GVariant *arg_requester,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "RegisterGameByPIDFd",
    g_variant_new ("(@h@h)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_register_game_by_pidfd_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_register_game_by_pidfd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_register_game_by_pidfd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_register_game_by_pidfd_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_register_game_by_pidfd_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPIDFd">RegisterGameByPIDFd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_register_game_by_pidfd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_register_game_by_pidfd_sync (
    XdpGameMode *proxy,
    GVariant *arg_target,
    GVariant *arg_requester,
    GUnixFDList  *fd_list,
    gint *out_result,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "RegisterGameByPIDFd",
    g_variant_new ("(@h@h)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_unregister_game_by_pidfd:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPIDFd">UnregisterGameByPIDFd()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_call_unregister_game_by_pidfd_finish() to get the result of the operation.
 *
 * See xdp_game_mode_call_unregister_game_by_pidfd_sync() for the synchronous, blocking version of this method.
 */
void
xdp_game_mode_call_unregister_game_by_pidfd (
    XdpGameMode *proxy,
    GVariant *arg_target,
    GVariant *arg_requester,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "UnregisterGameByPIDFd",
    g_variant_new ("(@h@h)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_game_mode_call_unregister_game_by_pidfd_finish:
 * @proxy: A #XdpGameModeProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_call_unregister_game_by_pidfd().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_game_mode_call_unregister_game_by_pidfd().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_unregister_game_by_pidfd_finish (
    XdpGameMode *proxy,
    gint *out_result,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_call_unregister_game_by_pidfd_sync:
 * @proxy: A #XdpGameModeProxy.
 * @arg_target: Argument to pass with the method invocation.
 * @arg_requester: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPIDFd">UnregisterGameByPIDFd()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_call_unregister_game_by_pidfd() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_game_mode_call_unregister_game_by_pidfd_sync (
    XdpGameMode *proxy,
    GVariant *arg_target,
    GVariant *arg_requester,
    GUnixFDList  *fd_list,
    gint *out_result,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "UnregisterGameByPIDFd",
    g_variant_new ("(@h@h)",
                   arg_target,
                   arg_requester),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_game_mode_complete_query_status:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatus">QueryStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_query_status (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   result));
}

/**
 * xdp_game_mode_complete_register_game:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGame">RegisterGame()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_register_game (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   result));
}

/**
 * xdp_game_mode_complete_unregister_game:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGame">UnregisterGame()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_unregister_game (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   result));
}

/**
 * xdp_game_mode_complete_query_status_by_pid:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPid">QueryStatusByPid()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_query_status_by_pid (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   result));
}

/**
 * xdp_game_mode_complete_register_game_by_pid:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPid">RegisterGameByPid()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_register_game_by_pid (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   result));
}

/**
 * xdp_game_mode_complete_unregister_game_by_pid:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPid">UnregisterGameByPid()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_unregister_game_by_pid (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i)",
                   result));
}

/**
 * xdp_game_mode_complete_query_status_by_pidfd:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.QueryStatusByPIDFd">QueryStatusByPIDFd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_query_status_by_pidfd (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    gint result)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(i)",
                   result),
    fd_list);
}

/**
 * xdp_game_mode_complete_register_game_by_pidfd:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.RegisterGameByPIDFd">RegisterGameByPIDFd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_register_game_by_pidfd (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    gint result)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(i)",
                   result),
    fd_list);
}

/**
 * xdp_game_mode_complete_unregister_game_by_pidfd:
 * @object: A #XdpGameMode.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-GameMode.UnregisterGameByPIDFd">UnregisterGameByPIDFd()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_game_mode_complete_unregister_game_by_pidfd (
    XdpGameMode *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    gint result)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(i)",
                   result),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpGameModeProxy:
 *
 * The #XdpGameModeProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpGameModeProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpGameModeProxy.
 */

struct _XdpGameModeProxyPrivate
{
  GData *qdata;
};

static void xdp_game_mode_proxy_iface_init (XdpGameModeIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpGameModeProxy, xdp_game_mode_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpGameModeProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_GAME_MODE, xdp_game_mode_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpGameModeProxy, xdp_game_mode_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_GAME_MODE, xdp_game_mode_proxy_iface_init))

#endif
static void
xdp_game_mode_proxy_finalize (GObject *object)
{
  XdpGameModeProxy *proxy = XDP_GAME_MODE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_game_mode_proxy_parent_class)->finalize (object);
}

static void
xdp_game_mode_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_game_mode_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_game_mode_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.GameMode: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_game_mode_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_game_mode_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.GameMode", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_game_mode_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_game_mode_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_game_mode_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_GAME_MODE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_GAME_MODE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_game_mode_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpGameModeProxy *proxy = XDP_GAME_MODE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_game_mode_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_game_mode_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_game_mode_proxy_get_version (XdpGameMode *object)
{
  XdpGameModeProxy *proxy = XDP_GAME_MODE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_game_mode_proxy_init (XdpGameModeProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_game_mode_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_GAME_MODE_PROXY, XdpGameModeProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_game_mode_interface_info ());
}

static void
xdp_game_mode_proxy_class_init (XdpGameModeProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_game_mode_proxy_finalize;
  gobject_class->get_property = xdp_game_mode_proxy_get_property;
  gobject_class->set_property = xdp_game_mode_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_game_mode_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_game_mode_proxy_g_properties_changed;

  xdp_game_mode_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpGameModeProxyPrivate));
#endif
}

static void
xdp_game_mode_proxy_iface_init (XdpGameModeIface *iface)
{
  iface->get_version = xdp_game_mode_proxy_get_version;
}

/**
 * xdp_game_mode_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_game_mode_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_game_mode_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_GAME_MODE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.GameMode", NULL);
}

/**
 * xdp_game_mode_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_game_mode_proxy_new().
 *
 * Returns: (transfer full) (type XdpGameModeProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpGameMode *
xdp_game_mode_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_GAME_MODE (ret);
  else
    return NULL;
}

/**
 * xdp_game_mode_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpGameModeProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpGameMode *
xdp_game_mode_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_GAME_MODE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.GameMode", NULL);
  if (ret != NULL)
    return XDP_GAME_MODE (ret);
  else
    return NULL;
}


/**
 * xdp_game_mode_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_game_mode_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_game_mode_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_game_mode_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_game_mode_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_GAME_MODE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.GameMode", NULL);
}

/**
 * xdp_game_mode_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_game_mode_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_game_mode_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpGameModeProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpGameMode *
xdp_game_mode_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_GAME_MODE (ret);
  else
    return NULL;
}

/**
 * xdp_game_mode_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_game_mode_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_game_mode_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpGameModeProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpGameMode *
xdp_game_mode_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_GAME_MODE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.GameMode", NULL);
  if (ret != NULL)
    return XDP_GAME_MODE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpGameModeSkeleton:
 *
 * The #XdpGameModeSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpGameModeSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpGameModeSkeleton.
 */

struct _XdpGameModeSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_game_mode_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_GAME_MODE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_GAME_MODE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_game_mode_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_game_mode_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_game_mode_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_game_mode_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_game_mode_skeleton_vtable =
{
  _xdp_game_mode_skeleton_handle_method_call,
  _xdp_game_mode_skeleton_handle_get_property,
  _xdp_game_mode_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_game_mode_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_game_mode_interface_info ();
}

static GDBusInterfaceVTable *
xdp_game_mode_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_game_mode_skeleton_vtable;
}

static GVariant *
xdp_game_mode_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_game_mode_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_game_mode_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_game_mode_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_game_mode_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.GameMode", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_game_mode_emit_changed (gpointer user_data);

static void
xdp_game_mode_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_game_mode_emit_changed (skeleton);
}

static void xdp_game_mode_skeleton_iface_init (XdpGameModeIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpGameModeSkeleton, xdp_game_mode_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpGameModeSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_GAME_MODE, xdp_game_mode_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpGameModeSkeleton, xdp_game_mode_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_GAME_MODE, xdp_game_mode_skeleton_iface_init))

#endif
static void
xdp_game_mode_skeleton_finalize (GObject *object)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_game_mode_skeleton_parent_class)->finalize (object);
}

static void
xdp_game_mode_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_game_mode_emit_changed (gpointer user_data)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.GameMode",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_game_mode_schedule_emit_changed (XdpGameModeSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_game_mode_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_game_mode_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_game_mode_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_game_mode_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_game_mode_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_game_mode_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_game_mode_skeleton_init (XdpGameModeSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_game_mode_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_GAME_MODE_SKELETON, XdpGameModeSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_game_mode_skeleton_get_version (XdpGameMode *object)
{
  XdpGameModeSkeleton *skeleton = XDP_GAME_MODE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_game_mode_skeleton_class_init (XdpGameModeSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_game_mode_skeleton_finalize;
  gobject_class->get_property = xdp_game_mode_skeleton_get_property;
  gobject_class->set_property = xdp_game_mode_skeleton_set_property;
  gobject_class->notify       = xdp_game_mode_skeleton_notify;


  xdp_game_mode_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_game_mode_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_game_mode_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_game_mode_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_game_mode_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpGameModeSkeletonPrivate));
#endif
}

static void
xdp_game_mode_skeleton_iface_init (XdpGameModeIface *iface)
{
  iface->get_version = xdp_game_mode_skeleton_get_version;
}

/**
 * xdp_game_mode_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-GameMode.top_of_page">org.freedesktop.portal.GameMode</link>.
 *
 * Returns: (transfer full) (type XdpGameModeSkeleton): The skeleton object.
 */
XdpGameMode *
xdp_game_mode_skeleton_new (void)
{
  return XDP_GAME_MODE (g_object_new (XDP_TYPE_GAME_MODE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Inhibit
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpInhibit
 * @title: XdpInhibit
 * @short_description: Generated C code for the org.freedesktop.portal.Inhibit D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Inhibit ---- */

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_inhibit_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_inhibit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_inhibit_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_inhibit_method_info_inhibit_IN_ARG_pointers[] =
{
  &_xdp_inhibit_method_info_inhibit_IN_ARG_window.parent_struct,
  &_xdp_inhibit_method_info_inhibit_IN_ARG_flags.parent_struct,
  &_xdp_inhibit_method_info_inhibit_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_inhibit_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_inhibit_method_info_inhibit_OUT_ARG_pointers[] =
{
  &_xdp_inhibit_method_info_inhibit_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_inhibit_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_xdp_inhibit_method_info_inhibit_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_inhibit_method_info_inhibit_OUT_ARG_pointers,
    NULL
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_create_monitor_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_create_monitor_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_inhibit_method_info_create_monitor_IN_ARG_pointers[] =
{
  &_xdp_inhibit_method_info_create_monitor_IN_ARG_window.parent_struct,
  &_xdp_inhibit_method_info_create_monitor_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_create_monitor_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_inhibit_method_info_create_monitor_OUT_ARG_pointers[] =
{
  &_xdp_inhibit_method_info_create_monitor_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_inhibit_method_info_create_monitor =
{
  {
    -1,
    (gchar *) "CreateMonitor",
    (GDBusArgInfo **) &_xdp_inhibit_method_info_create_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_inhibit_method_info_create_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-create-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_method_info_query_end_response_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_inhibit_method_info_query_end_response_IN_ARG_pointers[] =
{
  &_xdp_inhibit_method_info_query_end_response_IN_ARG_session_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_inhibit_method_info_query_end_response =
{
  {
    -1,
    (gchar *) "QueryEndResponse",
    (GDBusArgInfo **) &_xdp_inhibit_method_info_query_end_response_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-query-end-response",
  FALSE
};

static const GDBusMethodInfo * const _xdp_inhibit_method_info_pointers[] =
{
  &_xdp_inhibit_method_info_inhibit.parent_struct,
  &_xdp_inhibit_method_info_create_monitor.parent_struct,
  &_xdp_inhibit_method_info_query_end_response.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_signal_info_state_changed_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_inhibit_signal_info_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_inhibit_signal_info_state_changed_ARG_pointers[] =
{
  &_xdp_inhibit_signal_info_state_changed_ARG_session_handle.parent_struct,
  &_xdp_inhibit_signal_info_state_changed_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_inhibit_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_xdp_inhibit_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const GDBusSignalInfo * const _xdp_inhibit_signal_info_pointers[] =
{
  &_xdp_inhibit_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_inhibit_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_inhibit_property_info_pointers[] =
{
  &_xdp_inhibit_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_inhibit_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Inhibit",
    (GDBusMethodInfo **) &_xdp_inhibit_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_inhibit_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_inhibit_property_info_pointers,
    NULL
  },
  "inhibit",
};


/**
 * xdp_inhibit_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_inhibit_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_inhibit_interface_info.parent_struct;
}

/**
 * xdp_inhibit_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpInhibit interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_inhibit_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpInhibit:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link>.
 */

/**
 * XdpInhibitIface:
 * @parent_iface: The parent interface.
 * @handle_create_monitor: Handler for the #XdpInhibit::handle-create-monitor signal.
 * @handle_inhibit: Handler for the #XdpInhibit::handle-inhibit signal.
 * @handle_query_end_response: Handler for the #XdpInhibit::handle-query-end-response signal.
 * @get_version: Getter for the #XdpInhibit:version property.
 * @state_changed: Handler for the #XdpInhibit::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link>.
 */

typedef XdpInhibitIface XdpInhibitInterface;
G_DEFINE_INTERFACE (XdpInhibit, xdp_inhibit, G_TYPE_OBJECT)

static void
xdp_inhibit_default_init (XdpInhibitIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpInhibit::handle-inhibit:
   * @object: A #XdpInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_window: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_inhibit_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpInhibitIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * XdpInhibit::handle-create-monitor:
   * @object: A #XdpInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_inhibit_complete_create_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpInhibitIface, handle_create_monitor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpInhibit::handle-query-end-response:
   * @object: A #XdpInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_inhibit_complete_query_end_response() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-end-response",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpInhibitIface, handle_query_end_response),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpInhibit::state-changed:
   * @object: A #XdpInhibit.
   * @arg_session_handle: Argument.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Inhibit.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpInhibitIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpInhibit:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Inhibit.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_inhibit_get_version: (skip)
 * @object: A #XdpInhibit.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Inhibit.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_inhibit_get_version (XdpInhibit *object)
{
  return XDP_INHIBIT_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_inhibit_set_version: (skip)
 * @object: A #XdpInhibit.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Inhibit.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_inhibit_set_version (XdpInhibit *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_inhibit_emit_state_changed:
 * @object: A #XdpInhibit.
 * @arg_session_handle: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Inhibit.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
xdp_inhibit_emit_state_changed (
    XdpInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  g_signal_emit_by_name (object, "state-changed", arg_session_handle, arg_state);
}

/**
 * xdp_inhibit_call_inhibit:
 * @proxy: A #XdpInhibitProxy.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_inhibit_call_inhibit_finish() to get the result of the operation.
 *
 * See xdp_inhibit_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
xdp_inhibit_call_inhibit (
    XdpInhibit *proxy,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(su@a{sv})",
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_inhibit_call_inhibit_finish:
 * @proxy: A #XdpInhibitProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_inhibit_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_inhibit_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_inhibit_call_inhibit_finish (
    XdpInhibit *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_inhibit_call_inhibit_sync:
 * @proxy: A #XdpInhibitProxy.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_inhibit_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_inhibit_call_inhibit_sync (
    XdpInhibit *proxy,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(su@a{sv})",
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_inhibit_call_create_monitor:
 * @proxy: A #XdpInhibitProxy.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_inhibit_call_create_monitor_finish() to get the result of the operation.
 *
 * See xdp_inhibit_call_create_monitor_sync() for the synchronous, blocking version of this method.
 */
void
xdp_inhibit_call_create_monitor (
    XdpInhibit *proxy,
    const gchar *arg_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(s@a{sv})",
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_inhibit_call_create_monitor_finish:
 * @proxy: A #XdpInhibitProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_inhibit_call_create_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_inhibit_call_create_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_inhibit_call_create_monitor_finish (
    XdpInhibit *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_inhibit_call_create_monitor_sync:
 * @proxy: A #XdpInhibitProxy.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_inhibit_call_create_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_inhibit_call_create_monitor_sync (
    XdpInhibit *proxy,
    const gchar *arg_window,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(s@a{sv})",
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_inhibit_call_query_end_response:
 * @proxy: A #XdpInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_inhibit_call_query_end_response_finish() to get the result of the operation.
 *
 * See xdp_inhibit_call_query_end_response_sync() for the synchronous, blocking version of this method.
 */
void
xdp_inhibit_call_query_end_response (
    XdpInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_inhibit_call_query_end_response_finish:
 * @proxy: A #XdpInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_inhibit_call_query_end_response().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_inhibit_call_query_end_response().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_inhibit_call_query_end_response_finish (
    XdpInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_inhibit_call_query_end_response_sync:
 * @proxy: A #XdpInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_inhibit_call_query_end_response() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_inhibit_call_query_end_response_sync (
    XdpInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_inhibit_complete_inhibit:
 * @object: A #XdpInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_inhibit_complete_inhibit (
    XdpInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_inhibit_complete_create_monitor:
 * @object: A #XdpInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_inhibit_complete_create_monitor (
    XdpInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_inhibit_complete_query_end_response:
 * @object: A #XdpInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_inhibit_complete_query_end_response (
    XdpInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpInhibitProxy:
 *
 * The #XdpInhibitProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpInhibitProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpInhibitProxy.
 */

struct _XdpInhibitProxyPrivate
{
  GData *qdata;
};

static void xdp_inhibit_proxy_iface_init (XdpInhibitIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpInhibitProxy, xdp_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpInhibitProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_INHIBIT, xdp_inhibit_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpInhibitProxy, xdp_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_INHIBIT, xdp_inhibit_proxy_iface_init))

#endif
static void
xdp_inhibit_proxy_finalize (GObject *object)
{
  XdpInhibitProxy *proxy = XDP_INHIBIT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_inhibit_proxy_parent_class)->finalize (object);
}

static void
xdp_inhibit_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_inhibit_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_inhibit_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Inhibit: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_inhibit_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_inhibit_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Inhibit", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_inhibit_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_inhibit_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_inhibit_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_INHIBIT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_INHIBIT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_inhibit_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpInhibitProxy *proxy = XDP_INHIBIT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_inhibit_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_inhibit_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_inhibit_proxy_get_version (XdpInhibit *object)
{
  XdpInhibitProxy *proxy = XDP_INHIBIT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_inhibit_proxy_init (XdpInhibitProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_inhibit_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_INHIBIT_PROXY, XdpInhibitProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_inhibit_interface_info ());
}

static void
xdp_inhibit_proxy_class_init (XdpInhibitProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_inhibit_proxy_finalize;
  gobject_class->get_property = xdp_inhibit_proxy_get_property;
  gobject_class->set_property = xdp_inhibit_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_inhibit_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_inhibit_proxy_g_properties_changed;

  xdp_inhibit_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpInhibitProxyPrivate));
#endif
}

static void
xdp_inhibit_proxy_iface_init (XdpInhibitIface *iface)
{
  iface->get_version = xdp_inhibit_proxy_get_version;
}

/**
 * xdp_inhibit_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_inhibit_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_inhibit_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_inhibit_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Inhibit", NULL);
}

/**
 * xdp_inhibit_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_inhibit_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_inhibit_proxy_new().
 *
 * Returns: (transfer full) (type XdpInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpInhibit *
xdp_inhibit_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_inhibit_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_inhibit_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpInhibit *
xdp_inhibit_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_INHIBIT (ret);
  else
    return NULL;
}


/**
 * xdp_inhibit_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_inhibit_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_inhibit_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_inhibit_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_inhibit_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Inhibit", NULL);
}

/**
 * xdp_inhibit_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_inhibit_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_inhibit_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpInhibit *
xdp_inhibit_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_inhibit_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_inhibit_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_inhibit_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpInhibit *
xdp_inhibit_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_INHIBIT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpInhibitSkeleton:
 *
 * The #XdpInhibitSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpInhibitSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpInhibitSkeleton.
 */

struct _XdpInhibitSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_inhibit_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_INHIBIT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_INHIBIT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_inhibit_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_inhibit_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_inhibit_skeleton_vtable =
{
  _xdp_inhibit_skeleton_handle_method_call,
  _xdp_inhibit_skeleton_handle_get_property,
  _xdp_inhibit_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_inhibit_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_inhibit_interface_info ();
}

static GDBusInterfaceVTable *
xdp_inhibit_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_inhibit_skeleton_vtable;
}

static GVariant *
xdp_inhibit_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_inhibit_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_inhibit_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_inhibit_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_inhibit_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Inhibit", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_inhibit_emit_changed (gpointer user_data);

static void
xdp_inhibit_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_inhibit_emit_changed (skeleton);
}

static void
_xdp_inhibit_on_signal_state_changed (
    XdpInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_session_handle,
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Inhibit", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_inhibit_skeleton_iface_init (XdpInhibitIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpInhibitSkeleton, xdp_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpInhibitSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_INHIBIT, xdp_inhibit_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpInhibitSkeleton, xdp_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_INHIBIT, xdp_inhibit_skeleton_iface_init))

#endif
static void
xdp_inhibit_skeleton_finalize (GObject *object)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_inhibit_skeleton_parent_class)->finalize (object);
}

static void
xdp_inhibit_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_inhibit_emit_changed (gpointer user_data)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Inhibit",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_inhibit_schedule_emit_changed (XdpInhibitSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_inhibit_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_inhibit_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_inhibit_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_inhibit_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_inhibit_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_inhibit_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_inhibit_skeleton_init (XdpInhibitSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_inhibit_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_INHIBIT_SKELETON, XdpInhibitSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_inhibit_skeleton_get_version (XdpInhibit *object)
{
  XdpInhibitSkeleton *skeleton = XDP_INHIBIT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_inhibit_skeleton_class_init (XdpInhibitSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_inhibit_skeleton_finalize;
  gobject_class->get_property = xdp_inhibit_skeleton_get_property;
  gobject_class->set_property = xdp_inhibit_skeleton_set_property;
  gobject_class->notify       = xdp_inhibit_skeleton_notify;


  xdp_inhibit_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_inhibit_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_inhibit_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_inhibit_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_inhibit_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpInhibitSkeletonPrivate));
#endif
}

static void
xdp_inhibit_skeleton_iface_init (XdpInhibitIface *iface)
{
  iface->state_changed = _xdp_inhibit_on_signal_state_changed;
  iface->get_version = xdp_inhibit_skeleton_get_version;
}

/**
 * xdp_inhibit_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Inhibit.top_of_page">org.freedesktop.portal.Inhibit</link>.
 *
 * Returns: (transfer full) (type XdpInhibitSkeleton): The skeleton object.
 */
XdpInhibit *
xdp_inhibit_skeleton_new (void)
{
  return XDP_INHIBIT (g_object_new (XDP_TYPE_INHIBIT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Location
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpLocation
 * @title: XdpLocation
 * @short_description: Generated C code for the org.freedesktop.portal.Location D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Location ---- */

static const _ExtendedGDBusArgInfo _xdp_location_method_info_create_session_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_location_method_info_create_session_IN_ARG_pointers[] =
{
  &_xdp_location_method_info_create_session_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_location_method_info_create_session_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_location_method_info_create_session_OUT_ARG_pointers[] =
{
  &_xdp_location_method_info_create_session_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_location_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_xdp_location_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_location_method_info_create_session_OUT_ARG_pointers,
    NULL
  },
  "handle-create-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_location_method_info_start_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_location_method_info_start_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_location_method_info_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_location_method_info_start_IN_ARG_pointers[] =
{
  &_xdp_location_method_info_start_IN_ARG_session_handle.parent_struct,
  &_xdp_location_method_info_start_IN_ARG_parent_window.parent_struct,
  &_xdp_location_method_info_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_location_method_info_start_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_location_method_info_start_OUT_ARG_pointers[] =
{
  &_xdp_location_method_info_start_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_location_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_xdp_location_method_info_start_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_location_method_info_start_OUT_ARG_pointers,
    NULL
  },
  "handle-start",
  FALSE
};

static const GDBusMethodInfo * const _xdp_location_method_info_pointers[] =
{
  &_xdp_location_method_info_create_session.parent_struct,
  &_xdp_location_method_info_start.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_location_signal_info_location_updated_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_location_signal_info_location_updated_ARG_location =
{
  {
    -1,
    (gchar *) "location",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_location_signal_info_location_updated_ARG_pointers[] =
{
  &_xdp_location_signal_info_location_updated_ARG_session_handle.parent_struct,
  &_xdp_location_signal_info_location_updated_ARG_location.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_location_signal_info_location_updated =
{
  {
    -1,
    (gchar *) "LocationUpdated",
    (GDBusArgInfo **) &_xdp_location_signal_info_location_updated_ARG_pointers,
    NULL
  },
  "location-updated"
};

static const GDBusSignalInfo * const _xdp_location_signal_info_pointers[] =
{
  &_xdp_location_signal_info_location_updated.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_location_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_location_property_info_pointers[] =
{
  &_xdp_location_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_location_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Location",
    (GDBusMethodInfo **) &_xdp_location_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_location_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_location_property_info_pointers,
    NULL
  },
  "location",
};


/**
 * xdp_location_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_location_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_location_interface_info.parent_struct;
}

/**
 * xdp_location_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpLocation interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_location_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpLocation:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link>.
 */

/**
 * XdpLocationIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #XdpLocation::handle-create-session signal.
 * @handle_start: Handler for the #XdpLocation::handle-start signal.
 * @get_version: Getter for the #XdpLocation:version property.
 * @location_updated: Handler for the #XdpLocation::location-updated signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link>.
 */

typedef XdpLocationIface XdpLocationInterface;
G_DEFINE_INTERFACE (XdpLocation, xdp_location, G_TYPE_OBJECT)

static void
xdp_location_default_init (XdpLocationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpLocation::handle-create-session:
   * @object: A #XdpLocation.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Location.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_location_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpLocationIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * XdpLocation::handle-start:
   * @object: A #XdpLocation.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Location.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_location_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpLocationIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpLocation::location-updated:
   * @object: A #XdpLocation.
   * @arg_session_handle: Argument.
   * @arg_location: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Location.LocationUpdated">"LocationUpdated"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("location-updated",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpLocationIface, location_updated),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpLocation:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Location.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_location_get_version: (skip)
 * @object: A #XdpLocation.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Location.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_location_get_version (XdpLocation *object)
{
  return XDP_LOCATION_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_location_set_version: (skip)
 * @object: A #XdpLocation.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Location.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_location_set_version (XdpLocation *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_location_emit_location_updated:
 * @object: A #XdpLocation.
 * @arg_session_handle: Argument to pass with the signal.
 * @arg_location: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Location.LocationUpdated">"LocationUpdated"</link> D-Bus signal.
 */
void
xdp_location_emit_location_updated (
    XdpLocation *object,
    const gchar *arg_session_handle,
    GVariant *arg_location)
{
  g_signal_emit_by_name (object, "location-updated", arg_session_handle, arg_location);
}

/**
 * xdp_location_call_create_session:
 * @proxy: A #XdpLocationProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Location.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_location_call_create_session_finish() to get the result of the operation.
 *
 * See xdp_location_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
xdp_location_call_create_session (
    XdpLocation *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_location_call_create_session_finish:
 * @proxy: A #XdpLocationProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_location_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_location_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_location_call_create_session_finish (
    XdpLocation *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_location_call_create_session_sync:
 * @proxy: A #XdpLocationProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Location.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_location_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_location_call_create_session_sync (
    XdpLocation *proxy,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_location_call_start:
 * @proxy: A #XdpLocationProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Location.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_location_call_start_finish() to get the result of the operation.
 *
 * See xdp_location_call_start_sync() for the synchronous, blocking version of this method.
 */
void
xdp_location_call_start (
    XdpLocation *proxy,
    const gchar *arg_session_handle,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(os@a{sv})",
                   arg_session_handle,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_location_call_start_finish:
 * @proxy: A #XdpLocationProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_location_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_location_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_location_call_start_finish (
    XdpLocation *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_location_call_start_sync:
 * @proxy: A #XdpLocationProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Location.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_location_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_location_call_start_sync (
    XdpLocation *proxy,
    const gchar *arg_session_handle,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(os@a{sv})",
                   arg_session_handle,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_location_complete_create_session:
 * @object: A #XdpLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Location.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_location_complete_create_session (
    XdpLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_location_complete_start:
 * @object: A #XdpLocation.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Location.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_location_complete_start (
    XdpLocation *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpLocationProxy:
 *
 * The #XdpLocationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpLocationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpLocationProxy.
 */

struct _XdpLocationProxyPrivate
{
  GData *qdata;
};

static void xdp_location_proxy_iface_init (XdpLocationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpLocationProxy, xdp_location_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpLocationProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_LOCATION, xdp_location_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpLocationProxy, xdp_location_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_LOCATION, xdp_location_proxy_iface_init))

#endif
static void
xdp_location_proxy_finalize (GObject *object)
{
  XdpLocationProxy *proxy = XDP_LOCATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_location_proxy_parent_class)->finalize (object);
}

static void
xdp_location_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_location_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_location_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Location: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_location_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_location_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Location", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_location_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_location_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_location_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_LOCATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_LOCATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_location_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpLocationProxy *proxy = XDP_LOCATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_location_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_location_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_location_proxy_get_version (XdpLocation *object)
{
  XdpLocationProxy *proxy = XDP_LOCATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_location_proxy_init (XdpLocationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_location_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_LOCATION_PROXY, XdpLocationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_location_interface_info ());
}

static void
xdp_location_proxy_class_init (XdpLocationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_location_proxy_finalize;
  gobject_class->get_property = xdp_location_proxy_get_property;
  gobject_class->set_property = xdp_location_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_location_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_location_proxy_g_properties_changed;

  xdp_location_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpLocationProxyPrivate));
#endif
}

static void
xdp_location_proxy_iface_init (XdpLocationIface *iface)
{
  iface->get_version = xdp_location_proxy_get_version;
}

/**
 * xdp_location_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_location_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_location_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_location_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_LOCATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Location", NULL);
}

/**
 * xdp_location_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_location_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_location_proxy_new().
 *
 * Returns: (transfer full) (type XdpLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpLocation *
xdp_location_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_LOCATION (ret);
  else
    return NULL;
}

/**
 * xdp_location_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_location_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpLocation *
xdp_location_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_LOCATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Location", NULL);
  if (ret != NULL)
    return XDP_LOCATION (ret);
  else
    return NULL;
}


/**
 * xdp_location_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_location_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_location_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_location_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_location_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_LOCATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Location", NULL);
}

/**
 * xdp_location_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_location_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_location_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpLocation *
xdp_location_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_LOCATION (ret);
  else
    return NULL;
}

/**
 * xdp_location_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_location_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_location_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpLocationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpLocation *
xdp_location_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_LOCATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Location", NULL);
  if (ret != NULL)
    return XDP_LOCATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpLocationSkeleton:
 *
 * The #XdpLocationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpLocationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpLocationSkeleton.
 */

struct _XdpLocationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_location_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_LOCATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_LOCATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_location_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_location_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_location_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_location_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_location_skeleton_vtable =
{
  _xdp_location_skeleton_handle_method_call,
  _xdp_location_skeleton_handle_get_property,
  _xdp_location_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_location_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_location_interface_info ();
}

static GDBusInterfaceVTable *
xdp_location_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_location_skeleton_vtable;
}

static GVariant *
xdp_location_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_location_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_location_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_location_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_location_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Location", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_location_emit_changed (gpointer user_data);

static void
xdp_location_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_location_emit_changed (skeleton);
}

static void
_xdp_location_on_signal_location_updated (
    XdpLocation *object,
    const gchar *arg_session_handle,
    GVariant *arg_location)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_session_handle,
                   arg_location));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Location", "LocationUpdated",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_location_skeleton_iface_init (XdpLocationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpLocationSkeleton, xdp_location_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpLocationSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_LOCATION, xdp_location_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpLocationSkeleton, xdp_location_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_LOCATION, xdp_location_skeleton_iface_init))

#endif
static void
xdp_location_skeleton_finalize (GObject *object)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_location_skeleton_parent_class)->finalize (object);
}

static void
xdp_location_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_location_emit_changed (gpointer user_data)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Location",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_location_schedule_emit_changed (XdpLocationSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_location_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_location_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_location_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_location_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_location_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_location_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_location_skeleton_init (XdpLocationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_location_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_LOCATION_SKELETON, XdpLocationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_location_skeleton_get_version (XdpLocation *object)
{
  XdpLocationSkeleton *skeleton = XDP_LOCATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_location_skeleton_class_init (XdpLocationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_location_skeleton_finalize;
  gobject_class->get_property = xdp_location_skeleton_get_property;
  gobject_class->set_property = xdp_location_skeleton_set_property;
  gobject_class->notify       = xdp_location_skeleton_notify;


  xdp_location_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_location_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_location_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_location_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_location_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpLocationSkeletonPrivate));
#endif
}

static void
xdp_location_skeleton_iface_init (XdpLocationIface *iface)
{
  iface->location_updated = _xdp_location_on_signal_location_updated;
  iface->get_version = xdp_location_skeleton_get_version;
}

/**
 * xdp_location_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Location.top_of_page">org.freedesktop.portal.Location</link>.
 *
 * Returns: (transfer full) (type XdpLocationSkeleton): The skeleton object.
 */
XdpLocation *
xdp_location_skeleton_new (void)
{
  return XDP_LOCATION (g_object_new (XDP_TYPE_LOCATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.MemoryMonitor
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpMemoryMonitor
 * @title: XdpMemoryMonitor
 * @short_description: Generated C code for the org.freedesktop.portal.MemoryMonitor D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.MemoryMonitor ---- */

static const _ExtendedGDBusArgInfo _xdp_memory_monitor_signal_info_low_memory_warning_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "y",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_memory_monitor_signal_info_low_memory_warning_ARG_pointers[] =
{
  &_xdp_memory_monitor_signal_info_low_memory_warning_ARG_level.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_memory_monitor_signal_info_low_memory_warning =
{
  {
    -1,
    (gchar *) "LowMemoryWarning",
    (GDBusArgInfo **) &_xdp_memory_monitor_signal_info_low_memory_warning_ARG_pointers,
    NULL
  },
  "low-memory-warning"
};

static const GDBusSignalInfo * const _xdp_memory_monitor_signal_info_pointers[] =
{
  &_xdp_memory_monitor_signal_info_low_memory_warning.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_memory_monitor_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_memory_monitor_property_info_pointers[] =
{
  &_xdp_memory_monitor_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_memory_monitor_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.MemoryMonitor",
    NULL,
    (GDBusSignalInfo **) &_xdp_memory_monitor_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_memory_monitor_property_info_pointers,
    NULL
  },
  "memory-monitor",
};


/**
 * xdp_memory_monitor_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_memory_monitor_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_memory_monitor_interface_info.parent_struct;
}

/**
 * xdp_memory_monitor_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpMemoryMonitor interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_memory_monitor_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpMemoryMonitor:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link>.
 */

/**
 * XdpMemoryMonitorIface:
 * @parent_iface: The parent interface.
 * @get_version: Getter for the #XdpMemoryMonitor:version property.
 * @low_memory_warning: Handler for the #XdpMemoryMonitor::low-memory-warning signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link>.
 */

typedef XdpMemoryMonitorIface XdpMemoryMonitorInterface;
G_DEFINE_INTERFACE (XdpMemoryMonitor, xdp_memory_monitor, G_TYPE_OBJECT)

static void
xdp_memory_monitor_default_init (XdpMemoryMonitorIface *iface)
{
  /* GObject signals for received D-Bus signals: */
  /**
   * XdpMemoryMonitor::low-memory-warning:
   * @object: A #XdpMemoryMonitor.
   * @arg_level: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-MemoryMonitor.LowMemoryWarning">"LowMemoryWarning"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("low-memory-warning",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpMemoryMonitorIface, low_memory_warning),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_UCHAR);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpMemoryMonitor:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-MemoryMonitor.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_memory_monitor_get_version: (skip)
 * @object: A #XdpMemoryMonitor.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-MemoryMonitor.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_memory_monitor_get_version (XdpMemoryMonitor *object)
{
  return XDP_MEMORY_MONITOR_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_memory_monitor_set_version: (skip)
 * @object: A #XdpMemoryMonitor.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-MemoryMonitor.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_memory_monitor_set_version (XdpMemoryMonitor *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_memory_monitor_emit_low_memory_warning:
 * @object: A #XdpMemoryMonitor.
 * @arg_level: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-MemoryMonitor.LowMemoryWarning">"LowMemoryWarning"</link> D-Bus signal.
 */
void
xdp_memory_monitor_emit_low_memory_warning (
    XdpMemoryMonitor *object,
    guchar arg_level)
{
  g_signal_emit_by_name (object, "low-memory-warning", arg_level);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpMemoryMonitorProxy:
 *
 * The #XdpMemoryMonitorProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpMemoryMonitorProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpMemoryMonitorProxy.
 */

struct _XdpMemoryMonitorProxyPrivate
{
  GData *qdata;
};

static void xdp_memory_monitor_proxy_iface_init (XdpMemoryMonitorIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpMemoryMonitorProxy, xdp_memory_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpMemoryMonitorProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_MEMORY_MONITOR, xdp_memory_monitor_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpMemoryMonitorProxy, xdp_memory_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_MEMORY_MONITOR, xdp_memory_monitor_proxy_iface_init))

#endif
static void
xdp_memory_monitor_proxy_finalize (GObject *object)
{
  XdpMemoryMonitorProxy *proxy = XDP_MEMORY_MONITOR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_memory_monitor_proxy_parent_class)->finalize (object);
}

static void
xdp_memory_monitor_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_memory_monitor_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_memory_monitor_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.MemoryMonitor: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_memory_monitor_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_memory_monitor_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.MemoryMonitor", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_memory_monitor_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_memory_monitor_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_memory_monitor_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_MEMORY_MONITOR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_MEMORY_MONITOR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_memory_monitor_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpMemoryMonitorProxy *proxy = XDP_MEMORY_MONITOR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_memory_monitor_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_memory_monitor_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_memory_monitor_proxy_get_version (XdpMemoryMonitor *object)
{
  XdpMemoryMonitorProxy *proxy = XDP_MEMORY_MONITOR_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_memory_monitor_proxy_init (XdpMemoryMonitorProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_memory_monitor_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_MEMORY_MONITOR_PROXY, XdpMemoryMonitorProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_memory_monitor_interface_info ());
}

static void
xdp_memory_monitor_proxy_class_init (XdpMemoryMonitorProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_memory_monitor_proxy_finalize;
  gobject_class->get_property = xdp_memory_monitor_proxy_get_property;
  gobject_class->set_property = xdp_memory_monitor_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_memory_monitor_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_memory_monitor_proxy_g_properties_changed;

  xdp_memory_monitor_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpMemoryMonitorProxyPrivate));
#endif
}

static void
xdp_memory_monitor_proxy_iface_init (XdpMemoryMonitorIface *iface)
{
  iface->get_version = xdp_memory_monitor_proxy_get_version;
}

/**
 * xdp_memory_monitor_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_memory_monitor_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_memory_monitor_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_memory_monitor_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_MEMORY_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.MemoryMonitor", NULL);
}

/**
 * xdp_memory_monitor_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_memory_monitor_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_memory_monitor_proxy_new().
 *
 * Returns: (transfer full) (type XdpMemoryMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpMemoryMonitor *
xdp_memory_monitor_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_MEMORY_MONITOR (ret);
  else
    return NULL;
}

/**
 * xdp_memory_monitor_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_memory_monitor_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpMemoryMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpMemoryMonitor *
xdp_memory_monitor_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_MEMORY_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.MemoryMonitor", NULL);
  if (ret != NULL)
    return XDP_MEMORY_MONITOR (ret);
  else
    return NULL;
}


/**
 * xdp_memory_monitor_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_memory_monitor_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_memory_monitor_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_memory_monitor_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_memory_monitor_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_MEMORY_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.MemoryMonitor", NULL);
}

/**
 * xdp_memory_monitor_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_memory_monitor_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_memory_monitor_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpMemoryMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpMemoryMonitor *
xdp_memory_monitor_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_MEMORY_MONITOR (ret);
  else
    return NULL;
}

/**
 * xdp_memory_monitor_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_memory_monitor_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_memory_monitor_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpMemoryMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpMemoryMonitor *
xdp_memory_monitor_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_MEMORY_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.MemoryMonitor", NULL);
  if (ret != NULL)
    return XDP_MEMORY_MONITOR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpMemoryMonitorSkeleton:
 *
 * The #XdpMemoryMonitorSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpMemoryMonitorSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpMemoryMonitorSkeleton.
 */

struct _XdpMemoryMonitorSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_memory_monitor_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_MEMORY_MONITOR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_MEMORY_MONITOR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_memory_monitor_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_memory_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_memory_monitor_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_memory_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_memory_monitor_skeleton_vtable =
{
  _xdp_memory_monitor_skeleton_handle_method_call,
  _xdp_memory_monitor_skeleton_handle_get_property,
  _xdp_memory_monitor_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_memory_monitor_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_memory_monitor_interface_info ();
}

static GDBusInterfaceVTable *
xdp_memory_monitor_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_memory_monitor_skeleton_vtable;
}

static GVariant *
xdp_memory_monitor_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_memory_monitor_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_memory_monitor_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_memory_monitor_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_memory_monitor_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.MemoryMonitor", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_memory_monitor_emit_changed (gpointer user_data);

static void
xdp_memory_monitor_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_memory_monitor_emit_changed (skeleton);
}

static void
_xdp_memory_monitor_on_signal_low_memory_warning (
    XdpMemoryMonitor *object,
    guchar arg_level)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(y)",
                   arg_level));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.MemoryMonitor", "LowMemoryWarning",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_memory_monitor_skeleton_iface_init (XdpMemoryMonitorIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpMemoryMonitorSkeleton, xdp_memory_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpMemoryMonitorSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_MEMORY_MONITOR, xdp_memory_monitor_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpMemoryMonitorSkeleton, xdp_memory_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_MEMORY_MONITOR, xdp_memory_monitor_skeleton_iface_init))

#endif
static void
xdp_memory_monitor_skeleton_finalize (GObject *object)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_memory_monitor_skeleton_parent_class)->finalize (object);
}

static void
xdp_memory_monitor_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_memory_monitor_emit_changed (gpointer user_data)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.MemoryMonitor",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_memory_monitor_schedule_emit_changed (XdpMemoryMonitorSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_memory_monitor_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_memory_monitor_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_memory_monitor_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_memory_monitor_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_memory_monitor_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_memory_monitor_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_memory_monitor_skeleton_init (XdpMemoryMonitorSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_memory_monitor_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_MEMORY_MONITOR_SKELETON, XdpMemoryMonitorSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_memory_monitor_skeleton_get_version (XdpMemoryMonitor *object)
{
  XdpMemoryMonitorSkeleton *skeleton = XDP_MEMORY_MONITOR_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_memory_monitor_skeleton_class_init (XdpMemoryMonitorSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_memory_monitor_skeleton_finalize;
  gobject_class->get_property = xdp_memory_monitor_skeleton_get_property;
  gobject_class->set_property = xdp_memory_monitor_skeleton_set_property;
  gobject_class->notify       = xdp_memory_monitor_skeleton_notify;


  xdp_memory_monitor_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_memory_monitor_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_memory_monitor_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_memory_monitor_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_memory_monitor_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpMemoryMonitorSkeletonPrivate));
#endif
}

static void
xdp_memory_monitor_skeleton_iface_init (XdpMemoryMonitorIface *iface)
{
  iface->low_memory_warning = _xdp_memory_monitor_on_signal_low_memory_warning;
  iface->get_version = xdp_memory_monitor_skeleton_get_version;
}

/**
 * xdp_memory_monitor_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-MemoryMonitor.top_of_page">org.freedesktop.portal.MemoryMonitor</link>.
 *
 * Returns: (transfer full) (type XdpMemoryMonitorSkeleton): The skeleton object.
 */
XdpMemoryMonitor *
xdp_memory_monitor_skeleton_new (void)
{
  return XDP_MEMORY_MONITOR (g_object_new (XDP_TYPE_MEMORY_MONITOR_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.NetworkMonitor
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpNetworkMonitor
 * @title: XdpNetworkMonitor
 * @short_description: Generated C code for the org.freedesktop.portal.NetworkMonitor D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.NetworkMonitor ---- */

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_get_available_OUT_ARG_available =
{
  {
    -1,
    (gchar *) "available",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_network_monitor_method_info_get_available_OUT_ARG_pointers[] =
{
  &_xdp_network_monitor_method_info_get_available_OUT_ARG_available.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_network_monitor_method_info_get_available =
{
  {
    -1,
    (gchar *) "GetAvailable",
    NULL,
    (GDBusArgInfo **) &_xdp_network_monitor_method_info_get_available_OUT_ARG_pointers,
    NULL
  },
  "handle-get-available",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_get_metered_OUT_ARG_metered =
{
  {
    -1,
    (gchar *) "metered",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_network_monitor_method_info_get_metered_OUT_ARG_pointers[] =
{
  &_xdp_network_monitor_method_info_get_metered_OUT_ARG_metered.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_network_monitor_method_info_get_metered =
{
  {
    -1,
    (gchar *) "GetMetered",
    NULL,
    (GDBusArgInfo **) &_xdp_network_monitor_method_info_get_metered_OUT_ARG_pointers,
    NULL
  },
  "handle-get-metered",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_get_connectivity_OUT_ARG_connectivity =
{
  {
    -1,
    (gchar *) "connectivity",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_network_monitor_method_info_get_connectivity_OUT_ARG_pointers[] =
{
  &_xdp_network_monitor_method_info_get_connectivity_OUT_ARG_connectivity.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_network_monitor_method_info_get_connectivity =
{
  {
    -1,
    (gchar *) "GetConnectivity",
    NULL,
    (GDBusArgInfo **) &_xdp_network_monitor_method_info_get_connectivity_OUT_ARG_pointers,
    NULL
  },
  "handle-get-connectivity",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_get_status_OUT_ARG_status =
{
  {
    -1,
    (gchar *) "status",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_network_monitor_method_info_get_status_OUT_ARG_pointers[] =
{
  &_xdp_network_monitor_method_info_get_status_OUT_ARG_status.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_network_monitor_method_info_get_status =
{
  {
    -1,
    (gchar *) "GetStatus",
    NULL,
    (GDBusArgInfo **) &_xdp_network_monitor_method_info_get_status_OUT_ARG_pointers,
    NULL
  },
  "handle-get-status",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_can_reach_IN_ARG_hostname =
{
  {
    -1,
    (gchar *) "hostname",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_can_reach_IN_ARG_port =
{
  {
    -1,
    (gchar *) "port",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_network_monitor_method_info_can_reach_IN_ARG_pointers[] =
{
  &_xdp_network_monitor_method_info_can_reach_IN_ARG_hostname.parent_struct,
  &_xdp_network_monitor_method_info_can_reach_IN_ARG_port.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_network_monitor_method_info_can_reach_OUT_ARG_reachable =
{
  {
    -1,
    (gchar *) "reachable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_network_monitor_method_info_can_reach_OUT_ARG_pointers[] =
{
  &_xdp_network_monitor_method_info_can_reach_OUT_ARG_reachable.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_network_monitor_method_info_can_reach =
{
  {
    -1,
    (gchar *) "CanReach",
    (GDBusArgInfo **) &_xdp_network_monitor_method_info_can_reach_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_network_monitor_method_info_can_reach_OUT_ARG_pointers,
    NULL
  },
  "handle-can-reach",
  FALSE
};

static const GDBusMethodInfo * const _xdp_network_monitor_method_info_pointers[] =
{
  &_xdp_network_monitor_method_info_get_available.parent_struct,
  &_xdp_network_monitor_method_info_get_metered.parent_struct,
  &_xdp_network_monitor_method_info_get_connectivity.parent_struct,
  &_xdp_network_monitor_method_info_get_status.parent_struct,
  &_xdp_network_monitor_method_info_can_reach.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_network_monitor_signal_info_changed =
{
  {
    -1,
    (gchar *) "changed",
    NULL,
    NULL
  },
  "changed"
};

static const GDBusSignalInfo * const _xdp_network_monitor_signal_info_pointers[] =
{
  &_xdp_network_monitor_signal_info_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_network_monitor_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_network_monitor_property_info_pointers[] =
{
  &_xdp_network_monitor_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_network_monitor_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.NetworkMonitor",
    (GDBusMethodInfo **) &_xdp_network_monitor_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_network_monitor_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_network_monitor_property_info_pointers,
    NULL
  },
  "network-monitor",
};


/**
 * xdp_network_monitor_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_network_monitor_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_network_monitor_interface_info.parent_struct;
}

/**
 * xdp_network_monitor_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpNetworkMonitor interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_network_monitor_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpNetworkMonitor:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link>.
 */

/**
 * XdpNetworkMonitorIface:
 * @parent_iface: The parent interface.
 * @handle_can_reach: Handler for the #XdpNetworkMonitor::handle-can-reach signal.
 * @handle_get_available: Handler for the #XdpNetworkMonitor::handle-get-available signal.
 * @handle_get_connectivity: Handler for the #XdpNetworkMonitor::handle-get-connectivity signal.
 * @handle_get_metered: Handler for the #XdpNetworkMonitor::handle-get-metered signal.
 * @handle_get_status: Handler for the #XdpNetworkMonitor::handle-get-status signal.
 * @get_version: Getter for the #XdpNetworkMonitor:version property.
 * @changed: Handler for the #XdpNetworkMonitor::changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link>.
 */

typedef XdpNetworkMonitorIface XdpNetworkMonitorInterface;
G_DEFINE_INTERFACE (XdpNetworkMonitor, xdp_network_monitor, G_TYPE_OBJECT)

static void
xdp_network_monitor_default_init (XdpNetworkMonitorIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpNetworkMonitor::handle-get-available:
   * @object: A #XdpNetworkMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetAvailable">GetAvailable()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_network_monitor_complete_get_available() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-available",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNetworkMonitorIface, handle_get_available),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpNetworkMonitor::handle-get-metered:
   * @object: A #XdpNetworkMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetMetered">GetMetered()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_network_monitor_complete_get_metered() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-metered",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNetworkMonitorIface, handle_get_metered),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpNetworkMonitor::handle-get-connectivity:
   * @object: A #XdpNetworkMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetConnectivity">GetConnectivity()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_network_monitor_complete_get_connectivity() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-connectivity",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNetworkMonitorIface, handle_get_connectivity),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpNetworkMonitor::handle-get-status:
   * @object: A #XdpNetworkMonitor.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetStatus">GetStatus()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_network_monitor_complete_get_status() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-status",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNetworkMonitorIface, handle_get_status),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpNetworkMonitor::handle-can-reach:
   * @object: A #XdpNetworkMonitor.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_hostname: Argument passed by remote caller.
   * @arg_port: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.CanReach">CanReach()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_network_monitor_complete_can_reach() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-reach",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNetworkMonitorIface, handle_can_reach),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpNetworkMonitor::changed:
   * @object: A #XdpNetworkMonitor.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-NetworkMonitor.changed">"changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNetworkMonitorIface, changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpNetworkMonitor:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-NetworkMonitor.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_network_monitor_get_version: (skip)
 * @object: A #XdpNetworkMonitor.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-NetworkMonitor.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_network_monitor_get_version (XdpNetworkMonitor *object)
{
  return XDP_NETWORK_MONITOR_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_network_monitor_set_version: (skip)
 * @object: A #XdpNetworkMonitor.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-NetworkMonitor.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_network_monitor_set_version (XdpNetworkMonitor *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_network_monitor_emit_changed:
 * @object: A #XdpNetworkMonitor.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-NetworkMonitor.changed">"changed"</link> D-Bus signal.
 */
void
xdp_network_monitor_emit_changed (
    XdpNetworkMonitor *object)
{
  g_signal_emit_by_name (object, "changed");
}

/**
 * xdp_network_monitor_call_get_available:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetAvailable">GetAvailable()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_call_get_available_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_call_get_available_sync() for the synchronous, blocking version of this method.
 */
void
xdp_network_monitor_call_get_available (
    XdpNetworkMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAvailable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_network_monitor_call_get_available_finish:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_call_get_available().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_network_monitor_call_get_available().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_available_finish (
    XdpNetworkMonitor *proxy,
    gboolean *out_available,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_available_sync:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_available: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetAvailable">GetAvailable()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_call_get_available() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_available_sync (
    XdpNetworkMonitor *proxy,
    gboolean *out_available,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAvailable",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_available);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_metered:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetMetered">GetMetered()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_call_get_metered_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_call_get_metered_sync() for the synchronous, blocking version of this method.
 */
void
xdp_network_monitor_call_get_metered (
    XdpNetworkMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMetered",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_network_monitor_call_get_metered_finish:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_metered: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_call_get_metered().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_network_monitor_call_get_metered().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_metered_finish (
    XdpNetworkMonitor *proxy,
    gboolean *out_metered,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_metered);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_metered_sync:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_metered: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetMetered">GetMetered()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_call_get_metered() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_metered_sync (
    XdpNetworkMonitor *proxy,
    gboolean *out_metered,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMetered",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_metered);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_connectivity:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetConnectivity">GetConnectivity()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_call_get_connectivity_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_call_get_connectivity_sync() for the synchronous, blocking version of this method.
 */
void
xdp_network_monitor_call_get_connectivity (
    XdpNetworkMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetConnectivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_network_monitor_call_get_connectivity_finish:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_connectivity: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_call_get_connectivity().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_network_monitor_call_get_connectivity().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_connectivity_finish (
    XdpNetworkMonitor *proxy,
    guint *out_connectivity,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_connectivity);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_connectivity_sync:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_connectivity: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetConnectivity">GetConnectivity()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_call_get_connectivity() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_connectivity_sync (
    XdpNetworkMonitor *proxy,
    guint *out_connectivity,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetConnectivity",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_connectivity);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_status:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetStatus">GetStatus()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_call_get_status_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_call_get_status_sync() for the synchronous, blocking version of this method.
 */
void
xdp_network_monitor_call_get_status (
    XdpNetworkMonitor *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_network_monitor_call_get_status_finish:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_call_get_status().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_network_monitor_call_get_status().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_status_finish (
    XdpNetworkMonitor *proxy,
    GVariant **out_status,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_get_status_sync:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_status: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetStatus">GetStatus()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_call_get_status() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_get_status_sync (
    XdpNetworkMonitor *proxy,
    GVariant **out_status,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetStatus",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_status);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_can_reach:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @arg_hostname: Argument to pass with the method invocation.
 * @arg_port: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.CanReach">CanReach()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_call_can_reach_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_call_can_reach_sync() for the synchronous, blocking version of this method.
 */
void
xdp_network_monitor_call_can_reach (
    XdpNetworkMonitor *proxy,
    const gchar *arg_hostname,
    guint arg_port,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanReach",
    g_variant_new ("(su)",
                   arg_hostname,
                   arg_port),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_network_monitor_call_can_reach_finish:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @out_reachable: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_call_can_reach().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_network_monitor_call_can_reach().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_can_reach_finish (
    XdpNetworkMonitor *proxy,
    gboolean *out_reachable,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_reachable);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_call_can_reach_sync:
 * @proxy: A #XdpNetworkMonitorProxy.
 * @arg_hostname: Argument to pass with the method invocation.
 * @arg_port: Argument to pass with the method invocation.
 * @out_reachable: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.CanReach">CanReach()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_call_can_reach() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_network_monitor_call_can_reach_sync (
    XdpNetworkMonitor *proxy,
    const gchar *arg_hostname,
    guint arg_port,
    gboolean *out_reachable,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanReach",
    g_variant_new ("(su)",
                   arg_hostname,
                   arg_port),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_reachable);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_network_monitor_complete_get_available:
 * @object: A #XdpNetworkMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @available: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetAvailable">GetAvailable()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_network_monitor_complete_get_available (
    XdpNetworkMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean available)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   available));
}

/**
 * xdp_network_monitor_complete_get_metered:
 * @object: A #XdpNetworkMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @metered: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetMetered">GetMetered()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_network_monitor_complete_get_metered (
    XdpNetworkMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean metered)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   metered));
}

/**
 * xdp_network_monitor_complete_get_connectivity:
 * @object: A #XdpNetworkMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @connectivity: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetConnectivity">GetConnectivity()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_network_monitor_complete_get_connectivity (
    XdpNetworkMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint connectivity)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   connectivity));
}

/**
 * xdp_network_monitor_complete_get_status:
 * @object: A #XdpNetworkMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @status: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.GetStatus">GetStatus()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_network_monitor_complete_get_status (
    XdpNetworkMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *status)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   status));
}

/**
 * xdp_network_monitor_complete_can_reach:
 * @object: A #XdpNetworkMonitor.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @reachable: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-NetworkMonitor.CanReach">CanReach()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_network_monitor_complete_can_reach (
    XdpNetworkMonitor *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean reachable)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   reachable));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpNetworkMonitorProxy:
 *
 * The #XdpNetworkMonitorProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpNetworkMonitorProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpNetworkMonitorProxy.
 */

struct _XdpNetworkMonitorProxyPrivate
{
  GData *qdata;
};

static void xdp_network_monitor_proxy_iface_init (XdpNetworkMonitorIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpNetworkMonitorProxy, xdp_network_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpNetworkMonitorProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NETWORK_MONITOR, xdp_network_monitor_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpNetworkMonitorProxy, xdp_network_monitor_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NETWORK_MONITOR, xdp_network_monitor_proxy_iface_init))

#endif
static void
xdp_network_monitor_proxy_finalize (GObject *object)
{
  XdpNetworkMonitorProxy *proxy = XDP_NETWORK_MONITOR_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_network_monitor_proxy_parent_class)->finalize (object);
}

static void
xdp_network_monitor_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_network_monitor_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_network_monitor_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.NetworkMonitor: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_network_monitor_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_network_monitor_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.NetworkMonitor", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_network_monitor_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_network_monitor_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_network_monitor_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_NETWORK_MONITOR);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_NETWORK_MONITOR);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_network_monitor_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpNetworkMonitorProxy *proxy = XDP_NETWORK_MONITOR_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_network_monitor_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_network_monitor_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_network_monitor_proxy_get_version (XdpNetworkMonitor *object)
{
  XdpNetworkMonitorProxy *proxy = XDP_NETWORK_MONITOR_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_network_monitor_proxy_init (XdpNetworkMonitorProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_network_monitor_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_NETWORK_MONITOR_PROXY, XdpNetworkMonitorProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_network_monitor_interface_info ());
}

static void
xdp_network_monitor_proxy_class_init (XdpNetworkMonitorProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_network_monitor_proxy_finalize;
  gobject_class->get_property = xdp_network_monitor_proxy_get_property;
  gobject_class->set_property = xdp_network_monitor_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_network_monitor_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_network_monitor_proxy_g_properties_changed;

  xdp_network_monitor_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpNetworkMonitorProxyPrivate));
#endif
}

static void
xdp_network_monitor_proxy_iface_init (XdpNetworkMonitorIface *iface)
{
  iface->get_version = xdp_network_monitor_proxy_get_version;
}

/**
 * xdp_network_monitor_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_network_monitor_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_NETWORK_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.NetworkMonitor", NULL);
}

/**
 * xdp_network_monitor_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_network_monitor_proxy_new().
 *
 * Returns: (transfer full) (type XdpNetworkMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNetworkMonitor *
xdp_network_monitor_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_NETWORK_MONITOR (ret);
  else
    return NULL;
}

/**
 * xdp_network_monitor_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpNetworkMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNetworkMonitor *
xdp_network_monitor_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_NETWORK_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.NetworkMonitor", NULL);
  if (ret != NULL)
    return XDP_NETWORK_MONITOR (ret);
  else
    return NULL;
}


/**
 * xdp_network_monitor_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_network_monitor_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_network_monitor_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_network_monitor_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_network_monitor_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_NETWORK_MONITOR_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.NetworkMonitor", NULL);
}

/**
 * xdp_network_monitor_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_network_monitor_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_network_monitor_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpNetworkMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNetworkMonitor *
xdp_network_monitor_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_NETWORK_MONITOR (ret);
  else
    return NULL;
}

/**
 * xdp_network_monitor_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_network_monitor_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_network_monitor_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpNetworkMonitorProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNetworkMonitor *
xdp_network_monitor_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_NETWORK_MONITOR_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.NetworkMonitor", NULL);
  if (ret != NULL)
    return XDP_NETWORK_MONITOR (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpNetworkMonitorSkeleton:
 *
 * The #XdpNetworkMonitorSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpNetworkMonitorSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpNetworkMonitorSkeleton.
 */

struct _XdpNetworkMonitorSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_network_monitor_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_NETWORK_MONITOR);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_NETWORK_MONITOR);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_network_monitor_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_network_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_network_monitor_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_network_monitor_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_network_monitor_skeleton_vtable =
{
  _xdp_network_monitor_skeleton_handle_method_call,
  _xdp_network_monitor_skeleton_handle_get_property,
  _xdp_network_monitor_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_network_monitor_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_network_monitor_interface_info ();
}

static GDBusInterfaceVTable *
xdp_network_monitor_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_network_monitor_skeleton_vtable;
}

static GVariant *
xdp_network_monitor_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_network_monitor_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_network_monitor_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_network_monitor_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_network_monitor_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.NetworkMonitor", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_network_monitor_emit_changed (gpointer user_data);

static void
xdp_network_monitor_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_network_monitor_emit_changed (skeleton);
}

static void
_xdp_network_monitor_on_signal_changed (
    XdpNetworkMonitor *object)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.NetworkMonitor", "changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_network_monitor_skeleton_iface_init (XdpNetworkMonitorIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpNetworkMonitorSkeleton, xdp_network_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpNetworkMonitorSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NETWORK_MONITOR, xdp_network_monitor_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpNetworkMonitorSkeleton, xdp_network_monitor_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NETWORK_MONITOR, xdp_network_monitor_skeleton_iface_init))

#endif
static void
xdp_network_monitor_skeleton_finalize (GObject *object)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_network_monitor_skeleton_parent_class)->finalize (object);
}

static void
xdp_network_monitor_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_network_monitor_emit_changed (gpointer user_data)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.NetworkMonitor",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_network_monitor_schedule_emit_changed (XdpNetworkMonitorSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_network_monitor_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_network_monitor_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_network_monitor_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_network_monitor_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_network_monitor_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_network_monitor_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_network_monitor_skeleton_init (XdpNetworkMonitorSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_network_monitor_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_NETWORK_MONITOR_SKELETON, XdpNetworkMonitorSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_network_monitor_skeleton_get_version (XdpNetworkMonitor *object)
{
  XdpNetworkMonitorSkeleton *skeleton = XDP_NETWORK_MONITOR_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_network_monitor_skeleton_class_init (XdpNetworkMonitorSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_network_monitor_skeleton_finalize;
  gobject_class->get_property = xdp_network_monitor_skeleton_get_property;
  gobject_class->set_property = xdp_network_monitor_skeleton_set_property;
  gobject_class->notify       = xdp_network_monitor_skeleton_notify;


  xdp_network_monitor_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_network_monitor_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_network_monitor_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_network_monitor_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_network_monitor_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpNetworkMonitorSkeletonPrivate));
#endif
}

static void
xdp_network_monitor_skeleton_iface_init (XdpNetworkMonitorIface *iface)
{
  iface->changed = _xdp_network_monitor_on_signal_changed;
  iface->get_version = xdp_network_monitor_skeleton_get_version;
}

/**
 * xdp_network_monitor_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-NetworkMonitor.top_of_page">org.freedesktop.portal.NetworkMonitor</link>.
 *
 * Returns: (transfer full) (type XdpNetworkMonitorSkeleton): The skeleton object.
 */
XdpNetworkMonitor *
xdp_network_monitor_skeleton_new (void)
{
  return XDP_NETWORK_MONITOR (g_object_new (XDP_TYPE_NETWORK_MONITOR_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.Notification
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpNotification
 * @title: XdpNotification
 * @short_description: Generated C code for the org.freedesktop.portal.Notification D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.Notification ---- */

static const _ExtendedGDBusArgInfo _xdp_notification_method_info_add_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_notification_method_info_add_notification_IN_ARG_notification =
{
  {
    -1,
    (gchar *) "notification",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_notification_method_info_add_notification_IN_ARG_pointers[] =
{
  &_xdp_notification_method_info_add_notification_IN_ARG_id.parent_struct,
  &_xdp_notification_method_info_add_notification_IN_ARG_notification.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_notification_method_info_add_notification =
{
  {
    -1,
    (gchar *) "AddNotification",
    (GDBusArgInfo **) &_xdp_notification_method_info_add_notification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-add-notification",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_notification_method_info_remove_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_notification_method_info_remove_notification_IN_ARG_pointers[] =
{
  &_xdp_notification_method_info_remove_notification_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_notification_method_info_remove_notification =
{
  {
    -1,
    (gchar *) "RemoveNotification",
    (GDBusArgInfo **) &_xdp_notification_method_info_remove_notification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-notification",
  FALSE
};

static const GDBusMethodInfo * const _xdp_notification_method_info_pointers[] =
{
  &_xdp_notification_method_info_add_notification.parent_struct,
  &_xdp_notification_method_info_remove_notification.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_notification_signal_info_action_invoked_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_notification_signal_info_action_invoked_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_notification_signal_info_action_invoked_ARG_parameter =
{
  {
    -1,
    (gchar *) "parameter",
    (gchar *) "av",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_notification_signal_info_action_invoked_ARG_pointers[] =
{
  &_xdp_notification_signal_info_action_invoked_ARG_id.parent_struct,
  &_xdp_notification_signal_info_action_invoked_ARG_action.parent_struct,
  &_xdp_notification_signal_info_action_invoked_ARG_parameter.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_notification_signal_info_action_invoked =
{
  {
    -1,
    (gchar *) "ActionInvoked",
    (GDBusArgInfo **) &_xdp_notification_signal_info_action_invoked_ARG_pointers,
    NULL
  },
  "action-invoked"
};

static const GDBusSignalInfo * const _xdp_notification_signal_info_pointers[] =
{
  &_xdp_notification_signal_info_action_invoked.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_notification_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_notification_property_info_pointers[] =
{
  &_xdp_notification_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_notification_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.Notification",
    (GDBusMethodInfo **) &_xdp_notification_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_notification_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_notification_property_info_pointers,
    NULL
  },
  "notification",
};


/**
 * xdp_notification_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_notification_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_notification_interface_info.parent_struct;
}

/**
 * xdp_notification_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpNotification interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_notification_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpNotification:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link>.
 */

/**
 * XdpNotificationIface:
 * @parent_iface: The parent interface.
 * @handle_add_notification: Handler for the #XdpNotification::handle-add-notification signal.
 * @handle_remove_notification: Handler for the #XdpNotification::handle-remove-notification signal.
 * @get_version: Getter for the #XdpNotification:version property.
 * @action_invoked: Handler for the #XdpNotification::action-invoked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link>.
 */

typedef XdpNotificationIface XdpNotificationInterface;
G_DEFINE_INTERFACE (XdpNotification, xdp_notification, G_TYPE_OBJECT)

static void
xdp_notification_default_init (XdpNotificationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpNotification::handle-add-notification:
   * @object: A #XdpNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   * @arg_notification: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Notification.AddNotification">AddNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_notification_complete_add_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNotificationIface, handle_add_notification),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpNotification::handle-remove-notification:
   * @object: A #XdpNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_notification_complete_remove_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNotificationIface, handle_remove_notification),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpNotification::action-invoked:
   * @object: A #XdpNotification.
   * @arg_id: Argument.
   * @arg_action: Argument.
   * @arg_parameter: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-portal-Notification.ActionInvoked">"ActionInvoked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("action-invoked",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpNotificationIface, action_invoked),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpNotification:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-Notification.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_notification_get_version: (skip)
 * @object: A #XdpNotification.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-Notification.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_notification_get_version (XdpNotification *object)
{
  return XDP_NOTIFICATION_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_notification_set_version: (skip)
 * @object: A #XdpNotification.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-Notification.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_notification_set_version (XdpNotification *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_notification_emit_action_invoked:
 * @object: A #XdpNotification.
 * @arg_id: Argument to pass with the signal.
 * @arg_action: Argument to pass with the signal.
 * @arg_parameter: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-portal-Notification.ActionInvoked">"ActionInvoked"</link> D-Bus signal.
 */
void
xdp_notification_emit_action_invoked (
    XdpNotification *object,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  g_signal_emit_by_name (object, "action-invoked", arg_id, arg_action, arg_parameter);
}

/**
 * xdp_notification_call_add_notification:
 * @proxy: A #XdpNotificationProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_notification_call_add_notification_finish() to get the result of the operation.
 *
 * See xdp_notification_call_add_notification_sync() for the synchronous, blocking version of this method.
 */
void
xdp_notification_call_add_notification (
    XdpNotification *proxy,
    const gchar *arg_id,
    GVariant *arg_notification,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(s@a{sv})",
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_notification_call_add_notification_finish:
 * @proxy: A #XdpNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_notification_call_add_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_notification_call_add_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_notification_call_add_notification_finish (
    XdpNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_notification_call_add_notification_sync:
 * @proxy: A #XdpNotificationProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_notification_call_add_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_notification_call_add_notification_sync (
    XdpNotification *proxy,
    const gchar *arg_id,
    GVariant *arg_notification,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(s@a{sv})",
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_notification_call_remove_notification:
 * @proxy: A #XdpNotificationProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_notification_call_remove_notification_finish() to get the result of the operation.
 *
 * See xdp_notification_call_remove_notification_sync() for the synchronous, blocking version of this method.
 */
void
xdp_notification_call_remove_notification (
    XdpNotification *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_notification_call_remove_notification_finish:
 * @proxy: A #XdpNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_notification_call_remove_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_notification_call_remove_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_notification_call_remove_notification_finish (
    XdpNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_notification_call_remove_notification_sync:
 * @proxy: A #XdpNotificationProxy.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_notification_call_remove_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_notification_call_remove_notification_sync (
    XdpNotification *proxy,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(s)",
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_notification_complete_add_notification:
 * @object: A #XdpNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Notification.AddNotification">AddNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_notification_complete_add_notification (
    XdpNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_notification_complete_remove_notification:
 * @object: A #XdpNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_notification_complete_remove_notification (
    XdpNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpNotificationProxy:
 *
 * The #XdpNotificationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpNotificationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpNotificationProxy.
 */

struct _XdpNotificationProxyPrivate
{
  GData *qdata;
};

static void xdp_notification_proxy_iface_init (XdpNotificationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpNotificationProxy, xdp_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpNotificationProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NOTIFICATION, xdp_notification_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpNotificationProxy, xdp_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NOTIFICATION, xdp_notification_proxy_iface_init))

#endif
static void
xdp_notification_proxy_finalize (GObject *object)
{
  XdpNotificationProxy *proxy = XDP_NOTIFICATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_notification_proxy_parent_class)->finalize (object);
}

static void
xdp_notification_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_notification_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_notification_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.Notification: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_notification_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_notification_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.Notification", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_notification_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_notification_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_notification_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_NOTIFICATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_notification_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpNotificationProxy *proxy = XDP_NOTIFICATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_notification_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_notification_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_notification_proxy_get_version (XdpNotification *object)
{
  XdpNotificationProxy *proxy = XDP_NOTIFICATION_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_notification_proxy_init (XdpNotificationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_notification_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_TYPE_NOTIFICATION_PROXY, XdpNotificationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_notification_interface_info ());
}

static void
xdp_notification_proxy_class_init (XdpNotificationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_notification_proxy_finalize;
  gobject_class->get_property = xdp_notification_proxy_get_property;
  gobject_class->set_property = xdp_notification_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_notification_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_notification_proxy_g_properties_changed;

  xdp_notification_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpNotificationProxyPrivate));
#endif
}

static void
xdp_notification_proxy_iface_init (XdpNotificationIface *iface)
{
  iface->get_version = xdp_notification_proxy_get_version;
}

/**
 * xdp_notification_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_notification_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_notification_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_notification_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Notification", NULL);
}

/**
 * xdp_notification_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_notification_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_notification_proxy_new().
 *
 * Returns: (transfer full) (type XdpNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNotification *
xdp_notification_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * xdp_notification_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_notification_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNotification *
xdp_notification_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Notification", NULL);
  if (ret != NULL)
    return XDP_NOTIFICATION (ret);
  else
    return NULL;
}


/**
 * xdp_notification_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_notification_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_notification_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_notification_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_notification_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Notification", NULL);
}

/**
 * xdp_notification_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_notification_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_notification_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNotification *
xdp_notification_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * xdp_notification_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_notification_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_notification_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpNotification *
xdp_notification_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.portal.Notification", NULL);
  if (ret != NULL)
    return XDP_NOTIFICATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpNotificationSkeleton:
 *
 * The #XdpNotificationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpNotificationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpNotificationSkeleton.
 */

struct _XdpNotificationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_notification_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_NOTIFICATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_notification_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_notification_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_notification_skeleton_vtable =
{
  _xdp_notification_skeleton_handle_method_call,
  _xdp_notification_skeleton_handle_get_property,
  _xdp_notification_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_notification_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_notification_interface_info ();
}

static GDBusInterfaceVTable *
xdp_notification_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_notification_skeleton_vtable;
}

static GVariant *
xdp_notification_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_notification_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_notification_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_notification_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_notification_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Notification", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_notification_emit_changed (gpointer user_data);

static void
xdp_notification_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_notification_emit_changed (skeleton);
}

static void
_xdp_notification_on_signal_action_invoked (
    XdpNotification *object,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss@av)",
                   arg_id,
                   arg_action,
                   arg_parameter));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.portal.Notification", "ActionInvoked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_notification_skeleton_iface_init (XdpNotificationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpNotificationSkeleton, xdp_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpNotificationSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NOTIFICATION, xdp_notification_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpNotificationSkeleton, xdp_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_NOTIFICATION, xdp_notification_skeleton_iface_init))

#endif
static void
xdp_notification_skeleton_finalize (GObject *object)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_notification_skeleton_parent_class)->finalize (object);
}

static void
xdp_notification_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_notification_emit_changed (gpointer user_data)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.portal.Notification",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_notification_schedule_emit_changed (XdpNotificationSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_notification_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_notification_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_notification_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_notification_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_notification_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_notification_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_notification_skeleton_init (XdpNotificationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_notification_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_TYPE_NOTIFICATION_SKELETON, XdpNotificationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_notification_skeleton_get_version (XdpNotification *object)
{
  XdpNotificationSkeleton *skeleton = XDP_NOTIFICATION_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_notification_skeleton_class_init (XdpNotificationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_notification_skeleton_finalize;
  gobject_class->get_property = xdp_notification_skeleton_get_property;
  gobject_class->set_property = xdp_notification_skeleton_set_property;
  gobject_class->notify       = xdp_notification_skeleton_notify;


  xdp_notification_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_notification_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_notification_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_notification_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_notification_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpNotificationSkeletonPrivate));
#endif
}

static void
xdp_notification_skeleton_iface_init (XdpNotificationIface *iface)
{
  iface->action_invoked = _xdp_notification_on_signal_action_invoked;
  iface->get_version = xdp_notification_skeleton_get_version;
}

/**
 * xdp_notification_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-Notification.top_of_page">org.freedesktop.portal.Notification</link>.
 *
 * Returns: (transfer full) (type XdpNotificationSkeleton): The skeleton object.
 */
XdpNotification *
xdp_notification_skeleton_new (void)
{
  return XDP_NOTIFICATION (g_object_new (XDP_TYPE_NOTIFICATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.portal.OpenURI
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpOpenURI
 * @title: XdpOpenURI
 * @short_description: Generated C code for the org.freedesktop.portal.OpenURI D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-portal-OpenURI.top_of_page">org.freedesktop.portal.OpenURI</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.portal.OpenURI ---- */

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_uri_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_uri_IN_ARG_uri =
{
  {
    -1,
    (gchar *) "uri",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_uri_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_open_uri_method_info_open_uri_IN_ARG_pointers[] =
{
  &_xdp_open_uri_method_info_open_uri_IN_ARG_parent_window.parent_struct,
  &_xdp_open_uri_method_info_open_uri_IN_ARG_uri.parent_struct,
  &_xdp_open_uri_method_info_open_uri_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_uri_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_open_uri_method_info_open_uri_OUT_ARG_pointers[] =
{
  &_xdp_open_uri_method_info_open_uri_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_open_uri_method_info_open_uri =
{
  {
    -1,
    (gchar *) "OpenURI",
    (GDBusArgInfo **) &_xdp_open_uri_method_info_open_uri_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_open_uri_method_info_open_uri_OUT_ARG_pointers,
    NULL
  },
  "handle-open-uri",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_file_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_open_uri_method_info_open_file_IN_ARG_pointers[] =
{
  &_xdp_open_uri_method_info_open_file_IN_ARG_parent_window.parent_struct,
  &_xdp_open_uri_method_info_open_file_IN_ARG_fd.parent_struct,
  &_xdp_open_uri_method_info_open_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_file_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_open_uri_method_info_open_file_OUT_ARG_pointers[] =
{
  &_xdp_open_uri_method_info_open_file_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_open_uri_method_info_open_file =
{
  {
    -1,
    (gchar *) "OpenFile",
    (GDBusArgInfo **) &_xdp_open_uri_method_info_open_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_open_uri_method_info_open_file_OUT_ARG_pointers,
    NULL
  },
  "handle-open-file",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_directory_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_directory_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_directory_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_open_uri_method_info_open_directory_IN_ARG_pointers[] =
{
  &_xdp_open_uri_method_info_open_directory_IN_ARG_parent_window.parent_struct,
  &_xdp_open_uri_method_info_open_directory_IN_ARG_fd.parent_struct,
  &_xdp_open_uri_method_info_open_directory_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_open_uri_method_info_open_directory_OUT_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_open_uri_method_info_open_directory_OUT_ARG_pointers[] =
{
  &_xdp_open_uri_method_info_open_directory_OUT_ARG_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_open_uri_method_info_open_directory =
{
  {
    -1,
    (gchar *) "OpenDirectory",
    (GDBusArgInfo **) &_xdp_open_uri_method_info_open_directory_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_open_uri_method_info_open_directory_OUT_ARG_pointers,
    NULL
  },
  "handle-open-directory",
  TRUE
};

static const GDBusMethodInfo * const _xdp_open_uri_method_info_pointers[] =
{
  &_xdp_open_uri_method_info_open_uri.parent_struct,
  &_xdp_open_uri_method_info_open_file.parent_struct,
  &_xdp_open_uri_method_info_open_directory.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_open_uri_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_open_uri_property_info_pointers[] =
{
  &_xdp_open_uri_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_open_uri_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.portal.OpenURI",
    (GDBusMethodInfo **) &_xdp_open_uri_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_open_uri_property_info_pointers,
    NULL
  },
  "open-uri",
};


/**
 * xdp_open_uri_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-portal-OpenURI.top_of_page">org.freedesktop.portal.OpenURI</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_open_uri_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_open_uri_interface_info.parent_struct;
}

/**
 * xdp_open_uri_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpOpenURI interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_open_uri_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpOpenURI:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-OpenURI.top_of_page">org.freedesktop.portal.OpenURI</link>.
 */

/**
 * XdpOpenURIIface:
 * @parent_iface: The parent interface.
 * @handle_open_directory: Handler for the #XdpOpenURI::handle-open-directory signal.
 * @handle_open_file: Handler for the #XdpOpenURI::handle-open-file signal.
 * @handle_open_uri: Handler for the #XdpOpenURI::handle-open-uri signal.
 * @get_version: Getter for the #XdpOpenURI:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-portal-OpenURI.top_of_page">org.freedesktop.portal.OpenURI</link>.
 */

typedef XdpOpenURIIface XdpOpenURIInterface;
G_DEFINE_INTERFACE (XdpOpenURI, xdp_open_uri, G_TYPE_OBJECT)

static void
xdp_open_uri_default_init (XdpOpenURIIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpOpenURI::handle-open-uri:
   * @object: A #XdpOpenURI.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_uri: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenURI">OpenURI()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_open_uri_complete_open_uri() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-uri",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpOpenURIIface, handle_open_uri),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpOpenURI::handle-open-file:
   * @object: A #XdpOpenURI.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_fd: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenFile">OpenFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_open_uri_complete_open_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpOpenURIIface, handle_open_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpOpenURI::handle-open-directory:
   * @object: A #XdpOpenURI.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_fd: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenDirectory">OpenDirectory()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_open_uri_complete_open_directory() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-directory",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpOpenURIIface, handle_open_directory),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpOpenURI:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-portal-OpenURI.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_open_uri_get_version: (skip)
 * @object: A #XdpOpenURI.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-portal-OpenURI.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_open_uri_get_version (XdpOpenURI *object)
{
  return XDP_OPEN_URI_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_open_uri_set_version: (skip)
 * @object: A #XdpOpenURI.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-portal-OpenURI.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_open_uri_set_version (XdpOpenURI *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_open_uri_call_open_uri:
 * @proxy: A #XdpOpenURIProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenURI">OpenURI()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_open_uri_call_open_uri_finish() to get the result of the operation.
 *
 * See xdp_open_uri_call_open_uri_sync() for the synchronous, blocking version of this method.
 */
void
xdp_open_uri_call_open_uri (
    XdpOpenURI *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_uri,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenURI",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_uri,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_open_uri_call_open_uri_finish:
 * @proxy: A #XdpOpenURIProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_open_uri_call_open_uri().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_open_uri_call_open_uri().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_open_uri_call_open_uri_finish (
    XdpOpenURI *proxy,
    gchar **out_handle,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_open_uri_call_open_uri_sync:
 * @proxy: A #XdpOpenURIProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_uri: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenURI">OpenURI()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_open_uri_call_open_uri() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_open_uri_call_open_uri_sync (
    XdpOpenURI *proxy,
    const gchar *arg_parent_window,
    const gchar *arg_uri,
    GVariant *arg_options,
    gchar **out_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenURI",
    g_variant_new ("(ss@a{sv})",
                   arg_parent_window,
                   arg_uri,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_open_uri_call_open_file:
 * @proxy: A #XdpOpenURIProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenFile">OpenFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_open_uri_call_open_file_finish() to get the result of the operation.
 *
 * See xdp_open_uri_call_open_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_open_uri_call_open_file (
    XdpOpenURI *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(s@h@a{sv})",
                   arg_parent_window,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_open_uri_call_open_file_finish:
 * @proxy: A #XdpOpenURIProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_open_uri_call_open_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_open_uri_call_open_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_open_uri_call_open_file_finish (
    XdpOpenURI *proxy,
    gchar **out_handle,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_open_uri_call_open_file_sync:
 * @proxy: A #XdpOpenURIProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenFile">OpenFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_open_uri_call_open_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_open_uri_call_open_file_sync (
    XdpOpenURI *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    gchar **out_handle,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(s@h@a{sv})",
                   arg_parent_window,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_open_uri_call_open_directory:
 * @proxy: A #XdpOpenURIProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenDirectory">OpenDirectory()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_open_uri_call_open_directory_finish() to get the result of the operation.
 *
 * See xdp_open_uri_call_open_directory_sync() for the synchronous, blocking version of this method.
 */
void
xdp_open_uri_call_open_directory (
    XdpOpenURI *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "OpenDirectory",
    g_variant_new ("(s@h@a{sv})",
                   arg_parent_window,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_open_uri_call_open_directory_finish:
 * @proxy: A #XdpOpenURIProxy.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_open_uri_call_open_directory().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_open_uri_call_open_directory().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_open_uri_call_open_directory_finish (
    XdpOpenURI *proxy,
    gchar **out_handle,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_open_uri_call_open_directory_sync:
 * @proxy: A #XdpOpenURIProxy.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_handle: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenDirectory">OpenDirectory()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_open_uri_call_open_directory() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_open_uri_call_open_directory_sync (
    XdpOpenURI *proxy,
    const gchar *arg_parent_window,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    gchar **out_handle,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "OpenDirectory",
    g_variant_new ("(s@h@a{sv})",
                   arg_parent_window,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_handle);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_open_uri_complete_open_uri:
 * @object: A #XdpOpenURI.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenURI">OpenURI()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_open_uri_complete_open_uri (
    XdpOpenURI *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   handle));
}

/**
 * xdp_open_uri_complete_open_file:
 * @object: A #XdpOpenURI.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenFile">OpenFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_open_uri_complete_open_file (
    XdpOpenURI *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(o)",
                   handle),
    fd_list);
}

/**
 * xdp_open_uri_complete_open_directory:
 * @object: A #XdpOpenURI.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @handle: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-portal-OpenURI.OpenDirectory">OpenDirectory()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_open_uri_complete_open_directory (
    XdpOpenURI *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    const gchar *handle)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(o)",
                   handle),
    fd_list);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpOpenURIProxy:
 *
 * The #XdpOpenURIProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpOpenURIProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpOpenURIProxy.
 */

struct _XdpOpenURIProxyPrivate
{
  GData *qdata;
};

static void xdp_open_uri_proxy_iface_init (XdpOpenURIIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpOpenURIProxy, xdp_open_uri_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpOpenURIProxy)
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_OPEN_URI, xdp_open_uri_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpOpenURIProxy, xdp_open_uri_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_TYPE_OPEN_URI, xdp_open_uri_proxy_iface_init))

#endif
static void
xdp_open_uri_proxy_finalize (GObject *object)
{
  XdpOpenURIProxy *proxy = XDP_OPEN_URI_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_open_uri_proxy_parent_class)->finalize (object);
}

static void
xdp_open_uri_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_open_uri_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_open_uri_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.portal.OpenURI: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_open_uri_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_open_uri_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.portal.OpenURI", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_open_uri_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_open_uri_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_open_uri_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_TYPE_OPEN_URI);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_TYPE_OPEN_URI);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_open_uri_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpOpenURIProxy *proxy = XDP_OPEN_URI_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_open_uri_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_open_uri_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_open_uri_proxy_get_version (XdpOpenURI *object)
{
  XdpOpenURIProxy *proxy = XDP_OPEN_URI_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (p