/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ui.ContributedPlatformReleases;
import cc.arduino.contributions.packages.ui.ContributedPlatformTableCellJPanel;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.ReverseComparator;
import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;
import processing.app.I18n;

public class ContributedPlatformTableCellEditor
extends InstallerTableCell {
    private ContributedPlatformTableCellJPanel cell;
    private ContributedPlatformReleases value;

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object _value, boolean isSelected, int row, int column) {
        this.value = (ContributedPlatformReleases)_value;
        this.cell = new ContributedPlatformTableCellJPanel();
        this.cell.installButton.addActionListener(e -> this.onInstall(this.value.getSelected(), this.value.getInstalled()));
        this.cell.removeButton.addActionListener(e -> this.onRemove(this.value.getInstalled()));
        this.cell.downgradeButton.addActionListener(e -> {
            ContributedPlatform selected = (ContributedPlatform)this.cell.downgradeChooser.getSelectedItem();
            this.onInstall(selected, this.value.getInstalled());
        });
        this.cell.versionToInstallChooser.addActionListener(e -> {
            this.value.select((ContributedPlatform)this.cell.versionToInstallChooser.getSelectedItem());
            if (this.cell.versionToInstallChooser.getSelectedIndex() != 0) {
                InstallerTableCell.dropdownSelected(true);
            }
        });
        this.setEnabled(true);
        ContributedPlatform installed = this.value.getInstalled();
        LinkedList<ContributedPlatform> releases = new LinkedList<ContributedPlatform>(this.value.releases);
        List<ContributedPlatform> uninstalledReleases = releases.stream().filter(p -> !p.isInstalled()).collect(Collectors.toList());
        List installedBuiltIn = releases.stream().filter(p -> p.isInstalled()).filter(p -> p.isBuiltIn()).collect(Collectors.toList());
        if (installed != null && !installedBuiltIn.contains(installed)) {
            uninstalledReleases.addAll(installedBuiltIn);
        }
        Collections.sort(uninstalledReleases, new ReverseComparator((Comparator)new DownloadableContributionVersionComparator()));
        this.cell.downgradeChooser.removeAllItems();
        this.cell.downgradeChooser.addItem(I18n.tr((String)"Select version"));
        LinkedList uninstalledPreviousReleases = new LinkedList();
        LinkedList uninstalledNewerReleases = new LinkedList();
        uninstalledReleases.stream().forEach(input -> {
            if (installed == null || VersionComparator.greaterThan((String)installed.getParsedVersion(), (String)input.getParsedVersion())) {
                uninstalledPreviousReleases.add(input);
            } else {
                uninstalledNewerReleases.add(input);
            }
        });
        uninstalledNewerReleases.forEach(this.cell.downgradeChooser::addItem);
        uninstalledPreviousReleases.forEach(this.cell.downgradeChooser::addItem);
        boolean downgradeVisible = installed != null && (!uninstalledPreviousReleases.isEmpty() || uninstalledNewerReleases.size() > 1);
        this.cell.downgradeChooser.setVisible(downgradeVisible);
        this.cell.downgradeButton.setVisible(downgradeVisible);
        this.cell.versionToInstallChooser.removeAllItems();
        uninstalledReleases.forEach(this.cell.versionToInstallChooser::addItem);
        this.cell.versionToInstallChooser.setVisible(installed == null && uninstalledReleases.size() > 1);
        this.cell.update(table, _value, !installedBuiltIn.isEmpty());
        this.cell.setForeground(Color.BLACK);
        this.cell.setBackground(new Color(218, 227, 227));
        return this.cell;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cell.setButtonsVisible(enabled);
    }

    @Override
    public void setStatus(String status) {
        this.cell.statusLabel.setText(status);
    }

    protected void onRemove(ContributedPlatform contributedPlatform) {
    }

    protected void onInstall(ContributedPlatform contributedPlatform, ContributedPlatform installed) {
    }
}

