/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.SketchController;
import processing.app.tools.Tool;

public class Archiver
implements Tool {
    Editor editor;
    boolean useDate;
    int digits = 3;
    NumberFormat numberFormat;
    SimpleDateFormat dateFormat;

    @Override
    public String getMenuTitle() {
        return I18n.tr((String)"Archive Sketch");
    }

    @Override
    public void init(Editor editor) {
        this.editor = editor;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setGroupingUsed(false);
        this.numberFormat.setMinimumIntegerDigits(this.digits);
        this.dateFormat = new SimpleDateFormat("yyMMdd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SketchController sketch = this.editor.getSketchController();
        boolean success = false;
        try {
            success = sketch.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!success) {
            Base.showWarning(I18n.tr((String)"Couldn't archive sketch"), I18n.tr((String)"Archiving the sketch has been canceled because\nthe sketch couldn't save properly."), null);
            return;
        }
        File location = sketch.getSketch().getFolder();
        String name = location.getName();
        File parent = new File(location.getParent());
        File newbie = null;
        String namely = null;
        int index = 0;
        do {
            boolean bl = this.useDate = !name.startsWith("sketch_");
            if (this.useDate) {
                String purty = this.dateFormat.format(new Date());
                String stamp = purty + (char)(97 + index);
                namely = name + "-" + stamp;
                newbie = new File(parent, namely + ".zip");
            } else {
                String diggie = this.numberFormat.format(index + 1);
                namely = name + "-" + diggie;
                newbie = new File(parent, namely + ".zip");
            }
            ++index;
        } while (newbie.exists());
        FileDialog fd = new FileDialog((Frame)this.editor, I18n.tr((String)"Archive sketch as:"), 1);
        fd.setDirectory(parent.getAbsolutePath());
        fd.setFile(newbie.getName());
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename != null) {
            newbie = new File(directory, filename);
            ZipOutputStream zos = null;
            try {
                zos = new ZipOutputStream(new FileOutputStream(newbie));
                this.buildZip(location, name, zos);
                zos.flush();
                this.editor.statusNotice("Created archive " + newbie.getName() + ".");
                IOUtils.closeQuietly((Closeable)zos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(zos);
            }
        } else {
            this.editor.statusNotice(I18n.tr((String)"Archive sketch canceled."));
        }
    }

    public void buildZip(File dir, String sofar, ZipOutputStream zos) throws IOException {
        String[] files = dir.list();
        if (files == null) {
            throw new IOException("Unable to list files from " + dir);
        }
        for (int i = 0; i < files.length; ++i) {
            ZipEntry entry;
            String nowfar;
            if (files[i].equals(".") || files[i].equals("..")) continue;
            File sub = new File(dir, files[i]);
            String string = nowfar = sofar == null ? files[i] : sofar + "/" + files[i];
            if (sub.isDirectory()) {
                entry = new ZipEntry(nowfar + "/");
                zos.putNextEntry(entry);
                zos.closeEntry();
                this.buildZip(sub, nowfar, zos);
                continue;
            }
            entry = new ZipEntry(nowfar);
            entry.setTime(sub.lastModified());
            zos.putNextEntry(entry);
            zos.write(Base.loadBytesRaw(sub));
            zos.closeEntry();
        }
    }
}

