/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketInputStream;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.util.Arrays;

public class SignaturePacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    private int version;
    private int signatureType;
    private long creationTime;
    private long keyID;
    private int keyAlgorithm;
    private int hashAlgorithm;
    private MPInteger[] signature;
    private byte[] fingerPrint;
    private SignatureSubpacket[] hashedData;
    private SignatureSubpacket[] unhashedData;
    private byte[] signatureEncoding;

    SignaturePacket(BCPGInputStream bCPGInputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n;
        this.version = bCPGInputStream.read();
        if (this.version == 3 || this.version == 2) {
            n = bCPGInputStream.read();
            this.signatureType = bCPGInputStream.read();
            this.creationTime = ((long)bCPGInputStream.read() << 24 | (long)(bCPGInputStream.read() << 16) | (long)(bCPGInputStream.read() << 8) | (long)bCPGInputStream.read()) * 1000L;
            this.keyID |= (long)bCPGInputStream.read() << 56;
            this.keyID |= (long)bCPGInputStream.read() << 48;
            this.keyID |= (long)bCPGInputStream.read() << 40;
            this.keyID |= (long)bCPGInputStream.read() << 32;
            this.keyID |= (long)bCPGInputStream.read() << 24;
            this.keyID |= (long)bCPGInputStream.read() << 16;
            this.keyID |= (long)bCPGInputStream.read() << 8;
            this.keyID |= (long)bCPGInputStream.read();
            this.keyAlgorithm = bCPGInputStream.read();
            this.hashAlgorithm = bCPGInputStream.read();
        } else if (this.version == 4) {
            int n2;
            this.signatureType = bCPGInputStream.read();
            this.keyAlgorithm = bCPGInputStream.read();
            this.hashAlgorithm = bCPGInputStream.read();
            n = bCPGInputStream.read() << 8 | bCPGInputStream.read();
            object6 = new byte[n];
            bCPGInputStream.readFully((byte[])object6);
            object5 = new SignatureSubpacketInputStream(new ByteArrayInputStream((byte[])object6));
            object4 = new Vector<SignatureSubpacket>();
            while ((object3 = ((SignatureSubpacketInputStream)object5).readPacket()) != null) {
                ((Vector)object4).addElement(object3);
            }
            this.hashedData = new SignatureSubpacket[((Vector)object4).size()];
            for (n2 = 0; n2 != this.hashedData.length; ++n2) {
                object2 = (SignatureSubpacket)((Vector)object4).elementAt(n2);
                if (object2 instanceof IssuerKeyID) {
                    this.keyID = ((IssuerKeyID)object2).getKeyID();
                } else if (object2 instanceof SignatureCreationTime) {
                    this.creationTime = ((SignatureCreationTime)object2).getTime().getTime();
                }
                this.hashedData[n2] = object2;
            }
            n2 = bCPGInputStream.read() << 8 | bCPGInputStream.read();
            object2 = new byte[n2];
            bCPGInputStream.readFully((byte[])object2);
            object5 = new SignatureSubpacketInputStream(new ByteArrayInputStream((byte[])object2));
            ((Vector)object4).removeAllElements();
            while ((object3 = ((SignatureSubpacketInputStream)object5).readPacket()) != null) {
                ((Vector)object4).addElement(object3);
            }
            this.unhashedData = new SignatureSubpacket[((Vector)object4).size()];
            for (int i = 0; i != this.unhashedData.length; ++i) {
                object = (SignatureSubpacket)((Vector)object4).elementAt(i);
                if (object instanceof IssuerKeyID) {
                    this.keyID = ((IssuerKeyID)object).getKeyID();
                }
                this.unhashedData[i] = object;
            }
        } else {
            throw new RuntimeException("unsupported version: " + this.version);
        }
        this.fingerPrint = new byte[2];
        bCPGInputStream.readFully(this.fingerPrint);
        switch (this.keyAlgorithm) {
            case 1: 
            case 3: {
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[1];
                this.signature[0] = mPInteger;
                break;
            }
            case 17: {
                object6 = new MPInteger(bCPGInputStream);
                object3 = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[2];
                this.signature[0] = object6;
                this.signature[1] = object3;
                break;
            }
            case 16: 
            case 20: {
                object5 = new MPInteger(bCPGInputStream);
                object4 = new MPInteger(bCPGInputStream);
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[3];
                this.signature[0] = object5;
                this.signature[1] = object4;
                this.signature[2] = mPInteger;
                break;
            }
            case 19: {
                object2 = new MPInteger(bCPGInputStream);
                MPInteger mPInteger = new MPInteger(bCPGInputStream);
                this.signature = new MPInteger[2];
                this.signature[0] = object2;
                this.signature[1] = mPInteger;
                break;
            }
            default: {
                if (this.keyAlgorithm >= 100 && this.keyAlgorithm <= 110) {
                    int n3;
                    this.signature = null;
                    object = new ByteArrayOutputStream();
                    while ((n3 = bCPGInputStream.read()) >= 0) {
                        ((ByteArrayOutputStream)object).write(n3);
                    }
                    this.signatureEncoding = ((ByteArrayOutputStream)object).toByteArray();
                    break;
                }
                throw new IOException("unknown signature key algorithm: " + this.keyAlgorithm);
            }
        }
    }

    public SignaturePacket(int n, long l, int n2, int n3, SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket[] signatureSubpacketArray2, byte[] byArray, MPInteger[] mPIntegerArray) {
        this(4, n, l, n2, n3, signatureSubpacketArray, signatureSubpacketArray2, byArray, mPIntegerArray);
    }

    public SignaturePacket(int n, int n2, long l, int n3, int n4, long l2, byte[] byArray, MPInteger[] mPIntegerArray) {
        this(n, n2, l, n3, n4, null, null, byArray, mPIntegerArray);
        this.creationTime = l2;
    }

    public SignaturePacket(int n, int n2, long l, int n3, int n4, SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket[] signatureSubpacketArray2, byte[] byArray, MPInteger[] mPIntegerArray) {
        this.version = n;
        this.signatureType = n2;
        this.keyID = l;
        this.keyAlgorithm = n3;
        this.hashAlgorithm = n4;
        this.hashedData = signatureSubpacketArray;
        this.unhashedData = signatureSubpacketArray2;
        this.fingerPrint = byArray;
        this.signature = mPIntegerArray;
        if (signatureSubpacketArray != null) {
            this.setCreationTime();
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public long getKeyID() {
        return this.keyID;
    }

    public byte[] getSignatureTrailer() {
        byte[] byArray = null;
        if (this.version == 3 || this.version == 2) {
            byArray = new byte[5];
            long l = this.creationTime / 1000L;
            byArray[0] = (byte)this.signatureType;
            byArray[1] = (byte)(l >> 24);
            byArray[2] = (byte)(l >> 16);
            byArray[3] = (byte)(l >> 8);
            byArray[4] = (byte)l;
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write((byte)this.getVersion());
                byteArrayOutputStream.write((byte)this.getSignatureType());
                byteArrayOutputStream.write((byte)this.getKeyAlgorithm());
                byteArrayOutputStream.write((byte)this.getHashAlgorithm());
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                SignatureSubpacket[] signatureSubpacketArray = this.getHashedSubPackets();
                for (int i = 0; i != signatureSubpacketArray.length; ++i) {
                    signatureSubpacketArray[i].encode(byteArrayOutputStream2);
                }
                byte[] byArray2 = byteArrayOutputStream2.toByteArray();
                byteArrayOutputStream.write((byte)(byArray2.length >> 8));
                byteArrayOutputStream.write((byte)byArray2.length);
                byteArrayOutputStream.write(byArray2);
                byte[] byArray3 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.write((byte)this.getVersion());
                byteArrayOutputStream.write(-1);
                byteArrayOutputStream.write((byte)(byArray3.length >> 24));
                byteArrayOutputStream.write((byte)(byArray3.length >> 16));
                byteArrayOutputStream.write((byte)(byArray3.length >> 8));
                byteArrayOutputStream.write((byte)byArray3.length);
            }
            catch (IOException iOException) {
                throw new RuntimeException("exception generating trailer: " + iOException);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public int getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public int getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public MPInteger[] getSignature() {
        return this.signature;
    }

    public byte[] getSignatureBytes() {
        if (this.signatureEncoding == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(byteArrayOutputStream);
            for (int i = 0; i != this.signature.length; ++i) {
                try {
                    bCPGOutputStream.writeObject(this.signature[i]);
                    continue;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("internal error: " + iOException);
                }
            }
            return byteArrayOutputStream.toByteArray();
        }
        return Arrays.clone((byte[])this.signatureEncoding);
    }

    public SignatureSubpacket[] getHashedSubPackets() {
        return this.hashedData;
    }

    public SignatureSubpacket[] getUnhashedSubPackets() {
        return this.unhashedData;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BCPGOutputStream bCPGOutputStream2 = new BCPGOutputStream(byteArrayOutputStream);
        bCPGOutputStream2.write(this.version);
        if (this.version == 3 || this.version == 2) {
            bCPGOutputStream2.write(5);
            long l = this.creationTime / 1000L;
            bCPGOutputStream2.write(this.signatureType);
            bCPGOutputStream2.write((byte)(l >> 24));
            bCPGOutputStream2.write((byte)(l >> 16));
            bCPGOutputStream2.write((byte)(l >> 8));
            bCPGOutputStream2.write((byte)l);
            bCPGOutputStream2.write((byte)(this.keyID >> 56));
            bCPGOutputStream2.write((byte)(this.keyID >> 48));
            bCPGOutputStream2.write((byte)(this.keyID >> 40));
            bCPGOutputStream2.write((byte)(this.keyID >> 32));
            bCPGOutputStream2.write((byte)(this.keyID >> 24));
            bCPGOutputStream2.write((byte)(this.keyID >> 16));
            bCPGOutputStream2.write((byte)(this.keyID >> 8));
            bCPGOutputStream2.write((byte)this.keyID);
            bCPGOutputStream2.write(this.keyAlgorithm);
            bCPGOutputStream2.write(this.hashAlgorithm);
        } else if (this.version == 4) {
            bCPGOutputStream2.write(this.signatureType);
            bCPGOutputStream2.write(this.keyAlgorithm);
            bCPGOutputStream2.write(this.hashAlgorithm);
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            for (int i = 0; i != this.hashedData.length; ++i) {
                this.hashedData[i].encode(byteArrayOutputStream2);
            }
            byte[] byArray = byteArrayOutputStream2.toByteArray();
            bCPGOutputStream2.write(byArray.length >> 8);
            bCPGOutputStream2.write(byArray.length);
            bCPGOutputStream2.write(byArray);
            byteArrayOutputStream2.reset();
            for (int i = 0; i != this.unhashedData.length; ++i) {
                this.unhashedData[i].encode(byteArrayOutputStream2);
            }
            byArray = byteArrayOutputStream2.toByteArray();
            bCPGOutputStream2.write(byArray.length >> 8);
            bCPGOutputStream2.write(byArray.length);
            bCPGOutputStream2.write(byArray);
        } else {
            throw new IOException("unknown version: " + this.version);
        }
        bCPGOutputStream2.write(this.fingerPrint);
        if (this.signature != null) {
            for (int i = 0; i != this.signature.length; ++i) {
                bCPGOutputStream2.writeObject(this.signature[i]);
            }
        } else {
            bCPGOutputStream2.write(this.signatureEncoding);
        }
        bCPGOutputStream2.close();
        bCPGOutputStream.writePacket(2, byteArrayOutputStream.toByteArray(), true);
    }

    private void setCreationTime() {
        for (int i = 0; i != this.hashedData.length; ++i) {
            if (!(this.hashedData[i] instanceof SignatureCreationTime)) continue;
            this.creationTime = ((SignatureCreationTime)this.hashedData[i]).getTime().getTime();
            break;
        }
    }

    public static SignaturePacket fromByteArray(byte[] byArray) throws IOException {
        BCPGInputStream bCPGInputStream = new BCPGInputStream(new ByteArrayInputStream(byArray));
        return new SignaturePacket(bCPGInputStream);
    }
}

