/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import processing.app.I18n;
import processing.app.Platform;

public class ArchiveExtractor {
    private final Platform platform;

    public ArchiveExtractor(Platform platform) {
        assert (platform != null);
        this.platform = platform;
    }

    public void extract(File archiveFile, File destFolder) throws IOException, InterruptedException {
        this.extract(archiveFile, destFolder, 0);
    }

    public void extract(File archiveFile, File destFolder, int stripPath) throws IOException, InterruptedException {
        this.extract(archiveFile, destFolder, stripPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(File archiveFile, File destFolder, int stripPath, boolean overwrite) throws IOException, InterruptedException {
        HashMap<File, Long> foldersTimestamps = new HashMap<File, Long>();
        TarArchiveInputStream in = null;
        try {
            ArchiveEntry entry;
            if (archiveFile.getName().endsWith("tar.bz2")) {
                in = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream((InputStream)new FileInputStream(archiveFile)));
            } else if (archiveFile.getName().endsWith("zip")) {
                in = new ZipArchiveInputStream((InputStream)new FileInputStream(archiveFile));
            } else if (archiveFile.getName().endsWith("tar.gz")) {
                in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(archiveFile)));
            } else if (archiveFile.getName().endsWith("tar.xz")) {
                in = new TarArchiveInputStream((InputStream)new XZCompressorInputStream((InputStream)new FileInputStream(archiveFile)));
            } else if (archiveFile.getName().endsWith("tar")) {
                in = new TarArchiveInputStream((InputStream)new FileInputStream(archiveFile));
            } else {
                throw new IOException("Archive format not supported.");
            }
            String pathPrefix = "";
            HashMap<File, File> hardLinks = new HashMap<File, File>();
            HashMap<File, Integer> hardLinksMode = new HashMap<File, Integer>();
            HashMap<File, String> symLinks = new HashMap<File, String>();
            HashMap<File, Long> symLinksModifiedTimes = new HashMap<File, Long>();
            while ((entry = in.getNextEntry()) != null) {
                long size = entry.getSize();
                String name = entry.getName();
                boolean isDirectory = entry.isDirectory();
                boolean isLink = false;
                boolean isSymLink = false;
                String linkName = null;
                Integer mode = null;
                long modifiedTime = entry.getLastModifiedDate().getTime();
                int slash = name.lastIndexOf(47);
                if ((slash != -1 ? name.substring(slash + 1).startsWith("._") : name.startsWith("._")) || name.contains("pax_global_header")) continue;
                if (entry instanceof TarArchiveEntry) {
                    TarArchiveEntry tarEntry = (TarArchiveEntry)entry;
                    mode = tarEntry.getMode();
                    isLink = tarEntry.isLink();
                    isSymLink = tarEntry.isSymbolicLink();
                    linkName = tarEntry.getLinkName();
                }
                if (stripPath > 0 && pathPrefix.isEmpty()) {
                    slash = 0;
                    while (stripPath > 0) {
                        if ((slash = name.indexOf("/", slash)) == -1) {
                            throw new IOException("Invalid archive: it must contain a single root folder");
                        }
                        ++slash;
                        --stripPath;
                    }
                    pathPrefix = name.substring(0, slash);
                }
                if (!name.startsWith(pathPrefix)) {
                    throw new IOException("Invalid archive: it must contain a single root folder while file " + name + " is outside " + pathPrefix);
                }
                if ((name = name.substring(pathPrefix.length())).isEmpty()) continue;
                File outputFile = new File(destFolder, name);
                File outputLinkedFile = null;
                if (isLink) {
                    if (!linkName.startsWith(pathPrefix)) {
                        throw new IOException("Invalid archive: it must contain a single root folder while file " + linkName + " is outside " + pathPrefix);
                    }
                    linkName = linkName.substring(pathPrefix.length());
                    outputLinkedFile = new File(destFolder, linkName);
                }
                if (isSymLink && (outputLinkedFile = new File(linkName)).isAbsolute()) {
                    System.err.println(I18n.format(I18n.tr("Warning: file {0} links to an absolute path {1}"), outputFile, outputLinkedFile));
                    System.err.println();
                }
                if (isDirectory) {
                    if (outputFile.isFile() && !overwrite) {
                        throw new IOException("Can't create folder " + outputFile + ", a file with the same name exists!");
                    }
                } else if (outputFile.exists() && !overwrite) {
                    throw new IOException("Can't extract file " + outputFile + ", file already exists!");
                }
                if (isDirectory) {
                    if (!outputFile.exists() && !outputFile.mkdirs()) {
                        throw new IOException("Could not create folder: " + outputFile);
                    }
                    foldersTimestamps.put(outputFile, modifiedTime);
                } else if (isLink) {
                    hardLinks.put(outputFile, outputLinkedFile);
                    hardLinksMode.put(outputFile, mode);
                } else if (isSymLink) {
                    symLinks.put(outputFile, linkName);
                    symLinksModifiedTimes.put(outputFile, modifiedTime);
                } else {
                    if (!outputFile.getParentFile().isDirectory()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    ArchiveExtractor.copyStreamToFile((InputStream)in, size, outputFile);
                    outputFile.setLastModified(modifiedTime);
                }
                if (mode == null || isSymLink || !outputFile.exists()) continue;
                this.platform.chmod(outputFile, mode);
            }
            for (Map.Entry entry2 : hardLinks.entrySet()) {
                if (((File)entry2.getKey()).exists() && overwrite) {
                    ((File)entry2.getKey()).delete();
                }
                this.platform.link((File)entry2.getValue(), (File)entry2.getKey());
                Integer mode = (Integer)hardLinksMode.get(entry2.getKey());
                if (mode == null) continue;
                this.platform.chmod((File)entry2.getKey(), mode);
            }
            for (Map.Entry entry3 : symLinks.entrySet()) {
                if (((File)entry3.getKey()).exists() && overwrite) {
                    ((File)entry3.getKey()).delete();
                }
                this.platform.symlink((String)entry3.getValue(), (File)entry3.getKey());
                ((File)entry3.getKey()).setLastModified((Long)symLinksModifiedTimes.get(entry3.getKey()));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)in);
        for (File folder : foldersTimestamps.keySet()) {
            folder.setLastModified((Long)foldersTimestamps.get(folder));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStreamToFile(InputStream in, long size, File outputFile) throws IOException {
        FileOutputStream fos;
        block6: {
            int length;
            fos = null;
            fos = new FileOutputStream(outputFile);
            if (size != -1L) break block6;
            byte[] buffer = new byte[4096];
            while ((length = in.read(buffer)) != -1) {
                fos.write(buffer, 0, length);
            }
            IOUtils.closeQuietly((Closeable)fos);
            return;
        }
        try {
            byte[] buffer = new byte[4096];
            while (size > 0L) {
                int length = in.read(buffer);
                if (length <= 0) {
                    throw new IOException("Error while extracting file " + outputFile.getAbsolutePath());
                }
                fos.write(buffer, 0, length);
                size -= (long)length;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fos);
    }
}

