/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101.flashers.java;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jssc.SerialPort;
import jssc.SerialPortException;
import processing.app.I18n;
import processing.app.SerialException;
import processing.app.SerialNotFoundException;

public class FlasherSerialClient {
    private SerialPort port;
    private volatile byte[] recvBuffer = new byte[1000000];
    private volatile int recvPos = 0;
    private volatile int writePos = 0;

    public void open(String string, int n) throws SerialException, InterruptedException {
        try {
            this.port = new SerialPort(string);
            if (!this.port.openPort()) {
                throw new SerialException("Error opening serial port");
            }
            boolean bl = this.port.setParams(n, 8, 1, 0, true, true);
            if (!bl) {
                System.err.println(I18n.format((String)I18n.tr((String)"Error while setting serial port parameters: {0} {1} {2} {3}"), (Object[])new Object[]{115200, 0, 8, 1}));
            }
            this.port.addEventListener(serialPortEvent -> {
                if (!serialPortEvent.isRXCHAR()) {
                    return;
                }
                try {
                    byte[] byArray = this.port.readBytes(serialPortEvent.getEventValue());
                    if (byArray == null || byArray.length == 0) {
                        return;
                    }
                    byte[] byArray2 = this.recvBuffer;
                    synchronized (this.recvBuffer) {
                        for (int i = 0; i < byArray.length; ++i) {
                            this.recvBuffer[this.writePos++] = byArray[i];
                        }
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                {
                    return;
                }
            });
        }
        catch (SerialPortException serialPortException) {
            if (serialPortException.getPortName().startsWith("/dev") && "Permission denied".equals(serialPortException.getExceptionType())) {
                throw new SerialException(I18n.format((String)I18n.tr((String)"Error opening serial port ''{0}''. Try consulting the documentation at http://playground.arduino.cc/Linux/All#Permission"), (Object[])new Object[]{string}));
            }
            throw new SerialException(I18n.format((String)I18n.tr((String)"Error opening serial port ''{0}''."), (Object[])new Object[]{string}), (Throwable)serialPortException);
        }
        if (this.port == null) {
            throw new SerialNotFoundException(I18n.format((String)I18n.tr((String)"Serial port ''{0}'' not found."), (Object[])new Object[]{string}));
        }
        Thread.sleep(2500L);
    }

    public void close() throws SerialException {
        try {
            this.port.closePort();
        }
        catch (Exception exception) {
            throw new SerialException(I18n.format((String)I18n.tr((String)"Error opening serial port.\nClose the serial monitor (if open) or any program using port '{0}'"), (Object[])new Object[]{this.port.getPortName()}));
        }
    }

    public void hello() throws Exception {
        this.sendCommand((byte)-103, 287454020, 1432778632, null);
        byte[] byArray = this.waitAnswer(2000, 6, true);
        if (byArray.length != 6 || byArray[0] != 118) {
            throw new Exception("Programmer not responding\nMake sure that FirmwareUpdater sketch is loaded on the board.");
        }
        String string = new String(byArray);
        if (!string.equals("v10000")) {
            throw new Exception("Programmer version mismatch: " + string + ", but v10000 is required!");
        }
    }

    public int getMaximumPayload() throws Exception {
        this.sendCommand((byte)80, 0, 0, null);
        byte[] byArray = this.waitAnswer(100, 2);
        if (byArray.length != 2) {
            throw new Exception("Error while reading programmers parameters.");
        }
        return byArray[0] << 8 + byArray[1];
    }

    public byte[] readFlash(int n, int n2) throws Exception {
        this.sendCommand((byte)1, n, n2, null);
        byte[] byArray = this.waitAnswer(500, n2);
        if (byArray.length != n2) {
            throw new Exception("Error while reading flash memory.");
        }
        if (!this.ack()) {
            throw new Exception("Error while reading flash memory.");
        }
        return byArray;
    }

    public byte[] md5Flash(int n, int n2) throws Exception {
        this.sendCommand((byte)4, n, n2, null);
        if (this.ack(10000)) {
            byte[] byArray = this.waitAnswer(10000, 16);
            return byArray;
        }
        return null;
    }

    public void writeFlash(int n, byte[] byArray) throws Exception {
        this.sendCommand((byte)2, n, 0, byArray);
        if (!this.ack()) {
            throw new Exception("Error while writing flash memory.");
        }
    }

    public void eraseFlash(int n, int n2) throws Exception {
        this.sendCommand((byte)3, n, n2, null);
        if (!this.ack(20000)) {
            throw new Exception("Error while erasing flash memory.");
        }
    }

    public void addCertificateHighLevel(int n, byte[] byArray) throws Exception {
        this.sendCommand((byte)85, n, n, byArray);
        if (!this.ack(20000)) {
            throw new Exception("Error while uploading certificate.");
        }
    }

    private boolean ack() throws InterruptedException {
        return this.ack(1000);
    }

    private boolean ack(int n) throws InterruptedException {
        byte[] byArray = this.waitAnswer(n, 2);
        return byArray.length == 2 && byArray[0] == 79 && byArray[1] == 75;
    }

    private byte[] waitAnswer(int n, int n2) throws InterruptedException {
        return this.waitAnswer(n, n2, false);
    }

    private byte[] waitAnswer(int n, int n2, boolean bl) throws InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while (n > 0 && n3 < n2) {
            int n4 = this.read();
            if (n4 != -1 && (!bl || n4 > 0 && n4 < 128)) {
                byteArrayOutputStream.write(n4);
                ++n3;
                continue;
            }
            Thread.sleep(10L);
            n -= 10;
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() {
        byte[] byArray = this.recvBuffer;
        synchronized (this.recvBuffer) {
            if (this.recvPos == this.writePos) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.recvBuffer[this.recvPos++] & 0xFF;
        }
    }

    private void sendCommand(byte by, int n, int n2, byte[] byArray) throws SerialPortException {
        short s = 0;
        if (byArray != null) {
            s = (short)byArray.length;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(11 + s);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(by);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
        byteBuffer.putShort(s);
        if (byArray != null) {
            byteBuffer.put(byArray);
        }
        byte[] byArray2 = byteBuffer.array();
        this.port.writeBytes(byArray2);
    }
}

