/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.batik.ext.awt.image.GraphicsUtil;

public class IndexImage {
    static byte[][] computeRGB(int n, Cube[] cubeArray) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[3];
        for (int i = 0; i < n; ++i) {
            byArray4 = cubeArray[i].averageColorRGB(byArray4);
            byArray[i] = byArray4[0];
            byArray2[i] = byArray4[1];
            byArray3[i] = byArray4[2];
        }
        byte[][] byArrayArray = new byte[][]{byArray, byArray2, byArray3};
        return byArrayArray;
    }

    static void logRGB(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            String string = "(" + (byArray[i] + 128) + ',' + (byArray2[i] + 128) + ',' + (byArray3[i] + 128) + "),";
            stringBuffer.append(string);
        }
        System.out.println("RGB:" + n + stringBuffer);
    }

    static List[] createColorList(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        List[] listArray = new ArrayList[4096];
        for (int i = 0; i < n; ++i) {
            block1: for (int j = 0; j < n2; ++j) {
                int n3 = bufferedImage.getRGB(i, j) & 0xFFFFFF;
                int n4 = (n3 & 0xF00000) >>> 12 | (n3 & 0xF000) >>> 8 | (n3 & 0xF0) >>> 4;
                ArrayList<Counter> arrayList = listArray[n4];
                if (arrayList == null) {
                    arrayList = new ArrayList<Counter>();
                    arrayList.add(new Counter(n3));
                    listArray[n4] = arrayList;
                    continue;
                }
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    if (!((Counter)iterator.next()).add(n3)) continue;
                    continue block1;
                }
                arrayList.add(new Counter(n3));
            }
        }
        return listArray;
    }

    static Counter[][] convertColorList(List[] listArray) {
        Counter[] counterArray = new Counter[]{};
        Counter[][] counterArray2 = new Counter[4096][];
        for (int i = 0; i < listArray.length; ++i) {
            List list = listArray[i];
            if (list == null) {
                counterArray2[i] = counterArray;
                continue;
            }
            int n = list.size();
            counterArray2[i] = list.toArray(new Counter[n]);
            listArray[i] = null;
        }
        return counterArray2;
    }

    public static BufferedImage getIndexedImage(BufferedImage bufferedImage, int n) {
        int n2;
        Object object;
        Object object2;
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        List[] listArray = IndexImage.createColorList(bufferedImage);
        Counter[][] counterArray = IndexImage.convertColorList(listArray);
        listArray = null;
        int n5 = 1;
        int n6 = 0;
        Cube[] cubeArray = new Cube[n];
        cubeArray[0] = new Cube(counterArray, n3 * n4);
        while (n5 < n) {
            while (cubeArray[n6].isDone() && ++n6 != n5) {
            }
            if (n6 == n5) break;
            object2 = cubeArray[n6];
            object = ((Cube)object2).split();
            if (object == null) continue;
            if (((Cube)object).count > ((Cube)object2).count) {
                Object object3 = object2;
                object2 = object;
                object = object3;
            }
            int n7 = n6;
            int n8 = ((Cube)object2).count;
            for (n2 = n6 + 1; n2 < n5 && cubeArray[n2].count >= n8; ++n2) {
                cubeArray[n7++] = cubeArray[n2];
            }
            cubeArray[n7++] = object2;
            n8 = ((Cube)object).count;
            while (n7 < n5 && cubeArray[n7].count >= n8) {
                ++n7;
            }
            for (n2 = n5; n2 > n7; --n2) {
                cubeArray[n2] = cubeArray[n2 - 1];
            }
            cubeArray[n7++] = object;
            ++n5;
        }
        object2 = IndexImage.computeRGB(n5, cubeArray);
        object = new IndexColorModel(8, n5, object2[0], (byte[])object2[1], (byte[])object2[2]);
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 13, (IndexColorModel)object);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        for (n2 = 1; n2 <= 8 && 1 << n2 < n5; ++n2) {
        }
        if (n2 > 4) {
            return bufferedImage2;
        }
        if (n2 == 3) {
            n2 = 4;
        }
        IndexColorModel indexColorModel = new IndexColorModel(n2, n5, (byte[])object2[0], (byte[])object2[1], (byte[])object2[2]);
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = new MultiPixelPackedSampleModel(0, n3, n4, n2);
        WritableRaster writableRaster = Raster.createWritableRaster(multiPixelPackedSampleModel, new Point(0, 0));
        bufferedImage = bufferedImage2;
        bufferedImage2 = new BufferedImage(indexColorModel, writableRaster, bufferedImage.isAlphaPremultiplied(), null);
        GraphicsUtil.copyData(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    private static class Cube {
        static final byte[] RGB_BLACK = new byte[]{0, 0, 0};
        int[] min = new int[]{0, 0, 0};
        int[] max = new int[]{255, 255, 255};
        boolean done = false;
        final Counter[][] colors;
        int count = 0;
        static final int RED = 0;
        static final int GRN = 1;
        static final int BLU = 2;

        Cube(Counter[][] counterArray, int n) {
            this.colors = counterArray;
            this.count = n;
        }

        public boolean isDone() {
            return this.done;
        }

        private boolean contains(int[] nArray) {
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            return this.min[0] <= n && n <= this.max[0] && this.min[1] <= n2 && n2 <= this.max[1] && this.min[2] <= n3 && n3 <= this.max[2];
        }

        Cube split() {
            int n;
            int n2;
            int n3;
            int n4 = this.max[0] - this.min[0] + 1;
            int n5 = this.max[1] - this.min[1] + 1;
            int n6 = this.max[2] - this.min[2] + 1;
            if (n4 >= n5) {
                if (n4 >= n6) {
                    n3 = 0;
                    n2 = 1;
                    n = 2;
                } else {
                    n3 = 2;
                    n2 = 0;
                    n = 1;
                }
            } else if (n5 >= n6) {
                n3 = 1;
                n2 = 0;
                n = 2;
            } else {
                n3 = 2;
                n2 = 1;
                n = 0;
            }
            Cube cube = this.splitChannel(n3, n2, n);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n2, n3, n);
            if (cube != null) {
                return cube;
            }
            cube = this.splitChannel(n, n3, n2);
            if (cube != null) {
                return cube;
            }
            this.done = true;
            return null;
        }

        private void normalize(int n, int[] nArray) {
            boolean bl;
            int n2;
            if (this.count == 0) {
                return;
            }
            int n3 = this.min[n];
            int n4 = this.max[n];
            int n5 = -1;
            int n6 = -1;
            for (n2 = n3; n2 <= n4; ++n2) {
                if (nArray[n2] == 0) continue;
                n5 = n2;
                break;
            }
            for (n2 = n4; n2 >= n3; --n2) {
                if (nArray[n2] == 0) continue;
                n6 = n2;
                break;
            }
            n2 = n5 != -1 && n3 != n5 ? 1 : 0;
            boolean bl2 = bl = n6 != -1 && n4 != n6;
            if (n2 != 0) {
                this.min[n] = n5;
            }
            if (bl) {
                this.max[n] = n6;
            }
        }

        Cube splitChannel(int n, int n2, int n3) {
            if (this.min[n] == this.max[n]) {
                return null;
            }
            if (this.count == 0) {
                return null;
            }
            int n4 = this.count / 2;
            int[] nArray = this.computeCounts(n, n2, n3);
            int n5 = 0;
            int n6 = -1;
            int n7 = this.min[n];
            int n8 = this.max[n];
            for (int i = this.min[n]; i <= this.max[n]; ++i) {
                int n9 = nArray[i];
                if (n9 == 0) {
                    if (n5 != 0 || i >= this.max[n]) continue;
                    this.min[n] = i + 1;
                    continue;
                }
                if (n5 + n9 < n4) {
                    n6 = i;
                    n5 += n9;
                    continue;
                }
                if (n4 - n5 <= n5 + n9 - n4) {
                    if (n6 == -1) {
                        if (n9 == this.count) {
                            this.max[n] = i;
                            return null;
                        }
                        n7 = i;
                        n8 = i + 1;
                        n5 += n9;
                        break;
                    }
                    n7 = n6;
                    n8 = i;
                    break;
                }
                if (i == this.max[n]) {
                    if (n9 == this.count) {
                        return null;
                    }
                    n7 = n6;
                    n8 = i;
                    break;
                }
                n5 += n9;
                n7 = i;
                n8 = i + 1;
                break;
            }
            Cube cube = new Cube(this.colors, n5);
            this.count -= n5;
            cube.min[n] = this.min[n];
            cube.max[n] = n7;
            this.min[n] = n8;
            cube.min[n2] = this.min[n2];
            cube.max[n2] = this.max[n2];
            cube.min[n3] = this.min[n3];
            cube.max[n3] = this.max[n3];
            this.normalize(n, nArray);
            cube.normalize(n, nArray);
            return cube;
        }

        private int[] computeCounts(int n, int n2, int n3) {
            int n4 = (2 - n) * 4;
            int n5 = (2 - n2) * 4;
            int n6 = (2 - n3) * 4;
            int n7 = this.count / 2;
            int[] nArray = new int[256];
            int n8 = 0;
            int n9 = this.min[0];
            int n10 = this.min[1];
            int n11 = this.min[2];
            int n12 = this.max[0];
            int n13 = this.max[1];
            int n14 = this.max[2];
            int[] nArray2 = new int[]{n9 >> 4, n10 >> 4, n11 >> 4};
            int[] nArray3 = new int[]{n12 >> 4, n13 >> 4, n14 >> 4};
            int[] nArray4 = new int[]{0, 0, 0};
            for (int i = nArray2[n]; i <= nArray3[n]; ++i) {
                int n15 = i << n4;
                for (int j = nArray2[n2]; j <= nArray3[n2]; ++j) {
                    int n16 = n15 | j << n5;
                    for (int k = nArray2[n3]; k <= nArray3[n3]; ++k) {
                        int n17 = n16 | k << n6;
                        Counter[] counterArray = this.colors[n17];
                        for (int i2 = 0; i2 < counterArray.length; ++i2) {
                            Counter counter = counterArray[i2];
                            if (!this.contains(nArray4 = counter.getRgb(nArray4))) continue;
                            int n18 = nArray4[n];
                            nArray[n18] = nArray[n18] + counter.count;
                            n8 += counter.count;
                        }
                    }
                }
            }
            return nArray;
        }

        public String toString() {
            return "Cube: [" + this.min[0] + '-' + this.max[0] + "] [" + this.min[1] + '-' + this.max[1] + "] [" + this.min[2] + '-' + this.max[2] + "] n:" + this.count;
        }

        public int averageColor() {
            if (this.count == 0) {
                return 0;
            }
            byte[] byArray = this.averageColorRGB(null);
            return byArray[0] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[2] & 0xFF;
        }

        public byte[] averageColorRGB(byte[] byArray) {
            if (this.count == 0) {
                return RGB_BLACK;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = this.min[0];
            int n2 = this.min[1];
            int n3 = this.min[2];
            int n4 = this.max[0];
            int n5 = this.max[1];
            int n6 = this.max[2];
            int[] nArray = new int[]{n >> 4, n2 >> 4, n3 >> 4};
            int[] nArray2 = new int[]{n4 >> 4, n5 >> 4, n6 >> 4};
            int[] nArray3 = new int[3];
            for (int i = nArray[0]; i <= nArray2[0]; ++i) {
                int n7 = i << 8;
                for (int j = nArray[1]; j <= nArray2[1]; ++j) {
                    int n8 = n7 | j << 4;
                    for (int k = nArray[2]; k <= nArray2[2]; ++k) {
                        int n9 = n8 | k;
                        Counter[] counterArray = this.colors[n9];
                        for (int i2 = 0; i2 < counterArray.length; ++i2) {
                            Counter counter = counterArray[i2];
                            if (!this.contains(nArray3 = counter.getRgb(nArray3))) continue;
                            float f4 = (float)counter.count / (float)this.count;
                            f += (float)nArray3[0] * f4;
                            f2 += (float)nArray3[1] * f4;
                            f3 += (float)nArray3[2] * f4;
                        }
                    }
                }
            }
            byte[] byArray2 = byArray == null ? new byte[3] : byArray;
            byArray2[0] = (byte)(f + 0.5f);
            byArray2[1] = (byte)(f2 + 0.5f);
            byArray2[2] = (byte)(f3 + 0.5f);
            return byArray2;
        }
    }

    private static class Counter {
        final int val;
        int count = 1;

        Counter(int n) {
            this.val = n;
        }

        boolean add(int n) {
            if (this.val != n) {
                return false;
            }
            ++this.count;
            return true;
        }

        int[] getRgb(int[] nArray) {
            nArray[0] = (this.val & 0xFF0000) >> 16;
            nArray[1] = (this.val & 0xFF00) >> 8;
            nArray[2] = this.val & 0xFF;
            return nArray;
        }
    }
}

