/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeUpdateHandler;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.css.engine.CSSEngineEvent;
import org.apache.batik.dom.svg.SVGContext;
import org.w3c.dom.Element;
import org.w3c.dom.events.MutationEvent;

public abstract class SVGDescriptiveElementBridge
extends AbstractSVGBridge
implements GenericBridge,
BridgeUpdateHandler,
SVGContext {
    Element theElt;
    Element parent;
    BridgeContext theCtx;

    @Override
    public void handleElement(BridgeContext bridgeContext, Element element) {
        UserAgent userAgent = bridgeContext.getUserAgent();
        userAgent.handleElement(element, Boolean.TRUE);
        if (bridgeContext.isDynamic()) {
            SVGDescriptiveElementBridge sVGDescriptiveElementBridge = (SVGDescriptiveElementBridge)this.getInstance();
            sVGDescriptiveElementBridge.theElt = element;
            sVGDescriptiveElementBridge.parent = (Element)element.getParentNode();
            sVGDescriptiveElementBridge.theCtx = bridgeContext;
            ((SVGOMElement)element).setSVGContext((SVGContext)sVGDescriptiveElementBridge);
        }
    }

    @Override
    public void dispose() {
        UserAgent userAgent = this.theCtx.getUserAgent();
        ((SVGOMElement)this.theElt).setSVGContext(null);
        userAgent.handleElement(this.theElt, this.parent);
        this.theElt = null;
        this.parent = null;
    }

    @Override
    public void handleDOMNodeInsertedEvent(MutationEvent mutationEvent) {
        UserAgent userAgent = this.theCtx.getUserAgent();
        userAgent.handleElement(this.theElt, Boolean.TRUE);
    }

    @Override
    public void handleDOMCharacterDataModified(MutationEvent mutationEvent) {
        UserAgent userAgent = this.theCtx.getUserAgent();
        userAgent.handleElement(this.theElt, Boolean.TRUE);
    }

    @Override
    public void handleDOMNodeRemovedEvent(MutationEvent mutationEvent) {
        this.dispose();
    }

    @Override
    public void handleDOMAttrModifiedEvent(MutationEvent mutationEvent) {
    }

    @Override
    public void handleCSSEngineEvent(CSSEngineEvent cSSEngineEvent) {
    }

    @Override
    public void handleAnimatedAttributeChanged(AnimatedLiveAttributeValue animatedLiveAttributeValue) {
    }

    @Override
    public void handleOtherAnimationChanged(String string) {
    }

    public float getPixelUnitToMillimeter() {
        return this.theCtx.getUserAgent().getPixelUnitToMillimeter();
    }

    public float getPixelToMM() {
        return this.getPixelUnitToMillimeter();
    }

    public Rectangle2D getBBox() {
        return null;
    }

    public AffineTransform getScreenTransform() {
        return this.theCtx.getUserAgent().getTransform();
    }

    public void setScreenTransform(AffineTransform affineTransform) {
        this.theCtx.getUserAgent().setTransform(affineTransform);
    }

    public AffineTransform getCTM() {
        return null;
    }

    public AffineTransform getGlobalTransform() {
        return null;
    }

    public float getViewportWidth() {
        return this.theCtx.getBlockWidth(this.theElt);
    }

    public float getViewportHeight() {
        return this.theCtx.getBlockHeight(this.theElt);
    }

    public float getFontSize() {
        return 0.0f;
    }
}

