/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.NoSuchElementException;
import joptsimple.AlternativeLongOptionSpec;
import joptsimple.NoArgumentOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSpec;
import joptsimple.OptionalArgumentOptionSpec;
import joptsimple.ParserRules;
import joptsimple.RequiredArgumentOptionSpec;

class OptionSpecTokenizer {
    private static final char POSIXLY_CORRECT_MARKER = '+';
    private String specification;
    private int index;

    OptionSpecTokenizer(String specification) {
        if (specification == null) {
            throw new NullPointerException("null option specification");
        }
        this.specification = specification;
    }

    boolean hasMore() {
        return this.index < this.specification.length();
    }

    OptionSpec next() {
        OptionSpec spec;
        String optionCandidate;
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        if ("W".equals(optionCandidate = String.valueOf(this.specification.charAt(this.index++))) && (spec = this.handleReservedForExtensionsToken()) != null) {
            return spec;
        }
        ParserRules.checkLegalOption(optionCandidate);
        spec = !this.hasMore() ? new NoArgumentOptionSpec(optionCandidate) : (this.specification.charAt(this.index) == ':' ? this.handleArgumentAcceptingOption(optionCandidate) : new NoArgumentOptionSpec(optionCandidate));
        return spec;
    }

    void configure(OptionParser parser) {
        this.adjustForPosixlyCorrect(parser);
        while (this.hasMore()) {
            parser.recognize(this.next());
        }
    }

    private void adjustForPosixlyCorrect(OptionParser parser) {
        if ('+' == this.specification.charAt(0)) {
            parser.posixlyCorrect(true);
            this.specification = this.specification.substring(1);
        }
    }

    private OptionSpec handleReservedForExtensionsToken() {
        if (!this.hasMore()) {
            return new NoArgumentOptionSpec("W");
        }
        if (this.specification.charAt(this.index) == ';') {
            ++this.index;
            return new AlternativeLongOptionSpec();
        }
        return null;
    }

    private OptionSpec handleArgumentAcceptingOption(String candidate) {
        ++this.index;
        if (this.hasMore() && this.specification.charAt(this.index) == ':') {
            ++this.index;
            return new OptionalArgumentOptionSpec(candidate);
        }
        return new RequiredArgumentOptionSpec(candidate);
    }
}

