/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.RAFile;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747RAFile;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;

public final class WPLogConvert
extends GPSLogConvertInterface {
    private int recordSize = 16;
    private boolean passToFindFieldsActivatedInLog = false;
    private int error;

    @Override
    public final void setLoggerType(int n) {
        super.setLoggerType(n);
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                this.recordSize = 16;
                return;
            }
        }
        this.recordSize = 16;
    }

    public static final int longToUtcTime(int n) {
        int n2 = n & 0x3F;
        int n3 = n >> 6 & 0x3F;
        int n4 = n >> 12 & 0x1F;
        int n5 = n >> 17 & 0x1F;
        int n6 = n >> 22 & 0xF;
        n = n >> 26 & 0x3F;
        return JavaLibBridge.getDateInstance(n5, n6, n + 2000).dateToUTCepoch1970() + n4 * 3600 + n3 * 60 + n2;
    }

    @Override
    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            object = (BT747RAFile)object;
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            byte[] byArray = new byte[2048];
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(this.getLogFormatRecord$7cd0a50c());
            }
            int n = 0;
            int n2 = 0;
            int n3 = object.getSize();
            while (!this.stop && n2 + this.recordSize + 1 < n3) {
                int n4 = 2048;
                if (n2 + 2048 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                object.setPos(n2);
                if (object.readBytes(byArray, 0, n4) != n4) {
                    this.errorInfo = object.getPath() + "|" + object.getLastError();
                    return -3;
                }
                n2 += n4;
                while (n4 > n5 + this.recordSize) {
                    int n6;
                    int n7 = n5 + this.recordSize;
                    int n8 = n5;
                    n5 = n7;
                    gPSRecord.recCount = ++n;
                    if (this.passToFindFieldsActivatedInLog) continue;
                    switch (this.getLoggerType()) {
                        case 2: 
                        case 3: {
                            n7 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                            n6 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                            int n9 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                            int n10 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8;
                            gPSRecord.height = n10;
                            CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
                            n8 = 0xFF & byArray[n8];
                            gPSRecord.utc = WPLogConvert.longToUtcTime(n9);
                            break;
                        }
                        default: {
                            n7 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                            n6 = 0xFF & byArray[n8++] | (0xFF & byArray[n8++]) << 8 | (0xFF & byArray[n8++]) << 16 | (0xFF & byArray[n8++]) << 24;
                            int n10 = 0xFF & byArray[n8++];
                            int n9 = 0xFF & byArray[n8++];
                            int n11 = 0xFF & byArray[n8++];
                            int n12 = 0xFF & byArray[n8++];
                            int n13 = 0xFF & byArray[n8++];
                            int n14 = 0xFF & byArray[n8++];
                            n8 = 0xFF & byArray[n8];
                            gPSRecord.utc = JavaLibBridge.getDateInstance(n11, n9, n10 + 2000).dateToUTCepoch1970();
                            gPSRecord.utc += n12 * 3600 + n13 * 60 + n14;
                        }
                    }
                    if (n6 == -1) {
                        return 0;
                    }
                    if ((n7 & Integer.MIN_VALUE) != 0) {
                        n7 = -(n7 & Integer.MAX_VALUE);
                    }
                    if ((n6 & Integer.MIN_VALUE) != 0) {
                        n6 = -(n6 & Integer.MAX_VALUE);
                    }
                    gPSRecord.longitude = (double)(n7 / 1000000) + (double)(n7 % 1000000) / 600000.0;
                    gPSRecord.latitude = (double)(n6 / 1000000) + (double)(n6 % 1000000) / 600000.0;
                    gPSRecord.speed = (float)n8 * 1.852f;
                    gPSRecord.valid = 65535;
                    gPSRecord.rcr = 1;
                    gPSFileConverterInterface.addLogRecord(gPSRecord);
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                }
                n2 -= n4 - n5;
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    @Override
    protected final Object getFileObject(BT747Path bT747Path) {
        RAFile rAFile = null;
        if (File.isAvailable() && !(rAFile = new RAFile(bT747Path, 1)).isOpen()) {
            this.errorInfo = bT747Path + "|" + rAFile.getLastError();
            this.error = -1;
            rAFile = null;
        }
        return rAFile;
    }

    @Override
    protected final void closeFileObject(Object object) {
        ((File)object).close();
    }

    @Override
    public final int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            object = this.getFileObject((BT747Path)object);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(this.getLogFormatRecord$7cd0a50c());
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    private GPSRecord getLogFormatRecord$7cd0a50c() {
        int n = 45;
        switch (this.getLoggerType()) {
            case 2: 
            case 3: {
                n = 61;
            }
        }
        return GPSRecord.getLogFormatRecord(n);
    }

    @Override
    public final int getType() {
        return 10;
    }
}

