/* BudgieMenuButtons.c generated by valac 0.56.0, the Vala compiler
 * generated from BudgieMenuButtons.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgiemenuapplet.h"
#include <gmenu-tree.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

enum  {
	CATEGORY_BUTTON_0_PROPERTY,
	CATEGORY_BUTTON_GROUP_PROPERTY,
	CATEGORY_BUTTON_NUM_PROPERTIES
};
static GParamSpec* category_button_properties[CATEGORY_BUTTON_NUM_PROPERTIES];
#define __vala_GMenuTreeDirectory_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMenuTreeDirectory_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	MENU_BUTTON_0_PROPERTY,
	MENU_BUTTON_INFO_PROPERTY,
	MENU_BUTTON_PARENT_MENU_PROPERTY,
	MENU_BUTTON_NUM_PROPERTIES
};
static GParamSpec* menu_button_properties[MENU_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CategoryButtonPrivate {
	GMenuTreeDirectory* _group;
};

struct _MenuButtonPrivate {
	GDesktopAppInfo* _info;
	GMenuTreeDirectory* _parent_menu;
};

static gint CategoryButton_private_offset;
static gpointer category_button_parent_class = NULL;
static GType category_button_type_id = 0;
static gint MenuButton_private_offset;
static gpointer menu_button_parent_class = NULL;
static GType menu_button_type_id = 0;

static void _vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self);
static GMenuTreeDirectory* _vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self);
static void category_button_finalize (GObject * obj);
static void _vala_category_button_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_category_button_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void menu_button_drag_begin (MenuButton* self,
                             GdkDragContext* context);
static void _menu_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                                    GdkDragContext* context,
                                                    gpointer self);
static void menu_button_drag_end (MenuButton* self,
                           GdkDragContext* context);
static void _menu_button_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                                GdkDragContext* context,
                                                gpointer self);
static void menu_button_drag_data_get (MenuButton* self,
                                GdkDragContext* context,
                                GtkSelectionData* data,
                                guint info,
                                guint timestamp);
static void _menu_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                          GdkDragContext* context,
                                                          GtkSelectionData* selection_data,
                                                          guint info,
                                                          guint time_,
                                                          gpointer self);
static gboolean menu_button_hide_toplevel (MenuButton* self);
static gboolean _menu_button_hide_toplevel_gsource_func (gpointer self);
static gchar* menu_button_vala_has_no_strstr (MenuButton* self,
                                       const gchar* a,
                                       const gchar* b);
VALA_EXTERN gchar* searchable_string (const gchar* input);
static void menu_button_finalize (GObject * obj);
static void _vala_menu_button_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_menu_button_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
category_button_get_instance_private (CategoryButton* self)
{
	return G_STRUCT_MEMBER_P (self, CategoryButton_private_offset);
}

static void
_vala_GMenuTreeDirectory_free (GMenuTreeDirectory* self)
{
	g_boxed_free (gmenu_tree_directory_get_type (), self);
}

CategoryButton*
category_button_construct (GType object_type,
                           GMenuTreeDirectory* parent)
{
	CategoryButton * self = NULL;
	GtkLabel* lab = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkBox* layout = NULL;
	GtkBox* _tmp7_;
	GtkLabel* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GValue _tmp11_ = {0};
	self = (CategoryButton*) g_object_new (object_type, NULL);
	if (parent != NULL) {
		const gchar* _tmp0_;
		GtkLabel* _tmp1_;
		_tmp0_ = gmenu_tree_directory_get_name (parent);
		_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (lab);
		lab = _tmp1_;
	} else {
		GtkLabel* _tmp2_;
		_tmp2_ = (GtkLabel*) gtk_label_new (_ ("All"));
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (lab);
		lab = _tmp2_;
	}
	_tmp3_ = lab;
	gtk_widget_set_halign ((GtkWidget*) _tmp3_, GTK_ALIGN_START);
	_tmp4_ = lab;
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_CENTER);
	_tmp5_ = lab;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp5_, 10);
	_tmp6_ = lab;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 15);
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	layout = _tmp7_;
	_tmp8_ = lab;
	gtk_box_pack_start (layout, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp9_, "flat");
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp10_, "category-button");
	g_value_init (&_tmp11_, G_TYPE_BOOLEAN);
	g_value_set_boolean (&_tmp11_, FALSE);
	g_object_set_property ((GObject*) self, "draw-indicator", &_tmp11_);
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	category_button_set_group (self, parent);
	_g_object_unref0 (layout);
	_g_object_unref0 (lab);
	return self;
}

CategoryButton*
category_button_new (GMenuTreeDirectory* parent)
{
	return category_button_construct (TYPE_CATEGORY_BUTTON, parent);
}

GMenuTreeDirectory*
category_button_get_group (CategoryButton* self)
{
	GMenuTreeDirectory* result;
	GMenuTreeDirectory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group;
	result = _tmp0_;
	return result;
}

static GMenuTreeDirectory*
_vala_GMenuTreeDirectory_copy (GMenuTreeDirectory* self)
{
	return g_boxed_copy (gmenu_tree_directory_get_type (), self);
}

static gpointer
__vala_GMenuTreeDirectory_copy0 (gpointer self)
{
	return self ? _vala_GMenuTreeDirectory_copy (self) : NULL;
}

void
category_button_set_group (CategoryButton* self,
                           GMenuTreeDirectory* value)
{
	GMenuTreeDirectory* old_value;
	g_return_if_fail (self != NULL);
	old_value = category_button_get_group (self);
	if (old_value != value) {
		GMenuTreeDirectory* _tmp0_;
		_tmp0_ = __vala_GMenuTreeDirectory_copy0 (value);
		__vala_GMenuTreeDirectory_free0 (self->priv->_group);
		self->priv->_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, category_button_properties[CATEGORY_BUTTON_GROUP_PROPERTY]);
	}
}

static void
category_button_class_init (CategoryButtonClass * klass,
                            gpointer klass_data)
{
	category_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CategoryButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_category_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_category_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = category_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CATEGORY_BUTTON_GROUP_PROPERTY, category_button_properties[CATEGORY_BUTTON_GROUP_PROPERTY] = g_param_spec_boxed ("group", "group", "group", gmenu_tree_directory_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
category_button_instance_init (CategoryButton * self,
                               gpointer klass)
{
	self->priv = category_button_get_instance_private (self);
}

static void
category_button_finalize (GObject * obj)
{
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CATEGORY_BUTTON, CategoryButton);
	__vala_GMenuTreeDirectory_free0 (self->priv->_group);
	G_OBJECT_CLASS (category_button_parent_class)->finalize (obj);
}

/**
 * Factory widget to represent a category
 */
GType
category_button_get_type (void)
{
	return category_button_type_id;
}

GType
category_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CategoryButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) category_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CategoryButton), 0, (GInstanceInitFunc) category_button_instance_init, NULL };
	category_button_type_id = g_type_module_register_type (module, gtk_radio_button_get_type (), "CategoryButton", &g_define_type_info, 0);
	CategoryButton_private_offset = sizeof (CategoryButtonPrivate);
	return category_button_type_id;
}

static void
_vala_category_button_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CATEGORY_BUTTON, CategoryButton);
	switch (property_id) {
		case CATEGORY_BUTTON_GROUP_PROPERTY:
		g_value_set_boxed (value, category_button_get_group (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_category_button_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	CategoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CATEGORY_BUTTON, CategoryButton);
	switch (property_id) {
		case CATEGORY_BUTTON_GROUP_PROPERTY:
		category_button_set_group (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
menu_button_get_instance_private (MenuButton* self)
{
	return G_STRUCT_MEMBER_P (self, MenuButton_private_offset);
}

static void
_menu_button_drag_begin_gtk_widget_drag_begin (GtkWidget* _sender,
                                               GdkDragContext* context,
                                               gpointer self)
{
	menu_button_drag_begin ((MenuButton*) self, context);
}

static void
_menu_button_drag_end_gtk_widget_drag_end (GtkWidget* _sender,
                                           GdkDragContext* context,
                                           gpointer self)
{
	menu_button_drag_end ((MenuButton*) self, context);
}

static void
_menu_button_drag_data_get_gtk_widget_drag_data_get (GtkWidget* _sender,
                                                     GdkDragContext* context,
                                                     GtkSelectionData* selection_data,
                                                     guint info,
                                                     guint time_,
                                                     gpointer self)
{
	menu_button_drag_data_get ((MenuButton*) self, context, selection_data, info, time_);
}

MenuButton*
menu_button_construct (GType object_type,
                       GDesktopAppInfo* parent,
                       GMenuTreeDirectory* directory,
                       gint icon_size)
{
	MenuButton * self = NULL;
	GtkImage* img = NULL;
	GIcon* _tmp0_;
	GtkImage* _tmp1_;
	GtkLabel* lab = NULL;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	static const GtkTargetEntry drag_targets[2] = {{"text/uri-list", (guint) 0, (guint) 0}, {"application/x-desktop", (guint) 0, (guint) 0}};
	GtkBox* layout = NULL;
	GtkBox* _tmp4_;
	const gchar* _tmp5_;
	GtkStyleContext* _tmp6_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	self = (MenuButton*) g_object_new (object_type, NULL);
	_tmp0_ = g_app_info_get_icon ((GAppInfo*) parent);
	_tmp1_ = (GtkImage*) gtk_image_new_from_gicon (_tmp0_, (GtkIconSize) GTK_ICON_SIZE_INVALID);
	g_object_ref_sink (_tmp1_);
	img = _tmp1_;
	gtk_image_set_pixel_size (img, icon_size);
	gtk_widget_set_margin_end ((GtkWidget*) img, 7);
	_tmp2_ = g_app_info_get_display_name ((GAppInfo*) parent);
	_tmp3_ = (GtkLabel*) gtk_label_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	lab = _tmp3_;
	gtk_widget_set_halign ((GtkWidget*) lab, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) lab, GTK_ALIGN_CENTER);
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, drag_targets, (gint) G_N_ELEMENTS (drag_targets), GDK_ACTION_COPY);
	g_signal_connect_object ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "drag-begin", (GCallback) _menu_button_drag_begin_gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "drag-end", (GCallback) _menu_button_drag_end_gtk_widget_drag_end, self, 0);
	g_signal_connect_object ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), "drag-data-get", (GCallback) _menu_button_drag_data_get_gtk_widget_drag_data_get, self, 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp4_);
	layout = _tmp4_;
	gtk_box_pack_start (layout, (GtkWidget*) img, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (layout, (GtkWidget*) lab, TRUE, TRUE, (guint) 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) layout);
	menu_button_set_info (self, parent);
	menu_button_set_parent_menu (self, directory);
	_tmp5_ = g_app_info_get_description ((GAppInfo*) parent);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp5_);
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp6_, "flat");
	_g_object_unref0 (layout);
	_g_object_unref0 (lab);
	_g_object_unref0 (img);
	return self;
}

MenuButton*
menu_button_new (GDesktopAppInfo* parent,
                 GMenuTreeDirectory* directory,
                 gint icon_size)
{
	return menu_button_construct (TYPE_MENU_BUTTON, parent, directory, icon_size);
}

static gboolean
menu_button_hide_toplevel (MenuButton* self)
{
	GtkWidget* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	gtk_widget_hide (_tmp0_);
	result = FALSE;
	return result;
}

static void
menu_button_drag_begin (MenuButton* self,
                        GdkDragContext* context)
{
	GDesktopAppInfo* _tmp0_;
	GIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = self->priv->_info;
	_tmp1_ = g_app_info_get_icon ((GAppInfo*) _tmp0_);
	gtk_drag_set_icon_gicon (context, _tmp1_, 0, 0);
}

static gboolean
_menu_button_hide_toplevel_gsource_func (gpointer self)
{
	gboolean result;
	result = menu_button_hide_toplevel ((MenuButton*) self);
	return result;
}

static void
menu_button_drag_end (MenuButton* self,
                      GdkDragContext* context)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _menu_button_hide_toplevel_gsource_func, g_object_ref (self), g_object_unref);
}

static void
menu_button_drag_data_get (MenuButton* self,
                           GdkDragContext* context,
                           GtkSelectionData* data,
                           guint info,
                           guint timestamp)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (data != NULL);
	{
		gchar* _tmp0_ = NULL;
		GDesktopAppInfo* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** urls = NULL;
		gchar* _tmp4_;
		gchar** _tmp5_;
		gint urls_length1;
		gint _urls_size_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp1_ = self->priv->_info;
		_tmp2_ = g_desktop_app_info_get_filename (_tmp1_);
		_tmp3_ = g_filename_to_uri (_tmp2_, NULL, &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_tmp5_ = g_new0 (gchar*, 1 + 1);
		_tmp5_[0] = _tmp4_;
		urls = _tmp5_;
		urls_length1 = 1;
		_urls_size_ = urls_length1;
		_tmp6_ = urls;
		_tmp6__length1 = urls_length1;
		gtk_selection_data_set_uris (data, _tmp6_);
		urls = (_vala_array_free (urls, urls_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("BudgieMenuButtons.vala:98: Failed to set copy data: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
menu_button_vala_has_no_strstr (MenuButton* self,
                                const gchar* a,
                                const gchar* b)
{
	gint index = 0;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (a != NULL, NULL);
	g_return_val_if_fail (b != NULL, NULL);
	index = string_index_of (a, b, 0);
	if (index < 0) {
		result = NULL;
		return result;
	}
	_tmp0_ = string_substring (a, (glong) index, (glong) -1);
	result = _tmp0_;
	return result;
}

gint
menu_button_get_score (MenuButton* self,
                       const gchar* term)
{
	gint score = 0;
	gchar* name = NULL;
	GDesktopAppInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* found = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GCompareFunc _tmp11_;
	const gchar* _tmp12_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (term != NULL, 0);
	score = 0;
	_tmp0_ = self->priv->_info;
	_tmp1_ = g_app_info_get_name ((GAppInfo*) _tmp0_);
	_tmp2_ = searchable_string (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, term) == 0) {
		score += 100;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = name;
		if (g_str_has_prefix (_tmp4_, term)) {
			score += 50;
		}
	}
	_tmp5_ = name;
	_tmp6_ = menu_button_vala_has_no_strstr (self, _tmp5_, term);
	found = _tmp6_;
	_tmp7_ = found;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = found;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		score += 20 + _tmp10_;
	}
	_tmp11_ = ((GCompareFunc) g_strcmp0);
	_tmp12_ = name;
	score += _tmp11_ (_tmp12_, term);
	result = score;
	_g_free0 (found);
	_g_free0 (name);
	return result;
}

GDesktopAppInfo*
menu_button_get_info (MenuButton* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
menu_button_set_info (MenuButton* self,
                      GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = menu_button_get_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_info);
		self->priv->_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, menu_button_properties[MENU_BUTTON_INFO_PROPERTY]);
	}
}

GMenuTreeDirectory*
menu_button_get_parent_menu (MenuButton* self)
{
	GMenuTreeDirectory* result;
	GMenuTreeDirectory* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_menu;
	result = _tmp0_;
	return result;
}

void
menu_button_set_parent_menu (MenuButton* self,
                             GMenuTreeDirectory* value)
{
	GMenuTreeDirectory* old_value;
	g_return_if_fail (self != NULL);
	old_value = menu_button_get_parent_menu (self);
	if (old_value != value) {
		GMenuTreeDirectory* _tmp0_;
		_tmp0_ = __vala_GMenuTreeDirectory_copy0 (value);
		__vala_GMenuTreeDirectory_free0 (self->priv->_parent_menu);
		self->priv->_parent_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, menu_button_properties[MENU_BUTTON_PARENT_MENU_PROPERTY]);
	}
}

static void
menu_button_class_init (MenuButtonClass * klass,
                        gpointer klass_data)
{
	menu_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MenuButton_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_menu_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_menu_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = menu_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_INFO_PROPERTY, menu_button_properties[MENU_BUTTON_INFO_PROPERTY] = g_param_spec_object ("info", "info", "info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MENU_BUTTON_PARENT_MENU_PROPERTY, menu_button_properties[MENU_BUTTON_PARENT_MENU_PROPERTY] = g_param_spec_boxed ("parent-menu", "parent-menu", "parent-menu", gmenu_tree_directory_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
menu_button_instance_init (MenuButton * self,
                           gpointer klass)
{
	self->priv = menu_button_get_instance_private (self);
}

static void
menu_button_finalize (GObject * obj)
{
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MENU_BUTTON, MenuButton);
	_g_object_unref0 (self->priv->_info);
	__vala_GMenuTreeDirectory_free0 (self->priv->_parent_menu);
	G_OBJECT_CLASS (menu_button_parent_class)->finalize (obj);
}

/**
 * Factory widget to represent a menu item
 */
GType
menu_button_get_type (void)
{
	return menu_button_type_id;
}

GType
menu_button_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MenuButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) menu_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MenuButton), 0, (GInstanceInitFunc) menu_button_instance_init, NULL };
	menu_button_type_id = g_type_module_register_type (module, gtk_button_get_type (), "MenuButton", &g_define_type_info, 0);
	MenuButton_private_offset = sizeof (MenuButtonPrivate);
	return menu_button_type_id;
}

static void
_vala_menu_button_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_BUTTON, MenuButton);
	switch (property_id) {
		case MENU_BUTTON_INFO_PROPERTY:
		g_value_set_object (value, menu_button_get_info (self));
		break;
		case MENU_BUTTON_PARENT_MENU_PROPERTY:
		g_value_set_boxed (value, menu_button_get_parent_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_menu_button_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MenuButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MENU_BUTTON, MenuButton);
	switch (property_id) {
		case MENU_BUTTON_INFO_PROPERTY:
		menu_button_set_info (self, g_value_get_object (value));
		break;
		case MENU_BUTTON_PARENT_MENU_PROPERTY:
		menu_button_set_parent_menu (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

