/* main.c generated by valac 0.56.0, the Vala compiler
 * generated from main.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2016-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>
#include <glib-object.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <budgie-config.h>
#include <stdio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef struct _Block4Data Block4Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_SERVICE_MANAGER (budgie_service_manager_get_type ())
#define BUDGIE_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManager))
#define BUDGIE_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))
#define BUDGIE_IS_SERVICE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_IS_SERVICE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SERVICE_MANAGER))
#define BUDGIE_SERVICE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SERVICE_MANAGER, BudgieServiceManagerClass))

typedef struct _BudgieServiceManager BudgieServiceManager;
typedef struct _BudgieServiceManagerClass BudgieServiceManagerClass;

#define BUDGIE_TYPE_END_SESSION_DIALOG (budgie_end_session_dialog_get_type ())
#define BUDGIE_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialog))
#define BUDGIE_END_SESSION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogClass))
#define BUDGIE_IS_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_IS_END_SESSION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_END_SESSION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogClass))

typedef struct _BudgieEndSessionDialog BudgieEndSessionDialog;
typedef struct _BudgieEndSessionDialogClass BudgieEndSessionDialogClass;

#define BUDGIE_TYPE_SETTINGS_MANAGER (budgie_settings_manager_get_type ())
#define BUDGIE_SETTINGS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManager))
#define BUDGIE_SETTINGS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManagerClass))
#define BUDGIE_IS_SETTINGS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_MANAGER))
#define BUDGIE_IS_SETTINGS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_MANAGER))
#define BUDGIE_SETTINGS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_MANAGER, BudgieSettingsManagerClass))

typedef struct _BudgieSettingsManager BudgieSettingsManager;
typedef struct _BudgieSettingsManagerClass BudgieSettingsManagerClass;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _budgie_settings_manager_unref0(var) ((var == NULL) ? NULL : (var = (budgie_settings_manager_unref (var), NULL)))

struct _Block4Data {
	int _ref_count_;
	WnckScreen* screen;
};

VALA_EXTERN gboolean replace;
gboolean replace = FALSE;
VALA_EXTERN gboolean budgie_setup;
gboolean budgie_setup = FALSE;
VALA_EXTERN gboolean budgie_spammed;
gboolean budgie_spammed = FALSE;

VALA_EXTERN void budgie_DaemonNameLost (GDBusConnection* conn,
                            const gchar* name);
static gint _vala_main (gchar** args,
                 gint args_length1);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GType budgie_service_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieServiceManager, g_object_unref)
VALA_EXTERN GType budgie_end_session_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieEndSessionDialog, g_object_unref)
VALA_EXTERN guint budgie_end_session_dialog_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN gpointer budgie_settings_manager_ref (gpointer instance);
VALA_EXTERN void budgie_settings_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_settings_manager (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void budgie_value_set_settings_manager (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void budgie_value_take_settings_manager (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_settings_manager (const GValue* value);
VALA_EXTERN GType budgie_settings_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsManager, budgie_settings_manager_unref)
static gboolean __lambda28_ (Block4Data* _data4_);
static gboolean ___lambda28__gsource_func (gpointer self);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_new (gboolean replace);
VALA_EXTERN BudgieServiceManager* budgie_service_manager_construct (GType object_type,
                                                        gboolean replace);
VALA_EXTERN BudgieEndSessionDialog* budgie_end_session_dialog_new (gboolean replace);
VALA_EXTERN BudgieEndSessionDialog* budgie_end_session_dialog_construct (GType object_type,
                                                             gboolean replace);
VALA_EXTERN BudgieSettingsManager* budgie_settings_manager_new (void);
VALA_EXTERN BudgieSettingsManager* budgie_settings_manager_construct (GType object_type);
VALA_EXTERN void budgie_settings_manager_do_disable_quietly (BudgieSettingsManager* self);
static void _budgie_settings_manager_do_disable_quietly_budgie_end_session_dialog_opened (BudgieEndSessionDialog* _sender,
                                                                                   gpointer self);
static void _budgie_settings_manager_do_disable_quietly_budgie_end_session_dialog_closed (BudgieEndSessionDialog* _sender,
                                                                                   gpointer self);

const GOptionEntry options[2] = {{"replace", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &replace, "Replace currently running daemon"}, {NULL}};

void
budgie_DaemonNameLost (GDBusConnection* conn,
                       const gchar* name)
{
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_warning ("main.vala:27: budgie-daemon lost d-bus name %s", name);
	if (!budgie_spammed) {
		if (budgie_setup) {
			g_message ("main.vala:30: Replaced existing budgie-daemon");
		} else {
			g_message ("main.vala:32: Another instance of budgie-daemon is running. Use --repl" \
"ace");
		}
		budgie_spammed = TRUE;
	}
	gtk_main_quit ();
}

/**
 * Main entry for the daemon
 */
static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->screen);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda28_ (Block4Data* _data4_)
{
	WnckScreen* _tmp0_;
	WnckScreen* _tmp1_;
	WnckScreen* _tmp2_;
	gboolean result;
	_tmp0_ = wnck_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data4_->screen);
	_data4_->screen = _tmp1_;
	_tmp2_ = _data4_->screen;
	if (_tmp2_ != NULL) {
		WnckScreen* _tmp3_;
		_tmp3_ = _data4_->screen;
		wnck_screen_force_update (_tmp3_);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ (self);
	return result;
}

static void
_budgie_settings_manager_do_disable_quietly_budgie_end_session_dialog_opened (BudgieEndSessionDialog* _sender,
                                                                              gpointer self)
{
	budgie_settings_manager_do_disable_quietly ((BudgieSettingsManager*) self);
}

static void
_budgie_settings_manager_do_disable_quietly_budgie_end_session_dialog_closed (BudgieEndSessionDialog* _sender,
                                                                              gpointer self)
{
	budgie_settings_manager_do_disable_quietly ((BudgieSettingsManager*) self);
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	Block4Data* _data4_;
	GOptionContext* ctx = NULL;
	BudgieServiceManager* manager = NULL;
	BudgieEndSessionDialog* end_dialog = NULL;
	BudgieSettingsManager* settings = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GOptionGroup* _tmp4_;
	BudgieServiceManager* _tmp10_;
	BudgieEndSessionDialog* _tmp11_;
	BudgieSettingsManager* _tmp12_;
	BudgieEndSessionDialog* _tmp13_;
	BudgieSettingsManager* _tmp14_;
	BudgieEndSessionDialog* _tmp15_;
	BudgieSettingsManager* _tmp16_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	gtk_init ((gint*) (&args_length1), &args);
	manager = NULL;
	end_dialog = NULL;
	settings = NULL;
	_data4_->screen = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (BUDGIE_GETTEXT_PACKAGE, BUDGIE_LOCALEDIR);
	bind_textdomain_codeset (BUDGIE_GETTEXT_PACKAGE, "UTF-8");
	textdomain (BUDGIE_GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new ("- Budgie Daemon");
	_g_option_context_free0 (ctx);
	ctx = _tmp0_;
	_tmp1_ = ctx;
	g_option_context_set_help_enabled (_tmp1_, TRUE);
	_tmp2_ = ctx;
	g_option_context_add_main_entries (_tmp2_, options, NULL);
	_tmp3_ = ctx;
	_tmp4_ = gtk_get_option_group (FALSE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	{
		GOptionContext* _tmp5_;
		_tmp5_ = ctx;
		g_option_context_parse (_tmp5_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		fprintf (_tmp6_, "Error: %s\n", _tmp8_);
		result = 0;
		_g_error_free0 (e);
		_budgie_settings_manager_unref0 (settings);
		_g_object_unref0 (end_dialog);
		_g_object_unref0 (manager);
		_g_option_context_free0 (ctx);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp9_ = -1;
		_budgie_settings_manager_unref0 (settings);
		_g_object_unref0 (end_dialog);
		_g_object_unref0 (manager);
		_g_option_context_free0 (ctx);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda28__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	_tmp10_ = budgie_service_manager_new (replace);
	_g_object_unref0 (manager);
	manager = _tmp10_;
	_tmp11_ = budgie_end_session_dialog_new (replace);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (end_dialog);
	end_dialog = _tmp11_;
	_tmp12_ = budgie_settings_manager_new ();
	_budgie_settings_manager_unref0 (settings);
	settings = _tmp12_;
	_tmp13_ = end_dialog;
	_tmp14_ = settings;
	g_signal_connect (_tmp13_, "opened", (GCallback) _budgie_settings_manager_do_disable_quietly_budgie_end_session_dialog_opened, _tmp14_);
	_tmp15_ = end_dialog;
	_tmp16_ = settings;
	g_signal_connect (_tmp15_, "closed", (GCallback) _budgie_settings_manager_do_disable_quietly_budgie_end_session_dialog_closed, _tmp16_);
	gtk_main ();
	_g_object_unref0 (manager);
	manager = NULL;
	_g_object_unref0 (end_dialog);
	end_dialog = NULL;
	_budgie_settings_manager_unref0 (settings);
	settings = NULL;
	_g_object_unref0 (_data4_->screen);
	_data4_->screen = NULL;
	result = 0;
	_budgie_settings_manager_unref0 (settings);
	_g_object_unref0 (end_dialog);
	_g_object_unref0 (manager);
	_g_option_context_free0 (ctx);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

