/* settings_applet_chooser.c generated by valac 0.56.0, the Vala compiler
 * generated from settings_applet_chooser.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libpeas/peas.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_PLUGIN_ITEM (budgie_plugin_item_get_type ())
#define BUDGIE_PLUGIN_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem))
#define BUDGIE_PLUGIN_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItemClass))
#define BUDGIE_IS_PLUGIN_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PLUGIN_ITEM))
#define BUDGIE_IS_PLUGIN_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PLUGIN_ITEM))
#define BUDGIE_PLUGIN_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItemClass))

typedef struct _BudgiePluginItem BudgiePluginItem;
typedef struct _BudgiePluginItemClass BudgiePluginItemClass;
typedef struct _BudgiePluginItemPrivate BudgiePluginItemPrivate;
enum  {
	BUDGIE_PLUGIN_ITEM_0_PROPERTY,
	BUDGIE_PLUGIN_ITEM_PLUGIN_PROPERTY,
	BUDGIE_PLUGIN_ITEM_NUM_PROPERTIES
};
static GParamSpec* budgie_plugin_item_properties[BUDGIE_PLUGIN_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_APPLET_CHOOSER (budgie_applet_chooser_get_type ())
#define BUDGIE_APPLET_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooser))
#define BUDGIE_APPLET_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooserClass))
#define BUDGIE_IS_APPLET_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APPLET_CHOOSER))
#define BUDGIE_IS_APPLET_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APPLET_CHOOSER))
#define BUDGIE_APPLET_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooserClass))

typedef struct _BudgieAppletChooser BudgieAppletChooser;
typedef struct _BudgieAppletChooserClass BudgieAppletChooserClass;
typedef struct _BudgieAppletChooserPrivate BudgieAppletChooserPrivate;
enum  {
	BUDGIE_APPLET_CHOOSER_0_PROPERTY,
	BUDGIE_APPLET_CHOOSER_NUM_PROPERTIES
};
static GParamSpec* budgie_applet_chooser_properties[BUDGIE_APPLET_CHOOSER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))

struct _BudgiePluginItem {
	GtkGrid parent_instance;
	BudgiePluginItemPrivate * priv;
};

struct _BudgiePluginItemClass {
	GtkGridClass parent_class;
};

struct _BudgiePluginItemPrivate {
	PeasPluginInfo* _plugin;
	GtkImage* image;
	GtkLabel* label;
	GtkLabel* desc;
};

struct _BudgieAppletChooser {
	GtkDialog parent_instance;
	BudgieAppletChooserPrivate * priv;
};

struct _BudgieAppletChooserClass {
	GtkDialogClass parent_class;
};

struct _BudgieAppletChooserPrivate {
	GtkListBox* applets;
	GtkWidget* button_ok;
	gchar* applet_id;
};

static gint BudgiePluginItem_private_offset;
static gpointer budgie_plugin_item_parent_class = NULL;
static gint BudgieAppletChooser_private_offset;
static gpointer budgie_applet_chooser_parent_class = NULL;

VALA_EXTERN GType budgie_plugin_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePluginItem, g_object_unref)
VALA_EXTERN BudgiePluginItem* budgie_plugin_item_new (PeasPluginInfo* info);
VALA_EXTERN BudgiePluginItem* budgie_plugin_item_construct (GType object_type,
                                                PeasPluginInfo* info);
VALA_EXTERN PeasPluginInfo* budgie_plugin_item_get_plugin (BudgiePluginItem* self);
VALA_EXTERN void budgie_plugin_item_set_plugin (BudgiePluginItem* self,
                                    PeasPluginInfo* value);
static void budgie_plugin_item_finalize (GObject * obj);
static GType budgie_plugin_item_get_type_once (void);
static void _vala_budgie_plugin_item_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_budgie_plugin_item_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GType budgie_applet_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppletChooser, g_object_unref)
VALA_EXTERN BudgieAppletChooser* budgie_applet_chooser_new (GtkWindow* parent);
VALA_EXTERN BudgieAppletChooser* budgie_applet_chooser_construct (GType object_type,
                                                      GtkWindow* parent);
static gint budgie_applet_chooser_sort_applets (BudgieAppletChooser* self,
                                         GtkListBoxRow* a,
                                         GtkListBoxRow* b);
static gint _budgie_applet_chooser_sort_applets_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self);
static void budgie_applet_chooser_row_selected (BudgieAppletChooser* self,
                                         GtkListBoxRow* row);
static void _budgie_applet_chooser_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                    GtkListBoxRow* row,
                                                                    gpointer self);
static void budgie_applet_chooser_row_activated (BudgieAppletChooser* self,
                                          GtkListBoxRow* row);
static void _budgie_applet_chooser_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                      GtkListBoxRow* row,
                                                                      gpointer self);
VALA_EXTERN gchar* budgie_applet_chooser_run (BudgieAppletChooser* self);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
VALA_EXTERN void budgie_applet_chooser_set_plugin_list (BudgieAppletChooser* self,
                                            GList* plugins);
static void budgie_applet_chooser_add_plugin (BudgieAppletChooser* self,
                                       PeasPluginInfo* plugin);
static void budgie_applet_chooser_finalize (GObject * obj);
static GType budgie_applet_chooser_get_type_once (void);

static inline gpointer
budgie_plugin_item_get_instance_private (BudgiePluginItem* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePluginItem_private_offset);
}

/**
* Construct a new PluginItem for the given applet
*/
BudgiePluginItem*
budgie_plugin_item_construct (GType object_type,
                              PeasPluginInfo* info)
{
	BudgiePluginItem * self = NULL;
	GtkStyleContext* _tmp0_;
	const gchar* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	const gchar* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	const gchar* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GValue _tmp15_ = {0};
	GtkLabel* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkImage* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	self = (BudgiePluginItem*) g_object_new (object_type, "plugin", info, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "plugin-item");
	gtk_widget_set_margin_top ((GtkWidget*) self, 4);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 4);
	_tmp1_ = peas_plugin_info_get_icon_name (info);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp1_, (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp2_;
	_tmp3_ = self->priv->image;
	gtk_image_set_pixel_size (_tmp3_, 32);
	_tmp4_ = self->priv->image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp4_, 12);
	_tmp5_ = self->priv->image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, 14);
	_tmp6_ = peas_plugin_info_get_name (info);
	_tmp7_ = (GtkLabel*) gtk_label_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp7_;
	_tmp8_ = self->priv->label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp8_, 18);
	_tmp9_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	_tmp10_ = peas_plugin_info_get_description (info);
	_tmp11_ = (GtkLabel*) gtk_label_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->desc);
	self->priv->desc = _tmp11_;
	_tmp12_ = self->priv->desc;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 4);
	_tmp13_ = self->priv->desc;
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	_tmp14_ = self->priv->desc;
	g_value_init (&_tmp15_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp15_, 0.0);
	g_object_set_property ((GObject*) _tmp14_, "xalign", &_tmp15_);
	G_IS_VALUE (&_tmp15_) ? (g_value_unset (&_tmp15_), NULL) : NULL;
	_tmp16_ = self->priv->desc;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) _tmp16_);
	gtk_style_context_add_class (_tmp17_, "dim-label");
	_tmp18_ = self->priv->image;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp18_, 0, 0, 1, 2);
	_tmp19_ = self->priv->label;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp19_, 1, 0, 1, 1);
	_tmp20_ = self->priv->desc;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp20_, 1, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

BudgiePluginItem*
budgie_plugin_item_new (PeasPluginInfo* info)
{
	return budgie_plugin_item_construct (BUDGIE_TYPE_PLUGIN_ITEM, info);
}

PeasPluginInfo*
budgie_plugin_item_get_plugin (BudgiePluginItem* self)
{
	PeasPluginInfo* result;
	PeasPluginInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_plugin;
	result = _tmp0_;
	return result;
}

void
budgie_plugin_item_set_plugin (BudgiePluginItem* self,
                               PeasPluginInfo* value)
{
	PeasPluginInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_plugin_item_get_plugin (self);
	if (old_value != value) {
		self->priv->_plugin = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_plugin_item_properties[BUDGIE_PLUGIN_ITEM_PLUGIN_PROPERTY]);
	}
}

static void
budgie_plugin_item_class_init (BudgiePluginItemClass * klass,
                               gpointer klass_data)
{
	budgie_plugin_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgiePluginItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_plugin_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_plugin_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_plugin_item_finalize;
	/**
	* We're bound to the info
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_PLUGIN_ITEM_PLUGIN_PROPERTY, budgie_plugin_item_properties[BUDGIE_PLUGIN_ITEM_PLUGIN_PROPERTY] = g_param_spec_boxed ("plugin", "plugin", "plugin", peas_plugin_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
budgie_plugin_item_instance_init (BudgiePluginItem * self,
                                  gpointer klass)
{
	self->priv = budgie_plugin_item_get_instance_private (self);
}

static void
budgie_plugin_item_finalize (GObject * obj)
{
	BudgiePluginItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	_g_object_unref0 (self->priv->desc);
	G_OBJECT_CLASS (budgie_plugin_item_parent_class)->finalize (obj);
}

/**
* PluginItem is used to represent a plugin for the user to add to their
* panel through the Applet API
*/
static GType
budgie_plugin_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePluginItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_plugin_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePluginItem), 0, (GInstanceInitFunc) budgie_plugin_item_instance_init, NULL };
	GType budgie_plugin_item_type_id;
	budgie_plugin_item_type_id = g_type_register_static (gtk_grid_get_type (), "BudgiePluginItem", &g_define_type_info, 0);
	BudgiePluginItem_private_offset = g_type_add_instance_private (budgie_plugin_item_type_id, sizeof (BudgiePluginItemPrivate));
	return budgie_plugin_item_type_id;
}

GType
budgie_plugin_item_get_type (void)
{
	static volatile gsize budgie_plugin_item_type_id__once = 0;
	if (g_once_init_enter (&budgie_plugin_item_type_id__once)) {
		GType budgie_plugin_item_type_id;
		budgie_plugin_item_type_id = budgie_plugin_item_get_type_once ();
		g_once_init_leave (&budgie_plugin_item_type_id__once, budgie_plugin_item_type_id);
	}
	return budgie_plugin_item_type_id__once;
}

static void
_vala_budgie_plugin_item_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BudgiePluginItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem);
	switch (property_id) {
		case BUDGIE_PLUGIN_ITEM_PLUGIN_PROPERTY:
		g_value_set_boxed (value, budgie_plugin_item_get_plugin (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_plugin_item_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	BudgiePluginItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem);
	switch (property_id) {
		case BUDGIE_PLUGIN_ITEM_PLUGIN_PROPERTY:
		budgie_plugin_item_set_plugin (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_applet_chooser_get_instance_private (BudgieAppletChooser* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAppletChooser_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
_budgie_applet_chooser_sort_applets_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                            GtkListBoxRow* row2,
                                                            gpointer self)
{
	gint result;
	result = budgie_applet_chooser_sort_applets ((BudgieAppletChooser*) self, row1, row2);
	return result;
}

static void
_budgie_applet_chooser_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                               GtkListBoxRow* row,
                                                               gpointer self)
{
	budgie_applet_chooser_row_selected ((BudgieAppletChooser*) self, row);
}

static void
_budgie_applet_chooser_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                 GtkListBoxRow* row,
                                                                 gpointer self)
{
	budgie_applet_chooser_row_activated ((BudgieAppletChooser*) self, row);
}

BudgieAppletChooser*
budgie_applet_chooser_construct (GType object_type,
                                 GtkWindow* parent)
{
	BudgieAppletChooser * self = NULL;
	GtkBox* content_area = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkListBox* _tmp13_;
	g_return_val_if_fail (parent != NULL, NULL);
	self = (BudgieAppletChooser*) g_object_new (object_type, "use-header-bar", 1, "modal", TRUE, "title", _ ("Choose an applet"), "transient-for", parent, NULL);
	_tmp0_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_box_get_type ()) ? ((GtkBox*) _tmp0_) : NULL);
	content_area = _tmp1_;
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp2_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Add applet"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->button_ok);
	self->priv->button_ok = _tmp3_;
	_tmp4_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp4_, FALSE);
	_tmp5_ = self->priv->button_ok;
	_tmp6_ = gtk_widget_get_style_context (_tmp5_);
	gtk_style_context_add_class (_tmp6_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp7_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp7_);
	scroll = _tmp7_;
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp8_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->applets);
	self->priv->applets = _tmp8_;
	_tmp9_ = self->priv->applets;
	gtk_list_box_set_activate_on_single_click (_tmp9_, FALSE);
	_tmp10_ = self->priv->applets;
	gtk_list_box_set_sort_func (_tmp10_, _budgie_applet_chooser_sort_applets_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp11_ = self->priv->applets;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->applets;
	g_signal_connect_object (_tmp12_, "row-selected", (GCallback) _budgie_applet_chooser_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp13_ = self->priv->applets;
	g_signal_connect_object (_tmp13_, "row-activated", (GCallback) _budgie_applet_chooser_row_activated_gtk_list_box_row_activated, self, 0);
	gtk_box_pack_start (content_area, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	gtk_window_set_default_size ((GtkWindow*) self, 400, 450);
	_g_object_unref0 (scroll);
	_g_object_unref0 (content_area);
	return self;
}

BudgieAppletChooser*
budgie_applet_chooser_new (GtkWindow* parent)
{
	return budgie_applet_chooser_construct (BUDGIE_TYPE_APPLET_CHOOSER, parent);
}

/**
* Simple accessor to get the new applet ID to be added
*/
gchar*
budgie_applet_chooser_run (BudgieAppletChooser* self)
{
	GtkResponseType resp = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	resp = (GtkResponseType) gtk_dialog_run (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_dialog_get_type (), GtkDialog));
	switch (resp) {
		case GTK_RESPONSE_ACCEPT:
		{
			const gchar* _tmp0_;
			gchar* _tmp1_;
			_tmp0_ = self->priv->applet_id;
			_tmp1_ = g_strdup (_tmp0_);
			result = _tmp1_;
			return result;
		}
		default:
		case GTK_RESPONSE_CANCEL:
		{
			result = NULL;
			return result;
		}
	}
}

/**
* Super simple sorting of applets in alphabetical listing
*/
static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static gint
budgie_applet_chooser_sort_applets (BudgieAppletChooser* self,
                                    GtkListBoxRow* a,
                                    GtkListBoxRow* b)
{
	PeasPluginInfo* infoA = NULL;
	GtkWidget* _tmp0_;
	PeasPluginInfo* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasPluginInfo* _tmp3_;
	PeasPluginInfo* infoB = NULL;
	GtkWidget* _tmp4_;
	PeasPluginInfo* _tmp5_;
	PeasPluginInfo* _tmp6_;
	PeasPluginInfo* _tmp7_;
	GCompareFunc _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) a);
	_tmp1_ = budgie_plugin_item_get_plugin (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem));
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_PeasPluginInfo_copy0 (_tmp2_);
	infoA = _tmp3_;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) b);
	_tmp5_ = budgie_plugin_item_get_plugin (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem));
	_tmp6_ = _tmp5_;
	_tmp7_ = __vala_PeasPluginInfo_copy0 (_tmp6_);
	infoB = _tmp7_;
	_tmp8_ = ((GCompareFunc) g_strcmp0);
	_tmp9_ = peas_plugin_info_get_name (infoA);
	_tmp10_ = g_utf8_strdown (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = peas_plugin_info_get_name (infoB);
	_tmp13_ = g_utf8_strdown (_tmp12_, (gssize) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp8_ (_tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	result = _tmp15_;
	__vala_PeasPluginInfo_free0 (infoB);
	__vala_PeasPluginInfo_free0 (infoA);
	return result;
}

/**
* User picked a plugin
*/
static void
budgie_applet_chooser_row_selected (BudgieAppletChooser* self,
                                    GtkListBoxRow* row)
{
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	PeasPluginInfo* _tmp3_;
	PeasPluginInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		GtkWidget* _tmp0_;
		_g_free0 (self->priv->applet_id);
		self->priv->applet_id = NULL;
		_tmp0_ = self->priv->button_ok;
		gtk_widget_set_sensitive (_tmp0_, FALSE);
		return;
	}
	_tmp1_ = self->priv->button_ok;
	gtk_widget_set_sensitive (_tmp1_, TRUE);
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp3_ = budgie_plugin_item_get_plugin (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, BUDGIE_TYPE_PLUGIN_ITEM, BudgiePluginItem));
	_tmp4_ = _tmp3_;
	_tmp5_ = peas_plugin_info_get_name (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->applet_id);
	self->priv->applet_id = _tmp6_;
}

/**
* Special sauce to allow us to double-click activate an applet
*/
static void
budgie_applet_chooser_row_activated (BudgieAppletChooser* self,
                                     GtkListBoxRow* row)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	budgie_applet_chooser_row_selected (self, row);
	_tmp0_ = self->priv->applet_id;
	if (_tmp0_ != NULL) {
		gtk_dialog_response ((GtkDialog*) self, (gint) GTK_RESPONSE_ACCEPT);
	}
}

/**
* Set the available plugins to show in the dialog
*/
void
budgie_applet_chooser_set_plugin_list (BudgieAppletChooser* self,
                                       GList* plugins)
{
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GtkListBox* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				gtk_widget_destroy (_tmp2_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	{
		GList* plugin_collection = NULL;
		GList* plugin_it = NULL;
		plugin_collection = plugins;
		for (plugin_it = plugin_collection; plugin_it != NULL; plugin_it = plugin_it->next) {
			PeasPluginInfo* _tmp3_;
			PeasPluginInfo* plugin = NULL;
			_tmp3_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) plugin_it->data);
			plugin = _tmp3_;
			{
				PeasPluginInfo* _tmp4_;
				_tmp4_ = plugin;
				budgie_applet_chooser_add_plugin (self, _tmp4_);
				__vala_PeasPluginInfo_free0 (plugin);
			}
		}
	}
	_tmp5_ = self->priv->applets;
	gtk_list_box_invalidate_sort (_tmp5_);
}

/**
* Add a new plugin to our display area
*/
static void
budgie_applet_chooser_add_plugin (BudgieAppletChooser* self,
                                  PeasPluginInfo* plugin)
{
	GtkListBox* _tmp0_;
	BudgiePluginItem* _tmp1_;
	BudgiePluginItem* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->applets;
	_tmp1_ = budgie_plugin_item_new (plugin);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) _tmp0_, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}

static void
budgie_applet_chooser_class_init (BudgieAppletChooserClass * klass,
                                  gpointer klass_data)
{
	budgie_applet_chooser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAppletChooser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_applet_chooser_finalize;
}

static void
budgie_applet_chooser_instance_init (BudgieAppletChooser * self,
                                     gpointer klass)
{
	self->priv = budgie_applet_chooser_get_instance_private (self);
	self->priv->applet_id = NULL;
}

static void
budgie_applet_chooser_finalize (GObject * obj)
{
	BudgieAppletChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooser);
	_g_object_unref0 (self->priv->applets);
	_g_object_unref0 (self->priv->button_ok);
	_g_free0 (self->priv->applet_id);
	G_OBJECT_CLASS (budgie_applet_chooser_parent_class)->finalize (obj);
}

/**
* AppletChooser provides a dialog to allow selection of an
* applet to be added to a panel
*/
static GType
budgie_applet_chooser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppletChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_applet_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppletChooser), 0, (GInstanceInitFunc) budgie_applet_chooser_instance_init, NULL };
	GType budgie_applet_chooser_type_id;
	budgie_applet_chooser_type_id = g_type_register_static (gtk_dialog_get_type (), "BudgieAppletChooser", &g_define_type_info, 0);
	BudgieAppletChooser_private_offset = g_type_add_instance_private (budgie_applet_chooser_type_id, sizeof (BudgieAppletChooserPrivate));
	return budgie_applet_chooser_type_id;
}

GType
budgie_applet_chooser_get_type (void)
{
	static volatile gsize budgie_applet_chooser_type_id__once = 0;
	if (g_once_init_enter (&budgie_applet_chooser_type_id__once)) {
		GType budgie_applet_chooser_type_id;
		budgie_applet_chooser_type_id = budgie_applet_chooser_get_type_once ();
		g_once_init_leave (&budgie_applet_chooser_type_id__once, budgie_applet_chooser_type_id);
	}
	return budgie_applet_chooser_type_id__once;
}

