/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.FreeCol;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.FreeColClientHolder;
import net.sf.freecol.client.gui.ChoiceItem;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.LoadingSavegameInfo;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.FreeColSavegameFile;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.FreeColServer;

public final class ConnectController
extends FreeColClientHolder {
    private static final Logger logger = Logger.getLogger(ConnectController.class.getName());
    private static final List<String> savedKeys = CollectionUtils.makeUnmodifiableList("owner", "singleplayer", "publicServer");

    public ConnectController(FreeColClient freeColClient) {
        super(freeColClient);
    }

    private StringTemplate connect(String user, String host, int port) {
        if (this.askServer().isConnected()) {
            return null;
        }
        StringTemplate err = null;
        try {
            if (this.askServer().connect("FreeColClient:" + user, host, port) != null) {
                this.getFreeColClient().changeClientState(false);
                logger.info("Connected to " + host + ":" + port + " as " + user);
            } else {
                logger.warning("Failed to connect to " + host + ":" + port + " as " + user);
                err = StringTemplate.template("server.couldNotConnect");
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception when connecting to " + host + ":" + port + " as " + user, ex);
            err = FreeCol.errorFromException(ex, "server.couldNotConnect");
        }
        return err;
    }

    public boolean requestLogout(Game.LogoutReason reason) {
        FreeColServer fcs;
        Unit active;
        FreeColClient fcc = this.getFreeColClient();
        Player player = fcc.getMyPlayer();
        if (!fcc.isLoggedIn()) {
            return true;
        }
        if (reason == Game.LogoutReason.RECONNECT && (active = this.getGUI().getActiveUnit()) != null && player.owns(active) && (fcs = fcc.getFreeColServer()) != null) {
            fcs.getGame().setInitialActiveUnitId(active.getId());
        }
        logger.info("Logout begin for client " + player.getName() + ": " + reason);
        return this.askServer().logout(player, reason);
    }

    public boolean logout(Game.LogoutReason reason) {
        FreeColClient fcc = this.getFreeColClient();
        Player player = fcc.getMyPlayer();
        logger.info("Logout end for client " + player.getName() + ": " + reason);
        this.askServer().disconnect();
        switch (reason) {
            case DEFEATED: 
            case QUIT: {
                fcc.logout(false);
                SwingUtilities.invokeLater(() -> this.mainTitle());
                break;
            }
            case LOGIN: {
                FreeCol.trace(logger, "logout(LOGIN) detected");
                fcc.logout(false);
                break;
            }
            case MAIN_TITLE: {
                fcc.logout(false);
                break;
            }
            case NEW_GAME: {
                fcc.logout(false);
                break;
            }
            default: {
                fcc.logout(false);
                SwingUtilities.invokeLater(() -> {
                    String name = player.getName();
                    try {
                        if (this.askServer().reconnect() != null && this.askServer().login(name, FreeCol.getVersion(), fcc.getSinglePlayer(), fcc.currentPlayerIsMyPlayer())) {
                            logger.info("Reconnected for client " + name);
                        } else {
                            logger.severe("Reconnect failed for client " + name);
                            fcc.askToQuit();
                        }
                    }
                    catch (IOException ioe) {
                        logger.log(Level.SEVERE, "Reconnect exception for client " + name, ioe);
                        fcc.quit();
                    }
                });
            }
        }
        return true;
    }

    public boolean requestLogin(String user, String host, int port) {
        FreeColClient fcc = this.getFreeColClient();
        if (fcc.isLoggedIn()) {
            return true;
        }
        fcc.setMapEditor(false);
        this.askServer().disconnect();
        StringTemplate err = this.connect(user, host, port);
        if (err == null) {
            logger.info("Login request for client " + FreeCol.getName());
            if (this.askServer().login(user, FreeCol.getVersion(), fcc.getSinglePlayer(), fcc.currentPlayerIsMyPlayer())) {
                return true;
            }
            err = StringTemplate.template("server.couldNotLogin");
        }
        this.getGUI().showErrorPanel(err);
        return false;
    }

    public void login(FreeColServer.ServerState state, Game game, String user, boolean single, boolean current) {
        FreeColClient fcc = this.getFreeColClient();
        Player player = game.getPlayerByName(user);
        if (player == null) {
            Object err = StringTemplate.template("server.noSuchPlayer").addName("%player%", user);
            this.getGUI().showErrorPanel((StringTemplate)err);
            logger.warning(Messages.message(err));
            return;
        }
        fcc.login(state == FreeColServer.ServerState.IN_GAME, game, player, single);
        if (current) {
            game.setCurrentPlayer(player);
        }
        logger.info("Login accepted for client " + player.getName() + " to " + (fcc.isInGame() ? "running" : (game.allPlayersReadyToLaunch() ? "ready" : "new")) + " " + (single ? "single" : "multi") + "-player game as " + user + "/" + player.getId());
        if (fcc.isInGame()) {
            fcc.restoreGUI(player);
            this.igc().nextModelMessage();
        } else if (this.getMap() != null && game.allPlayersReadyToLaunch()) {
            this.pgc().requestLaunch();
        } else {
            this.getGUI().showStartGamePanel(game, player, single);
        }
    }

    public boolean startSinglePlayerGame(Specification spec) {
        FreeColClient fcc = this.getFreeColClient();
        fcc.setMapEditor(false);
        if (!fcc.unblockServer(FreeCol.getServerPort())) {
            return false;
        }
        if (fcc.isLoggedIn()) {
            logger.warning("startSinglePlayer while logged in!");
            this.requestLogout(Game.LogoutReason.LOGIN);
        }
        List<FreeColModFile> mods = this.getClientOptions().getActiveMods();
        spec.loadMods(mods);
        Messages.loadActiveModMessageBundle(mods, FreeCol.getLocale());
        FreeColServer fcs = fcc.startServer(false, true, spec, null, -1);
        return fcs == null ? false : this.requestLogin(FreeCol.getName(), fcs.getHost(), fcs.getPort());
    }

    public boolean startSavedGame(File file) {
        int port;
        InetAddress address;
        String serverName;
        boolean singlePlayer;
        boolean show;
        boolean defaultPublicServer;
        boolean defaultSinglePlayer;
        FreeColClient fcc = this.getFreeColClient();
        GUI gui = this.getGUI();
        fcc.setMapEditor(false);
        ClientOptions options = this.getClientOptions();
        FreeColSavegameFile fis = null;
        try {
            fis = new FreeColSavegameFile(file);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.WARNING, "Can not find file: " + file.getName(), fnfe);
            gui.showErrorPanel(fnfe, FreeCol.badFile("error.couldNotFind", file));
            return false;
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Could not load file: " + file.getName(), ioe);
            gui.showErrorPanel(ioe, FreeCol.badFile("error.couldNotLoad", file));
            return false;
        }
        options.merge(fis);
        options.fixClientOptions();
        List<String> values = null;
        try {
            values = fis.peekAttributes(savedKeys);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not read from: " + file.getName(), ex);
            gui.showErrorPanel(ex, FreeCol.badFile("error.couldNotLoad", file));
            return false;
        }
        if (values != null && values.size() == savedKeys.size()) {
            String str = values.get(0);
            if (str != null) {
                FreeCol.setName(str);
            }
            defaultSinglePlayer = Boolean.parseBoolean(values.get(1));
            defaultPublicServer = Boolean.parseBoolean(values.get(2));
        } else {
            defaultSinglePlayer = true;
            defaultPublicServer = false;
        }
        boolean publicServer = defaultPublicServer;
        int sgo = options.getInteger("model.option.showSavegameSettings");
        boolean bl = show = sgo == 2 || !defaultSinglePlayer && sgo == 1;
        if (show) {
            LoadingSavegameInfo lsi = this.getGUI().showLoadingSavegameDialog(defaultPublicServer, defaultSinglePlayer);
            if (lsi == null) {
                return false;
            }
            singlePlayer = lsi.isSinglePlayer();
            serverName = lsi.getServerName();
            address = lsi.getAddress();
            port = lsi.getPort();
        } else {
            singlePlayer = defaultSinglePlayer;
            serverName = null;
            address = null;
            port = -1;
        }
        Messages.loadActiveModMessageBundle(options.getActiveMods(), FreeCol.getLocale());
        FreeColServer fcs = fcc.startServer(publicServer, singlePlayer, file, address, port, serverName);
        if (fcs == null) {
            return false;
        }
        fcs.getGame().getSpecification().loadMods(options.getActiveMods());
        fcc.setFreeColServer(fcs);
        fcc.setSinglePlayer(true);
        return this.requestLogin(FreeCol.getName(), fcs.getHost(), fcs.getPort());
    }

    public boolean startMultiplayerGame(Specification specification, boolean publicServer, InetAddress address, int port) {
        FreeColServer fcs;
        FreeColClient fcc = this.getFreeColClient();
        fcc.setMapEditor(false);
        if (!fcc.unblockServer(port)) {
            return false;
        }
        if (fcc.isLoggedIn()) {
            logger.warning("startMultiPlayer while logged in!");
            this.requestLogout(Game.LogoutReason.LOGIN);
        }
        if ((fcs = fcc.startServer(publicServer, false, specification, address, port)) == null) {
            return false;
        }
        fcc.setFreeColServer(fcs);
        fcc.setSinglePlayer(false);
        return this.requestLogin(FreeCol.getName(), fcs.getHost(), fcs.getPort());
    }

    public boolean joinMultiplayerGame(String host, int port) {
        String name;
        StringTemplate err;
        FreeColClient fcc = this.getFreeColClient();
        fcc.setMapEditor(false);
        if (fcc.isLoggedIn()) {
            logger.warning("joinMultiPlayer while logged in!");
            this.requestLogout(Game.LogoutReason.LOGIN);
        }
        if ((err = this.connect(name = FreeCol.getName(), host, port)) != null) {
            this.getGUI().showErrorPanel(err);
            return false;
        }
        while (fcc.getServerState() == null) {
            Utils.delay(1000L, null);
        }
        this.askServer().disconnect();
        switch (fcc.getServerState()) {
            case PRE_GAME: 
            case LOAD_GAME: {
                break;
            }
            case IN_GAME: {
                List<String> names = fcc.getVacantPlayerNames();
                if (names.isEmpty()) {
                    return false;
                }
                if (names.contains(name)) break;
                StringTemplate tmpl = StringTemplate.template("client.choicePlayer");
                String choice = (String)this.getGUI().getChoice(tmpl, "cancel", CollectionUtils.transform(names, CollectionUtils.alwaysTrue(), n -> new ChoiceItem<String>(Messages.message(StringTemplate.template("countryName").add("%nation%", Messages.nameKey(n))), (String)n)));
                if (choice == null) {
                    return false;
                }
                name = Messages.getRulerName(choice);
                break;
            }
            default: {
                this.getGUI().showErrorPanel(StringTemplate.template("client.ending"));
                return false;
            }
        }
        return this.requestLogin(name, host, port);
    }

    public void mainTitle() {
        FreeColClient fcc = this.getFreeColClient();
        if ((fcc.isLoggedIn() || fcc.isMapEditor()) && !this.getGUI().confirmStopGame()) {
            return;
        }
        if (fcc.isMapEditor()) {
            fcc.setMapEditor(false);
        }
        this.getGUI().showMainTitle();
        if (fcc.isLoggedIn()) {
            this.requestLogout(Game.LogoutReason.MAIN_TITLE);
        }
        fcc.stopServer();
    }

    public void newGame() {
        FreeColClient fcc = this.getFreeColClient();
        if (fcc.isLoggedIn() && !this.getGUI().confirmStopGame()) {
            return;
        }
        if (fcc.isMapEditor()) {
            fcc.getMapEditorController().newMap();
            return;
        }
        this.getGUI().removeInGameComponents();
        this.getGUI().showNewPanel(null);
        if (fcc.isLoggedIn()) {
            this.requestLogout(Game.LogoutReason.NEW_GAME);
        }
        fcc.stopServer();
    }
}

