/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.io.File;
import java.util.logging.Logger;
import javax.sound.sampled.Mixer;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.option.AudioMixerOption;
import net.sf.freecol.common.option.PercentageOption;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.sound.SoundPlayer;

public class SoundController {
    private static final Logger logger = Logger.getLogger(SoundController.class.getName());
    private SoundPlayer soundPlayer;

    public SoundController(FreeColClient freeColClient, boolean sound) {
        ClientOptions opts = freeColClient.getClientOptions();
        this.soundPlayer = null;
        if (sound) {
            AudioMixerOption amo = null;
            try {
                amo = opts.getOption("model.option.audioMixer", AudioMixerOption.class);
            }
            catch (Exception ex) {
                logger.warning(ex.getMessage());
            }
            PercentageOption vo = null;
            try {
                vo = opts.getOption("model.option.audioVolume", PercentageOption.class);
            }
            catch (Exception ex) {
                logger.warning(ex.getMessage());
            }
            if (amo == null || vo == null) {
                return;
            }
            logger.info("Create sound player with " + amo + "/" + vo);
            this.soundPlayer = new SoundPlayer(amo, vo);
        }
    }

    public boolean canPlaySound() {
        return this.soundPlayer != null && this.soundPlayer.getMixer() != null;
    }

    public void playSound(String sound) {
        if (!this.canPlaySound()) {
            return;
        }
        this.soundPlayer.stop();
        if (sound == null) {
            return;
        }
        File file = ResourceManager.getAudio(sound);
        if (file == null) {
            return;
        }
        boolean playing = this.soundPlayer.playOnce(file);
        logger.finest((playing ? "Queued" : "Fail on") + " sound: " + sound);
    }

    public String getSoundMixerLabelText() {
        Mixer mixer;
        String text = this.soundPlayer == null ? Messages.message("nothing") : ((mixer = this.soundPlayer.getMixer()) == null ? Messages.message("none") : mixer.getMixerInfo().getName());
        return Messages.message("current") + ":  " + text;
    }
}

