/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.images.BeachTileAnimationImageCreator;
import net.sf.freecol.common.io.sza.SimpleZippedAnimation;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.LostCityRumour;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Resource;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.SettlementType;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementStyle;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.resources.ImageCache;
import net.sf.freecol.common.resources.ImageResource;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.resources.StringResource;
import net.sf.freecol.common.resources.Video;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;
import net.sf.freecol.common.util.StringUtils;

public final class ImageLibrary {
    private static final Logger logger = Logger.getLogger(ImageLibrary.class.getName());
    public static final Dimension ICON_SIZE = new Dimension(32, 32);
    public static final Dimension BUILDING_SIZE = new Dimension(128, 96);
    public static final Dimension TILE_SIZE = new Dimension(128, 64);
    public static final Dimension TILE_OVERLAY_SIZE = new Dimension(128, 96);
    public static final Dimension TILE_FOREST_SIZE = new Dimension(128, 84);
    public static final float TINY_SCALE = 0.25f;
    public static final float SMALLER_SCALE = 0.5f;
    public static final float SMALL_SCALE = 0.75f;
    public static final float NORMAL_SCALE = 1.0f;
    public static final float MIN_SCALE = 0.25f;
    public static final float MAX_SCALE = 4.0f;
    public static final float SCALE_STEP = 0.25f;
    public static final String DELETE = "image.miscicon.delete";
    public static final String PLOWED = "image.tile.model.improvement.plow";
    public static final String UNIT_SELECT = "image.tile.unitSelect";
    public static final String TILE_TAKEN = "image.tile.tileTaken";
    public static final String TILE_OWNED_BY_INDIANS = "image.tileitem.nativeLand";
    public static final String LOST_CITY_RUMOUR = "image.tileitem.lostCityRumour";
    public static final String DARKNESS = "image.halo.dark";
    public static final String ICON_LOCK = "image.icon.lock";
    public static final String ICON_COIN = "image.icon.coin";
    public static final String BELLS = "image.icon.model.goods.bells";
    private static String RIVER_STYLE_PREFIX = "image.tile.model.improvement.river.s";
    private static final List<String> buttonKeys = CollectionUtils.makeUnmodifiableList("image.miscicon.button.normal.", "image.miscicon.button.highlighted.", "image.miscicon.button.pressed.", "image.miscicon.button.disabled.");
    private float scaleFactor;
    private Dimension tileSize;
    private Dimension tileOverlaySize;
    private Dimension tileForestSize;
    private final ImageCache imageCache;
    private Map<String, BufferedImage> stringImageCache;

    public ImageLibrary(ImageCache imageCache) {
        this(1.0f, imageCache);
    }

    public ImageLibrary(float scaleFactor, ImageCache imageCache) {
        this.changeScaleFactor(scaleFactor);
        this.imageCache = imageCache;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void changeScaleFactor(float scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.tileSize = this.scale(TILE_SIZE);
        this.tileOverlaySize = this.scale(TILE_OVERLAY_SIZE);
        this.tileForestSize = this.scale(TILE_FOREST_SIZE);
        this.stringImageCache = new HashMap<String, BufferedImage>();
    }

    public int scaleInt(int n) {
        return (int)((float)n * this.scaleFactor);
    }

    public Dimension scale(Dimension size) {
        return ImageLibrary.scaleDimension(size, this.scaleFactor);
    }

    public Dimension scale(Dimension size, float extraFactor) {
        return ImageLibrary.scaleDimension(size, this.scaleFactor * extraFactor);
    }

    public static Dimension scaleDimension(Dimension size, float scaleFactor) {
        return new Dimension(Math.round((float)size.width * scaleFactor), Math.round((float)size.height * scaleFactor));
    }

    public Dimension getTileSize() {
        return this.tileSize;
    }

    public Dimension getForestedTileSize() {
        return this.tileForestSize;
    }

    private static int variationSeedUsing(int x, int y) {
        return x * 6841 + y * 7919;
    }

    public static SimpleZippedAnimation getSZA(String key, float scale) {
        return ResourceManager.getSZAResource(key, false) == null ? null : ResourceManager.getSZA(key, scale);
    }

    public static Color makeForegroundColor(Color background) {
        return background == null || (double)background.getRed() * 0.3 + (double)background.getGreen() * 0.59 + (double)background.getBlue() * 0.11 >= 126.0 ? Color.BLACK : Color.WHITE;
    }

    private static Color makeStringBorderColor(Color color) {
        return (double)color.getRed() * 0.3 + (double)color.getGreen() * 0.59 + (double)color.getBlue() * 0.11 < 10.0 ? Color.WHITE : Color.BLACK;
    }

    public static Color getColor(String key) {
        return ImageLibrary.getColor(key, null);
    }

    public static Color getColor(String key, Color replacement) {
        return ResourceManager.getColor(key, replacement);
    }

    public static Color getGoodsColor(GoodsType goodsType, int amount, Location location) {
        String key = !goodsType.limitIgnored() && location instanceof Colony && ((Colony)location).getWarehouseCapacity() < amount ? "color.foreground.GoodsLabel.capacityExceeded" : (location instanceof Colony && goodsType.isStorable() && ((Colony)location).getExportData(goodsType).getExported() ? "color.foreground.GoodsLabel.exported" : (amount == 0 ? "color.foreground.GoodsLabel.zeroAmount" : (amount < 0 ? "color.foreground.GoodsLabel.negativeAmount" : "color.foreground.GoodsLabel.positiveAmount")));
        return ImageLibrary.getColor(key, Color.BLACK);
    }

    public static Color getMinimapBackgroundColor() {
        return ImageLibrary.getColor("color.background.MiniMap");
    }

    public static Color getMinimapBorderColor() {
        return ImageLibrary.getColor("color.border.MiniMap");
    }

    public static Color getMinimapEconomicColor(TileType type) {
        String key = "color.economic.MiniMap." + type.getId();
        return ImageLibrary.getColor(key);
    }

    public static Color getMinimapPoliticsColor(TileType type) {
        String key = "color.politics.MiniMap." + type.getId();
        return ImageLibrary.getColor(key);
    }

    public static Color getRoadColor() {
        return ImageLibrary.getColor("color.map.road");
    }

    public Font getScaledFont(String spec, String text) {
        return FontLibrary.getScaledFont(spec, this.scaleFactor, text);
    }

    public static BufferedImage getUnscaledImage(String key) {
        return ResourceManager.getImage(key);
    }

    public BufferedImage getScaledImage(String key) {
        return this.imageCache.getScaledImage(key, this.scaleFactor, false);
    }

    public BufferedImage getSizedImage(String key, Dimension size) {
        return this.imageCache.getSizedImage(key, size, false);
    }

    public static BufferedImage getButtonBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColButton");
    }

    public List<BufferedImage> getButtonImages(String key) {
        ArrayList<BufferedImage> ret = new ArrayList<BufferedImage>();
        for (String base : buttonKeys) {
            String k = base + key;
            BufferedImage image = this.imageCache.getScaledImage(k, this.scaleFactor, false);
            if (image == null) continue;
            ret.add(image);
        }
        return ret;
    }

    public static BufferedImage getBrightPanelBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColBrightPanel");
    }

    public static BufferedImage getCanvasBackgroundImage() {
        String key = "image.flavor.Canvas.map";
        return ResourceManager.getImageResource("image.flavor.Canvas.map", false) == null ? null : ImageLibrary.getUnscaledImage("image.flavor.Canvas.map");
    }

    public BufferedImage getColopediaCellImage(boolean expanded) {
        String key = "image.icon.Colopedia." + (expanded ? "open" : "closed") + "Section";
        return this.getScaledImage(key);
    }

    public BufferedImage getColopediaConceptImage() {
        return this.getScaledImage("image.icon.Colopedia.idea");
    }

    public static BufferedImage getColorCellRendererBackground() {
        return ImageLibrary.getUnscaledImage("image.background.ColorCellRenderer");
    }

    public JLabel getCompassRose() {
        return new JLabel(new ImageIcon(this.getScaledImage("image.skin.compass")));
    }

    public static Cursor getCursor() {
        String key = "image.icon.cursor.go";
        if (ResourceManager.getImageResource(key, false) != null) {
            BufferedImage im = ImageLibrary.getUnscaledImage(key);
            return Toolkit.getDefaultToolkit().createCustomCursor(im, new Point(((Image)im).getWidth(null) / 2, ((Image)im).getHeight(null) / 2), "go");
        }
        return Cursor.getPredefinedCursor(12);
    }

    public BufferedImage getFoundingFatherImage(FoundingFather father, boolean grayscale) {
        String key = "image.flavor." + father.getId();
        return this.imageCache.getScaledImage(key, this.scaleFactor, grayscale);
    }

    public BufferedImage getInformationPanelSkin(Player player) {
        String key = this.determineInformationPanelSkinKey(player);
        return this.getScaledImage(key);
    }

    private String determineInformationPanelSkinKey(Player player) {
        String key;
        String string = player == null ? "image.skin.InformationPanel" : (key = player.isRebel() ? "image.skin.InformationPanel.rebel" : "image.skin.InformationPanel." + player.getNationResourceKey());
        if (ResourceManager.getImageResource(key, false) == null) {
            key = "image.skin.InformationPanel";
        }
        return key;
    }

    public int getInformationPanelSkinTopInset(Player player) {
        String key = this.determineInformationPanelSkinKey(player) + ".insets.top";
        StringResource s = ResourceManager.getStringResource(key, false);
        return s != null ? Integer.parseInt(s.getString()) : 0;
    }

    public BufferedImage getLCRImage(Dimension size) {
        return this.imageCache.getSizedImage(LOST_CITY_RUMOUR, size, false);
    }

    public BufferedImage getLibertyImage() {
        return this.imageCache.getSizedImage(BELLS, this.scale(ICON_SIZE), false);
    }

    public static BufferedImage getListBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColList");
    }

    public JLabel getLockLabel() {
        BufferedImage img = this.imageCache.getScaledImage(ICON_LOCK, this.scaleFactor * 0.5f, false);
        return new JLabel(new ImageIcon(img));
    }

    public static BufferedImage getMeetingImage(Player meet) {
        String base = "image.flavor.event.meeting.";
        Object key = "image.flavor.event.meeting." + meet.getNationResourceKey();
        if (ResourceManager.getImageResource((String)key, false) == null) {
            key = "image.flavor.event.meeting.natives";
        }
        return ImageLibrary.getUnscaledImage((String)key);
    }

    public static BufferedImage getMenuBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColMenuBar");
    }

    public static BufferedImage getMiniMapBackground() {
        return ImageLibrary.getUnscaledImage("image.background.MiniMap");
    }

    public BufferedImage getMiniMapSkin() {
        String key = "image.skin.MiniMap";
        return this.imageCache.getScaledImage("image.skin.MiniMap", this.scaleFactor, false);
    }

    private BufferedImage getObjectImageInternal(FreeColObject display, Dimension size) {
        BufferedImage image;
        FreeColObject derived = display.getDisplayObject();
        BufferedImage bufferedImage = derived instanceof BuildingType ? this.getBuildingTypeImage((BuildingType)derived, size) : (derived instanceof GoodsType ? this.getGoodsTypeImage((GoodsType)derived, size) : (derived instanceof LostCityRumour ? this.getLCRImage(size) : (derived instanceof Nation ? this.getNationImage((Nation)derived, size) : (derived instanceof ResourceType ? this.getResourceTypeImage((ResourceType)derived, size, false) : (derived instanceof Settlement ? this.getSettlementImage((Settlement)derived, size) : (derived instanceof TileType ? this.getTerrainImage((TileType)derived, 0, 0, size) : (image = derived instanceof UnitType ? this.getUnitTypeImage((UnitType)derived, size) : null)))))));
        if (image == null) {
            logger.warning("Could not find image for " + display);
            return null;
        }
        return image;
    }

    public BufferedImage getObjectImage(FreeColObject display) {
        return this.getObjectImageInternal(display, this.scale(ICON_SIZE));
    }

    public BufferedImage getObjectImage(FreeColObject display, Dimension size) {
        return this.getObjectImageInternal(display, size);
    }

    public ImageIcon getObjectImageIcon(FreeColObject display) {
        if (display == null) {
            return null;
        }
        BufferedImage image = this.getObjectImage(display, this.scale(ICON_SIZE, this.scaleFactor * 2.0f));
        return image == null ? null : new ImageIcon(image);
    }

    public static BufferedImage getOptionPaneBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColOptionPane");
    }

    public static BufferedImage getPanelBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColPanel");
    }

    public static BufferedImage getPanelBackground(Class<?> clazz) {
        while (clazz != null) {
            ImageResource ir = ResourceManager.getImageResource("image.background." + clazz.getSimpleName(), false);
            if (ir != null) {
                return ir.getImage();
            }
            if ((clazz = clazz.getSuperclass()).getName().startsWith("net.sf.freecol")) continue;
            clazz = null;
        }
        return ImageLibrary.getPanelBackground();
    }

    public BufferedImage getPlaceholderImage() {
        return this.imageCache.getSizedImage("image.unit.placeholder", ICON_SIZE, false);
    }

    public static BufferedImage getPopupMenuBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColPopupMenu");
    }

    public static BufferedImage getProgressBarBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColProgressBar");
    }

    public static BufferedImage getTextAreaBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColTextArea");
    }

    public static BufferedImage getTextFieldBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColTextField");
    }

    public static BufferedImage getToolTipBackground() {
        return ImageLibrary.getUnscaledImage("image.background.FreeColToolTip");
    }

    private static String getBuildingTypeKey(BuildingType buildingType) {
        return "image.buildingicon." + buildingType.getId();
    }

    public BufferedImage getBuildableTypeImage(BuildableType buildable, Dimension size) {
        return buildable instanceof BuildingType ? this.getBuildingTypeImage((BuildingType)buildable, size) : this.getUnitTypeImage((UnitType)buildable, size);
    }

    public BufferedImage getSmallBuildableTypeImage(BuildableType buildable, Player player) {
        float scale = this.scaleFactor * 0.75f;
        return buildable instanceof BuildingType ? this.getScaledBuildingTypeImage((BuildingType)buildable, player, scale) : this.getUnitTypeImage((UnitType)buildable, scale);
    }

    public BufferedImage getBuildingTypeImage(BuildingType buildingType, Dimension size) {
        String key = ImageLibrary.getBuildingTypeKey(buildingType);
        return this.imageCache.getSizedImage(key, size, false);
    }

    public BufferedImage getScaledBuildingTypeImage(BuildingType buildingType, float scale) {
        String key = ImageLibrary.getBuildingTypeKey(buildingType);
        return this.imageCache.getScaledImage(key, scale, false);
    }

    private BufferedImage getScaledBuildingTypeImage(BuildingType buildingType, Player player, float scale) {
        Object key = ImageLibrary.getBuildingTypeKey(buildingType);
        String extraKey = (String)key + "." + player.getNationResourceKey();
        if (ResourceManager.getImageResource(extraKey, false) != null) {
            key = extraKey;
        }
        return this.imageCache.getScaledImage((String)key, scale, false);
    }

    public BufferedImage getScaledBuildingImage(Building building) {
        return this.getScaledBuildingTypeImage(building.getType(), building.getOwner(), this.scaleFactor);
    }

    public BufferedImage getSmallBuildingImage(Building building) {
        return this.getScaledBuildingTypeImage(building.getType(), building.getOwner(), this.scaleFactor * 0.75f);
    }

    private static String getGoodsTypeKey(GoodsType gt) {
        return "image.icon." + gt.getId();
    }

    public BufferedImage getGoodsTypeImage(GoodsType gt, Dimension size) {
        return this.imageCache.getSizedImage(ImageLibrary.getGoodsTypeKey(gt), size, false);
    }

    public BufferedImage getScaledGoodsTypeImage(GoodsType gt) {
        return this.getGoodsTypeImage(gt, this.scale(ICON_SIZE));
    }

    public BufferedImage getSmallGoodsTypeImage(GoodsType gt) {
        return this.getGoodsTypeImage(gt, this.scale(ICON_SIZE, 0.75f));
    }

    public BufferedImage getSmallerGoodsTypeImage(GoodsType gt) {
        return this.getGoodsTypeImage(gt, this.scale(ICON_SIZE, 0.5f));
    }

    private static String getMercenaryLeaderKey(int n) {
        return "image.flavor.model.mercenaries." + n;
    }

    private static String getMonarchKey(String nationId) {
        return "image.flavor.monarch." + nationId;
    }

    public static BufferedImage getMonarchImage(Nation nation) {
        String key = ImageLibrary.getMonarchKey(nation.getId());
        return ImageLibrary.getUnscaledImage(key);
    }

    public static BufferedImage getMonarchImage(String monarchKey) {
        String key;
        try {
            int n = Integer.parseInt(monarchKey);
            key = ImageLibrary.getMercenaryLeaderKey(n);
        }
        catch (Exception e) {
            key = ImageLibrary.getMonarchKey(monarchKey);
        }
        return ImageLibrary.getUnscaledImage(key);
    }

    public static String getNationKey(Nation nation) {
        return "image.miscicon." + nation.getId();
    }

    public BufferedImage getNationImage(Nation nation, Dimension size) {
        return this.imageCache.getSizedImage(ImageLibrary.getNationKey(nation), size, false);
    }

    public BufferedImage getNationImage(Nation nation, float scale) {
        return this.imageCache.getScaledImage(ImageLibrary.getNationKey(nation), scale, false);
    }

    public BufferedImage getScaledNationImage(Nation nation) {
        return this.getNationImage(nation, this.scaleFactor);
    }

    public BufferedImage getSmallNationImage(Nation nation) {
        return this.getNationImage(nation, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallerNationImage(Nation nation) {
        return this.getNationImage(nation, this.scaleFactor * 0.5f);
    }

    public BufferedImage getUnscaledSmallerNationImage(Nation nation) {
        return this.getNationImage(nation, 0.5f);
    }

    public static BufferedImage getPathImage(PathType pt) {
        return pt == null ? null : ImageLibrary.getUnscaledImage(pt.getImageKey());
    }

    public static BufferedImage getPathImage(Unit u) {
        return u == null ? null : ImageLibrary.getPathImage(PathType.getPathType(u));
    }

    private static BufferedImage getPathNextTurnImage(PathType pt) {
        return pt == null ? null : ImageLibrary.getUnscaledImage(pt.getNextTurnImageKey());
    }

    public static BufferedImage getPathNextTurnImage(Unit u) {
        return u == null ? null : ImageLibrary.getPathNextTurnImage(PathType.getPathType(u));
    }

    public BufferedImage getBeachCornerImage(int index, int x, int y) {
        String key = "image.tile.model.tile.beach.corner" + index;
        return this.imageCache.getSizedImage(key, this.tileSize, false, ImageLibrary.variationSeedUsing(x, y));
    }

    public BufferedImage getBeachEdgeImage(int index, int x, int y) {
        String key = "image.tile.model.tile.beach.edge" + index;
        return this.imageCache.getSizedImage(key, this.tileSize, false, ImageLibrary.variationSeedUsing(x, y));
    }

    private ImageResource getBeachCenterImageResource() {
        String key = "image.tile.model.tile.beach";
        return ImageCache.getImageResource("image.tile.model.tile.beach");
    }

    public BufferedImage getBaseTileTransitionImage(Tile tile, Direction direction) {
        Tile borderingTile = tile.getNeighbourOrNull(direction);
        if (borderingTile == null || !borderingTile.isExplored() || !tile.isExplored() || tile.getType() == borderingTile.getType()) {
            return null;
        }
        boolean notABeachTransition = borderingTile.isLand() || !borderingTile.isLand() && !tile.isLand();
        ImageResource terrainImageResource = notABeachTransition ? ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(borderingTile.getType())) : this.getBeachCenterImageResource();
        if (terrainImageResource == null) {
            return null;
        }
        ImageResource tileImageResource = ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(tile.getType()));
        if (tileImageResource == null || terrainImageResource.getPrimaryKey().equals(tileImageResource.getPrimaryKey())) {
            return null;
        }
        String transitionKey = terrainImageResource.getPrimaryKey() + "$gen";
        BufferedImage transitionImage = this.imageCache.getCachedImageOrGenerate(transitionKey, this.tileSize, false, direction.ordinal(), () -> {
            BufferedImage terrainImage = this.imageCache.getCachedImage(terrainImageResource, this.tileSize, false, 0);
            return ImageUtils.imageWithAlphaFromMask(terrainImage, this.getTerrainMask(direction));
        });
        return transitionImage;
    }

    public BufferedImage getBorderImage(TileType type, Direction direction, int x, int y) {
        String key = "image.tile." + (type == null ? "model.tile.unexplored" : type.getId()) + ".border." + direction;
        return this.imageCache.getSizedImage(key, this.tileSize, false, ImageLibrary.variationSeedUsing(x, y));
    }

    private BufferedImage getForestImageInternal(TileType type, TileImprovementStyle riverStyle, Dimension size) {
        String key;
        if (riverStyle != null) {
            String mask = riverStyle.getMask();
            key = "image.tileforest." + type.getId() + ".s" + ("0000".equals(mask) ? "0100" : mask);
            if (ResourceManager.getImageResource(key, false) != null) {
                return this.imageCache.getSizedImage(key, size, false);
            }
        }
        key = "image.tileforest." + type.getId();
        return this.imageCache.getSizedImage(key, size, false);
    }

    public BufferedImage getForestImage(TileType type, Dimension size) {
        return this.getForestImageInternal(type, null, size);
    }

    public BufferedImage getScaledForestImage(TileType type) {
        return this.getForestImageInternal(type, null, this.tileForestSize);
    }

    public BufferedImage getScaledForestImage(TileType type, TileImprovementStyle riverStyle) {
        return this.getForestImageInternal(type, riverStyle, this.tileForestSize);
    }

    private BufferedImage getOverlayImageInternal(TileType type, int seed, Dimension size) {
        String key = "image.tileoverlay." + type.getId();
        ImageResource ir = ResourceManager.getImageResource(key, false);
        if (ir == null) {
            return null;
        }
        return this.imageCache.getSizedImage(key, size, false, seed);
    }

    private BufferedImage getAboveTileImageInternal(TileType type, int seed, Dimension size) {
        String key = "image.abovetile." + type.getId();
        ImageResource ir = ResourceManager.getImageResource(key, false);
        if (ir == null) {
            return null;
        }
        return this.imageCache.getSizedImage(key, size, false, seed);
    }

    public BufferedImage getScaledOverlayImage(Tile tile) {
        return this.getOverlayImageInternal(tile.getType(), ImageLibrary.variationSeedUsing(tile.getX(), tile.getY()), this.tileOverlaySize);
    }

    public BufferedImage getScaledAboveTileImage(Tile tile) {
        return this.getAboveTileImageInternal(tile.getType(), ImageLibrary.variationSeedUsing(tile.getX(), tile.getY()), this.tileOverlaySize);
    }

    public BufferedImage getSizedOverlayImage(TileType type, Dimension size) {
        return this.getOverlayImageInternal(type, type.getId().hashCode(), size);
    }

    private static String getResourceTypeKey(ResourceType rt) {
        return "image.tileitem." + rt.getId();
    }

    public BufferedImage getResourceTypeImage(ResourceType rt, Dimension size, boolean grayscale) {
        return this.imageCache.getSizedImage(ImageLibrary.getResourceTypeKey(rt), size, grayscale);
    }

    private BufferedImage getResourceTypeImage(ResourceType rt, float scale, boolean grayscale) {
        return this.imageCache.getScaledImage(ImageLibrary.getResourceTypeKey(rt), scale, grayscale);
    }

    public BufferedImage getScaledResourceTypeImage(ResourceType rt) {
        return this.getResourceTypeImage(rt, this.scaleFactor, false);
    }

    public BufferedImage getSmallResourceTypeImage(ResourceType rt) {
        return this.getResourceTypeImage(rt, this.scaleFactor * 0.75f, false);
    }

    public BufferedImage getScaledResourceImage(Resource resource) {
        return this.getResourceTypeImage(resource.getType(), this.scaleFactor, false);
    }

    private static String getRiverStyleKey(String style) {
        return RIVER_STYLE_PREFIX + style;
    }

    private BufferedImage getRiverImageInternal(String style, Dimension size) {
        return this.imageCache.getSizedImage(ImageLibrary.getRiverStyleKey(style), size, false);
    }

    public BufferedImage getRiverImage(String style, Dimension size) {
        return this.getRiverImageInternal(style, size);
    }

    private BufferedImage getScaledRiverImage(String style, float scale) {
        return this.getRiverImageInternal(style, ImageLibrary.scaleDimension(this.tileSize, scale));
    }

    public BufferedImage getScaledRiverImage(TileImprovementStyle style) {
        return this.getRiverImageInternal(style.getString(), this.tileSize);
    }

    public BufferedImage getScaledRiverImage(String style) {
        return this.getScaledRiverImage(style, this.scaleFactor);
    }

    public BufferedImage getSmallerRiverImage(String style) {
        return this.getScaledRiverImage(style, this.scaleFactor * 0.5f);
    }

    public BufferedImage getRiverMouthImage(Direction direction, int magnitude, int x, int y) {
        String key = "image.tile.model.tile.delta." + direction + (magnitude == 1 ? ".small" : ".large");
        return this.imageCache.getSizedImage(key, this.tileSize, false);
    }

    public static List<String> getRiverStyleKeys(boolean all) {
        return ResourceManager.getImageKeys(RIVER_STYLE_PREFIX).stream().map(key -> key.substring(RIVER_STYLE_PREFIX.length())).filter(style -> (all || !style.contains("1")) && !"0000".equals(style)).sorted().collect(Collectors.toList());
    }

    private static String getSettlementTypeKey(SettlementType settlementType) {
        return "image.tileitem." + settlementType.getId();
    }

    private BufferedImage getSettlementTypeImage(SettlementType settlementType, float scale) {
        String key = ImageLibrary.getSettlementTypeKey(settlementType);
        return this.imageCache.getScaledImage(key, scale, false);
    }

    public BufferedImage getSettlementTypeImage(SettlementType settlementType, Dimension size) {
        String key = ImageLibrary.getSettlementTypeKey(settlementType);
        return this.imageCache.getSizedImage(key, size, false);
    }

    public BufferedImage getScaledSettlementTypeImage(SettlementType settlementType) {
        return this.getSettlementTypeImage(settlementType, this.scaleFactor);
    }

    public BufferedImage getSmallerSettlementTypeImage(SettlementType settlementType) {
        return this.getSettlementTypeImage(settlementType, this.scaleFactor * 0.5f);
    }

    public static String getSettlementKey(Settlement settlement) {
        IndianSettlement is;
        Object key = ImageLibrary.getSettlementTypeKey(settlement.getType());
        if (settlement instanceof Colony) {
            Colony colony = (Colony)settlement;
            if (colony.isUndead()) {
                key = (String)key + ".undead";
            } else {
                int count = colony.getApparentUnitCount();
                key = (String)key + (count <= 3 ? ".small" : (count <= 7 ? ".medium" : ".large"));
                String stockade = colony.getStockadeKey();
                if (stockade != null) {
                    key = (String)key + "." + stockade;
                }
            }
        } else if (settlement instanceof IndianSettlement && (is = (IndianSettlement)settlement).hasMissionary()) {
            key = (String)key + ".mission";
        }
        return key;
    }

    public BufferedImage getSettlementImage(Settlement settlement, float scale) {
        return this.imageCache.getScaledImage(ImageLibrary.getSettlementKey(settlement), scale, false);
    }

    public BufferedImage getSettlementImage(Settlement settlement, Dimension size) {
        return this.imageCache.getSizedImage(ImageLibrary.getSettlementKey(settlement), size, false);
    }

    public BufferedImage getScaledSettlementImage(Settlement settlement) {
        return this.getSettlementImage(settlement, this.scaleFactor);
    }

    public BufferedImage getSmallSettlementImage(Settlement settlement) {
        return this.getSettlementImage(settlement, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallerSettlementImage(Settlement settlement) {
        return this.getSettlementImage(settlement, this.scaleFactor * 0.5f);
    }

    public static String getTerrainImageKey(TileType type) {
        return "image.tile." + (type == null ? "model.tile.unexplored" : type.getId()) + ".center";
    }

    private BufferedImage getTerrainImageInternal(TileType type, int x, int y, Dimension size) {
        return this.imageCache.getSizedImage(ImageLibrary.getTerrainImageKey(type), size, false, ImageLibrary.variationSeedUsing(x, y));
    }

    public BufferedImage getTerrainMask(Direction direction) {
        String key = direction != null ? "image.mask." + direction.toString().toLowerCase() : "image.mask";
        return this.imageCache.getSizedImage(key, this.tileSize, false);
    }

    public BufferedImage getTerrainImage(TileType type, int x, int y, Dimension size) {
        return this.getTerrainImageInternal(type, x, y, size);
    }

    public BufferedImage getScaledTerrainImage(TileType type, int x, int y) {
        return this.getTerrainImageInternal(type, x, y, this.tileSize);
    }

    public BufferedImage getAnimatedScaledTerrainImage(TileType type, long ticks) {
        ImageResource imageResource = ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(type));
        if (imageResource == null) {
            return null;
        }
        return this.imageCache.getCachedImage(imageResource, this.tileSize, false, imageResource.getVariationNumberForTick(ticks));
    }

    public BufferedImage getAnimatedScaledWaterAndBeachTerrainImage(TileType type, List<Direction> directionsWithLand, long ticks) {
        ImageResource beachCenterImageResource = this.getBeachCenterImageResource();
        if (beachCenterImageResource == null) {
            return null;
        }
        String beachVariationKey = this.determineDirectionCombinationKey(directionsWithLand);
        ImageResource oceanImageResource = ImageCache.getImageResource(ImageLibrary.getTerrainImageKey(type));
        int oceanVariationNumber = oceanImageResource.getVariationNumberForTick(ticks);
        String generatedKey = oceanImageResource.getPrimaryKey() + ".beach." + beachVariationKey + "$gen";
        BufferedImage result = this.imageCache.getCachedImageOrGenerate(generatedKey, this.tileSize, false, oceanVariationNumber, () -> {
            BufferedImage oceanImage = this.getAnimatedScaledTerrainImage(type, ticks);
            String oceanMaskKey = "image.mask.beach." + beachVariationKey;
            BufferedImage maskImage = this.imageCache.getSizedImage(oceanMaskKey, this.tileSize, false);
            return BeachTileAnimationImageCreator.generateImage(beachCenterImageResource.getImage(this.tileSize, false), oceanImage, oceanVariationNumber, maskImage, this.getTerrainMask(null));
        });
        return result;
    }

    private String determineDirectionCombinationKey(List<Direction> directions) {
        Optional<String> neighboursPre = directions.stream().filter(d -> Direction.longSides.contains(d)).map(d -> d.toString().toLowerCase()).sorted().reduce((a, b) -> a + "_" + b);
        String beachVariationKey = directions.stream().filter(d -> Direction.longSides.contains(d) || neighboursPre.isEmpty() || !((String)neighboursPre.get()).contains(d.toString().toLowerCase())).map(d -> d.toString().toLowerCase()).sorted().reduce((a, b) -> a + "_" + b).get();
        return beachVariationKey;
    }

    public BufferedImage getTileImprovementImage(String id) {
        String key = "image.tile." + id;
        return ResourceManager.getImageResource(key, false) == null ? null : this.imageCache.getSizedImage(key, this.tileSize, false);
    }

    public BufferedImage getTileImageWithOverlayAndForest(TileType type, Dimension size) {
        BufferedImage forestImage;
        int width = size.width > 0 ? size.width : (2 * ImageLibrary.TILE_SIZE.width * size.height + (ImageLibrary.TILE_OVERLAY_SIZE.height + 1)) / (2 * ImageLibrary.TILE_OVERLAY_SIZE.height);
        Dimension size2 = new Dimension(width, -1);
        BufferedImage terrainImage = this.getTerrainImage(type, 0, 0, size2);
        BufferedImage overlayImage = this.getSizedOverlayImage(type, size2);
        BufferedImage bufferedImage = forestImage = type.isForested() ? this.getForestImage(type, size2) : null;
        if (overlayImage == null && forestImage == null) {
            return terrainImage;
        }
        width = terrainImage.getWidth();
        int height = terrainImage.getHeight();
        if (overlayImage != null) {
            height = Math.max(height, overlayImage.getHeight());
        }
        if (forestImage != null) {
            height = Math.max(height, forestImage.getHeight());
        }
        BufferedImage compositeImage = new BufferedImage(width, height, 2);
        Graphics2D g = compositeImage.createGraphics();
        g.drawImage((Image)terrainImage, 0, height - terrainImage.getHeight(), null);
        if (overlayImage != null) {
            g.drawImage((Image)overlayImage, 0, height - overlayImage.getHeight(), null);
        }
        if (forestImage != null) {
            g.drawImage((Image)forestImage, 0, height - forestImage.getHeight(), null);
        }
        g.dispose();
        return compositeImage;
    }

    private static String getUnitTypeImageKey(UnitType unitType, Player owner, String roleId, boolean nativeEthnicity) {
        String extraKey;
        if (nativeEthnicity && unitType.hasAbility("model.ability.bornInIndianSettlement")) {
            nativeEthnicity = false;
        }
        String roleQual = Role.isDefaultRoleId(roleId) ? "" : "." + Role.getRoleIdSuffix(roleId);
        String key = "image.unit." + unitType.getId() + roleQual + (nativeEthnicity ? ".native" : "");
        if (nativeEthnicity && ResourceManager.getImageResource(key, false) == null) {
            key = "image.unit." + unitType.getId() + roleQual;
        }
        if (owner != null && ResourceManager.getImageResource(extraKey = key + "." + owner.getNationResourceKey(), false) != null) {
            key = extraKey;
        }
        return key;
    }

    private BufferedImage getUnitTypeImage(UnitType unitType, Player owner, String roleId, boolean nativeEthnicity, boolean grayscale, float scale) {
        String key = ImageLibrary.getUnitTypeImageKey(unitType, null, roleId, nativeEthnicity);
        return this.imageCache.getScaledImage(key, scale, grayscale);
    }

    private BufferedImage getUnitTypeImage(UnitType unitType, float scale) {
        return this.getUnitTypeImage(unitType, null, unitType.getDisplayRoleId(), false, false, scale);
    }

    private BufferedImage getUnitTypeImage(UnitType unitType, String roleId, boolean nativeEthnicity, Dimension size) {
        String key = ImageLibrary.getUnitTypeImageKey(unitType, null, roleId, nativeEthnicity);
        return this.imageCache.getSizedImage(key, size, false);
    }

    private BufferedImage getUnitTypeImage(UnitType unitType, Dimension size) {
        return this.getUnitTypeImage(unitType, unitType.getDisplayRoleId(), false, size);
    }

    public BufferedImage getScaledUnitTypeImage(UnitType unitType) {
        return this.getUnitTypeImage(unitType, null, unitType.getDisplayRoleId(), false, false, this.scaleFactor);
    }

    public BufferedImage getSmallUnitTypeImage(UnitType unitType, String roleId, boolean grayscale) {
        return this.getUnitTypeImage(unitType, null, roleId, false, grayscale, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallUnitTypeImage(UnitType unitType, boolean grayscale) {
        return this.getSmallUnitTypeImage(unitType, unitType.getDisplayRoleId(), grayscale);
    }

    public BufferedImage getSmallUnitTypeImage(UnitType unitType) {
        return this.getSmallUnitTypeImage(unitType, unitType.getDisplayRoleId(), false);
    }

    public BufferedImage getSmallerUnitTypeImage(UnitType unitType) {
        return this.getUnitTypeImage(unitType, null, unitType.getDisplayRoleId(), false, false, this.scaleFactor * 0.5f);
    }

    public BufferedImage getTinyUnitTypeImage(UnitType unitType, boolean grayscale) {
        return this.getUnitTypeImage(unitType, null, unitType.getDisplayRoleId(), false, grayscale, this.scaleFactor * 0.25f);
    }

    public BufferedImage getTinyUnitTypeImage(UnitType unitType) {
        return this.getTinyUnitTypeImage(unitType, false);
    }

    private BufferedImage getUnitImage(Unit unit, boolean grayscale, float scale) {
        return this.getUnitTypeImage(unit.getType(), unit.getOwner(), unit.getRole().getId(), unit.hasNativeEthnicity(), grayscale, scale);
    }

    public BufferedImage getScaledUnitImage(Unit unit, boolean grayscale) {
        return this.getUnitImage(unit, grayscale, this.scaleFactor);
    }

    public BufferedImage getScaledUnitImage(Unit unit) {
        return this.getScaledUnitImage(unit, false);
    }

    public BufferedImage getSmallUnitImage(Unit unit, boolean grayscale) {
        return this.getUnitImage(unit, grayscale, this.scaleFactor * 0.75f);
    }

    public BufferedImage getSmallUnitImage(Unit unit) {
        return this.getSmallUnitImage(unit, false);
    }

    public BufferedImage getSmallerUnitImage(Unit unit) {
        return this.getUnitImage(unit, false, this.scaleFactor * 0.5f);
    }

    public BufferedImage getTinyUnitImage(Unit unit) {
        return this.getUnitImage(unit, false, this.scaleFactor * 0.25f);
    }

    public BufferedImage getAlarmChip(Graphics2D g, IndianSettlement is, Player player) {
        if (player == null || !is.hasContacted(player)) {
            return null;
        }
        Color ownerColor = is.getOwner().getNationColor();
        Player enemy = is.getMostHated();
        Color enemyColor = enemy == null ? Nation.UNKNOWN_NATION_COLOR : enemy.getNationColor();
        int amount = 4;
        if (enemy == null) {
            amount = 0;
        } else if (player == enemy) {
            Tension alarm = is.getAlarm(enemy);
            int n = amount = alarm == null ? 4 : alarm.getLevel().ordinal();
            if (amount == 0) {
                amount = 1;
            }
        }
        Color foreground = ImageLibrary.makeForegroundColor(enemyColor);
        String text = ResourceManager.getString(is.worthScouting(player) ? "indianAlarmChip.contacted" : "indianAlarmChip.scouted");
        return this.createChip(g, text, Color.BLACK, ownerColor, (double)amount / 4.0, enemyColor, foreground, true);
    }

    public BufferedImage getIndianSettlementChip(Graphics2D g, IndianSettlement is) {
        String key = ResourceManager.getString("indianSettlementChip." + (is.getType().isCapital() ? "capital" : "normal"));
        Color background = is.getOwner().getNationColor();
        return this.createChip(g, key, Color.BLACK, background, 0.0, Color.BLACK, ImageLibrary.makeForegroundColor(background), true);
    }

    public BufferedImage getMissionChip(Graphics2D g, Player owner, boolean expert) {
        Color background = owner.getNationColor();
        String key = "color.foreground.mission." + (expert ? "expert" : "normal");
        Color foreground = ImageLibrary.getColor(key, expert ? Color.BLACK : Color.GRAY);
        return this.createChip(g, ResourceManager.getString("cross"), Color.BLACK, background, 0.0, Color.BLACK, foreground, true);
    }

    public BufferedImage getOccupationIndicatorChip(Graphics2D g, Unit unit, String text) {
        Color background = unit.getOwner().getNationColor();
        Color foreground = unit.getState() == Unit.UnitState.FORTIFIED ? Color.GRAY : ImageLibrary.makeForegroundColor(background);
        return this.createChip(g, text, Color.BLACK, background, 0.0, Color.BLACK, foreground, true);
    }

    private BufferedImage createChip(Graphics2D g, String text, Color border, Color background, double amount, Color fill, Color foreground, boolean filled) {
        Font font = this.getScaledFont("simple-bold-tiny", null);
        FontMetrics fm = g.getFontMetrics(font);
        int padding = this.scaleInt(6);
        BufferedImage bi = new BufferedImage(fm.stringWidth(text) + padding, fm.getMaxAscent() + fm.getMaxDescent() + padding, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setFont(font);
        int width = bi.getWidth();
        int height = bi.getHeight();
        g2.setColor(border);
        g2.fillRect(0, 0, width, height);
        g2.setColor(background);
        g2.fillRect(1, 1, width - 2, height - 2);
        if (!filled && amount > 0.0 && amount <= 1.0) {
            g2.setColor(fill);
            g2.fillRect(1, 1, width - 2, (int)((double)(height - 2) * amount));
        }
        g2.setColor(foreground);
        g2.drawString(text, padding / 2, fm.getMaxAscent() + padding / 2);
        g2.dispose();
        return bi;
    }

    public BufferedImage getStringImage(Graphics g, String text, Color color, Font font) {
        String key;
        BufferedImage img;
        if (color == null) {
            logger.warning("getStringImage(" + text + ") called with color null");
            color = Color.WHITE;
        }
        if ((img = this.stringImageCache.get(key = text + "." + font.getFontName().replace(' ', '-') + "." + Integer.toString(font.getSize()) + "." + Integer.toHexString(color.getRGB()))) != null) {
            return img;
        }
        img = this.createStringImage(text, color, font, g.getFontMetrics(font));
        this.stringImageCache.put(key, img);
        return img;
    }

    private BufferedImage createStringImage(String text, Color color, Font font, FontMetrics fm) {
        int dstRGB;
        int srcA;
        int srcRGB;
        int d;
        int width = fm.stringWidth(text) + 4;
        int height = fm.getMaxAscent() + fm.getMaxDescent();
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(ImageLibrary.makeStringBorderColor(color));
        g.setFont(font);
        g.drawString(text, 2, fm.getMaxAscent());
        int borderWidth = 1;
        int borderColor = ImageLibrary.makeStringBorderColor(color).getRGB();
        for (int biY = 0; biY < height; ++biY) {
            for (int biX = borderWidth; biX < width - borderWidth; ++biX) {
                int biXI = width - biX - 1;
                for (d = 1; d <= borderWidth; ++d) {
                    srcRGB = img.getRGB(biX, biY);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = img.getRGB(biX - d, biY);
                    if (dstRGB != borderColor && srcA > 0) {
                        img.setRGB(biX, biY, borderColor);
                        img.setRGB(biX - d, biY, srcRGB);
                    }
                    srcRGB = img.getRGB(biXI, biY);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = img.getRGB(biXI + d, biY);
                    if (dstRGB == borderColor || srcA <= 0) continue;
                    img.setRGB(biXI, biY, borderColor);
                    img.setRGB(biXI + d, biY, srcRGB);
                }
            }
        }
        for (int biX = 0; biX < width; ++biX) {
            for (int biY = borderWidth; biY < height - borderWidth; ++biY) {
                int biYI = height - biY - 1;
                for (d = 1; d <= borderWidth; ++d) {
                    srcRGB = img.getRGB(biX, biY);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = img.getRGB(biX, biY - d);
                    if (dstRGB != borderColor && srcA > 0) {
                        img.setRGB(biX, biY, borderColor);
                        img.setRGB(biX, biY - d, srcRGB);
                    }
                    srcRGB = img.getRGB(biX, biYI);
                    srcA = srcRGB >> 24 & 0xFF;
                    dstRGB = img.getRGB(biX, biYI + d);
                    if (dstRGB == borderColor || srcA <= 0) continue;
                    img.setRGB(biX, biYI, borderColor);
                    img.setRGB(biX, biYI + d, srcRGB);
                }
            }
        }
        g.setColor(color);
        g.drawString(text, 2, fm.getMaxAscent());
        g.dispose();
        return img;
    }

    public static Video getVideo(String key) {
        return ResourceManager.getVideo(key);
    }

    public static enum PathType {
        NAVAL,
        WAGON,
        HORSE,
        FOOT;


        private String getKey() {
            return StringUtils.getEnumKey(this);
        }

        public String getImageKey() {
            return "image.tileitem.path." + this.getKey();
        }

        public String getNextTurnImageKey() {
            return "image.tileitem.path." + this.getKey() + ".nextTurn";
        }

        public static PathType getPathType(Unit u) {
            return u == null ? FOOT : (u.isNaval() ? NAVAL : (u.isMounted() ? HORSE : (u.isPerson() ? FOOT : WAGON)));
        }
    }
}

