/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.images;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.sf.freecol.common.util.ImageUtils;

public final class BeachTileAnimationImageCreator {
    public static BufferedImage generateImage(BufferedImage beachImage, BufferedImage oceanImage, int oceanImageVariationNumber, BufferedImage oceanMaskImage, BufferedImage tileMask) {
        int width = oceanImage.getWidth();
        int height = oceanImage.getHeight();
        if (beachImage.getWidth() != width || beachImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (oceanMaskImage.getWidth() != width || oceanMaskImage.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        if (tileMask.getWidth() != width || tileMask.getHeight() != height) {
            throw new IllegalArgumentException("All images should be of the same size.");
        }
        BufferedImage maskedInputImage = ImageUtils.imageWithAlphaFromMask(oceanImage, oceanMaskImage);
        float extraOcean = 0.05f;
        float alpha = oceanImageVariationNumber <= 10 ? 0.05f * (float)oceanImageVariationNumber : 0.5f - 0.05f * (float)(oceanImageVariationNumber - 10);
        BufferedImage resultImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = resultImage.createGraphics();
        g2d.drawImage((Image)beachImage, 0, 0, null);
        g2d.drawImage((Image)maskedInputImage, 0, 0, null);
        g2d.setComposite(AlphaComposite.getInstance(3, alpha));
        g2d.drawImage((Image)maskedInputImage, 0, 0, null);
        g2d.dispose();
        return ImageUtils.imageWithAlphaFromMask(resultImage, tileMask);
    }
}

