/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.MapControls;
import net.sf.freecol.client.gui.panel.UnitButton;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Unit;

public final class CornerMapControls
extends MapControls {
    private static final Logger logger = Logger.getLogger(CornerMapControls.class.getName());
    private final ImageLibrary lib;
    private final JLabel compassRose;
    private final MiniMapPanel miniMapPanel;
    private Image miniMapSkin;

    public CornerMapControls(FreeColClient freeColClient) {
        super(freeColClient, true);
        this.lib = freeColClient.getGUI().getFixedImageLibrary();
        this.compassRose = this.lib.getCompassRose();
        this.compassRose.setFocusable(false);
        this.compassRose.setSize(this.compassRose.getPreferredSize());
        this.compassRose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Unit unit = CornerMapControls.this.getGUI().getActiveUnit();
                if (unit == null) {
                    return;
                }
                int x = e.getX() - CornerMapControls.this.compassRose.getWidth() / 2;
                int y = e.getY() - CornerMapControls.this.compassRose.getHeight() / 2;
                double theta = Math.atan2(y, x) + 1.5707963267948966 + 0.39269908169872414;
                if (theta < 0.0) {
                    theta += Math.PI * 2;
                }
                CornerMapControls.this.igc().moveUnit(unit, Direction.angleToDirection(theta));
            }
        });
        this.miniMapPanel = new MiniMapPanel();
        this.miniMapPanel.setFocusable(false);
        this.miniMapPanel.setLayout(null);
        this.miniMapPanel.add(this.miniMapToggleBorders);
        this.miniMapPanel.add(this.miniMapToggleFogOfWarButton);
        this.miniMapPanel.add(this.miniMapZoomInButton);
        this.miniMapPanel.add(this.miniMapZoomOutButton);
        this.miniMapPanel.add(this.miniMap);
        this.updateLayoutIfNeeded();
    }

    @Override
    public void updateLayoutIfNeeded() {
        int scaledGap;
        super.updateLayoutIfNeeded();
        BufferedImage newMinimapSkin = this.lib.getMiniMapSkin();
        if (this.miniMapSkin == newMinimapSkin) {
            return;
        }
        this.miniMapSkin = newMinimapSkin;
        int width = this.lib.scaleInt(220);
        int height = this.lib.scaleInt(128);
        this.miniMap.setSize(width, height);
        if (this.miniMapSkin != null) {
            width = this.miniMapSkin.getWidth(null);
            height = this.miniMapSkin.getHeight(null);
            this.miniMapPanel.setBorder(null);
            this.miniMapPanel.setSize(width, height);
            this.miniMapPanel.setOpaque(false);
        } else {
            this.miniMapPanel.setOpaque(true);
            this.miniMap.setBorder(new BevelBorder(0));
        }
        int x = scaledGap = this.lib.scaleInt(4);
        int y = height - this.miniMapZoomInButton.getHeight() - 2 * scaledGap;
        this.miniMapZoomInButton.setLocation(x, y);
        this.miniMapToggleFogOfWarButton.setLocation(x, y -= this.miniMapZoomInButton.getHeight() - 2 * scaledGap);
        this.miniMapToggleBorders.setLocation(x, y -= this.miniMapToggleFogOfWarButton.getHeight() - 2 * scaledGap);
        y = height - 2 * scaledGap - this.miniMap.getHeight();
        this.miniMap.setLocation(x += this.miniMapZoomInButton.getWidth() + scaledGap, y);
        y = height - this.miniMapZoomOutButton.getHeight() - 2 * scaledGap;
        this.miniMapZoomOutButton.setLocation(x += this.miniMap.getWidth() + scaledGap, y);
        this.miniMapPanel.revalidate();
        this.miniMapPanel.repaint();
    }

    @Override
    public List<Component> getComponentsToAdd(Dimension newSize) {
        boolean rose;
        ArrayList<Component> ret = new ArrayList<Component>();
        if (this.getGame() == null) {
            return ret;
        }
        int cw = newSize.width;
        int ch = newSize.height;
        if (!this.infoPanel.isShowing()) {
            this.infoPanel.setLocation(cw - this.infoPanel.getWidth(), ch - this.infoPanel.getHeight());
            this.infoPanel.refresh();
            ret.add(this.infoPanel);
        }
        if (!this.miniMapPanel.isShowing()) {
            this.miniMapPanel.setLocation(0, ch - this.miniMapPanel.getHeight());
            ret.add(this.miniMapPanel);
        }
        if ((rose = this.getClientOptions().getBoolean("model.option.displayCompassRose")) && !this.compassRose.isShowing()) {
            this.compassRose.setLocation(cw - this.compassRose.getWidth() - 20, 20);
            ret.add(this.compassRose);
        }
        if (!this.unitButtons.isEmpty() && !this.getFreeColClient().isMapEditor()) {
            int SPACE = 5;
            int width = -5;
            int height = 0;
            for (UnitButton ub : this.unitButtons) {
                if (ub.isShowing()) continue;
                height = Math.max(height, ub.getHeight());
                width += 5 + ub.getWidth();
            }
            int x = this.miniMapPanel.getWidth() + 1 + (this.infoPanel.getX() - this.miniMapPanel.getWidth() - width) / 2;
            int y = ch - height - 5;
            for (UnitButton ub : this.unitButtons) {
                if (ub.isShowing()) continue;
                ub.setLocation(x, y);
                x += 5 + ub.getWidth();
                ub.refreshAction();
                ret.add(ub);
            }
        }
        return ret;
    }

    @Override
    public List<Component> getComponentsPresent() {
        boolean rose;
        ArrayList<Component> ret = new ArrayList<Component>();
        if (this.infoPanel.isShowing()) {
            ret.add(this.infoPanel);
        }
        if (this.miniMapPanel.isShowing()) {
            ret.add(this.miniMapPanel);
        }
        if ((rose = this.getClientOptions().getBoolean("model.option.displayCompassRose")) && this.compassRose.isShowing()) {
            ret.add(this.compassRose);
        }
        for (UnitButton ub : this.unitButtons) {
            if (!ub.isShowing()) continue;
            ret.add(ub);
        }
        return ret;
    }

    public class MiniMapPanel
    extends JPanel {
        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (CornerMapControls.this.miniMapSkin != null) {
                graphics.drawImage(CornerMapControls.this.miniMapSkin, 0, 0, null);
            }
        }
    }
}

