/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.MarketLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.CargoPanel;
import net.sf.freecol.client.gui.panel.ColonyPanel;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.debug.DebugUtils;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;

public final class QuickActionMenu
extends JPopupMenu {
    private static final Logger logger = Logger.getLogger(QuickActionMenu.class.getName());
    private final FreeColClient freeColClient;
    private final GUI gui;
    private final FreeColPanel parentPanel;

    public QuickActionMenu(FreeColClient freeColClient, FreeColPanel freeColPanel) {
        this.freeColClient = freeColClient;
        this.gui = freeColClient.getGUI();
        this.parentPanel = freeColPanel;
    }

    public QuickActionMenu addMenuItems(JComponent comp) {
        if (comp instanceof UnitLabel) {
            this.createUnitMenu((UnitLabel)comp);
        } else if (comp instanceof GoodsLabel) {
            this.createGoodsMenu((GoodsLabel)comp);
        } else if (comp instanceof MarketLabel) {
            this.createMarketMenu((MarketLabel)comp);
        } else if (comp instanceof ColonyPanel.TilesPanel.ASingleTilePanel) {
            this.createTileMenu((ColonyPanel.TilesPanel.ASingleTilePanel)comp);
        } else if (comp.getParent() instanceof ColonyPanel.TilesPanel.ASingleTilePanel) {
            this.createTileMenu((ColonyPanel.TilesPanel.ASingleTilePanel)comp.getParent());
        }
        return this;
    }

    private static String getWorkLabel(WorkLocation wl) {
        return "WORK_" + StringUtils.upCase(StringUtils.lastPart(wl.getClass().toString(), "."));
    }

    private void promptForGoods(AbstractGoods ag) {
        int ret = this.gui.showSelectAmountDialog(ag.getType(), 100, ag.getAmount(), true);
        if (ret > 0) {
            ag.setAmount(ret);
        }
    }

    private void createUnitMenu(UnitLabel unitLabel) {
        Unit unit = unitLabel.getUnit();
        this.setLabel("Unit");
        ImageIcon unitIcon = new ImageIcon(this.gui.getFixedImageLibrary().getSmallUnitImage(unit));
        JMenuItem name = new JMenuItem(unit.getDescription(Unit.UnitLabelType.NATIONAL) + " (" + Messages.message("colopedia") + ")", unitIcon);
        name.setActionCommand(UnitLabel.UnitAction.COLOPEDIA.toString());
        name.addActionListener(unitLabel);
        this.add(name);
        this.addSeparator();
        if (this.addCarrierItems(unitLabel)) {
            this.addSeparator();
        }
        if (unit.isInEurope()) {
            if (this.addCommandItems(unitLabel)) {
                this.addSeparator();
            }
            if (this.addBoardItems(unitLabel, unit.getOwner().getEurope())) {
                this.addSeparator();
            }
        } else if (unit.hasTile()) {
            Colony colony = unit.getLocation().getTile().getColony();
            if (colony != null) {
                if (this.addTileItem(unitLabel)) {
                    this.addSeparator();
                }
                if (this.addWorkItems(unitLabel)) {
                    this.addSeparator();
                }
                if (this.addEducationItems(unitLabel)) {
                    this.addSeparator();
                }
                if (unit.isInColony() && colony.canReducePopulation()) {
                    JMenuItem menuItem = Utility.localizedMenuItem("quickActionMenu.leaveTown");
                    menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_TOWN.toString());
                    menuItem.addActionListener(unitLabel);
                    this.add(menuItem);
                    this.addBoardItems(unitLabel, colony.getTile());
                    this.addSeparator();
                } else {
                    if (this.addCommandItems(unitLabel)) {
                        this.addSeparator();
                    }
                    if (this.addBoardItems(unitLabel, colony.getTile())) {
                        this.addSeparator();
                    }
                }
            } else if (this.addCommandItems(unitLabel)) {
                this.addSeparator();
            }
        }
        if (unit.hasAbility("model.ability.canBeEquipped") && this.addRoleItems(unitLabel)) {
            this.addSeparator();
        }
    }

    private boolean addBoardItems(UnitLabel unitLabel, Location loc) {
        Unit tempUnit = unitLabel.getUnit();
        if (tempUnit.isCarrier()) {
            return false;
        }
        InGameController igc = this.freeColClient.getInGameController();
        boolean added = false;
        for (Unit unit : CollectionUtils.transform(loc.getUnitList(), u -> u.isCarrier() && u.canCarryUnits() && u.canAdd(tempUnit) && tempUnit.getLocation() != u)) {
            Object template = StringTemplate.template("quickActionMenu.board").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
            JMenuItem menuItem = Utility.localizedMenuItem(template);
            menuItem.addActionListener(ae -> igc.boardShip(tempUnit, unit));
            this.add(menuItem);
            added = true;
        }
        return added;
    }

    private boolean addLoadItems(Goods goods, Location loc) {
        InGameController igc = this.freeColClient.getInGameController();
        boolean added = false;
        for (Unit unit : CollectionUtils.transform(loc.getUnits(), u -> u.isCarrier() && u.canCarryGoods() && u.canAdd(goods))) {
            Object template = StringTemplate.template("quickActionMenu.loadOnTo").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
            JMenuItem menuItem = Utility.localizedMenuItem(template);
            menuItem.addActionListener(ae -> {
                if ((ae.getModifiers() & 1) != 0) {
                    this.promptForGoods(goods);
                }
                igc.loadCargo(goods, unit);
            });
            this.add(menuItem);
            added = true;
        }
        return added;
    }

    private boolean addCarrierItems(UnitLabel unitLabel) {
        JMenuItem menuItem;
        Unit unit = unitLabel.getUnit();
        if (!unit.isCarrier() || !unit.hasCargo()) {
            return false;
        }
        JMenuItem cargo = Utility.localizedMenuItem("cargoOnCarrier");
        this.add(cargo);
        for (Unit passenger : unit.getUnitList()) {
            menuItem = new JMenuItem("    " + passenger.getDescription(Unit.UnitLabelType.NATIONAL));
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            this.add(menuItem);
        }
        for (Goods goods : unit.getGoodsList()) {
            menuItem = new JMenuItem("    " + Messages.message(goods.getLabel(true)));
            menuItem.setFont(menuItem.getFont().deriveFont(2));
            this.add(menuItem);
        }
        return true;
    }

    private List<JMenuItem> descendingList(Map<JMenuItem, Integer> map) {
        Comparator<JMenuItem> comp = Comparator.comparingInt(k -> (Integer)map.get(k)).reversed().thenComparing(AbstractButton::getText);
        return CollectionUtils.sort(map.keySet(), comp);
    }

    private JMenuItem makeProductionItem(GoodsType type, WorkLocation wl, int amount, UnitLabel unitLabel, boolean claim) {
        Object t = StringTemplate.template(type.getId() + ".workAs").addAmount("%amount%", amount);
        if (claim) {
            ((StringTemplate)t).addStringTemplate("%claim%", wl.getClaimTemplate());
        } else if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            ((StringTemplate)t).addStringTemplate("%claim%", wl.getLocationLabel());
        } else {
            ((StringTemplate)t).addName("%claim%", "");
        }
        JMenuItem menuItem = Utility.localizedMenuItem(t, (Icon)new ImageIcon(this.gui.getFixedImageLibrary().getSmallGoodsTypeImage(type)));
        menuItem.setActionCommand(QuickActionMenu.getWorkLabel(wl) + "/" + wl.getId() + "/" + type.getId() + "/" + (claim ? "!" : ""));
        menuItem.addActionListener(unitLabel);
        return menuItem;
    }

    private boolean addWorkItems(UnitLabel unitLabel) {
        Unit unit = unitLabel.getUnit();
        if (unit.isCarrier()) {
            return false;
        }
        UnitType unitType = unit.getType();
        GoodsType expertGoods = unitType.getExpertProduction();
        Colony colony = unit.getLocation().getColony();
        Specification spec = this.freeColClient.getGame().getSpecification();
        WorkLocation current = unit.getWorkLocation();
        int bonusChange = current != null ? 0 : colony.governmentChange(colony.getUnitCount() + 1);
        int bonus = colony.getProductionBonus();
        HashMap<JMenuItem, Integer> items = new HashMap<JMenuItem, Integer>();
        HashMap<JMenuItem, Integer> extras = new HashMap<JMenuItem, Integer>();
        JMenuItem expertOwned = null;
        JMenuItem expertUnowned = null;
        for (GoodsType type : spec.getGoodsTypeList()) {
            JMenuItem ji;
            int bestOwnedProd = bonus + bonusChange;
            int bestUnownedProd = bonus + bonusChange;
            WorkLocation bestOwned = null;
            WorkLocation bestUnowned = null;
            for (WorkLocation wl : colony.getAllWorkLocationsList()) {
                int prod = 0;
                switch (wl.getNoAddReason(unit)) {
                    case NONE: {
                        prod = wl.getPotentialProduction(type, unitType);
                        if (bestOwnedProd >= prod) break;
                        bestOwnedProd = prod;
                        bestOwned = wl;
                        break;
                    }
                    case ALREADY_PRESENT: {
                        prod = wl.getPotentialProduction(type, unitType);
                        if (bestOwnedProd >= prod) break;
                        bestOwnedProd = prod;
                        bestOwned = unit.getWorkType() == type ? null : wl;
                        break;
                    }
                    case CLAIM_REQUIRED: {
                        prod = wl.getPotentialProduction(type, unitType);
                        if (bestUnownedProd >= prod) break;
                        bestUnownedProd = prod;
                        bestUnowned = wl;
                        break;
                    }
                }
            }
            if (bestOwned != null && bestOwnedProd > 0) {
                ji = this.makeProductionItem(type, bestOwned, bestOwnedProd, unitLabel, false);
                if (type == expertGoods) {
                    expertOwned = ji;
                } else {
                    items.put(ji, bestOwnedProd);
                }
            }
            if (bestUnowned == null || bestUnownedProd <= bestOwnedProd || bestUnownedProd <= 0) continue;
            ji = this.makeProductionItem(type, bestUnowned, bestUnownedProd, unitLabel, true);
            if (type == expertGoods) {
                expertUnowned = ji;
                continue;
            }
            extras.put(ji, bestUnownedProd);
        }
        JMenu container = Utility.localizedMenu("quickActionMenu.changeWork");
        List<JMenuItem> owned = this.descendingList(items);
        if (expertOwned != null) {
            owned.add(0, expertOwned);
        }
        for (JMenuItem j : owned) {
            container.add(j);
        }
        List<JMenuItem> unowned = this.descendingList(extras);
        if (expertUnowned != null) {
            unowned.add(0, expertUnowned);
        }
        if (!unowned.isEmpty()) {
            if (!owned.isEmpty()) {
                container.addSeparator();
            }
            for (JMenuItem j : unowned) {
                container.add(j);
            }
        }
        if (container.getItemCount() > 0) {
            this.add(container);
        }
        if (current != null && unit.getWorkType() != null) {
            JMenuItem ji = Utility.localizedMenuItem("showProductionModifiers");
            ji.addActionListener(ae -> this.gui.showWorkProductionPanel(unit));
            this.add(ji);
        }
        return !owned.isEmpty() || !unowned.isEmpty() || current != null;
    }

    private boolean addEducationItems(UnitLabel unitLabel) {
        UnitType expertType;
        UnitTypeChange uc;
        Unit unit = unitLabel.getUnit();
        Specification spec = unit.getSpecification();
        ImageLibrary lib = this.gui.getFixedImageLibrary();
        boolean separatorNeeded = false;
        if (spec.getBoolean("model.option.allowStudentSelection")) {
            for (Unit teacher : CollectionUtils.transform(unit.getColony().getTeachers(), u -> unit.canBeStudent((Unit)u) && u.isInColony())) {
                JMenuItem menuItem = null;
                ImageIcon teacherIcon = new ImageIcon(lib.getSmallerUnitImage(teacher));
                if (teacher.getStudent() != unit) {
                    menuItem = Utility.localizedMenuItem("quickActionMenu.assignToTeacher", (Icon)teacherIcon);
                    if (teacher.getStudent() != null) {
                        menuItem.setText(menuItem.getText() + " (" + teacher.getTurnsOfTraining() + "/" + teacher.getNeededTurnsOfTraining() + ")");
                    }
                    menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN + "/" + teacher.getId());
                    menuItem.addActionListener(unitLabel);
                } else {
                    menuItem = Utility.localizedMenuItem(StringTemplate.template("quickActionMenu.apprentice").addName("%unit%", Messages.getName(teacher.getType())), (Icon)teacherIcon);
                    menuItem.setText(menuItem.getText() + ": " + teacher.getTurnsOfTraining() + "/" + teacher.getNeededTurnsOfTraining());
                    menuItem.setEnabled(false);
                }
                this.add(menuItem);
                separatorNeeded = true;
            }
        }
        if (unit.getStudent() != null) {
            Unit student = unit.getStudent();
            JMenuItem menuItem = Utility.localizedMenuItem(StringTemplate.template("quickActionMenu.teaching").addName("%unit%", Messages.getName(student.getType())));
            menuItem.setText(menuItem.getText() + ": " + unit.getTurnsOfTraining() + "/" + unit.getNeededTurnsOfTraining());
            menuItem.setEnabled(false);
            this.add(menuItem);
            separatorNeeded = true;
        }
        int experience = unit.getExperience();
        GoodsType goods = unit.getExperienceType();
        if (experience > 0 && goods != null && (uc = unit.getUnitChange("model.unitChange.experience", expertType = spec.getExpertForProducing(goods))) != null) {
            int maxExperience = unit.getType().getMaximumExperience();
            float probability = (float)(uc.probability * experience) / (float)maxExperience;
            String jobName = Messages.message(goods.getWorkingAsKey());
            MigPanel experiencePanel = new MigPanel(new MigLayout("wrap 3"));
            experiencePanel.add((Component)new JLabel(new ImageIcon(lib.getSmallerUnitTypeImage(expertType))), "spany 2");
            experiencePanel.add(Utility.localizedLabel(StringTemplate.template("quickActionMenu.experience").addName("%job%", jobName)));
            experiencePanel.add((Component)Utility.localizedLabel(((StringTemplate)StringTemplate.label("/").addName(String.valueOf(experience))).addName(String.valueOf(maxExperience))), "align right");
            if (unit.isInColony() && unit.getWorkType() == goods) {
                experiencePanel.add(Utility.localizedLabel("quickActionMenu.upgrade"));
                experiencePanel.add((Component)new JLabel(ModifierFormat.format(probability) + "%"), "align right");
            }
            this.add(experiencePanel);
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    private boolean addCommandItems(UnitLabel unitLabel) {
        Unit tempUnit = unitLabel.getUnit();
        boolean isUnitAtSea = tempUnit.isAtSea();
        JMenuItem menuItem = Utility.localizedMenuItem("activateUnit");
        menuItem.addActionListener(ae -> {
            if (tempUnit.getState() != Unit.UnitState.ACTIVE) {
                this.freeColClient.getInGameController().changeState(tempUnit, Unit.UnitState.ACTIVE);
            }
            this.gui.changeView(tempUnit, false);
        });
        menuItem.setEnabled(!isUnitAtSea);
        this.add(menuItem);
        if (!(tempUnit.getLocation() instanceof Europe)) {
            menuItem = Utility.localizedMenuItem("fortify");
            menuItem.setActionCommand(UnitLabel.UnitAction.FORTIFY.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(tempUnit.getMovesLeft() > 0 && tempUnit.getState() != Unit.UnitState.FORTIFIED && tempUnit.getState() != Unit.UnitState.FORTIFYING);
            this.add(menuItem);
        }
        Unit.UnitState unitState = tempUnit.getState();
        menuItem = Utility.localizedMenuItem("sentry");
        menuItem.setActionCommand(UnitLabel.UnitAction.SENTRY.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled(unitState != Unit.UnitState.SENTRY && !isUnitAtSea);
        this.add(menuItem);
        boolean hasTradeRoute = tempUnit.getTradeRoute() != null;
        menuItem = Utility.localizedMenuItem("clearOrders");
        menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_ORDERS.toString());
        menuItem.addActionListener(unitLabel);
        menuItem.setEnabled((unitState != Unit.UnitState.ACTIVE || hasTradeRoute) && !isUnitAtSea);
        this.add(menuItem);
        if (tempUnit.isCarrier()) {
            menuItem = Utility.localizedMenuItem("assignTradeRoute");
            menuItem.setActionCommand(UnitLabel.UnitAction.ASSIGN_TRADE_ROUTE.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(!hasTradeRoute);
            this.add(menuItem);
        }
        if (tempUnit.canCarryTreasure() && tempUnit.canCashInTreasureTrain()) {
            menuItem = Utility.localizedMenuItem("cashInTreasureTrain");
            menuItem.addActionListener(ae -> this.freeColClient.getInGameController().checkCashInTreasureTrain(tempUnit));
            menuItem.setEnabled(true);
            this.add(menuItem);
        }
        if (tempUnit.getLocation() instanceof Unit) {
            menuItem = Utility.localizedMenuItem("leaveShip");
            menuItem.setActionCommand(UnitLabel.UnitAction.LEAVE_SHIP.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(true);
            this.add(menuItem);
        }
        if (tempUnit.isCarrier()) {
            menuItem = Utility.localizedMenuItem(tempUnit.getSettlement() != null ? "unload" : "dumpCargo");
            menuItem.setActionCommand(UnitLabel.UnitAction.UNLOAD.toString());
            menuItem.addActionListener(unitLabel);
            menuItem.setEnabled(!isUnitAtSea && tempUnit.hasCargo());
            this.add(menuItem);
        }
        if (FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) {
            DebugUtils.addGoodsAdditionEntry(this.freeColClient, tempUnit, this);
        }
        return true;
    }

    private JMenuItem createRoleItem(UnitLabel unitLabel, Role from, int fromCount, Role to, int toCount, int price) {
        String key = "model.role.change." + to.getSuffix();
        if (!Messages.containsKey(key)) {
            key = "model.role.change." + from.getSuffix() + "." + to.getSuffix();
        }
        Object text = Messages.message(key);
        if (price > 0) {
            text = (String)text + " (" + Messages.message(StringTemplate.template("goldAmount").addAmount("%amount%", price)) + ")";
        } else if (price < 0) {
            text = (String)text + " (" + Messages.message(StringTemplate.template("goldAmount").addAmount("%amount%", -price)) + " (" + Messages.message("income") + "))";
        }
        AbstractGoods change = null;
        List<AbstractGoods> need = Role.getGoodsDifference(from, fromCount, to, toCount);
        switch (need.size()) {
            case 0: {
                break;
            }
            case 1: {
                change = need.get(0);
                break;
            }
            default: {
                change = CollectionUtils.find(need, AbstractGoods::isPositive);
            }
        }
        ImageIcon icon = change == null ? null : new ImageIcon(this.gui.getFixedImageLibrary().getSmallGoodsTypeImage(change.getType()));
        JMenuItem item = new JMenuItem((String)text, icon);
        InGameController igc = this.freeColClient.getInGameController();
        item.addActionListener(ae -> {
            igc.equipUnitForRole(unitLabel.getUnit(), to, toCount);
            unitLabel.updateIcon();
            if (this.parentPanel instanceof ColonyPanel) {
                ((ColonyPanel)this.parentPanel).update();
            }
        });
        return item;
    }

    private boolean addRoleItems(UnitLabel unitLabel) {
        UnitLocation uloc;
        Unit unit = unitLabel.getUnit();
        Role role = unit.getRole();
        int roleCount = unit.getRoleCount();
        boolean separatorNeeded = false;
        UnitLocation unitLocation = uloc = unit.isInEurope() ? unit.getOwner().getEurope() : unit.getSettlement();
        if (uloc == null) {
            return false;
        }
        for (Role r : CollectionUtils.transform(unit.getAvailableRoles(null), r2 -> r2 != role)) {
            JMenuItem newItem;
            if (r.isDefaultRole()) {
                newItem = this.createRoleItem(unitLabel, role, roleCount, r, 0, 0);
            } else {
                newItem = null;
                for (int count = r.getMaximumCount(); count > 0; --count) {
                    List<AbstractGoods> req = unit.getGoodsDifference(r, count);
                    try {
                        int price = uloc.priceGoods(req);
                        if (!unit.getOwner().checkGold(price)) continue;
                        newItem = this.createRoleItem(unitLabel, role, roleCount, r, count, price);
                        break;
                    }
                    catch (FreeColException fce) {
                        // empty catch block
                    }
                }
            }
            if (newItem == null) continue;
            this.add(newItem);
            separatorNeeded = true;
        }
        UnitTypeChange uc = unit.getUnitChange("model.unitChange.clearSkill");
        if (uc != null) {
            if (separatorNeeded) {
                this.addSeparator();
            }
            JMenuItem menuItem = Utility.localizedMenuItem("quickActionMenu.clearSpeciality", (Icon)new ImageIcon(this.gui.getFixedImageLibrary().getTinyUnitTypeImage(uc.to)));
            menuItem.setActionCommand(UnitLabel.UnitAction.CLEAR_SPECIALITY.toString());
            menuItem.addActionListener(unitLabel);
            this.add(menuItem);
            if (unit.getLocation() instanceof Building && !((Building)unit.getLocation()).canAddType(uc.to)) {
                menuItem.setEnabled(false);
            }
            separatorNeeded = true;
        }
        return separatorNeeded;
    }

    private void createGoodsMenu(GoodsLabel goodsLabel) {
        int amount;
        InGameController igc = this.freeColClient.getInGameController();
        Player player = this.freeColClient.getMyPlayer();
        Goods goods = goodsLabel.getGoods();
        this.setLabel(Messages.message("cargo"));
        JMenuItem name = new JMenuItem(Messages.getName(goods) + " (" + Messages.message("colopedia") + ")", new ImageIcon(this.gui.getFixedImageLibrary().getSmallGoodsTypeImage(goods.getType())));
        name.addActionListener(ae -> this.gui.showColopediaPanel(goods.getType().getId()));
        this.add(name);
        int n = amount = player.getMarket() == null ? 0 : player.getMarket().getSalePrice(goods.getType(), goods.getAmount());
        if (amount > 0) {
            amount -= amount * player.getTax() / 100;
        }
        if (amount > 0) {
            JMenuItem price = Utility.localizedMenuItem(StringTemplate.template("quickActionMenu.profit").addAmount("%amount%", amount));
            this.add(price);
        }
        if (goods.getLocation() instanceof Colony) {
            Colony colony = (Colony)goods.getLocation();
            this.addLoadItems(goods, colony.getTile());
        } else if (goods.getLocation() instanceof Europe) {
            Europe europe = (Europe)goods.getLocation();
            this.addLoadItems(goods, europe);
            if (!player.canTrade(goods.getType())) {
                this.addPayArrears(goods.getType());
            }
        } else if (goods.getLocation() instanceof Unit) {
            Unit carrier = (Unit)goods.getLocation();
            if (carrier.getLocation().getColony() != null || carrier.isInEurope() && player.canTrade(goods.getType())) {
                JMenuItem unload = Utility.localizedMenuItem("unload");
                unload.addActionListener(ae -> {
                    if ((ae.getModifiers() & 1) != 0) {
                        this.promptForGoods(goods);
                    }
                    igc.unloadCargo(goods, false);
                });
                this.add(unload);
            } else {
                if (carrier.isInEurope() && !player.canTrade(goods.getType())) {
                    this.addPayArrears(goods.getType());
                }
                JMenuItem dump = Utility.localizedMenuItem("dumpCargo");
                dump.addActionListener(ae -> {
                    if ((ae.getModifiers() & 1) != 0) {
                        this.promptForGoods(goods);
                    }
                    igc.unloadCargo(goods, true);
                    if (this.parentPanel instanceof CargoPanel) {
                        ((CargoPanel)this.parentPanel).initialize();
                    }
                    this.parentPanel.revalidate();
                });
                this.add(dump);
            }
        }
    }

    private void addPayArrears(GoodsType goodsType) {
        InGameController igc = this.freeColClient.getInGameController();
        JMenuItem menuItem = Utility.localizedMenuItem("payArrears");
        menuItem.addActionListener(ae -> {
            igc.payArrears(goodsType);
            if (this.parentPanel instanceof CargoPanel) {
                CargoPanel cargoPanel = (CargoPanel)this.parentPanel;
                cargoPanel.initialize();
            }
            this.parentPanel.revalidate();
        });
        this.add(menuItem);
    }

    private void createMarketMenu(MarketLabel marketLabel) {
        AbstractGoods ag = marketLabel.getAbstractGoods();
        Player player = this.freeColClient.getMyPlayer();
        this.setLabel(Messages.message("cargo"));
        JMenuItem name = new JMenuItem(Messages.getName(ag) + " (" + Messages.message("colopedia") + ")", new ImageIcon(this.gui.getFixedImageLibrary().getSmallGoodsTypeImage(ag.getType())));
        name.addActionListener(ae -> this.gui.showColopediaPanel(ag.getType().getId()));
        this.add(name);
        Europe europe = this.freeColClient.getMyPlayer().getEurope();
        this.addMarketItems(ag, europe);
        if (!player.canTrade(ag.getType())) {
            this.addPayArrears(ag.getType());
        }
    }

    private boolean addMarketItems(AbstractGoods ag, Europe europe) {
        InGameController igc = this.freeColClient.getInGameController();
        Goods goods = new Goods(europe.getGame(), null, ag.getType(), ag.getAmount());
        boolean added = false;
        for (Unit unit : CollectionUtils.transform(europe.getUnits(), u -> u.isCarrier() && u.canCarryGoods() && u.canAdd(goods))) {
            Object template = StringTemplate.template("loadOnTo").addStringTemplate("%unit%", unit.getLabel(Unit.UnitLabelType.NATIONAL));
            JMenuItem menuItem = Utility.localizedMenuItem(template);
            menuItem.addActionListener(ae -> {
                if ((ae.getModifiers() & 1) != 0) {
                    this.promptForGoods(ag);
                }
                igc.buyGoods(ag.getType(), ag.getAmount(), unit);
            });
            this.add(menuItem);
            added = true;
        }
        return added;
    }

    private void createTileMenu(ColonyPanel.TilesPanel.ASingleTilePanel singleTilePanel) {
        if (singleTilePanel.getColonyTile() != null && singleTilePanel.getColonyTile().getColony() != null) {
            this.addTileItem(singleTilePanel.getColonyTile().getWorkTile());
        }
    }

    private boolean addTileItem(UnitLabel unitLabel) {
        Tile tile;
        Unit unit = unitLabel.getUnit();
        Tile tile2 = tile = unit == null ? null : unit.getWorkTile();
        if (tile != null) {
            this.addTileItem(tile);
            return true;
        }
        return false;
    }

    private void addTileItem(Tile tile) {
        if (tile != null) {
            String msg = Messages.message(tile.getLabel());
            JMenuItem menuItem = new JMenuItem(msg);
            menuItem.addActionListener(ae -> this.gui.showTilePanel(tile));
            this.add(menuItem);
        }
    }
}

