/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.util.CollectionUtils;

public final class StatisticsPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(StatisticsPanel.class.getName());
    private static final String[] memoryKeys = new String[]{"freeMemory", "totalMemory", "maxMemory"};

    public StatisticsPanel(FreeColClient freeColClient, Map<String, String> serverStatistics, Map<String, String> clientStatistics) {
        super(freeColClient, null, new BorderLayout());
        JPanel header = new JPanel();
        this.add((Component)header, "First");
        header.add((Component)Utility.localizedLabel("statistics"), Float.valueOf(0.5f));
        JPanel statsPanel = new JPanel(new GridLayout(1, 2));
        JScrollPane scrollPane = new JScrollPane(statsPanel, 20, 31);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        statsPanel.add(this.displayStatsMessage("client", clientStatistics));
        statsPanel.add(this.displayStatsMessage("server", serverStatistics));
        this.add((Component)this.okButton, "Last");
        this.setSize(this.getPreferredSize());
    }

    private JPanel displayStatsMessage(String title, Map<String, String> stats) {
        JPanel panel = new JPanel();
        panel.setBorder(Utility.localizedBorder(title));
        Box b = new Box(3);
        panel.add(b);
        HashMap<String, String> memory = new HashMap<String, String>(memoryKeys.length);
        HashMap<String, String> ai = new HashMap<String, String>();
        for (String k : memoryKeys) {
            memory.put(Messages.message("memoryManager." + k), stats.remove(k));
        }
        for (String k : new ArrayList<String>(stats.keySet())) {
            if (!k.startsWith("AI")) continue;
            ai.put(k, stats.remove(k));
        }
        b.add(this.createStatsTable("Memory", memory));
        b.add(this.createStatsTable("Game", stats));
        if (ai.isEmpty()) {
            b.add(new JLabel());
        } else {
            b.add(this.createStatsTable("AI", ai));
        }
        return panel;
    }

    private JPanel createStatsTable(String title, Map<String, String> data) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new JLabel(title), "First");
        StatisticsModel model = new StatisticsModel();
        model.setData(data);
        JTable table = new JTable(model);
        table.setAutoCreateColumnsFromModel(true);
        table.setAutoResizeMode(4);
        table.setAutoCreateRowSorter(true);
        JScrollPane scrollPane = new JScrollPane(table);
        table.addNotify();
        scrollPane.getViewport().setOpaque(false);
        scrollPane.getColumnHeader().setOpaque(false);
        panel.add((Component)scrollPane, "Center");
        panel.setPreferredSize(new Dimension(300, (data.size() + 2) * 17));
        return panel;
    }

    private static class StatisticsModel
    extends AbstractTableModel {
        private static final int NAME_COLUMN = 0;
        private static final int VALUE_COLUMN = 1;
        private final String[] columnNames = new String[]{"name", "value"};
        private Object[][] data = null;

        public void setData(Map<String, String> statsData) {
            this.data = new Object[2][statsData.size()];
            int i = 0;
            for (Map.Entry<String, String> e : CollectionUtils.mapEntriesByKey(statsData)) {
                this.data[0][i] = e.getKey();
                this.data[1][i] = e.getValue();
                ++i;
            }
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return String.class;
        }

        @Override
        public String getColumnName(int column) {
            return Messages.message(this.columnNames[column]);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data[0].length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (0 <= row && 0 <= column && row < this.getRowCount() && column < this.getColumnCount()) {
                switch (column) {
                    case 0: {
                        return this.data[0][row];
                    }
                    case 1: {
                        return this.data[1][row];
                    }
                }
            }
            return null;
        }
    }
}

