/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.function.edit.FieldEdit;
import tim.prune.function.edit.FieldEditList;
import tim.prune.gui.GuiGridLayout;

public class TruncatePointCoords
extends GenericFunction {
    private JDialog _dialog = null;
    private DataPoint _point = null;
    private JComboBox<String> _coordFormatDropdown = null;
    private JSpinner _numDigitsField = null;
    private JTextField _previewField = null;

    public TruncatePointCoords(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.truncatecoords";
    }

    @Override
    public void begin() {
        this._point = this._app.getTrackInfo().getCurrentPoint();
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.showPreview();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.truncatecoords.intro")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        String[] stringArray = new String[]{I18nManager.getText("units.degminsec"), I18nManager.getText("units.degmin"), I18nManager.getText("units.deg")};
        this._coordFormatDropdown = new JComboBox<String>(stringArray);
        this._coordFormatDropdown.setSelectedIndex(1);
        this._numDigitsField = new JSpinner(new SpinnerNumberModel(3, 0, 10, 1));
        this._numDigitsField.setValue(3);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    TruncatePointCoords.this._dialog.dispose();
                }
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TruncatePointCoords.this.showPreview();
            }
        };
        this._coordFormatDropdown.addKeyListener(keyAdapter);
        this._coordFormatDropdown.addActionListener(actionListener);
        this._numDigitsField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TruncatePointCoords.this.showPreview();
            }
        });
        JLabel jLabel = new JLabel(I18nManager.getText("details.coordformat"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._coordFormatDropdown);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.truncatecoords.numdigits"));
        jLabel2.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel2);
        guiGridLayout.add(this._numDigitsField);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.truncatecoords.preview"));
        jLabel3.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel3);
        this._previewField = new JTextField("", 26);
        this._previewField.setEditable(false);
        guiGridLayout.add(this._previewField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TruncatePointCoords.this.finish();
            }
        };
        jButton.addActionListener(actionListener2);
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TruncatePointCoords.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton2);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void showPreview() {
        String[] stringArray = this.getTruncatedCoords();
        this._previewField.setText(String.valueOf(stringArray[0]) + ", " + stringArray[1]);
    }

    private String[] getTruncatedCoords() {
        int[] nArray = new int[]{10, 11, 17};
        int n = nArray[this._coordFormatDropdown.getSelectedIndex()];
        int n2 = ((SpinnerNumberModel)this._numDigitsField.getModel()).getNumber().intValue();
        return new String[]{this._point.getLatitude().output(n, n2), this._point.getLongitude().output(n, n2)};
    }

    private void finish() {
        FieldEditList fieldEditList = new FieldEditList();
        FieldEditList fieldEditList2 = new FieldEditList();
        String[] stringArray = this.getTruncatedCoords();
        fieldEditList.addEdit(new FieldEdit(Field.LATITUDE, stringArray[0]));
        fieldEditList2.addEdit(new FieldEdit(Field.LATITUDE, this._point.getFieldValue(Field.LATITUDE)));
        fieldEditList.addEdit(new FieldEdit(Field.LONGITUDE, stringArray[1]));
        fieldEditList2.addEdit(new FieldEdit(Field.LONGITUDE, this._point.getFieldValue(Field.LONGITUDE)));
        this._app.completePointEdit(fieldEditList, fieldEditList2);
        this._dialog.dispose();
    }
}

