/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tim.prune.data.Field;
import tim.prune.load.TrackNameList;
import tim.prune.load.xml.GpxTag;
import tim.prune.load.xml.XmlHandler;

public class GpxHandler
extends XmlHandler {
    private boolean _insidePoint = false;
    private boolean _insideWaypoint = false;
    private boolean _startSegment = true;
    private boolean _isTrackPoint = false;
    private int _trackNum = -1;
    private GpxTag _fileTitle = new GpxTag();
    private GpxTag _pointName = new GpxTag();
    private GpxTag _trackName = new GpxTag();
    private String _latitude = null;
    private String _longitude = null;
    private GpxTag _elevation = new GpxTag();
    private GpxTag _time = new GpxTag();
    private GpxTag _type = new GpxTag();
    private GpxTag _description = new GpxTag();
    private GpxTag _link = new GpxTag();
    private GpxTag _comment = new GpxTag();
    private GpxTag _currentTag = null;
    private ArrayList<String[]> _pointList = new ArrayList();
    private ArrayList<String> _linkList = new ArrayList();
    private TrackNameList _trackNameList = new TrackNameList();

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string3.toLowerCase();
        if (string4.equals("wpt") || string4.equals("trkpt") || string4.equals("rtept")) {
            this._insidePoint = true;
            this._insideWaypoint = string4.equals("wpt");
            this._isTrackPoint = string4.equals("trkpt");
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string5 = attributes.getQName(n2).toLowerCase();
                if (string5.equals("lat")) {
                    this._latitude = attributes.getValue(n2);
                } else if (string5.equals("lon")) {
                    this._longitude = attributes.getValue(n2);
                }
                ++n2;
            }
            this._elevation.setValue(null);
            this._pointName.setValue(null);
            this._time.setValue(null);
            this._type.setValue(null);
            this._link.setValue(null);
            this._description.setValue(null);
            this._comment.setValue(null);
        } else if (string4.equals("ele")) {
            this._currentTag = this._elevation;
        } else if (string4.equals("name")) {
            this._currentTag = this._insidePoint ? this._pointName : (this._trackNum < 0 ? this._fileTitle : this._trackName);
        } else if (string4.equals("time")) {
            this._currentTag = this._time;
        } else if (string4.equals("type")) {
            this._currentTag = this._type;
        } else if (string4.equals("description") || string4.equals("desc")) {
            this._currentTag = this._description;
        } else if (string4.equals("cmt")) {
            this._currentTag = this._comment;
        } else if (string4.equals("link")) {
            this._link.setValue(attributes.getValue("href"));
        } else if (string4.equals("trkseg")) {
            this._startSegment = true;
        } else if (string4.equals("trk")) {
            ++this._trackNum;
            this._trackName.setValue(null);
        }
        super.startElement(string, string2, string3, attributes);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3.toLowerCase();
        if (string4.equals("wpt") || string4.equals("trkpt") || string4.equals("rtept")) {
            this.processPoint();
            this._insidePoint = false;
        } else {
            this._currentTag = null;
        }
        super.endElement(string, string2, string3);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._currentTag != null) {
            this._currentTag.setValue(GpxHandler.checkCharacters(this._currentTag.getValue(), string));
        }
        super.characters(cArray, n, n2);
    }

    private static String checkCharacters(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return String.valueOf(string) + string2;
    }

    private void processPoint() {
        String[] stringArray = new String[9];
        stringArray[0] = this._latitude;
        stringArray[1] = this._longitude;
        stringArray[2] = this._elevation.getValue();
        if (this._insideWaypoint) {
            stringArray[3] = this._pointName.getValue();
        }
        stringArray[4] = this._time.getValue();
        if (this._startSegment && !this._insideWaypoint) {
            stringArray[5] = "1";
            this._startSegment = false;
        }
        stringArray[6] = this._type.getValue();
        stringArray[7] = this._description.getValue();
        stringArray[8] = this._comment.getValue();
        this._pointList.add(stringArray);
        this._trackNameList.addPoint(this._trackNum, this._trackName.getValue(), this._isTrackPoint);
        this._linkList.add(this._link.getValue());
    }

    @Override
    public Field[] getFieldArray() {
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.WAYPT_NAME, Field.TIMESTAMP, Field.NEW_SEGMENT, Field.WAYPT_TYPE, Field.DESCRIPTION, Field.COMMENT};
        return fieldArray;
    }

    @Override
    public String[][] getDataArray() {
        int n = this._pointList.size();
        String[][] stringArray = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pointList.get(n2);
            ++n2;
        }
        return stringArray;
    }

    @Override
    public String[] getLinkArray() {
        int n = this._linkList.size();
        boolean bl = false;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._linkList.get(n2);
            if (stringArray[n2] != null) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            stringArray = null;
        }
        return stringArray;
    }

    @Override
    public TrackNameList getTrackNameList() {
        return this._trackNameList;
    }

    @Override
    public String getFileTitle() {
        return this._fileTitle.getValue();
    }
}

