/*
 * Decompiled with CFR 0.152.
 */
package org.grails.transaction;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class GrailsTransactionAttribute
extends RuleBasedTransactionAttribute {
    private static final Logger log = LoggerFactory.getLogger(GrailsTransactionAttribute.class);
    private static final long serialVersionUID = 1L;
    private boolean inheritRollbackOnly = true;

    public GrailsTransactionAttribute() {
    }

    public GrailsTransactionAttribute(int propagationBehavior, List<RollbackRuleAttribute> rollbackRules) {
        super(propagationBehavior, rollbackRules);
    }

    public GrailsTransactionAttribute(TransactionAttribute other) {
        this.setPropagationBehavior(other.getPropagationBehavior());
        this.setIsolationLevel(other.getIsolationLevel());
        this.setTimeout(other.getTimeout());
        this.setReadOnly(other.isReadOnly());
        this.setName(other.getName());
    }

    public GrailsTransactionAttribute(TransactionDefinition other) {
        this.setPropagationBehavior(other.getPropagationBehavior());
        this.setIsolationLevel(other.getIsolationLevel());
        this.setTimeout(other.getTimeout());
        this.setReadOnly(other.isReadOnly());
        this.setName(other.getName());
    }

    public GrailsTransactionAttribute(GrailsTransactionAttribute other) {
        this((RuleBasedTransactionAttribute)other);
    }

    public GrailsTransactionAttribute(RuleBasedTransactionAttribute other) {
        super(other);
        if (other instanceof GrailsTransactionAttribute) {
            this.inheritRollbackOnly = ((GrailsTransactionAttribute)other).inheritRollbackOnly;
        }
    }

    public boolean rollbackOn(Throwable ex) {
        if (log.isTraceEnabled()) {
            log.trace("Applying rules to determine whether transaction should rollback on $ex");
        }
        RollbackRuleAttribute winner = null;
        int deepest = Integer.MAX_VALUE;
        List rollbackRules = this.getRollbackRules();
        if (rollbackRules != null) {
            for (RollbackRuleAttribute rule : rollbackRules) {
                int depth = rule.getDepth(ex);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                winner = rule;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Winning rollback rule is: $winner");
        }
        if (winner == null) {
            log.trace("No relevant rollback rule found: applying default rules");
            return true;
        }
        return !(winner instanceof NoRollbackRuleAttribute);
    }

    public boolean isInheritRollbackOnly() {
        return this.inheritRollbackOnly;
    }

    public void setInheritRollbackOnly(boolean inheritRollbackOnly) {
        this.inheritRollbackOnly = inheritRollbackOnly;
    }
}

