/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.annotation.context;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.DefaultScope;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class BeanAnnotationMapper
extends AbstractSpringAnnotationMapper {
    public String getName() {
        return "org.springframework.context.annotation.Bean";
    }

    @Override
    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList newAnnotations = new ArrayList(3);
        AnnotationValueBuilder beanAnn = AnnotationValue.builder(Bean.class);
        Optional destroyMethod = annotation.get((CharSequence)"destroyMethod", String.class);
        destroyMethod.ifPresent(s -> beanAnn.member("preDestroy", s));
        newAnnotations.add(beanAnn.build());
        newAnnotations.add(AnnotationValue.builder(DefaultScope.class).value(Singleton.class).build());
        String beanName = annotation.getValue(String.class).orElse(annotation.get((CharSequence)"name", String.class).orElse(null));
        if (StringUtils.isNotEmpty((CharSequence)beanName)) {
            newAnnotations.add(AnnotationValue.builder((String)"javax.inject.Named").value(beanName).build());
        }
        return newAnnotations;
    }
}

