/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TSFBuilder;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Type;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.jackson.JacksonConfiguration;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;

@Factory
@BootstrapContextCompatible
public class ObjectMapperFactory {
    public static final String MICRONAUT_MODULE = "micronaut";
    @Inject
    protected Module[] jacksonModules = new Module[0];
    @Inject
    protected JsonSerializer[] serializers = new JsonSerializer[0];
    @Inject
    protected JsonDeserializer[] deserializers = new JsonDeserializer[0];
    @Inject
    protected BeanSerializerModifier[] beanSerializerModifiers = new BeanSerializerModifier[0];
    @Inject
    protected BeanDeserializerModifier[] beanDeserializerModifiers = new BeanDeserializerModifier[0];
    @Inject
    protected KeyDeserializer[] keyDeserializers = new KeyDeserializer[0];

    @Requires(beans={JacksonConfiguration.class})
    @Singleton
    @BootstrapContextCompatible
    public JsonFactory jsonFactory(JacksonConfiguration jacksonConfiguration) {
        TSFBuilder jsonFactoryBuilder = JsonFactory.builder();
        jacksonConfiguration.getFactorySettings().forEach((arg_0, arg_1) -> ((TSFBuilder)jsonFactoryBuilder).configure(arg_0, arg_1));
        return jsonFactoryBuilder.build();
    }

    @Singleton
    @Primary
    @Named(value="json")
    @BootstrapContextCompatible
    public ObjectMapper objectMapper(@Nullable JacksonConfiguration jacksonConfiguration, @Nullable JsonFactory jsonFactory) {
        Optional targetType;
        Class[] value;
        Type annotation;
        Class<?> type;
        boolean hasConfiguration;
        ObjectMapper objectMapper = jsonFactory != null ? new ObjectMapper(jsonFactory) : new ObjectMapper();
        boolean bl = hasConfiguration = jacksonConfiguration != null;
        if (!hasConfiguration || jacksonConfiguration.isModuleScan()) {
            objectMapper.findAndRegisterModules();
        }
        objectMapper.registerModules(this.jacksonModules);
        SimpleModule module = new SimpleModule(MICRONAUT_MODULE);
        for (JsonSerializer jsonSerializer : this.serializers) {
            type = jsonSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class aClass : value = annotation.value()) {
                    module.addSerializer(aClass, jsonSerializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            if (targetType.isPresent()) {
                module.addSerializer((Class)targetType.get(), jsonSerializer);
                continue;
            }
            module.addSerializer(jsonSerializer);
        }
        for (JsonSerializer jsonSerializer : this.deserializers) {
            type = jsonSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation != null) {
                for (Class aClass : value = annotation.value()) {
                    module.addDeserializer(aClass, (JsonDeserializer)jsonSerializer);
                }
                continue;
            }
            targetType = GenericTypeUtils.resolveSuperGenericTypeArgument(type);
            targetType.ifPresent(arg_0 -> ObjectMapperFactory.lambda$objectMapper$0(module, (JsonDeserializer)jsonSerializer, arg_0));
        }
        if (hasConfiguration && jacksonConfiguration.isTrimStrings()) {
            module.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer(){

                public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                    String value = super.deserialize(p, ctxt);
                    return StringUtils.trimToNull((String)value);
                }
            });
        }
        for (JsonSerializer jsonSerializer : this.keyDeserializers) {
            type = jsonSerializer.getClass();
            annotation = type.getAnnotation(Type.class);
            if (annotation == null) continue;
            for (Class clazz : value = annotation.value()) {
                module.addKeyDeserializer(clazz, (KeyDeserializer)jsonSerializer);
            }
        }
        objectMapper.registerModule((Module)module);
        for (JsonSerializer jsonSerializer : this.beanSerializerModifiers) {
            objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier((BeanSerializerModifier)jsonSerializer));
        }
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS, true);
        if (hasConfiguration) {
            PropertyNamingStrategy propertyNamingStrategy;
            TimeZone timeZone;
            Locale locale;
            String dateFormat;
            JsonInclude.Include include;
            ObjectMapper.DefaultTyping defaultTyping = jacksonConfiguration.getDefaultTyping();
            if (defaultTyping != null) {
                objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), defaultTyping);
            }
            if ((include = jacksonConfiguration.getSerializationInclusion()) != null) {
                objectMapper.setSerializationInclusion(include);
            }
            if ((dateFormat = jacksonConfiguration.getDateFormat()) != null) {
                objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(dateFormat));
            }
            if ((locale = jacksonConfiguration.getLocale()) != null) {
                objectMapper.setLocale(locale);
            }
            if ((timeZone = jacksonConfiguration.getTimeZone()) != null) {
                objectMapper.setTimeZone(timeZone);
            }
            if ((propertyNamingStrategy = jacksonConfiguration.getPropertyNamingStrategy()) != null) {
                objectMapper.setPropertyNamingStrategy(propertyNamingStrategy);
            }
            jacksonConfiguration.getSerializationSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            jacksonConfiguration.getDeserializationSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            jacksonConfiguration.getMapperSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            jacksonConfiguration.getParserSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
            jacksonConfiguration.getGeneratorSettings().forEach((arg_0, arg_1) -> ((ObjectMapper)objectMapper).configure(arg_0, arg_1));
        }
        return objectMapper;
    }

    private static /* synthetic */ void lambda$objectMapper$0(SimpleModule module, JsonDeserializer deserializer, Class aClass) {
        module.addDeserializer(aClass, deserializer);
    }
}

