/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.testng.TestNGException;
import org.testng.collections.Lists;

public class PoolService<FutureType> {
    private final ExecutorCompletionService<FutureType> m_completionService;
    private final ExecutorService m_executor;

    public PoolService(int threadPoolSize) {
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger threadNumber = new AtomicInteger(0);

            @Override
            public Thread newThread(@Nonnull Runnable r) {
                return new Thread(r, "TestNG-PoolService-" + this.threadNumber.getAndIncrement());
            }
        };
        this.m_executor = Executors.newFixedThreadPool(threadPoolSize, threadFactory);
        this.m_completionService = new ExecutorCompletionService(this.m_executor);
    }

    public List<FutureType> submitTasksAndWait(List<? extends Callable<FutureType>> tasks) {
        List<Future> takes = Lists.newArrayList(tasks.size());
        for (Callable<FutureType> callable : tasks) {
            takes.add(this.m_completionService.submit(callable));
        }
        List result = Lists.newArrayList(takes.size());
        for (Future take : takes) {
            try {
                result.add(take.get());
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TestNGException(e);
            }
        }
        this.m_executor.shutdown();
        return result;
    }
}

