/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.Maps;

class ScriptMethodSelector {
    private final ScriptEngine engine;
    private final String expression;

    ScriptMethodSelector(ScriptEngine engine, String expression) {
        this.engine = engine;
        this.expression = expression.trim();
    }

    boolean includeMethodFromExpression(ITestNGMethod tm) {
        Map<String, String> groups = Maps.newHashMap();
        for (String group : tm.getGroups()) {
            groups.put(group, group);
        }
        try {
            ScriptMethodSelector.setContext(this.engine, groups, tm);
            Object evalResult = this.engine.eval(this.expression);
            if (evalResult == null) {
                String msg = String.format("The " + this.engine.getFactory().getLanguageName() + " expression [%s] evaluated to null.", this.expression);
                throw new TestNGException(msg);
            }
            int n = ((Boolean)evalResult).booleanValue() ? 1 : 0;
            return n != 0;
        }
        catch (ScriptException e) {
            throw new TestNGException(e);
        }
        finally {
            ScriptMethodSelector.resetContext(this.engine);
        }
    }

    private static void setContext(ScriptEngine engine, Map<String, String> groups, ITestNGMethod tm) {
        ScriptContext context = engine.getContext();
        Method method = tm.getConstructorOrMethod().getMethod();
        context.setAttribute("method", method, 100);
        context.setAttribute("groups", groups, 100);
        context.setAttribute("testngMethod", tm, 100);
    }

    private static void resetContext(ScriptEngine engine) {
        ScriptContext context = engine.getContext();
        context.removeAttribute("method", 100);
        context.removeAttribute("groups", 100);
        context.removeAttribute("testngMethod", 100);
    }
}

