/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.common.impl.lc;

import org.apache.groovy.contracts.annotations.meta.Postcondition;
import org.apache.groovy.contracts.common.base.BaseLifecycle;
import org.apache.groovy.contracts.common.spi.ProcessingContextInformation;
import org.apache.groovy.contracts.generation.CandidateChecks;
import org.apache.groovy.contracts.generation.PostconditionGenerator;
import org.apache.groovy.contracts.util.AnnotationUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;

public class PostconditionLifecycle
extends BaseLifecycle {
    @Override
    public void beforeProcessingClassNode(ProcessingContextInformation processingContextInformation, ClassNode classNode) {
        PostconditionGenerator postconditionGenerator = new PostconditionGenerator(processingContextInformation.readerSource());
        postconditionGenerator.addOldVariablesMethod(classNode);
    }

    @Override
    public void afterProcessingConstructorNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode constructorNode) {
        this.generatePostcondition(processingContextInformation, classNode, constructorNode);
    }

    @Override
    public void afterProcessingMethodNode(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        this.generatePostcondition(processingContextInformation, classNode, methodNode);
    }

    private void generatePostcondition(ProcessingContextInformation processingContextInformation, ClassNode classNode, MethodNode methodNode) {
        if (!processingContextInformation.isPostconditionsEnabled()) {
            return;
        }
        if (!CandidateChecks.isPostconditionCandidate(classNode, methodNode)) {
            return;
        }
        PostconditionGenerator postconditionGenerator = new PostconditionGenerator(processingContextInformation.readerSource());
        if (!(methodNode instanceof ConstructorNode) && AnnotationUtils.getAnnotationNodeInHierarchyWithMetaAnnotation(classNode, methodNode, ClassHelper.makeWithoutCaching(Postcondition.class)).size() > 0) {
            postconditionGenerator.generateDefaultPostconditionStatement(classNode, methodNode);
        } else {
            postconditionGenerator.generateDefaultPostconditionStatement(classNode, methodNode);
        }
    }
}

